"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const PDFDict_1 = (0, tslib_1.__importDefault)(require("../objects/PDFDict"));
const PDFName_1 = (0, tslib_1.__importDefault)(require("../objects/PDFName"));
const acroform_1 = require("../acroform");
const ViewerPreferences_1 = (0, tslib_1.__importDefault)(require("../interactive/ViewerPreferences"));
class PDFCatalog extends PDFDict_1.default {
    Pages() {
        return this.lookup(PDFName_1.default.of('Pages'), PDFDict_1.default);
    }
    AcroForm() {
        return this.lookupMaybe(PDFName_1.default.of('AcroForm'), PDFDict_1.default);
    }
    getAcroForm() {
        const dict = this.AcroForm();
        if (!dict)
            return undefined;
        return acroform_1.PDFAcroForm.fromDict(dict);
    }
    getOrCreateAcroForm() {
        let acroForm = this.getAcroForm();
        if (!acroForm) {
            acroForm = acroform_1.PDFAcroForm.create(this.context);
            const acroFormRef = this.context.register(acroForm.dict);
            this.set(PDFName_1.default.of('AcroForm'), acroFormRef);
        }
        return acroForm;
    }
    ViewerPreferences() {
        return this.lookupMaybe(PDFName_1.default.of('ViewerPreferences'), PDFDict_1.default);
    }
    getViewerPreferences() {
        const dict = this.ViewerPreferences();
        if (!dict)
            return undefined;
        return ViewerPreferences_1.default.fromDict(dict);
    }
    getOrCreateViewerPreferences() {
        let viewerPrefs = this.getViewerPreferences();
        if (!viewerPrefs) {
            viewerPrefs = ViewerPreferences_1.default.create(this.context);
            const viewerPrefsRef = this.context.register(viewerPrefs.dict);
            this.set(PDFName_1.default.of('ViewerPreferences'), viewerPrefsRef);
        }
        return viewerPrefs;
    }
    /**
     * Inserts the given ref as a leaf node of this catalog's page tree at the
     * specified index (zero-based). Also increments the `Count` of each node in
     * the page tree hierarchy to accomodate the new page.
     *
     * Returns the ref of the PDFPageTree node into which `leafRef` was inserted.
     */
    insertLeafNode(leafRef, index) {
        const pagesRef = this.get(PDFName_1.default.of('Pages'));
        const maybeParentRef = this.Pages().insertLeafNode(leafRef, index);
        return maybeParentRef || pagesRef;
    }
    removeLeafNode(index) {
        this.Pages().removeLeafNode(index);
    }
}
PDFCatalog.withContextAndPages = (context, pages) => {
    const dict = new Map();
    dict.set(PDFName_1.default.of('Type'), PDFName_1.default.of('Catalog'));
    dict.set(PDFName_1.default.of('Pages'), pages);
    return new PDFCatalog(dict, context);
};
PDFCatalog.fromMapWithContext = (map, context) => new PDFCatalog(map, context);
exports.default = PDFCatalog;
//# sourceMappingURL=PDFCatalog.js.map