"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const maths_1 = require("../maths");
const Circle_1 = (0, tslib_1.__importDefault)(require("./Circle"));
const GraphElement_1 = (0, tslib_1.__importDefault)(require("./GraphElement"));
const Point_1 = (0, tslib_1.__importDefault)(require("./Point"));
class Arc extends GraphElement_1.default {
    constructor(O = new Point_1.default(), A = new Point_1.default(), B = new Point_1.default(), lastSweep = 0) {
        super();
        this.O = O;
        this.A = A;
        this.B = B;
        this.lastSweep = lastSweep;
    }
    center() {
        return this.O;
    }
    origin() {
        return this.A;
    }
    destination() {
        return this.getCircle().orthoProjection(this.B);
    }
    sweep() {
        this.lastSweep = (0, maths_1.angleABC)(this.origin(), this.center(), this.destination(), this.lastSweep);
        return this.lastSweep;
    }
    ray() {
        return (0, maths_1.distance)(this.center(), this.origin());
    }
    isEqual(element) {
        if (!(element instanceof Arc))
            return false;
        const dest = this.destination();
        const o = this.origin();
        const eDest = element.destination();
        const eO = element.origin();
        return (this.getCircle().isEqual(element.getCircle()) &&
            ((dest.isEqual(eDest) && o.isEqual(eO)) ||
                (dest.isEqual(eO) && o.isEqual(eDest))));
    }
    getCircle() {
        const circle = new Circle_1.default(this.center(), this.ray());
        return circle;
    }
    originVect() {
        return (0, maths_1.vector)(this.center(), this.origin());
    }
    middle() {
        const halfSweep = this.sweep() / 2;
        const mid = this.center().plus((0, maths_1.rotate)((0, maths_1.vector)(this.center(), this.origin()), halfSweep));
        return mid;
    }
    includes(P) {
        // As angles are returned between -π and π, we need the middle of the arc
        return (this.getCircle().includes(P) &&
            Math.abs((0, maths_1.angleABC)(this.middle(), this.center(), P)) <=
                Math.abs(this.sweep() / 2));
    }
    orthoProjection(P) {
        const H = this.getCircle().orthoProjection(P);
        if (this.includes(H))
            return H;
        else {
            const origin = this.origin().toCoords();
            const destination = this.destination().toCoords();
            // Returns the closest between origin and destination
            const coords = (0, maths_1.distanceCoords)(H.toCoords(), origin) <
                (0, maths_1.distanceCoords)(H.toCoords(), destination)
                ? origin
                : destination;
            return new Point_1.default(coords);
        }
    }
}
exports.default = Arc;
//# sourceMappingURL=Arc.js.map