"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const intersections_1 = require("../intersections");
const maths_1 = require("../maths");
const GraphElement_1 = (0, tslib_1.__importDefault)(require("./GraphElement"));
const Point_1 = (0, tslib_1.__importDefault)(require("./Point"));
class Line extends GraphElement_1.default {
    constructor(A = new Point_1.default(), B = new Point_1.default()) {
        super();
        this.A = A;
        this.B = B;
    }
    origin() {
        return this.A;
    }
    dirVect() {
        return (0, maths_1.vector)(this.A, this.B);
    }
    /** Line equation */
    y(x) {
        const a = this.a();
        const b = this.b();
        return a * x + b;
    }
    /** The slope */
    a() {
        const dirVect = this.dirVect();
        return dirVect.y / dirVect.x;
    }
    /** Origin y coordinate */
    b() {
        const O = this.origin().toCoords();
        const a = this.a();
        return O.y - a * O.x;
    }
    isEqual(element) {
        const vect = this.dirVect();
        return (element instanceof Line &&
            (0, maths_1.isColinear)(vect, element.dirVect()) &&
            ((0, maths_1.isEqual)(vect.x, 0)
                ? // We need to take care of the case of the vertical line
                    (0, maths_1.isEqual)(this.origin().toCoords().x, element.origin().toCoords().x)
                : (0, maths_1.isEqual)(this.b(), element.b())));
    }
    /** Reversed line equation */
    x(y) {
        const dirVect = this.dirVect();
        return ((y - this.b()) * dirVect.x) / dirVect.y;
    }
    includes(P) {
        const { x, y } = P.toCoords();
        const vect = this.dirVect();
        return (0, maths_1.isEqual)(vect.x, 0)
            ? (0, maths_1.isEqual)(this.origin().toCoords().x, x)
            : (0, maths_1.isEqual)(this.y(x), y);
    }
    /** This is used to standarsize type Segment | HalfLine | Line */
    getLine() {
        const line = new Line(this.origin(), this.B);
        return line;
    }
    orthoProjection(P) {
        const vectOrtho = (0, maths_1.orthogonal)(this.dirVect());
        const A = new Point_1.default(P.toCoords());
        const ortho = new Line(A, A.plus(vectOrtho));
        const H = (0, intersections_1.intersectionLine)(this, ortho)[0];
        return new Point_1.default(H);
    }
}
exports.default = Line;
//# sourceMappingURL=Line.js.map