import PDFDict from '../objects/PDFDict.js';
import PDFName from '../objects/PDFName.js';
import PDFAcroField from './PDFAcroField.js';
import PDFWidgetAnnotation from '../annotation/PDFWidgetAnnotation.js';
import { IndexOutOfBoundsError } from '../errors.js';
class PDFAcroTerminal extends PDFAcroField {
    FT() {
        const nameOrRef = this.getInheritableAttribute(PDFName.of('FT'));
        return this.dict.context.lookup(nameOrRef, PDFName);
    }
    getWidgets() {
        const kidDicts = this.Kids();
        // This field is itself a widget
        if (!kidDicts)
            return [PDFWidgetAnnotation.fromDict(this.dict)];
        // This field's kids are its widgets
        const widgets = new Array(kidDicts.size());
        for (let idx = 0, len = kidDicts.size(); idx < len; idx++) {
            const dict = kidDicts.lookup(idx, PDFDict);
            widgets[idx] = PDFWidgetAnnotation.fromDict(dict);
        }
        return widgets;
    }
    addWidget(ref) {
        const { Kids } = this.normalizedEntries();
        Kids.push(ref);
    }
    removeWidget(idx) {
        const kidDicts = this.Kids();
        if (!kidDicts) {
            // This field is itself a widget
            if (idx !== 0)
                throw new IndexOutOfBoundsError(idx, 0, 0);
            this.setKids([]);
        }
        else {
            // This field's kids are its widgets
            if (idx < 0 || idx > kidDicts.size()) {
                throw new IndexOutOfBoundsError(idx, 0, kidDicts.size());
            }
            kidDicts.remove(idx);
        }
    }
    normalizedEntries() {
        let Kids = this.Kids();
        // If this field is itself a widget (because it was only rendered once in
        // the document, so the field and widget properties were merged) then we
        // add itself to the `Kids` array. The alternative would be to try
        // splitting apart the widget properties and creating a separate object
        // for them.
        if (!Kids) {
            Kids = this.dict.context.obj([this.ref]);
            this.dict.set(PDFName.of('Kids'), Kids);
        }
        return { Kids };
    }
}
PDFAcroTerminal.fromDict = (dict, ref) => new PDFAcroTerminal(dict, ref);
export default PDFAcroTerminal;
//# sourceMappingURL=PDFAcroTerminal.js.map