import PDFHexString from '../objects/PDFHexString.js';
class JavaScriptEmbedder {
    constructor(script, scriptName) {
        this.script = script;
        this.scriptName = scriptName;
    }
    static for(script, scriptName) {
        return new JavaScriptEmbedder(script, scriptName);
    }
    async embedIntoContext(context, ref) {
        const jsActionDict = context.obj({
            Type: 'Action',
            S: 'JavaScript',
            JS: PDFHexString.fromText(this.script),
        });
        if (ref) {
            context.assign(ref, jsActionDict);
            return ref;
        }
        else {
            return context.register(jsActionDict);
        }
    }
}
export default JavaScriptEmbedder;
//# sourceMappingURL=JavaScriptEmbedder.js.map