import PDFObject from '../objects/PDFObject.js';
import CharCodes from '../syntax/CharCodes.js';
import { copyStringIntoBuffer } from '../../utils/index.js';
class PDFOperator {
    constructor(name, args) {
        this.name = name;
        this.args = args || [];
    }
    clone(context) {
        const args = new Array(this.args.length);
        for (let idx = 0, len = args.length; idx < len; idx++) {
            const arg = this.args[idx];
            args[idx] = arg instanceof PDFObject ? arg.clone(context) : arg;
        }
        return PDFOperator.of(this.name, args);
    }
    toString() {
        let value = '';
        for (let idx = 0, len = this.args.length; idx < len; idx++) {
            value += String(this.args[idx]) + ' ';
        }
        value += this.name;
        return value;
    }
    sizeInBytes() {
        let size = 0;
        for (let idx = 0, len = this.args.length; idx < len; idx++) {
            const arg = this.args[idx];
            size += (arg instanceof PDFObject ? arg.sizeInBytes() : arg.length) + 1;
        }
        size += this.name.length;
        return size;
    }
    copyBytesInto(buffer, offset) {
        const initialOffset = offset;
        for (let idx = 0, len = this.args.length; idx < len; idx++) {
            const arg = this.args[idx];
            if (arg instanceof PDFObject) {
                offset += arg.copyBytesInto(buffer, offset);
            }
            else {
                offset += copyStringIntoBuffer(arg, buffer, offset);
            }
            buffer[offset++] = CharCodes.Space;
        }
        offset += copyStringIntoBuffer(this.name, buffer, offset);
        return offset - initialOffset;
    }
}
PDFOperator.of = (name, args) => new PDFOperator(name, args);
export default PDFOperator;
//# sourceMappingURL=PDFOperator.js.map