import { Schema } from '@pdfme/common';
interface ShapeSchema extends Schema {
    type: 'ellipse' | 'rectangle';
    borderWidth: number;
    borderColor: string;
    color: string;
    radius?: number;
}
export declare const rectangle: {
    propPanel: {
        defaultSchema: {
            type: "ellipse" | "rectangle";
            borderWidth: number;
            borderColor: string;
            color: string;
            radius?: number;
            name: string;
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
            content?: string | undefined;
            rotate?: number | undefined;
            opacity?: number | undefined;
            readOnly?: boolean | undefined;
            required?: boolean | undefined;
            __bodyRange?: {
                start: number;
                end?: number | undefined;
            } | undefined;
            __isSplit?: boolean | undefined;
        };
        schema: ((propPanelProps: Omit<{
            rootElement: HTMLDivElement;
            activeSchema: import("@pdfme/common").SchemaForUI;
            activeElements: HTMLElement[];
            changeSchemas: import("@pdfme/common").ChangeSchemas;
            schemas: import("@pdfme/common").SchemaForUI[];
            options: import("@pdfme/common").UIOptions;
            theme: import("antd").GlobalToken;
            i18n: (key: string) => string;
        }, "rootElement">) => Record<string, import("@pdfme/common").PropPanelSchema>) | Record<string, import("@pdfme/common").PropPanelSchema>;
        widgets?: Record<string, (props: import("@pdfme/common").PropPanelWidgetProps) => void>;
    };
    icon: string;
    pdf: (arg: import("@pdfme/common").PDFRenderProps<ShapeSchema & {
        name: string;
        type: string;
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
        content?: string | undefined;
        rotate?: number | undefined;
        opacity?: number | undefined;
        readOnly?: boolean | undefined;
        required?: boolean | undefined;
        __bodyRange?: {
            start: number;
            end?: number | undefined;
        } | undefined;
        __isSplit?: boolean | undefined;
    } & {
        [k: string]: unknown;
    }>) => Promise<void> | void;
    ui: (arg: import("@pdfme/common").UIRenderProps<ShapeSchema & {
        name: string;
        type: string;
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
        content?: string | undefined;
        rotate?: number | undefined;
        opacity?: number | undefined;
        readOnly?: boolean | undefined;
        required?: boolean | undefined;
        __bodyRange?: {
            start: number;
            end?: number | undefined;
        } | undefined;
        __isSplit?: boolean | undefined;
    } & {
        [k: string]: unknown;
    }>) => Promise<void> | void;
    uninterruptedEditMode?: boolean;
};
export declare const ellipse: {
    propPanel: {
        defaultSchema: {
            type: "ellipse" | "rectangle";
            borderWidth: number;
            borderColor: string;
            color: string;
            radius?: number;
            name: string;
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
            content?: string | undefined;
            rotate?: number | undefined;
            opacity?: number | undefined;
            readOnly?: boolean | undefined;
            required?: boolean | undefined;
            __bodyRange?: {
                start: number;
                end?: number | undefined;
            } | undefined;
            __isSplit?: boolean | undefined;
        };
        schema: ((propPanelProps: Omit<{
            rootElement: HTMLDivElement;
            activeSchema: import("@pdfme/common").SchemaForUI;
            activeElements: HTMLElement[];
            changeSchemas: import("@pdfme/common").ChangeSchemas;
            schemas: import("@pdfme/common").SchemaForUI[];
            options: import("@pdfme/common").UIOptions;
            theme: import("antd").GlobalToken;
            i18n: (key: string) => string;
        }, "rootElement">) => Record<string, import("@pdfme/common").PropPanelSchema>) | Record<string, import("@pdfme/common").PropPanelSchema>;
        widgets?: Record<string, (props: import("@pdfme/common").PropPanelWidgetProps) => void>;
    };
    icon: string;
    pdf: (arg: import("@pdfme/common").PDFRenderProps<ShapeSchema & {
        name: string;
        type: string;
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
        content?: string | undefined;
        rotate?: number | undefined;
        opacity?: number | undefined;
        readOnly?: boolean | undefined;
        required?: boolean | undefined;
        __bodyRange?: {
            start: number;
            end?: number | undefined;
        } | undefined;
        __isSplit?: boolean | undefined;
    } & {
        [k: string]: unknown;
    }>) => Promise<void> | void;
    ui: (arg: import("@pdfme/common").UIRenderProps<ShapeSchema & {
        name: string;
        type: string;
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
        content?: string | undefined;
        rotate?: number | undefined;
        opacity?: number | undefined;
        readOnly?: boolean | undefined;
        required?: boolean | undefined;
        __bodyRange?: {
            start: number;
            end?: number | undefined;
        } | undefined;
        __isSplit?: boolean | undefined;
    } & {
        [k: string]: unknown;
    }>) => Promise<void> | void;
    uninterruptedEditMode?: boolean;
};
export {};
