import { Template, Size, UIProps, UIOptions, PreviewProps } from '@pdfme/common';
export declare abstract class BaseUIClass {
    protected domContainer: HTMLElement | null;
    protected template: Template;
    protected size: Size;
    private lang;
    private font;
    private readonly setSize;
    constructor(props: UIProps);
    protected getI18n(): (key: "type" | "field" | "cancel" | "fieldName" | "require" | "uniq" | "inputExample" | "edit" | "plsSelect" | "plsInputName" | "plsAddNewField" | "fieldMustUniq" | "notUniq" | "noKeyName" | "fieldsList" | "addNewField" | "editField" | "goToFirst" | "goToPrevious" | "goToNext" | "goToEnd" | "select" | "zoomIn" | "zoomOut" | "errorOccurred" | "errorBulkUpdateFieldName" | "commitBulkUpdateFieldName" | "bulkUpdateFieldName") => string;
    protected getFont(): Record<string, {
        fallback?: boolean | undefined;
        subset?: boolean | undefined;
        data: ArrayBuffer | Uint8Array;
    }>;
    getTemplate(): {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    updateTemplate(template: Template): void;
    updateOptions(options: UIOptions): void;
    destroy(): void;
    protected abstract render(): void;
}
export declare abstract class PreviewUI extends BaseUIClass {
    protected inputs: {
        [key: string]: string;
    }[];
    constructor(props: PreviewProps);
    getInputs(): {
        [key: string]: string;
    }[];
    setInputs(inputs: {
        [key: string]: string;
    }[]): void;
    protected abstract render(): void;
}
