import { Template, BasePdf, SchemaForUI, Size, PluginRegistry } from '@pdfme/common';
export declare const uuid: () => string;
export declare const debounce: <T extends (...args: unknown[]) => unknown>(cb: T, wait?: number) => T;
export declare const round: (number: number, precision: number) => number;
export declare const flatten: <T>(arr: T[][]) => T[];
export declare const initShortCuts: (arg: {
    move: (command: "up" | "down" | "left" | "right", isShift: boolean) => void;
    remove: () => void;
    esc: () => void;
    copy: () => void;
    paste: () => void;
    redo: () => void;
    undo: () => void;
    save: () => void;
    selectAll: () => void;
}) => void;
export declare const destroyShortCuts: () => void;
export declare const arrayBufferToBase64: (arrayBuffer: ArrayBuffer) => string;
export declare const template2SchemasList: (_template: Template) => Promise<{
    width: number;
    height: number;
    type: string;
    name: string;
    position: {
        x: number;
        y: number;
    };
    id: string;
    opacity?: number | undefined;
    rotate?: number | undefined;
    required?: boolean | undefined;
    content?: string | undefined;
    readOnly?: boolean | undefined;
    __bodyRange?: {
        start: number;
        end?: number | undefined;
    } | undefined;
    __isSplit?: boolean | undefined;
}[][]>;
export declare const schemasList2template: (schemasList: SchemaForUI[][], basePdf: BasePdf) => Template;
export declare const getUniqueSchemaName: (arg: {
    copiedSchemaName: string;
    schema: SchemaForUI[];
    stackUniqueSchemaNames: string[];
}) => string;
export declare const moveCommandToChangeSchemasArg: (props: {
    command: "up" | "down" | "left" | "right";
    activeSchemas: SchemaForUI[];
    isShift: boolean;
    pageSize: Size;
}) => {
    key: string;
    value: number;
    schemaId: string;
}[];
export declare const getPagesScrollTopByIndex: (pageSizes: Size[], index: number, scale: number) => number;
export declare const getSidebarContentHeight: (sidebarHeight: number) => number;
export declare const changeSchemas: (args: {
    objs: {
        key: string;
        value: unknown;
        schemaId: string;
    }[];
    schemas: SchemaForUI[];
    basePdf: BasePdf;
    pluginsRegistry: PluginRegistry;
    pageSize: {
        width: number;
        height: number;
    };
    commitSchemas: (newSchemas: SchemaForUI[]) => void;
}) => void;
export declare const useMaxZoom: () => number;
export declare const setFontNameRecursively: (obj: Record<string, unknown>, fontName: string, seen?: WeakSet<WeakKey>) => void;
