(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("js-lib/src/core"), require("js-lib/src/property-path"));
	else if(typeof define === 'function' && define.amd)
		define(["js-lib/src/core", "js-lib/src/property-path"], factory);
	else if(typeof exports === 'object')
		exports["Object"] = factory(require("js-lib/src/core"), require("js-lib/src/property-path"));
	else
		root["Peace"] = root["Peace"] || {}, root["Peace"]["Object"] = factory(root["Peace"]["Core"], root["Peace"]["PropertyPath"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE__core__, __WEBPACK_EXTERNAL_MODULE__property_path__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/object.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./core":
/*!*****************************************************************************************************************************!*\
  !*** external {"commonjs":"js-lib/src/core","commonjs2":"js-lib/src/core","amd":"js-lib/src/core","root":["Peace","Core"]} ***!
  \*****************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE__core__;

/***/ }),

/***/ "./property-path":
/*!****************************************************************************************************************************************************************!*\
  !*** external {"commonjs":"js-lib/src/property-path","commonjs2":"js-lib/src/property-path","amd":"js-lib/src/property-path","root":["Peace","PropertyPath"]} ***!
  \****************************************************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE__property_path__;

/***/ }),

/***/ "./src/object.js":
/*!***********************!*\
  !*** ./src/object.js ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

let Core = __webpack_require__(/*! ./core */ "./core");
let PropertyPath = __webpack_require__(/*! ./property-path */ "./property-path");

/** 对象访问上下文 */
class VisitorContext {
    /**
     * @param {*} root 根对象值
     * @param {PropertyPath} [path] 当前属性到根对象的属性路径
     * @param {*} [parent] 父对象值
     * @param {String|Number} [name] 当前属性名
     * @param {*} [value] 当前属性值
     */
    constructor(root, path, parent, name, value) {
        this.root = root;
        this.path = path;
        this.parent = parent;
        this.name = name;
        this.value = value;
    }
}

/** 对象访问器 */
class Visitor {
    /**
     * 前置访问可遍历对象
     * @param {VisitorContext} context
     */
    preVisit(context) {}

    /**
     * 后置访问可遍历对象
     * @param {VisitorContext}context
     */
    postVisit(context) {}

    /**
     * 访问属性值
     * @param {VisitorContext}context
     */
    visit(context) {}
}

class ConsoleVisitor extends Visitor {

    preVisit(context) {
        console.info('preVisit:', context.path ? context.path.toString() : null, '=>', context.value);
    }

    postVisit(context) {
        console.info('postVisit:', context.path ? context.path.toString() : null, '=>', context.value);
    }

    visit(context) {
        console.info('visit:', context.path.toString(), '=>', context.value);
    }
}

let CONSOLE_VISITOR = new ConsoleVisitor();


/**
 * 递归遍历对象的所有属性
 * @param {*} value
 * @param {Visitor} visitor
 * @param {VisitorContext} context
 */
function _walkTree(value, visitor, context) {
    context.value = value;
    //处理原始类型
    if (Core.isSimpleType(value)) {
        visitor.visit && visitor.visit(context);
        return;
    }

    //处理数组类型
    if (value instanceof Array) {
        visitor.preVisit && visitor.preVisit(context);
        value.forEach((item, i) => {
            _walkTree(item, visitor, new VisitorContext(
                context.root,
                context.path ? context.path.addNode(i) : new PropertyPath(i),
                value,
                i,
            ));
        });
        visitor.postVisit && visitor.postVisit(context);
        return;
    }

    //处理对象类型
    let keys = Object.keys(value);
    visitor.preVisit && visitor.preVisit(context);
    keys.forEach(key => {
        _walkTree(value[key], visitor, new VisitorContext(
            context.root,
            context.path ? context.path.addNode(key) : new PropertyPath(key),
            value,
            key,
        ));
    });
    visitor.postVisit && visitor.postVisit(context);
}

/**
 * @param {*} value
 * @param {Visitor} visitor
 */
function walkTree(value, visitor) {
    _walkTree(value, visitor, new VisitorContext(value));
}

module.exports = {
    VisitorContext,
    Visitor,
    ConsoleVisitor,
    walkTree,
    CONSOLE_VISITOR
};

/***/ })

/******/ });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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