(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("axios"), require("jsonpath"));
	else if(typeof define === 'function' && define.amd)
		define(["axios", "jsonpath"], factory);
	else if(typeof exports === 'object')
		exports["Peace"] = factory(require("axios"), require("jsonpath"));
	else
		root["Peace"] = factory(root["_"], root["jsonpath"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_axios__, __WEBPACK_EXTERNAL_MODULE_jsonpath__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/all.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./src/all.js":
/*!********************!*\
  !*** ./src/all.js ***!
  \********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = {
    Core: __webpack_require__(/*! ./core */ "./src/core.js"),
    PropertyPath: __webpack_require__(/*! ./property-path */ "./src/property-path.js"),
    Object: __webpack_require__(/*! ./object */ "./src/object.js"),
    AsyncValidator: __webpack_require__(/*! ./async-validator */ "./src/async-validator.js"),
};

/***/ }),

/***/ "./src/async-validator.js":
/*!********************************!*\
  !*** ./src/async-validator.js ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

let Core = __webpack_require__(/*! ./core.js */ "./src/core.js");
let Axios = __webpack_require__(/*! axios */ "axios");

//basic rule, can't support message placeholder
let Rules = {
    rules: {
        requires(rule, value, callback, source, options) {
            if (Core.isEmpty(value)) return true;
            return rule.requires.filter(name => !Core.isEmpty(value[name])).length > 0;
        },
        depend(rule, value, callback, source, options) {
            if (!rule.depend.supplier(source)) return true;
            return !Core.isEmpty(value);
        },
        unique(rule, value, callback, source, options) {
            //{url:String,params:{},original:{}}
            let unique = rule.unique;
            let params = {[rule.field]: value};

            unique.params
            && Object.keys(unique.params).forEach(key => {
                let value = rule.unique.params[key];
                params[key] = value instanceof Function ? value() : value;
            });

            let original = unique.original;
            if (original) {
                if (Core.getType(original) !== 'object') original = {[rule.field]: original};
                if (Object.keys(params).filter(key => params[key] !== original[key]).length === 0) return true;
            }

            return Axios
                .get(unique.url, {params: params})
                .then(t => Promise.resolve(unique.format ? unique.format(t) : t),
                    // t => throw new Error(`请求出错(${t})`));
                    t => Promise.reject(t));
            //TODO 不能再promise回调中抛出异常
        }
    },
    messages: {
        requires: 'one of {opts} is required',
        depend: '{field} depending on {opts.field} is required',
        unique: "{field} with value '{value}' already exists",
    },
};

function join(name) {
    return {
        validator(rule, value, callback, source, options) {
            let result = Rules.rules[name].apply(this, arguments);
            if (!(result instanceof Promise)) result = Promise.resolve(result);
            result.then(isValid => {
                if (isValid) return callback();
                let message = rule.message || options.messages[name] || Rules.messages[name];
                callback(new Error(Core.format(message, {field: rule.field, value: value, opts: rule[name]})));
            })
        },
    };
}

//join rule, supported message placeholder
Object.assign(Rules, {
    requires: {type: 'object', ...join('requires')},
    depend: join('depend'),
    unique: join('unique'),
});

//Simplified use
Object.assign(Rules, {
    simplified: {
        requires(names) {
            return {requires: names, ...Rules.requires};
        },
        depend(field, supplier) {
            supplier = supplier || (value => !Core.isEmpty(Core.getValue(value, field)));
            return {depend: {field: field, supplier}, ...Rules.depend};
        },
        unique(url, params, original, format = result => result) {
            return {unique: {url, params, original, format}, ...Rules.unique};
        }
    }
});

module.exports = Rules;

/***/ }),

/***/ "./src/core.js":
/*!*********************!*\
  !*** ./src/core.js ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

let Core = {
    /**
     * js类型
     * @see <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Grammar_and_Types#Data_types">参考文档</a>
     */
    types: ['undefined', 'null', 'boolean', 'number', 'bigint', 'string', 'symbol', 'object'],
    primitiveTypes: ['undefined', 'null', 'boolean', 'number', 'bigint', 'string', 'symbol'],
    /**
     * 获取值的类型
     * @param {*} value
     * @return {string}
     */
    getType(value) {
        let type = Object.prototype.toString.call(value);
        /\[object (\w+)]/.test(type);
        return RegExp.$1.toLowerCase();
    },
    /**
     * 是否原始类型或其封装类型
     * @param {*} [value]
     * @return {boolean}
     */
    isPrimitiveOrWrapper(value) {
        return Core.primitiveTypes.filter(item => item === Core.getType(value)).length > 0;
    },
    /**
     * 是否简单类型，不可遍历的类型
     * @param {*} value
     * @return {boolean}
     */
    isSimpleType(value) {
        return Core.isPrimitiveOrWrapper(value)
            || value instanceof Function
            || value instanceof Date
            || value instanceof RegExp;
    },
    /**
     * 获取对象的值
     * @param {object} object
     * @param {string} path 属性路径
     * @return {*}
     */
    getValue(object, path) {
        //TODO 如何实现可选的jsonpath依赖在node中, eval快还是jsonpath快？
        let jsonpath = __webpack_require__(/*! jsonpath */ "jsonpath");
        return jsonpath
            ? jsonpath.value(object, `$.${path}`)
            : Core._getValue(object, path);
    },
    /** 通过eval获取对象值 */
    _getValue(object, path) {
        try {
            return eval("object." + path);
        } catch (e) {
            if (console && console.warn) console.warn(`can't eval ${path} on object `, object);
            return undefined;
        }
    },
    /**
     * 格式化
     * @param {String} message
     * @param {Object|Array} value
     * @return {String}
     */
    format(message, value) {
        if (Core.isSimpleType(value)) value = [value];
        return Array.isArray(value)
            ? message.replace(/{(\d+)}/g, (matched, index) => value[index])
            //TODO 提供精确匹配属性路径的正则表达式
            : message.replace(/{(.*?)}/g, (matched, name) => Core.getValue(value, name));
    },
    /**
     * 是否null或者undefined
     * @param {*} value
     * @return {boolean}
     */
    isNullOrUndefined(value) {
        return value === undefined || value === null;
    },
    /**
     * 是否为空
     * @param {*} value
     * @return {boolean}
     */
    isEmpty(value) {
        if (Core.isNullOrUndefined(value)) return true;
        let type = Core.getType(value);
        if (type === 'string') return value === '';
        if (type === 'array') return value.length === 0;
        return false;
    }
};

module.exports = Core;


/***/ }),

/***/ "./src/object.js":
/*!***********************!*\
  !*** ./src/object.js ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

let Core = __webpack_require__(/*! ./core */ "./src/core.js");
let PropertyPath = __webpack_require__(/*! ./property-path */ "./src/property-path.js");

/** 对象访问上下文 */
class VisitorContext {
    /**
     * @param {*} root 根对象值
     * @param {PropertyPath} [path] 当前属性到根对象的属性路径
     * @param {*} [parent] 父对象值
     * @param {String|Number} [name] 当前属性名
     * @param {*} [value] 当前属性值
     */
    constructor(root, path, parent, name, value) {
        this.root = root;
        this.path = path;
        this.parent = parent;
        this.name = name;
        this.value = value;
    }
}

/** 对象访问器 */
class Visitor {
    /**
     * 前置访问可遍历对象
     * @param {VisitorContext} context
     */
    preVisit(context) {}

    /**
     * 后置访问可遍历对象
     * @param {VisitorContext}context
     */
    postVisit(context) {}

    /**
     * 访问属性值
     * @param {VisitorContext}context
     */
    visit(context) {}
}

class ConsoleVisitor extends Visitor {

    preVisit(context) {
        console.info('preVisit:', context.path ? context.path.toString() : null, '=>', context.value);
    }

    postVisit(context) {
        console.info('postVisit:', context.path ? context.path.toString() : null, '=>', context.value);
    }

    visit(context) {
        console.info('visit:', context.path.toString(), '=>', context.value);
    }
}

let CONSOLE_VISITOR = new ConsoleVisitor();


/**
 * 递归遍历对象的所有属性
 * @param {*} value
 * @param {Visitor} visitor
 * @param {VisitorContext} context
 */
function _walkTree(value, visitor, context) {
    context.value = value;
    //处理原始类型
    if (Core.isSimpleType(value)) {
        visitor.visit && visitor.visit(context);
        return;
    }

    //处理数组类型
    if (value instanceof Array) {
        visitor.preVisit && visitor.preVisit(context);
        value.forEach((item, i) => {
            _walkTree(item, visitor, new VisitorContext(
                context.root,
                context.path ? context.path.addNode(i) : new PropertyPath(i),
                value,
                i,
            ));
        });
        visitor.postVisit && visitor.postVisit(context);
        return;
    }

    //处理对象类型
    let keys = Object.keys(value);
    visitor.preVisit && visitor.preVisit(context);
    keys.forEach(key => {
        _walkTree(value[key], visitor, new VisitorContext(
            context.root,
            context.path ? context.path.addNode(key) : new PropertyPath(key),
            value,
            key,
        ));
    });
    visitor.postVisit && visitor.postVisit(context);
}

/**
 * @param {*} value
 * @param {Visitor} visitor
 */
function walkTree(value, visitor) {
    _walkTree(value, visitor, new VisitorContext(value));
}

module.exports = {
    VisitorContext,
    Visitor,
    ConsoleVisitor,
    walkTree,
    CONSOLE_VISITOR
};

/***/ }),

/***/ "./src/property-path.js":
/*!******************************!*\
  !*** ./src/property-path.js ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports) {

/** 属性路径 */
class PropertyPath {

    /**
     * @param {...String|Number} nodes 属性路径中的节点数组
     */
    constructor(...nodes) {
        this.nodes = nodes;
        this.nodes.forEach((node, i) => this[i] = node);
    }

    /**
     * 在末尾添加节点
     * @param {String|Number} node
     * @return {PropertyPath}
     */
    addNode(node) {
        return new PropertyPath(...this.nodes, node);
    }

    /**
     * 获取属性值
     * @param {*} object 任意对象
     * @return {null | undefined | *}
     */
    getValue(object) {
        let value = object;
        for (let i = 0; i < this.nodes.length; i++) {
            if (value === undefined) return undefined;
            if (value === null) return null;
            value = value[this.nodes[i]];
        }
        return value;
    }

    /**
     * 设置属性值
     * @param {*} object 任意对象
     * @param {*} value 属性值
     */
    setValue(object, value) {
        //roles,0,name,admin = {roles:[{name:'admin'}]}
        this.nodes.forEach((node, index) => {
            //如果是叶子节点直接设置值
            if (this.nodes.length === index + 1) {
                object[node] = value;
            } else {
                //如果途经空对象，初始化一个对象
                if (!object[node]) object[node] = typeof this.nodes[index + 1] === 'number' ? [] : {};
                object = object[node];
            }
        });
    }

    /**属性路径的字符串格式*/
    toString() {
        let string = '';
        this.nodes.forEach((node, i) => {
            if (typeof node === 'number') {
                string += '[' + node + ']'
            } else {
                string += (i === 0 ? '' : '.') + node;
            }
        });
        return string;
    }
}


module.exports = PropertyPath;


/***/ }),

/***/ "axios":
/*!**********************************************************************************!*\
  !*** external {"commonjs":"axios","commonjs2":"axios","amd":"axios","root":"_"} ***!
  \**********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_axios__;

/***/ }),

/***/ "jsonpath":
/*!***************************!*\
  !*** external "jsonpath" ***!
  \***************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_jsonpath__;

/***/ })

/******/ });
});
//# sourceMappingURL=peace.js.map