// @generated by Peggy 5.0.6.
//
// https://peggyjs.org/

"use strict";


const OPS_TO_PREFIXED_TYPES = {
  "$": "text",
  "&": "simple_and",
  "!": "simple_not",
};

const OPS_TO_SUFFIXED_TYPES = {
  "?": "optional",
  "*": "zero_or_more",
  "+": "one_or_more",
};

const OPS_TO_SEMANTIC_PREDICATE_TYPES = {
  "&": "semantic_and",
  "!": "semantic_not",
};

class peg$SyntaxError extends SyntaxError {
  constructor(message, expected, found, location) {
    super(message);
    this.expected = expected;
    this.found = found;
    this.location = location;
    this.name = "SyntaxError";
  }

  format(sources) {
    let str = "Error: " + this.message;
    if (this.location) {
      let src = null;
      const st = sources.find(s => s.source === this.location.source);
      if (st) {
        src = st.text.split(/\r\n|\n|\r/g);
      }
      const s = this.location.start;
      const offset_s = (this.location.source && (typeof this.location.source.offset === "function"))
        ? this.location.source.offset(s)
        : s;
      const loc = this.location.source + ":" + offset_s.line + ":" + offset_s.column;
      if (src) {
        const e = this.location.end;
        const filler = "".padEnd(offset_s.line.toString().length, " ");
        const line = src[s.line - 1];
        const last = s.line === e.line ? e.column : line.length + 1;
        const hatLen = (last - s.column) || 1;
        str += "\n --> " + loc + "\n"
            + filler + " |\n"
            + offset_s.line + " | " + line + "\n"
            + filler + " | " + "".padEnd(s.column - 1, " ")
            + "".padEnd(hatLen, "^");
      } else {
        str += "\n at " + loc;
      }
    }
    return str;
  }

  static buildMessage(expected, found) {
    function hex(ch) {
      return ch.codePointAt(0).toString(16).toUpperCase();
    }

    const nonPrintable = Object.prototype.hasOwnProperty.call(RegExp.prototype, "unicode")
      ? new RegExp("[\\p{C}\\p{Mn}\\p{Mc}]", "gu")
      : null;
    function unicodeEscape(s) {
      if (nonPrintable) {
        return s.replace(nonPrintable,  ch => "\\u{" + hex(ch) + "}");
      }
      return s;
    }

    function literalEscape(s) {
      return unicodeEscape(s
        .replace(/\\/g, "\\\\")
        .replace(/"/g,  "\\\"")
        .replace(/\0/g, "\\0")
        .replace(/\t/g, "\\t")
        .replace(/\n/g, "\\n")
        .replace(/\r/g, "\\r")
        .replace(/[\x00-\x0F]/g,          ch => "\\x0" + hex(ch))
        .replace(/[\x10-\x1F\x7F-\x9F]/g, ch => "\\x"  + hex(ch)));
    }

    function classEscape(s) {
      return unicodeEscape(s
        .replace(/\\/g, "\\\\")
        .replace(/\]/g, "\\]")
        .replace(/\^/g, "\\^")
        .replace(/-/g,  "\\-")
        .replace(/\0/g, "\\0")
        .replace(/\t/g, "\\t")
        .replace(/\n/g, "\\n")
        .replace(/\r/g, "\\r")
        .replace(/[\x00-\x0F]/g,          ch => "\\x0" + hex(ch))
        .replace(/[\x10-\x1F\x7F-\x9F]/g, ch => "\\x"  + hex(ch)));
    }

    const DESCRIBE_EXPECTATION_FNS = {
      literal(expectation) {
        return "\"" + literalEscape(expectation.text) + "\"";
      },

      class(expectation) {
        const escapedParts = expectation.parts.map(
          part => (Array.isArray(part)
            ? classEscape(part[0]) + "-" + classEscape(part[1])
            : classEscape(part))
        );

        return "[" + (expectation.inverted ? "^" : "") + escapedParts.join("") + "]" + (expectation.unicode ? "u" : "");
      },

      any() {
        return "any character";
      },

      end() {
        return "end of input";
      },

      other(expectation) {
        return expectation.description;
      },
    };

    function describeExpectation(expectation) {
      return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
    }

    function describeExpected(expected) {
      const descriptions = expected.map(describeExpectation);
      descriptions.sort();

      if (descriptions.length > 0) {
        let j = 1;
        for (let i = 1; i < descriptions.length; i++) {
          if (descriptions[i - 1] !== descriptions[i]) {
            descriptions[j] = descriptions[i];
            j++;
          }
        }
        descriptions.length = j;
      }

      switch (descriptions.length) {
        case 1:
          return descriptions[0];

        case 2:
          return descriptions[0] + " or " + descriptions[1];

        default:
          return descriptions.slice(0, -1).join(", ")
            + ", or "
            + descriptions[descriptions.length - 1];
      }
    }

    function describeFound(found) {
      return found ? "\"" + literalEscape(found) + "\"" : "end of input";
    }

    return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
  }
}

function peg$parse(input, options) {
  options = options !== undefined ? options : {};

  const peg$FAILED = {};
  const peg$source = options.grammarSource;

  const peg$startRuleFunctions = {
    Grammar: peg$parseGrammar,
    ImportsAndSource: peg$parseImportsAndSource,
  };
  let peg$startRuleFunction = peg$parseGrammar;

  const peg$c0 = "import";
  const peg$c1 = ";";
  const peg$c2 = ",";
  const peg$c3 = "*";
  const peg$c4 = "as";
  const peg$c5 = "{";
  const peg$c6 = "}";
  const peg$c7 = "from";
  const peg$c8 = "=";
  const peg$c9 = "/";
  const peg$c10 = "@";
  const peg$c11 = ":";
  const peg$c12 = "|";
  const peg$c13 = "..";
  const peg$c14 = "(";
  const peg$c15 = ")";
  const peg$c16 = ".";
  const peg$c17 = "\n";
  const peg$c18 = "\r\n";
  const peg$c19 = "/*";
  const peg$c20 = "*/";
  const peg$c21 = "//";
  const peg$c22 = "\\";
  const peg$c23 = "i";
  const peg$c24 = "\"";
  const peg$c25 = "'";
  const peg$c26 = "[";
  const peg$c27 = "^";
  const peg$c28 = "]";
  const peg$c29 = "p";
  const peg$c30 = "_";
  const peg$c31 = "u";
  const peg$c32 = "-";
  const peg$c33 = "0";
  const peg$c34 = "b";
  const peg$c35 = "f";
  const peg$c36 = "n";
  const peg$c37 = "r";
  const peg$c38 = "t";
  const peg$c39 = "v";
  const peg$c40 = "x";

  const peg$r0 = /^[!$&]/;
  const peg$r1 = /^[*-+?]/;
  const peg$r2 = /^[!&]/;
  const peg$r3 = /^[\0-\uD7FF\uE000-\uFFFF]/;
  const peg$r4 = /^[\uD800-\uDBFF]/;
  const peg$r5 = /^[\uDC00-\uDFFF]/;
  const peg$r6 = /^[\uD800-\uDFFF]/;
  const peg$r7 = /^[\t\v-\f \p{Zs}\xA0\uFEFF]/u;
  const peg$r8 = /^[\n\r\u2028\u2029]/;
  const peg$r9 = /^[\r\u2028-\u2029]/;
  const peg$r10 = /^[\p{ID_Start}_]/u;
  const peg$r11 = /^[$\p{ID_Continue}]/u;
  const peg$r12 = /^[\n\r"\\\u2028-\u2029]/;
  const peg$r13 = /^[\n\r'\\\u2028-\u2029]/;
  const peg$r14 = /^[a-z]/i;
  const peg$r15 = /^[\n\r\\-\]\u2028-\u2029]/;
  const peg$r16 = /^["'\\]/;
  const peg$r17 = /^[0-9pux]/;
  const peg$r18 = /^[0-9]/;
  const peg$r19 = /^[0-9a-f]/i;
  const peg$r20 = /^[{}]/;

  const peg$e0 = peg$anyExpectation();
  const peg$e1 = peg$literalExpectation("import", false);
  const peg$e2 = peg$literalExpectation(";", false);
  const peg$e3 = peg$literalExpectation(",", false);
  const peg$e4 = peg$literalExpectation("*", false);
  const peg$e5 = peg$literalExpectation("as", false);
  const peg$e6 = peg$literalExpectation("{", false);
  const peg$e7 = peg$literalExpectation("}", false);
  const peg$e8 = peg$literalExpectation("from", false);
  const peg$e9 = peg$literalExpectation("=", false);
  const peg$e10 = peg$literalExpectation("/", false);
  const peg$e11 = peg$literalExpectation("@", false);
  const peg$e12 = peg$literalExpectation(":", false);
  const peg$e13 = peg$classExpectation(["!", "$", "&"], false, false, false);
  const peg$e14 = peg$classExpectation([["*", "+"], "?"], false, false, false);
  const peg$e15 = peg$literalExpectation("|", false);
  const peg$e16 = peg$literalExpectation("..", false);
  const peg$e17 = peg$literalExpectation("(", false);
  const peg$e18 = peg$literalExpectation(")", false);
  const peg$e19 = peg$literalExpectation(".", false);
  const peg$e20 = peg$classExpectation(["!", "&"], false, false, false);
  const peg$e21 = peg$classExpectation([["\0", "\uD7FF"], ["\uE000", "\uFFFF"]], false, false, false);
  const peg$e22 = peg$classExpectation([["\uD800", "\uDBFF"]], false, false, false);
  const peg$e23 = peg$classExpectation([["\uDC00", "\uDFFF"]], false, false, false);
  const peg$e24 = peg$classExpectation([["\uD800", "\uDFFF"]], false, false, false);
  const peg$e25 = peg$otherExpectation("whitespace");
  const peg$e26 = peg$classExpectation(["\t", ["\v", "\f"], " ", "\\p{Zs}", "\xA0", "\uFEFF"], false, false, true);
  const peg$e27 = peg$classExpectation(["\n", "\r", "\u2028", "\u2029"], false, false, false);
  const peg$e28 = peg$otherExpectation("end of line");
  const peg$e29 = peg$literalExpectation("\n", false);
  const peg$e30 = peg$literalExpectation("\r\n", false);
  const peg$e31 = peg$classExpectation(["\r", ["\u2028", "\u2029"]], false, false, false);
  const peg$e32 = peg$otherExpectation("comment");
  const peg$e33 = peg$literalExpectation("/*", false);
  const peg$e34 = peg$literalExpectation("*/", false);
  const peg$e35 = peg$literalExpectation("//", false);
  const peg$e36 = peg$otherExpectation("identifier");
  const peg$e37 = peg$classExpectation(["\\p{ID_Start}", "_"], false, false, true);
  const peg$e38 = peg$literalExpectation("\\", false);
  const peg$e39 = peg$classExpectation(["$", "\\p{ID_Continue}"], false, false, true);
  const peg$e40 = peg$otherExpectation("literal");
  const peg$e41 = peg$literalExpectation("i", false);
  const peg$e42 = peg$otherExpectation("string");
  const peg$e43 = peg$literalExpectation("\"", false);
  const peg$e44 = peg$literalExpectation("'", false);
  const peg$e45 = peg$classExpectation(["\n", "\r", "\"", "\\", ["\u2028", "\u2029"]], false, false, false);
  const peg$e46 = peg$classExpectation(["\n", "\r", "'", "\\", ["\u2028", "\u2029"]], false, false, false);
  const peg$e47 = peg$otherExpectation("character class");
  const peg$e48 = peg$literalExpectation("[", false);
  const peg$e49 = peg$literalExpectation("^", false);
  const peg$e50 = peg$literalExpectation("]", false);
  const peg$e51 = peg$literalExpectation("p", true);
  const peg$e52 = peg$literalExpectation("_", false);
  const peg$e53 = peg$classExpectation([["a", "z"]], false, true, false);
  const peg$e54 = peg$literalExpectation("u", false);
  const peg$e55 = peg$literalExpectation("-", false);
  const peg$e56 = peg$classExpectation(["\n", "\r", ["\\", "]"], ["\u2028", "\u2029"]], false, false, false);
  const peg$e57 = peg$literalExpectation("0", false);
  const peg$e58 = peg$classExpectation(["\"", "'", "\\"], false, false, false);
  const peg$e59 = peg$literalExpectation("b", false);
  const peg$e60 = peg$literalExpectation("f", false);
  const peg$e61 = peg$literalExpectation("n", false);
  const peg$e62 = peg$literalExpectation("r", false);
  const peg$e63 = peg$literalExpectation("t", false);
  const peg$e64 = peg$literalExpectation("v", false);
  const peg$e65 = peg$classExpectation([["0", "9"], "p", "u", "x"], false, false, false);
  const peg$e66 = peg$literalExpectation("x", false);
  const peg$e67 = peg$classExpectation([["0", "9"]], false, false, false);
  const peg$e68 = peg$classExpectation([["0", "9"], ["a", "f"]], false, true, false);
  const peg$e69 = peg$otherExpectation("code block");
  const peg$e70 = peg$classExpectation(["{", "}"], false, false, false);

  function peg$f0(imports, topLevelInitializer, initializer, rules) {
    return {
      type: "grammar",
      imports,
      topLevelInitializer,
      initializer,
      rules,
      location: location(),
    };
  }
  function peg$f1(imports, body) {
    return [imports, body];
  }
  function peg$f2(code) {
    return {
      type: "top_level_initializer",
      code,
      codeLocation: location(),
    };
  }
  function peg$f3(code) {
    return {
      type: "top_level_initializer",
      code,
      codeLocation: location(),
    };
  }
  function peg$f4(what, from) {
    return {
      type: "grammar_import", what, from, location: location(),
    };
  }
  function peg$f5(from) {
    return {
      type: "grammar_import", what: [], from, location: location(),
    };
  }
  function peg$f6(first, others) {
    if (!others) {
      return [first];
    }
    // 'others' is always an array.
    others.unshift(first);
    return others;
  }
  function peg$f7(binding) {
    return {
      type: "import_binding_default",
      binding: binding[0],
      location: binding[1],
    };
  }
  function peg$f8(binding) {
    return [{
      type: "import_binding_all",
      binding: binding[0],
      location: binding[1],
    }];
  }
  function peg$f9() {    return [];  }
  function peg$f10(rename, binding) {
    return {
      type: "import_binding_rename",
      rename: rename[0],
      renameLocation: rename[1],
      binding: binding[0],
      location: binding[1],
    };
  }
  function peg$f11(binding) {
    return {
      type: "import_binding",
      binding: binding[0],
      location: binding[1],
    };
  }
  function peg$f12(module) {
    return { type: "import_module_specifier", module, location: location() };
  }
  function peg$f13(id) {    return [id, location()];  }
  function peg$f14(id) {    return [id, location()];  }
  function peg$f15(id) {
    if (reservedWords.has(id[0])) {
      error(`Binding identifier can't be a reserved word "${id[0]}"`, id[1]);
    }
    return id[0];
  }
  function peg$f16(code) {
    return {
      type: "top_level_initializer",
      code: code[0],
      codeLocation: code[1],
      location: location(),
    };
  }
  function peg$f17(code) {
    return {
      type: "initializer",
      code: code[0],
      codeLocation: code[1],
      location: location(),
    };
  }
  function peg$f18(name, displayName, expression) {
    return {
      type: "rule",
      name: name[0],
      nameLocation: name[1],
      expression: displayName !== null
        ? {
            type: "named",
            name: displayName,
            expression,
            location: location(),
          }
        : expression,
      location: location(),
    };
  }
  function peg$f19(head, tail) {
    return tail.length > 0
      ? {
          type: "choice",
          alternatives: [head].concat(tail),
          location: location(),
        }
      : head;
  }
  function peg$f20(expression, code) {
    return code !== null
      ? {
          type: "action",
          expression,
          code: code[0],
          codeLocation: code[1],
          location: location(),
        }
      : expression;
  }
  function peg$f21(head, tail) {
    return ((tail.length > 0) || (head.type === "labeled" && head.pick))
      ? {
          type: "sequence",
          elements: [head].concat(tail),
          location: location(),
        }
      : head;
  }
  function peg$f22(pluck, label, expression) {
    if (expression.type.startsWith("semantic_")) {
      error("\"@\" cannot be used on a semantic predicate", pluck);
    }
    return {
      type: "labeled",
      label: label !== null ? label[0] : null,
      // Use location of "@" if label is unavailable
      labelLocation: label !== null ? label[1] : pluck,
      pick: true,
      expression,
      location: location(),
    };
  }
  function peg$f23(label, expression) {
    return {
      type: "labeled",
      label: label[0],
      labelLocation: label[1],
      expression,
      location: location(),
    };
  }
  function peg$f24() {    return location();  }
  function peg$f25(label) {
    if (reservedWords.has(label[0])) {
      error(`Label can't be a reserved word "${label[0]}"`, label[1]);
    }

    return label;
  }
  function peg$f26(operator, expression) {
    return {
      type: OPS_TO_PREFIXED_TYPES[operator],
      expression,
      location: location(),
    };
  }
  function peg$f27(expression, operator) {
    return {
      type: OPS_TO_SUFFIXED_TYPES[operator],
      expression,
      location: location(),
    };
  }
  function peg$f28(expression, boundaries, delimiter) {
    const min = boundaries[0];
    const max = boundaries[1];
    if (max.type === "constant" && max.value === 0) {
      error("The maximum count of repetitions of the rule must be > 0", max.location);
    }

    return {
      type: "repeated",
      min,
      max,
      expression,
      delimiter,
      location: location(),
    };
  }
  function peg$f29(min, max) {
    return [
      min !== null ? min : { type: "constant", value: 0 },
      max !== null ? max : { type: "constant", value: null },
    ];
  }
  function peg$f30(exact) {    return [null, exact];  }
  function peg$f31(value) {    return { type: "constant", value, location: location() };  }
  function peg$f32(value) {    return { type: "variable", value: value[0], location: location() };  }
  function peg$f33(value) {
    return {
      type: "function",
      value: value[0],
      codeLocation: value[1],
      location: location(),
    };
  }
  function peg$f34(expression) {
    // The purpose of the "group" AST node is just to isolate label scope. We
    // don't need to put it around nodes that can't contain any labels or
    // nodes that already isolate label scope themselves. This leaves us with
    // "labeled" and "sequence".
    return expression.type === "labeled" || expression.type === "sequence"
      ? { type: "group", expression, location: location() }
      : expression;
  }
  function peg$f35(library, name) {
    return {
      type: "library_ref",
      name: name[0],
      library: library[0],
      libraryNumber: -1,
      location: location(),
    };
  }
  function peg$f36(name) {
    return { type: "rule_ref", name: name[0], location: location() };
  }
  function peg$f37(operator, code) {
    return {
      type: OPS_TO_SEMANTIC_PREDICATE_TYPES[operator],
      code: code[0],
      codeLocation: code[1],
      location: location(),
    };
  }
  function peg$f38(head, tail) {
    return [head + tail.join(""), location()];
  }
  function peg$f39(value, ignoreCase) {
    return {
      type: "literal",
      value,
      ignoreCase: ignoreCase !== null,
      location: location(),
    };
  }
  function peg$f40(chars) {    return chars.join("");  }
  function peg$f41(chars) {    return chars.join("");  }
  function peg$f42(inverted, parts, flags) {
    // [^]u is like . but for a codepoint: not-nothing.
    if (inverted && (parts.length === 0)) {
      if (flags.unicode) {
        parts = [["\ud800", "\udfff"]];
      } else {
        return {
          type: "any",
          location: location(),
        };
      }
    }
    return {
      type: "class",
      parts: parts.filter(part => part !== ""),
      inverted: Boolean(inverted),
      ignoreCase: Boolean(flags.ignoreCase),
      location: location(),
      unicode: Boolean(flags.unicode) || parts.flat().some(
        c => ((typeof c === "object") && c.unicode) || (c.codePointAt(0) > 0xffff)
      ),
    };
  }
  function peg$f43(value) {
    try {
      new RegExp(`[\\${value}]`, "u");
    } catch (er) {
      error("Invalid Unicode property escape");
    }
    return {
      type: "classEscape",
      value,
      unicode: true,
      location: location(),
    };
  }
  function peg$f44(flags) {
    const ret = Object.fromEntries(flags);
    if (Object.keys(ret).length !== flags.length) {
      error("Invalid flags");
    }
    return ret;
  }
  function peg$f45() {    return ["ignoreCase", true];  }
  function peg$f46() {    return ["unicode", true];  }
  function peg$f47(begin, end) {
    if (begin.codePointAt(0) > end.codePointAt(0)) {
      error(
        "Invalid character range: " + text() + "."
      );
    }

    return [begin, end];
  }
  function peg$f48() {    return "";  }
  function peg$f49() {    return "\0";  }
  function peg$f50() {    return "\b";  }
  function peg$f51() {    return "\f";  }
  function peg$f52() {    return "\n";  }
  function peg$f53() {    return "\r";  }
  function peg$f54() {    return "\t";  }
  function peg$f55() {    return "\v";  }
  function peg$f56(digits) {
    return String.fromCharCode(parseInt(digits, 16));
  }
  function peg$f57(digits) {
    return String.fromCharCode(parseInt(digits, 16));
  }
  function peg$f58(digits) {
    return String.fromCodePoint(parseInt(digits, 16));
  }
  function peg$f59() {    return { type: "any", location: location() };  }
  function peg$f60(code) {    return [code, location()];  }
  function peg$f61(digits) {    return parseInt(digits, 10);  }
  let peg$currPos = options.peg$currPos | 0;
  let peg$savedPos = peg$currPos;
  const peg$posDetailsCache = [{ line: 1, column: 1 }];
  let peg$maxFailPos = peg$currPos;
  let peg$maxFailExpected = options.peg$maxFailExpected || [];
  let peg$silentFails = options.peg$silentFails | 0;

  let peg$result;

  if (options.startRule) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function offset() {
    return peg$savedPos;
  }

  function range() {
    return {
      source: peg$source,
      start: peg$savedPos,
      end: peg$currPos,
    };
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildSimpleError(message, location);
  }

  function peg$getUnicode(pos = peg$currPos) {
    const cp = input.codePointAt(pos);
    if (cp === undefined) {
      return "";
    }
    return String.fromCodePoint(cp);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text, ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase, unicode) {
    return { type: "class", parts, inverted, ignoreCase, unicode };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description };
  }

  function peg$computePosDetails(pos) {
    let details = peg$posDetailsCache[pos];
    let p;

    if (details) {
      return details;
    } else {
      if (pos >= peg$posDetailsCache.length) {
        p = peg$posDetailsCache.length - 1;
      } else {
        p = pos;
        while (!peg$posDetailsCache[--p]) {}
      }

      details = peg$posDetailsCache[p];
      details = {
        line: details.line,
        column: details.column,
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;

      return details;
    }
  }

  function peg$computeLocation(startPos, endPos, offset) {
    const startPosDetails = peg$computePosDetails(startPos);
    const endPosDetails = peg$computePosDetails(endPos);

    const res = {
      source: peg$source,
      start: {
        offset: startPos,
        line: startPosDetails.line,
        column: startPosDetails.column,
      },
      end: {
        offset: endPos,
        line: endPosDetails.line,
        column: endPosDetails.column,
      },
    };
    if (offset && peg$source && (typeof peg$source.offset === "function")) {
      res.start = peg$source.offset(res.start);
      res.end = peg$source.offset(res.end);
    }
    return res;
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parseGrammar() {
    let s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parseImportDeclarations();
    s2 = peg$currPos;
    s3 = peg$parse__();
    s4 = peg$parseTopLevelInitializer();
    if (s4 !== peg$FAILED) {
      s2 = s4;
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 === peg$FAILED) {
      s2 = null;
    }
    s3 = peg$currPos;
    s4 = peg$parse__();
    s5 = peg$parseInitializer();
    if (s5 !== peg$FAILED) {
      s3 = s5;
    } else {
      peg$currPos = s3;
      s3 = peg$FAILED;
    }
    if (s3 === peg$FAILED) {
      s3 = null;
    }
    s4 = peg$parse__();
    s5 = [];
    s6 = peg$currPos;
    s7 = peg$parseRule();
    if (s7 !== peg$FAILED) {
      s8 = peg$parse__();
      s6 = s7;
    } else {
      peg$currPos = s6;
      s6 = peg$FAILED;
    }
    if (s6 !== peg$FAILED) {
      while (s6 !== peg$FAILED) {
        s5.push(s6);
        s6 = peg$currPos;
        s7 = peg$parseRule();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s6 = s7;
        } else {
          peg$currPos = s6;
          s6 = peg$FAILED;
        }
      }
    } else {
      s5 = peg$FAILED;
    }
    if (s5 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f0(s1, s2, s3, s5);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseImportsAndSource() {
    let s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parseImportsAsText();
    s2 = peg$parseGrammarBody();
    peg$savedPos = s0;
    s0 = peg$f1(s1, s2);

    return s0;
  }

  function peg$parseGrammarBody() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = [];
    if (input.length > peg$currPos) {
      s3 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e0); }
    }
    while (s3 !== peg$FAILED) {
      s2.push(s3);
      if (input.length > peg$currPos) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e0); }
      }
    }
    s1 = input.substring(s1, peg$currPos);
    peg$savedPos = s0;
    s1 = peg$f2(s1);
    s0 = s1;

    return s0;
  }

  function peg$parseImportsAsText() {
    let s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseImportDeclarations();
    s1 = input.substring(s1, peg$currPos);
    peg$savedPos = s0;
    s1 = peg$f3(s1);
    s0 = s1;

    return s0;
  }

  function peg$parseImportDeclarations() {
    let s0, s1;

    s0 = [];
    s1 = peg$parseImportDeclaration();
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$parseImportDeclaration();
    }

    return s0;
  }

  function peg$parseImportDeclaration() {
    let s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parse__();
    if (input.substr(peg$currPos, 6) === peg$c0) {
      s2 = peg$c0;
      peg$currPos += 6;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e1); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseImportClause();
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s6 = peg$parseFromClause();
        if (s6 !== peg$FAILED) {
          s7 = peg$currPos;
          s8 = peg$parse__();
          if (input.charCodeAt(peg$currPos) === 59) {
            s9 = peg$c1;
            peg$currPos++;
          } else {
            s9 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e2); }
          }
          if (s9 !== peg$FAILED) {
            s8 = [s8, s9];
            s7 = s8;
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f4(s4, s6);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parse__();
      if (input.substr(peg$currPos, 6) === peg$c0) {
        s2 = peg$c0;
        peg$currPos += 6;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e1); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s4 = peg$parseModuleSpecifier();
        if (s4 !== peg$FAILED) {
          s5 = peg$currPos;
          s6 = peg$parse__();
          if (input.charCodeAt(peg$currPos) === 59) {
            s7 = peg$c1;
            peg$currPos++;
          } else {
            s7 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e2); }
          }
          if (s7 !== peg$FAILED) {
            s6 = [s6, s7];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f5(s4);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseImportClause() {
    let s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$parseNameSpaceImport();
    if (s0 === peg$FAILED) {
      s0 = peg$parseNamedImports();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseImportedDefaultBinding();
        if (s1 !== peg$FAILED) {
          s2 = peg$currPos;
          s3 = peg$parse__();
          if (input.charCodeAt(peg$currPos) === 44) {
            s4 = peg$c2;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e3); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parse__();
            s6 = peg$parseNameSpaceImport();
            if (s6 === peg$FAILED) {
              s6 = peg$parseNamedImports();
            }
            if (s6 !== peg$FAILED) {
              s2 = s6;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f6(s1, s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parseImportedDefaultBinding() {
    let s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseImportedBinding();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f7(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseNameSpaceImport() {
    let s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 42) {
      s1 = peg$c3;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e4); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 2) === peg$c4) {
        s3 = peg$c4;
        peg$currPos += 2;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e5); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseImportedBinding();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f8(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseNamedImports() {
    let s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 123) {
      s1 = peg$c5;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e6); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 125) {
        s3 = peg$c6;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e7); }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f9();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 123) {
        s1 = peg$c5;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e6); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseImportsList();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 44) {
            s6 = peg$c2;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e3); }
          }
          if (s6 !== peg$FAILED) {
            s7 = peg$parse__();
            s6 = [s6, s7];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          if (input.charCodeAt(peg$currPos) === 125) {
            s6 = peg$c6;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e7); }
          }
          if (s6 !== peg$FAILED) {
            s0 = s3;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseFromClause() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4) === peg$c7) {
      s1 = peg$c7;
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e8); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseModuleSpecifier();
      if (s3 !== peg$FAILED) {
        s0 = s3;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseImportsList() {
    let s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseImportSpecifier();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$currPos;
      s3 = peg$currPos;
      s4 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 44) {
        s5 = peg$c2;
        peg$currPos++;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e3); }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s4 = [s4, s5, s6];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s3 = peg$parseImportSpecifier();
        if (s3 === peg$FAILED) {
          peg$currPos = s2;
          s2 = peg$FAILED;
        } else {
          s2 = s3;
        }
      } else {
        s2 = s3;
      }
    }
    if (s1.length < 1) {
      peg$currPos = s0;
      s0 = peg$FAILED;
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parseImportSpecifier() {
    let s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseModuleExportName();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 2) === peg$c4) {
        s3 = peg$c4;
        peg$currPos += 2;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e5); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseImportedBinding();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f10(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseImportedBinding();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f11(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseModuleSpecifier() {
    let s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseStringLiteral();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f12(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseImportedBinding() {
    let s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseBindingIdentifier();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f13(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseModuleExportName() {
    let s0, s1;

    s0 = peg$parseIdentifierName();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseStringLiteral();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f14(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseBindingIdentifier() {
    let s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseIdentifierName();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f15(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseTopLevelInitializer() {
    let s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 123) {
      s1 = peg$c5;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e6); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseCodeBlock();
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 125) {
          s3 = peg$c6;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e7); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseEOS();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f16(s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseInitializer() {
    let s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parseCodeBlock();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseEOS();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f17(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseRule() {
    let s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseIdentifierName();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$currPos;
      s4 = peg$parseStringLiteral();
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      if (input.charCodeAt(peg$currPos) === 61) {
        s4 = peg$c8;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e9); }
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s6 = peg$parseChoiceExpression();
        if (s6 !== peg$FAILED) {
          s7 = peg$parseEOS();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f18(s1, s3, s6);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseChoiceExpression() {
    let s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseActionExpression();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 47) {
        s5 = peg$c9;
        peg$currPos++;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e10); }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseActionExpression();
        if (s7 !== peg$FAILED) {
          s3 = s7;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        if (input.charCodeAt(peg$currPos) === 47) {
          s5 = peg$c9;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e10); }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseActionExpression();
          if (s7 !== peg$FAILED) {
            s3 = s7;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f19(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseActionExpression() {
    let s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parseSequenceExpression();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parse__();
      s4 = peg$parseCodeBlock();
      if (s4 !== peg$FAILED) {
        s2 = s4;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f20(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseSequenceExpression() {
    let s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseLabeledExpression();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseLabeledExpression();
      if (s5 !== peg$FAILED) {
        s3 = s5;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseLabeledExpression();
        if (s5 !== peg$FAILED) {
          s3 = s5;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f21(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseLabeledExpression() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsePluck();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseLabelColon();
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      s3 = peg$parsePrefixedExpression();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f22(s1, s2, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseLabelColon();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsePrefixedExpression();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f23(s1, s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parsePrefixedExpression();
      }
    }

    return s0;
  }

  function peg$parsePluck() {
    let s0, s1;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 64) {
      s1 = peg$c10;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e11); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f24();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseLabelColon() {
    let s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parseIdentifierName();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 58) {
        s3 = peg$c11;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e12); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        peg$savedPos = s0;
        s0 = peg$f25(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsePrefixedExpression() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsePrefixedOperator();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseSuffixedExpression();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f26(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseSuffixedExpression();
    }

    return s0;
  }

  function peg$parsePrefixedOperator() {
    let s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r0.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e13); }
    }

    return s0;
  }

  function peg$parseSuffixedExpression() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsePrimaryExpression();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseSuffixedOperator();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f27(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseRepeatedExpression();
      if (s0 === peg$FAILED) {
        s0 = peg$parsePrimaryExpression();
      }
    }

    return s0;
  }

  function peg$parseSuffixedOperator() {
    let s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r1.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e14); }
    }

    return s0;
  }

  function peg$parseRepeatedExpression() {
    let s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parsePrimaryExpression();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 124) {
        s3 = peg$c12;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e15); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseBoundaries();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 44) {
            s8 = peg$c2;
            peg$currPos++;
          } else {
            s8 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e3); }
          }
          if (s8 !== peg$FAILED) {
            s9 = peg$parse__();
            s10 = peg$parseChoiceExpression();
            if (s10 !== peg$FAILED) {
              s11 = peg$parse__();
              s7 = s10;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          if (input.charCodeAt(peg$currPos) === 124) {
            s8 = peg$c12;
            peg$currPos++;
          } else {
            s8 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e15); }
          }
          if (s8 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f28(s1, s5, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseBoundaries() {
    let s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseBoundary();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    if (input.substr(peg$currPos, 2) === peg$c13) {
      s3 = peg$c13;
      peg$currPos += 2;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e16); }
    }
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parseBoundary();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f29(s1, s5);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseBoundary();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f30(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseBoundary() {
    let s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseInteger();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f31(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseIdentifierName();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f32(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseCodeBlock();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$f33(s1);
        }
        s0 = s1;
      }
    }

    return s0;
  }

  function peg$parsePrimaryExpression() {
    let s0, s1, s2, s3, s4, s5;

    s0 = peg$parseLiteralMatcher();
    if (s0 === peg$FAILED) {
      s0 = peg$parseCharacterClassMatcher();
      if (s0 === peg$FAILED) {
        s0 = peg$parseAnyMatcher();
        if (s0 === peg$FAILED) {
          s0 = peg$parseRuleReferenceExpression();
          if (s0 === peg$FAILED) {
            s0 = peg$parseSemanticPredicateExpression();
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              if (input.charCodeAt(peg$currPos) === 40) {
                s1 = peg$c14;
                peg$currPos++;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e17); }
              }
              if (s1 !== peg$FAILED) {
                s2 = peg$parse__();
                s3 = peg$parseChoiceExpression();
                if (s3 !== peg$FAILED) {
                  s4 = peg$parse__();
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s5 = peg$c15;
                    peg$currPos++;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e18); }
                  }
                  if (s5 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f34(s3);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseRuleReferenceExpression() {
    let s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseIdentifierName();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 46) {
        s2 = peg$c16;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e19); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseIdentifierName();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f35(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseIdentifierName();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        peg$silentFails++;
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$currPos;
        s6 = peg$parseStringLiteral();
        if (s6 !== peg$FAILED) {
          s7 = peg$parse__();
          s6 = [s6, s7];
          s5 = s6;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        if (input.charCodeAt(peg$currPos) === 61) {
          s6 = peg$c8;
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e9); }
        }
        if (s6 !== peg$FAILED) {
          s4 = [s4, s5, s6];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        peg$silentFails--;
        if (s3 === peg$FAILED) {
          s2 = undefined;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f36(s1);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseSemanticPredicateExpression() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseSemanticPredicateOperator();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseCodeBlock();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f37(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseSemanticPredicateOperator() {
    let s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r2.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e20); }
    }

    return s0;
  }

  function peg$parseSourceCharacter() {
    let s0;

    s0 = peg$parseSourceCharacterLow();
    if (s0 === peg$FAILED) {
      s0 = peg$parseSourceCharacterHigh();
    }

    return s0;
  }

  function peg$parseSourceCharacterLow() {
    let s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r3.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e21); }
    }

    return s0;
  }

  function peg$parseSourceCharacterHigh() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = input.charAt(peg$currPos);
    if (peg$r4.test(s2)) {
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e22); }
    }
    if (s2 !== peg$FAILED) {
      s3 = input.charAt(peg$currPos);
      if (peg$r5.test(s3)) {
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e23); }
      }
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }
    if (s0 === peg$FAILED) {
      s0 = input.charAt(peg$currPos);
      if (peg$r6.test(s0)) {
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e24); }
      }
    }

    return s0;
  }

  function peg$parseWhiteSpace() {
    let s0, s1;

    peg$silentFails++;
    s0 = peg$getUnicode();
    if (peg$r7.test(s0)) {
      peg$currPos += s0.length;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e26); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e25); }
    }

    return s0;
  }

  function peg$parseLineTerminator() {
    let s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r8.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e27); }
    }

    return s0;
  }

  function peg$parseLineTerminatorSequence() {
    let s0, s1;

    peg$silentFails++;
    if (input.charCodeAt(peg$currPos) === 10) {
      s0 = peg$c17;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e29); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 2) === peg$c18) {
        s0 = peg$c18;
        peg$currPos += 2;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e30); }
      }
      if (s0 === peg$FAILED) {
        s0 = input.charAt(peg$currPos);
        if (peg$r9.test(s0)) {
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e31); }
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e28); }
    }

    return s0;
  }

  function peg$parseComment() {
    let s0, s1;

    peg$silentFails++;
    s0 = peg$parseMultiLineComment();
    if (s0 === peg$FAILED) {
      s0 = peg$parseSingleLineComment();
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e32); }
    }

    return s0;
  }

  function peg$parseMultiLineComment() {
    let s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c19) {
      s1 = peg$c19;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e33); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$currPos;
      peg$silentFails++;
      if (input.substr(peg$currPos, 2) === peg$c20) {
        s5 = peg$c20;
        peg$currPos += 2;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e34); }
      }
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parseSourceCharacter();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        if (input.substr(peg$currPos, 2) === peg$c20) {
          s5 = peg$c20;
          peg$currPos += 2;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e34); }
        }
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parseSourceCharacter();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (input.substr(peg$currPos, 2) === peg$c20) {
        s3 = peg$c20;
        peg$currPos += 2;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e34); }
      }
      if (s3 !== peg$FAILED) {
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseMultiLineCommentNoLineTerminator() {
    let s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c19) {
      s1 = peg$c19;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e33); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$currPos;
      peg$silentFails++;
      if (input.substr(peg$currPos, 2) === peg$c20) {
        s5 = peg$c20;
        peg$currPos += 2;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e34); }
      }
      if (s5 === peg$FAILED) {
        s5 = peg$parseLineTerminator();
      }
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parseSourceCharacter();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        if (input.substr(peg$currPos, 2) === peg$c20) {
          s5 = peg$c20;
          peg$currPos += 2;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e34); }
        }
        if (s5 === peg$FAILED) {
          s5 = peg$parseLineTerminator();
        }
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parseSourceCharacter();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (input.substr(peg$currPos, 2) === peg$c20) {
        s3 = peg$c20;
        peg$currPos += 2;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e34); }
      }
      if (s3 !== peg$FAILED) {
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseSingleLineComment() {
    let s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c21) {
      s1 = peg$c21;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e35); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$currPos;
      peg$silentFails++;
      s5 = peg$parseLineTerminator();
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parseSourceCharacter();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        s5 = peg$parseLineTerminator();
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parseSourceCharacter();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      s1 = [s1, s2];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseIdentifierName() {
    let s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseIdentifierStart();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseIdentifierPart();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseIdentifierPart();
      }
      peg$savedPos = s0;
      s0 = peg$f38(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e36); }
    }

    return s0;
  }

  function peg$parseIdentifierStart() {
    let s0, s1, s2;

    s0 = peg$getUnicode();
    if (peg$r10.test(s0)) {
      peg$currPos += s0.length;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e37); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c22;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e38); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseUnicodeEscapeSequence();
        if (s2 !== peg$FAILED) {
          s0 = s2;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseIdentifierPart() {
    let s0;

    s0 = peg$getUnicode();
    if (peg$r11.test(s0)) {
      peg$currPos += s0.length;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e39); }
    }

    return s0;
  }

  function peg$parseLiteralMatcher() {
    let s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseStringLiteral();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 105) {
        s2 = peg$c23;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e41); }
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f39(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e40); }
    }

    return s0;
  }

  function peg$parseStringLiteral() {
    let s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 34) {
      s1 = peg$c24;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e43); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseDoubleStringCharacter();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseDoubleStringCharacter();
      }
      if (input.charCodeAt(peg$currPos) === 34) {
        s3 = peg$c24;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e43); }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f40(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 39) {
        s1 = peg$c25;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e44); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSingleStringCharacter();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSingleStringCharacter();
        }
        if (input.charCodeAt(peg$currPos) === 39) {
          s3 = peg$c25;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e44); }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f41(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e42); }
    }

    return s0;
  }

  function peg$parseDoubleStringCharacter() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$currPos;
    peg$silentFails++;
    s3 = input.charAt(peg$currPos);
    if (peg$r12.test(s3)) {
      peg$currPos++;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e45); }
    }
    peg$silentFails--;
    if (s3 === peg$FAILED) {
      s2 = undefined;
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parseSourceCharacter();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c22;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e38); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseEscapeSequence();
        if (s2 !== peg$FAILED) {
          s0 = s2;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseLineContinuation();
      }
    }

    return s0;
  }

  function peg$parseSingleStringCharacter() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$currPos;
    peg$silentFails++;
    s3 = input.charAt(peg$currPos);
    if (peg$r13.test(s3)) {
      peg$currPos++;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e46); }
    }
    peg$silentFails--;
    if (s3 === peg$FAILED) {
      s2 = undefined;
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parseSourceCharacter();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c22;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e38); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseEscapeSequence();
        if (s2 !== peg$FAILED) {
          s0 = s2;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseLineContinuation();
      }
    }

    return s0;
  }

  function peg$parseCharacterClassMatcher() {
    let s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 91) {
      s1 = peg$c26;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e48); }
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 94) {
        s2 = peg$c27;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e49); }
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      s3 = [];
      s4 = peg$parseAtomEscape();
      if (s4 === peg$FAILED) {
        s4 = peg$parseClassCharacterRange();
        if (s4 === peg$FAILED) {
          s4 = peg$parseClassCharacter();
        }
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$parseAtomEscape();
        if (s4 === peg$FAILED) {
          s4 = peg$parseClassCharacterRange();
          if (s4 === peg$FAILED) {
            s4 = peg$parseClassCharacter();
          }
        }
      }
      if (input.charCodeAt(peg$currPos) === 93) {
        s4 = peg$c28;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e50); }
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parseClassFlags();
        peg$savedPos = s0;
        s0 = peg$f42(s2, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e47); }
    }

    return s0;
  }

  function peg$parseAtomEscape() {
    let s0, s1, s2;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 92) {
      s1 = peg$c22;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e38); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseCharacterClassEscape();
      if (s2 !== peg$FAILED) {
        s0 = s2;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseCharacterClassEscape() {
    let s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$currPos;
    s3 = input.charAt(peg$currPos);
    if (s3.toLowerCase() === peg$c29) {
      peg$currPos++;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e51); }
    }
    if (s3 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 123) {
        s4 = peg$c5;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e6); }
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parseUnicodePropertyValueExpression();
        if (s5 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 125) {
            s6 = peg$c6;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e7); }
          }
          if (s6 !== peg$FAILED) {
            s3 = [s3, s4, s5, s6];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s1 = input.substring(s1, peg$currPos);
    } else {
      s1 = s2;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f43(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseUnicodePropertyValueExpression() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseUnicodePropertyName();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 61) {
        s2 = peg$c8;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e9); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseUnicodePropertyValue();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseLoneUnicodePropertyNameOrValue();
    }

    return s0;
  }

  function peg$parseUnicodePropertyName() {
    let s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseUnicodePropertyNameCharacter();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseUnicodePropertyNameCharacter();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parseUnicodePropertyValue() {
    let s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseUnicodePropertyValueCharacter();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseUnicodePropertyValueCharacter();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parseLoneUnicodePropertyNameOrValue() {
    let s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseUnicodePropertyValueCharacter();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseUnicodePropertyValueCharacter();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parseUnicodePropertyValueCharacter() {
    let s0;

    s0 = peg$parseUnicodePropertyNameCharacter();
    if (s0 === peg$FAILED) {
      s0 = peg$parseDecimalDigit();
    }

    return s0;
  }

  function peg$parseUnicodePropertyNameCharacter() {
    let s0;

    s0 = peg$parseAsciiLetter();
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 95) {
        s0 = peg$c30;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e52); }
      }
    }

    return s0;
  }

  function peg$parseAsciiLetter() {
    let s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r14.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e53); }
    }

    return s0;
  }

  function peg$parseClassFlags() {
    let s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseClassFlag();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parseClassFlag();
    }
    peg$savedPos = s0;
    s1 = peg$f44(s1);
    s0 = s1;

    return s0;
  }

  function peg$parseClassFlag() {
    let s0, s1;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 105) {
      s1 = peg$c23;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e41); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f45();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 117) {
        s1 = peg$c31;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e54); }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f46();
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseClassCharacterRange() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseClassCharacter();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 45) {
        s2 = peg$c32;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e55); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseClassCharacter();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f47(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseClassCharacter() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$currPos;
    peg$silentFails++;
    s3 = input.charAt(peg$currPos);
    if (peg$r15.test(s3)) {
      peg$currPos++;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e56); }
    }
    peg$silentFails--;
    if (s3 === peg$FAILED) {
      s2 = undefined;
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parseSourceCharacter();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c22;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e38); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseEscapeSequence();
        if (s2 !== peg$FAILED) {
          s0 = s2;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseLineContinuation();
      }
    }

    return s0;
  }

  function peg$parseLineContinuation() {
    let s0, s1, s2;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 92) {
      s1 = peg$c22;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e38); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseLineTerminatorSequence();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f48();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseEscapeSequence() {
    let s0, s1, s2, s3;

    s0 = peg$parseCharacterEscapeSequence();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 48) {
        s1 = peg$c33;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e57); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        peg$silentFails++;
        s3 = peg$parseDecimalDigit();
        peg$silentFails--;
        if (s3 === peg$FAILED) {
          s2 = undefined;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f49();
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseHexEscapeSequence();
        if (s0 === peg$FAILED) {
          s0 = peg$parseUnicodeEscapeSequence();
        }
      }
    }

    return s0;
  }

  function peg$parseCharacterEscapeSequence() {
    let s0;

    s0 = peg$parseSingleEscapeCharacter();
    if (s0 === peg$FAILED) {
      s0 = peg$parseNonEscapeCharacter();
    }

    return s0;
  }

  function peg$parseSingleEscapeCharacter() {
    let s0, s1;

    s0 = input.charAt(peg$currPos);
    if (peg$r16.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e58); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 98) {
        s1 = peg$c34;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e59); }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f50();
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 102) {
          s1 = peg$c35;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e60); }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$f51();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 110) {
            s1 = peg$c36;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e61); }
          }
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$f52();
          }
          s0 = s1;
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 114) {
              s1 = peg$c37;
              peg$currPos++;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e62); }
            }
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$f53();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              if (input.charCodeAt(peg$currPos) === 116) {
                s1 = peg$c38;
                peg$currPos++;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e63); }
              }
              if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$f54();
              }
              s0 = s1;
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 118) {
                  s1 = peg$c39;
                  peg$currPos++;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e64); }
                }
                if (s1 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$f55();
                }
                s0 = s1;
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseNonEscapeCharacter() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$currPos;
    peg$silentFails++;
    s3 = peg$parseEscapeCharacter();
    if (s3 === peg$FAILED) {
      s3 = peg$parseLineTerminator();
    }
    peg$silentFails--;
    if (s3 === peg$FAILED) {
      s2 = undefined;
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parseSourceCharacter();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parseEscapeCharacter() {
    let s0;

    s0 = peg$parseSingleEscapeCharacter();
    if (s0 === peg$FAILED) {
      s0 = input.charAt(peg$currPos);
      if (peg$r17.test(s0)) {
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e65); }
      }
    }

    return s0;
  }

  function peg$parseHexEscapeSequence() {
    let s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 120) {
      s1 = peg$c40;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e66); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$currPos;
      s4 = peg$parseHexDigit();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseHexDigit();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s2 = input.substring(s2, peg$currPos);
      } else {
        s2 = s3;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f56(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseUnicodeEscapeSequence() {
    let s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 117) {
      s1 = peg$c31;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e54); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$currPos;
      s4 = peg$parseHexDigit();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseHexDigit();
        if (s5 !== peg$FAILED) {
          s6 = peg$parseHexDigit();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseHexDigit();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s2 = input.substring(s2, peg$currPos);
      } else {
        s2 = s3;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f57(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 117) {
        s1 = peg$c31;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e54); }
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 123) {
          s2 = peg$c5;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e6); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          s4 = [];
          s5 = peg$parseHexDigit();
          if (s5 !== peg$FAILED) {
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseHexDigit();
            }
          } else {
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s3 = input.substring(s3, peg$currPos);
          } else {
            s3 = s4;
          }
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 125) {
              s4 = peg$c6;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e7); }
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f58(s3);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseDecimalDigit() {
    let s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r18.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e67); }
    }

    return s0;
  }

  function peg$parseHexDigit() {
    let s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r19.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e68); }
    }

    return s0;
  }

  function peg$parseAnyMatcher() {
    let s0, s1;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 46) {
      s1 = peg$c16;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e19); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f59();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseCodeBlock() {
    let s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 123) {
      s1 = peg$c5;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e6); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseBareCodeBlock();
      if (input.charCodeAt(peg$currPos) === 125) {
        s3 = peg$c6;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e7); }
      }
      if (s3 !== peg$FAILED) {
        s0 = s2;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e69); }
    }

    return s0;
  }

  function peg$parseBareCodeBlock() {
    let s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseCode();
    peg$savedPos = s0;
    s1 = peg$f60(s1);
    s0 = s1;

    return s0;
  }

  function peg$parseCode() {
    let s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = [];
    s2 = [];
    s3 = peg$currPos;
    s4 = peg$currPos;
    peg$silentFails++;
    s5 = input.charAt(peg$currPos);
    if (peg$r20.test(s5)) {
      peg$currPos++;
    } else {
      s5 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e70); }
    }
    peg$silentFails--;
    if (s5 === peg$FAILED) {
      s4 = undefined;
    } else {
      peg$currPos = s4;
      s4 = peg$FAILED;
    }
    if (s4 !== peg$FAILED) {
      s5 = peg$parseSourceCharacter();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
    } else {
      peg$currPos = s3;
      s3 = peg$FAILED;
    }
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        s5 = input.charAt(peg$currPos);
        if (peg$r20.test(s5)) {
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e70); }
        }
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parseSourceCharacter();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 === peg$FAILED) {
      s2 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 123) {
        s3 = peg$c5;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e6); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parseCode();
        if (input.charCodeAt(peg$currPos) === 125) {
          s5 = peg$c6;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e7); }
        }
        if (s5 !== peg$FAILED) {
          s3 = [s3, s4, s5];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    }
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$currPos;
      peg$silentFails++;
      s5 = input.charAt(peg$currPos);
      if (peg$r20.test(s5)) {
        peg$currPos++;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e70); }
      }
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parseSourceCharacter();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$currPos;
          peg$silentFails++;
          s5 = input.charAt(peg$currPos);
          if (peg$r20.test(s5)) {
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e70); }
          }
          peg$silentFails--;
          if (s5 === peg$FAILED) {
            s4 = undefined;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parseSourceCharacter();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 123) {
          s3 = peg$c5;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e6); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseCode();
          if (input.charCodeAt(peg$currPos) === 125) {
            s5 = peg$c6;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e7); }
          }
          if (s5 !== peg$FAILED) {
            s3 = [s3, s4, s5];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      }
    }
    s0 = input.substring(s0, peg$currPos);

    return s0;
  }

  function peg$parseInteger() {
    let s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = [];
    s3 = peg$parseDecimalDigit();
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseDecimalDigit();
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s1 = input.substring(s1, peg$currPos);
    } else {
      s1 = s2;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f61(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parse__() {
    let s0, s1;

    s0 = [];
    s1 = peg$parseWhiteSpace();
    if (s1 === peg$FAILED) {
      s1 = peg$parseLineTerminatorSequence();
      if (s1 === peg$FAILED) {
        s1 = peg$parseComment();
      }
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$parseWhiteSpace();
      if (s1 === peg$FAILED) {
        s1 = peg$parseLineTerminatorSequence();
        if (s1 === peg$FAILED) {
          s1 = peg$parseComment();
        }
      }
    }

    return s0;
  }

  function peg$parse_() {
    let s0, s1;

    s0 = [];
    s1 = peg$parseWhiteSpace();
    if (s1 === peg$FAILED) {
      s1 = peg$parseMultiLineCommentNoLineTerminator();
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$parseWhiteSpace();
      if (s1 === peg$FAILED) {
        s1 = peg$parseMultiLineCommentNoLineTerminator();
      }
    }

    return s0;
  }

  function peg$parseEOS() {
    let s0, s1, s2, s3;

    s0 = [];
    s1 = peg$currPos;
    s2 = peg$parse__();
    if (input.charCodeAt(peg$currPos) === 59) {
      s3 = peg$c1;
      peg$currPos++;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e2); }
    }
    if (s3 !== peg$FAILED) {
      s2 = [s2, s3];
      s1 = s2;
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      while (s1 !== peg$FAILED) {
        s0.push(s1);
        s1 = peg$currPos;
        s2 = peg$parse__();
        if (input.charCodeAt(peg$currPos) === 59) {
          s3 = peg$c1;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e2); }
        }
        if (s3 !== peg$FAILED) {
          s2 = [s2, s3];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      }
    } else {
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parse_();
      s2 = peg$parseSingleLineComment();
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      s3 = peg$parseLineTerminatorSequence();
      if (s3 !== peg$FAILED) {
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parse__();
        s2 = peg$parseEOF();
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parseEOF() {
    let s0, s1;

    s0 = peg$currPos;
    peg$silentFails++;
    if (input.length > peg$currPos) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e0); }
    }
    peg$silentFails--;
    if (s1 === peg$FAILED) {
      s0 = undefined;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }


  const reservedWords = new Set(options.reservedWords);

  peg$result = peg$startRuleFunction();

  const peg$success = (peg$result !== peg$FAILED && peg$currPos === input.length);
  function peg$throw() {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? peg$getUnicode(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
  if (options.peg$library) {
    return /** @type {any} */ ({
      peg$result,
      peg$currPos,
      peg$FAILED,
      peg$maxFailExpected,
      peg$maxFailPos,
      peg$success,
      peg$throw: peg$success ? undefined : peg$throw,
    });
  }
  if (peg$success) {
    return peg$result;
  } else {
    peg$throw();
  }
}

module.exports = {
  StartRules: ["Grammar", "ImportsAndSource"],
  SyntaxError: peg$SyntaxError,
  parse: peg$parse,
};
