export type NormalizedOptions = {
    originalContext?: Record<string, any> | undefined;
    console?: ConsoleOutput | undefined;
};
export type SourceFormat = "amd" | "bare" | "cjs" | "commonjs" | "es" | "es6" | "esm" | "globals" | "guess" | "mjs" | "module" | "umd";
export type ConsoleOutErr = {
    /**
     * Stdout.
     */
    out?: string | undefined;
    /**
     * Stdout.
     */
    err?: string | undefined;
    /**
     * Call this to snapshot out and err.  Will
     * be added to the empty object you provide.
     */
    capture?: (() => void) | undefined;
};
/**
 * Options for how to process code.
 */
export type FromMemOptions = {
    /**
     * What format does the code have?
     * "guess" means to read the closest package.json file looking for the
     * "type" key.  "globals", "amd", and "bare" are not actually supported.
     */
    format?: SourceFormat | undefined;
    /**
     * If specified, use this instead of the
     * current values in process.env.  Works if includeGlobals is false by
     * creating an otherwise-empty process instance.
     */
    env?: Record<string, any> | undefined;
    /**
     * What is the fully-qualified synthetic filename
     * for the code?  Most important is the directory, which is used to find
     * modules that the code import's or require's.
     */
    filename: string;
    /**
     * Variables to make availble in
     * the global scope while code is being evaluated.  Overwrites global
     * properties as needed.
     */
    context?: Record<string, any> | undefined;
    /**
     * Include the typical global
     * properties that node gives to all modules.  (e.g. Buffer, process).
     */
    includeGlobals?: boolean | undefined;
    /**
     * Specifies the line number offset that is
     * displayed in stack traces produced by this script.
     */
    lineOffset?: number | undefined;
    /**
     * Specifies the first-line column number
     * offset that is displayed in stack traces produced by this script.
     */
    columnOffset?: number | undefined;
    /**
     * If specified, execute this code on the resulting
     * module in an async context, with `IMPORTED` being the imported module,
     * and `arg` being the value of the arg option.
     */
    exec?: string | undefined;
    /**
     * Will be available as "arg" in the exec code.
     */
    arg?: unknown;
    /**
     * If specified, will be filled in
     * with output from the console.* functions.
     */
    consoleOutput?: ConsoleOutErr | undefined;
    /**
     * Set color
     * support for this Console instance. Setting to true enables coloring while
     * inspecting values. Setting to false disables coloring while inspecting
     * values. Setting to 'auto' makes color support depend on the value of the
     * isTTY property and the value returned by getColorDepth() on the
     * respective stream.  Ignored if consoleOutput is not set.
     */
    colorMode?: boolean | "auto" | undefined;
    /**
     * If format is "globals", use this as the
     * export variable.
     */
    exportVar?: string | undefined;
};
/**
 * @typedef {object} NormalizedOptions
 * @property {Record<string, any>} [originalContext]
 * @property {ConsoleOutput} [console]
 */
/**
 * Fix up context as needed.
 *
 * @param {FromMemOptions & NormalizedOptions} options
 */
export function normalizeContext(options: FromMemOptions & NormalizedOptions): void;
/**
 * Revert normalizeOptions.
 *
 * @param {FromMemOptions & NormalizedOptions} options
 */
export function denormalizeContext(options: FromMemOptions & NormalizedOptions): void;
export const globalContext: {
    [k: string]: any;
};
import ConsoleOutput = require("./console.js");
