export = importString;
/** @typedef {import("./global.js").FromMemOptions} FromMemOptions */
/** @typedef {import("./global.js").NormalizedOptions} NormalizedOptions */
/**
 * Treat the given code as a node module as if import had been called
 * on a file containing the code.
 *
 * @param {string} code Source code in es6 format.
 * @param {string} dirname Where the synthetic file would have lived.
 * @param {FromMemOptions} options
 * @returns {Promise<unknown>} The module exported from code, or results of exec.
 */
declare function importString(code: string, dirname: string, options: FromMemOptions): Promise<unknown>;
declare namespace importString {
    export { FromMemOptions, NormalizedOptions };
}
type FromMemOptions = import("./global.js").FromMemOptions;
type NormalizedOptions = import("./global.js").NormalizedOptions;
