export = fromMem;
/** @typedef {import("./global.js").FromMemOptions} FromMemOptions */
/** @typedef {import("./global.js").ConsoleOutErr} ConsoleOutErr */
/** @typedef {import("./global.js").SourceFormat} SourceFormat */
/** @typedef {import("./utils.js").ModuleType} ModuleType */
/**
 * Import or require the given code from memory.  Knows about the different
 * Peggy output formats.  Returns the exports of the module.
 *
 * @param {string} code Code to import
 * @param {FromMemOptions} options Options.  Most important is filename.
 * @returns {Promise<unknown>} The evaluated code.
 * @example
 *
 * ```js
 * const mjsResult = await fromMem(
 *   "export default 42",
 *   {
 *     filename: "foo.mjs",
 *     exec: "return IMPORTED.default + arg",
 *     arg: 3,
 *   }
 * ); // 45
 * const cjsResult = await fromMem(
 *   "module.exports = 42;",
 *   {
 *     filename: "foo.cjs",
 *     exec: "return IMPORTED + arg",
 *     arg: 3,
 *   }
 * ); // 45
 * ```
 */
declare function fromMem(code: string, options: FromMemOptions): Promise<unknown>;
declare namespace fromMem {
    export { clearModuleTypeCache, guessModuleType, isImportSupported, FromMemOptions, ConsoleOutErr, SourceFormat, ModuleType };
}
import { clearModuleTypeCache } from "./utils.js";
import { guessModuleType } from "./utils.js";
import { isImportSupported } from "./utils.js";
type FromMemOptions = import("./global.js").FromMemOptions;
type ConsoleOutErr = import("./global.js").ConsoleOutErr;
type SourceFormat = import("./global.js").SourceFormat;
type ModuleType = import("./utils.js").ModuleType;
