export = spawnChild;
/** @typedef {import("./global.js").FromMemOptions} FromMemOptions */
/** @typedef {import("./global.js").ConsoleOutErr} ConsoleOutErr */
/**
 * @typedef {object} SpawnResult
 * @prop {Error|undefined} [error]
 * @prop {unknown} [result]
 * @prop {ConsoleOutErr} [consoleOutput]
 */
/**
 * Treat the given code as a node module as if import had been called on a
 * file containing the code.  Creates a child process with
 * --experimental-vm-modules.  Slightly better security than running
 * in-process, but slower and will not pass non-serializable types adequately
 * across the boundary correctly.
 *
 * @param {string} code Source code in es6 format.
 * @param {string} dirname Where the synthetic file would have lived.
 * @param {FromMemOptions} options
 * @returns {Promise<SpawnResult>} The module exports from code
 */
declare function spawnChild(code: string, dirname: string, options: FromMemOptions): Promise<SpawnResult>;
declare namespace spawnChild {
    export { FromMemOptions, ConsoleOutErr, SpawnResult };
}
type FromMemOptions = import("./global.js").FromMemOptions;
type ConsoleOutErr = import("./global.js").ConsoleOutErr;
type SpawnResult = {
    error?: Error | undefined;
    result?: unknown;
    consoleOutput?: import("./global.js").ConsoleOutErr | undefined;
};
