export = requireString;
/** @typedef {import("./global.js").FromMemOptions} FromMemOptions */
/** @typedef {import("./global.js").NormalizedOptions} NormalizedOptions */
/**
 * Treat the given code as a node module as if require() had been called
 * on a file containing the code.
 *
 * @param {string} code Source code in commonjs format.
 * @param {string} dirname Used for __dirname.
 * @param {FromMemOptions} options
 * @returns {unknown} The module exported from code, or the result from exec.
 */
declare function requireString(code: string, dirname: string, options: FromMemOptions): unknown;
declare namespace requireString {
    export { FromMemOptions, NormalizedOptions };
}
type FromMemOptions = import("./global.js").FromMemOptions;
type NormalizedOptions = import("./global.js").NormalizedOptions;
