export type FromMemOptions = import("./global.js").FromMemOptions;
export type ModuleType = "commonjs" | "es";
export function clearModuleTypeCache(): void;
/** @typedef {import("./global.js").FromMemOptions} FromMemOptions */
/**
 * Execute the given code in an Async function, passing in two parameters.
 * Usually the first will be an imported/required module, and the second
 * (optional) argument that is user-specific.
 *
 * @param {unknown} imported Imported module.
 * @param {FromMemOptions} options Second arg for `exec` code.
 * @returns
 */
export function evalAsync(imported: unknown, options: FromMemOptions): any;
/**
 * Figure out the module type for the given file.  If no package.json is
 * found, default to "commonjs".
 *
 * @param {string} filename Fully-qualified filename to start from.
 * @returns {Promise<ModuleType>}
 * @throws On invalid package.json
 */
export function guessModuleType(filename: string): Promise<ModuleType>;
/**
 * Is importing from an ES6 module supported in the current environment?
 *
 * @returns {boolean}
 */
export function isImportSupported(): boolean;
/**
 * If the given specifier starts with a ".", path.resolve it to the given
 * directory.  Otherwise, it's a fully-qualified path, a node internal
 * module name, an npm-provided module name, or a URL.
 *
 * @param {string} dirname Owning directory
 * @param {string} specifier String from the rightmost side of an import statement
 * @returns {string} Resolved path name or original string
 */
export function resolveIfNeeded(dirname: string, specifier: string): string;
