[![ci](https://img.shields.io/travis/pegjs/pegjs.svg)](https://travis-ci.org/pegjs/pegjs)
[![coverage](https://img.shields.io/coveralls/github/pegjs/pegjs.svg)](https://coveralls.io/github/pegjs/pegjs)
[![license](https://img.shields.io/badge/license-mit-blue.svg)](https://opensource.org/licenses/MIT)

PEG.js is a simple parser generator for JavaScript that produces fast parsers with excellent error reporting. You can use it to process complex data or computer languages and build transformers, interpreters, compilers and other tools easily.

> PEG.js is still very much work in progress. There are no compatibility guarantees until version 1.0

## features

  * Simple and expressive grammar syntax
  * Integrates both lexical and syntactical analysis
  * Parsers have excellent error reporting out of the box
  * Based on [parsing expression grammar](http://en.wikipedia.org/wiki/Parsing_expression_grammar) formalism - more powerful than traditional LL(*k*) and LR(*k*) parsers
  * Usable [from your browser](https://pegjs.org/online), from the command line, or via JavaScript API

## documentation

- [Getting Started](https://github.com/pegjs/pegjs/blob/master/docs/guides/getting-started.md)
- [Installation](https://github.com/pegjs/pegjs/blob/master/docs/guides/installation.md)
- [Generating a Parser](https://github.com/pegjs/pegjs/blob/master/docs/guides/generating-a-parser.md)
- [Using the Parser](https://github.com/pegjs/pegjs/blob/master/docs/guides/using-the-parser.md)
- [Grammar Syntax and Semantics](https://github.com/pegjs/pegjs/tree/master/docs/grammar)
- [JavaScript API](https://github.com/pegjs/pegjs/blob/master/docs/guides/javascript-api.md)
- [Plugins](https://github.com/pegjs/pegjs/blob/master/docs/guides/plugins.md)
- [Compatibility](https://github.com/pegjs/pegjs/blob/master/docs/notes/compatibility.md)
- [Development](https://github.com/pegjs/pegjs/blob/master/docs/notes/development.md)
- [Useful Links](https://github.com/pegjs/pegjs/blob/master/docs/notes/useful-links.md)

## license

Released under the [MIT License](https://opensource.org/licenses/MIT).

Copyright (c) 2010-2016 [David Majda](https://majda.cz/)<br>
Copyright (c) 2017+ [Futago-za Ryuu](https://github.com/futagoza)
