# Changelog of perf-regexes

## [1.0.1] - 2018-12-24

### Added

- Support for the 's' (ES9 dotAll) flag.
- Support unicode whitespace and line-endings.

## [1.0.0] - 2018-12-22

Complete refactorization of the repo.

### Added

- Separates double and single quoted string: `JS_DQSTR` and `JS_DQSTR`
- Adds regexes for lines: `EMPTY_LINES`, `NON_EMPTY_LINES`, `TRAILING_WS`, `OPT_WS_EOL` and `EOL`
- UMD build for AMD, CommonJS, and browsers with the `window.R` object.
- Karma test for local Chrome and Firefox browsers.
- More than 40 mocha test.
- TypeScript definition.
- Markdownlinter configuration.
- More badges.

### Changed

- Regex construction with common parts to make more clear and maintainable the code.
- Simplification of `JS_REGEX`.
- Deprecate `JS_REGEX_P`.
- Rename the ESM build from 'dist/perf-regexes.esm.js' to 'dist/perf-regexes.mjs'
- The minimum supported version of NodeJS now is 6.14 (oldest maintained LTS version w/fixes).
- Update Travis test to node 4.2 and the latest stable version.
- Update Readme with corrections and more samples.
- Update license file.
- Update ESLint configuration and 'ignore' files.
- Update devDependencies.

## [0.1.2] - 2016-09-23

### Changed

- Revision of `J_REGEX`, new `J\REGEX_P`, including prefix in $1
- Removed `JS_DIVISOR`, `ES6_TSTR_SIMPLE`, and `ISCOMMENT`
- Removed dependency on Bublé

## [0.0.2] - 2016-09-08

### Removed

- Exclude `in` and `of` from valid regex prefix.

## [0.0.1] - 2016-09-07

- Initial release.
