/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2018 Photon Storm Ltd.
 * @license      {@link https://github.com/photonstorm/phaser/blob/master/license.txt|MIT License}
 */

/**
 * PlayStation DualShock 4 Gamepad Configuration.
 * Sony PlayStation DualShock 4 (v2) wireless controller
 *
 * @name Phaser.Input.Gamepad.Configs.DUALSHOCK_4
 * @type {object}
 * @since 3.0.0
 */
module.exports = {

    UP: 12,
    DOWN: 13,
    LEFT: 14,
    RIGHT: 15,

    SHARE: 8,
    OPTIONS: 9,
    PS: 16,
    TOUCHBAR: 17,

    X: 0,
    CIRCLE: 1,
    SQUARE: 2,
    TRIANGLE: 3,

    L1: 4,
    R1: 5,
    L2: 6,
    R2: 7,
    L3: 10,
    R3: 11,

    LEFT_STICK_H: 0,
    LEFT_STICK_V: 1,
    RIGHT_STICK_H: 2,
    RIGHT_STICK_V: 3

};
