/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * The Camera Shake Complete Event.
 * 
 * This event is dispatched by a Camera instance when the Shake Effect completes.
 *
 * @event Phaser.Cameras.Scene2D.Events#SHAKE_COMPLETE
 * @since 3.3.0
 * 
 * @param {Phaser.Cameras.Scene2D.Camera} camera - The camera that the effect began on.
 * @param {Phaser.Cameras.Scene2D.Effects.Shake} effect - A reference to the effect instance.
 */
module.exports = 'camerashakecomplete';
