/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

var GEOM_CONST = {

    /**
     * A Circle Geometry object type.
     * 
     * @name Phaser.Geom.CIRCLE
     * @type {integer}
     * @since 3.19.0
     */
    CIRCLE: 0,

    /**
     * An Ellipse Geometry object type.
     * 
     * @name Phaser.Geom.ELLIPSE
     * @type {integer}
     * @since 3.19.0
     */
    ELLIPSE: 1,

    /**
     * A Line Geometry object type.
     * 
     * @name Phaser.Geom.LINE
     * @type {integer}
     * @since 3.19.0
     */
    LINE: 2,

    /**
     * A Point Geometry object type.
     * 
     * @name Phaser.Geom.POINT
     * @type {integer}
     * @since 3.19.0
     */
    POINT: 3,

    /**
     * A Polygon Geometry object type.
     * 
     * @name Phaser.Geom.POLYGON
     * @type {integer}
     * @since 3.19.0
     */
    POLYGON: 4,

    /**
     * A Rectangle Geometry object type.
     * 
     * @name Phaser.Geom.RECTANGLE
     * @type {integer}
     * @since 3.19.0
     */
    RECTANGLE: 5,

    /**
     * A Triangle Geometry object type.
     * 
     * @name Phaser.Geom.TRIANGLE
     * @type {integer}
     * @since 3.19.0
     */
    TRIANGLE: 6

};

module.exports = GEOM_CONST;
