/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * Phaser Scale Manager constants for orientation.
 * 
 * @namespace Phaser.Scale.Orientation
 * @memberof Phaser.Scale
 * @since 3.16.0
 */

/**
 * Phaser Scale Manager constants for orientation.
 * 
 * To find out what each mode does please see [Phaser.Scale.Orientation]{@link Phaser.Scale.Orientation}.
 * 
 * @typedef {Phaser.Scale.Orientation} Phaser.Scale.OrientationType
 * @memberof Phaser.Scale
 * @since 3.16.0
 */

module.exports = {

    /**
     * A landscape orientation.
     * 
     * @name Phaser.Scale.Orientation.LANDSCAPE
     * @type {string}
     * @const
     * @since 3.16.0
     */
    LANDSCAPE: 'landscape-primary',

    /**
     * A portrait orientation.
     * 
     * @name Phaser.Scale.Orientation.PORTRAIT
     * @type {string}
     * @const
     * @since 3.16.0
     */
    PORTRAIT: 'portrait-primary'

};
