/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * Filter Types.
 *
 * @namespace Phaser.Textures.FilterMode
 * @memberof Phaser.Textures
 * @since 3.0.0
 */
var CONST = {

    /**
     * Linear filter type.
     * 
     * @name Phaser.Textures.FilterMode.LINEAR
     * @type {integer}
     * @const
     * @since 3.0.0
     */
    LINEAR: 0,

    /**
     * Nearest neighbor filter type.
     * 
     * @name Phaser.Textures.FilterMode.NEAREST
     * @type {integer}
     * @const
     * @since 3.0.0
     */
    NEAREST: 1
    
};

module.exports = CONST;
