/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * @namespace Phaser.Tilemaps.Components
 */

module.exports = {

    CalculateFacesAt: require('./CalculateFacesAt'),
    CalculateFacesWithin: require('./CalculateFacesWithin'),
    Copy: require('./Copy'),
    CreateFromTiles: require('./CreateFromTiles'),
    CullTiles: require('./CullTiles'),
    Fill: require('./Fill'),
    FilterTiles: require('./FilterTiles'),
    FindByIndex: require('./FindByIndex'),
    FindTile: require('./FindTile'),
    ForEachTile: require('./ForEachTile'),
    GetTileAt: require('./GetTileAt'),
    GetTileAtWorldXY: require('./GetTileAtWorldXY'),
    GetTilesWithin: require('./GetTilesWithin'),
    GetTilesWithinShape: require('./GetTilesWithinShape'),
    GetTilesWithinWorldXY: require('./GetTilesWithinWorldXY'),
    HasTileAt: require('./HasTileAt'),
    HasTileAtWorldXY: require('./HasTileAtWorldXY'),
    IsInLayerBounds: require('./IsInLayerBounds'),
    PutTileAt: require('./PutTileAt'),
    PutTileAtWorldXY: require('./PutTileAtWorldXY'),
    PutTilesAt: require('./PutTilesAt'),
    Randomize: require('./Randomize'),
    RemoveTileAt: require('./RemoveTileAt'),
    RemoveTileAtWorldXY: require('./RemoveTileAtWorldXY'),
    RenderDebug: require('./RenderDebug'),
    ReplaceByIndex: require('./ReplaceByIndex'),
    SetCollision: require('./SetCollision'),
    SetCollisionBetween: require('./SetCollisionBetween'),
    SetCollisionByExclusion: require('./SetCollisionByExclusion'),
    SetCollisionByProperty: require('./SetCollisionByProperty'),
    SetCollisionFromCollisionGroup: require('./SetCollisionFromCollisionGroup'),
    SetTileIndexCallback: require('./SetTileIndexCallback'),
    SetTileLocationCallback: require('./SetTileLocationCallback'),
    Shuffle: require('./Shuffle'),
    SwapByIndex: require('./SwapByIndex'),
    TileToWorldX: require('./TileToWorldX'),
    TileToWorldXY: require('./TileToWorldXY'),
    TileToWorldY: require('./TileToWorldY'),
    WeightedRandomize: require('./WeightedRandomize'),
    WorldToTileX: require('./WorldToTileX'),
    WorldToTileXY: require('./WorldToTileXY'),
    WorldToTileY: require('./WorldToTileY')

};
