/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * The Remove Animation Event.
 * 
 * This event is dispatched when an animation is removed from the global Animation Manager.
 *
 * @event Phaser.Animations.Events#REMOVE_ANIMATION
 * @since 3.0.0
 * 
 * @param {string} key - The key of the Animation that was removed from the global Animation Manager.
 * @param {Phaser.Animations.Animation} animation - An instance of the removed Animation.
 */
module.exports = 'remove';
