/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * The Game Blur Event.
 * 
 * This event is dispatched by the Game Visibility Handler when the window in which the Game instance is embedded
 * enters a blurred state. The blur event is raised when the window loses focus. This can happen if a user swaps
 * tab, or if they simply remove focus from the browser to another app.
 *
 * @event Phaser.Core.Events#BLUR
 * @since 3.0.0
 */
module.exports = 'blur';
