/**
 * @typedef {object} Phaser.Types.GameObjects.GameObjectConfig
 * @since 3.0.0
 *
 * @property {(number|object)} [x=0] - The x position of the Game Object.
 * @property {(number|object)} [y=0] - The y position of the Game Object.
 * @property {number} [depth=0] - The depth of the GameObject.
 * @property {boolean} [flipX=false] - The horizontally flipped state of the Game Object.
 * @property {boolean} [flipY=false] - The vertically flipped state of the Game Object.
 * @property {?(number|object)} [scale=null] - The scale of the GameObject.
 * @property {?(number|object)} [scrollFactor=null] - The scroll factor of the GameObject.
 * @property {(number|object)} [rotation=0] - The rotation angle of the Game Object, in radians.
 * @property {?(number|object)} [angle=null] - The rotation angle of the Game Object, in degrees.
 * @property {(number|object)} [alpha=1] - The alpha (opacity) of the Game Object.
 * @property {?(number|object)} [origin=null] - The origin of the Game Object.
 * @property {number} [scaleMode=ScaleModes.DEFAULT] - The scale mode of the GameObject.
 * @property {number} [blendMode=BlendModes.DEFAULT] - The blend mode of the GameObject.
 * @property {boolean} [visible=true] - The visible state of the Game Object.
 * @property {boolean} [add=true] - Add the GameObject to the scene.
 */
