/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * Tatar SNES USB Controller Gamepad Configuration.
 * USB Gamepad  (STANDARD GAMEPAD Vendor: 0079 Product: 0011)
 *
 * @name Phaser.Input.Gamepad.Configs.SNES_USB
 * @type {object}
 * @since 3.0.0
 */
module.exports = {

    UP: 12,
    DOWN: 13,
    LEFT: 14,
    RIGHT: 15,

    SELECT: 8,
    START: 9,

    B: 0,
    A: 1,
    Y: 2,
    X: 3,

    LEFT_SHOULDER: 4,
    RIGHT_SHOULDER: 5

};
