/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * Keyboard Codes.
 *
 * @namespace Phaser.Input.Keyboard.KeyCodes
 * @memberof Phaser.Input.Keyboard
 * @since 3.0.0
 */

var KeyCodes = {

    /**
     * The BACKSPACE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.BACKSPACE
     * @type {number}
     * @since 3.0.0
     */
    BACKSPACE: 8,

    /**
     * The TAB key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.TAB
     * @type {number}
     * @since 3.0.0
     */
    TAB: 9,

    /**
     * The ENTER key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.ENTER
     * @type {number}
     * @since 3.0.0
     */
    ENTER: 13,

    /**
     * The SHIFT key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.SHIFT
     * @type {number}
     * @since 3.0.0
     */
    SHIFT: 16,

    /**
     * The CTRL key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.CTRL
     * @type {number}
     * @since 3.0.0
     */
    CTRL: 17,

    /**
     * The ALT key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.ALT
     * @type {number}
     * @since 3.0.0
     */
    ALT: 18,

    /**
     * The PAUSE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.PAUSE
     * @type {number}
     * @since 3.0.0
     */
    PAUSE: 19,

    /**
     * The CAPS_LOCK key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.CAPS_LOCK
     * @type {number}
     * @since 3.0.0
     */
    CAPS_LOCK: 20,

    /**
     * The ESC key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.ESC
     * @type {number}
     * @since 3.0.0
     */
    ESC: 27,

    /**
     * The SPACE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.SPACE
     * @type {number}
     * @since 3.0.0
     */
    SPACE: 32,

    /**
     * The PAGE_UP key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.PAGE_UP
     * @type {number}
     * @since 3.0.0
     */
    PAGE_UP: 33,

    /**
     * The PAGE_DOWN key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.PAGE_DOWN
     * @type {number}
     * @since 3.0.0
     */
    PAGE_DOWN: 34,

    /**
     * The END key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.END
     * @type {number}
     * @since 3.0.0
     */
    END: 35,

    /**
     * The HOME key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.HOME
     * @type {number}
     * @since 3.0.0
     */
    HOME: 36,

    /**
     * The LEFT key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.LEFT
     * @type {number}
     * @since 3.0.0
     */
    LEFT: 37,

    /**
     * The UP key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.UP
     * @type {number}
     * @since 3.0.0
     */
    UP: 38,

    /**
     * The RIGHT key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.RIGHT
     * @type {number}
     * @since 3.0.0
     */
    RIGHT: 39,

    /**
     * The DOWN key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.DOWN
     * @type {number}
     * @since 3.0.0
     */
    DOWN: 40,

    /**
     * The PRINT_SCREEN key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.PRINT_SCREEN
     * @type {number}
     * @since 3.0.0
     */
    PRINT_SCREEN: 42,

    /**
     * The INSERT key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.INSERT
     * @type {number}
     * @since 3.0.0
     */
    INSERT: 45,

    /**
     * The DELETE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.DELETE
     * @type {number}
     * @since 3.0.0
     */
    DELETE: 46,

    /**
     * The ZERO key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.ZERO
     * @type {number}
     * @since 3.0.0
     */
    ZERO: 48,

    /**
     * The ONE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.ONE
     * @type {number}
     * @since 3.0.0
     */
    ONE: 49,

    /**
     * The TWO key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.TWO
     * @type {number}
     * @since 3.0.0
     */
    TWO: 50,

    /**
     * The THREE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.THREE
     * @type {number}
     * @since 3.0.0
     */
    THREE: 51,

    /**
     * The FOUR key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.FOUR
     * @type {number}
     * @since 3.0.0
     */
    FOUR: 52,

    /**
     * The FIVE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.FIVE
     * @type {number}
     * @since 3.0.0
     */
    FIVE: 53,

    /**
     * The SIX key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.SIX
     * @type {number}
     * @since 3.0.0
     */
    SIX: 54,

    /**
     * The SEVEN key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.SEVEN
     * @type {number}
     * @since 3.0.0
     */
    SEVEN: 55,

    /**
     * The EIGHT key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.EIGHT
     * @type {number}
     * @since 3.0.0
     */
    EIGHT: 56,

    /**
     * The NINE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NINE
     * @type {number}
     * @since 3.0.0
     */
    NINE: 57,

    /**
     * The NUMPAD_ZERO key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_ZERO
     * @type {number}
     * @since 3.0.0
     */
    NUMPAD_ZERO: 96,

    /**
     * The NUMPAD_ONE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_ONE
     * @type {number}
     * @since 3.0.0
     */
    NUMPAD_ONE: 97,

    /**
     * The NUMPAD_TWO key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_TWO
     * @type {number}
     * @since 3.0.0
     */
    NUMPAD_TWO: 98,

    /**
     * The NUMPAD_THREE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_THREE
     * @type {number}
     * @since 3.0.0
     */
    NUMPAD_THREE: 99,

    /**
     * The NUMPAD_FOUR key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_FOUR
     * @type {number}
     * @since 3.0.0
     */
    NUMPAD_FOUR: 100,

    /**
     * The NUMPAD_FIVE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_FIVE
     * @type {number}
     * @since 3.0.0
     */
    NUMPAD_FIVE: 101,

    /**
     * The NUMPAD_SIX key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_SIX
     * @type {number}
     * @since 3.0.0
     */
    NUMPAD_SIX: 102,

    /**
     * The NUMPAD_SEVEN key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_SEVEN
     * @type {number}
     * @since 3.0.0
     */
    NUMPAD_SEVEN: 103,

    /**
     * The NUMPAD_EIGHT key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_EIGHT
     * @type {number}
     * @since 3.0.0
     */
    NUMPAD_EIGHT: 104,

    /**
     * The NUMPAD_NINE key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_NINE
     * @type {number}
     * @since 3.0.0
     */
    NUMPAD_NINE: 105,

    /**
     * The Numpad Addition (+) key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_ADD
     * @type {number}
     * @since 3.21.0
     */
    NUMPAD_ADD: 107,

    /**
     * The Numpad Subtraction (-) key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_SUBTRACT
     * @type {number}
     * @since 3.21.0
     */
    NUMPAD_SUBTRACT: 109,

    /**
     * The A key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.A
     * @type {number}
     * @since 3.0.0
     */
    A: 65,

    /**
     * The B key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.B
     * @type {number}
     * @since 3.0.0
     */
    B: 66,

    /**
     * The C key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.C
     * @type {number}
     * @since 3.0.0
     */
    C: 67,

    /**
     * The D key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.D
     * @type {number}
     * @since 3.0.0
     */
    D: 68,

    /**
     * The E key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.E
     * @type {number}
     * @since 3.0.0
     */
    E: 69,

    /**
     * The F key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F
     * @type {number}
     * @since 3.0.0
     */
    F: 70,

    /**
     * The G key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.G
     * @type {number}
     * @since 3.0.0
     */
    G: 71,

    /**
     * The H key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.H
     * @type {number}
     * @since 3.0.0
     */
    H: 72,

    /**
     * The I key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.I
     * @type {number}
     * @since 3.0.0
     */
    I: 73,

    /**
     * The J key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.J
     * @type {number}
     * @since 3.0.0
     */
    J: 74,

    /**
     * The K key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.K
     * @type {number}
     * @since 3.0.0
     */
    K: 75,

    /**
     * The L key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.L
     * @type {number}
     * @since 3.0.0
     */
    L: 76,

    /**
     * The M key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.M
     * @type {number}
     * @since 3.0.0
     */
    M: 77,

    /**
     * The N key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.N
     * @type {number}
     * @since 3.0.0
     */
    N: 78,

    /**
     * The O key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.O
     * @type {number}
     * @since 3.0.0
     */
    O: 79,

    /**
     * The P key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.P
     * @type {number}
     * @since 3.0.0
     */
    P: 80,

    /**
     * The Q key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.Q
     * @type {number}
     * @since 3.0.0
     */
    Q: 81,

    /**
     * The R key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.R
     * @type {number}
     * @since 3.0.0
     */
    R: 82,

    /**
     * The S key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.S
     * @type {number}
     * @since 3.0.0
     */
    S: 83,

    /**
     * The T key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.T
     * @type {number}
     * @since 3.0.0
     */
    T: 84,

    /**
     * The U key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.U
     * @type {number}
     * @since 3.0.0
     */
    U: 85,

    /**
     * The V key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.V
     * @type {number}
     * @since 3.0.0
     */
    V: 86,

    /**
     * The W key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.W
     * @type {number}
     * @since 3.0.0
     */
    W: 87,

    /**
     * The X key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.X
     * @type {number}
     * @since 3.0.0
     */
    X: 88,

    /**
     * The Y key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.Y
     * @type {number}
     * @since 3.0.0
     */
    Y: 89,

    /**
     * The Z key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.Z
     * @type {number}
     * @since 3.0.0
     */
    Z: 90,

    /**
     * The F1 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F1
     * @type {number}
     * @since 3.0.0
     */
    F1: 112,

    /**
     * The F2 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F2
     * @type {number}
     * @since 3.0.0
     */
    F2: 113,

    /**
     * The F3 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F3
     * @type {number}
     * @since 3.0.0
     */
    F3: 114,

    /**
     * The F4 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F4
     * @type {number}
     * @since 3.0.0
     */
    F4: 115,

    /**
     * The F5 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F5
     * @type {number}
     * @since 3.0.0
     */
    F5: 116,

    /**
     * The F6 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F6
     * @type {number}
     * @since 3.0.0
     */
    F6: 117,

    /**
     * The F7 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F7
     * @type {number}
     * @since 3.0.0
     */
    F7: 118,

    /**
     * The F8 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F8
     * @type {number}
     * @since 3.0.0
     */
    F8: 119,

    /**
     * The F9 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F9
     * @type {number}
     * @since 3.0.0
     */
    F9: 120,

    /**
     * The F10 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F10
     * @type {number}
     * @since 3.0.0
     */
    F10: 121,

    /**
     * The F11 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F11
     * @type {number}
     * @since 3.0.0
     */
    F11: 122,

    /**
     * The F12 key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.F12
     * @type {number}
     * @since 3.0.0
     */
    F12: 123,

    /**
     * The SEMICOLON key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.SEMICOLON
     * @type {number}
     * @since 3.0.0
     */
    SEMICOLON: 186,

    /**
     * The PLUS key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.PLUS
     * @type {number}
     * @since 3.0.0
     */
    PLUS: 187,

    /**
     * The COMMA key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.COMMA
     * @type {number}
     * @since 3.0.0
     */
    COMMA: 188,

    /**
     * The MINUS key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.MINUS
     * @type {number}
     * @since 3.0.0
     */
    MINUS: 189,

    /**
     * The PERIOD key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.PERIOD
     * @type {number}
     * @since 3.0.0
     */
    PERIOD: 190,

    /**
     * The FORWARD_SLASH key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.FORWARD_SLASH
     * @type {number}
     * @since 3.0.0
     */
    FORWARD_SLASH: 191,

    /**
     * The BACK_SLASH key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.BACK_SLASH
     * @type {number}
     * @since 3.0.0
     */
    BACK_SLASH: 220,

    /**
     * The QUOTES key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.QUOTES
     * @type {number}
     * @since 3.0.0
     */
    QUOTES: 222,

    /**
     * The BACKTICK key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.BACKTICK
     * @type {number}
     * @since 3.0.0
     */
    BACKTICK: 192,

    /**
     * The OPEN_BRACKET key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.OPEN_BRACKET
     * @type {number}
     * @since 3.0.0
     */
    OPEN_BRACKET: 219,

    /**
     * The CLOSED_BRACKET key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.CLOSED_BRACKET
     * @type {number}
     * @since 3.0.0
     */
    CLOSED_BRACKET: 221,

    /**
     * The SEMICOLON_FIREFOX key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.SEMICOLON_FIREFOX
     * @type {number}
     * @since 3.0.0
     */
    SEMICOLON_FIREFOX: 59,

    /**
     * The COLON key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.COLON
     * @type {number}
     * @since 3.0.0
     */
    COLON: 58,

    /**
     * The COMMA_FIREFOX_WINDOWS key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.COMMA_FIREFOX_WINDOWS
     * @type {number}
     * @since 3.0.0
     */
    COMMA_FIREFOX_WINDOWS: 60,

    /**
     * The COMMA_FIREFOX key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.COMMA_FIREFOX
     * @type {number}
     * @since 3.0.0
     */
    COMMA_FIREFOX: 62,

    /**
     * The BRACKET_RIGHT_FIREFOX key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.BRACKET_RIGHT_FIREFOX
     * @type {number}
     * @since 3.0.0
     */
    BRACKET_RIGHT_FIREFOX: 174,

    /**
     * The BRACKET_LEFT_FIREFOX key.
     * 
     * @name Phaser.Input.Keyboard.KeyCodes.BRACKET_LEFT_FIREFOX
     * @type {number}
     * @since 3.0.0
     */
    BRACKET_LEFT_FIREFOX: 175
};

module.exports = KeyCodes;
