/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * The Renderer Resize Event.
 *
 * This event is dispatched by the Phaser Renderer when it is resized, usually as a result
 * of the Scale Manager resizing.
 *
 * @event Phaser.Renderer.Events#RESIZE
 * @since 3.50.0
 *
 * @param {number} width - The new width of the renderer.
 * @param {number} height - The new height of the renderer.
 */
module.exports = 'resize';
