/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

var PIPELINE_CONST = {

    /**
     * The Bitmap Mask Pipeline.
     *
     * @name Phaser.Renderer.WebGL.Pipelines.BITMAPMASK_PIPELINE
     * @type {string}
     * @const
     * @since 3.50.0
     */
    BITMAPMASK_PIPELINE: 'BitmapMaskPipeline',

    /**
     * The Light 2D Pipeline.
     *
     * @name Phaser.Renderer.WebGL.Pipelines.LIGHT_PIPELINE
     * @type {string}
     * @const
     * @since 3.50.0
     */
    LIGHT_PIPELINE: 'Light2D',

    /**
     * The Point Light Pipeline.
     *
     * @name Phaser.Renderer.WebGL.Pipelines.POINTLIGHT_PIPELINE
     * @type {string}
     * @const
     * @since 3.50.0
     */
    POINTLIGHT_PIPELINE: 'PointLightPipeline',

    /**
     * The Single Texture Pipeline.
     *
     * @name Phaser.Renderer.WebGL.Pipelines.SINGLE_PIPELINE
     * @type {string}
     * @const
     * @since 3.50.0
     */
    SINGLE_PIPELINE: 'SinglePipeline',

    /**
     * The Multi Texture Pipeline.
     *
     * @name Phaser.Renderer.WebGL.Pipelines.MULTI_PIPELINE
     * @type {string}
     * @const
     * @since 3.50.0
     */
    MULTI_PIPELINE: 'MultiPipeline',

    /**
     * The Rope Pipeline.
     *
     * @name Phaser.Renderer.WebGL.Pipelines.ROPE_PIPELINE
     * @type {string}
     * @const
     * @since 3.50.0
     */
    ROPE_PIPELINE: 'RopePipeline',

    /**
     * The Graphics and Shapes Pipeline.
     *
     * @name Phaser.Renderer.WebGL.Pipelines.GRAPHICS_PIPELINE
     * @type {string}
     * @const
     * @since 3.50.0
     */
    GRAPHICS_PIPELINE: 'GraphicsPipeline',

    /**
     * The Post FX Pipeline.
     *
     * @name Phaser.Renderer.WebGL.Pipelines.POSTFX_PIPELINE
     * @type {string}
     * @const
     * @since 3.50.0
     */
    POSTFX_PIPELINE: 'PostFXPipeline',

    /**
     * The Utility Pipeline.
     *
     * @name Phaser.Renderer.WebGL.Pipelines.UTILITY_PIPELINE
     * @type {string}
     * @const
     * @since 3.50.0
     */
    UTILITY_PIPELINE: 'UtilityPipeline'
};

module.exports = PIPELINE_CONST;
