/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * The WebGLPipeline Resize Event.
 *
 * This event is dispatched by a WebGLPipeline when it is resized, usually as a result
 * of the Renderer resizing.
 *
 * @event Phaser.Renderer.WebGL.Pipelines.Events#RESIZE
 * @since 3.50.0
 *
 * @param {number} width - The new width of the pipeline.
 * @param {number} height - The new height of the pipeline.
 * @param {Phaser.Renderer.WebGL.WebGLPipeline} pipeline - The pipeline that was resized.
 */
module.exports = 'pipelineresize';
