/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * Scene consts.
 * 
 * @ignore
 */

var CONST = {

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.PENDING
     * @readonly
     * @type {number}
     * @since 3.0.0
     */
    PENDING: 0,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.INIT
     * @readonly
     * @type {number}
     * @since 3.0.0
     */
    INIT: 1,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.START
     * @readonly
     * @type {number}
     * @since 3.0.0
     */
    START: 2,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.LOADING
     * @readonly
     * @type {number}
     * @since 3.0.0
     */
    LOADING: 3,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.CREATING
     * @readonly
     * @type {number}
     * @since 3.0.0
     */
    CREATING: 4,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.RUNNING
     * @readonly
     * @type {number}
     * @since 3.0.0
     */
    RUNNING: 5,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.PAUSED
     * @readonly
     * @type {number}
     * @since 3.0.0
     */
    PAUSED: 6,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.SLEEPING
     * @readonly
     * @type {number}
     * @since 3.0.0
     */
    SLEEPING: 7,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.SHUTDOWN
     * @readonly
     * @type {number}
     * @since 3.0.0
     */
    SHUTDOWN: 8,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.DESTROYED
     * @readonly
     * @type {number}
     * @since 3.0.0
     */
    DESTROYED: 9

};

module.exports = CONST;
