/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2020 Photon Storm Ltd.
 * @license      {@link https://opensource.org/licenses/MIT|MIT License}
 */

/**
 * @namespace Phaser.Tilemaps.Components
 */

module.exports = {

    CalculateFacesAt: require('./CalculateFacesAt'),
    CalculateFacesWithin: require('./CalculateFacesWithin'),
    CheckIsoBounds: require('./CheckIsoBounds'),
    Copy: require('./Copy'),
    CreateFromTiles: require('./CreateFromTiles'),
    CullBounds: require('./CullBounds'),
    CullTiles: require('./CullTiles'),
    Fill: require('./Fill'),
    FilterTiles: require('./FilterTiles'),
    FindByIndex: require('./FindByIndex'),
    FindTile: require('./FindTile'),
    ForEachTile: require('./ForEachTile'),
    GetCullTilesFunction: require('./GetCullTilesFunction'),
    GetTileAt: require('./GetTileAt'),
    GetTileAtWorldXY: require('./GetTileAtWorldXY'),
    GetTilesWithin: require('./GetTilesWithin'),
    GetTilesWithinShape: require('./GetTilesWithinShape'),
    GetTilesWithinWorldXY: require('./GetTilesWithinWorldXY'),
    GetTileToWorldXFunction: require('./GetTileToWorldXFunction'),
    GetTileToWorldXYFunction: require('./GetTileToWorldXYFunction'),
    GetTileToWorldYFunction: require('./GetTileToWorldYFunction'),
    GetWorldToTileXFunction: require('./GetWorldToTileXFunction'),
    GetWorldToTileXYFunction: require('./GetWorldToTileXYFunction'),
    GetWorldToTileYFunction: require('./GetWorldToTileYFunction'),
    HasTileAt: require('./HasTileAt'),
    HasTileAtWorldXY: require('./HasTileAtWorldXY'),
    HexagonalCullBounds: require('./HexagonalCullBounds'),
    HexagonalCullTiles: require('./HexagonalCullTiles'),
    HexagonalTileToWorldXY: require('./HexagonalTileToWorldXY'),
    HexagonalTileToWorldY: require('./HexagonalTileToWorldY'),
    HexagonalWorldToTileXY: require('./HexagonalWorldToTileXY'),
    HexagonalWorldToTileY: require('./HexagonalWorldToTileY'),
    IsInLayerBounds: require('./IsInLayerBounds'),
    IsometricCullTiles: require('./IsometricCullTiles'),
    IsometricTileToWorldXY: require('./IsometricTileToWorldXY'),
    IsometricWorldToTileXY: require('./IsometricWorldToTileXY'),
    PutTileAt: require('./PutTileAt'),
    PutTileAtWorldXY: require('./PutTileAtWorldXY'),
    PutTilesAt: require('./PutTilesAt'),
    Randomize: require('./Randomize'),
    RemoveTileAt: require('./RemoveTileAt'),
    RemoveTileAtWorldXY: require('./RemoveTileAtWorldXY'),
    RenderDebug: require('./RenderDebug'),
    ReplaceByIndex: require('./ReplaceByIndex'),
    RunCull: require('./RunCull'),
    SetCollision: require('./SetCollision'),
    SetCollisionBetween: require('./SetCollisionBetween'),
    SetCollisionByExclusion: require('./SetCollisionByExclusion'),
    SetCollisionByProperty: require('./SetCollisionByProperty'),
    SetCollisionFromCollisionGroup: require('./SetCollisionFromCollisionGroup'),
    SetLayerCollisionIndex: require('./SetLayerCollisionIndex'),
    SetTileCollision: require('./SetTileCollision'),
    SetTileIndexCallback: require('./SetTileIndexCallback'),
    SetTileLocationCallback: require('./SetTileLocationCallback'),
    Shuffle: require('./Shuffle'),
    StaggeredCullBounds: require('./StaggeredCullBounds'),
    StaggeredCullTiles: require('./StaggeredCullTiles'),
    StaggeredTileToWorldXY: require('./StaggeredTileToWorldXY'),
    StaggeredTileToWorldY: require('./StaggeredTileToWorldY'),
    StaggeredWorldToTileXY: require('./StaggeredWorldToTileXY'),
    StaggeredWorldToTileY: require('./StaggeredWorldToTileY'),
    SwapByIndex: require('./SwapByIndex'),
    TileToWorldX: require('./TileToWorldX'),
    TileToWorldXY: require('./TileToWorldXY'),
    TileToWorldY: require('./TileToWorldY'),
    WeightedRandomize: require('./WeightedRandomize'),
    WorldToTileX: require('./WorldToTileX'),
    WorldToTileXY: require('./WorldToTileXY'),
    WorldToTileY: require('./WorldToTileY')

};
