# Contributing to Pico

Thanks for your interest in contributing to Pico CSS! Please take a moment to review this document before submitting a [bug report](https://github.com/picocss/pico/issues) or a [pull request](https://github.com/picocss/pico/pulls).

## Bug reports

The [issue tracker]((https://github.com/picocss/pico/issues)) is the preferred channel for bug reports, but please respect the following restrictions:
- Please do not use the issue tracker for personal support requests. [Open a question in our discussion forums](https://github.com/picocss/pico/discussions/categories/help) instead.
- Please do not use the issue tracker for feature requests.  Instead, use our discussion forums to [suggest any ideas](https://github.com/picocss/pico/discussions/categories/ideas) you have.

## Pull requests

Good pull requests, patches, improvements, and new features are a fantastic help.

**Please ask before starting work on any significant new features.**
We recommend that you first [suggest your feature idea in our discussion forums](https://github.com/picocss/pico/discussions/categories/ideas).

[`dev`](https://github.com/picocss/pico/tree/dev) branch is open for pull requests on `v2`.

[`v1-dev`](https://github.com/picocss/pico/tree/v1-dev) branch is open to pull requests on `v1`.

**Do not edit [`/css`](https://github.com/picocss/pico/tree/master/css) files directly.** Edit the source files in [`/scss`](https://github.com/picocss/pico/tree/master/scss), then recompile the [`/css`](https://github.com/picocss/pico/tree/master/css) files with `yarn build`.