// const { once } = require('node:events')
const { Piscina } = require('./dist')

const piscina = new Piscina({
  filename: require.resolve('./test/fixtures/async-iterator.js'),
  concurrentTasksPerWorker: 1,
  atomics: 'async',
})

;(async () => {
  const redeable = await piscina.run({ length: 10 })
  const chunks = [];
  // redeable.setEncoding('utf-8')
  redeable.on('data', chunk => {
    console.log('chunk', chunk)
    chunks.push(chunk)
  })

  redeable.on('end', () => {
    console.log('playgroound>> end - ', Buffer.concat(chunks).toString())
    process.exit(0)
  })
})()
