/*!
 * PixiJS - v8.6.2
 * Compiled Fri, 29 Nov 2024 15:30:15 UTC
 *
 * PixiJS is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
var PIXI = (function (exports) {
    'use strict';

    "use strict";
    const BrowserAdapter = {
      createCanvas: (width, height) => {
        const canvas = document.createElement("canvas");
        canvas.width = width;
        canvas.height = height;
        return canvas;
      },
      getCanvasRenderingContext2D: () => CanvasRenderingContext2D,
      getWebGLRenderingContext: () => WebGLRenderingContext,
      getNavigator: () => navigator,
      getBaseUrl: () => {
        var _a;
        return (_a = document.baseURI) != null ? _a : window.location.href;
      },
      getFontFaceSet: () => document.fonts,
      fetch: (url, options) => fetch(url, options),
      parseXML: (xml) => {
        const parser = new DOMParser();
        return parser.parseFromString(xml, "text/xml");
      }
    };

    "use strict";
    let currentAdapter = BrowserAdapter;
    const DOMAdapter = {
      /**
       * Returns the current adapter.
       * @returns {environment.Adapter} The current adapter.
       */
      get() {
        return currentAdapter;
      },
      /**
       * Sets the current adapter.
       * @param adapter - The new adapter.
       */
      set(adapter) {
        currentAdapter = adapter;
      }
    };

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    function getDefaultExportFromCjs (x) {
    	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
    }

    function getDefaultExportFromNamespaceIfPresent (n) {
    	return n && Object.prototype.hasOwnProperty.call(n, 'default') ? n['default'] : n;
    }

    function getDefaultExportFromNamespaceIfNotNamed (n) {
    	return n && Object.prototype.hasOwnProperty.call(n, 'default') && Object.keys(n).length === 1 ? n['default'] : n;
    }

    function getAugmentedNamespace(n) {
      if (n.__esModule) return n;
      var f = n.default;
    	if (typeof f == "function") {
    		var a = function a () {
    			if (this instanceof a) {
            return Reflect.construct(f, arguments, this.constructor);
    			}
    			return f.apply(this, arguments);
    		};
    		a.prototype = f.prototype;
      } else a = {};
      Object.defineProperty(a, '__esModule', {value: true});
    	Object.keys(n).forEach(function (k) {
    		var d = Object.getOwnPropertyDescriptor(n, k);
    		Object.defineProperty(a, k, d.get ? d : {
    			enumerable: true,
    			get: function () {
    				return n[k];
    			}
    		});
    	});
    	return a;
    }

    var lib = {};

    var dom$2 = {};

    var conventions$2 = {};

    'use strict';

    /**
     * Ponyfill for `Array.prototype.find` which is only available in ES6 runtimes.
     *
     * Works with anything that has a `length` property and index access properties, including NodeList.
     *
     * @template {unknown} T
     * @param {Array<T> | ({length:number, [number]: T})} list
     * @param {function (item: T, index: number, list:Array<T> | ({length:number, [number]: T})):boolean} predicate
     * @param {Partial<Pick<ArrayConstructor['prototype'], 'find'>>?} ac `Array.prototype` by default,
     * 				allows injecting a custom implementation in tests
     * @returns {T | undefined}
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/find
     * @see https://tc39.es/ecma262/multipage/indexed-collections.html#sec-array.prototype.find
     */
    function find$1(list, predicate, ac) {
    	if (ac === undefined) {
    		ac = Array.prototype;
    	}
    	if (list && typeof ac.find === 'function') {
    		return ac.find.call(list, predicate);
    	}
    	for (var i = 0; i < list.length; i++) {
    		if (Object.prototype.hasOwnProperty.call(list, i)) {
    			var item = list[i];
    			if (predicate.call(undefined, item, i, list)) {
    				return item;
    			}
    		}
    	}
    }

    /**
     * "Shallow freezes" an object to render it immutable.
     * Uses `Object.freeze` if available,
     * otherwise the immutability is only in the type.
     *
     * Is used to create "enum like" objects.
     *
     * @template T
     * @param {T} object the object to freeze
     * @param {Pick<ObjectConstructor, 'freeze'> = Object} oc `Object` by default,
     * 				allows to inject custom object constructor for tests
     * @returns {Readonly<T>}
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/freeze
     */
    function freeze(object, oc) {
    	if (oc === undefined) {
    		oc = Object;
    	}
    	return oc && typeof oc.freeze === 'function' ? oc.freeze(object) : object
    }

    /**
     * Since we can not rely on `Object.assign` we provide a simplified version
     * that is sufficient for our needs.
     *
     * @param {Object} target
     * @param {Object | null | undefined} source
     *
     * @returns {Object} target
     * @throws TypeError if target is not an object
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/assign
     * @see https://tc39.es/ecma262/multipage/fundamental-objects.html#sec-object.assign
     */
    function assign(target, source) {
    	if (target === null || typeof target !== 'object') {
    		throw new TypeError('target is not an object')
    	}
    	for (var key in source) {
    		if (Object.prototype.hasOwnProperty.call(source, key)) {
    			target[key] = source[key];
    		}
    	}
    	return target
    }

    /**
     * All mime types that are allowed as input to `DOMParser.parseFromString`
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser/parseFromString#Argument02 MDN
     * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#domparsersupportedtype WHATWG HTML Spec
     * @see DOMParser.prototype.parseFromString
     */
    var MIME_TYPE = freeze({
    	/**
    	 * `text/html`, the only mime type that triggers treating an XML document as HTML.
    	 *
    	 * @see DOMParser.SupportedType.isHTML
    	 * @see https://www.iana.org/assignments/media-types/text/html IANA MimeType registration
    	 * @see https://en.wikipedia.org/wiki/HTML Wikipedia
    	 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser/parseFromString MDN
    	 * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-domparser-parsefromstring WHATWG HTML Spec
    	 */
    	HTML: 'text/html',

    	/**
    	 * Helper method to check a mime type if it indicates an HTML document
    	 *
    	 * @param {string} [value]
    	 * @returns {boolean}
    	 *
    	 * @see https://www.iana.org/assignments/media-types/text/html IANA MimeType registration
    	 * @see https://en.wikipedia.org/wiki/HTML Wikipedia
    	 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser/parseFromString MDN
    	 * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-domparser-parsefromstring 	 */
    	isHTML: function (value) {
    		return value === MIME_TYPE.HTML
    	},

    	/**
    	 * `application/xml`, the standard mime type for XML documents.
    	 *
    	 * @see https://www.iana.org/assignments/media-types/application/xml IANA MimeType registration
    	 * @see https://tools.ietf.org/html/rfc7303#section-9.1 RFC 7303
    	 * @see https://en.wikipedia.org/wiki/XML_and_MIME Wikipedia
    	 */
    	XML_APPLICATION: 'application/xml',

    	/**
    	 * `text/html`, an alias for `application/xml`.
    	 *
    	 * @see https://tools.ietf.org/html/rfc7303#section-9.2 RFC 7303
    	 * @see https://www.iana.org/assignments/media-types/text/xml IANA MimeType registration
    	 * @see https://en.wikipedia.org/wiki/XML_and_MIME Wikipedia
    	 */
    	XML_TEXT: 'text/xml',

    	/**
    	 * `application/xhtml+xml`, indicates an XML document that has the default HTML namespace,
    	 * but is parsed as an XML document.
    	 *
    	 * @see https://www.iana.org/assignments/media-types/application/xhtml+xml IANA MimeType registration
    	 * @see https://dom.spec.whatwg.org/#dom-domimplementation-createdocument WHATWG DOM Spec
    	 * @see https://en.wikipedia.org/wiki/XHTML Wikipedia
    	 */
    	XML_XHTML_APPLICATION: 'application/xhtml+xml',

    	/**
    	 * `image/svg+xml`,
    	 *
    	 * @see https://www.iana.org/assignments/media-types/image/svg+xml IANA MimeType registration
    	 * @see https://www.w3.org/TR/SVG11/ W3C SVG 1.1
    	 * @see https://en.wikipedia.org/wiki/Scalable_Vector_Graphics Wikipedia
    	 */
    	XML_SVG_IMAGE: 'image/svg+xml',
    });

    /**
     * Namespaces that are used in this code base.
     *
     * @see http://www.w3.org/TR/REC-xml-names
     */
    var NAMESPACE$3 = freeze({
    	/**
    	 * The XHTML namespace.
    	 *
    	 * @see http://www.w3.org/1999/xhtml
    	 */
    	HTML: 'http://www.w3.org/1999/xhtml',

    	/**
    	 * Checks if `uri` equals `NAMESPACE.HTML`.
    	 *
    	 * @param {string} [uri]
    	 *
    	 * @see NAMESPACE.HTML
    	 */
    	isHTML: function (uri) {
    		return uri === NAMESPACE$3.HTML
    	},

    	/**
    	 * The SVG namespace.
    	 *
    	 * @see http://www.w3.org/2000/svg
    	 */
    	SVG: 'http://www.w3.org/2000/svg',

    	/**
    	 * The `xml:` namespace.
    	 *
    	 * @see http://www.w3.org/XML/1998/namespace
    	 */
    	XML: 'http://www.w3.org/XML/1998/namespace',

    	/**
    	 * The `xmlns:` namespace
    	 *
    	 * @see https://www.w3.org/2000/xmlns/
    	 */
    	XMLNS: 'http://www.w3.org/2000/xmlns/',
    });

    var assign_1 = conventions$2.assign = assign;
    var find_1 = conventions$2.find = find$1;
    var freeze_1 = conventions$2.freeze = freeze;
    var MIME_TYPE_1 = conventions$2.MIME_TYPE = MIME_TYPE;
    var NAMESPACE_1 = conventions$2.NAMESPACE = NAMESPACE$3;

    var conventions$1 = conventions$2;

    var find = conventions$1.find;
    var NAMESPACE$2 = conventions$1.NAMESPACE;

    /**
     * A prerequisite for `[].filter`, to drop elements that are empty
     * @param {string} input
     * @returns {boolean}
     */
    function notEmptyString (input) {
    	return input !== ''
    }
    /**
     * @see https://infra.spec.whatwg.org/#split-on-ascii-whitespace
     * @see https://infra.spec.whatwg.org/#ascii-whitespace
     *
     * @param {string} input
     * @returns {string[]} (can be empty)
     */
    function splitOnASCIIWhitespace(input) {
    	// U+0009 TAB, U+000A LF, U+000C FF, U+000D CR, U+0020 SPACE
    	return input ? input.split(/[\t\n\f\r ]+/).filter(notEmptyString) : []
    }

    /**
     * Adds element as a key to current if it is not already present.
     *
     * @param {Record<string, boolean | undefined>} current
     * @param {string} element
     * @returns {Record<string, boolean | undefined>}
     */
    function orderedSetReducer (current, element) {
    	if (!current.hasOwnProperty(element)) {
    		current[element] = true;
    	}
    	return current;
    }

    /**
     * @see https://infra.spec.whatwg.org/#ordered-set
     * @param {string} input
     * @returns {string[]}
     */
    function toOrderedSet(input) {
    	if (!input) return [];
    	var list = splitOnASCIIWhitespace(input);
    	return Object.keys(list.reduce(orderedSetReducer, {}))
    }

    /**
     * Uses `list.indexOf` to implement something like `Array.prototype.includes`,
     * which we can not rely on being available.
     *
     * @param {any[]} list
     * @returns {function(any): boolean}
     */
    function arrayIncludes (list) {
    	return function(element) {
    		return list && list.indexOf(element) !== -1;
    	}
    }

    function copy(src,dest){
    	for(var p in src){
    		if (Object.prototype.hasOwnProperty.call(src, p)) {
    			dest[p] = src[p];
    		}
    	}
    }

    /**
    ^\w+\.prototype\.([_\w]+)\s*=\s*((?:.*\{\s*?[\r\n][\s\S]*?^})|\S.*?(?=[;\r\n]));?
    ^\w+\.prototype\.([_\w]+)\s*=\s*(\S.*?(?=[;\r\n]));?
     */
    function _extends(Class,Super){
    	var pt = Class.prototype;
    	if(!(pt instanceof Super)){
    		function t(){};
    		t.prototype = Super.prototype;
    		t = new t();
    		copy(pt,t);
    		Class.prototype = pt = t;
    	}
    	if(pt.constructor != Class){
    		if(typeof Class != 'function'){
    			console.error("unknown Class:"+Class);
    		}
    		pt.constructor = Class;
    	}
    }

    // Node Types
    var NodeType = {};
    var ELEMENT_NODE                = NodeType.ELEMENT_NODE                = 1;
    var ATTRIBUTE_NODE              = NodeType.ATTRIBUTE_NODE              = 2;
    var TEXT_NODE                   = NodeType.TEXT_NODE                   = 3;
    var CDATA_SECTION_NODE          = NodeType.CDATA_SECTION_NODE          = 4;
    var ENTITY_REFERENCE_NODE       = NodeType.ENTITY_REFERENCE_NODE       = 5;
    var ENTITY_NODE                 = NodeType.ENTITY_NODE                 = 6;
    var PROCESSING_INSTRUCTION_NODE = NodeType.PROCESSING_INSTRUCTION_NODE = 7;
    var COMMENT_NODE                = NodeType.COMMENT_NODE                = 8;
    var DOCUMENT_NODE               = NodeType.DOCUMENT_NODE               = 9;
    var DOCUMENT_TYPE_NODE          = NodeType.DOCUMENT_TYPE_NODE          = 10;
    var DOCUMENT_FRAGMENT_NODE      = NodeType.DOCUMENT_FRAGMENT_NODE      = 11;
    var NOTATION_NODE               = NodeType.NOTATION_NODE               = 12;

    // ExceptionCode
    var ExceptionCode = {};
    var ExceptionMessage = {};
    var INDEX_SIZE_ERR              = ExceptionCode.INDEX_SIZE_ERR              = ((ExceptionMessage[1]="Index size error"),1);
    var DOMSTRING_SIZE_ERR          = ExceptionCode.DOMSTRING_SIZE_ERR          = ((ExceptionMessage[2]="DOMString size error"),2);
    var HIERARCHY_REQUEST_ERR       = ExceptionCode.HIERARCHY_REQUEST_ERR       = ((ExceptionMessage[3]="Hierarchy request error"),3);
    var WRONG_DOCUMENT_ERR          = ExceptionCode.WRONG_DOCUMENT_ERR          = ((ExceptionMessage[4]="Wrong document"),4);
    var INVALID_CHARACTER_ERR       = ExceptionCode.INVALID_CHARACTER_ERR       = ((ExceptionMessage[5]="Invalid character"),5);
    var NO_DATA_ALLOWED_ERR         = ExceptionCode.NO_DATA_ALLOWED_ERR         = ((ExceptionMessage[6]="No data allowed"),6);
    var NO_MODIFICATION_ALLOWED_ERR = ExceptionCode.NO_MODIFICATION_ALLOWED_ERR = ((ExceptionMessage[7]="No modification allowed"),7);
    var NOT_FOUND_ERR               = ExceptionCode.NOT_FOUND_ERR               = ((ExceptionMessage[8]="Not found"),8);
    var NOT_SUPPORTED_ERR           = ExceptionCode.NOT_SUPPORTED_ERR           = ((ExceptionMessage[9]="Not supported"),9);
    var INUSE_ATTRIBUTE_ERR         = ExceptionCode.INUSE_ATTRIBUTE_ERR         = ((ExceptionMessage[10]="Attribute in use"),10);
    //level2
    var INVALID_STATE_ERR        	= ExceptionCode.INVALID_STATE_ERR        	= ((ExceptionMessage[11]="Invalid state"),11);
    var SYNTAX_ERR               	= ExceptionCode.SYNTAX_ERR               	= ((ExceptionMessage[12]="Syntax error"),12);
    var INVALID_MODIFICATION_ERR 	= ExceptionCode.INVALID_MODIFICATION_ERR 	= ((ExceptionMessage[13]="Invalid modification"),13);
    var NAMESPACE_ERR            	= ExceptionCode.NAMESPACE_ERR           	= ((ExceptionMessage[14]="Invalid namespace"),14);
    var INVALID_ACCESS_ERR       	= ExceptionCode.INVALID_ACCESS_ERR      	= ((ExceptionMessage[15]="Invalid access"),15);

    /**
     * DOM Level 2
     * Object DOMException
     * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html
     * @see http://www.w3.org/TR/REC-DOM-Level-1/ecma-script-language-binding.html
     */
    function DOMException(code, message) {
    	if(message instanceof Error){
    		var error = message;
    	}else {
    		error = this;
    		Error.call(this, ExceptionMessage[code]);
    		this.message = ExceptionMessage[code];
    		if(Error.captureStackTrace) Error.captureStackTrace(this, DOMException);
    	}
    	error.code = code;
    	if(message) this.message = this.message + ": " + message;
    	return error;
    };
    DOMException.prototype = Error.prototype;
    copy(ExceptionCode,DOMException);

    /**
     * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/core.html#ID-536297177
     * The NodeList interface provides the abstraction of an ordered collection of nodes, without defining or constraining how this collection is implemented. NodeList objects in the DOM are live.
     * The items in the NodeList are accessible via an integral index, starting from 0.
     */
    function NodeList() {
    };
    NodeList.prototype = {
    	/**
    	 * The number of nodes in the list. The range of valid child node indices is 0 to length-1 inclusive.
    	 * @standard level1
    	 */
    	length:0,
    	/**
    	 * Returns the indexth item in the collection. If index is greater than or equal to the number of nodes in the list, this returns null.
    	 * @standard level1
    	 * @param index  unsigned long
    	 *   Index into the collection.
    	 * @return Node
    	 * 	The node at the indexth position in the NodeList, or null if that is not a valid index.
    	 */
    	item: function(index) {
    		return index >= 0 && index < this.length ? this[index] : null;
    	},
    	toString:function(isHTML,nodeFilter){
    		for(var buf = [], i = 0;i<this.length;i++){
    			serializeToString(this[i],buf,isHTML,nodeFilter);
    		}
    		return buf.join('');
    	},
    	/**
    	 * @private
    	 * @param {function (Node):boolean} predicate
    	 * @returns {Node[]}
    	 */
    	filter: function (predicate) {
    		return Array.prototype.filter.call(this, predicate);
    	},
    	/**
    	 * @private
    	 * @param {Node} item
    	 * @returns {number}
    	 */
    	indexOf: function (item) {
    		return Array.prototype.indexOf.call(this, item);
    	},
    };

    function LiveNodeList(node,refresh){
    	this._node = node;
    	this._refresh = refresh;
    	_updateLiveList(this);
    }
    function _updateLiveList(list){
    	var inc = list._node._inc || list._node.ownerDocument._inc;
    	if (list._inc !== inc) {
    		var ls = list._refresh(list._node);
    		__set__(list,'length',ls.length);
    		if (!list.$$length || ls.length < list.$$length) {
    			for (var i = ls.length; i in list; i++) {
    				if (Object.prototype.hasOwnProperty.call(list, i)) {
    					delete list[i];
    				}
    			}
    		}
    		copy(ls,list);
    		list._inc = inc;
    	}
    }
    LiveNodeList.prototype.item = function(i){
    	_updateLiveList(this);
    	return this[i] || null;
    };

    _extends(LiveNodeList,NodeList);

    /**
     * Objects implementing the NamedNodeMap interface are used
     * to represent collections of nodes that can be accessed by name.
     * Note that NamedNodeMap does not inherit from NodeList;
     * NamedNodeMaps are not maintained in any particular order.
     * Objects contained in an object implementing NamedNodeMap may also be accessed by an ordinal index,
     * but this is simply to allow convenient enumeration of the contents of a NamedNodeMap,
     * and does not imply that the DOM specifies an order to these Nodes.
     * NamedNodeMap objects in the DOM are live.
     * used for attributes or DocumentType entities
     */
    function NamedNodeMap() {
    };

    function _findNodeIndex(list,node){
    	var i = list.length;
    	while(i--){
    		if(list[i] === node){return i}
    	}
    }

    function _addNamedNode(el,list,newAttr,oldAttr){
    	if(oldAttr){
    		list[_findNodeIndex(list,oldAttr)] = newAttr;
    	}else {
    		list[list.length++] = newAttr;
    	}
    	if(el){
    		newAttr.ownerElement = el;
    		var doc = el.ownerDocument;
    		if(doc){
    			oldAttr && _onRemoveAttribute(doc,el,oldAttr);
    			_onAddAttribute(doc,el,newAttr);
    		}
    	}
    }
    function _removeNamedNode(el,list,attr){
    	//console.log('remove attr:'+attr)
    	var i = _findNodeIndex(list,attr);
    	if(i>=0){
    		var lastIndex = list.length-1;
    		while(i<lastIndex){
    			list[i] = list[++i];
    		}
    		list.length = lastIndex;
    		if(el){
    			var doc = el.ownerDocument;
    			if(doc){
    				_onRemoveAttribute(doc,el,attr);
    				attr.ownerElement = null;
    			}
    		}
    	}else {
    		throw new DOMException(NOT_FOUND_ERR,new Error(el.tagName+'@'+attr))
    	}
    }
    NamedNodeMap.prototype = {
    	length:0,
    	item:NodeList.prototype.item,
    	getNamedItem: function(key) {
    //		if(key.indexOf(':')>0 || key == 'xmlns'){
    //			return null;
    //		}
    		//console.log()
    		var i = this.length;
    		while(i--){
    			var attr = this[i];
    			//console.log(attr.nodeName,key)
    			if(attr.nodeName == key){
    				return attr;
    			}
    		}
    	},
    	setNamedItem: function(attr) {
    		var el = attr.ownerElement;
    		if(el && el!=this._ownerElement){
    			throw new DOMException(INUSE_ATTRIBUTE_ERR);
    		}
    		var oldAttr = this.getNamedItem(attr.nodeName);
    		_addNamedNode(this._ownerElement,this,attr,oldAttr);
    		return oldAttr;
    	},
    	/* returns Node */
    	setNamedItemNS: function(attr) {// raises: WRONG_DOCUMENT_ERR,NO_MODIFICATION_ALLOWED_ERR,INUSE_ATTRIBUTE_ERR
    		var el = attr.ownerElement, oldAttr;
    		if(el && el!=this._ownerElement){
    			throw new DOMException(INUSE_ATTRIBUTE_ERR);
    		}
    		oldAttr = this.getNamedItemNS(attr.namespaceURI,attr.localName);
    		_addNamedNode(this._ownerElement,this,attr,oldAttr);
    		return oldAttr;
    	},

    	/* returns Node */
    	removeNamedItem: function(key) {
    		var attr = this.getNamedItem(key);
    		_removeNamedNode(this._ownerElement,this,attr);
    		return attr;


    	},// raises: NOT_FOUND_ERR,NO_MODIFICATION_ALLOWED_ERR

    	//for level2
    	removeNamedItemNS:function(namespaceURI,localName){
    		var attr = this.getNamedItemNS(namespaceURI,localName);
    		_removeNamedNode(this._ownerElement,this,attr);
    		return attr;
    	},
    	getNamedItemNS: function(namespaceURI, localName) {
    		var i = this.length;
    		while(i--){
    			var node = this[i];
    			if(node.localName == localName && node.namespaceURI == namespaceURI){
    				return node;
    			}
    		}
    		return null;
    	}
    };

    /**
     * The DOMImplementation interface represents an object providing methods
     * which are not dependent on any particular document.
     * Such an object is returned by the `Document.implementation` property.
     *
     * __The individual methods describe the differences compared to the specs.__
     *
     * @constructor
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation MDN
     * @see https://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-102161490 DOM Level 1 Core (Initial)
     * @see https://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-102161490 DOM Level 2 Core
     * @see https://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-102161490 DOM Level 3 Core
     * @see https://dom.spec.whatwg.org/#domimplementation DOM Living Standard
     */
    function DOMImplementation$2() {
    }

    DOMImplementation$2.prototype = {
    	/**
    	 * The DOMImplementation.hasFeature() method returns a Boolean flag indicating if a given feature is supported.
    	 * The different implementations fairly diverged in what kind of features were reported.
    	 * The latest version of the spec settled to force this method to always return true, where the functionality was accurate and in use.
    	 *
    	 * @deprecated It is deprecated and modern browsers return true in all cases.
    	 *
    	 * @param {string} feature
    	 * @param {string} [version]
    	 * @returns {boolean} always true
    	 *
    	 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation/hasFeature MDN
    	 * @see https://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-5CED94D7 DOM Level 1 Core
    	 * @see https://dom.spec.whatwg.org/#dom-domimplementation-hasfeature DOM Living Standard
    	 */
    	hasFeature: function(feature, version) {
    			return true;
    	},
    	/**
    	 * Creates an XML Document object of the specified type with its document element.
    	 *
    	 * __It behaves slightly different from the description in the living standard__:
    	 * - There is no interface/class `XMLDocument`, it returns a `Document` instance.
    	 * - `contentType`, `encoding`, `mode`, `origin`, `url` fields are currently not declared.
    	 * - this implementation is not validating names or qualified names
    	 *   (when parsing XML strings, the SAX parser takes care of that)
    	 *
    	 * @param {string|null} namespaceURI
    	 * @param {string} qualifiedName
    	 * @param {DocumentType=null} doctype
    	 * @returns {Document}
    	 *
    	 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation/createDocument MDN
    	 * @see https://www.w3.org/TR/DOM-Level-2-Core/core.html#Level-2-Core-DOM-createDocument DOM Level 2 Core (initial)
    	 * @see https://dom.spec.whatwg.org/#dom-domimplementation-createdocument  DOM Level 2 Core
    	 *
    	 * @see https://dom.spec.whatwg.org/#validate-and-extract DOM: Validate and extract
    	 * @see https://www.w3.org/TR/xml/#NT-NameStartChar XML Spec: Names
    	 * @see https://www.w3.org/TR/xml-names/#ns-qualnames XML Namespaces: Qualified names
    	 */
    	createDocument: function(namespaceURI,  qualifiedName, doctype){
    		var doc = new Document();
    		doc.implementation = this;
    		doc.childNodes = new NodeList();
    		doc.doctype = doctype || null;
    		if (doctype){
    			doc.appendChild(doctype);
    		}
    		if (qualifiedName){
    			var root = doc.createElementNS(namespaceURI, qualifiedName);
    			doc.appendChild(root);
    		}
    		return doc;
    	},
    	/**
    	 * Returns a doctype, with the given `qualifiedName`, `publicId`, and `systemId`.
    	 *
    	 * __This behavior is slightly different from the in the specs__:
    	 * - this implementation is not validating names or qualified names
    	 *   (when parsing XML strings, the SAX parser takes care of that)
    	 *
    	 * @param {string} qualifiedName
    	 * @param {string} [publicId]
    	 * @param {string} [systemId]
    	 * @returns {DocumentType} which can either be used with `DOMImplementation.createDocument` upon document creation
    	 * 				  or can be put into the document via methods like `Node.insertBefore()` or `Node.replaceChild()`
    	 *
    	 * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation/createDocumentType MDN
    	 * @see https://www.w3.org/TR/DOM-Level-2-Core/core.html#Level-2-Core-DOM-createDocType DOM Level 2 Core
    	 * @see https://dom.spec.whatwg.org/#dom-domimplementation-createdocumenttype DOM Living Standard
    	 *
    	 * @see https://dom.spec.whatwg.org/#validate-and-extract DOM: Validate and extract
    	 * @see https://www.w3.org/TR/xml/#NT-NameStartChar XML Spec: Names
    	 * @see https://www.w3.org/TR/xml-names/#ns-qualnames XML Namespaces: Qualified names
    	 */
    	createDocumentType: function(qualifiedName, publicId, systemId){
    		var node = new DocumentType();
    		node.name = qualifiedName;
    		node.nodeName = qualifiedName;
    		node.publicId = publicId || '';
    		node.systemId = systemId || '';

    		return node;
    	}
    };


    /**
     * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/core.html#ID-1950641247
     */

    function Node$1() {
    };

    Node$1.prototype = {
    	firstChild : null,
    	lastChild : null,
    	previousSibling : null,
    	nextSibling : null,
    	attributes : null,
    	parentNode : null,
    	childNodes : null,
    	ownerDocument : null,
    	nodeValue : null,
    	namespaceURI : null,
    	prefix : null,
    	localName : null,
    	// Modified in DOM Level 2:
    	insertBefore:function(newChild, refChild){//raises
    		return _insertBefore(this,newChild,refChild);
    	},
    	replaceChild:function(newChild, oldChild){//raises
    		_insertBefore(this, newChild,oldChild, assertPreReplacementValidityInDocument);
    		if(oldChild){
    			this.removeChild(oldChild);
    		}
    	},
    	removeChild:function(oldChild){
    		return _removeChild(this,oldChild);
    	},
    	appendChild:function(newChild){
    		return this.insertBefore(newChild,null);
    	},
    	hasChildNodes:function(){
    		return this.firstChild != null;
    	},
    	cloneNode:function(deep){
    		return cloneNode(this.ownerDocument||this,this,deep);
    	},
    	// Modified in DOM Level 2:
    	normalize:function(){
    		var child = this.firstChild;
    		while(child){
    			var next = child.nextSibling;
    			if(next && next.nodeType == TEXT_NODE && child.nodeType == TEXT_NODE){
    				this.removeChild(next);
    				child.appendData(next.data);
    			}else {
    				child.normalize();
    				child = next;
    			}
    		}
    	},
      	// Introduced in DOM Level 2:
    	isSupported:function(feature, version){
    		return this.ownerDocument.implementation.hasFeature(feature,version);
    	},
        // Introduced in DOM Level 2:
        hasAttributes:function(){
        	return this.attributes.length>0;
        },
    	/**
    	 * Look up the prefix associated to the given namespace URI, starting from this node.
    	 * **The default namespace declarations are ignored by this method.**
    	 * See Namespace Prefix Lookup for details on the algorithm used by this method.
    	 *
    	 * _Note: The implementation seems to be incomplete when compared to the algorithm described in the specs._
    	 *
    	 * @param {string | null} namespaceURI
    	 * @returns {string | null}
    	 * @see https://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-lookupNamespacePrefix
    	 * @see https://www.w3.org/TR/DOM-Level-3-Core/namespaces-algorithms.html#lookupNamespacePrefixAlgo
    	 * @see https://dom.spec.whatwg.org/#dom-node-lookupprefix
    	 * @see https://github.com/xmldom/xmldom/issues/322
    	 */
        lookupPrefix:function(namespaceURI){
        	var el = this;
        	while(el){
        		var map = el._nsMap;
        		//console.dir(map)
        		if(map){
        			for(var n in map){
    						if (Object.prototype.hasOwnProperty.call(map, n) && map[n] === namespaceURI) {
    							return n;
    						}
        			}
        		}
        		el = el.nodeType == ATTRIBUTE_NODE?el.ownerDocument : el.parentNode;
        	}
        	return null;
        },
        // Introduced in DOM Level 3:
        lookupNamespaceURI:function(prefix){
        	var el = this;
        	while(el){
        		var map = el._nsMap;
        		//console.dir(map)
        		if(map){
        			if(Object.prototype.hasOwnProperty.call(map, prefix)){
        				return map[prefix] ;
        			}
        		}
        		el = el.nodeType == ATTRIBUTE_NODE?el.ownerDocument : el.parentNode;
        	}
        	return null;
        },
        // Introduced in DOM Level 3:
        isDefaultNamespace:function(namespaceURI){
        	var prefix = this.lookupPrefix(namespaceURI);
        	return prefix == null;
        }
    };


    function _xmlEncoder(c){
    	return c == '<' && '&lt;' ||
             c == '>' && '&gt;' ||
             c == '&' && '&amp;' ||
             c == '"' && '&quot;' ||
             '&#'+c.charCodeAt()+';'
    }


    copy(NodeType,Node$1);
    copy(NodeType,Node$1.prototype);

    /**
     * @param callback return true for continue,false for break
     * @return boolean true: break visit;
     */
    function _visitNode(node,callback){
    	if(callback(node)){
    		return true;
    	}
    	if(node = node.firstChild){
    		do{
    			if(_visitNode(node,callback)){return true}
            }while(node=node.nextSibling)
        }
    }



    function Document(){
    	this.ownerDocument = this;
    }

    function _onAddAttribute(doc,el,newAttr){
    	doc && doc._inc++;
    	var ns = newAttr.namespaceURI ;
    	if(ns === NAMESPACE$2.XMLNS){
    		//update namespace
    		el._nsMap[newAttr.prefix?newAttr.localName:''] = newAttr.value;
    	}
    }

    function _onRemoveAttribute(doc,el,newAttr,remove){
    	doc && doc._inc++;
    	var ns = newAttr.namespaceURI ;
    	if(ns === NAMESPACE$2.XMLNS){
    		//update namespace
    		delete el._nsMap[newAttr.prefix?newAttr.localName:''];
    	}
    }

    /**
     * Updates `el.childNodes`, updating the indexed items and it's `length`.
     * Passing `newChild` means it will be appended.
     * Otherwise it's assumed that an item has been removed,
     * and `el.firstNode` and it's `.nextSibling` are used
     * to walk the current list of child nodes.
     *
     * @param {Document} doc
     * @param {Node} el
     * @param {Node} [newChild]
     * @private
     */
    function _onUpdateChild (doc, el, newChild) {
    	if(doc && doc._inc){
    		doc._inc++;
    		//update childNodes
    		var cs = el.childNodes;
    		if (newChild) {
    			cs[cs.length++] = newChild;
    		} else {
    			var child = el.firstChild;
    			var i = 0;
    			while (child) {
    				cs[i++] = child;
    				child = child.nextSibling;
    			}
    			cs.length = i;
    			delete cs[cs.length];
    		}
    	}
    }

    /**
     * Removes the connections between `parentNode` and `child`
     * and any existing `child.previousSibling` or `child.nextSibling`.
     *
     * @see https://github.com/xmldom/xmldom/issues/135
     * @see https://github.com/xmldom/xmldom/issues/145
     *
     * @param {Node} parentNode
     * @param {Node} child
     * @returns {Node} the child that was removed.
     * @private
     */
    function _removeChild (parentNode, child) {
    	var previous = child.previousSibling;
    	var next = child.nextSibling;
    	if (previous) {
    		previous.nextSibling = next;
    	} else {
    		parentNode.firstChild = next;
    	}
    	if (next) {
    		next.previousSibling = previous;
    	} else {
    		parentNode.lastChild = previous;
    	}
    	child.parentNode = null;
    	child.previousSibling = null;
    	child.nextSibling = null;
    	_onUpdateChild(parentNode.ownerDocument, parentNode);
    	return child;
    }

    /**
     * Returns `true` if `node` can be a parent for insertion.
     * @param {Node} node
     * @returns {boolean}
     */
    function hasValidParentNodeType(node) {
    	return (
    		node &&
    		(node.nodeType === Node$1.DOCUMENT_NODE || node.nodeType === Node$1.DOCUMENT_FRAGMENT_NODE || node.nodeType === Node$1.ELEMENT_NODE)
    	);
    }

    /**
     * Returns `true` if `node` can be inserted according to it's `nodeType`.
     * @param {Node} node
     * @returns {boolean}
     */
    function hasInsertableNodeType(node) {
    	return (
    		node &&
    		(isElementNode(node) ||
    			isTextNode(node) ||
    			isDocTypeNode(node) ||
    			node.nodeType === Node$1.DOCUMENT_FRAGMENT_NODE ||
    			node.nodeType === Node$1.COMMENT_NODE ||
    			node.nodeType === Node$1.PROCESSING_INSTRUCTION_NODE)
    	);
    }

    /**
     * Returns true if `node` is a DOCTYPE node
     * @param {Node} node
     * @returns {boolean}
     */
    function isDocTypeNode(node) {
    	return node && node.nodeType === Node$1.DOCUMENT_TYPE_NODE;
    }

    /**
     * Returns true if the node is an element
     * @param {Node} node
     * @returns {boolean}
     */
    function isElementNode(node) {
    	return node && node.nodeType === Node$1.ELEMENT_NODE;
    }
    /**
     * Returns true if `node` is a text node
     * @param {Node} node
     * @returns {boolean}
     */
    function isTextNode(node) {
    	return node && node.nodeType === Node$1.TEXT_NODE;
    }

    /**
     * Check if en element node can be inserted before `child`, or at the end if child is falsy,
     * according to the presence and position of a doctype node on the same level.
     *
     * @param {Document} doc The document node
     * @param {Node} child the node that would become the nextSibling if the element would be inserted
     * @returns {boolean} `true` if an element can be inserted before child
     * @private
     * https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
     */
    function isElementInsertionPossible(doc, child) {
    	var parentChildNodes = doc.childNodes || [];
    	if (find(parentChildNodes, isElementNode) || isDocTypeNode(child)) {
    		return false;
    	}
    	var docTypeNode = find(parentChildNodes, isDocTypeNode);
    	return !(child && docTypeNode && parentChildNodes.indexOf(docTypeNode) > parentChildNodes.indexOf(child));
    }

    /**
     * Check if en element node can be inserted before `child`, or at the end if child is falsy,
     * according to the presence and position of a doctype node on the same level.
     *
     * @param {Node} doc The document node
     * @param {Node} child the node that would become the nextSibling if the element would be inserted
     * @returns {boolean} `true` if an element can be inserted before child
     * @private
     * https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
     */
    function isElementReplacementPossible(doc, child) {
    	var parentChildNodes = doc.childNodes || [];

    	function hasElementChildThatIsNotChild(node) {
    		return isElementNode(node) && node !== child;
    	}

    	if (find(parentChildNodes, hasElementChildThatIsNotChild)) {
    		return false;
    	}
    	var docTypeNode = find(parentChildNodes, isDocTypeNode);
    	return !(child && docTypeNode && parentChildNodes.indexOf(docTypeNode) > parentChildNodes.indexOf(child));
    }

    /**
     * @private
     * Steps 1-5 of the checks before inserting and before replacing a child are the same.
     *
     * @param {Node} parent the parent node to insert `node` into
     * @param {Node} node the node to insert
     * @param {Node=} child the node that should become the `nextSibling` of `node`
     * @returns {Node}
     * @throws DOMException for several node combinations that would create a DOM that is not well-formed.
     * @throws DOMException if `child` is provided but is not a child of `parent`.
     * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
     * @see https://dom.spec.whatwg.org/#concept-node-replace
     */
    function assertPreInsertionValidity1to5(parent, node, child) {
    	// 1. If `parent` is not a Document, DocumentFragment, or Element node, then throw a "HierarchyRequestError" DOMException.
    	if (!hasValidParentNodeType(parent)) {
    		throw new DOMException(HIERARCHY_REQUEST_ERR, 'Unexpected parent node type ' + parent.nodeType);
    	}
    	// 2. If `node` is a host-including inclusive ancestor of `parent`, then throw a "HierarchyRequestError" DOMException.
    	// not implemented!
    	// 3. If `child` is non-null and its parent is not `parent`, then throw a "NotFoundError" DOMException.
    	if (child && child.parentNode !== parent) {
    		throw new DOMException(NOT_FOUND_ERR, 'child not in parent');
    	}
    	if (
    		// 4. If `node` is not a DocumentFragment, DocumentType, Element, or CharacterData node, then throw a "HierarchyRequestError" DOMException.
    		!hasInsertableNodeType(node) ||
    		// 5. If either `node` is a Text node and `parent` is a document,
    		// the sax parser currently adds top level text nodes, this will be fixed in 0.9.0
    		// || (node.nodeType === Node.TEXT_NODE && parent.nodeType === Node.DOCUMENT_NODE)
    		// or `node` is a doctype and `parent` is not a document, then throw a "HierarchyRequestError" DOMException.
    		(isDocTypeNode(node) && parent.nodeType !== Node$1.DOCUMENT_NODE)
    	) {
    		throw new DOMException(
    			HIERARCHY_REQUEST_ERR,
    			'Unexpected node type ' + node.nodeType + ' for parent node type ' + parent.nodeType
    		);
    	}
    }

    /**
     * @private
     * Step 6 of the checks before inserting and before replacing a child are different.
     *
     * @param {Document} parent the parent node to insert `node` into
     * @param {Node} node the node to insert
     * @param {Node | undefined} child the node that should become the `nextSibling` of `node`
     * @returns {Node}
     * @throws DOMException for several node combinations that would create a DOM that is not well-formed.
     * @throws DOMException if `child` is provided but is not a child of `parent`.
     * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
     * @see https://dom.spec.whatwg.org/#concept-node-replace
     */
    function assertPreInsertionValidityInDocument(parent, node, child) {
    	var parentChildNodes = parent.childNodes || [];
    	var nodeChildNodes = node.childNodes || [];

    	// DocumentFragment
    	if (node.nodeType === Node$1.DOCUMENT_FRAGMENT_NODE) {
    		var nodeChildElements = nodeChildNodes.filter(isElementNode);
    		// If node has more than one element child or has a Text node child.
    		if (nodeChildElements.length > 1 || find(nodeChildNodes, isTextNode)) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'More than one element or text in fragment');
    		}
    		// Otherwise, if `node` has one element child and either `parent` has an element child,
    		// `child` is a doctype, or `child` is non-null and a doctype is following `child`.
    		if (nodeChildElements.length === 1 && !isElementInsertionPossible(parent, child)) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Element in fragment can not be inserted before doctype');
    		}
    	}
    	// Element
    	if (isElementNode(node)) {
    		// `parent` has an element child, `child` is a doctype,
    		// or `child` is non-null and a doctype is following `child`.
    		if (!isElementInsertionPossible(parent, child)) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Only one element can be added and only after doctype');
    		}
    	}
    	// DocumentType
    	if (isDocTypeNode(node)) {
    		// `parent` has a doctype child,
    		if (find(parentChildNodes, isDocTypeNode)) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Only one doctype is allowed');
    		}
    		var parentElementChild = find(parentChildNodes, isElementNode);
    		// `child` is non-null and an element is preceding `child`,
    		if (child && parentChildNodes.indexOf(parentElementChild) < parentChildNodes.indexOf(child)) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Doctype can only be inserted before an element');
    		}
    		// or `child` is null and `parent` has an element child.
    		if (!child && parentElementChild) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Doctype can not be appended since element is present');
    		}
    	}
    }

    /**
     * @private
     * Step 6 of the checks before inserting and before replacing a child are different.
     *
     * @param {Document} parent the parent node to insert `node` into
     * @param {Node} node the node to insert
     * @param {Node | undefined} child the node that should become the `nextSibling` of `node`
     * @returns {Node}
     * @throws DOMException for several node combinations that would create a DOM that is not well-formed.
     * @throws DOMException if `child` is provided but is not a child of `parent`.
     * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
     * @see https://dom.spec.whatwg.org/#concept-node-replace
     */
    function assertPreReplacementValidityInDocument(parent, node, child) {
    	var parentChildNodes = parent.childNodes || [];
    	var nodeChildNodes = node.childNodes || [];

    	// DocumentFragment
    	if (node.nodeType === Node$1.DOCUMENT_FRAGMENT_NODE) {
    		var nodeChildElements = nodeChildNodes.filter(isElementNode);
    		// If `node` has more than one element child or has a Text node child.
    		if (nodeChildElements.length > 1 || find(nodeChildNodes, isTextNode)) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'More than one element or text in fragment');
    		}
    		// Otherwise, if `node` has one element child and either `parent` has an element child that is not `child` or a doctype is following `child`.
    		if (nodeChildElements.length === 1 && !isElementReplacementPossible(parent, child)) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Element in fragment can not be inserted before doctype');
    		}
    	}
    	// Element
    	if (isElementNode(node)) {
    		// `parent` has an element child that is not `child` or a doctype is following `child`.
    		if (!isElementReplacementPossible(parent, child)) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Only one element can be added and only after doctype');
    		}
    	}
    	// DocumentType
    	if (isDocTypeNode(node)) {
    		function hasDoctypeChildThatIsNotChild(node) {
    			return isDocTypeNode(node) && node !== child;
    		}

    		// `parent` has a doctype child that is not `child`,
    		if (find(parentChildNodes, hasDoctypeChildThatIsNotChild)) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Only one doctype is allowed');
    		}
    		var parentElementChild = find(parentChildNodes, isElementNode);
    		// or an element is preceding `child`.
    		if (child && parentChildNodes.indexOf(parentElementChild) < parentChildNodes.indexOf(child)) {
    			throw new DOMException(HIERARCHY_REQUEST_ERR, 'Doctype can only be inserted before an element');
    		}
    	}
    }

    /**
     * @private
     * @param {Node} parent the parent node to insert `node` into
     * @param {Node} node the node to insert
     * @param {Node=} child the node that should become the `nextSibling` of `node`
     * @returns {Node}
     * @throws DOMException for several node combinations that would create a DOM that is not well-formed.
     * @throws DOMException if `child` is provided but is not a child of `parent`.
     * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity
     */
    function _insertBefore(parent, node, child, _inDocumentAssertion) {
    	// To ensure pre-insertion validity of a node into a parent before a child, run these steps:
    	assertPreInsertionValidity1to5(parent, node, child);

    	// If parent is a document, and any of the statements below, switched on the interface node implements,
    	// are true, then throw a "HierarchyRequestError" DOMException.
    	if (parent.nodeType === Node$1.DOCUMENT_NODE) {
    		(_inDocumentAssertion || assertPreInsertionValidityInDocument)(parent, node, child);
    	}

    	var cp = node.parentNode;
    	if(cp){
    		cp.removeChild(node);//remove and update
    	}
    	if(node.nodeType === DOCUMENT_FRAGMENT_NODE){
    		var newFirst = node.firstChild;
    		if (newFirst == null) {
    			return node;
    		}
    		var newLast = node.lastChild;
    	}else {
    		newFirst = newLast = node;
    	}
    	var pre = child ? child.previousSibling : parent.lastChild;

    	newFirst.previousSibling = pre;
    	newLast.nextSibling = child;


    	if(pre){
    		pre.nextSibling = newFirst;
    	}else {
    		parent.firstChild = newFirst;
    	}
    	if(child == null){
    		parent.lastChild = newLast;
    	}else {
    		child.previousSibling = newLast;
    	}
    	do{
    		newFirst.parentNode = parent;
    	}while(newFirst !== newLast && (newFirst= newFirst.nextSibling))
    	_onUpdateChild(parent.ownerDocument||parent, parent);
    	//console.log(parent.lastChild.nextSibling == null)
    	if (node.nodeType == DOCUMENT_FRAGMENT_NODE) {
    		node.firstChild = node.lastChild = null;
    	}
    	return node;
    }

    /**
     * Appends `newChild` to `parentNode`.
     * If `newChild` is already connected to a `parentNode` it is first removed from it.
     *
     * @see https://github.com/xmldom/xmldom/issues/135
     * @see https://github.com/xmldom/xmldom/issues/145
     * @param {Node} parentNode
     * @param {Node} newChild
     * @returns {Node}
     * @private
     */
    function _appendSingleChild (parentNode, newChild) {
    	if (newChild.parentNode) {
    		newChild.parentNode.removeChild(newChild);
    	}
    	newChild.parentNode = parentNode;
    	newChild.previousSibling = parentNode.lastChild;
    	newChild.nextSibling = null;
    	if (newChild.previousSibling) {
    		newChild.previousSibling.nextSibling = newChild;
    	} else {
    		parentNode.firstChild = newChild;
    	}
    	parentNode.lastChild = newChild;
    	_onUpdateChild(parentNode.ownerDocument, parentNode, newChild);
    	return newChild;
    }

    Document.prototype = {
    	//implementation : null,
    	nodeName :  '#document',
    	nodeType :  DOCUMENT_NODE,
    	/**
    	 * The DocumentType node of the document.
    	 *
    	 * @readonly
    	 * @type DocumentType
    	 */
    	doctype :  null,
    	documentElement :  null,
    	_inc : 1,

    	insertBefore :  function(newChild, refChild){//raises
    		if(newChild.nodeType == DOCUMENT_FRAGMENT_NODE){
    			var child = newChild.firstChild;
    			while(child){
    				var next = child.nextSibling;
    				this.insertBefore(child,refChild);
    				child = next;
    			}
    			return newChild;
    		}
    		_insertBefore(this, newChild, refChild);
    		newChild.ownerDocument = this;
    		if (this.documentElement === null && newChild.nodeType === ELEMENT_NODE) {
    			this.documentElement = newChild;
    		}

    		return newChild;
    	},
    	removeChild :  function(oldChild){
    		if(this.documentElement == oldChild){
    			this.documentElement = null;
    		}
    		return _removeChild(this,oldChild);
    	},
    	replaceChild: function (newChild, oldChild) {
    		//raises
    		_insertBefore(this, newChild, oldChild, assertPreReplacementValidityInDocument);
    		newChild.ownerDocument = this;
    		if (oldChild) {
    			this.removeChild(oldChild);
    		}
    		if (isElementNode(newChild)) {
    			this.documentElement = newChild;
    		}
    	},
    	// Introduced in DOM Level 2:
    	importNode : function(importedNode,deep){
    		return importNode(this,importedNode,deep);
    	},
    	// Introduced in DOM Level 2:
    	getElementById :	function(id){
    		var rtv = null;
    		_visitNode(this.documentElement,function(node){
    			if(node.nodeType == ELEMENT_NODE){
    				if(node.getAttribute('id') == id){
    					rtv = node;
    					return true;
    				}
    			}
    		});
    		return rtv;
    	},

    	/**
    	 * The `getElementsByClassName` method of `Document` interface returns an array-like object
    	 * of all child elements which have **all** of the given class name(s).
    	 *
    	 * Returns an empty list if `classeNames` is an empty string or only contains HTML white space characters.
    	 *
    	 *
    	 * Warning: This is a live LiveNodeList.
    	 * Changes in the DOM will reflect in the array as the changes occur.
    	 * If an element selected by this array no longer qualifies for the selector,
    	 * it will automatically be removed. Be aware of this for iteration purposes.
    	 *
    	 * @param {string} classNames is a string representing the class name(s) to match; multiple class names are separated by (ASCII-)whitespace
    	 *
    	 * @see https://developer.mozilla.org/en-US/docs/Web/API/Document/getElementsByClassName
    	 * @see https://dom.spec.whatwg.org/#concept-getelementsbyclassname
    	 */
    	getElementsByClassName: function(classNames) {
    		var classNamesSet = toOrderedSet(classNames);
    		return new LiveNodeList(this, function(base) {
    			var ls = [];
    			if (classNamesSet.length > 0) {
    				_visitNode(base.documentElement, function(node) {
    					if(node !== base && node.nodeType === ELEMENT_NODE) {
    						var nodeClassNames = node.getAttribute('class');
    						// can be null if the attribute does not exist
    						if (nodeClassNames) {
    							// before splitting and iterating just compare them for the most common case
    							var matches = classNames === nodeClassNames;
    							if (!matches) {
    								var nodeClassNamesSet = toOrderedSet(nodeClassNames);
    								matches = classNamesSet.every(arrayIncludes(nodeClassNamesSet));
    							}
    							if(matches) {
    								ls.push(node);
    							}
    						}
    					}
    				});
    			}
    			return ls;
    		});
    	},

    	//document factory method:
    	createElement :	function(tagName){
    		var node = new Element();
    		node.ownerDocument = this;
    		node.nodeName = tagName;
    		node.tagName = tagName;
    		node.localName = tagName;
    		node.childNodes = new NodeList();
    		var attrs	= node.attributes = new NamedNodeMap();
    		attrs._ownerElement = node;
    		return node;
    	},
    	createDocumentFragment :	function(){
    		var node = new DocumentFragment();
    		node.ownerDocument = this;
    		node.childNodes = new NodeList();
    		return node;
    	},
    	createTextNode :	function(data){
    		var node = new Text$1();
    		node.ownerDocument = this;
    		node.appendData(data);
    		return node;
    	},
    	createComment :	function(data){
    		var node = new Comment();
    		node.ownerDocument = this;
    		node.appendData(data);
    		return node;
    	},
    	createCDATASection :	function(data){
    		var node = new CDATASection();
    		node.ownerDocument = this;
    		node.appendData(data);
    		return node;
    	},
    	createProcessingInstruction :	function(target,data){
    		var node = new ProcessingInstruction();
    		node.ownerDocument = this;
    		node.tagName = node.nodeName = node.target = target;
    		node.nodeValue = node.data = data;
    		return node;
    	},
    	createAttribute :	function(name){
    		var node = new Attr();
    		node.ownerDocument	= this;
    		node.name = name;
    		node.nodeName	= name;
    		node.localName = name;
    		node.specified = true;
    		return node;
    	},
    	createEntityReference :	function(name){
    		var node = new EntityReference();
    		node.ownerDocument	= this;
    		node.nodeName	= name;
    		return node;
    	},
    	// Introduced in DOM Level 2:
    	createElementNS :	function(namespaceURI,qualifiedName){
    		var node = new Element();
    		var pl = qualifiedName.split(':');
    		var attrs	= node.attributes = new NamedNodeMap();
    		node.childNodes = new NodeList();
    		node.ownerDocument = this;
    		node.nodeName = qualifiedName;
    		node.tagName = qualifiedName;
    		node.namespaceURI = namespaceURI;
    		if(pl.length == 2){
    			node.prefix = pl[0];
    			node.localName = pl[1];
    		}else {
    			//el.prefix = null;
    			node.localName = qualifiedName;
    		}
    		attrs._ownerElement = node;
    		return node;
    	},
    	// Introduced in DOM Level 2:
    	createAttributeNS :	function(namespaceURI,qualifiedName){
    		var node = new Attr();
    		var pl = qualifiedName.split(':');
    		node.ownerDocument = this;
    		node.nodeName = qualifiedName;
    		node.name = qualifiedName;
    		node.namespaceURI = namespaceURI;
    		node.specified = true;
    		if(pl.length == 2){
    			node.prefix = pl[0];
    			node.localName = pl[1];
    		}else {
    			//el.prefix = null;
    			node.localName = qualifiedName;
    		}
    		return node;
    	}
    };
    _extends(Document,Node$1);


    function Element() {
    	this._nsMap = {};
    };
    Element.prototype = {
    	nodeType : ELEMENT_NODE,
    	hasAttribute : function(name){
    		return this.getAttributeNode(name)!=null;
    	},
    	getAttribute : function(name){
    		var attr = this.getAttributeNode(name);
    		return attr && attr.value || '';
    	},
    	getAttributeNode : function(name){
    		return this.attributes.getNamedItem(name);
    	},
    	setAttribute : function(name, value){
    		var attr = this.ownerDocument.createAttribute(name);
    		attr.value = attr.nodeValue = "" + value;
    		this.setAttributeNode(attr);
    	},
    	removeAttribute : function(name){
    		var attr = this.getAttributeNode(name);
    		attr && this.removeAttributeNode(attr);
    	},

    	//four real opeartion method
    	appendChild:function(newChild){
    		if(newChild.nodeType === DOCUMENT_FRAGMENT_NODE){
    			return this.insertBefore(newChild,null);
    		}else {
    			return _appendSingleChild(this,newChild);
    		}
    	},
    	setAttributeNode : function(newAttr){
    		return this.attributes.setNamedItem(newAttr);
    	},
    	setAttributeNodeNS : function(newAttr){
    		return this.attributes.setNamedItemNS(newAttr);
    	},
    	removeAttributeNode : function(oldAttr){
    		//console.log(this == oldAttr.ownerElement)
    		return this.attributes.removeNamedItem(oldAttr.nodeName);
    	},
    	//get real attribute name,and remove it by removeAttributeNode
    	removeAttributeNS : function(namespaceURI, localName){
    		var old = this.getAttributeNodeNS(namespaceURI, localName);
    		old && this.removeAttributeNode(old);
    	},

    	hasAttributeNS : function(namespaceURI, localName){
    		return this.getAttributeNodeNS(namespaceURI, localName)!=null;
    	},
    	getAttributeNS : function(namespaceURI, localName){
    		var attr = this.getAttributeNodeNS(namespaceURI, localName);
    		return attr && attr.value || '';
    	},
    	setAttributeNS : function(namespaceURI, qualifiedName, value){
    		var attr = this.ownerDocument.createAttributeNS(namespaceURI, qualifiedName);
    		attr.value = attr.nodeValue = "" + value;
    		this.setAttributeNode(attr);
    	},
    	getAttributeNodeNS : function(namespaceURI, localName){
    		return this.attributes.getNamedItemNS(namespaceURI, localName);
    	},

    	getElementsByTagName : function(tagName){
    		return new LiveNodeList(this,function(base){
    			var ls = [];
    			_visitNode(base,function(node){
    				if(node !== base && node.nodeType == ELEMENT_NODE && (tagName === '*' || node.tagName == tagName)){
    					ls.push(node);
    				}
    			});
    			return ls;
    		});
    	},
    	getElementsByTagNameNS : function(namespaceURI, localName){
    		return new LiveNodeList(this,function(base){
    			var ls = [];
    			_visitNode(base,function(node){
    				if(node !== base && node.nodeType === ELEMENT_NODE && (namespaceURI === '*' || node.namespaceURI === namespaceURI) && (localName === '*' || node.localName == localName)){
    					ls.push(node);
    				}
    			});
    			return ls;

    		});
    	}
    };
    Document.prototype.getElementsByTagName = Element.prototype.getElementsByTagName;
    Document.prototype.getElementsByTagNameNS = Element.prototype.getElementsByTagNameNS;


    _extends(Element,Node$1);
    function Attr() {
    };
    Attr.prototype.nodeType = ATTRIBUTE_NODE;
    _extends(Attr,Node$1);


    function CharacterData() {
    };
    CharacterData.prototype = {
    	data : '',
    	substringData : function(offset, count) {
    		return this.data.substring(offset, offset+count);
    	},
    	appendData: function(text) {
    		text = this.data+text;
    		this.nodeValue = this.data = text;
    		this.length = text.length;
    	},
    	insertData: function(offset,text) {
    		this.replaceData(offset,0,text);

    	},
    	appendChild:function(newChild){
    		throw new Error(ExceptionMessage[HIERARCHY_REQUEST_ERR])
    	},
    	deleteData: function(offset, count) {
    		this.replaceData(offset,count,"");
    	},
    	replaceData: function(offset, count, text) {
    		var start = this.data.substring(0,offset);
    		var end = this.data.substring(offset+count);
    		text = start + text + end;
    		this.nodeValue = this.data = text;
    		this.length = text.length;
    	}
    };
    _extends(CharacterData,Node$1);
    function Text$1() {
    };
    Text$1.prototype = {
    	nodeName : "#text",
    	nodeType : TEXT_NODE,
    	splitText : function(offset) {
    		var text = this.data;
    		var newText = text.substring(offset);
    		text = text.substring(0, offset);
    		this.data = this.nodeValue = text;
    		this.length = text.length;
    		var newNode = this.ownerDocument.createTextNode(newText);
    		if(this.parentNode){
    			this.parentNode.insertBefore(newNode, this.nextSibling);
    		}
    		return newNode;
    	}
    };
    _extends(Text$1,CharacterData);
    function Comment() {
    };
    Comment.prototype = {
    	nodeName : "#comment",
    	nodeType : COMMENT_NODE
    };
    _extends(Comment,CharacterData);

    function CDATASection() {
    };
    CDATASection.prototype = {
    	nodeName : "#cdata-section",
    	nodeType : CDATA_SECTION_NODE
    };
    _extends(CDATASection,CharacterData);


    function DocumentType() {
    };
    DocumentType.prototype.nodeType = DOCUMENT_TYPE_NODE;
    _extends(DocumentType,Node$1);

    function Notation() {
    };
    Notation.prototype.nodeType = NOTATION_NODE;
    _extends(Notation,Node$1);

    function Entity() {
    };
    Entity.prototype.nodeType = ENTITY_NODE;
    _extends(Entity,Node$1);

    function EntityReference() {
    };
    EntityReference.prototype.nodeType = ENTITY_REFERENCE_NODE;
    _extends(EntityReference,Node$1);

    function DocumentFragment() {
    };
    DocumentFragment.prototype.nodeName =	"#document-fragment";
    DocumentFragment.prototype.nodeType =	DOCUMENT_FRAGMENT_NODE;
    _extends(DocumentFragment,Node$1);


    function ProcessingInstruction() {
    }
    ProcessingInstruction.prototype.nodeType = PROCESSING_INSTRUCTION_NODE;
    _extends(ProcessingInstruction,Node$1);
    function XMLSerializer$2(){}
    XMLSerializer$2.prototype.serializeToString = function(node,isHtml,nodeFilter){
    	return nodeSerializeToString.call(node,isHtml,nodeFilter);
    };
    Node$1.prototype.toString = nodeSerializeToString;
    function nodeSerializeToString(isHtml,nodeFilter){
    	var buf = [];
    	var refNode = this.nodeType == 9 && this.documentElement || this;
    	var prefix = refNode.prefix;
    	var uri = refNode.namespaceURI;

    	if(uri && prefix == null){
    		//console.log(prefix)
    		var prefix = refNode.lookupPrefix(uri);
    		if(prefix == null){
    			//isHTML = true;
    			var visibleNamespaces=[
    			{namespace:uri,prefix:null}
    			//{namespace:uri,prefix:''}
    			];
    		}
    	}
    	serializeToString(this,buf,isHtml,nodeFilter,visibleNamespaces);
    	//console.log('###',this.nodeType,uri,prefix,buf.join(''))
    	return buf.join('');
    }

    function needNamespaceDefine(node, isHTML, visibleNamespaces) {
    	var prefix = node.prefix || '';
    	var uri = node.namespaceURI;
    	// According to [Namespaces in XML 1.0](https://www.w3.org/TR/REC-xml-names/#ns-using) ,
    	// and more specifically https://www.w3.org/TR/REC-xml-names/#nsc-NoPrefixUndecl :
    	// > In a namespace declaration for a prefix [...], the attribute value MUST NOT be empty.
    	// in a similar manner [Namespaces in XML 1.1](https://www.w3.org/TR/xml-names11/#ns-using)
    	// and more specifically https://www.w3.org/TR/xml-names11/#nsc-NSDeclared :
    	// > [...] Furthermore, the attribute value [...] must not be an empty string.
    	// so serializing empty namespace value like xmlns:ds="" would produce an invalid XML document.
    	if (!uri) {
    		return false;
    	}
    	if (prefix === "xml" && uri === NAMESPACE$2.XML || uri === NAMESPACE$2.XMLNS) {
    		return false;
    	}

    	var i = visibleNamespaces.length;
    	while (i--) {
    		var ns = visibleNamespaces[i];
    		// get namespace prefix
    		if (ns.prefix === prefix) {
    			return ns.namespace !== uri;
    		}
    	}
    	return true;
    }
    /**
     * Well-formed constraint: No < in Attribute Values
     * > The replacement text of any entity referred to directly or indirectly
     * > in an attribute value must not contain a <.
     * @see https://www.w3.org/TR/xml11/#CleanAttrVals
     * @see https://www.w3.org/TR/xml11/#NT-AttValue
     *
     * Literal whitespace other than space that appear in attribute values
     * are serialized as their entity references, so they will be preserved.
     * (In contrast to whitespace literals in the input which are normalized to spaces)
     * @see https://www.w3.org/TR/xml11/#AVNormalize
     * @see https://w3c.github.io/DOM-Parsing/#serializing-an-element-s-attributes
     */
    function addSerializedAttribute(buf, qualifiedName, value) {
    	buf.push(' ', qualifiedName, '="', value.replace(/[<>&"\t\n\r]/g, _xmlEncoder), '"');
    }

    function serializeToString(node,buf,isHTML,nodeFilter,visibleNamespaces){
    	if (!visibleNamespaces) {
    		visibleNamespaces = [];
    	}

    	if(nodeFilter){
    		node = nodeFilter(node);
    		if(node){
    			if(typeof node == 'string'){
    				buf.push(node);
    				return;
    			}
    		}else {
    			return;
    		}
    		//buf.sort.apply(attrs, attributeSorter);
    	}

    	switch(node.nodeType){
    	case ELEMENT_NODE:
    		var attrs = node.attributes;
    		var len = attrs.length;
    		var child = node.firstChild;
    		var nodeName = node.tagName;

    		isHTML = NAMESPACE$2.isHTML(node.namespaceURI) || isHTML;

    		var prefixedNodeName = nodeName;
    		if (!isHTML && !node.prefix && node.namespaceURI) {
    			var defaultNS;
    			// lookup current default ns from `xmlns` attribute
    			for (var ai = 0; ai < attrs.length; ai++) {
    				if (attrs.item(ai).name === 'xmlns') {
    					defaultNS = attrs.item(ai).value;
    					break
    				}
    			}
    			if (!defaultNS) {
    				// lookup current default ns in visibleNamespaces
    				for (var nsi = visibleNamespaces.length - 1; nsi >= 0; nsi--) {
    					var namespace = visibleNamespaces[nsi];
    					if (namespace.prefix === '' && namespace.namespace === node.namespaceURI) {
    						defaultNS = namespace.namespace;
    						break
    					}
    				}
    			}
    			if (defaultNS !== node.namespaceURI) {
    				for (var nsi = visibleNamespaces.length - 1; nsi >= 0; nsi--) {
    					var namespace = visibleNamespaces[nsi];
    					if (namespace.namespace === node.namespaceURI) {
    						if (namespace.prefix) {
    							prefixedNodeName = namespace.prefix + ':' + nodeName;
    						}
    						break
    					}
    				}
    			}
    		}

    		buf.push('<', prefixedNodeName);

    		for(var i=0;i<len;i++){
    			// add namespaces for attributes
    			var attr = attrs.item(i);
    			if (attr.prefix == 'xmlns') {
    				visibleNamespaces.push({ prefix: attr.localName, namespace: attr.value });
    			}else if(attr.nodeName == 'xmlns'){
    				visibleNamespaces.push({ prefix: '', namespace: attr.value });
    			}
    		}

    		for(var i=0;i<len;i++){
    			var attr = attrs.item(i);
    			if (needNamespaceDefine(attr,isHTML, visibleNamespaces)) {
    				var prefix = attr.prefix||'';
    				var uri = attr.namespaceURI;
    				addSerializedAttribute(buf, prefix ? 'xmlns:' + prefix : "xmlns", uri);
    				visibleNamespaces.push({ prefix: prefix, namespace:uri });
    			}
    			serializeToString(attr,buf,isHTML,nodeFilter,visibleNamespaces);
    		}

    		// add namespace for current node
    		if (nodeName === prefixedNodeName && needNamespaceDefine(node, isHTML, visibleNamespaces)) {
    			var prefix = node.prefix||'';
    			var uri = node.namespaceURI;
    			addSerializedAttribute(buf, prefix ? 'xmlns:' + prefix : "xmlns", uri);
    			visibleNamespaces.push({ prefix: prefix, namespace:uri });
    		}

    		if(child || isHTML && !/^(?:meta|link|img|br|hr|input)$/i.test(nodeName)){
    			buf.push('>');
    			//if is cdata child node
    			if(isHTML && /^script$/i.test(nodeName)){
    				while(child){
    					if(child.data){
    						buf.push(child.data);
    					}else {
    						serializeToString(child, buf, isHTML, nodeFilter, visibleNamespaces.slice());
    					}
    					child = child.nextSibling;
    				}
    			}else
    			{
    				while(child){
    					serializeToString(child, buf, isHTML, nodeFilter, visibleNamespaces.slice());
    					child = child.nextSibling;
    				}
    			}
    			buf.push('</',prefixedNodeName,'>');
    		}else {
    			buf.push('/>');
    		}
    		// remove added visible namespaces
    		//visibleNamespaces.length = startVisibleNamespaces;
    		return;
    	case DOCUMENT_NODE:
    	case DOCUMENT_FRAGMENT_NODE:
    		var child = node.firstChild;
    		while(child){
    			serializeToString(child, buf, isHTML, nodeFilter, visibleNamespaces.slice());
    			child = child.nextSibling;
    		}
    		return;
    	case ATTRIBUTE_NODE:
    		return addSerializedAttribute(buf, node.name, node.value);
    	case TEXT_NODE:
    		/**
    		 * The ampersand character (&) and the left angle bracket (<) must not appear in their literal form,
    		 * except when used as markup delimiters, or within a comment, a processing instruction, or a CDATA section.
    		 * If they are needed elsewhere, they must be escaped using either numeric character references or the strings
    		 * `&amp;` and `&lt;` respectively.
    		 * The right angle bracket (>) may be represented using the string " &gt; ", and must, for compatibility,
    		 * be escaped using either `&gt;` or a character reference when it appears in the string `]]>` in content,
    		 * when that string is not marking the end of a CDATA section.
    		 *
    		 * In the content of elements, character data is any string of characters
    		 * which does not contain the start-delimiter of any markup
    		 * and does not include the CDATA-section-close delimiter, `]]>`.
    		 *
    		 * @see https://www.w3.org/TR/xml/#NT-CharData
    		 * @see https://w3c.github.io/DOM-Parsing/#xml-serializing-a-text-node
    		 */
    		return buf.push(node.data
    			.replace(/[<&>]/g,_xmlEncoder)
    		);
    	case CDATA_SECTION_NODE:
    		return buf.push( '<![CDATA[',node.data,']]>');
    	case COMMENT_NODE:
    		return buf.push( "<!--",node.data,"-->");
    	case DOCUMENT_TYPE_NODE:
    		var pubid = node.publicId;
    		var sysid = node.systemId;
    		buf.push('<!DOCTYPE ',node.name);
    		if(pubid){
    			buf.push(' PUBLIC ', pubid);
    			if (sysid && sysid!='.') {
    				buf.push(' ', sysid);
    			}
    			buf.push('>');
    		}else if(sysid && sysid!='.'){
    			buf.push(' SYSTEM ', sysid, '>');
    		}else {
    			var sub = node.internalSubset;
    			if(sub){
    				buf.push(" [",sub,"]");
    			}
    			buf.push(">");
    		}
    		return;
    	case PROCESSING_INSTRUCTION_NODE:
    		return buf.push( "<?",node.target," ",node.data,"?>");
    	case ENTITY_REFERENCE_NODE:
    		return buf.push( '&',node.nodeName,';');
    	//case ENTITY_NODE:
    	//case NOTATION_NODE:
    	default:
    		buf.push('??',node.nodeName);
    	}
    }
    function importNode(doc,node,deep){
    	var node2;
    	switch (node.nodeType) {
    	case ELEMENT_NODE:
    		node2 = node.cloneNode(false);
    		node2.ownerDocument = doc;
    		//var attrs = node2.attributes;
    		//var len = attrs.length;
    		//for(var i=0;i<len;i++){
    			//node2.setAttributeNodeNS(importNode(doc,attrs.item(i),deep));
    		//}
    	case DOCUMENT_FRAGMENT_NODE:
    		break;
    	case ATTRIBUTE_NODE:
    		deep = true;
    		break;
    	//case ENTITY_REFERENCE_NODE:
    	//case PROCESSING_INSTRUCTION_NODE:
    	////case TEXT_NODE:
    	//case CDATA_SECTION_NODE:
    	//case COMMENT_NODE:
    	//	deep = false;
    	//	break;
    	//case DOCUMENT_NODE:
    	//case DOCUMENT_TYPE_NODE:
    	//cannot be imported.
    	//case ENTITY_NODE:
    	//case NOTATION_NODE：
    	//can not hit in level3
    	//default:throw e;
    	}
    	if(!node2){
    		node2 = node.cloneNode(false);//false
    	}
    	node2.ownerDocument = doc;
    	node2.parentNode = null;
    	if(deep){
    		var child = node.firstChild;
    		while(child){
    			node2.appendChild(importNode(doc,child,deep));
    			child = child.nextSibling;
    		}
    	}
    	return node2;
    }
    //
    //var _relationMap = {firstChild:1,lastChild:1,previousSibling:1,nextSibling:1,
    //					attributes:1,childNodes:1,parentNode:1,documentElement:1,doctype,};
    function cloneNode(doc,node,deep){
    	var node2 = new node.constructor();
    	for (var n in node) {
    		if (Object.prototype.hasOwnProperty.call(node, n)) {
    			var v = node[n];
    			if (typeof v != "object") {
    				if (v != node2[n]) {
    					node2[n] = v;
    				}
    			}
    		}
    	}
    	if(node.childNodes){
    		node2.childNodes = new NodeList();
    	}
    	node2.ownerDocument = doc;
    	switch (node2.nodeType) {
    	case ELEMENT_NODE:
    		var attrs	= node.attributes;
    		var attrs2	= node2.attributes = new NamedNodeMap();
    		var len = attrs.length;
    		attrs2._ownerElement = node2;
    		for(var i=0;i<len;i++){
    			node2.setAttributeNode(cloneNode(doc,attrs.item(i),true));
    		}
    		break;;
    	case ATTRIBUTE_NODE:
    		deep = true;
    	}
    	if(deep){
    		var child = node.firstChild;
    		while(child){
    			node2.appendChild(cloneNode(doc,child,deep));
    			child = child.nextSibling;
    		}
    	}
    	return node2;
    }

    function __set__(object,key,value){
    	object[key] = value;
    }
    //do dynamic
    try{
    	if(Object.defineProperty){
    		Object.defineProperty(LiveNodeList.prototype,'length',{
    			get:function(){
    				_updateLiveList(this);
    				return this.$$length;
    			}
    		});

    		Object.defineProperty(Node$1.prototype,'textContent',{
    			get:function(){
    				return getTextContent(this);
    			},

    			set:function(data){
    				switch(this.nodeType){
    				case ELEMENT_NODE:
    				case DOCUMENT_FRAGMENT_NODE:
    					while(this.firstChild){
    						this.removeChild(this.firstChild);
    					}
    					if(data || String(data)){
    						this.appendChild(this.ownerDocument.createTextNode(data));
    					}
    					break;

    				default:
    					this.data = data;
    					this.value = data;
    					this.nodeValue = data;
    				}
    			}
    		});

    		function getTextContent(node){
    			switch(node.nodeType){
    			case ELEMENT_NODE:
    			case DOCUMENT_FRAGMENT_NODE:
    				var buf = [];
    				node = node.firstChild;
    				while(node){
    					if(node.nodeType!==7 && node.nodeType !==8){
    						buf.push(getTextContent(node));
    					}
    					node = node.nextSibling;
    				}
    				return buf.join('');
    			default:
    				return node.nodeValue;
    			}
    		}

    		__set__ = function(object,key,value){
    			//console.log(value)
    			object['$$'+key] = value;
    		};
    	}
    }catch(e){//ie8
    }

    //if(typeof require == 'function'){
    	var DocumentType_1 = dom$2.DocumentType = DocumentType;
    	var DOMException_1 = dom$2.DOMException = DOMException;
    	var DOMImplementation_1 = dom$2.DOMImplementation = DOMImplementation$2;
    	var Element_1 = dom$2.Element = Element;
    	var Node_1 = dom$2.Node = Node$1;
    	var NodeList_1 = dom$2.NodeList = NodeList;
    	var XMLSerializer_1 = dom$2.XMLSerializer = XMLSerializer$2;

    var domParser = {};

    var entities$2 = {};

    (function (exports) {
    	'use strict';

    	var freeze = conventions$2.freeze;

    	/**
    	 * The entities that are predefined in every XML document.
    	 *
    	 * @see https://www.w3.org/TR/2006/REC-xml11-20060816/#sec-predefined-ent W3C XML 1.1
    	 * @see https://www.w3.org/TR/2008/REC-xml-20081126/#sec-predefined-ent W3C XML 1.0
    	 * @see https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references#Predefined_entities_in_XML Wikipedia
    	 */
    	exports.XML_ENTITIES = freeze({
    		amp: '&',
    		apos: "'",
    		gt: '>',
    		lt: '<',
    		quot: '"',
    	});

    	/**
    	 * A map of all entities that are detected in an HTML document.
    	 * They contain all entries from `XML_ENTITIES`.
    	 *
    	 * @see XML_ENTITIES
    	 * @see DOMParser.parseFromString
    	 * @see DOMImplementation.prototype.createHTMLDocument
    	 * @see https://html.spec.whatwg.org/#named-character-references WHATWG HTML(5) Spec
    	 * @see https://html.spec.whatwg.org/entities.json JSON
    	 * @see https://www.w3.org/TR/xml-entity-names/ W3C XML Entity Names
    	 * @see https://www.w3.org/TR/html4/sgml/entities.html W3C HTML4/SGML
    	 * @see https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references#Character_entity_references_in_HTML Wikipedia (HTML)
    	 * @see https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references#Entities_representing_special_characters_in_XHTML Wikpedia (XHTML)
    	 */
    	exports.HTML_ENTITIES = freeze({
    		Aacute: '\u00C1',
    		aacute: '\u00E1',
    		Abreve: '\u0102',
    		abreve: '\u0103',
    		ac: '\u223E',
    		acd: '\u223F',
    		acE: '\u223E\u0333',
    		Acirc: '\u00C2',
    		acirc: '\u00E2',
    		acute: '\u00B4',
    		Acy: '\u0410',
    		acy: '\u0430',
    		AElig: '\u00C6',
    		aelig: '\u00E6',
    		af: '\u2061',
    		Afr: '\uD835\uDD04',
    		afr: '\uD835\uDD1E',
    		Agrave: '\u00C0',
    		agrave: '\u00E0',
    		alefsym: '\u2135',
    		aleph: '\u2135',
    		Alpha: '\u0391',
    		alpha: '\u03B1',
    		Amacr: '\u0100',
    		amacr: '\u0101',
    		amalg: '\u2A3F',
    		AMP: '\u0026',
    		amp: '\u0026',
    		And: '\u2A53',
    		and: '\u2227',
    		andand: '\u2A55',
    		andd: '\u2A5C',
    		andslope: '\u2A58',
    		andv: '\u2A5A',
    		ang: '\u2220',
    		ange: '\u29A4',
    		angle: '\u2220',
    		angmsd: '\u2221',
    		angmsdaa: '\u29A8',
    		angmsdab: '\u29A9',
    		angmsdac: '\u29AA',
    		angmsdad: '\u29AB',
    		angmsdae: '\u29AC',
    		angmsdaf: '\u29AD',
    		angmsdag: '\u29AE',
    		angmsdah: '\u29AF',
    		angrt: '\u221F',
    		angrtvb: '\u22BE',
    		angrtvbd: '\u299D',
    		angsph: '\u2222',
    		angst: '\u00C5',
    		angzarr: '\u237C',
    		Aogon: '\u0104',
    		aogon: '\u0105',
    		Aopf: '\uD835\uDD38',
    		aopf: '\uD835\uDD52',
    		ap: '\u2248',
    		apacir: '\u2A6F',
    		apE: '\u2A70',
    		ape: '\u224A',
    		apid: '\u224B',
    		apos: '\u0027',
    		ApplyFunction: '\u2061',
    		approx: '\u2248',
    		approxeq: '\u224A',
    		Aring: '\u00C5',
    		aring: '\u00E5',
    		Ascr: '\uD835\uDC9C',
    		ascr: '\uD835\uDCB6',
    		Assign: '\u2254',
    		ast: '\u002A',
    		asymp: '\u2248',
    		asympeq: '\u224D',
    		Atilde: '\u00C3',
    		atilde: '\u00E3',
    		Auml: '\u00C4',
    		auml: '\u00E4',
    		awconint: '\u2233',
    		awint: '\u2A11',
    		backcong: '\u224C',
    		backepsilon: '\u03F6',
    		backprime: '\u2035',
    		backsim: '\u223D',
    		backsimeq: '\u22CD',
    		Backslash: '\u2216',
    		Barv: '\u2AE7',
    		barvee: '\u22BD',
    		Barwed: '\u2306',
    		barwed: '\u2305',
    		barwedge: '\u2305',
    		bbrk: '\u23B5',
    		bbrktbrk: '\u23B6',
    		bcong: '\u224C',
    		Bcy: '\u0411',
    		bcy: '\u0431',
    		bdquo: '\u201E',
    		becaus: '\u2235',
    		Because: '\u2235',
    		because: '\u2235',
    		bemptyv: '\u29B0',
    		bepsi: '\u03F6',
    		bernou: '\u212C',
    		Bernoullis: '\u212C',
    		Beta: '\u0392',
    		beta: '\u03B2',
    		beth: '\u2136',
    		between: '\u226C',
    		Bfr: '\uD835\uDD05',
    		bfr: '\uD835\uDD1F',
    		bigcap: '\u22C2',
    		bigcirc: '\u25EF',
    		bigcup: '\u22C3',
    		bigodot: '\u2A00',
    		bigoplus: '\u2A01',
    		bigotimes: '\u2A02',
    		bigsqcup: '\u2A06',
    		bigstar: '\u2605',
    		bigtriangledown: '\u25BD',
    		bigtriangleup: '\u25B3',
    		biguplus: '\u2A04',
    		bigvee: '\u22C1',
    		bigwedge: '\u22C0',
    		bkarow: '\u290D',
    		blacklozenge: '\u29EB',
    		blacksquare: '\u25AA',
    		blacktriangle: '\u25B4',
    		blacktriangledown: '\u25BE',
    		blacktriangleleft: '\u25C2',
    		blacktriangleright: '\u25B8',
    		blank: '\u2423',
    		blk12: '\u2592',
    		blk14: '\u2591',
    		blk34: '\u2593',
    		block: '\u2588',
    		bne: '\u003D\u20E5',
    		bnequiv: '\u2261\u20E5',
    		bNot: '\u2AED',
    		bnot: '\u2310',
    		Bopf: '\uD835\uDD39',
    		bopf: '\uD835\uDD53',
    		bot: '\u22A5',
    		bottom: '\u22A5',
    		bowtie: '\u22C8',
    		boxbox: '\u29C9',
    		boxDL: '\u2557',
    		boxDl: '\u2556',
    		boxdL: '\u2555',
    		boxdl: '\u2510',
    		boxDR: '\u2554',
    		boxDr: '\u2553',
    		boxdR: '\u2552',
    		boxdr: '\u250C',
    		boxH: '\u2550',
    		boxh: '\u2500',
    		boxHD: '\u2566',
    		boxHd: '\u2564',
    		boxhD: '\u2565',
    		boxhd: '\u252C',
    		boxHU: '\u2569',
    		boxHu: '\u2567',
    		boxhU: '\u2568',
    		boxhu: '\u2534',
    		boxminus: '\u229F',
    		boxplus: '\u229E',
    		boxtimes: '\u22A0',
    		boxUL: '\u255D',
    		boxUl: '\u255C',
    		boxuL: '\u255B',
    		boxul: '\u2518',
    		boxUR: '\u255A',
    		boxUr: '\u2559',
    		boxuR: '\u2558',
    		boxur: '\u2514',
    		boxV: '\u2551',
    		boxv: '\u2502',
    		boxVH: '\u256C',
    		boxVh: '\u256B',
    		boxvH: '\u256A',
    		boxvh: '\u253C',
    		boxVL: '\u2563',
    		boxVl: '\u2562',
    		boxvL: '\u2561',
    		boxvl: '\u2524',
    		boxVR: '\u2560',
    		boxVr: '\u255F',
    		boxvR: '\u255E',
    		boxvr: '\u251C',
    		bprime: '\u2035',
    		Breve: '\u02D8',
    		breve: '\u02D8',
    		brvbar: '\u00A6',
    		Bscr: '\u212C',
    		bscr: '\uD835\uDCB7',
    		bsemi: '\u204F',
    		bsim: '\u223D',
    		bsime: '\u22CD',
    		bsol: '\u005C',
    		bsolb: '\u29C5',
    		bsolhsub: '\u27C8',
    		bull: '\u2022',
    		bullet: '\u2022',
    		bump: '\u224E',
    		bumpE: '\u2AAE',
    		bumpe: '\u224F',
    		Bumpeq: '\u224E',
    		bumpeq: '\u224F',
    		Cacute: '\u0106',
    		cacute: '\u0107',
    		Cap: '\u22D2',
    		cap: '\u2229',
    		capand: '\u2A44',
    		capbrcup: '\u2A49',
    		capcap: '\u2A4B',
    		capcup: '\u2A47',
    		capdot: '\u2A40',
    		CapitalDifferentialD: '\u2145',
    		caps: '\u2229\uFE00',
    		caret: '\u2041',
    		caron: '\u02C7',
    		Cayleys: '\u212D',
    		ccaps: '\u2A4D',
    		Ccaron: '\u010C',
    		ccaron: '\u010D',
    		Ccedil: '\u00C7',
    		ccedil: '\u00E7',
    		Ccirc: '\u0108',
    		ccirc: '\u0109',
    		Cconint: '\u2230',
    		ccups: '\u2A4C',
    		ccupssm: '\u2A50',
    		Cdot: '\u010A',
    		cdot: '\u010B',
    		cedil: '\u00B8',
    		Cedilla: '\u00B8',
    		cemptyv: '\u29B2',
    		cent: '\u00A2',
    		CenterDot: '\u00B7',
    		centerdot: '\u00B7',
    		Cfr: '\u212D',
    		cfr: '\uD835\uDD20',
    		CHcy: '\u0427',
    		chcy: '\u0447',
    		check: '\u2713',
    		checkmark: '\u2713',
    		Chi: '\u03A7',
    		chi: '\u03C7',
    		cir: '\u25CB',
    		circ: '\u02C6',
    		circeq: '\u2257',
    		circlearrowleft: '\u21BA',
    		circlearrowright: '\u21BB',
    		circledast: '\u229B',
    		circledcirc: '\u229A',
    		circleddash: '\u229D',
    		CircleDot: '\u2299',
    		circledR: '\u00AE',
    		circledS: '\u24C8',
    		CircleMinus: '\u2296',
    		CirclePlus: '\u2295',
    		CircleTimes: '\u2297',
    		cirE: '\u29C3',
    		cire: '\u2257',
    		cirfnint: '\u2A10',
    		cirmid: '\u2AEF',
    		cirscir: '\u29C2',
    		ClockwiseContourIntegral: '\u2232',
    		CloseCurlyDoubleQuote: '\u201D',
    		CloseCurlyQuote: '\u2019',
    		clubs: '\u2663',
    		clubsuit: '\u2663',
    		Colon: '\u2237',
    		colon: '\u003A',
    		Colone: '\u2A74',
    		colone: '\u2254',
    		coloneq: '\u2254',
    		comma: '\u002C',
    		commat: '\u0040',
    		comp: '\u2201',
    		compfn: '\u2218',
    		complement: '\u2201',
    		complexes: '\u2102',
    		cong: '\u2245',
    		congdot: '\u2A6D',
    		Congruent: '\u2261',
    		Conint: '\u222F',
    		conint: '\u222E',
    		ContourIntegral: '\u222E',
    		Copf: '\u2102',
    		copf: '\uD835\uDD54',
    		coprod: '\u2210',
    		Coproduct: '\u2210',
    		COPY: '\u00A9',
    		copy: '\u00A9',
    		copysr: '\u2117',
    		CounterClockwiseContourIntegral: '\u2233',
    		crarr: '\u21B5',
    		Cross: '\u2A2F',
    		cross: '\u2717',
    		Cscr: '\uD835\uDC9E',
    		cscr: '\uD835\uDCB8',
    		csub: '\u2ACF',
    		csube: '\u2AD1',
    		csup: '\u2AD0',
    		csupe: '\u2AD2',
    		ctdot: '\u22EF',
    		cudarrl: '\u2938',
    		cudarrr: '\u2935',
    		cuepr: '\u22DE',
    		cuesc: '\u22DF',
    		cularr: '\u21B6',
    		cularrp: '\u293D',
    		Cup: '\u22D3',
    		cup: '\u222A',
    		cupbrcap: '\u2A48',
    		CupCap: '\u224D',
    		cupcap: '\u2A46',
    		cupcup: '\u2A4A',
    		cupdot: '\u228D',
    		cupor: '\u2A45',
    		cups: '\u222A\uFE00',
    		curarr: '\u21B7',
    		curarrm: '\u293C',
    		curlyeqprec: '\u22DE',
    		curlyeqsucc: '\u22DF',
    		curlyvee: '\u22CE',
    		curlywedge: '\u22CF',
    		curren: '\u00A4',
    		curvearrowleft: '\u21B6',
    		curvearrowright: '\u21B7',
    		cuvee: '\u22CE',
    		cuwed: '\u22CF',
    		cwconint: '\u2232',
    		cwint: '\u2231',
    		cylcty: '\u232D',
    		Dagger: '\u2021',
    		dagger: '\u2020',
    		daleth: '\u2138',
    		Darr: '\u21A1',
    		dArr: '\u21D3',
    		darr: '\u2193',
    		dash: '\u2010',
    		Dashv: '\u2AE4',
    		dashv: '\u22A3',
    		dbkarow: '\u290F',
    		dblac: '\u02DD',
    		Dcaron: '\u010E',
    		dcaron: '\u010F',
    		Dcy: '\u0414',
    		dcy: '\u0434',
    		DD: '\u2145',
    		dd: '\u2146',
    		ddagger: '\u2021',
    		ddarr: '\u21CA',
    		DDotrahd: '\u2911',
    		ddotseq: '\u2A77',
    		deg: '\u00B0',
    		Del: '\u2207',
    		Delta: '\u0394',
    		delta: '\u03B4',
    		demptyv: '\u29B1',
    		dfisht: '\u297F',
    		Dfr: '\uD835\uDD07',
    		dfr: '\uD835\uDD21',
    		dHar: '\u2965',
    		dharl: '\u21C3',
    		dharr: '\u21C2',
    		DiacriticalAcute: '\u00B4',
    		DiacriticalDot: '\u02D9',
    		DiacriticalDoubleAcute: '\u02DD',
    		DiacriticalGrave: '\u0060',
    		DiacriticalTilde: '\u02DC',
    		diam: '\u22C4',
    		Diamond: '\u22C4',
    		diamond: '\u22C4',
    		diamondsuit: '\u2666',
    		diams: '\u2666',
    		die: '\u00A8',
    		DifferentialD: '\u2146',
    		digamma: '\u03DD',
    		disin: '\u22F2',
    		div: '\u00F7',
    		divide: '\u00F7',
    		divideontimes: '\u22C7',
    		divonx: '\u22C7',
    		DJcy: '\u0402',
    		djcy: '\u0452',
    		dlcorn: '\u231E',
    		dlcrop: '\u230D',
    		dollar: '\u0024',
    		Dopf: '\uD835\uDD3B',
    		dopf: '\uD835\uDD55',
    		Dot: '\u00A8',
    		dot: '\u02D9',
    		DotDot: '\u20DC',
    		doteq: '\u2250',
    		doteqdot: '\u2251',
    		DotEqual: '\u2250',
    		dotminus: '\u2238',
    		dotplus: '\u2214',
    		dotsquare: '\u22A1',
    		doublebarwedge: '\u2306',
    		DoubleContourIntegral: '\u222F',
    		DoubleDot: '\u00A8',
    		DoubleDownArrow: '\u21D3',
    		DoubleLeftArrow: '\u21D0',
    		DoubleLeftRightArrow: '\u21D4',
    		DoubleLeftTee: '\u2AE4',
    		DoubleLongLeftArrow: '\u27F8',
    		DoubleLongLeftRightArrow: '\u27FA',
    		DoubleLongRightArrow: '\u27F9',
    		DoubleRightArrow: '\u21D2',
    		DoubleRightTee: '\u22A8',
    		DoubleUpArrow: '\u21D1',
    		DoubleUpDownArrow: '\u21D5',
    		DoubleVerticalBar: '\u2225',
    		DownArrow: '\u2193',
    		Downarrow: '\u21D3',
    		downarrow: '\u2193',
    		DownArrowBar: '\u2913',
    		DownArrowUpArrow: '\u21F5',
    		DownBreve: '\u0311',
    		downdownarrows: '\u21CA',
    		downharpoonleft: '\u21C3',
    		downharpoonright: '\u21C2',
    		DownLeftRightVector: '\u2950',
    		DownLeftTeeVector: '\u295E',
    		DownLeftVector: '\u21BD',
    		DownLeftVectorBar: '\u2956',
    		DownRightTeeVector: '\u295F',
    		DownRightVector: '\u21C1',
    		DownRightVectorBar: '\u2957',
    		DownTee: '\u22A4',
    		DownTeeArrow: '\u21A7',
    		drbkarow: '\u2910',
    		drcorn: '\u231F',
    		drcrop: '\u230C',
    		Dscr: '\uD835\uDC9F',
    		dscr: '\uD835\uDCB9',
    		DScy: '\u0405',
    		dscy: '\u0455',
    		dsol: '\u29F6',
    		Dstrok: '\u0110',
    		dstrok: '\u0111',
    		dtdot: '\u22F1',
    		dtri: '\u25BF',
    		dtrif: '\u25BE',
    		duarr: '\u21F5',
    		duhar: '\u296F',
    		dwangle: '\u29A6',
    		DZcy: '\u040F',
    		dzcy: '\u045F',
    		dzigrarr: '\u27FF',
    		Eacute: '\u00C9',
    		eacute: '\u00E9',
    		easter: '\u2A6E',
    		Ecaron: '\u011A',
    		ecaron: '\u011B',
    		ecir: '\u2256',
    		Ecirc: '\u00CA',
    		ecirc: '\u00EA',
    		ecolon: '\u2255',
    		Ecy: '\u042D',
    		ecy: '\u044D',
    		eDDot: '\u2A77',
    		Edot: '\u0116',
    		eDot: '\u2251',
    		edot: '\u0117',
    		ee: '\u2147',
    		efDot: '\u2252',
    		Efr: '\uD835\uDD08',
    		efr: '\uD835\uDD22',
    		eg: '\u2A9A',
    		Egrave: '\u00C8',
    		egrave: '\u00E8',
    		egs: '\u2A96',
    		egsdot: '\u2A98',
    		el: '\u2A99',
    		Element: '\u2208',
    		elinters: '\u23E7',
    		ell: '\u2113',
    		els: '\u2A95',
    		elsdot: '\u2A97',
    		Emacr: '\u0112',
    		emacr: '\u0113',
    		empty: '\u2205',
    		emptyset: '\u2205',
    		EmptySmallSquare: '\u25FB',
    		emptyv: '\u2205',
    		EmptyVerySmallSquare: '\u25AB',
    		emsp: '\u2003',
    		emsp13: '\u2004',
    		emsp14: '\u2005',
    		ENG: '\u014A',
    		eng: '\u014B',
    		ensp: '\u2002',
    		Eogon: '\u0118',
    		eogon: '\u0119',
    		Eopf: '\uD835\uDD3C',
    		eopf: '\uD835\uDD56',
    		epar: '\u22D5',
    		eparsl: '\u29E3',
    		eplus: '\u2A71',
    		epsi: '\u03B5',
    		Epsilon: '\u0395',
    		epsilon: '\u03B5',
    		epsiv: '\u03F5',
    		eqcirc: '\u2256',
    		eqcolon: '\u2255',
    		eqsim: '\u2242',
    		eqslantgtr: '\u2A96',
    		eqslantless: '\u2A95',
    		Equal: '\u2A75',
    		equals: '\u003D',
    		EqualTilde: '\u2242',
    		equest: '\u225F',
    		Equilibrium: '\u21CC',
    		equiv: '\u2261',
    		equivDD: '\u2A78',
    		eqvparsl: '\u29E5',
    		erarr: '\u2971',
    		erDot: '\u2253',
    		Escr: '\u2130',
    		escr: '\u212F',
    		esdot: '\u2250',
    		Esim: '\u2A73',
    		esim: '\u2242',
    		Eta: '\u0397',
    		eta: '\u03B7',
    		ETH: '\u00D0',
    		eth: '\u00F0',
    		Euml: '\u00CB',
    		euml: '\u00EB',
    		euro: '\u20AC',
    		excl: '\u0021',
    		exist: '\u2203',
    		Exists: '\u2203',
    		expectation: '\u2130',
    		ExponentialE: '\u2147',
    		exponentiale: '\u2147',
    		fallingdotseq: '\u2252',
    		Fcy: '\u0424',
    		fcy: '\u0444',
    		female: '\u2640',
    		ffilig: '\uFB03',
    		fflig: '\uFB00',
    		ffllig: '\uFB04',
    		Ffr: '\uD835\uDD09',
    		ffr: '\uD835\uDD23',
    		filig: '\uFB01',
    		FilledSmallSquare: '\u25FC',
    		FilledVerySmallSquare: '\u25AA',
    		fjlig: '\u0066\u006A',
    		flat: '\u266D',
    		fllig: '\uFB02',
    		fltns: '\u25B1',
    		fnof: '\u0192',
    		Fopf: '\uD835\uDD3D',
    		fopf: '\uD835\uDD57',
    		ForAll: '\u2200',
    		forall: '\u2200',
    		fork: '\u22D4',
    		forkv: '\u2AD9',
    		Fouriertrf: '\u2131',
    		fpartint: '\u2A0D',
    		frac12: '\u00BD',
    		frac13: '\u2153',
    		frac14: '\u00BC',
    		frac15: '\u2155',
    		frac16: '\u2159',
    		frac18: '\u215B',
    		frac23: '\u2154',
    		frac25: '\u2156',
    		frac34: '\u00BE',
    		frac35: '\u2157',
    		frac38: '\u215C',
    		frac45: '\u2158',
    		frac56: '\u215A',
    		frac58: '\u215D',
    		frac78: '\u215E',
    		frasl: '\u2044',
    		frown: '\u2322',
    		Fscr: '\u2131',
    		fscr: '\uD835\uDCBB',
    		gacute: '\u01F5',
    		Gamma: '\u0393',
    		gamma: '\u03B3',
    		Gammad: '\u03DC',
    		gammad: '\u03DD',
    		gap: '\u2A86',
    		Gbreve: '\u011E',
    		gbreve: '\u011F',
    		Gcedil: '\u0122',
    		Gcirc: '\u011C',
    		gcirc: '\u011D',
    		Gcy: '\u0413',
    		gcy: '\u0433',
    		Gdot: '\u0120',
    		gdot: '\u0121',
    		gE: '\u2267',
    		ge: '\u2265',
    		gEl: '\u2A8C',
    		gel: '\u22DB',
    		geq: '\u2265',
    		geqq: '\u2267',
    		geqslant: '\u2A7E',
    		ges: '\u2A7E',
    		gescc: '\u2AA9',
    		gesdot: '\u2A80',
    		gesdoto: '\u2A82',
    		gesdotol: '\u2A84',
    		gesl: '\u22DB\uFE00',
    		gesles: '\u2A94',
    		Gfr: '\uD835\uDD0A',
    		gfr: '\uD835\uDD24',
    		Gg: '\u22D9',
    		gg: '\u226B',
    		ggg: '\u22D9',
    		gimel: '\u2137',
    		GJcy: '\u0403',
    		gjcy: '\u0453',
    		gl: '\u2277',
    		gla: '\u2AA5',
    		glE: '\u2A92',
    		glj: '\u2AA4',
    		gnap: '\u2A8A',
    		gnapprox: '\u2A8A',
    		gnE: '\u2269',
    		gne: '\u2A88',
    		gneq: '\u2A88',
    		gneqq: '\u2269',
    		gnsim: '\u22E7',
    		Gopf: '\uD835\uDD3E',
    		gopf: '\uD835\uDD58',
    		grave: '\u0060',
    		GreaterEqual: '\u2265',
    		GreaterEqualLess: '\u22DB',
    		GreaterFullEqual: '\u2267',
    		GreaterGreater: '\u2AA2',
    		GreaterLess: '\u2277',
    		GreaterSlantEqual: '\u2A7E',
    		GreaterTilde: '\u2273',
    		Gscr: '\uD835\uDCA2',
    		gscr: '\u210A',
    		gsim: '\u2273',
    		gsime: '\u2A8E',
    		gsiml: '\u2A90',
    		Gt: '\u226B',
    		GT: '\u003E',
    		gt: '\u003E',
    		gtcc: '\u2AA7',
    		gtcir: '\u2A7A',
    		gtdot: '\u22D7',
    		gtlPar: '\u2995',
    		gtquest: '\u2A7C',
    		gtrapprox: '\u2A86',
    		gtrarr: '\u2978',
    		gtrdot: '\u22D7',
    		gtreqless: '\u22DB',
    		gtreqqless: '\u2A8C',
    		gtrless: '\u2277',
    		gtrsim: '\u2273',
    		gvertneqq: '\u2269\uFE00',
    		gvnE: '\u2269\uFE00',
    		Hacek: '\u02C7',
    		hairsp: '\u200A',
    		half: '\u00BD',
    		hamilt: '\u210B',
    		HARDcy: '\u042A',
    		hardcy: '\u044A',
    		hArr: '\u21D4',
    		harr: '\u2194',
    		harrcir: '\u2948',
    		harrw: '\u21AD',
    		Hat: '\u005E',
    		hbar: '\u210F',
    		Hcirc: '\u0124',
    		hcirc: '\u0125',
    		hearts: '\u2665',
    		heartsuit: '\u2665',
    		hellip: '\u2026',
    		hercon: '\u22B9',
    		Hfr: '\u210C',
    		hfr: '\uD835\uDD25',
    		HilbertSpace: '\u210B',
    		hksearow: '\u2925',
    		hkswarow: '\u2926',
    		hoarr: '\u21FF',
    		homtht: '\u223B',
    		hookleftarrow: '\u21A9',
    		hookrightarrow: '\u21AA',
    		Hopf: '\u210D',
    		hopf: '\uD835\uDD59',
    		horbar: '\u2015',
    		HorizontalLine: '\u2500',
    		Hscr: '\u210B',
    		hscr: '\uD835\uDCBD',
    		hslash: '\u210F',
    		Hstrok: '\u0126',
    		hstrok: '\u0127',
    		HumpDownHump: '\u224E',
    		HumpEqual: '\u224F',
    		hybull: '\u2043',
    		hyphen: '\u2010',
    		Iacute: '\u00CD',
    		iacute: '\u00ED',
    		ic: '\u2063',
    		Icirc: '\u00CE',
    		icirc: '\u00EE',
    		Icy: '\u0418',
    		icy: '\u0438',
    		Idot: '\u0130',
    		IEcy: '\u0415',
    		iecy: '\u0435',
    		iexcl: '\u00A1',
    		iff: '\u21D4',
    		Ifr: '\u2111',
    		ifr: '\uD835\uDD26',
    		Igrave: '\u00CC',
    		igrave: '\u00EC',
    		ii: '\u2148',
    		iiiint: '\u2A0C',
    		iiint: '\u222D',
    		iinfin: '\u29DC',
    		iiota: '\u2129',
    		IJlig: '\u0132',
    		ijlig: '\u0133',
    		Im: '\u2111',
    		Imacr: '\u012A',
    		imacr: '\u012B',
    		image: '\u2111',
    		ImaginaryI: '\u2148',
    		imagline: '\u2110',
    		imagpart: '\u2111',
    		imath: '\u0131',
    		imof: '\u22B7',
    		imped: '\u01B5',
    		Implies: '\u21D2',
    		in: '\u2208',
    		incare: '\u2105',
    		infin: '\u221E',
    		infintie: '\u29DD',
    		inodot: '\u0131',
    		Int: '\u222C',
    		int: '\u222B',
    		intcal: '\u22BA',
    		integers: '\u2124',
    		Integral: '\u222B',
    		intercal: '\u22BA',
    		Intersection: '\u22C2',
    		intlarhk: '\u2A17',
    		intprod: '\u2A3C',
    		InvisibleComma: '\u2063',
    		InvisibleTimes: '\u2062',
    		IOcy: '\u0401',
    		iocy: '\u0451',
    		Iogon: '\u012E',
    		iogon: '\u012F',
    		Iopf: '\uD835\uDD40',
    		iopf: '\uD835\uDD5A',
    		Iota: '\u0399',
    		iota: '\u03B9',
    		iprod: '\u2A3C',
    		iquest: '\u00BF',
    		Iscr: '\u2110',
    		iscr: '\uD835\uDCBE',
    		isin: '\u2208',
    		isindot: '\u22F5',
    		isinE: '\u22F9',
    		isins: '\u22F4',
    		isinsv: '\u22F3',
    		isinv: '\u2208',
    		it: '\u2062',
    		Itilde: '\u0128',
    		itilde: '\u0129',
    		Iukcy: '\u0406',
    		iukcy: '\u0456',
    		Iuml: '\u00CF',
    		iuml: '\u00EF',
    		Jcirc: '\u0134',
    		jcirc: '\u0135',
    		Jcy: '\u0419',
    		jcy: '\u0439',
    		Jfr: '\uD835\uDD0D',
    		jfr: '\uD835\uDD27',
    		jmath: '\u0237',
    		Jopf: '\uD835\uDD41',
    		jopf: '\uD835\uDD5B',
    		Jscr: '\uD835\uDCA5',
    		jscr: '\uD835\uDCBF',
    		Jsercy: '\u0408',
    		jsercy: '\u0458',
    		Jukcy: '\u0404',
    		jukcy: '\u0454',
    		Kappa: '\u039A',
    		kappa: '\u03BA',
    		kappav: '\u03F0',
    		Kcedil: '\u0136',
    		kcedil: '\u0137',
    		Kcy: '\u041A',
    		kcy: '\u043A',
    		Kfr: '\uD835\uDD0E',
    		kfr: '\uD835\uDD28',
    		kgreen: '\u0138',
    		KHcy: '\u0425',
    		khcy: '\u0445',
    		KJcy: '\u040C',
    		kjcy: '\u045C',
    		Kopf: '\uD835\uDD42',
    		kopf: '\uD835\uDD5C',
    		Kscr: '\uD835\uDCA6',
    		kscr: '\uD835\uDCC0',
    		lAarr: '\u21DA',
    		Lacute: '\u0139',
    		lacute: '\u013A',
    		laemptyv: '\u29B4',
    		lagran: '\u2112',
    		Lambda: '\u039B',
    		lambda: '\u03BB',
    		Lang: '\u27EA',
    		lang: '\u27E8',
    		langd: '\u2991',
    		langle: '\u27E8',
    		lap: '\u2A85',
    		Laplacetrf: '\u2112',
    		laquo: '\u00AB',
    		Larr: '\u219E',
    		lArr: '\u21D0',
    		larr: '\u2190',
    		larrb: '\u21E4',
    		larrbfs: '\u291F',
    		larrfs: '\u291D',
    		larrhk: '\u21A9',
    		larrlp: '\u21AB',
    		larrpl: '\u2939',
    		larrsim: '\u2973',
    		larrtl: '\u21A2',
    		lat: '\u2AAB',
    		lAtail: '\u291B',
    		latail: '\u2919',
    		late: '\u2AAD',
    		lates: '\u2AAD\uFE00',
    		lBarr: '\u290E',
    		lbarr: '\u290C',
    		lbbrk: '\u2772',
    		lbrace: '\u007B',
    		lbrack: '\u005B',
    		lbrke: '\u298B',
    		lbrksld: '\u298F',
    		lbrkslu: '\u298D',
    		Lcaron: '\u013D',
    		lcaron: '\u013E',
    		Lcedil: '\u013B',
    		lcedil: '\u013C',
    		lceil: '\u2308',
    		lcub: '\u007B',
    		Lcy: '\u041B',
    		lcy: '\u043B',
    		ldca: '\u2936',
    		ldquo: '\u201C',
    		ldquor: '\u201E',
    		ldrdhar: '\u2967',
    		ldrushar: '\u294B',
    		ldsh: '\u21B2',
    		lE: '\u2266',
    		le: '\u2264',
    		LeftAngleBracket: '\u27E8',
    		LeftArrow: '\u2190',
    		Leftarrow: '\u21D0',
    		leftarrow: '\u2190',
    		LeftArrowBar: '\u21E4',
    		LeftArrowRightArrow: '\u21C6',
    		leftarrowtail: '\u21A2',
    		LeftCeiling: '\u2308',
    		LeftDoubleBracket: '\u27E6',
    		LeftDownTeeVector: '\u2961',
    		LeftDownVector: '\u21C3',
    		LeftDownVectorBar: '\u2959',
    		LeftFloor: '\u230A',
    		leftharpoondown: '\u21BD',
    		leftharpoonup: '\u21BC',
    		leftleftarrows: '\u21C7',
    		LeftRightArrow: '\u2194',
    		Leftrightarrow: '\u21D4',
    		leftrightarrow: '\u2194',
    		leftrightarrows: '\u21C6',
    		leftrightharpoons: '\u21CB',
    		leftrightsquigarrow: '\u21AD',
    		LeftRightVector: '\u294E',
    		LeftTee: '\u22A3',
    		LeftTeeArrow: '\u21A4',
    		LeftTeeVector: '\u295A',
    		leftthreetimes: '\u22CB',
    		LeftTriangle: '\u22B2',
    		LeftTriangleBar: '\u29CF',
    		LeftTriangleEqual: '\u22B4',
    		LeftUpDownVector: '\u2951',
    		LeftUpTeeVector: '\u2960',
    		LeftUpVector: '\u21BF',
    		LeftUpVectorBar: '\u2958',
    		LeftVector: '\u21BC',
    		LeftVectorBar: '\u2952',
    		lEg: '\u2A8B',
    		leg: '\u22DA',
    		leq: '\u2264',
    		leqq: '\u2266',
    		leqslant: '\u2A7D',
    		les: '\u2A7D',
    		lescc: '\u2AA8',
    		lesdot: '\u2A7F',
    		lesdoto: '\u2A81',
    		lesdotor: '\u2A83',
    		lesg: '\u22DA\uFE00',
    		lesges: '\u2A93',
    		lessapprox: '\u2A85',
    		lessdot: '\u22D6',
    		lesseqgtr: '\u22DA',
    		lesseqqgtr: '\u2A8B',
    		LessEqualGreater: '\u22DA',
    		LessFullEqual: '\u2266',
    		LessGreater: '\u2276',
    		lessgtr: '\u2276',
    		LessLess: '\u2AA1',
    		lesssim: '\u2272',
    		LessSlantEqual: '\u2A7D',
    		LessTilde: '\u2272',
    		lfisht: '\u297C',
    		lfloor: '\u230A',
    		Lfr: '\uD835\uDD0F',
    		lfr: '\uD835\uDD29',
    		lg: '\u2276',
    		lgE: '\u2A91',
    		lHar: '\u2962',
    		lhard: '\u21BD',
    		lharu: '\u21BC',
    		lharul: '\u296A',
    		lhblk: '\u2584',
    		LJcy: '\u0409',
    		ljcy: '\u0459',
    		Ll: '\u22D8',
    		ll: '\u226A',
    		llarr: '\u21C7',
    		llcorner: '\u231E',
    		Lleftarrow: '\u21DA',
    		llhard: '\u296B',
    		lltri: '\u25FA',
    		Lmidot: '\u013F',
    		lmidot: '\u0140',
    		lmoust: '\u23B0',
    		lmoustache: '\u23B0',
    		lnap: '\u2A89',
    		lnapprox: '\u2A89',
    		lnE: '\u2268',
    		lne: '\u2A87',
    		lneq: '\u2A87',
    		lneqq: '\u2268',
    		lnsim: '\u22E6',
    		loang: '\u27EC',
    		loarr: '\u21FD',
    		lobrk: '\u27E6',
    		LongLeftArrow: '\u27F5',
    		Longleftarrow: '\u27F8',
    		longleftarrow: '\u27F5',
    		LongLeftRightArrow: '\u27F7',
    		Longleftrightarrow: '\u27FA',
    		longleftrightarrow: '\u27F7',
    		longmapsto: '\u27FC',
    		LongRightArrow: '\u27F6',
    		Longrightarrow: '\u27F9',
    		longrightarrow: '\u27F6',
    		looparrowleft: '\u21AB',
    		looparrowright: '\u21AC',
    		lopar: '\u2985',
    		Lopf: '\uD835\uDD43',
    		lopf: '\uD835\uDD5D',
    		loplus: '\u2A2D',
    		lotimes: '\u2A34',
    		lowast: '\u2217',
    		lowbar: '\u005F',
    		LowerLeftArrow: '\u2199',
    		LowerRightArrow: '\u2198',
    		loz: '\u25CA',
    		lozenge: '\u25CA',
    		lozf: '\u29EB',
    		lpar: '\u0028',
    		lparlt: '\u2993',
    		lrarr: '\u21C6',
    		lrcorner: '\u231F',
    		lrhar: '\u21CB',
    		lrhard: '\u296D',
    		lrm: '\u200E',
    		lrtri: '\u22BF',
    		lsaquo: '\u2039',
    		Lscr: '\u2112',
    		lscr: '\uD835\uDCC1',
    		Lsh: '\u21B0',
    		lsh: '\u21B0',
    		lsim: '\u2272',
    		lsime: '\u2A8D',
    		lsimg: '\u2A8F',
    		lsqb: '\u005B',
    		lsquo: '\u2018',
    		lsquor: '\u201A',
    		Lstrok: '\u0141',
    		lstrok: '\u0142',
    		Lt: '\u226A',
    		LT: '\u003C',
    		lt: '\u003C',
    		ltcc: '\u2AA6',
    		ltcir: '\u2A79',
    		ltdot: '\u22D6',
    		lthree: '\u22CB',
    		ltimes: '\u22C9',
    		ltlarr: '\u2976',
    		ltquest: '\u2A7B',
    		ltri: '\u25C3',
    		ltrie: '\u22B4',
    		ltrif: '\u25C2',
    		ltrPar: '\u2996',
    		lurdshar: '\u294A',
    		luruhar: '\u2966',
    		lvertneqq: '\u2268\uFE00',
    		lvnE: '\u2268\uFE00',
    		macr: '\u00AF',
    		male: '\u2642',
    		malt: '\u2720',
    		maltese: '\u2720',
    		Map: '\u2905',
    		map: '\u21A6',
    		mapsto: '\u21A6',
    		mapstodown: '\u21A7',
    		mapstoleft: '\u21A4',
    		mapstoup: '\u21A5',
    		marker: '\u25AE',
    		mcomma: '\u2A29',
    		Mcy: '\u041C',
    		mcy: '\u043C',
    		mdash: '\u2014',
    		mDDot: '\u223A',
    		measuredangle: '\u2221',
    		MediumSpace: '\u205F',
    		Mellintrf: '\u2133',
    		Mfr: '\uD835\uDD10',
    		mfr: '\uD835\uDD2A',
    		mho: '\u2127',
    		micro: '\u00B5',
    		mid: '\u2223',
    		midast: '\u002A',
    		midcir: '\u2AF0',
    		middot: '\u00B7',
    		minus: '\u2212',
    		minusb: '\u229F',
    		minusd: '\u2238',
    		minusdu: '\u2A2A',
    		MinusPlus: '\u2213',
    		mlcp: '\u2ADB',
    		mldr: '\u2026',
    		mnplus: '\u2213',
    		models: '\u22A7',
    		Mopf: '\uD835\uDD44',
    		mopf: '\uD835\uDD5E',
    		mp: '\u2213',
    		Mscr: '\u2133',
    		mscr: '\uD835\uDCC2',
    		mstpos: '\u223E',
    		Mu: '\u039C',
    		mu: '\u03BC',
    		multimap: '\u22B8',
    		mumap: '\u22B8',
    		nabla: '\u2207',
    		Nacute: '\u0143',
    		nacute: '\u0144',
    		nang: '\u2220\u20D2',
    		nap: '\u2249',
    		napE: '\u2A70\u0338',
    		napid: '\u224B\u0338',
    		napos: '\u0149',
    		napprox: '\u2249',
    		natur: '\u266E',
    		natural: '\u266E',
    		naturals: '\u2115',
    		nbsp: '\u00A0',
    		nbump: '\u224E\u0338',
    		nbumpe: '\u224F\u0338',
    		ncap: '\u2A43',
    		Ncaron: '\u0147',
    		ncaron: '\u0148',
    		Ncedil: '\u0145',
    		ncedil: '\u0146',
    		ncong: '\u2247',
    		ncongdot: '\u2A6D\u0338',
    		ncup: '\u2A42',
    		Ncy: '\u041D',
    		ncy: '\u043D',
    		ndash: '\u2013',
    		ne: '\u2260',
    		nearhk: '\u2924',
    		neArr: '\u21D7',
    		nearr: '\u2197',
    		nearrow: '\u2197',
    		nedot: '\u2250\u0338',
    		NegativeMediumSpace: '\u200B',
    		NegativeThickSpace: '\u200B',
    		NegativeThinSpace: '\u200B',
    		NegativeVeryThinSpace: '\u200B',
    		nequiv: '\u2262',
    		nesear: '\u2928',
    		nesim: '\u2242\u0338',
    		NestedGreaterGreater: '\u226B',
    		NestedLessLess: '\u226A',
    		NewLine: '\u000A',
    		nexist: '\u2204',
    		nexists: '\u2204',
    		Nfr: '\uD835\uDD11',
    		nfr: '\uD835\uDD2B',
    		ngE: '\u2267\u0338',
    		nge: '\u2271',
    		ngeq: '\u2271',
    		ngeqq: '\u2267\u0338',
    		ngeqslant: '\u2A7E\u0338',
    		nges: '\u2A7E\u0338',
    		nGg: '\u22D9\u0338',
    		ngsim: '\u2275',
    		nGt: '\u226B\u20D2',
    		ngt: '\u226F',
    		ngtr: '\u226F',
    		nGtv: '\u226B\u0338',
    		nhArr: '\u21CE',
    		nharr: '\u21AE',
    		nhpar: '\u2AF2',
    		ni: '\u220B',
    		nis: '\u22FC',
    		nisd: '\u22FA',
    		niv: '\u220B',
    		NJcy: '\u040A',
    		njcy: '\u045A',
    		nlArr: '\u21CD',
    		nlarr: '\u219A',
    		nldr: '\u2025',
    		nlE: '\u2266\u0338',
    		nle: '\u2270',
    		nLeftarrow: '\u21CD',
    		nleftarrow: '\u219A',
    		nLeftrightarrow: '\u21CE',
    		nleftrightarrow: '\u21AE',
    		nleq: '\u2270',
    		nleqq: '\u2266\u0338',
    		nleqslant: '\u2A7D\u0338',
    		nles: '\u2A7D\u0338',
    		nless: '\u226E',
    		nLl: '\u22D8\u0338',
    		nlsim: '\u2274',
    		nLt: '\u226A\u20D2',
    		nlt: '\u226E',
    		nltri: '\u22EA',
    		nltrie: '\u22EC',
    		nLtv: '\u226A\u0338',
    		nmid: '\u2224',
    		NoBreak: '\u2060',
    		NonBreakingSpace: '\u00A0',
    		Nopf: '\u2115',
    		nopf: '\uD835\uDD5F',
    		Not: '\u2AEC',
    		not: '\u00AC',
    		NotCongruent: '\u2262',
    		NotCupCap: '\u226D',
    		NotDoubleVerticalBar: '\u2226',
    		NotElement: '\u2209',
    		NotEqual: '\u2260',
    		NotEqualTilde: '\u2242\u0338',
    		NotExists: '\u2204',
    		NotGreater: '\u226F',
    		NotGreaterEqual: '\u2271',
    		NotGreaterFullEqual: '\u2267\u0338',
    		NotGreaterGreater: '\u226B\u0338',
    		NotGreaterLess: '\u2279',
    		NotGreaterSlantEqual: '\u2A7E\u0338',
    		NotGreaterTilde: '\u2275',
    		NotHumpDownHump: '\u224E\u0338',
    		NotHumpEqual: '\u224F\u0338',
    		notin: '\u2209',
    		notindot: '\u22F5\u0338',
    		notinE: '\u22F9\u0338',
    		notinva: '\u2209',
    		notinvb: '\u22F7',
    		notinvc: '\u22F6',
    		NotLeftTriangle: '\u22EA',
    		NotLeftTriangleBar: '\u29CF\u0338',
    		NotLeftTriangleEqual: '\u22EC',
    		NotLess: '\u226E',
    		NotLessEqual: '\u2270',
    		NotLessGreater: '\u2278',
    		NotLessLess: '\u226A\u0338',
    		NotLessSlantEqual: '\u2A7D\u0338',
    		NotLessTilde: '\u2274',
    		NotNestedGreaterGreater: '\u2AA2\u0338',
    		NotNestedLessLess: '\u2AA1\u0338',
    		notni: '\u220C',
    		notniva: '\u220C',
    		notnivb: '\u22FE',
    		notnivc: '\u22FD',
    		NotPrecedes: '\u2280',
    		NotPrecedesEqual: '\u2AAF\u0338',
    		NotPrecedesSlantEqual: '\u22E0',
    		NotReverseElement: '\u220C',
    		NotRightTriangle: '\u22EB',
    		NotRightTriangleBar: '\u29D0\u0338',
    		NotRightTriangleEqual: '\u22ED',
    		NotSquareSubset: '\u228F\u0338',
    		NotSquareSubsetEqual: '\u22E2',
    		NotSquareSuperset: '\u2290\u0338',
    		NotSquareSupersetEqual: '\u22E3',
    		NotSubset: '\u2282\u20D2',
    		NotSubsetEqual: '\u2288',
    		NotSucceeds: '\u2281',
    		NotSucceedsEqual: '\u2AB0\u0338',
    		NotSucceedsSlantEqual: '\u22E1',
    		NotSucceedsTilde: '\u227F\u0338',
    		NotSuperset: '\u2283\u20D2',
    		NotSupersetEqual: '\u2289',
    		NotTilde: '\u2241',
    		NotTildeEqual: '\u2244',
    		NotTildeFullEqual: '\u2247',
    		NotTildeTilde: '\u2249',
    		NotVerticalBar: '\u2224',
    		npar: '\u2226',
    		nparallel: '\u2226',
    		nparsl: '\u2AFD\u20E5',
    		npart: '\u2202\u0338',
    		npolint: '\u2A14',
    		npr: '\u2280',
    		nprcue: '\u22E0',
    		npre: '\u2AAF\u0338',
    		nprec: '\u2280',
    		npreceq: '\u2AAF\u0338',
    		nrArr: '\u21CF',
    		nrarr: '\u219B',
    		nrarrc: '\u2933\u0338',
    		nrarrw: '\u219D\u0338',
    		nRightarrow: '\u21CF',
    		nrightarrow: '\u219B',
    		nrtri: '\u22EB',
    		nrtrie: '\u22ED',
    		nsc: '\u2281',
    		nsccue: '\u22E1',
    		nsce: '\u2AB0\u0338',
    		Nscr: '\uD835\uDCA9',
    		nscr: '\uD835\uDCC3',
    		nshortmid: '\u2224',
    		nshortparallel: '\u2226',
    		nsim: '\u2241',
    		nsime: '\u2244',
    		nsimeq: '\u2244',
    		nsmid: '\u2224',
    		nspar: '\u2226',
    		nsqsube: '\u22E2',
    		nsqsupe: '\u22E3',
    		nsub: '\u2284',
    		nsubE: '\u2AC5\u0338',
    		nsube: '\u2288',
    		nsubset: '\u2282\u20D2',
    		nsubseteq: '\u2288',
    		nsubseteqq: '\u2AC5\u0338',
    		nsucc: '\u2281',
    		nsucceq: '\u2AB0\u0338',
    		nsup: '\u2285',
    		nsupE: '\u2AC6\u0338',
    		nsupe: '\u2289',
    		nsupset: '\u2283\u20D2',
    		nsupseteq: '\u2289',
    		nsupseteqq: '\u2AC6\u0338',
    		ntgl: '\u2279',
    		Ntilde: '\u00D1',
    		ntilde: '\u00F1',
    		ntlg: '\u2278',
    		ntriangleleft: '\u22EA',
    		ntrianglelefteq: '\u22EC',
    		ntriangleright: '\u22EB',
    		ntrianglerighteq: '\u22ED',
    		Nu: '\u039D',
    		nu: '\u03BD',
    		num: '\u0023',
    		numero: '\u2116',
    		numsp: '\u2007',
    		nvap: '\u224D\u20D2',
    		nVDash: '\u22AF',
    		nVdash: '\u22AE',
    		nvDash: '\u22AD',
    		nvdash: '\u22AC',
    		nvge: '\u2265\u20D2',
    		nvgt: '\u003E\u20D2',
    		nvHarr: '\u2904',
    		nvinfin: '\u29DE',
    		nvlArr: '\u2902',
    		nvle: '\u2264\u20D2',
    		nvlt: '\u003C\u20D2',
    		nvltrie: '\u22B4\u20D2',
    		nvrArr: '\u2903',
    		nvrtrie: '\u22B5\u20D2',
    		nvsim: '\u223C\u20D2',
    		nwarhk: '\u2923',
    		nwArr: '\u21D6',
    		nwarr: '\u2196',
    		nwarrow: '\u2196',
    		nwnear: '\u2927',
    		Oacute: '\u00D3',
    		oacute: '\u00F3',
    		oast: '\u229B',
    		ocir: '\u229A',
    		Ocirc: '\u00D4',
    		ocirc: '\u00F4',
    		Ocy: '\u041E',
    		ocy: '\u043E',
    		odash: '\u229D',
    		Odblac: '\u0150',
    		odblac: '\u0151',
    		odiv: '\u2A38',
    		odot: '\u2299',
    		odsold: '\u29BC',
    		OElig: '\u0152',
    		oelig: '\u0153',
    		ofcir: '\u29BF',
    		Ofr: '\uD835\uDD12',
    		ofr: '\uD835\uDD2C',
    		ogon: '\u02DB',
    		Ograve: '\u00D2',
    		ograve: '\u00F2',
    		ogt: '\u29C1',
    		ohbar: '\u29B5',
    		ohm: '\u03A9',
    		oint: '\u222E',
    		olarr: '\u21BA',
    		olcir: '\u29BE',
    		olcross: '\u29BB',
    		oline: '\u203E',
    		olt: '\u29C0',
    		Omacr: '\u014C',
    		omacr: '\u014D',
    		Omega: '\u03A9',
    		omega: '\u03C9',
    		Omicron: '\u039F',
    		omicron: '\u03BF',
    		omid: '\u29B6',
    		ominus: '\u2296',
    		Oopf: '\uD835\uDD46',
    		oopf: '\uD835\uDD60',
    		opar: '\u29B7',
    		OpenCurlyDoubleQuote: '\u201C',
    		OpenCurlyQuote: '\u2018',
    		operp: '\u29B9',
    		oplus: '\u2295',
    		Or: '\u2A54',
    		or: '\u2228',
    		orarr: '\u21BB',
    		ord: '\u2A5D',
    		order: '\u2134',
    		orderof: '\u2134',
    		ordf: '\u00AA',
    		ordm: '\u00BA',
    		origof: '\u22B6',
    		oror: '\u2A56',
    		orslope: '\u2A57',
    		orv: '\u2A5B',
    		oS: '\u24C8',
    		Oscr: '\uD835\uDCAA',
    		oscr: '\u2134',
    		Oslash: '\u00D8',
    		oslash: '\u00F8',
    		osol: '\u2298',
    		Otilde: '\u00D5',
    		otilde: '\u00F5',
    		Otimes: '\u2A37',
    		otimes: '\u2297',
    		otimesas: '\u2A36',
    		Ouml: '\u00D6',
    		ouml: '\u00F6',
    		ovbar: '\u233D',
    		OverBar: '\u203E',
    		OverBrace: '\u23DE',
    		OverBracket: '\u23B4',
    		OverParenthesis: '\u23DC',
    		par: '\u2225',
    		para: '\u00B6',
    		parallel: '\u2225',
    		parsim: '\u2AF3',
    		parsl: '\u2AFD',
    		part: '\u2202',
    		PartialD: '\u2202',
    		Pcy: '\u041F',
    		pcy: '\u043F',
    		percnt: '\u0025',
    		period: '\u002E',
    		permil: '\u2030',
    		perp: '\u22A5',
    		pertenk: '\u2031',
    		Pfr: '\uD835\uDD13',
    		pfr: '\uD835\uDD2D',
    		Phi: '\u03A6',
    		phi: '\u03C6',
    		phiv: '\u03D5',
    		phmmat: '\u2133',
    		phone: '\u260E',
    		Pi: '\u03A0',
    		pi: '\u03C0',
    		pitchfork: '\u22D4',
    		piv: '\u03D6',
    		planck: '\u210F',
    		planckh: '\u210E',
    		plankv: '\u210F',
    		plus: '\u002B',
    		plusacir: '\u2A23',
    		plusb: '\u229E',
    		pluscir: '\u2A22',
    		plusdo: '\u2214',
    		plusdu: '\u2A25',
    		pluse: '\u2A72',
    		PlusMinus: '\u00B1',
    		plusmn: '\u00B1',
    		plussim: '\u2A26',
    		plustwo: '\u2A27',
    		pm: '\u00B1',
    		Poincareplane: '\u210C',
    		pointint: '\u2A15',
    		Popf: '\u2119',
    		popf: '\uD835\uDD61',
    		pound: '\u00A3',
    		Pr: '\u2ABB',
    		pr: '\u227A',
    		prap: '\u2AB7',
    		prcue: '\u227C',
    		prE: '\u2AB3',
    		pre: '\u2AAF',
    		prec: '\u227A',
    		precapprox: '\u2AB7',
    		preccurlyeq: '\u227C',
    		Precedes: '\u227A',
    		PrecedesEqual: '\u2AAF',
    		PrecedesSlantEqual: '\u227C',
    		PrecedesTilde: '\u227E',
    		preceq: '\u2AAF',
    		precnapprox: '\u2AB9',
    		precneqq: '\u2AB5',
    		precnsim: '\u22E8',
    		precsim: '\u227E',
    		Prime: '\u2033',
    		prime: '\u2032',
    		primes: '\u2119',
    		prnap: '\u2AB9',
    		prnE: '\u2AB5',
    		prnsim: '\u22E8',
    		prod: '\u220F',
    		Product: '\u220F',
    		profalar: '\u232E',
    		profline: '\u2312',
    		profsurf: '\u2313',
    		prop: '\u221D',
    		Proportion: '\u2237',
    		Proportional: '\u221D',
    		propto: '\u221D',
    		prsim: '\u227E',
    		prurel: '\u22B0',
    		Pscr: '\uD835\uDCAB',
    		pscr: '\uD835\uDCC5',
    		Psi: '\u03A8',
    		psi: '\u03C8',
    		puncsp: '\u2008',
    		Qfr: '\uD835\uDD14',
    		qfr: '\uD835\uDD2E',
    		qint: '\u2A0C',
    		Qopf: '\u211A',
    		qopf: '\uD835\uDD62',
    		qprime: '\u2057',
    		Qscr: '\uD835\uDCAC',
    		qscr: '\uD835\uDCC6',
    		quaternions: '\u210D',
    		quatint: '\u2A16',
    		quest: '\u003F',
    		questeq: '\u225F',
    		QUOT: '\u0022',
    		quot: '\u0022',
    		rAarr: '\u21DB',
    		race: '\u223D\u0331',
    		Racute: '\u0154',
    		racute: '\u0155',
    		radic: '\u221A',
    		raemptyv: '\u29B3',
    		Rang: '\u27EB',
    		rang: '\u27E9',
    		rangd: '\u2992',
    		range: '\u29A5',
    		rangle: '\u27E9',
    		raquo: '\u00BB',
    		Rarr: '\u21A0',
    		rArr: '\u21D2',
    		rarr: '\u2192',
    		rarrap: '\u2975',
    		rarrb: '\u21E5',
    		rarrbfs: '\u2920',
    		rarrc: '\u2933',
    		rarrfs: '\u291E',
    		rarrhk: '\u21AA',
    		rarrlp: '\u21AC',
    		rarrpl: '\u2945',
    		rarrsim: '\u2974',
    		Rarrtl: '\u2916',
    		rarrtl: '\u21A3',
    		rarrw: '\u219D',
    		rAtail: '\u291C',
    		ratail: '\u291A',
    		ratio: '\u2236',
    		rationals: '\u211A',
    		RBarr: '\u2910',
    		rBarr: '\u290F',
    		rbarr: '\u290D',
    		rbbrk: '\u2773',
    		rbrace: '\u007D',
    		rbrack: '\u005D',
    		rbrke: '\u298C',
    		rbrksld: '\u298E',
    		rbrkslu: '\u2990',
    		Rcaron: '\u0158',
    		rcaron: '\u0159',
    		Rcedil: '\u0156',
    		rcedil: '\u0157',
    		rceil: '\u2309',
    		rcub: '\u007D',
    		Rcy: '\u0420',
    		rcy: '\u0440',
    		rdca: '\u2937',
    		rdldhar: '\u2969',
    		rdquo: '\u201D',
    		rdquor: '\u201D',
    		rdsh: '\u21B3',
    		Re: '\u211C',
    		real: '\u211C',
    		realine: '\u211B',
    		realpart: '\u211C',
    		reals: '\u211D',
    		rect: '\u25AD',
    		REG: '\u00AE',
    		reg: '\u00AE',
    		ReverseElement: '\u220B',
    		ReverseEquilibrium: '\u21CB',
    		ReverseUpEquilibrium: '\u296F',
    		rfisht: '\u297D',
    		rfloor: '\u230B',
    		Rfr: '\u211C',
    		rfr: '\uD835\uDD2F',
    		rHar: '\u2964',
    		rhard: '\u21C1',
    		rharu: '\u21C0',
    		rharul: '\u296C',
    		Rho: '\u03A1',
    		rho: '\u03C1',
    		rhov: '\u03F1',
    		RightAngleBracket: '\u27E9',
    		RightArrow: '\u2192',
    		Rightarrow: '\u21D2',
    		rightarrow: '\u2192',
    		RightArrowBar: '\u21E5',
    		RightArrowLeftArrow: '\u21C4',
    		rightarrowtail: '\u21A3',
    		RightCeiling: '\u2309',
    		RightDoubleBracket: '\u27E7',
    		RightDownTeeVector: '\u295D',
    		RightDownVector: '\u21C2',
    		RightDownVectorBar: '\u2955',
    		RightFloor: '\u230B',
    		rightharpoondown: '\u21C1',
    		rightharpoonup: '\u21C0',
    		rightleftarrows: '\u21C4',
    		rightleftharpoons: '\u21CC',
    		rightrightarrows: '\u21C9',
    		rightsquigarrow: '\u219D',
    		RightTee: '\u22A2',
    		RightTeeArrow: '\u21A6',
    		RightTeeVector: '\u295B',
    		rightthreetimes: '\u22CC',
    		RightTriangle: '\u22B3',
    		RightTriangleBar: '\u29D0',
    		RightTriangleEqual: '\u22B5',
    		RightUpDownVector: '\u294F',
    		RightUpTeeVector: '\u295C',
    		RightUpVector: '\u21BE',
    		RightUpVectorBar: '\u2954',
    		RightVector: '\u21C0',
    		RightVectorBar: '\u2953',
    		ring: '\u02DA',
    		risingdotseq: '\u2253',
    		rlarr: '\u21C4',
    		rlhar: '\u21CC',
    		rlm: '\u200F',
    		rmoust: '\u23B1',
    		rmoustache: '\u23B1',
    		rnmid: '\u2AEE',
    		roang: '\u27ED',
    		roarr: '\u21FE',
    		robrk: '\u27E7',
    		ropar: '\u2986',
    		Ropf: '\u211D',
    		ropf: '\uD835\uDD63',
    		roplus: '\u2A2E',
    		rotimes: '\u2A35',
    		RoundImplies: '\u2970',
    		rpar: '\u0029',
    		rpargt: '\u2994',
    		rppolint: '\u2A12',
    		rrarr: '\u21C9',
    		Rrightarrow: '\u21DB',
    		rsaquo: '\u203A',
    		Rscr: '\u211B',
    		rscr: '\uD835\uDCC7',
    		Rsh: '\u21B1',
    		rsh: '\u21B1',
    		rsqb: '\u005D',
    		rsquo: '\u2019',
    		rsquor: '\u2019',
    		rthree: '\u22CC',
    		rtimes: '\u22CA',
    		rtri: '\u25B9',
    		rtrie: '\u22B5',
    		rtrif: '\u25B8',
    		rtriltri: '\u29CE',
    		RuleDelayed: '\u29F4',
    		ruluhar: '\u2968',
    		rx: '\u211E',
    		Sacute: '\u015A',
    		sacute: '\u015B',
    		sbquo: '\u201A',
    		Sc: '\u2ABC',
    		sc: '\u227B',
    		scap: '\u2AB8',
    		Scaron: '\u0160',
    		scaron: '\u0161',
    		sccue: '\u227D',
    		scE: '\u2AB4',
    		sce: '\u2AB0',
    		Scedil: '\u015E',
    		scedil: '\u015F',
    		Scirc: '\u015C',
    		scirc: '\u015D',
    		scnap: '\u2ABA',
    		scnE: '\u2AB6',
    		scnsim: '\u22E9',
    		scpolint: '\u2A13',
    		scsim: '\u227F',
    		Scy: '\u0421',
    		scy: '\u0441',
    		sdot: '\u22C5',
    		sdotb: '\u22A1',
    		sdote: '\u2A66',
    		searhk: '\u2925',
    		seArr: '\u21D8',
    		searr: '\u2198',
    		searrow: '\u2198',
    		sect: '\u00A7',
    		semi: '\u003B',
    		seswar: '\u2929',
    		setminus: '\u2216',
    		setmn: '\u2216',
    		sext: '\u2736',
    		Sfr: '\uD835\uDD16',
    		sfr: '\uD835\uDD30',
    		sfrown: '\u2322',
    		sharp: '\u266F',
    		SHCHcy: '\u0429',
    		shchcy: '\u0449',
    		SHcy: '\u0428',
    		shcy: '\u0448',
    		ShortDownArrow: '\u2193',
    		ShortLeftArrow: '\u2190',
    		shortmid: '\u2223',
    		shortparallel: '\u2225',
    		ShortRightArrow: '\u2192',
    		ShortUpArrow: '\u2191',
    		shy: '\u00AD',
    		Sigma: '\u03A3',
    		sigma: '\u03C3',
    		sigmaf: '\u03C2',
    		sigmav: '\u03C2',
    		sim: '\u223C',
    		simdot: '\u2A6A',
    		sime: '\u2243',
    		simeq: '\u2243',
    		simg: '\u2A9E',
    		simgE: '\u2AA0',
    		siml: '\u2A9D',
    		simlE: '\u2A9F',
    		simne: '\u2246',
    		simplus: '\u2A24',
    		simrarr: '\u2972',
    		slarr: '\u2190',
    		SmallCircle: '\u2218',
    		smallsetminus: '\u2216',
    		smashp: '\u2A33',
    		smeparsl: '\u29E4',
    		smid: '\u2223',
    		smile: '\u2323',
    		smt: '\u2AAA',
    		smte: '\u2AAC',
    		smtes: '\u2AAC\uFE00',
    		SOFTcy: '\u042C',
    		softcy: '\u044C',
    		sol: '\u002F',
    		solb: '\u29C4',
    		solbar: '\u233F',
    		Sopf: '\uD835\uDD4A',
    		sopf: '\uD835\uDD64',
    		spades: '\u2660',
    		spadesuit: '\u2660',
    		spar: '\u2225',
    		sqcap: '\u2293',
    		sqcaps: '\u2293\uFE00',
    		sqcup: '\u2294',
    		sqcups: '\u2294\uFE00',
    		Sqrt: '\u221A',
    		sqsub: '\u228F',
    		sqsube: '\u2291',
    		sqsubset: '\u228F',
    		sqsubseteq: '\u2291',
    		sqsup: '\u2290',
    		sqsupe: '\u2292',
    		sqsupset: '\u2290',
    		sqsupseteq: '\u2292',
    		squ: '\u25A1',
    		Square: '\u25A1',
    		square: '\u25A1',
    		SquareIntersection: '\u2293',
    		SquareSubset: '\u228F',
    		SquareSubsetEqual: '\u2291',
    		SquareSuperset: '\u2290',
    		SquareSupersetEqual: '\u2292',
    		SquareUnion: '\u2294',
    		squarf: '\u25AA',
    		squf: '\u25AA',
    		srarr: '\u2192',
    		Sscr: '\uD835\uDCAE',
    		sscr: '\uD835\uDCC8',
    		ssetmn: '\u2216',
    		ssmile: '\u2323',
    		sstarf: '\u22C6',
    		Star: '\u22C6',
    		star: '\u2606',
    		starf: '\u2605',
    		straightepsilon: '\u03F5',
    		straightphi: '\u03D5',
    		strns: '\u00AF',
    		Sub: '\u22D0',
    		sub: '\u2282',
    		subdot: '\u2ABD',
    		subE: '\u2AC5',
    		sube: '\u2286',
    		subedot: '\u2AC3',
    		submult: '\u2AC1',
    		subnE: '\u2ACB',
    		subne: '\u228A',
    		subplus: '\u2ABF',
    		subrarr: '\u2979',
    		Subset: '\u22D0',
    		subset: '\u2282',
    		subseteq: '\u2286',
    		subseteqq: '\u2AC5',
    		SubsetEqual: '\u2286',
    		subsetneq: '\u228A',
    		subsetneqq: '\u2ACB',
    		subsim: '\u2AC7',
    		subsub: '\u2AD5',
    		subsup: '\u2AD3',
    		succ: '\u227B',
    		succapprox: '\u2AB8',
    		succcurlyeq: '\u227D',
    		Succeeds: '\u227B',
    		SucceedsEqual: '\u2AB0',
    		SucceedsSlantEqual: '\u227D',
    		SucceedsTilde: '\u227F',
    		succeq: '\u2AB0',
    		succnapprox: '\u2ABA',
    		succneqq: '\u2AB6',
    		succnsim: '\u22E9',
    		succsim: '\u227F',
    		SuchThat: '\u220B',
    		Sum: '\u2211',
    		sum: '\u2211',
    		sung: '\u266A',
    		Sup: '\u22D1',
    		sup: '\u2283',
    		sup1: '\u00B9',
    		sup2: '\u00B2',
    		sup3: '\u00B3',
    		supdot: '\u2ABE',
    		supdsub: '\u2AD8',
    		supE: '\u2AC6',
    		supe: '\u2287',
    		supedot: '\u2AC4',
    		Superset: '\u2283',
    		SupersetEqual: '\u2287',
    		suphsol: '\u27C9',
    		suphsub: '\u2AD7',
    		suplarr: '\u297B',
    		supmult: '\u2AC2',
    		supnE: '\u2ACC',
    		supne: '\u228B',
    		supplus: '\u2AC0',
    		Supset: '\u22D1',
    		supset: '\u2283',
    		supseteq: '\u2287',
    		supseteqq: '\u2AC6',
    		supsetneq: '\u228B',
    		supsetneqq: '\u2ACC',
    		supsim: '\u2AC8',
    		supsub: '\u2AD4',
    		supsup: '\u2AD6',
    		swarhk: '\u2926',
    		swArr: '\u21D9',
    		swarr: '\u2199',
    		swarrow: '\u2199',
    		swnwar: '\u292A',
    		szlig: '\u00DF',
    		Tab: '\u0009',
    		target: '\u2316',
    		Tau: '\u03A4',
    		tau: '\u03C4',
    		tbrk: '\u23B4',
    		Tcaron: '\u0164',
    		tcaron: '\u0165',
    		Tcedil: '\u0162',
    		tcedil: '\u0163',
    		Tcy: '\u0422',
    		tcy: '\u0442',
    		tdot: '\u20DB',
    		telrec: '\u2315',
    		Tfr: '\uD835\uDD17',
    		tfr: '\uD835\uDD31',
    		there4: '\u2234',
    		Therefore: '\u2234',
    		therefore: '\u2234',
    		Theta: '\u0398',
    		theta: '\u03B8',
    		thetasym: '\u03D1',
    		thetav: '\u03D1',
    		thickapprox: '\u2248',
    		thicksim: '\u223C',
    		ThickSpace: '\u205F\u200A',
    		thinsp: '\u2009',
    		ThinSpace: '\u2009',
    		thkap: '\u2248',
    		thksim: '\u223C',
    		THORN: '\u00DE',
    		thorn: '\u00FE',
    		Tilde: '\u223C',
    		tilde: '\u02DC',
    		TildeEqual: '\u2243',
    		TildeFullEqual: '\u2245',
    		TildeTilde: '\u2248',
    		times: '\u00D7',
    		timesb: '\u22A0',
    		timesbar: '\u2A31',
    		timesd: '\u2A30',
    		tint: '\u222D',
    		toea: '\u2928',
    		top: '\u22A4',
    		topbot: '\u2336',
    		topcir: '\u2AF1',
    		Topf: '\uD835\uDD4B',
    		topf: '\uD835\uDD65',
    		topfork: '\u2ADA',
    		tosa: '\u2929',
    		tprime: '\u2034',
    		TRADE: '\u2122',
    		trade: '\u2122',
    		triangle: '\u25B5',
    		triangledown: '\u25BF',
    		triangleleft: '\u25C3',
    		trianglelefteq: '\u22B4',
    		triangleq: '\u225C',
    		triangleright: '\u25B9',
    		trianglerighteq: '\u22B5',
    		tridot: '\u25EC',
    		trie: '\u225C',
    		triminus: '\u2A3A',
    		TripleDot: '\u20DB',
    		triplus: '\u2A39',
    		trisb: '\u29CD',
    		tritime: '\u2A3B',
    		trpezium: '\u23E2',
    		Tscr: '\uD835\uDCAF',
    		tscr: '\uD835\uDCC9',
    		TScy: '\u0426',
    		tscy: '\u0446',
    		TSHcy: '\u040B',
    		tshcy: '\u045B',
    		Tstrok: '\u0166',
    		tstrok: '\u0167',
    		twixt: '\u226C',
    		twoheadleftarrow: '\u219E',
    		twoheadrightarrow: '\u21A0',
    		Uacute: '\u00DA',
    		uacute: '\u00FA',
    		Uarr: '\u219F',
    		uArr: '\u21D1',
    		uarr: '\u2191',
    		Uarrocir: '\u2949',
    		Ubrcy: '\u040E',
    		ubrcy: '\u045E',
    		Ubreve: '\u016C',
    		ubreve: '\u016D',
    		Ucirc: '\u00DB',
    		ucirc: '\u00FB',
    		Ucy: '\u0423',
    		ucy: '\u0443',
    		udarr: '\u21C5',
    		Udblac: '\u0170',
    		udblac: '\u0171',
    		udhar: '\u296E',
    		ufisht: '\u297E',
    		Ufr: '\uD835\uDD18',
    		ufr: '\uD835\uDD32',
    		Ugrave: '\u00D9',
    		ugrave: '\u00F9',
    		uHar: '\u2963',
    		uharl: '\u21BF',
    		uharr: '\u21BE',
    		uhblk: '\u2580',
    		ulcorn: '\u231C',
    		ulcorner: '\u231C',
    		ulcrop: '\u230F',
    		ultri: '\u25F8',
    		Umacr: '\u016A',
    		umacr: '\u016B',
    		uml: '\u00A8',
    		UnderBar: '\u005F',
    		UnderBrace: '\u23DF',
    		UnderBracket: '\u23B5',
    		UnderParenthesis: '\u23DD',
    		Union: '\u22C3',
    		UnionPlus: '\u228E',
    		Uogon: '\u0172',
    		uogon: '\u0173',
    		Uopf: '\uD835\uDD4C',
    		uopf: '\uD835\uDD66',
    		UpArrow: '\u2191',
    		Uparrow: '\u21D1',
    		uparrow: '\u2191',
    		UpArrowBar: '\u2912',
    		UpArrowDownArrow: '\u21C5',
    		UpDownArrow: '\u2195',
    		Updownarrow: '\u21D5',
    		updownarrow: '\u2195',
    		UpEquilibrium: '\u296E',
    		upharpoonleft: '\u21BF',
    		upharpoonright: '\u21BE',
    		uplus: '\u228E',
    		UpperLeftArrow: '\u2196',
    		UpperRightArrow: '\u2197',
    		Upsi: '\u03D2',
    		upsi: '\u03C5',
    		upsih: '\u03D2',
    		Upsilon: '\u03A5',
    		upsilon: '\u03C5',
    		UpTee: '\u22A5',
    		UpTeeArrow: '\u21A5',
    		upuparrows: '\u21C8',
    		urcorn: '\u231D',
    		urcorner: '\u231D',
    		urcrop: '\u230E',
    		Uring: '\u016E',
    		uring: '\u016F',
    		urtri: '\u25F9',
    		Uscr: '\uD835\uDCB0',
    		uscr: '\uD835\uDCCA',
    		utdot: '\u22F0',
    		Utilde: '\u0168',
    		utilde: '\u0169',
    		utri: '\u25B5',
    		utrif: '\u25B4',
    		uuarr: '\u21C8',
    		Uuml: '\u00DC',
    		uuml: '\u00FC',
    		uwangle: '\u29A7',
    		vangrt: '\u299C',
    		varepsilon: '\u03F5',
    		varkappa: '\u03F0',
    		varnothing: '\u2205',
    		varphi: '\u03D5',
    		varpi: '\u03D6',
    		varpropto: '\u221D',
    		vArr: '\u21D5',
    		varr: '\u2195',
    		varrho: '\u03F1',
    		varsigma: '\u03C2',
    		varsubsetneq: '\u228A\uFE00',
    		varsubsetneqq: '\u2ACB\uFE00',
    		varsupsetneq: '\u228B\uFE00',
    		varsupsetneqq: '\u2ACC\uFE00',
    		vartheta: '\u03D1',
    		vartriangleleft: '\u22B2',
    		vartriangleright: '\u22B3',
    		Vbar: '\u2AEB',
    		vBar: '\u2AE8',
    		vBarv: '\u2AE9',
    		Vcy: '\u0412',
    		vcy: '\u0432',
    		VDash: '\u22AB',
    		Vdash: '\u22A9',
    		vDash: '\u22A8',
    		vdash: '\u22A2',
    		Vdashl: '\u2AE6',
    		Vee: '\u22C1',
    		vee: '\u2228',
    		veebar: '\u22BB',
    		veeeq: '\u225A',
    		vellip: '\u22EE',
    		Verbar: '\u2016',
    		verbar: '\u007C',
    		Vert: '\u2016',
    		vert: '\u007C',
    		VerticalBar: '\u2223',
    		VerticalLine: '\u007C',
    		VerticalSeparator: '\u2758',
    		VerticalTilde: '\u2240',
    		VeryThinSpace: '\u200A',
    		Vfr: '\uD835\uDD19',
    		vfr: '\uD835\uDD33',
    		vltri: '\u22B2',
    		vnsub: '\u2282\u20D2',
    		vnsup: '\u2283\u20D2',
    		Vopf: '\uD835\uDD4D',
    		vopf: '\uD835\uDD67',
    		vprop: '\u221D',
    		vrtri: '\u22B3',
    		Vscr: '\uD835\uDCB1',
    		vscr: '\uD835\uDCCB',
    		vsubnE: '\u2ACB\uFE00',
    		vsubne: '\u228A\uFE00',
    		vsupnE: '\u2ACC\uFE00',
    		vsupne: '\u228B\uFE00',
    		Vvdash: '\u22AA',
    		vzigzag: '\u299A',
    		Wcirc: '\u0174',
    		wcirc: '\u0175',
    		wedbar: '\u2A5F',
    		Wedge: '\u22C0',
    		wedge: '\u2227',
    		wedgeq: '\u2259',
    		weierp: '\u2118',
    		Wfr: '\uD835\uDD1A',
    		wfr: '\uD835\uDD34',
    		Wopf: '\uD835\uDD4E',
    		wopf: '\uD835\uDD68',
    		wp: '\u2118',
    		wr: '\u2240',
    		wreath: '\u2240',
    		Wscr: '\uD835\uDCB2',
    		wscr: '\uD835\uDCCC',
    		xcap: '\u22C2',
    		xcirc: '\u25EF',
    		xcup: '\u22C3',
    		xdtri: '\u25BD',
    		Xfr: '\uD835\uDD1B',
    		xfr: '\uD835\uDD35',
    		xhArr: '\u27FA',
    		xharr: '\u27F7',
    		Xi: '\u039E',
    		xi: '\u03BE',
    		xlArr: '\u27F8',
    		xlarr: '\u27F5',
    		xmap: '\u27FC',
    		xnis: '\u22FB',
    		xodot: '\u2A00',
    		Xopf: '\uD835\uDD4F',
    		xopf: '\uD835\uDD69',
    		xoplus: '\u2A01',
    		xotime: '\u2A02',
    		xrArr: '\u27F9',
    		xrarr: '\u27F6',
    		Xscr: '\uD835\uDCB3',
    		xscr: '\uD835\uDCCD',
    		xsqcup: '\u2A06',
    		xuplus: '\u2A04',
    		xutri: '\u25B3',
    		xvee: '\u22C1',
    		xwedge: '\u22C0',
    		Yacute: '\u00DD',
    		yacute: '\u00FD',
    		YAcy: '\u042F',
    		yacy: '\u044F',
    		Ycirc: '\u0176',
    		ycirc: '\u0177',
    		Ycy: '\u042B',
    		ycy: '\u044B',
    		yen: '\u00A5',
    		Yfr: '\uD835\uDD1C',
    		yfr: '\uD835\uDD36',
    		YIcy: '\u0407',
    		yicy: '\u0457',
    		Yopf: '\uD835\uDD50',
    		yopf: '\uD835\uDD6A',
    		Yscr: '\uD835\uDCB4',
    		yscr: '\uD835\uDCCE',
    		YUcy: '\u042E',
    		yucy: '\u044E',
    		Yuml: '\u0178',
    		yuml: '\u00FF',
    		Zacute: '\u0179',
    		zacute: '\u017A',
    		Zcaron: '\u017D',
    		zcaron: '\u017E',
    		Zcy: '\u0417',
    		zcy: '\u0437',
    		Zdot: '\u017B',
    		zdot: '\u017C',
    		zeetrf: '\u2128',
    		ZeroWidthSpace: '\u200B',
    		Zeta: '\u0396',
    		zeta: '\u03B6',
    		Zfr: '\u2128',
    		zfr: '\uD835\uDD37',
    		ZHcy: '\u0416',
    		zhcy: '\u0436',
    		zigrarr: '\u21DD',
    		Zopf: '\u2124',
    		zopf: '\uD835\uDD6B',
    		Zscr: '\uD835\uDCB5',
    		zscr: '\uD835\uDCCF',
    		zwj: '\u200D',
    		zwnj: '\u200C',
    	});

    	/**
    	 * @deprecated use `HTML_ENTITIES` instead
    	 * @see HTML_ENTITIES
    	 */
    	exports.entityMap = exports.HTML_ENTITIES; 
    } (entities$2));

    var entities$1 = /*@__PURE__*/getDefaultExportFromCjs(entities$2);

    var sax$1 = {};

    var NAMESPACE$1 = conventions$2.NAMESPACE;

    //[4]   	NameStartChar	   ::=   	":" | [A-Z] | "_" | [a-z] | [#xC0-#xD6] | [#xD8-#xF6] | [#xF8-#x2FF] | [#x370-#x37D] | [#x37F-#x1FFF] | [#x200C-#x200D] | [#x2070-#x218F] | [#x2C00-#x2FEF] | [#x3001-#xD7FF] | [#xF900-#xFDCF] | [#xFDF0-#xFFFD] | [#x10000-#xEFFFF]
    //[4a]   	NameChar	   ::=   	NameStartChar | "-" | "." | [0-9] | #xB7 | [#x0300-#x036F] | [#x203F-#x2040]
    //[5]   	Name	   ::=   	NameStartChar (NameChar)*
    var nameStartChar = /[A-Z_a-z\xC0-\xD6\xD8-\xF6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/;//\u10000-\uEFFFF
    var nameChar = new RegExp("[\\-\\.0-9"+nameStartChar.source.slice(1,-1)+"\\u00B7\\u0300-\\u036F\\u203F-\\u2040]");
    var tagNamePattern = new RegExp('^'+nameStartChar.source+nameChar.source+'*(?:\:'+nameStartChar.source+nameChar.source+'*)?$');
    //var tagNamePattern = /^[a-zA-Z_][\w\-\.]*(?:\:[a-zA-Z_][\w\-\.]*)?$/
    //var handlers = 'resolveEntity,getExternalSubset,characters,endDocument,endElement,endPrefixMapping,ignorableWhitespace,processingInstruction,setDocumentLocator,skippedEntity,startDocument,startElement,startPrefixMapping,notationDecl,unparsedEntityDecl,error,fatalError,warning,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,comment,endCDATA,endDTD,endEntity,startCDATA,startDTD,startEntity'.split(',')

    //S_TAG,	S_ATTR,	S_EQ,	S_ATTR_NOQUOT_VALUE
    //S_ATTR_SPACE,	S_ATTR_END,	S_TAG_SPACE, S_TAG_CLOSE
    var S_TAG = 0;//tag name offerring
    var S_ATTR = 1;//attr name offerring
    var S_ATTR_SPACE=2;//attr name end and space offer
    var S_EQ = 3;//=space?
    var S_ATTR_NOQUOT_VALUE = 4;//attr value(no quot value only)
    var S_ATTR_END = 5;//attr value end and no space(quot end)
    var S_TAG_SPACE = 6;//(attr value end || tag end ) && (space offer)
    var S_TAG_CLOSE = 7;//closed el<el />

    /**
     * Creates an error that will not be caught by XMLReader aka the SAX parser.
     *
     * @param {string} message
     * @param {any?} locator Optional, can provide details about the location in the source
     * @constructor
     */
    function ParseError$1(message, locator) {
    	this.message = message;
    	this.locator = locator;
    	if(Error.captureStackTrace) Error.captureStackTrace(this, ParseError$1);
    }
    ParseError$1.prototype = new Error();
    ParseError$1.prototype.name = ParseError$1.name;

    function XMLReader$1(){

    }

    XMLReader$1.prototype = {
    	parse:function(source,defaultNSMap,entityMap){
    		var domBuilder = this.domBuilder;
    		domBuilder.startDocument();
    		_copy(defaultNSMap ,defaultNSMap = {});
    		parse$2(source,defaultNSMap,entityMap,
    				domBuilder,this.errorHandler);
    		domBuilder.endDocument();
    	}
    };
    function parse$2(source,defaultNSMapCopy,entityMap,domBuilder,errorHandler){
    	function fixedFromCharCode(code) {
    		// String.prototype.fromCharCode does not supports
    		// > 2 bytes unicode chars directly
    		if (code > 0xffff) {
    			code -= 0x10000;
    			var surrogate1 = 0xd800 + (code >> 10)
    				, surrogate2 = 0xdc00 + (code & 0x3ff);

    			return String.fromCharCode(surrogate1, surrogate2);
    		} else {
    			return String.fromCharCode(code);
    		}
    	}
    	function entityReplacer(a){
    		var k = a.slice(1,-1);
    		if (Object.hasOwnProperty.call(entityMap, k)) {
    			return entityMap[k];
    		}else if(k.charAt(0) === '#'){
    			return fixedFromCharCode(parseInt(k.substr(1).replace('x','0x')))
    		}else {
    			errorHandler.error('entity not found:'+a);
    			return a;
    		}
    	}
    	function appendText(end){//has some bugs
    		if(end>start){
    			var xt = source.substring(start,end).replace(/&#?\w+;/g,entityReplacer);
    			locator&&position(start);
    			domBuilder.characters(xt,0,end-start);
    			start = end;
    		}
    	}
    	function position(p,m){
    		while(p>=lineEnd && (m = linePattern.exec(source))){
    			lineStart = m.index;
    			lineEnd = lineStart + m[0].length;
    			locator.lineNumber++;
    			//console.log('line++:',locator,startPos,endPos)
    		}
    		locator.columnNumber = p-lineStart+1;
    	}
    	var lineStart = 0;
    	var lineEnd = 0;
    	var linePattern = /.*(?:\r\n?|\n)|.*$/g;
    	var locator = domBuilder.locator;

    	var parseStack = [{currentNSMap:defaultNSMapCopy}];
    	var closeMap = {};
    	var start = 0;
    	while(true){
    		try{
    			var tagStart = source.indexOf('<',start);
    			if(tagStart<0){
    				if(!source.substr(start).match(/^\s*$/)){
    					var doc = domBuilder.doc;
    	    			var text = doc.createTextNode(source.substr(start));
    	    			doc.appendChild(text);
    	    			domBuilder.currentElement = text;
    				}
    				return;
    			}
    			if(tagStart>start){
    				appendText(tagStart);
    			}
    			switch(source.charAt(tagStart+1)){
    			case '/':
    				var end = source.indexOf('>',tagStart+3);
    				var tagName = source.substring(tagStart + 2, end).replace(/[ \t\n\r]+$/g, '');
    				var config = parseStack.pop();
    				if(end<0){

    	        		tagName = source.substring(tagStart+2).replace(/[\s<].*/,'');
    	        		errorHandler.error("end tag name: "+tagName+' is not complete:'+config.tagName);
    	        		end = tagStart+1+tagName.length;
    	        	}else if(tagName.match(/\s</)){
    	        		tagName = tagName.replace(/[\s<].*/,'');
    	        		errorHandler.error("end tag name: "+tagName+' maybe not complete');
    	        		end = tagStart+1+tagName.length;
    				}
    				var localNSMap = config.localNSMap;
    				var endMatch = config.tagName == tagName;
    				var endIgnoreCaseMach = endMatch || config.tagName&&config.tagName.toLowerCase() == tagName.toLowerCase();
    		        if(endIgnoreCaseMach){
    		        	domBuilder.endElement(config.uri,config.localName,tagName);
    					if(localNSMap){
    						for (var prefix in localNSMap) {
    							if (Object.prototype.hasOwnProperty.call(localNSMap, prefix)) {
    								domBuilder.endPrefixMapping(prefix);
    							}
    						}
    					}
    					if(!endMatch){
    		            	errorHandler.fatalError("end tag name: "+tagName+' is not match the current start tagName:'+config.tagName ); // No known test case
    					}
    		        }else {
    		        	parseStack.push(config);
    		        }

    				end++;
    				break;
    				// end elment
    			case '?':// <?...?>
    				locator&&position(tagStart);
    				end = parseInstruction(source,tagStart,domBuilder);
    				break;
    			case '!':// <!doctype,<![CDATA,<!--
    				locator&&position(tagStart);
    				end = parseDCC(source,tagStart,domBuilder,errorHandler);
    				break;
    			default:
    				locator&&position(tagStart);
    				var el = new ElementAttributes();
    				var currentNSMap = parseStack[parseStack.length-1].currentNSMap;
    				//elStartEnd
    				var end = parseElementStartPart(source,tagStart,el,currentNSMap,entityReplacer,errorHandler);
    				var len = el.length;


    				if(!el.closed && fixSelfClosed(source,end,el.tagName,closeMap)){
    					el.closed = true;
    					if(!entityMap.nbsp){
    						errorHandler.warning('unclosed xml attribute');
    					}
    				}
    				if(locator && len){
    					var locator2 = copyLocator(locator,{});
    					//try{//attribute position fixed
    					for(var i = 0;i<len;i++){
    						var a = el[i];
    						position(a.offset);
    						a.locator = copyLocator(locator,{});
    					}
    					domBuilder.locator = locator2;
    					if(appendElement$1(el,domBuilder,currentNSMap)){
    						parseStack.push(el);
    					}
    					domBuilder.locator = locator;
    				}else {
    					if(appendElement$1(el,domBuilder,currentNSMap)){
    						parseStack.push(el);
    					}
    				}

    				if (NAMESPACE$1.isHTML(el.uri) && !el.closed) {
    					end = parseHtmlSpecialContent(source,end,el.tagName,entityReplacer,domBuilder);
    				} else {
    					end++;
    				}
    			}
    		}catch(e){
    			if (e instanceof ParseError$1) {
    				throw e;
    			}
    			errorHandler.error('element parse error: '+e);
    			end = -1;
    		}
    		if(end>start){
    			start = end;
    		}else {
    			//TODO: 这里有可能sax回退，有位置错误风险
    			appendText(Math.max(tagStart,start)+1);
    		}
    	}
    }
    function copyLocator(f,t){
    	t.lineNumber = f.lineNumber;
    	t.columnNumber = f.columnNumber;
    	return t;
    }

    /**
     * @see #appendElement(source,elStartEnd,el,selfClosed,entityReplacer,domBuilder,parseStack);
     * @return end of the elementStartPart(end of elementEndPart for selfClosed el)
     */
    function parseElementStartPart(source,start,el,currentNSMap,entityReplacer,errorHandler){

    	/**
    	 * @param {string} qname
    	 * @param {string} value
    	 * @param {number} startIndex
    	 */
    	function addAttribute(qname, value, startIndex) {
    		if (el.attributeNames.hasOwnProperty(qname)) {
    			errorHandler.fatalError('Attribute ' + qname + ' redefined');
    		}
    		el.addValue(
    			qname,
    			// @see https://www.w3.org/TR/xml/#AVNormalize
    			// since the xmldom sax parser does not "interpret" DTD the following is not implemented:
    			// - recursive replacement of (DTD) entity references
    			// - trimming and collapsing multiple spaces into a single one for attributes that are not of type CDATA
    			value.replace(/[\t\n\r]/g, ' ').replace(/&#?\w+;/g, entityReplacer),
    			startIndex
    		);
    	}
    	var attrName;
    	var value;
    	var p = ++start;
    	var s = S_TAG;//status
    	while(true){
    		var c = source.charAt(p);
    		switch(c){
    		case '=':
    			if(s === S_ATTR){//attrName
    				attrName = source.slice(start,p);
    				s = S_EQ;
    			}else if(s === S_ATTR_SPACE){
    				s = S_EQ;
    			}else {
    				//fatalError: equal must after attrName or space after attrName
    				throw new Error('attribute equal must after attrName'); // No known test case
    			}
    			break;
    		case '\'':
    		case '"':
    			if(s === S_EQ || s === S_ATTR //|| s == S_ATTR_SPACE
    				){//equal
    				if(s === S_ATTR){
    					errorHandler.warning('attribute value must after "="');
    					attrName = source.slice(start,p);
    				}
    				start = p+1;
    				p = source.indexOf(c,start);
    				if(p>0){
    					value = source.slice(start, p);
    					addAttribute(attrName, value, start-1);
    					s = S_ATTR_END;
    				}else {
    					//fatalError: no end quot match
    					throw new Error('attribute value no end \''+c+'\' match');
    				}
    			}else if(s == S_ATTR_NOQUOT_VALUE){
    				value = source.slice(start, p);
    				addAttribute(attrName, value, start);
    				errorHandler.warning('attribute "'+attrName+'" missed start quot('+c+')!!');
    				start = p+1;
    				s = S_ATTR_END;
    			}else {
    				//fatalError: no equal before
    				throw new Error('attribute value must after "="'); // No known test case
    			}
    			break;
    		case '/':
    			switch(s){
    			case S_TAG:
    				el.setTagName(source.slice(start,p));
    			case S_ATTR_END:
    			case S_TAG_SPACE:
    			case S_TAG_CLOSE:
    				s =S_TAG_CLOSE;
    				el.closed = true;
    			case S_ATTR_NOQUOT_VALUE:
    			case S_ATTR:
    				break;
    				case S_ATTR_SPACE:
    					el.closed = true;
    				break;
    			//case S_EQ:
    			default:
    				throw new Error("attribute invalid close char('/')") // No known test case
    			}
    			break;
    		case ''://end document
    			errorHandler.error('unexpected end of input');
    			if(s == S_TAG){
    				el.setTagName(source.slice(start,p));
    			}
    			return p;
    		case '>':
    			switch(s){
    			case S_TAG:
    				el.setTagName(source.slice(start,p));
    			case S_ATTR_END:
    			case S_TAG_SPACE:
    			case S_TAG_CLOSE:
    				break;//normal
    			case S_ATTR_NOQUOT_VALUE://Compatible state
    			case S_ATTR:
    				value = source.slice(start,p);
    				if(value.slice(-1) === '/'){
    					el.closed  = true;
    					value = value.slice(0,-1);
    				}
    			case S_ATTR_SPACE:
    				if(s === S_ATTR_SPACE){
    					value = attrName;
    				}
    				if(s == S_ATTR_NOQUOT_VALUE){
    					errorHandler.warning('attribute "'+value+'" missed quot(")!');
    					addAttribute(attrName, value, start);
    				}else {
    					if(!NAMESPACE$1.isHTML(currentNSMap['']) || !value.match(/^(?:disabled|checked|selected)$/i)){
    						errorHandler.warning('attribute "'+value+'" missed value!! "'+value+'" instead!!');
    					}
    					addAttribute(value, value, start);
    				}
    				break;
    			case S_EQ:
    				throw new Error('attribute value missed!!');
    			}
    //			console.log(tagName,tagNamePattern,tagNamePattern.test(tagName))
    			return p;
    		/*xml space '\x20' | #x9 | #xD | #xA; */
    		case '\u0080':
    			c = ' ';
    		default:
    			if(c<= ' '){//space
    				switch(s){
    				case S_TAG:
    					el.setTagName(source.slice(start,p));//tagName
    					s = S_TAG_SPACE;
    					break;
    				case S_ATTR:
    					attrName = source.slice(start,p);
    					s = S_ATTR_SPACE;
    					break;
    				case S_ATTR_NOQUOT_VALUE:
    					var value = source.slice(start, p);
    					errorHandler.warning('attribute "'+value+'" missed quot(")!!');
    					addAttribute(attrName, value, start);
    				case S_ATTR_END:
    					s = S_TAG_SPACE;
    					break;
    				//case S_TAG_SPACE:
    				//case S_EQ:
    				//case S_ATTR_SPACE:
    				//	void();break;
    				//case S_TAG_CLOSE:
    					//ignore warning
    				}
    			}else {//not space
    //S_TAG,	S_ATTR,	S_EQ,	S_ATTR_NOQUOT_VALUE
    //S_ATTR_SPACE,	S_ATTR_END,	S_TAG_SPACE, S_TAG_CLOSE
    				switch(s){
    				//case S_TAG:void();break;
    				//case S_ATTR:void();break;
    				//case S_ATTR_NOQUOT_VALUE:void();break;
    				case S_ATTR_SPACE:
    					var tagName =  el.tagName;
    					if (!NAMESPACE$1.isHTML(currentNSMap['']) || !attrName.match(/^(?:disabled|checked|selected)$/i)) {
    						errorHandler.warning('attribute "'+attrName+'" missed value!! "'+attrName+'" instead2!!');
    					}
    					addAttribute(attrName, attrName, start);
    					start = p;
    					s = S_ATTR;
    					break;
    				case S_ATTR_END:
    					errorHandler.warning('attribute space is required"'+attrName+'"!!');
    				case S_TAG_SPACE:
    					s = S_ATTR;
    					start = p;
    					break;
    				case S_EQ:
    					s = S_ATTR_NOQUOT_VALUE;
    					start = p;
    					break;
    				case S_TAG_CLOSE:
    					throw new Error("elements closed character '/' and '>' must be connected to");
    				}
    			}
    		}//end outer switch
    		//console.log('p++',p)
    		p++;
    	}
    }
    /**
     * @return true if has new namespace define
     */
    function appendElement$1(el,domBuilder,currentNSMap){
    	var tagName = el.tagName;
    	var localNSMap = null;
    	//var currentNSMap = parseStack[parseStack.length-1].currentNSMap;
    	var i = el.length;
    	while(i--){
    		var a = el[i];
    		var qName = a.qName;
    		var value = a.value;
    		var nsp = qName.indexOf(':');
    		if(nsp>0){
    			var prefix = a.prefix = qName.slice(0,nsp);
    			var localName = qName.slice(nsp+1);
    			var nsPrefix = prefix === 'xmlns' && localName;
    		}else {
    			localName = qName;
    			prefix = null;
    			nsPrefix = qName === 'xmlns' && '';
    		}
    		//can not set prefix,because prefix !== ''
    		a.localName = localName ;
    		//prefix == null for no ns prefix attribute
    		if(nsPrefix !== false){//hack!!
    			if(localNSMap == null){
    				localNSMap = {};
    				//console.log(currentNSMap,0)
    				_copy(currentNSMap,currentNSMap={});
    				//console.log(currentNSMap,1)
    			}
    			currentNSMap[nsPrefix] = localNSMap[nsPrefix] = value;
    			a.uri = NAMESPACE$1.XMLNS;
    			domBuilder.startPrefixMapping(nsPrefix, value);
    		}
    	}
    	var i = el.length;
    	while(i--){
    		a = el[i];
    		var prefix = a.prefix;
    		if(prefix){//no prefix attribute has no namespace
    			if(prefix === 'xml'){
    				a.uri = NAMESPACE$1.XML;
    			}if(prefix !== 'xmlns'){
    				a.uri = currentNSMap[prefix || ''];

    				//{console.log('###'+a.qName,domBuilder.locator.systemId+'',currentNSMap,a.uri)}
    			}
    		}
    	}
    	var nsp = tagName.indexOf(':');
    	if(nsp>0){
    		prefix = el.prefix = tagName.slice(0,nsp);
    		localName = el.localName = tagName.slice(nsp+1);
    	}else {
    		prefix = null;//important!!
    		localName = el.localName = tagName;
    	}
    	//no prefix element has default namespace
    	var ns = el.uri = currentNSMap[prefix || ''];
    	domBuilder.startElement(ns,localName,tagName,el);
    	//endPrefixMapping and startPrefixMapping have not any help for dom builder
    	//localNSMap = null
    	if(el.closed){
    		domBuilder.endElement(ns,localName,tagName);
    		if(localNSMap){
    			for (prefix in localNSMap) {
    				if (Object.prototype.hasOwnProperty.call(localNSMap, prefix)) {
    					domBuilder.endPrefixMapping(prefix);
    				}
    			}
    		}
    	}else {
    		el.currentNSMap = currentNSMap;
    		el.localNSMap = localNSMap;
    		//parseStack.push(el);
    		return true;
    	}
    }
    function parseHtmlSpecialContent(source,elStartEnd,tagName,entityReplacer,domBuilder){
    	if(/^(?:script|textarea)$/i.test(tagName)){
    		var elEndStart =  source.indexOf('</'+tagName+'>',elStartEnd);
    		var text = source.substring(elStartEnd+1,elEndStart);
    		if(/[&<]/.test(text)){
    			if(/^script$/i.test(tagName)){
    				//if(!/\]\]>/.test(text)){
    					//lexHandler.startCDATA();
    					domBuilder.characters(text,0,text.length);
    					//lexHandler.endCDATA();
    					return elEndStart;
    				//}
    			}//}else{//text area
    				text = text.replace(/&#?\w+;/g,entityReplacer);
    				domBuilder.characters(text,0,text.length);
    				return elEndStart;
    			//}

    		}
    	}
    	return elStartEnd+1;
    }
    function fixSelfClosed(source,elStartEnd,tagName,closeMap){
    	//if(tagName in closeMap){
    	var pos = closeMap[tagName];
    	if(pos == null){
    		//console.log(tagName)
    		pos =  source.lastIndexOf('</'+tagName+'>');
    		if(pos<elStartEnd){//忘记闭合
    			pos = source.lastIndexOf('</'+tagName);
    		}
    		closeMap[tagName] =pos;
    	}
    	return pos<elStartEnd;
    	//}
    }

    function _copy (source, target) {
    	for (var n in source) {
    		if (Object.prototype.hasOwnProperty.call(source, n)) {
    			target[n] = source[n];
    		}
    	}
    }

    function parseDCC(source,start,domBuilder,errorHandler){//sure start with '<!'
    	var next= source.charAt(start+2);
    	switch(next){
    	case '-':
    		if(source.charAt(start + 3) === '-'){
    			var end = source.indexOf('-->',start+4);
    			//append comment source.substring(4,end)//<!--
    			if(end>start){
    				domBuilder.comment(source,start+4,end-start-4);
    				return end+3;
    			}else {
    				errorHandler.error("Unclosed comment");
    				return -1;
    			}
    		}else {
    			//error
    			return -1;
    		}
    	default:
    		if(source.substr(start+3,6) == 'CDATA['){
    			var end = source.indexOf(']]>',start+9);
    			domBuilder.startCDATA();
    			domBuilder.characters(source,start+9,end-start-9);
    			domBuilder.endCDATA();
    			return end+3;
    		}
    		//<!DOCTYPE
    		//startDTD(java.lang.String name, java.lang.String publicId, java.lang.String systemId)
    		var matchs = split(source,start);
    		var len = matchs.length;
    		if(len>1 && /!doctype/i.test(matchs[0][0])){
    			var name = matchs[1][0];
    			var pubid = false;
    			var sysid = false;
    			if(len>3){
    				if(/^public$/i.test(matchs[2][0])){
    					pubid = matchs[3][0];
    					sysid = len>4 && matchs[4][0];
    				}else if(/^system$/i.test(matchs[2][0])){
    					sysid = matchs[3][0];
    				}
    			}
    			var lastMatch = matchs[len-1];
    			domBuilder.startDTD(name, pubid, sysid);
    			domBuilder.endDTD();

    			return lastMatch.index+lastMatch[0].length
    		}
    	}
    	return -1;
    }



    function parseInstruction(source,start,domBuilder){
    	var end = source.indexOf('?>',start);
    	if(end){
    		var match = source.substring(start,end).match(/^<\?(\S*)\s*([\s\S]*?)\s*$/);
    		if(match){
    			var len = match[0].length;
    			domBuilder.processingInstruction(match[1], match[2]) ;
    			return end+2;
    		}else {//error
    			return -1;
    		}
    	}
    	return -1;
    }

    function ElementAttributes(){
    	this.attributeNames = {};
    }
    ElementAttributes.prototype = {
    	setTagName:function(tagName){
    		if(!tagNamePattern.test(tagName)){
    			throw new Error('invalid tagName:'+tagName)
    		}
    		this.tagName = tagName;
    	},
    	addValue:function(qName, value, offset) {
    		if(!tagNamePattern.test(qName)){
    			throw new Error('invalid attribute:'+qName)
    		}
    		this.attributeNames[qName] = this.length;
    		this[this.length++] = {qName:qName,value:value,offset:offset};
    	},
    	length:0,
    	getLocalName:function(i){return this[i].localName},
    	getLocator:function(i){return this[i].locator},
    	getQName:function(i){return this[i].qName},
    	getURI:function(i){return this[i].uri},
    	getValue:function(i){return this[i].value}
    //	,getIndex:function(uri, localName)){
    //		if(localName){
    //
    //		}else{
    //			var qName = uri
    //		}
    //	},
    //	getValue:function(){return this.getValue(this.getIndex.apply(this,arguments))},
    //	getType:function(uri,localName){}
    //	getType:function(i){},
    };



    function split(source,start){
    	var match;
    	var buf = [];
    	var reg = /'[^']+'|"[^"]+"|[^\s<>\/=]+=?|(\/?\s*>|<)/g;
    	reg.lastIndex = start;
    	reg.exec(source);//skip <
    	while(match = reg.exec(source)){
    		buf.push(match);
    		if(match[1])return buf;
    	}
    }

    var XMLReader_1 = sax$1.XMLReader = XMLReader$1;
    var ParseError_1 = sax$1.ParseError = ParseError$1;

    var conventions = conventions$2;
    var dom$1 = dom$2;
    var entities = entities$2;
    var sax = sax$1;

    var DOMImplementation$1 = dom$1.DOMImplementation;

    var NAMESPACE = conventions.NAMESPACE;

    var ParseError = sax.ParseError;
    var XMLReader = sax.XMLReader;

    /**
     * Normalizes line ending according to https://www.w3.org/TR/xml11/#sec-line-ends:
     *
     * > XML parsed entities are often stored in computer files which,
     * > for editing convenience, are organized into lines.
     * > These lines are typically separated by some combination
     * > of the characters CARRIAGE RETURN (#xD) and LINE FEED (#xA).
     * >
     * > To simplify the tasks of applications, the XML processor must behave
     * > as if it normalized all line breaks in external parsed entities (including the document entity)
     * > on input, before parsing, by translating all of the following to a single #xA character:
     * >
     * > 1. the two-character sequence #xD #xA
     * > 2. the two-character sequence #xD #x85
     * > 3. the single character #x85
     * > 4. the single character #x2028
     * > 5. any #xD character that is not immediately followed by #xA or #x85.
     *
     * @param {string} input
     * @returns {string}
     */
    function normalizeLineEndings(input) {
    	return input
    		.replace(/\r[\n\u0085]/g, '\n')
    		.replace(/[\r\u0085\u2028]/g, '\n')
    }

    /**
     * @typedef Locator
     * @property {number} [columnNumber]
     * @property {number} [lineNumber]
     */

    /**
     * @typedef DOMParserOptions
     * @property {DOMHandler} [domBuilder]
     * @property {Function} [errorHandler]
     * @property {(string) => string} [normalizeLineEndings] used to replace line endings before parsing
     * 						defaults to `normalizeLineEndings`
     * @property {Locator} [locator]
     * @property {Record<string, string>} [xmlns]
     *
     * @see normalizeLineEndings
     */

    /**
     * The DOMParser interface provides the ability to parse XML or HTML source code
     * from a string into a DOM `Document`.
     *
     * _xmldom is different from the spec in that it allows an `options` parameter,
     * to override the default behavior._
     *
     * @param {DOMParserOptions} [options]
     * @constructor
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser
     * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-parsing-and-serialization
     */
    function DOMParser$2(options){
    	this.options = options ||{locator:{}};
    }

    DOMParser$2.prototype.parseFromString = function(source,mimeType){
    	var options = this.options;
    	var sax =  new XMLReader();
    	var domBuilder = options.domBuilder || new DOMHandler();//contentHandler and LexicalHandler
    	var errorHandler = options.errorHandler;
    	var locator = options.locator;
    	var defaultNSMap = options.xmlns||{};
    	var isHTML = /\/x?html?$/.test(mimeType);//mimeType.toLowerCase().indexOf('html') > -1;
      	var entityMap = isHTML ? entities.HTML_ENTITIES : entities.XML_ENTITIES;
    	if(locator){
    		domBuilder.setDocumentLocator(locator);
    	}

    	sax.errorHandler = buildErrorHandler(errorHandler,domBuilder,locator);
    	sax.domBuilder = options.domBuilder || domBuilder;
    	if(isHTML){
    		defaultNSMap[''] = NAMESPACE.HTML;
    	}
    	defaultNSMap.xml = defaultNSMap.xml || NAMESPACE.XML;
    	var normalize = options.normalizeLineEndings || normalizeLineEndings;
    	if (source && typeof source === 'string') {
    		sax.parse(
    			normalize(source),
    			defaultNSMap,
    			entityMap
    		);
    	} else {
    		sax.errorHandler.error('invalid doc source');
    	}
    	return domBuilder.doc;
    };
    function buildErrorHandler(errorImpl,domBuilder,locator){
    	if(!errorImpl){
    		if(domBuilder instanceof DOMHandler){
    			return domBuilder;
    		}
    		errorImpl = domBuilder ;
    	}
    	var errorHandler = {};
    	var isCallback = errorImpl instanceof Function;
    	locator = locator||{};
    	function build(key){
    		var fn = errorImpl[key];
    		if(!fn && isCallback){
    			fn = errorImpl.length == 2?function(msg){errorImpl(key,msg);}:errorImpl;
    		}
    		errorHandler[key] = fn && function(msg){
    			fn('[xmldom '+key+']\t'+msg+_locator(locator));
    		}||function(){};
    	}
    	build('warning');
    	build('error');
    	build('fatalError');
    	return errorHandler;
    }

    //console.log('#\n\n\n\n\n\n\n####')
    /**
     * +ContentHandler+ErrorHandler
     * +LexicalHandler+EntityResolver2
     * -DeclHandler-DTDHandler
     *
     * DefaultHandler:EntityResolver, DTDHandler, ContentHandler, ErrorHandler
     * DefaultHandler2:DefaultHandler,LexicalHandler, DeclHandler, EntityResolver2
     * @link http://www.saxproject.org/apidoc/org/xml/sax/helpers/DefaultHandler.html
     */
    function DOMHandler() {
        this.cdata = false;
    }
    function position(locator,node){
    	node.lineNumber = locator.lineNumber;
    	node.columnNumber = locator.columnNumber;
    }
    /**
     * @see org.xml.sax.ContentHandler#startDocument
     * @link http://www.saxproject.org/apidoc/org/xml/sax/ContentHandler.html
     */
    DOMHandler.prototype = {
    	startDocument : function() {
        	this.doc = new DOMImplementation$1().createDocument(null, null, null);
        	if (this.locator) {
            	this.doc.documentURI = this.locator.systemId;
        	}
    	},
    	startElement:function(namespaceURI, localName, qName, attrs) {
    		var doc = this.doc;
    	    var el = doc.createElementNS(namespaceURI, qName||localName);
    	    var len = attrs.length;
    	    appendElement(this, el);
    	    this.currentElement = el;

    		this.locator && position(this.locator,el);
    	    for (var i = 0 ; i < len; i++) {
    	        var namespaceURI = attrs.getURI(i);
    	        var value = attrs.getValue(i);
    	        var qName = attrs.getQName(i);
    			var attr = doc.createAttributeNS(namespaceURI, qName);
    			this.locator &&position(attrs.getLocator(i),attr);
    			attr.value = attr.nodeValue = value;
    			el.setAttributeNode(attr);
    	    }
    	},
    	endElement:function(namespaceURI, localName, qName) {
    		var current = this.currentElement;
    		var tagName = current.tagName;
    		this.currentElement = current.parentNode;
    	},
    	startPrefixMapping:function(prefix, uri) {
    	},
    	endPrefixMapping:function(prefix) {
    	},
    	processingInstruction:function(target, data) {
    	    var ins = this.doc.createProcessingInstruction(target, data);
    	    this.locator && position(this.locator,ins);
    	    appendElement(this, ins);
    	},
    	ignorableWhitespace:function(ch, start, length) {
    	},
    	characters:function(chars, start, length) {
    		chars = _toString.apply(this,arguments);
    		//console.log(chars)
    		if(chars){
    			if (this.cdata) {
    				var charNode = this.doc.createCDATASection(chars);
    			} else {
    				var charNode = this.doc.createTextNode(chars);
    			}
    			if(this.currentElement){
    				this.currentElement.appendChild(charNode);
    			}else if(/^\s*$/.test(chars)){
    				this.doc.appendChild(charNode);
    				//process xml
    			}
    			this.locator && position(this.locator,charNode);
    		}
    	},
    	skippedEntity:function(name) {
    	},
    	endDocument:function() {
    		this.doc.normalize();
    	},
    	setDocumentLocator:function (locator) {
    	    if(this.locator = locator){// && !('lineNumber' in locator)){
    	    	locator.lineNumber = 0;
    	    }
    	},
    	//LexicalHandler
    	comment:function(chars, start, length) {
    		chars = _toString.apply(this,arguments);
    	    var comm = this.doc.createComment(chars);
    	    this.locator && position(this.locator,comm);
    	    appendElement(this, comm);
    	},

    	startCDATA:function() {
    	    //used in characters() methods
    	    this.cdata = true;
    	},
    	endCDATA:function() {
    	    this.cdata = false;
    	},

    	startDTD:function(name, publicId, systemId) {
    		var impl = this.doc.implementation;
    	    if (impl && impl.createDocumentType) {
    	        var dt = impl.createDocumentType(name, publicId, systemId);
    	        this.locator && position(this.locator,dt);
    	        appendElement(this, dt);
    					this.doc.doctype = dt;
    	    }
    	},
    	/**
    	 * @see org.xml.sax.ErrorHandler
    	 * @link http://www.saxproject.org/apidoc/org/xml/sax/ErrorHandler.html
    	 */
    	warning:function(error) {
    		console.warn('[xmldom warning]\t'+error,_locator(this.locator));
    	},
    	error:function(error) {
    		console.error('[xmldom error]\t'+error,_locator(this.locator));
    	},
    	fatalError:function(error) {
    		throw new ParseError(error, this.locator);
    	}
    };
    function _locator(l){
    	if(l){
    		return '\n@'+(l.systemId ||'')+'#[line:'+l.lineNumber+',col:'+l.columnNumber+']'
    	}
    }
    function _toString(chars,start,length){
    	if(typeof chars == 'string'){
    		return chars.substr(start,length)
    	}else {//java sax connect width xmldom on rhino(what about: "? && !(chars instanceof String)")
    		if(chars.length >= start+length || start){
    			return new java.lang.String(chars,start,length)+'';
    		}
    		return chars;
    	}
    }

    /*
     * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/LexicalHandler.html
     * used method of org.xml.sax.ext.LexicalHandler:
     *  #comment(chars, start, length)
     *  #startCDATA()
     *  #endCDATA()
     *  #startDTD(name, publicId, systemId)
     *
     *
     * IGNORED method of org.xml.sax.ext.LexicalHandler:
     *  #endDTD()
     *  #startEntity(name)
     *  #endEntity(name)
     *
     *
     * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/DeclHandler.html
     * IGNORED method of org.xml.sax.ext.DeclHandler
     * 	#attributeDecl(eName, aName, type, mode, value)
     *  #elementDecl(name, model)
     *  #externalEntityDecl(name, publicId, systemId)
     *  #internalEntityDecl(name, value)
     * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/EntityResolver2.html
     * IGNORED method of org.xml.sax.EntityResolver2
     *  #resolveEntity(String name,String publicId,String baseURI,String systemId)
     *  #resolveEntity(publicId, systemId)
     *  #getExternalSubset(name, baseURI)
     * @link http://www.saxproject.org/apidoc/org/xml/sax/DTDHandler.html
     * IGNORED method of org.xml.sax.DTDHandler
     *  #notationDecl(name, publicId, systemId) {};
     *  #unparsedEntityDecl(name, publicId, systemId, notationName) {};
     */
    "endDTD,startEntity,endEntity,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,resolveEntity,getExternalSubset,notationDecl,unparsedEntityDecl".replace(/\w+/g,function(key){
    	DOMHandler.prototype[key] = function(){return null};
    });

    /* Private static helpers treated below as private instance methods, so don't need to add these to the public API; we might use a Relator to also get rid of non-standard public properties */
    function appendElement (hander,node) {
        if (!hander.currentElement) {
            hander.doc.appendChild(node);
        } else {
            hander.currentElement.appendChild(node);
        }
    }//appendChild and setAttributeNS are preformance key

    var __DOMHandler = domParser.__DOMHandler = DOMHandler;
    var normalizeLineEndings_1 = domParser.normalizeLineEndings = normalizeLineEndings;
    var DOMParser_1 = domParser.DOMParser = DOMParser$2;

    var dom = dom$2;
    var DOMImplementation = lib.DOMImplementation = dom.DOMImplementation;
    var XMLSerializer$1 = lib.XMLSerializer = dom.XMLSerializer;
    var DOMParser$1 = lib.DOMParser = domParser.DOMParser;

    "use strict";
    const WebWorkerAdapter = {
      createCanvas: (width, height) => new OffscreenCanvas(width != null ? width : 0, height != null ? height : 0),
      getCanvasRenderingContext2D: () => OffscreenCanvasRenderingContext2D,
      getWebGLRenderingContext: () => WebGLRenderingContext,
      getNavigator: () => navigator,
      getBaseUrl: () => globalThis.location.href,
      getFontFaceSet: () => globalThis.fonts,
      fetch: (url, options) => fetch(url, options),
      parseXML: (xml) => {
        const parser = new DOMParser$1();
        return parser.parseFromString(xml, "text/xml");
      }
    };

    "use strict";
    var __defProp$18 = Object.defineProperty;
    var __defProps$r = Object.defineProperties;
    var __getOwnPropDescs$r = Object.getOwnPropertyDescriptors;
    var __getOwnPropSymbols$18 = Object.getOwnPropertySymbols;
    var __hasOwnProp$18 = Object.prototype.hasOwnProperty;
    var __propIsEnum$18 = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$18 = (obj, key, value) => key in obj ? __defProp$18(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$18 = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$18.call(b, prop))
          __defNormalProp$18(a, prop, b[prop]);
      if (__getOwnPropSymbols$18)
        for (var prop of __getOwnPropSymbols$18(b)) {
          if (__propIsEnum$18.call(b, prop))
            __defNormalProp$18(a, prop, b[prop]);
        }
      return a;
    };
    var __spreadProps$r = (a, b) => __defProps$r(a, __getOwnPropDescs$r(b));
    var ExtensionType = /* @__PURE__ */ ((ExtensionType2) => {
      ExtensionType2["Application"] = "application";
      ExtensionType2["WebGLPipes"] = "webgl-pipes";
      ExtensionType2["WebGLPipesAdaptor"] = "webgl-pipes-adaptor";
      ExtensionType2["WebGLSystem"] = "webgl-system";
      ExtensionType2["WebGPUPipes"] = "webgpu-pipes";
      ExtensionType2["WebGPUPipesAdaptor"] = "webgpu-pipes-adaptor";
      ExtensionType2["WebGPUSystem"] = "webgpu-system";
      ExtensionType2["CanvasSystem"] = "canvas-system";
      ExtensionType2["CanvasPipesAdaptor"] = "canvas-pipes-adaptor";
      ExtensionType2["CanvasPipes"] = "canvas-pipes";
      ExtensionType2["Asset"] = "asset";
      ExtensionType2["LoadParser"] = "load-parser";
      ExtensionType2["ResolveParser"] = "resolve-parser";
      ExtensionType2["CacheParser"] = "cache-parser";
      ExtensionType2["DetectionParser"] = "detection-parser";
      ExtensionType2["MaskEffect"] = "mask-effect";
      ExtensionType2["BlendMode"] = "blend-mode";
      ExtensionType2["TextureSource"] = "texture-source";
      ExtensionType2["Environment"] = "environment";
      ExtensionType2["ShapeBuilder"] = "shape-builder";
      ExtensionType2["Batcher"] = "batcher";
      return ExtensionType2;
    })(ExtensionType || {});
    const normalizeExtension = (ext) => {
      if (typeof ext === "function" || typeof ext === "object" && ext.extension) {
        if (!ext.extension) {
          throw new Error("Extension class must have an extension object");
        }
        const metadata = typeof ext.extension !== "object" ? { type: ext.extension } : ext.extension;
        ext = __spreadProps$r(__spreadValues$18({}, metadata), { ref: ext });
      }
      if (typeof ext === "object") {
        ext = __spreadValues$18({}, ext);
      } else {
        throw new Error("Invalid extension type");
      }
      if (typeof ext.type === "string") {
        ext.type = [ext.type];
      }
      return ext;
    };
    const normalizeExtensionPriority = (ext, defaultPriority) => {
      var _a;
      return (_a = normalizeExtension(ext).priority) != null ? _a : defaultPriority;
    };
    const extensions = {
      /** @ignore */
      _addHandlers: {},
      /** @ignore */
      _removeHandlers: {},
      /** @ignore */
      _queue: {},
      /**
       * Remove extensions from PixiJS.
       * @param extensions - Extensions to be removed.
       * @returns {extensions} For chaining.
       */
      remove(...extensions2) {
        extensions2.map(normalizeExtension).forEach((ext) => {
          ext.type.forEach((type) => {
            var _a, _b;
            return (_b = (_a = this._removeHandlers)[type]) == null ? void 0 : _b.call(_a, ext);
          });
        });
        return this;
      },
      /**
       * Register new extensions with PixiJS.
       * @param extensions - The spread of extensions to add to PixiJS.
       * @returns {extensions} For chaining.
       */
      add(...extensions2) {
        extensions2.map(normalizeExtension).forEach((ext) => {
          ext.type.forEach((type) => {
            var _a, _b;
            const handlers = this._addHandlers;
            const queue = this._queue;
            if (!handlers[type]) {
              queue[type] = queue[type] || [];
              (_a = queue[type]) == null ? void 0 : _a.push(ext);
            } else {
              (_b = handlers[type]) == null ? void 0 : _b.call(handlers, ext);
            }
          });
        });
        return this;
      },
      /**
       * Internal method to handle extensions by name.
       * @param type - The extension type.
       * @param onAdd  - Function handler when extensions are added/registered {@link StrictExtensionFormat}.
       * @param onRemove  - Function handler when extensions are removed/unregistered {@link StrictExtensionFormat}.
       * @returns {extensions} For chaining.
       */
      handle(type, onAdd, onRemove) {
        var _a;
        const addHandlers = this._addHandlers;
        const removeHandlers = this._removeHandlers;
        if (addHandlers[type] || removeHandlers[type]) {
          throw new Error(`Extension type ${type} already has a handler`);
        }
        addHandlers[type] = onAdd;
        removeHandlers[type] = onRemove;
        const queue = this._queue;
        if (queue[type]) {
          (_a = queue[type]) == null ? void 0 : _a.forEach((ext) => onAdd(ext));
          delete queue[type];
        }
        return this;
      },
      /**
       * Handle a type, but using a map by `name` property.
       * @param type - Type of extension to handle.
       * @param map - The object map of named extensions.
       * @returns {extensions} For chaining.
       */
      handleByMap(type, map) {
        return this.handle(
          type,
          (extension) => {
            if (extension.name) {
              map[extension.name] = extension.ref;
            }
          },
          (extension) => {
            if (extension.name) {
              delete map[extension.name];
            }
          }
        );
      },
      /**
       * Handle a type, but using a list of extensions with a `name` property.
       * @param type - Type of extension to handle.
       * @param map - The array of named extensions.
       * @param defaultPriority - Fallback priority if none is defined.
       * @returns {extensions} For chaining.
       */
      handleByNamedList(type, map, defaultPriority = -1) {
        return this.handle(
          type,
          (extension) => {
            const index = map.findIndex((item) => item.name === extension.name);
            if (index >= 0)
              return;
            map.push({ name: extension.name, value: extension.ref });
            map.sort((a, b) => normalizeExtensionPriority(b.value, defaultPriority) - normalizeExtensionPriority(a.value, defaultPriority));
          },
          (extension) => {
            const index = map.findIndex((item) => item.name === extension.name);
            if (index !== -1) {
              map.splice(index, 1);
            }
          }
        );
      },
      /**
       * Handle a type, but using a list of extensions.
       * @param type - Type of extension to handle.
       * @param list - The list of extensions.
       * @param defaultPriority - The default priority to use if none is specified.
       * @returns {extensions} For chaining.
       */
      handleByList(type, list, defaultPriority = -1) {
        return this.handle(
          type,
          (extension) => {
            if (list.includes(extension.ref)) {
              return;
            }
            list.push(extension.ref);
            list.sort((a, b) => normalizeExtensionPriority(b, defaultPriority) - normalizeExtensionPriority(a, defaultPriority));
          },
          (extension) => {
            const index = list.indexOf(extension.ref);
            if (index !== -1) {
              list.splice(index, 1);
            }
          }
        );
      }
    };

    "use strict";
    class ResizePlugin {
      /**
       * Initialize the plugin with scope of application instance
       * @static
       * @private
       * @param {object} [options] - See application options
       */
      static init(options) {
        Object.defineProperty(
          this,
          "resizeTo",
          /**
           * The HTML element or window to automatically resize the
           * renderer's view element to match width and height.
           * @member {Window|HTMLElement}
           * @name resizeTo
           * @memberof app.Application#
           */
          {
            set(dom) {
              globalThis.removeEventListener("resize", this.queueResize);
              this._resizeTo = dom;
              if (dom) {
                globalThis.addEventListener("resize", this.queueResize);
                this.resize();
              }
            },
            get() {
              return this._resizeTo;
            }
          }
        );
        this.queueResize = () => {
          if (!this._resizeTo) {
            return;
          }
          this._cancelResize();
          this._resizeId = requestAnimationFrame(() => this.resize());
        };
        this._cancelResize = () => {
          if (this._resizeId) {
            cancelAnimationFrame(this._resizeId);
            this._resizeId = null;
          }
        };
        this.resize = () => {
          if (!this._resizeTo) {
            return;
          }
          this._cancelResize();
          let width;
          let height;
          if (this._resizeTo === globalThis.window) {
            width = globalThis.innerWidth;
            height = globalThis.innerHeight;
          } else {
            const { clientWidth, clientHeight } = this._resizeTo;
            width = clientWidth;
            height = clientHeight;
          }
          this.renderer.resize(width, height);
          this.render();
        };
        this._resizeId = null;
        this._resizeTo = null;
        this.resizeTo = options.resizeTo || null;
      }
      /**
       * Clean up the ticker, scoped to application
       * @static
       * @private
       */
      static destroy() {
        globalThis.removeEventListener("resize", this.queueResize);
        this._cancelResize();
        this._cancelResize = null;
        this.queueResize = null;
        this.resizeTo = null;
        this.resize = null;
      }
    }
    /** @ignore */
    ResizePlugin.extension = ExtensionType.Application;

    "use strict";
    var UPDATE_PRIORITY = /* @__PURE__ */ ((UPDATE_PRIORITY2) => {
      UPDATE_PRIORITY2[UPDATE_PRIORITY2["INTERACTION"] = 50] = "INTERACTION";
      UPDATE_PRIORITY2[UPDATE_PRIORITY2["HIGH"] = 25] = "HIGH";
      UPDATE_PRIORITY2[UPDATE_PRIORITY2["NORMAL"] = 0] = "NORMAL";
      UPDATE_PRIORITY2[UPDATE_PRIORITY2["LOW"] = -25] = "LOW";
      UPDATE_PRIORITY2[UPDATE_PRIORITY2["UTILITY"] = -50] = "UTILITY";
      return UPDATE_PRIORITY2;
    })(UPDATE_PRIORITY || {});

    "use strict";
    class TickerListener {
      /**
       * Constructor
       * @private
       * @param fn - The listener function to be added for one update
       * @param context - The listener context
       * @param priority - The priority for emitting
       * @param once - If the handler should fire once
       */
      constructor(fn, context = null, priority = 0, once = false) {
        /** The next item in chain. */
        this.next = null;
        /** The previous item in chain. */
        this.previous = null;
        /** `true` if this listener has been destroyed already. */
        this._destroyed = false;
        this._fn = fn;
        this._context = context;
        this.priority = priority;
        this._once = once;
      }
      /**
       * Simple compare function to figure out if a function and context match.
       * @param fn - The listener function to be added for one update
       * @param context - The listener context
       * @returns `true` if the listener match the arguments
       */
      match(fn, context = null) {
        return this._fn === fn && this._context === context;
      }
      /**
       * Emit by calling the current function.
       * @param ticker - The ticker emitting.
       * @returns Next ticker
       */
      emit(ticker) {
        if (this._fn) {
          if (this._context) {
            this._fn.call(this._context, ticker);
          } else {
            this._fn(ticker);
          }
        }
        const redirect = this.next;
        if (this._once) {
          this.destroy(true);
        }
        if (this._destroyed) {
          this.next = null;
        }
        return redirect;
      }
      /**
       * Connect to the list.
       * @param previous - Input node, previous listener
       */
      connect(previous) {
        this.previous = previous;
        if (previous.next) {
          previous.next.previous = this;
        }
        this.next = previous.next;
        previous.next = this;
      }
      /**
       * Destroy and don't use after this.
       * @param hard - `true` to remove the `next` reference, this
       *        is considered a hard destroy. Soft destroy maintains the next reference.
       * @returns The listener to redirect while emitting or removing.
       */
      destroy(hard = false) {
        this._destroyed = true;
        this._fn = null;
        this._context = null;
        if (this.previous) {
          this.previous.next = this.next;
        }
        if (this.next) {
          this.next.previous = this.previous;
        }
        const redirect = this.next;
        this.next = hard ? null : redirect;
        this.previous = null;
        return redirect;
      }
    }

    "use strict";
    const _Ticker = class _Ticker {
      constructor() {
        /**
         * Whether or not this ticker should invoke the method
         * {@link ticker.Ticker#start|start} automatically when a listener is added.
         */
        this.autoStart = false;
        /**
         * Scalar time value from last frame to this frame.
         * This value is capped by setting {@link ticker.Ticker#minFPS|minFPS}
         * and is scaled with {@link ticker.Ticker#speed|speed}.
         * **Note:** The cap may be exceeded by scaling.
         */
        this.deltaTime = 1;
        /**
         * The last time {@link ticker.Ticker#update|update} was invoked.
         * This value is also reset internally outside of invoking
         * update, but only when a new animation frame is requested.
         * If the platform supports DOMHighResTimeStamp,
         * this value will have a precision of 1 µs.
         */
        this.lastTime = -1;
        /**
         * Factor of current {@link ticker.Ticker#deltaTime|deltaTime}.
         * @example
         * // Scales ticker.deltaTime to what would be
         * // the equivalent of approximately 120 FPS
         * ticker.speed = 2;
         */
        this.speed = 1;
        /**
         * Whether or not this ticker has been started.
         * `true` if {@link ticker.Ticker#start|start} has been called.
         * `false` if {@link ticker.Ticker#stop|Stop} has been called.
         * While `false`, this value may change to `true` in the
         * event of {@link ticker.Ticker#autoStart|autoStart} being `true`
         * and a listener is added.
         */
        this.started = false;
        /** Internal current frame request ID */
        this._requestId = null;
        /**
         * Internal value managed by minFPS property setter and getter.
         * This is the maximum allowed milliseconds between updates.
         */
        this._maxElapsedMS = 100;
        /**
         * Internal value managed by minFPS property setter and getter.
         * This is the minimum allowed milliseconds between updates.
         */
        this._minElapsedMS = 0;
        /** If enabled, deleting is disabled.*/
        this._protected = false;
        /** The last time keyframe was executed. Maintains a relatively fixed interval with the previous value. */
        this._lastFrame = -1;
        this._head = new TickerListener(null, null, Infinity);
        this.deltaMS = 1 / _Ticker.targetFPMS;
        this.elapsedMS = 1 / _Ticker.targetFPMS;
        this._tick = (time) => {
          this._requestId = null;
          if (this.started) {
            this.update(time);
            if (this.started && this._requestId === null && this._head.next) {
              this._requestId = requestAnimationFrame(this._tick);
            }
          }
        };
      }
      /**
       * Conditionally requests a new animation frame.
       * If a frame has not already been requested, and if the internal
       * emitter has listeners, a new frame is requested.
       * @private
       */
      _requestIfNeeded() {
        if (this._requestId === null && this._head.next) {
          this.lastTime = performance.now();
          this._lastFrame = this.lastTime;
          this._requestId = requestAnimationFrame(this._tick);
        }
      }
      /**
       * Conditionally cancels a pending animation frame.
       * @private
       */
      _cancelIfNeeded() {
        if (this._requestId !== null) {
          cancelAnimationFrame(this._requestId);
          this._requestId = null;
        }
      }
      /**
       * Conditionally requests a new animation frame.
       * If the ticker has been started it checks if a frame has not already
       * been requested, and if the internal emitter has listeners. If these
       * conditions are met, a new frame is requested. If the ticker has not
       * been started, but autoStart is `true`, then the ticker starts now,
       * and continues with the previous conditions to request a new frame.
       * @private
       */
      _startIfPossible() {
        if (this.started) {
          this._requestIfNeeded();
        } else if (this.autoStart) {
          this.start();
        }
      }
      /**
       * Register a handler for tick events. Calls continuously unless
       * it is removed or the ticker is stopped.
       * @param fn - The listener function to be added for updates
       * @param context - The listener context
       * @param {number} [priority=UPDATE_PRIORITY.NORMAL] - The priority for emitting
       * @returns This instance of a ticker
       */
      add(fn, context, priority = UPDATE_PRIORITY.NORMAL) {
        return this._addListener(new TickerListener(fn, context, priority));
      }
      /**
       * Add a handler for the tick event which is only execute once.
       * @param fn - The listener function to be added for one update
       * @param context - The listener context
       * @param {number} [priority=UPDATE_PRIORITY.NORMAL] - The priority for emitting
       * @returns This instance of a ticker
       */
      addOnce(fn, context, priority = UPDATE_PRIORITY.NORMAL) {
        return this._addListener(new TickerListener(fn, context, priority, true));
      }
      /**
       * Internally adds the event handler so that it can be sorted by priority.
       * Priority allows certain handler (user, AnimatedSprite, Interaction) to be run
       * before the rendering.
       * @private
       * @param listener - Current listener being added.
       * @returns This instance of a ticker
       */
      _addListener(listener) {
        let current = this._head.next;
        let previous = this._head;
        if (!current) {
          listener.connect(previous);
        } else {
          while (current) {
            if (listener.priority > current.priority) {
              listener.connect(previous);
              break;
            }
            previous = current;
            current = current.next;
          }
          if (!listener.previous) {
            listener.connect(previous);
          }
        }
        this._startIfPossible();
        return this;
      }
      /**
       * Removes any handlers matching the function and context parameters.
       * If no handlers are left after removing, then it cancels the animation frame.
       * @param fn - The listener function to be removed
       * @param context - The listener context to be removed
       * @returns This instance of a ticker
       */
      remove(fn, context) {
        let listener = this._head.next;
        while (listener) {
          if (listener.match(fn, context)) {
            listener = listener.destroy();
          } else {
            listener = listener.next;
          }
        }
        if (!this._head.next) {
          this._cancelIfNeeded();
        }
        return this;
      }
      /**
       * The number of listeners on this ticker, calculated by walking through linked list
       * @readonly
       * @member {number}
       */
      get count() {
        if (!this._head) {
          return 0;
        }
        let count = 0;
        let current = this._head;
        while (current = current.next) {
          count++;
        }
        return count;
      }
      /** Starts the ticker. If the ticker has listeners a new animation frame is requested at this point. */
      start() {
        if (!this.started) {
          this.started = true;
          this._requestIfNeeded();
        }
      }
      /** Stops the ticker. If the ticker has requested an animation frame it is canceled at this point. */
      stop() {
        if (this.started) {
          this.started = false;
          this._cancelIfNeeded();
        }
      }
      /** Destroy the ticker and don't use after this. Calling this method removes all references to internal events. */
      destroy() {
        if (!this._protected) {
          this.stop();
          let listener = this._head.next;
          while (listener) {
            listener = listener.destroy(true);
          }
          this._head.destroy();
          this._head = null;
        }
      }
      /**
       * Triggers an update. An update entails setting the
       * current {@link ticker.Ticker#elapsedMS|elapsedMS},
       * the current {@link ticker.Ticker#deltaTime|deltaTime},
       * invoking all listeners with current deltaTime,
       * and then finally setting {@link ticker.Ticker#lastTime|lastTime}
       * with the value of currentTime that was provided.
       * This method will be called automatically by animation
       * frame callbacks if the ticker instance has been started
       * and listeners are added.
       * @param {number} [currentTime=performance.now()] - the current time of execution
       */
      update(currentTime = performance.now()) {
        let elapsedMS;
        if (currentTime > this.lastTime) {
          elapsedMS = this.elapsedMS = currentTime - this.lastTime;
          if (elapsedMS > this._maxElapsedMS) {
            elapsedMS = this._maxElapsedMS;
          }
          elapsedMS *= this.speed;
          if (this._minElapsedMS) {
            const delta = currentTime - this._lastFrame | 0;
            if (delta < this._minElapsedMS) {
              return;
            }
            this._lastFrame = currentTime - delta % this._minElapsedMS;
          }
          this.deltaMS = elapsedMS;
          this.deltaTime = this.deltaMS * _Ticker.targetFPMS;
          const head = this._head;
          let listener = head.next;
          while (listener) {
            listener = listener.emit(this);
          }
          if (!head.next) {
            this._cancelIfNeeded();
          }
        } else {
          this.deltaTime = this.deltaMS = this.elapsedMS = 0;
        }
        this.lastTime = currentTime;
      }
      /**
       * The frames per second at which this ticker is running.
       * The default is approximately 60 in most modern browsers.
       * **Note:** This does not factor in the value of
       * {@link ticker.Ticker#speed|speed}, which is specific
       * to scaling {@link ticker.Ticker#deltaTime|deltaTime}.
       * @member {number}
       * @readonly
       */
      get FPS() {
        return 1e3 / this.elapsedMS;
      }
      /**
       * Manages the maximum amount of milliseconds allowed to
       * elapse between invoking {@link ticker.Ticker#update|update}.
       * This value is used to cap {@link ticker.Ticker#deltaTime|deltaTime},
       * but does not effect the measured value of {@link ticker.Ticker#FPS|FPS}.
       * When setting this property it is clamped to a value between
       * `0` and `Ticker.targetFPMS * 1000`.
       * @member {number}
       * @default 10
       */
      get minFPS() {
        return 1e3 / this._maxElapsedMS;
      }
      set minFPS(fps) {
        const minFPS = Math.min(this.maxFPS, fps);
        const minFPMS = Math.min(Math.max(0, minFPS) / 1e3, _Ticker.targetFPMS);
        this._maxElapsedMS = 1 / minFPMS;
      }
      /**
       * Manages the minimum amount of milliseconds required to
       * elapse between invoking {@link ticker.Ticker#update|update}.
       * This will effect the measured value of {@link ticker.Ticker#FPS|FPS}.
       * If it is set to `0`, then there is no limit; PixiJS will render as many frames as it can.
       * Otherwise it will be at least `minFPS`
       * @member {number}
       * @default 0
       */
      get maxFPS() {
        if (this._minElapsedMS) {
          return Math.round(1e3 / this._minElapsedMS);
        }
        return 0;
      }
      set maxFPS(fps) {
        if (fps === 0) {
          this._minElapsedMS = 0;
        } else {
          const maxFPS = Math.max(this.minFPS, fps);
          this._minElapsedMS = 1 / (maxFPS / 1e3);
        }
      }
      /**
       * The shared ticker instance used by {@link AnimatedSprite} and by
       * {@link VideoResource} to update animation frames / video textures.
       *
       * It may also be used by {@link Application} if created with the `sharedTicker` option property set to true.
       *
       * The property {@link ticker.Ticker#autoStart|autoStart} is set to `true` for this instance.
       * Please follow the examples for usage, including how to opt-out of auto-starting the shared ticker.
       * @example
       * import { Ticker } from 'pixi.js';
       *
       * const ticker = Ticker.shared;
       * // Set this to prevent starting this ticker when listeners are added.
       * // By default this is true only for the Ticker.shared instance.
       * ticker.autoStart = false;
       *
       * // FYI, call this to ensure the ticker is stopped. It should be stopped
       * // if you have not attempted to render anything yet.
       * ticker.stop();
       *
       * // Call this when you are ready for a running shared ticker.
       * ticker.start();
       * @example
       * import { autoDetectRenderer, Container } from 'pixi.js';
       *
       * // You may use the shared ticker to render...
       * const renderer = autoDetectRenderer();
       * const stage = new Container();
       * document.body.appendChild(renderer.view);
       * ticker.add((time) => renderer.render(stage));
       *
       * // Or you can just update it manually.
       * ticker.autoStart = false;
       * ticker.stop();
       * const animate = (time) => {
       *     ticker.update(time);
       *     renderer.render(stage);
       *     requestAnimationFrame(animate);
       * };
       * animate(performance.now());
       * @member {ticker.Ticker}
       * @readonly
       * @static
       */
      static get shared() {
        if (!_Ticker._shared) {
          const shared = _Ticker._shared = new _Ticker();
          shared.autoStart = true;
          shared._protected = true;
        }
        return _Ticker._shared;
      }
      /**
       * The system ticker instance used by {@link BasePrepare} for core timing
       * functionality that shouldn't usually need to be paused, unlike the `shared`
       * ticker which drives visual animations and rendering which may want to be paused.
       *
       * The property {@link ticker.Ticker#autoStart|autoStart} is set to `true` for this instance.
       * @member {ticker.Ticker}
       * @readonly
       * @static
       */
      static get system() {
        if (!_Ticker._system) {
          const system = _Ticker._system = new _Ticker();
          system.autoStart = true;
          system._protected = true;
        }
        return _Ticker._system;
      }
    };
    /**
     * Target frames per millisecond.
     * @static
     */
    _Ticker.targetFPMS = 0.06;
    let Ticker = _Ticker;

    "use strict";
    class TickerPlugin {
      /**
       * Initialize the plugin with scope of application instance
       * @static
       * @private
       * @param {object} [options] - See application options
       */
      static init(options) {
        options = Object.assign({
          autoStart: true,
          sharedTicker: false
        }, options);
        Object.defineProperty(
          this,
          "ticker",
          {
            set(ticker) {
              if (this._ticker) {
                this._ticker.remove(this.render, this);
              }
              this._ticker = ticker;
              if (ticker) {
                ticker.add(this.render, this, UPDATE_PRIORITY.LOW);
              }
            },
            get() {
              return this._ticker;
            }
          }
        );
        this.stop = () => {
          this._ticker.stop();
        };
        this.start = () => {
          this._ticker.start();
        };
        this._ticker = null;
        this.ticker = options.sharedTicker ? Ticker.shared : new Ticker();
        if (options.autoStart) {
          this.start();
        }
      }
      /**
       * Clean up the ticker, scoped to application.
       * @static
       * @private
       */
      static destroy() {
        if (this._ticker) {
          const oldTicker = this._ticker;
          this.ticker = null;
          oldTicker.destroy();
        }
      }
    }
    /** @ignore */
    TickerPlugin.extension = ExtensionType.Application;

    "use strict";
    extensions.add(ResizePlugin);
    extensions.add(TickerPlugin);

    "use strict";
    var LoaderParserPriority = /* @__PURE__ */ ((LoaderParserPriority2) => {
      LoaderParserPriority2[LoaderParserPriority2["Low"] = 0] = "Low";
      LoaderParserPriority2[LoaderParserPriority2["Normal"] = 1] = "Normal";
      LoaderParserPriority2[LoaderParserPriority2["High"] = 2] = "High";
      return LoaderParserPriority2;
    })(LoaderParserPriority || {});

    "use strict";
    let warnCount = 0;
    const maxWarnings = 500;
    function warn(...args) {
      if (warnCount === maxWarnings)
        return;
      warnCount++;
      if (warnCount === maxWarnings) {
        console.warn("PixiJS Warning: too many warnings, no more warnings will be reported to the console by PixiJS.");
      } else {
        console.warn("PixiJS Warning: ", ...args);
      }
    }

    "use strict";
    function assertPath(path2) {
      if (typeof path2 !== "string") {
        throw new TypeError(`Path must be a string. Received ${JSON.stringify(path2)}`);
      }
    }
    function removeUrlParams(url) {
      const re = url.split("?")[0];
      return re.split("#")[0];
    }
    function escapeRegExp(string) {
      return string.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    }
    function replaceAll(str, find, replace) {
      return str.replace(new RegExp(escapeRegExp(find), "g"), replace);
    }
    function normalizeStringPosix(path2, allowAboveRoot) {
      let res = "";
      let lastSegmentLength = 0;
      let lastSlash = -1;
      let dots = 0;
      let code = -1;
      for (let i = 0; i <= path2.length; ++i) {
        if (i < path2.length) {
          code = path2.charCodeAt(i);
        } else if (code === 47) {
          break;
        } else {
          code = 47;
        }
        if (code === 47) {
          if (lastSlash === i - 1 || dots === 1) {
          } else if (lastSlash !== i - 1 && dots === 2) {
            if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 || res.charCodeAt(res.length - 2) !== 46) {
              if (res.length > 2) {
                const lastSlashIndex = res.lastIndexOf("/");
                if (lastSlashIndex !== res.length - 1) {
                  if (lastSlashIndex === -1) {
                    res = "";
                    lastSegmentLength = 0;
                  } else {
                    res = res.slice(0, lastSlashIndex);
                    lastSegmentLength = res.length - 1 - res.lastIndexOf("/");
                  }
                  lastSlash = i;
                  dots = 0;
                  continue;
                }
              } else if (res.length === 2 || res.length === 1) {
                res = "";
                lastSegmentLength = 0;
                lastSlash = i;
                dots = 0;
                continue;
              }
            }
            if (allowAboveRoot) {
              if (res.length > 0) {
                res += "/..";
              } else {
                res = "..";
              }
              lastSegmentLength = 2;
            }
          } else {
            if (res.length > 0) {
              res += `/${path2.slice(lastSlash + 1, i)}`;
            } else {
              res = path2.slice(lastSlash + 1, i);
            }
            lastSegmentLength = i - lastSlash - 1;
          }
          lastSlash = i;
          dots = 0;
        } else if (code === 46 && dots !== -1) {
          ++dots;
        } else {
          dots = -1;
        }
      }
      return res;
    }
    const path = {
      /**
       * Converts a path to posix format.
       * @param path - The path to convert to posix
       */
      toPosix(path2) {
        return replaceAll(path2, "\\", "/");
      },
      /**
       * Checks if the path is a URL e.g. http://, https://
       * @param path - The path to check
       */
      isUrl(path2) {
        return /^https?:/.test(this.toPosix(path2));
      },
      /**
       * Checks if the path is a data URL
       * @param path - The path to check
       */
      isDataUrl(path2) {
        return /^data:([a-z]+\/[a-z0-9-+.]+(;[a-z0-9-.!#$%*+.{}|~`]+=[a-z0-9-.!#$%*+.{}()_|~`]+)*)?(;base64)?,([a-z0-9!$&',()*+;=\-._~:@\/?%\s<>]*?)$/i.test(path2);
      },
      /**
       * Checks if the path is a blob URL
       * @param path - The path to check
       */
      isBlobUrl(path2) {
        return path2.startsWith("blob:");
      },
      /**
       * Checks if the path has a protocol e.g. http://, https://, file:///, data:, blob:, C:/
       * This will return true for windows file paths
       * @param path - The path to check
       */
      hasProtocol(path2) {
        return /^[^/:]+:/.test(this.toPosix(path2));
      },
      /**
       * Returns the protocol of the path e.g. http://, https://, file:///, data:, blob:, C:/
       * @param path - The path to get the protocol from
       */
      getProtocol(path2) {
        assertPath(path2);
        path2 = this.toPosix(path2);
        const matchFile = /^file:\/\/\//.exec(path2);
        if (matchFile) {
          return matchFile[0];
        }
        const matchProtocol = /^[^/:]+:\/{0,2}/.exec(path2);
        if (matchProtocol) {
          return matchProtocol[0];
        }
        return "";
      },
      /**
       * Converts URL to an absolute path.
       * When loading from a Web Worker, we must use absolute paths.
       * If the URL is already absolute we return it as is
       * If it's not, we convert it
       * @param url - The URL to test
       * @param customBaseUrl - The base URL to use
       * @param customRootUrl - The root URL to use
       */
      toAbsolute(url, customBaseUrl, customRootUrl) {
        assertPath(url);
        if (this.isDataUrl(url) || this.isBlobUrl(url))
          return url;
        const baseUrl = removeUrlParams(this.toPosix(customBaseUrl != null ? customBaseUrl : DOMAdapter.get().getBaseUrl()));
        const rootUrl = removeUrlParams(this.toPosix(customRootUrl != null ? customRootUrl : this.rootname(baseUrl)));
        url = this.toPosix(url);
        if (url.startsWith("/")) {
          return path.join(rootUrl, url.slice(1));
        }
        const absolutePath = this.isAbsolute(url) ? url : this.join(baseUrl, url);
        return absolutePath;
      },
      /**
       * Normalizes the given path, resolving '..' and '.' segments
       * @param path - The path to normalize
       */
      normalize(path2) {
        assertPath(path2);
        if (path2.length === 0)
          return ".";
        if (this.isDataUrl(path2) || this.isBlobUrl(path2))
          return path2;
        path2 = this.toPosix(path2);
        let protocol = "";
        const isAbsolute = path2.startsWith("/");
        if (this.hasProtocol(path2)) {
          protocol = this.rootname(path2);
          path2 = path2.slice(protocol.length);
        }
        const trailingSeparator = path2.endsWith("/");
        path2 = normalizeStringPosix(path2, false);
        if (path2.length > 0 && trailingSeparator)
          path2 += "/";
        if (isAbsolute)
          return `/${path2}`;
        return protocol + path2;
      },
      /**
       * Determines if path is an absolute path.
       * Absolute paths can be urls, data urls, or paths on disk
       * @param path - The path to test
       */
      isAbsolute(path2) {
        assertPath(path2);
        path2 = this.toPosix(path2);
        if (this.hasProtocol(path2))
          return true;
        return path2.startsWith("/");
      },
      /**
       * Joins all given path segments together using the platform-specific separator as a delimiter,
       * then normalizes the resulting path
       * @param segments - The segments of the path to join
       */
      join(...segments) {
        var _a;
        if (segments.length === 0) {
          return ".";
        }
        let joined;
        for (let i = 0; i < segments.length; ++i) {
          const arg = segments[i];
          assertPath(arg);
          if (arg.length > 0) {
            if (joined === void 0)
              joined = arg;
            else {
              const prevArg = (_a = segments[i - 1]) != null ? _a : "";
              if (this.joinExtensions.includes(this.extname(prevArg).toLowerCase())) {
                joined += `/../${arg}`;
              } else {
                joined += `/${arg}`;
              }
            }
          }
        }
        if (joined === void 0) {
          return ".";
        }
        return this.normalize(joined);
      },
      /**
       * Returns the directory name of a path
       * @param path - The path to parse
       */
      dirname(path2) {
        assertPath(path2);
        if (path2.length === 0)
          return ".";
        path2 = this.toPosix(path2);
        let code = path2.charCodeAt(0);
        const hasRoot = code === 47;
        let end = -1;
        let matchedSlash = true;
        const proto = this.getProtocol(path2);
        const origpath = path2;
        path2 = path2.slice(proto.length);
        for (let i = path2.length - 1; i >= 1; --i) {
          code = path2.charCodeAt(i);
          if (code === 47) {
            if (!matchedSlash) {
              end = i;
              break;
            }
          } else {
            matchedSlash = false;
          }
        }
        if (end === -1)
          return hasRoot ? "/" : this.isUrl(origpath) ? proto + path2 : proto;
        if (hasRoot && end === 1)
          return "//";
        return proto + path2.slice(0, end);
      },
      /**
       * Returns the root of the path e.g. /, C:/, file:///, http://domain.com/
       * @param path - The path to parse
       */
      rootname(path2) {
        assertPath(path2);
        path2 = this.toPosix(path2);
        let root = "";
        if (path2.startsWith("/"))
          root = "/";
        else {
          root = this.getProtocol(path2);
        }
        if (this.isUrl(path2)) {
          const index = path2.indexOf("/", root.length);
          if (index !== -1) {
            root = path2.slice(0, index);
          } else
            root = path2;
          if (!root.endsWith("/"))
            root += "/";
        }
        return root;
      },
      /**
       * Returns the last portion of a path
       * @param path - The path to test
       * @param ext - Optional extension to remove
       */
      basename(path2, ext) {
        assertPath(path2);
        if (ext)
          assertPath(ext);
        path2 = removeUrlParams(this.toPosix(path2));
        let start = 0;
        let end = -1;
        let matchedSlash = true;
        let i;
        if (ext !== void 0 && ext.length > 0 && ext.length <= path2.length) {
          if (ext.length === path2.length && ext === path2)
            return "";
          let extIdx = ext.length - 1;
          let firstNonSlashEnd = -1;
          for (i = path2.length - 1; i >= 0; --i) {
            const code = path2.charCodeAt(i);
            if (code === 47) {
              if (!matchedSlash) {
                start = i + 1;
                break;
              }
            } else {
              if (firstNonSlashEnd === -1) {
                matchedSlash = false;
                firstNonSlashEnd = i + 1;
              }
              if (extIdx >= 0) {
                if (code === ext.charCodeAt(extIdx)) {
                  if (--extIdx === -1) {
                    end = i;
                  }
                } else {
                  extIdx = -1;
                  end = firstNonSlashEnd;
                }
              }
            }
          }
          if (start === end)
            end = firstNonSlashEnd;
          else if (end === -1)
            end = path2.length;
          return path2.slice(start, end);
        }
        for (i = path2.length - 1; i >= 0; --i) {
          if (path2.charCodeAt(i) === 47) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
        }
        if (end === -1)
          return "";
        return path2.slice(start, end);
      },
      /**
       * Returns the extension of the path, from the last occurrence of the . (period) character to end of string in the last
       * portion of the path. If there is no . in the last portion of the path, or if there are no . characters other than
       * the first character of the basename of path, an empty string is returned.
       * @param path - The path to parse
       */
      extname(path2) {
        assertPath(path2);
        path2 = removeUrlParams(this.toPosix(path2));
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let preDotState = 0;
        for (let i = path2.length - 1; i >= 0; --i) {
          const code = path2.charCodeAt(i);
          if (code === 47) {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (code === 46) {
            if (startDot === -1)
              startDot = i;
            else if (preDotState !== 1)
              preDotState = 1;
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          return "";
        }
        return path2.slice(startDot, end);
      },
      /**
       * Parses a path into an object containing the 'root', `dir`, `base`, `ext`, and `name` properties.
       * @param path - The path to parse
       */
      parse(path2) {
        assertPath(path2);
        const ret = { root: "", dir: "", base: "", ext: "", name: "" };
        if (path2.length === 0)
          return ret;
        path2 = removeUrlParams(this.toPosix(path2));
        let code = path2.charCodeAt(0);
        const isAbsolute = this.isAbsolute(path2);
        let start;
        const protocol = "";
        ret.root = this.rootname(path2);
        if (isAbsolute || this.hasProtocol(path2)) {
          start = 1;
        } else {
          start = 0;
        }
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let i = path2.length - 1;
        let preDotState = 0;
        for (; i >= start; --i) {
          code = path2.charCodeAt(i);
          if (code === 47) {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (code === 46) {
            if (startDot === -1)
              startDot = i;
            else if (preDotState !== 1)
              preDotState = 1;
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          if (end !== -1) {
            if (startPart === 0 && isAbsolute)
              ret.base = ret.name = path2.slice(1, end);
            else
              ret.base = ret.name = path2.slice(startPart, end);
          }
        } else {
          if (startPart === 0 && isAbsolute) {
            ret.name = path2.slice(1, startDot);
            ret.base = path2.slice(1, end);
          } else {
            ret.name = path2.slice(startPart, startDot);
            ret.base = path2.slice(startPart, end);
          }
          ret.ext = path2.slice(startDot, end);
        }
        ret.dir = this.dirname(path2);
        if (protocol)
          ret.dir = protocol + ret.dir;
        return ret;
      },
      sep: "/",
      delimiter: ":",
      joinExtensions: [".html"]
    };

    "use strict";
    const convertToList = (input, transform, forceTransform = false) => {
      if (!Array.isArray(input)) {
        input = [input];
      }
      if (!transform) {
        return input;
      }
      return input.map((item) => {
        if (typeof item === "string" || forceTransform) {
          return transform(item);
        }
        return item;
      });
    };

    "use strict";
    function processX(base, ids, depth, result, tags) {
      const id = ids[depth];
      for (let i = 0; i < id.length; i++) {
        const value = id[i];
        if (depth < ids.length - 1) {
          processX(base.replace(result[depth], value), ids, depth + 1, result, tags);
        } else {
          tags.push(base.replace(result[depth], value));
        }
      }
    }
    function createStringVariations(string) {
      const regex = /\{(.*?)\}/g;
      const result = string.match(regex);
      const tags = [];
      if (result) {
        const ids = [];
        result.forEach((vars) => {
          const split = vars.substring(1, vars.length - 1).split(",");
          ids.push(split);
        });
        processX(string, ids, 0, result, tags);
      } else {
        tags.push(string);
      }
      return tags;
    }

    "use strict";
    const isSingleItem = (item) => !Array.isArray(item);

    "use strict";
    var __defProp$17 = Object.defineProperty;
    var __getOwnPropSymbols$17 = Object.getOwnPropertySymbols;
    var __hasOwnProp$17 = Object.prototype.hasOwnProperty;
    var __propIsEnum$17 = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$17 = (obj, key, value) => key in obj ? __defProp$17(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$17 = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$17.call(b, prop))
          __defNormalProp$17(a, prop, b[prop]);
      if (__getOwnPropSymbols$17)
        for (var prop of __getOwnPropSymbols$17(b)) {
          if (__propIsEnum$17.call(b, prop))
            __defNormalProp$17(a, prop, b[prop]);
        }
      return a;
    };
    class Resolver {
      constructor() {
        this._defaultBundleIdentifierOptions = {
          connector: "-",
          createBundleAssetId: (bundleId, assetId) => `${bundleId}${this._bundleIdConnector}${assetId}`,
          extractAssetIdFromBundle: (bundleId, assetBundleId) => assetBundleId.replace(`${bundleId}${this._bundleIdConnector}`, "")
        };
        /** The character that is used to connect the bundleId and the assetId when generating a bundle asset id key */
        this._bundleIdConnector = this._defaultBundleIdentifierOptions.connector;
        /**
         * A function that generates a bundle asset id key from a bundleId and an assetId
         * @param bundleId - the bundleId
         * @param assetId  - the assetId
         * @returns the bundle asset id key
         */
        this._createBundleAssetId = this._defaultBundleIdentifierOptions.createBundleAssetId;
        /**
         * A function that generates an assetId from a bundle asset id key. This is the reverse of generateBundleAssetId
         * @param bundleId - the bundleId
         * @param assetBundleId - the bundle asset id key
         * @returns the assetId
         */
        this._extractAssetIdFromBundle = this._defaultBundleIdentifierOptions.extractAssetIdFromBundle;
        this._assetMap = {};
        this._preferredOrder = [];
        this._parsers = [];
        this._resolverHash = {};
        this._bundles = {};
      }
      /**
       * Override how the resolver deals with generating bundle ids.
       * must be called before any bundles are added
       * @param bundleIdentifier - the bundle identifier options
       */
      setBundleIdentifier(bundleIdentifier) {
        var _a, _b, _c;
        this._bundleIdConnector = (_a = bundleIdentifier.connector) != null ? _a : this._bundleIdConnector;
        this._createBundleAssetId = (_b = bundleIdentifier.createBundleAssetId) != null ? _b : this._createBundleAssetId;
        this._extractAssetIdFromBundle = (_c = bundleIdentifier.extractAssetIdFromBundle) != null ? _c : this._extractAssetIdFromBundle;
        if (this._extractAssetIdFromBundle("foo", this._createBundleAssetId("foo", "bar")) !== "bar") {
          throw new Error("[Resolver] GenerateBundleAssetId are not working correctly");
        }
      }
      /**
       * Let the resolver know which assets you prefer to use when resolving assets.
       * Multiple prefer user defined rules can be added.
       * @example
       * resolver.prefer({
       *     // first look for something with the correct format, and then then correct resolution
       *     priority: ['format', 'resolution'],
       *     params:{
       *         format:'webp', // prefer webp images
       *         resolution: 2, // prefer a resolution of 2
       *     }
       * })
       * resolver.add('foo', ['bar@2x.webp', 'bar@2x.png', 'bar.webp', 'bar.png']);
       * resolver.resolveUrl('foo') // => 'bar@2x.webp'
       * @param preferOrders - the prefer options
       */
      prefer(...preferOrders) {
        preferOrders.forEach((prefer) => {
          this._preferredOrder.push(prefer);
          if (!prefer.priority) {
            prefer.priority = Object.keys(prefer.params);
          }
        });
        this._resolverHash = {};
      }
      /**
       * Set the base path to prepend to all urls when resolving
       * @example
       * resolver.basePath = 'https://home.com/';
       * resolver.add('foo', 'bar.ong');
       * resolver.resolveUrl('foo', 'bar.png'); // => 'https://home.com/bar.png'
       * @param basePath - the base path to use
       */
      set basePath(basePath) {
        this._basePath = basePath;
      }
      get basePath() {
        return this._basePath;
      }
      /**
       * Set the root path for root-relative URLs. By default the `basePath`'s root is used. If no `basePath` is set, then the
       * default value for browsers is `window.location.origin`
       * @example
       * // Application hosted on https://home.com/some-path/index.html
       * resolver.basePath = 'https://home.com/some-path/';
       * resolver.rootPath = 'https://home.com/';
       * resolver.add('foo', '/bar.png');
       * resolver.resolveUrl('foo', '/bar.png'); // => 'https://home.com/bar.png'
       * @param rootPath - the root path to use
       */
      set rootPath(rootPath) {
        this._rootPath = rootPath;
      }
      get rootPath() {
        return this._rootPath;
      }
      /**
       * All the active URL parsers that help the parser to extract information and create
       * an asset object-based on parsing the URL itself.
       *
       * Can be added using the extensions API
       * @example
       * resolver.add('foo', [
       *     {
       *         resolution: 2,
       *         format: 'png',
       *         src: 'image@2x.png',
       *     },
       *     {
       *         resolution:1,
       *         format:'png',
       *         src: 'image.png',
       *     },
       * ]);
       *
       * // With a url parser the information such as resolution and file format could extracted from the url itself:
       * extensions.add({
       *     extension: ExtensionType.ResolveParser,
       *     test: loadTextures.test, // test if url ends in an image
       *     parse: (value: string) =>
       *     ({
       *         resolution: parseFloat(Resolver.RETINA_PREFIX.exec(value)?.[1] ?? '1'),
       *         format: value.split('.').pop(),
       *         src: value,
       *     }),
       * });
       *
       * // Now resolution and format can be extracted from the url
       * resolver.add('foo', [
       *     'image@2x.png',
       *     'image.png',
       * ]);
       */
      get parsers() {
        return this._parsers;
      }
      /** Used for testing, this resets the resolver to its initial state */
      reset() {
        this.setBundleIdentifier(this._defaultBundleIdentifierOptions);
        this._assetMap = {};
        this._preferredOrder = [];
        this._resolverHash = {};
        this._rootPath = null;
        this._basePath = null;
        this._manifest = null;
        this._bundles = {};
        this._defaultSearchParams = null;
      }
      /**
       * Sets the default URL search parameters for the URL resolver. The urls can be specified as a string or an object.
       * @param searchParams - the default url parameters to append when resolving urls
       */
      setDefaultSearchParams(searchParams) {
        if (typeof searchParams === "string") {
          this._defaultSearchParams = searchParams;
        } else {
          const queryValues = searchParams;
          this._defaultSearchParams = Object.keys(queryValues).map((key) => `${encodeURIComponent(key)}=${encodeURIComponent(queryValues[key])}`).join("&");
        }
      }
      /**
       * Returns the aliases for a given asset
       * @param asset - the asset to get the aliases for
       */
      getAlias(asset) {
        const { alias, src } = asset;
        const aliasesToUse = convertToList(
          alias || src,
          (value) => {
            if (typeof value === "string")
              return value;
            if (Array.isArray(value))
              return value.map((v) => {
                var _a;
                return (_a = v == null ? void 0 : v.src) != null ? _a : v;
              });
            if (value == null ? void 0 : value.src)
              return value.src;
            return value;
          },
          true
        );
        return aliasesToUse;
      }
      /**
       * Add a manifest to the asset resolver. This is a nice way to add all the asset information in one go.
       * generally a manifest would be built using a tool.
       * @param manifest - the manifest to add to the resolver
       */
      addManifest(manifest) {
        if (this._manifest) {
          warn("[Resolver] Manifest already exists, this will be overwritten");
        }
        this._manifest = manifest;
        manifest.bundles.forEach((bundle) => {
          this.addBundle(bundle.name, bundle.assets);
        });
      }
      /**
       * This adds a bundle of assets in one go so that you can resolve them as a group.
       * For example you could add a bundle for each screen in you pixi app
       * @example
       * resolver.addBundle('animals', [
       *  { alias: 'bunny', src: 'bunny.png' },
       *  { alias: 'chicken', src: 'chicken.png' },
       *  { alias: 'thumper', src: 'thumper.png' },
       * ]);
       * // or
       * resolver.addBundle('animals', {
       *     bunny: 'bunny.png',
       *     chicken: 'chicken.png',
       *     thumper: 'thumper.png',
       * });
       *
       * const resolvedAssets = await resolver.resolveBundle('animals');
       * @param bundleId - The id of the bundle to add
       * @param assets - A record of the asset or assets that will be chosen from when loading via the specified key
       */
      addBundle(bundleId, assets) {
        const assetNames = [];
        let convertedAssets = assets;
        if (!Array.isArray(assets)) {
          convertedAssets = Object.entries(assets).map(([alias, src]) => {
            if (typeof src === "string" || Array.isArray(src)) {
              return { alias, src };
            }
            return __spreadValues$17({ alias }, src);
          });
        }
        convertedAssets.forEach((asset) => {
          const srcs = asset.src;
          const aliases = asset.alias;
          let ids;
          if (typeof aliases === "string") {
            const bundleAssetId = this._createBundleAssetId(bundleId, aliases);
            assetNames.push(bundleAssetId);
            ids = [aliases, bundleAssetId];
          } else {
            const bundleIds = aliases.map((name) => this._createBundleAssetId(bundleId, name));
            assetNames.push(...bundleIds);
            ids = [...aliases, ...bundleIds];
          }
          this.add(__spreadValues$17(__spreadValues$17({}, asset), {
            alias: ids,
            src: srcs
          }));
        });
        this._bundles[bundleId] = assetNames;
      }
      /**
       * Tells the resolver what keys are associated with witch asset.
       * The most important thing the resolver does
       * @example
       * // Single key, single asset:
       * resolver.add({alias: 'foo', src: 'bar.png');
       * resolver.resolveUrl('foo') // => 'bar.png'
       *
       * // Multiple keys, single asset:
       * resolver.add({alias: ['foo', 'boo'], src: 'bar.png'});
       * resolver.resolveUrl('foo') // => 'bar.png'
       * resolver.resolveUrl('boo') // => 'bar.png'
       *
       * // Multiple keys, multiple assets:
       * resolver.add({alias: ['foo', 'boo'], src: ['bar.png', 'bar.webp']});
       * resolver.resolveUrl('foo') // => 'bar.png'
       *
       * // Add custom data attached to the resolver
       * Resolver.add({
       *     alias: 'bunnyBooBooSmooth',
       *     src: 'bunny{png,webp}',
       *     data: { scaleMode:SCALE_MODES.NEAREST }, // Base texture options
       * });
       *
       * resolver.resolve('bunnyBooBooSmooth') // => { src: 'bunny.png', data: { scaleMode: SCALE_MODES.NEAREST } }
       * @param aliases - the UnresolvedAsset or array of UnresolvedAssets to add to the resolver
       */
      add(aliases) {
        const assets = [];
        if (Array.isArray(aliases)) {
          assets.push(...aliases);
        } else {
          assets.push(aliases);
        }
        let keyCheck;
        keyCheck = (key) => {
          if (this.hasKey(key)) {
            warn(`[Resolver] already has key: ${key} overwriting`);
          }
        };
        const assetArray = convertToList(assets);
        assetArray.forEach((asset) => {
          const { src } = asset;
          let { data, format, loadParser } = asset;
          const srcsToUse = convertToList(src).map((src2) => {
            if (typeof src2 === "string") {
              return createStringVariations(src2);
            }
            return Array.isArray(src2) ? src2 : [src2];
          });
          const aliasesToUse = this.getAlias(asset);
          Array.isArray(aliasesToUse) ? aliasesToUse.forEach(keyCheck) : keyCheck(aliasesToUse);
          const resolvedAssets = [];
          srcsToUse.forEach((srcs) => {
            srcs.forEach((src2) => {
              var _a, _b, _c;
              let formattedAsset = {};
              if (typeof src2 !== "object") {
                formattedAsset.src = src2;
                for (let i = 0; i < this._parsers.length; i++) {
                  const parser = this._parsers[i];
                  if (parser.test(src2)) {
                    formattedAsset = parser.parse(src2);
                    break;
                  }
                }
              } else {
                data = (_a = src2.data) != null ? _a : data;
                format = (_b = src2.format) != null ? _b : format;
                loadParser = (_c = src2.loadParser) != null ? _c : loadParser;
                formattedAsset = __spreadValues$17(__spreadValues$17({}, formattedAsset), src2);
              }
              if (!aliasesToUse) {
                throw new Error(`[Resolver] alias is undefined for this asset: ${formattedAsset.src}`);
              }
              formattedAsset = this._buildResolvedAsset(formattedAsset, {
                aliases: aliasesToUse,
                data,
                format,
                loadParser
              });
              resolvedAssets.push(formattedAsset);
            });
          });
          aliasesToUse.forEach((alias) => {
            this._assetMap[alias] = resolvedAssets;
          });
        });
      }
      // TODO: this needs an overload like load did in Assets
      /**
       * If the resolver has had a manifest set via setManifest, this will return the assets urls for
       * a given bundleId or bundleIds.
       * @example
       * // Manifest Example
       * const manifest = {
       *     bundles: [
       *         {
       *             name: 'load-screen',
       *             assets: [
       *                 {
       *                     alias: 'background',
       *                     src: 'sunset.png',
       *                 },
       *                 {
       *                     alias: 'bar',
       *                     src: 'load-bar.{png,webp}',
       *                 },
       *             ],
       *         },
       *         {
       *             name: 'game-screen',
       *             assets: [
       *                 {
       *                     alias: 'character',
       *                     src: 'robot.png',
       *                 },
       *                 {
       *                     alias: 'enemy',
       *                     src: 'bad-guy.png',
       *                 },
       *             ],
       *         },
       *     ]
       * };
       *
       * resolver.setManifest(manifest);
       * const resolved = resolver.resolveBundle('load-screen');
       * @param bundleIds - The bundle ids to resolve
       * @returns All the bundles assets or a hash of assets for each bundle specified
       */
      resolveBundle(bundleIds) {
        const singleAsset = isSingleItem(bundleIds);
        bundleIds = convertToList(bundleIds);
        const out = {};
        bundleIds.forEach((bundleId) => {
          const assetNames = this._bundles[bundleId];
          if (assetNames) {
            const results = this.resolve(assetNames);
            const assets = {};
            for (const key in results) {
              const asset = results[key];
              assets[this._extractAssetIdFromBundle(bundleId, key)] = asset;
            }
            out[bundleId] = assets;
          }
        });
        return singleAsset ? out[bundleIds[0]] : out;
      }
      /**
       * Does exactly what resolve does, but returns just the URL rather than the whole asset object
       * @param key - The key or keys to resolve
       * @returns - The URLs associated with the key(s)
       */
      resolveUrl(key) {
        const result = this.resolve(key);
        if (typeof key !== "string") {
          const out = {};
          for (const i in result) {
            out[i] = result[i].src;
          }
          return out;
        }
        return result.src;
      }
      resolve(keys) {
        const singleAsset = isSingleItem(keys);
        keys = convertToList(keys);
        const result = {};
        keys.forEach((key) => {
          if (!this._resolverHash[key]) {
            if (this._assetMap[key]) {
              let assets = this._assetMap[key];
              const preferredOrder = this._getPreferredOrder(assets);
              preferredOrder == null ? void 0 : preferredOrder.priority.forEach((priorityKey) => {
                preferredOrder.params[priorityKey].forEach((value) => {
                  const filteredAssets = assets.filter((asset) => {
                    if (asset[priorityKey]) {
                      return asset[priorityKey] === value;
                    }
                    return false;
                  });
                  if (filteredAssets.length) {
                    assets = filteredAssets;
                  }
                });
              });
              this._resolverHash[key] = assets[0];
            } else {
              this._resolverHash[key] = this._buildResolvedAsset({
                alias: [key],
                src: key
              }, {});
            }
          }
          result[key] = this._resolverHash[key];
        });
        return singleAsset ? result[keys[0]] : result;
      }
      /**
       * Checks if an asset with a given key exists in the resolver
       * @param key - The key of the asset
       */
      hasKey(key) {
        return !!this._assetMap[key];
      }
      /**
       * Checks if a bundle with the given key exists in the resolver
       * @param key - The key of the bundle
       */
      hasBundle(key) {
        return !!this._bundles[key];
      }
      /**
       * Internal function for figuring out what prefer criteria an asset should use.
       * @param assets
       */
      _getPreferredOrder(assets) {
        for (let i = 0; i < assets.length; i++) {
          const asset = assets[0];
          const preferred = this._preferredOrder.find((preference) => preference.params.format.includes(asset.format));
          if (preferred) {
            return preferred;
          }
        }
        return this._preferredOrder[0];
      }
      /**
       * Appends the default url parameters to the url
       * @param url - The url to append the default parameters to
       * @returns - The url with the default parameters appended
       */
      _appendDefaultSearchParams(url) {
        if (!this._defaultSearchParams)
          return url;
        const paramConnector = /\?/.test(url) ? "&" : "?";
        return `${url}${paramConnector}${this._defaultSearchParams}`;
      }
      _buildResolvedAsset(formattedAsset, data) {
        var _a, _b;
        const { aliases, data: assetData, loadParser, format } = data;
        if (this._basePath || this._rootPath) {
          formattedAsset.src = path.toAbsolute(formattedAsset.src, this._basePath, this._rootPath);
        }
        formattedAsset.alias = (_a = aliases != null ? aliases : formattedAsset.alias) != null ? _a : [formattedAsset.src];
        formattedAsset.src = this._appendDefaultSearchParams(formattedAsset.src);
        formattedAsset.data = __spreadValues$17(__spreadValues$17({}, assetData || {}), formattedAsset.data);
        formattedAsset.loadParser = loadParser != null ? loadParser : formattedAsset.loadParser;
        formattedAsset.format = (_b = format != null ? format : formattedAsset.format) != null ? _b : getUrlExtension(formattedAsset.src);
        return formattedAsset;
      }
    }
    /**
     * The prefix that denotes a URL is for a retina asset.
     * @static
     * @name RETINA_PREFIX
     * @type {RegExp}
     * @default /@([0-9\.]+)x/
     * @example `@2x`
     */
    Resolver.RETINA_PREFIX = /@([0-9\.]+)x/;
    function getUrlExtension(url) {
      return url.split(".").pop().split("?").shift().split("#").shift();
    }

    "use strict";
    const copySearchParams = (targetUrl, sourceUrl) => {
      const searchParams = sourceUrl.split("?")[1];
      if (searchParams) {
        targetUrl += `?${searchParams}`;
      }
      return targetUrl;
    };

    var eventemitter3$1 = {exports: {}};

    var eventemitter3 = eventemitter3$1.exports;

    (function (module) {
    	'use strict';

    	var has = Object.prototype.hasOwnProperty
    	  , prefix = '~';

    	/**
    	 * Constructor to create a storage for our `EE` objects.
    	 * An `Events` instance is a plain object whose properties are event names.
    	 *
    	 * @constructor
    	 * @private
    	 */
    	function Events() {}

    	//
    	// We try to not inherit from `Object.prototype`. In some engines creating an
    	// instance in this way is faster than calling `Object.create(null)` directly.
    	// If `Object.create(null)` is not supported we prefix the event names with a
    	// character to make sure that the built-in object properties are not
    	// overridden or used as an attack vector.
    	//
    	if (Object.create) {
    	  Events.prototype = Object.create(null);

    	  //
    	  // This hack is needed because the `__proto__` property is still inherited in
    	  // some old browsers like Android 4, iPhone 5.1, Opera 11 and Safari 5.
    	  //
    	  if (!new Events().__proto__) prefix = false;
    	}

    	/**
    	 * Representation of a single event listener.
    	 *
    	 * @param {Function} fn The listener function.
    	 * @param {*} context The context to invoke the listener with.
    	 * @param {Boolean} [once=false] Specify if the listener is a one-time listener.
    	 * @constructor
    	 * @private
    	 */
    	function EE(fn, context, once) {
    	  this.fn = fn;
    	  this.context = context;
    	  this.once = once || false;
    	}

    	/**
    	 * Add a listener for a given event.
    	 *
    	 * @param {EventEmitter} emitter Reference to the `EventEmitter` instance.
    	 * @param {(String|Symbol)} event The event name.
    	 * @param {Function} fn The listener function.
    	 * @param {*} context The context to invoke the listener with.
    	 * @param {Boolean} once Specify if the listener is a one-time listener.
    	 * @returns {EventEmitter}
    	 * @private
    	 */
    	function addListener(emitter, event, fn, context, once) {
    	  if (typeof fn !== 'function') {
    	    throw new TypeError('The listener must be a function');
    	  }

    	  var listener = new EE(fn, context || emitter, once)
    	    , evt = prefix ? prefix + event : event;

    	  if (!emitter._events[evt]) emitter._events[evt] = listener, emitter._eventsCount++;
    	  else if (!emitter._events[evt].fn) emitter._events[evt].push(listener);
    	  else emitter._events[evt] = [emitter._events[evt], listener];

    	  return emitter;
    	}

    	/**
    	 * Clear event by name.
    	 *
    	 * @param {EventEmitter} emitter Reference to the `EventEmitter` instance.
    	 * @param {(String|Symbol)} evt The Event name.
    	 * @private
    	 */
    	function clearEvent(emitter, evt) {
    	  if (--emitter._eventsCount === 0) emitter._events = new Events();
    	  else delete emitter._events[evt];
    	}

    	/**
    	 * Minimal `EventEmitter` interface that is molded against the Node.js
    	 * `EventEmitter` interface.
    	 *
    	 * @constructor
    	 * @public
    	 */
    	function EventEmitter() {
    	  this._events = new Events();
    	  this._eventsCount = 0;
    	}

    	/**
    	 * Return an array listing the events for which the emitter has registered
    	 * listeners.
    	 *
    	 * @returns {Array}
    	 * @public
    	 */
    	EventEmitter.prototype.eventNames = function eventNames() {
    	  var names = []
    	    , events
    	    , name;

    	  if (this._eventsCount === 0) return names;

    	  for (name in (events = this._events)) {
    	    if (has.call(events, name)) names.push(prefix ? name.slice(1) : name);
    	  }

    	  if (Object.getOwnPropertySymbols) {
    	    return names.concat(Object.getOwnPropertySymbols(events));
    	  }

    	  return names;
    	};

    	/**
    	 * Return the listeners registered for a given event.
    	 *
    	 * @param {(String|Symbol)} event The event name.
    	 * @returns {Array} The registered listeners.
    	 * @public
    	 */
    	EventEmitter.prototype.listeners = function listeners(event) {
    	  var evt = prefix ? prefix + event : event
    	    , handlers = this._events[evt];

    	  if (!handlers) return [];
    	  if (handlers.fn) return [handlers.fn];

    	  for (var i = 0, l = handlers.length, ee = new Array(l); i < l; i++) {
    	    ee[i] = handlers[i].fn;
    	  }

    	  return ee;
    	};

    	/**
    	 * Return the number of listeners listening to a given event.
    	 *
    	 * @param {(String|Symbol)} event The event name.
    	 * @returns {Number} The number of listeners.
    	 * @public
    	 */
    	EventEmitter.prototype.listenerCount = function listenerCount(event) {
    	  var evt = prefix ? prefix + event : event
    	    , listeners = this._events[evt];

    	  if (!listeners) return 0;
    	  if (listeners.fn) return 1;
    	  return listeners.length;
    	};

    	/**
    	 * Calls each of the listeners registered for a given event.
    	 *
    	 * @param {(String|Symbol)} event The event name.
    	 * @returns {Boolean} `true` if the event had listeners, else `false`.
    	 * @public
    	 */
    	EventEmitter.prototype.emit = function emit(event, a1, a2, a3, a4, a5) {
    	  var evt = prefix ? prefix + event : event;

    	  if (!this._events[evt]) return false;

    	  var listeners = this._events[evt]
    	    , len = arguments.length
    	    , args
    	    , i;

    	  if (listeners.fn) {
    	    if (listeners.once) this.removeListener(event, listeners.fn, undefined, true);

    	    switch (len) {
    	      case 1: return listeners.fn.call(listeners.context), true;
    	      case 2: return listeners.fn.call(listeners.context, a1), true;
    	      case 3: return listeners.fn.call(listeners.context, a1, a2), true;
    	      case 4: return listeners.fn.call(listeners.context, a1, a2, a3), true;
    	      case 5: return listeners.fn.call(listeners.context, a1, a2, a3, a4), true;
    	      case 6: return listeners.fn.call(listeners.context, a1, a2, a3, a4, a5), true;
    	    }

    	    for (i = 1, args = new Array(len -1); i < len; i++) {
    	      args[i - 1] = arguments[i];
    	    }

    	    listeners.fn.apply(listeners.context, args);
    	  } else {
    	    var length = listeners.length
    	      , j;

    	    for (i = 0; i < length; i++) {
    	      if (listeners[i].once) this.removeListener(event, listeners[i].fn, undefined, true);

    	      switch (len) {
    	        case 1: listeners[i].fn.call(listeners[i].context); break;
    	        case 2: listeners[i].fn.call(listeners[i].context, a1); break;
    	        case 3: listeners[i].fn.call(listeners[i].context, a1, a2); break;
    	        case 4: listeners[i].fn.call(listeners[i].context, a1, a2, a3); break;
    	        default:
    	          if (!args) for (j = 1, args = new Array(len -1); j < len; j++) {
    	            args[j - 1] = arguments[j];
    	          }

    	          listeners[i].fn.apply(listeners[i].context, args);
    	      }
    	    }
    	  }

    	  return true;
    	};

    	/**
    	 * Add a listener for a given event.
    	 *
    	 * @param {(String|Symbol)} event The event name.
    	 * @param {Function} fn The listener function.
    	 * @param {*} [context=this] The context to invoke the listener with.
    	 * @returns {EventEmitter} `this`.
    	 * @public
    	 */
    	EventEmitter.prototype.on = function on(event, fn, context) {
    	  return addListener(this, event, fn, context, false);
    	};

    	/**
    	 * Add a one-time listener for a given event.
    	 *
    	 * @param {(String|Symbol)} event The event name.
    	 * @param {Function} fn The listener function.
    	 * @param {*} [context=this] The context to invoke the listener with.
    	 * @returns {EventEmitter} `this`.
    	 * @public
    	 */
    	EventEmitter.prototype.once = function once(event, fn, context) {
    	  return addListener(this, event, fn, context, true);
    	};

    	/**
    	 * Remove the listeners of a given event.
    	 *
    	 * @param {(String|Symbol)} event The event name.
    	 * @param {Function} fn Only remove the listeners that match this function.
    	 * @param {*} context Only remove the listeners that have this context.
    	 * @param {Boolean} once Only remove one-time listeners.
    	 * @returns {EventEmitter} `this`.
    	 * @public
    	 */
    	EventEmitter.prototype.removeListener = function removeListener(event, fn, context, once) {
    	  var evt = prefix ? prefix + event : event;

    	  if (!this._events[evt]) return this;
    	  if (!fn) {
    	    clearEvent(this, evt);
    	    return this;
    	  }

    	  var listeners = this._events[evt];

    	  if (listeners.fn) {
    	    if (
    	      listeners.fn === fn &&
    	      (!once || listeners.once) &&
    	      (!context || listeners.context === context)
    	    ) {
    	      clearEvent(this, evt);
    	    }
    	  } else {
    	    for (var i = 0, events = [], length = listeners.length; i < length; i++) {
    	      if (
    	        listeners[i].fn !== fn ||
    	        (once && !listeners[i].once) ||
    	        (context && listeners[i].context !== context)
    	      ) {
    	        events.push(listeners[i]);
    	      }
    	    }

    	    //
    	    // Reset the array, or remove it completely if we have no more listeners.
    	    //
    	    if (events.length) this._events[evt] = events.length === 1 ? events[0] : events;
    	    else clearEvent(this, evt);
    	  }

    	  return this;
    	};

    	/**
    	 * Remove all listeners, or those of the specified event.
    	 *
    	 * @param {(String|Symbol)} [event] The event name.
    	 * @returns {EventEmitter} `this`.
    	 * @public
    	 */
    	EventEmitter.prototype.removeAllListeners = function removeAllListeners(event) {
    	  var evt;

    	  if (event) {
    	    evt = prefix ? prefix + event : event;
    	    if (this._events[evt]) clearEvent(this, evt);
    	  } else {
    	    this._events = new Events();
    	    this._eventsCount = 0;
    	  }

    	  return this;
    	};

    	//
    	// Alias methods names because people roll like that.
    	//
    	EventEmitter.prototype.off = EventEmitter.prototype.removeListener;
    	EventEmitter.prototype.addListener = EventEmitter.prototype.on;

    	//
    	// Expose the prefix.
    	//
    	EventEmitter.prefixed = prefix;

    	//
    	// Allow `EventEmitter` to be imported as module namespace.
    	//
    	EventEmitter.EventEmitter = EventEmitter;

    	//
    	// Expose the module.
    	//
    	if ('undefined' !== 'object') {
    	  module.exports = EventEmitter;
    	} 
    } (eventemitter3$1));

    var eventemitter3Exports = eventemitter3$1.exports;
    var EventEmitter = /*@__PURE__*/getDefaultExportFromCjs(eventemitter3Exports);

    "use strict";
    const PI_2 = Math.PI * 2;
    const RAD_TO_DEG = 180 / Math.PI;
    const DEG_TO_RAD = Math.PI / 180;

    "use strict";
    class Point {
      /**
       * Creates a new `Point`
       * @param {number} [x=0] - position of the point on the x axis
       * @param {number} [y=0] - position of the point on the y axis
       */
      constructor(x = 0, y = 0) {
        /** Position of the point on the x axis */
        this.x = 0;
        /** Position of the point on the y axis */
        this.y = 0;
        this.x = x;
        this.y = y;
      }
      /**
       * Creates a clone of this point
       * @returns A clone of this point
       */
      clone() {
        return new Point(this.x, this.y);
      }
      /**
       * Copies `x` and `y` from the given point into this point
       * @param p - The point to copy from
       * @returns The point instance itself
       */
      copyFrom(p) {
        this.set(p.x, p.y);
        return this;
      }
      /**
       * Copies this point's x and y into the given point (`p`).
       * @param p - The point to copy to. Can be any of type that is or extends `PointData`
       * @returns The point (`p`) with values updated
       */
      copyTo(p) {
        p.set(this.x, this.y);
        return p;
      }
      /**
       * Accepts another point (`p`) and returns `true` if the given point is equal to this point
       * @param p - The point to check
       * @returns Returns `true` if both `x` and `y` are equal
       */
      equals(p) {
        return p.x === this.x && p.y === this.y;
      }
      /**
       * Sets the point to a new `x` and `y` position.
       * If `y` is omitted, both `x` and `y` will be set to `x`.
       * @param {number} [x=0] - position of the point on the `x` axis
       * @param {number} [y=x] - position of the point on the `y` axis
       * @returns The point instance itself
       */
      set(x = 0, y = x) {
        this.x = x;
        this.y = y;
        return this;
      }
      toString() {
        return `[pixi.js/math:Point x=${this.x} y=${this.y}]`;
      }
      /**
       * A static Point object with `x` and `y` values of `0`. Can be used to avoid creating new objects multiple times.
       * @readonly
       */
      static get shared() {
        tempPoint.x = 0;
        tempPoint.y = 0;
        return tempPoint;
      }
    }
    const tempPoint = new Point();

    "use strict";
    class Matrix {
      /**
       * @param a - x scale
       * @param b - y skew
       * @param c - x skew
       * @param d - y scale
       * @param tx - x translation
       * @param ty - y translation
       */
      constructor(a = 1, b = 0, c = 0, d = 1, tx = 0, ty = 0) {
        /** An array of the current matrix. Only populated when `toArray` is called */
        this.array = null;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.tx = tx;
        this.ty = ty;
      }
      /**
       * Creates a Matrix object based on the given array. The Element to Matrix mapping order is as follows:
       *
       * a = array[0]
       * b = array[1]
       * c = array[3]
       * d = array[4]
       * tx = array[2]
       * ty = array[5]
       * @param array - The array that the matrix will be populated from.
       */
      fromArray(array) {
        this.a = array[0];
        this.b = array[1];
        this.c = array[3];
        this.d = array[4];
        this.tx = array[2];
        this.ty = array[5];
      }
      /**
       * Sets the matrix properties.
       * @param a - Matrix component
       * @param b - Matrix component
       * @param c - Matrix component
       * @param d - Matrix component
       * @param tx - Matrix component
       * @param ty - Matrix component
       * @returns This matrix. Good for chaining method calls.
       */
      set(a, b, c, d, tx, ty) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.tx = tx;
        this.ty = ty;
        return this;
      }
      /**
       * Creates an array from the current Matrix object.
       * @param transpose - Whether we need to transpose the matrix or not
       * @param [out=new Float32Array(9)] - If provided the array will be assigned to out
       * @returns The newly created array which contains the matrix
       */
      toArray(transpose, out) {
        if (!this.array) {
          this.array = new Float32Array(9);
        }
        const array = out || this.array;
        if (transpose) {
          array[0] = this.a;
          array[1] = this.b;
          array[2] = 0;
          array[3] = this.c;
          array[4] = this.d;
          array[5] = 0;
          array[6] = this.tx;
          array[7] = this.ty;
          array[8] = 1;
        } else {
          array[0] = this.a;
          array[1] = this.c;
          array[2] = this.tx;
          array[3] = this.b;
          array[4] = this.d;
          array[5] = this.ty;
          array[6] = 0;
          array[7] = 0;
          array[8] = 1;
        }
        return array;
      }
      /**
       * Get a new position with the current transformation applied.
       * Can be used to go from a child's coordinate space to the world coordinate space. (e.g. rendering)
       * @param pos - The origin
       * @param {Point} [newPos] - The point that the new position is assigned to (allowed to be same as input)
       * @returns {Point} The new point, transformed through this matrix
       */
      apply(pos, newPos) {
        newPos = newPos || new Point();
        const x = pos.x;
        const y = pos.y;
        newPos.x = this.a * x + this.c * y + this.tx;
        newPos.y = this.b * x + this.d * y + this.ty;
        return newPos;
      }
      /**
       * Get a new position with the inverse of the current transformation applied.
       * Can be used to go from the world coordinate space to a child's coordinate space. (e.g. input)
       * @param pos - The origin
       * @param {Point} [newPos] - The point that the new position is assigned to (allowed to be same as input)
       * @returns {Point} The new point, inverse-transformed through this matrix
       */
      applyInverse(pos, newPos) {
        newPos = newPos || new Point();
        const a = this.a;
        const b = this.b;
        const c = this.c;
        const d = this.d;
        const tx = this.tx;
        const ty = this.ty;
        const id = 1 / (a * d + c * -b);
        const x = pos.x;
        const y = pos.y;
        newPos.x = d * id * x + -c * id * y + (ty * c - tx * d) * id;
        newPos.y = a * id * y + -b * id * x + (-ty * a + tx * b) * id;
        return newPos;
      }
      /**
       * Translates the matrix on the x and y.
       * @param x - How much to translate x by
       * @param y - How much to translate y by
       * @returns This matrix. Good for chaining method calls.
       */
      translate(x, y) {
        this.tx += x;
        this.ty += y;
        return this;
      }
      /**
       * Applies a scale transformation to the matrix.
       * @param x - The amount to scale horizontally
       * @param y - The amount to scale vertically
       * @returns This matrix. Good for chaining method calls.
       */
      scale(x, y) {
        this.a *= x;
        this.d *= y;
        this.c *= x;
        this.b *= y;
        this.tx *= x;
        this.ty *= y;
        return this;
      }
      /**
       * Applies a rotation transformation to the matrix.
       * @param angle - The angle in radians.
       * @returns This matrix. Good for chaining method calls.
       */
      rotate(angle) {
        const cos = Math.cos(angle);
        const sin = Math.sin(angle);
        const a1 = this.a;
        const c1 = this.c;
        const tx1 = this.tx;
        this.a = a1 * cos - this.b * sin;
        this.b = a1 * sin + this.b * cos;
        this.c = c1 * cos - this.d * sin;
        this.d = c1 * sin + this.d * cos;
        this.tx = tx1 * cos - this.ty * sin;
        this.ty = tx1 * sin + this.ty * cos;
        return this;
      }
      /**
       * Appends the given Matrix to this Matrix.
       * @param matrix - The matrix to append.
       * @returns This matrix. Good for chaining method calls.
       */
      append(matrix) {
        const a1 = this.a;
        const b1 = this.b;
        const c1 = this.c;
        const d1 = this.d;
        this.a = matrix.a * a1 + matrix.b * c1;
        this.b = matrix.a * b1 + matrix.b * d1;
        this.c = matrix.c * a1 + matrix.d * c1;
        this.d = matrix.c * b1 + matrix.d * d1;
        this.tx = matrix.tx * a1 + matrix.ty * c1 + this.tx;
        this.ty = matrix.tx * b1 + matrix.ty * d1 + this.ty;
        return this;
      }
      /**
       * Appends two matrix's and sets the result to this matrix. AB = A * B
       * @param a - The matrix to append.
       * @param b - The matrix to append.
       * @returns This matrix. Good for chaining method calls.
       */
      appendFrom(a, b) {
        const a1 = a.a;
        const b1 = a.b;
        const c1 = a.c;
        const d1 = a.d;
        const tx = a.tx;
        const ty = a.ty;
        const a2 = b.a;
        const b2 = b.b;
        const c2 = b.c;
        const d2 = b.d;
        this.a = a1 * a2 + b1 * c2;
        this.b = a1 * b2 + b1 * d2;
        this.c = c1 * a2 + d1 * c2;
        this.d = c1 * b2 + d1 * d2;
        this.tx = tx * a2 + ty * c2 + b.tx;
        this.ty = tx * b2 + ty * d2 + b.ty;
        return this;
      }
      /**
       * Sets the matrix based on all the available properties
       * @param x - Position on the x axis
       * @param y - Position on the y axis
       * @param pivotX - Pivot on the x axis
       * @param pivotY - Pivot on the y axis
       * @param scaleX - Scale on the x axis
       * @param scaleY - Scale on the y axis
       * @param rotation - Rotation in radians
       * @param skewX - Skew on the x axis
       * @param skewY - Skew on the y axis
       * @returns This matrix. Good for chaining method calls.
       */
      setTransform(x, y, pivotX, pivotY, scaleX, scaleY, rotation, skewX, skewY) {
        this.a = Math.cos(rotation + skewY) * scaleX;
        this.b = Math.sin(rotation + skewY) * scaleX;
        this.c = -Math.sin(rotation - skewX) * scaleY;
        this.d = Math.cos(rotation - skewX) * scaleY;
        this.tx = x - (pivotX * this.a + pivotY * this.c);
        this.ty = y - (pivotX * this.b + pivotY * this.d);
        return this;
      }
      /**
       * Prepends the given Matrix to this Matrix.
       * @param matrix - The matrix to prepend
       * @returns This matrix. Good for chaining method calls.
       */
      prepend(matrix) {
        const tx1 = this.tx;
        if (matrix.a !== 1 || matrix.b !== 0 || matrix.c !== 0 || matrix.d !== 1) {
          const a1 = this.a;
          const c1 = this.c;
          this.a = a1 * matrix.a + this.b * matrix.c;
          this.b = a1 * matrix.b + this.b * matrix.d;
          this.c = c1 * matrix.a + this.d * matrix.c;
          this.d = c1 * matrix.b + this.d * matrix.d;
        }
        this.tx = tx1 * matrix.a + this.ty * matrix.c + matrix.tx;
        this.ty = tx1 * matrix.b + this.ty * matrix.d + matrix.ty;
        return this;
      }
      /**
       * Decomposes the matrix (x, y, scaleX, scaleY, and rotation) and sets the properties on to a transform.
       * @param transform - The transform to apply the properties to.
       * @returns The transform with the newly applied properties
       */
      decompose(transform) {
        const a = this.a;
        const b = this.b;
        const c = this.c;
        const d = this.d;
        const pivot = transform.pivot;
        const skewX = -Math.atan2(-c, d);
        const skewY = Math.atan2(b, a);
        const delta = Math.abs(skewX + skewY);
        if (delta < 1e-5 || Math.abs(PI_2 - delta) < 1e-5) {
          transform.rotation = skewY;
          transform.skew.x = transform.skew.y = 0;
        } else {
          transform.rotation = 0;
          transform.skew.x = skewX;
          transform.skew.y = skewY;
        }
        transform.scale.x = Math.sqrt(a * a + b * b);
        transform.scale.y = Math.sqrt(c * c + d * d);
        transform.position.x = this.tx + (pivot.x * a + pivot.y * c);
        transform.position.y = this.ty + (pivot.x * b + pivot.y * d);
        return transform;
      }
      /**
       * Inverts this matrix
       * @returns This matrix. Good for chaining method calls.
       */
      invert() {
        const a1 = this.a;
        const b1 = this.b;
        const c1 = this.c;
        const d1 = this.d;
        const tx1 = this.tx;
        const n = a1 * d1 - b1 * c1;
        this.a = d1 / n;
        this.b = -b1 / n;
        this.c = -c1 / n;
        this.d = a1 / n;
        this.tx = (c1 * this.ty - d1 * tx1) / n;
        this.ty = -(a1 * this.ty - b1 * tx1) / n;
        return this;
      }
      /** Checks if this matrix is an identity matrix */
      isIdentity() {
        return this.a === 1 && this.b === 0 && this.c === 0 && this.d === 1 && this.tx === 0 && this.ty === 0;
      }
      /**
       * Resets this Matrix to an identity (default) matrix.
       * @returns This matrix. Good for chaining method calls.
       */
      identity() {
        this.a = 1;
        this.b = 0;
        this.c = 0;
        this.d = 1;
        this.tx = 0;
        this.ty = 0;
        return this;
      }
      /**
       * Creates a new Matrix object with the same values as this one.
       * @returns A copy of this matrix. Good for chaining method calls.
       */
      clone() {
        const matrix = new Matrix();
        matrix.a = this.a;
        matrix.b = this.b;
        matrix.c = this.c;
        matrix.d = this.d;
        matrix.tx = this.tx;
        matrix.ty = this.ty;
        return matrix;
      }
      /**
       * Changes the values of the given matrix to be the same as the ones in this matrix
       * @param matrix - The matrix to copy to.
       * @returns The matrix given in parameter with its values updated.
       */
      copyTo(matrix) {
        matrix.a = this.a;
        matrix.b = this.b;
        matrix.c = this.c;
        matrix.d = this.d;
        matrix.tx = this.tx;
        matrix.ty = this.ty;
        return matrix;
      }
      /**
       * Changes the values of the matrix to be the same as the ones in given matrix
       * @param matrix - The matrix to copy from.
       * @returns this
       */
      copyFrom(matrix) {
        this.a = matrix.a;
        this.b = matrix.b;
        this.c = matrix.c;
        this.d = matrix.d;
        this.tx = matrix.tx;
        this.ty = matrix.ty;
        return this;
      }
      /**
       * check to see if two matrices are the same
       * @param matrix - The matrix to compare to.
       */
      equals(matrix) {
        return matrix.a === this.a && matrix.b === this.b && matrix.c === this.c && matrix.d === this.d && matrix.tx === this.tx && matrix.ty === this.ty;
      }
      toString() {
        return `[pixi.js:Matrix a=${this.a} b=${this.b} c=${this.c} d=${this.d} tx=${this.tx} ty=${this.ty}]`;
      }
      /**
       * A default (identity) matrix.
       *
       * This is a shared object, if you want to modify it consider creating a new `Matrix`
       * @readonly
       */
      static get IDENTITY() {
        return identityMatrix$1.identity();
      }
      /**
       * A static Matrix that can be used to avoid creating new objects.
       * Will always ensure the matrix is reset to identity when requested.
       * Use this object for fast but temporary calculations, as it may be mutated later on.
       * This is a different object to the `IDENTITY` object and so can be modified without changing `IDENTITY`.
       * @readonly
       */
      static get shared() {
        return tempMatrix$6.identity();
      }
    }
    const tempMatrix$6 = new Matrix();
    const identityMatrix$1 = new Matrix();

    "use strict";
    const ux = [1, 1, 0, -1, -1, -1, 0, 1, 1, 1, 0, -1, -1, -1, 0, 1];
    const uy = [0, 1, 1, 1, 0, -1, -1, -1, 0, 1, 1, 1, 0, -1, -1, -1];
    const vx = [0, -1, -1, -1, 0, 1, 1, 1, 0, 1, 1, 1, 0, -1, -1, -1];
    const vy = [1, 1, 0, -1, -1, -1, 0, 1, -1, -1, 0, 1, 1, 1, 0, -1];
    const rotationCayley = [];
    const rotationMatrices = [];
    const signum = Math.sign;
    function init() {
      for (let i = 0; i < 16; i++) {
        const row = [];
        rotationCayley.push(row);
        for (let j = 0; j < 16; j++) {
          const _ux = signum(ux[i] * ux[j] + vx[i] * uy[j]);
          const _uy = signum(uy[i] * ux[j] + vy[i] * uy[j]);
          const _vx = signum(ux[i] * vx[j] + vx[i] * vy[j]);
          const _vy = signum(uy[i] * vx[j] + vy[i] * vy[j]);
          for (let k = 0; k < 16; k++) {
            if (ux[k] === _ux && uy[k] === _uy && vx[k] === _vx && vy[k] === _vy) {
              row.push(k);
              break;
            }
          }
        }
      }
      for (let i = 0; i < 16; i++) {
        const mat = new Matrix();
        mat.set(ux[i], uy[i], vx[i], vy[i], 0, 0);
        rotationMatrices.push(mat);
      }
    }
    init();
    const groupD8 = {
      /**
       * | Rotation | Direction |
       * |----------|-----------|
       * | 0°       | East      |
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      E: 0,
      /**
       * | Rotation | Direction |
       * |----------|-----------|
       * | 45°↻     | Southeast |
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      SE: 1,
      /**
       * | Rotation | Direction |
       * |----------|-----------|
       * | 90°↻     | South     |
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      S: 2,
      /**
       * | Rotation | Direction |
       * |----------|-----------|
       * | 135°↻    | Southwest |
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      SW: 3,
      /**
       * | Rotation | Direction |
       * |----------|-----------|
       * | 180°     | West      |
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      W: 4,
      /**
       * | Rotation    | Direction    |
       * |-------------|--------------|
       * | -135°/225°↻ | Northwest    |
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      NW: 5,
      /**
       * | Rotation    | Direction    |
       * |-------------|--------------|
       * | -90°/270°↻  | North        |
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      N: 6,
      /**
       * | Rotation    | Direction    |
       * |-------------|--------------|
       * | -45°/315°↻  | Northeast    |
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      NE: 7,
      /**
       * Reflection about Y-axis.
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      MIRROR_VERTICAL: 8,
      /**
       * Reflection about the main diagonal.
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      MAIN_DIAGONAL: 10,
      /**
       * Reflection about X-axis.
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      MIRROR_HORIZONTAL: 12,
      /**
       * Reflection about reverse diagonal.
       * @memberof maths.groupD8
       * @constant {GD8Symmetry}
       */
      REVERSE_DIAGONAL: 14,
      /**
       * @memberof maths.groupD8
       * @param {GD8Symmetry} ind - sprite rotation angle.
       * @returns {GD8Symmetry} The X-component of the U-axis
       *    after rotating the axes.
       */
      uX: (ind) => ux[ind],
      /**
       * @memberof maths.groupD8
       * @param {GD8Symmetry} ind - sprite rotation angle.
       * @returns {GD8Symmetry} The Y-component of the U-axis
       *    after rotating the axes.
       */
      uY: (ind) => uy[ind],
      /**
       * @memberof maths.groupD8
       * @param {GD8Symmetry} ind - sprite rotation angle.
       * @returns {GD8Symmetry} The X-component of the V-axis
       *    after rotating the axes.
       */
      vX: (ind) => vx[ind],
      /**
       * @memberof maths.groupD8
       * @param {GD8Symmetry} ind - sprite rotation angle.
       * @returns {GD8Symmetry} The Y-component of the V-axis
       *    after rotating the axes.
       */
      vY: (ind) => vy[ind],
      /**
       * @memberof maths.groupD8
       * @param {GD8Symmetry} rotation - symmetry whose opposite
       *   is needed. Only rotations have opposite symmetries while
       *   reflections don't.
       * @returns {GD8Symmetry} The opposite symmetry of `rotation`
       */
      inv: (rotation) => {
        if (rotation & 8) {
          return rotation & 15;
        }
        return -rotation & 7;
      },
      /**
       * Composes the two D8 operations.
       *
       * Taking `^` as reflection:
       *
       * |       | E=0 | S=2 | W=4 | N=6 | E^=8 | S^=10 | W^=12 | N^=14 |
       * |-------|-----|-----|-----|-----|------|-------|-------|-------|
       * | E=0   | E   | S   | W   | N   | E^   | S^    | W^    | N^    |
       * | S=2   | S   | W   | N   | E   | S^   | W^    | N^    | E^    |
       * | W=4   | W   | N   | E   | S   | W^   | N^    | E^    | S^    |
       * | N=6   | N   | E   | S   | W   | N^   | E^    | S^    | W^    |
       * | E^=8  | E^  | N^  | W^  | S^  | E    | N     | W     | S     |
       * | S^=10 | S^  | E^  | N^  | W^  | S    | E     | N     | W     |
       * | W^=12 | W^  | S^  | E^  | N^  | W    | S     | E     | N     |
       * | N^=14 | N^  | W^  | S^  | E^  | N    | W     | S     | E     |
       *
       * [This is a Cayley table]{@link https://en.wikipedia.org/wiki/Cayley_table}
       * @memberof maths.groupD8
       * @param {GD8Symmetry} rotationSecond - Second operation, which
       *   is the row in the above cayley table.
       * @param {GD8Symmetry} rotationFirst - First operation, which
       *   is the column in the above cayley table.
       * @returns {GD8Symmetry} Composed operation
       */
      add: (rotationSecond, rotationFirst) => rotationCayley[rotationSecond][rotationFirst],
      /**
       * Reverse of `add`.
       * @memberof maths.groupD8
       * @param {GD8Symmetry} rotationSecond - Second operation
       * @param {GD8Symmetry} rotationFirst - First operation
       * @returns {GD8Symmetry} Result
       */
      sub: (rotationSecond, rotationFirst) => rotationCayley[rotationSecond][groupD8.inv(rotationFirst)],
      /**
       * Adds 180 degrees to rotation, which is a commutative
       * operation.
       * @memberof maths.groupD8
       * @param {number} rotation - The number to rotate.
       * @returns {number} Rotated number
       */
      rotate180: (rotation) => rotation ^ 4,
      /**
       * Checks if the rotation angle is vertical, i.e. south
       * or north. It doesn't work for reflections.
       * @memberof maths.groupD8
       * @param {GD8Symmetry} rotation - The number to check.
       * @returns {boolean} Whether or not the direction is vertical
       */
      isVertical: (rotation) => (rotation & 3) === 2,
      // rotation % 4 === 2
      /**
       * Approximates the vector `V(dx,dy)` into one of the
       * eight directions provided by `groupD8`.
       * @memberof maths.groupD8
       * @param {number} dx - X-component of the vector
       * @param {number} dy - Y-component of the vector
       * @returns {GD8Symmetry} Approximation of the vector into
       *  one of the eight symmetries.
       */
      byDirection: (dx, dy) => {
        if (Math.abs(dx) * 2 <= Math.abs(dy)) {
          if (dy >= 0) {
            return groupD8.S;
          }
          return groupD8.N;
        } else if (Math.abs(dy) * 2 <= Math.abs(dx)) {
          if (dx > 0) {
            return groupD8.E;
          }
          return groupD8.W;
        } else if (dy > 0) {
          if (dx > 0) {
            return groupD8.SE;
          }
          return groupD8.SW;
        } else if (dx > 0) {
          return groupD8.NE;
        }
        return groupD8.NW;
      },
      /**
       * Helps sprite to compensate texture packer rotation.
       * @memberof maths.groupD8
       * @param {Matrix} matrix - sprite world matrix
       * @param {GD8Symmetry} rotation - The rotation factor to use.
       * @param {number} tx - sprite anchoring
       * @param {number} ty - sprite anchoring
       */
      matrixAppendRotationInv: (matrix, rotation, tx = 0, ty = 0) => {
        const mat = rotationMatrices[groupD8.inv(rotation)];
        mat.tx = tx;
        mat.ty = ty;
        matrix.append(mat);
      }
    };

    "use strict";
    const tempPoints = [new Point(), new Point(), new Point(), new Point()];
    class Rectangle {
      /**
       * @param x - The X coordinate of the upper-left corner of the rectangle
       * @param y - The Y coordinate of the upper-left corner of the rectangle
       * @param width - The overall width of the rectangle
       * @param height - The overall height of the rectangle
       */
      constructor(x = 0, y = 0, width = 0, height = 0) {
        /**
         * The type of the object, mainly used to avoid `instanceof` checks
         * @default 'rectangle'
         */
        this.type = "rectangle";
        this.x = Number(x);
        this.y = Number(y);
        this.width = Number(width);
        this.height = Number(height);
      }
      /** Returns the left edge of the rectangle. */
      get left() {
        return this.x;
      }
      /** Returns the right edge of the rectangle. */
      get right() {
        return this.x + this.width;
      }
      /** Returns the top edge of the rectangle. */
      get top() {
        return this.y;
      }
      /** Returns the bottom edge of the rectangle. */
      get bottom() {
        return this.y + this.height;
      }
      /** Determines whether the Rectangle is empty. */
      isEmpty() {
        return this.left === this.right || this.top === this.bottom;
      }
      /** A constant empty rectangle. This is a new object every time the property is accessed */
      static get EMPTY() {
        return new Rectangle(0, 0, 0, 0);
      }
      /**
       * Creates a clone of this Rectangle
       * @returns a copy of the rectangle
       */
      clone() {
        return new Rectangle(this.x, this.y, this.width, this.height);
      }
      /**
       * Converts a Bounds object to a Rectangle object.
       * @param bounds - The bounds to copy and convert to a rectangle.
       * @returns Returns itself.
       */
      copyFromBounds(bounds) {
        this.x = bounds.minX;
        this.y = bounds.minY;
        this.width = bounds.maxX - bounds.minX;
        this.height = bounds.maxY - bounds.minY;
        return this;
      }
      /**
       * Copies another rectangle to this one.
       * @param rectangle - The rectangle to copy from.
       * @returns Returns itself.
       */
      copyFrom(rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        return this;
      }
      /**
       * Copies this rectangle to another one.
       * @param rectangle - The rectangle to copy to.
       * @returns Returns given parameter.
       */
      copyTo(rectangle) {
        rectangle.copyFrom(this);
        return rectangle;
      }
      /**
       * Checks whether the x and y coordinates given are contained within this Rectangle
       * @param x - The X coordinate of the point to test
       * @param y - The Y coordinate of the point to test
       * @returns Whether the x/y coordinates are within this Rectangle
       */
      contains(x, y) {
        if (this.width <= 0 || this.height <= 0) {
          return false;
        }
        if (x >= this.x && x < this.x + this.width) {
          if (y >= this.y && y < this.y + this.height) {
            return true;
          }
        }
        return false;
      }
      /**
       * Checks whether the x and y coordinates given are contained within this rectangle including the stroke.
       * @param x - The X coordinate of the point to test
       * @param y - The Y coordinate of the point to test
       * @param strokeWidth - The width of the line to check
       * @returns Whether the x/y coordinates are within this rectangle
       */
      strokeContains(x, y, strokeWidth) {
        const { width, height } = this;
        if (width <= 0 || height <= 0)
          return false;
        const _x = this.x;
        const _y = this.y;
        const outerLeft = _x - strokeWidth / 2;
        const outerRight = _x + width + strokeWidth / 2;
        const outerTop = _y - strokeWidth / 2;
        const outerBottom = _y + height + strokeWidth / 2;
        const innerLeft = _x + strokeWidth / 2;
        const innerRight = _x + width - strokeWidth / 2;
        const innerTop = _y + strokeWidth / 2;
        const innerBottom = _y + height - strokeWidth / 2;
        return x >= outerLeft && x <= outerRight && y >= outerTop && y <= outerBottom && !(x > innerLeft && x < innerRight && y > innerTop && y < innerBottom);
      }
      /**
       * Determines whether the `other` Rectangle transformed by `transform` intersects with `this` Rectangle object.
       * Returns true only if the area of the intersection is >0, this means that Rectangles
       * sharing a side are not overlapping. Another side effect is that an arealess rectangle
       * (width or height equal to zero) can't intersect any other rectangle.
       * @param {Rectangle} other - The Rectangle to intersect with `this`.
       * @param {Matrix} transform - The transformation matrix of `other`.
       * @returns {boolean} A value of `true` if the transformed `other` Rectangle intersects with `this`; otherwise `false`.
       */
      intersects(other, transform) {
        if (!transform) {
          const x02 = this.x < other.x ? other.x : this.x;
          const x12 = this.right > other.right ? other.right : this.right;
          if (x12 <= x02) {
            return false;
          }
          const y02 = this.y < other.y ? other.y : this.y;
          const y12 = this.bottom > other.bottom ? other.bottom : this.bottom;
          return y12 > y02;
        }
        const x0 = this.left;
        const x1 = this.right;
        const y0 = this.top;
        const y1 = this.bottom;
        if (x1 <= x0 || y1 <= y0) {
          return false;
        }
        const lt = tempPoints[0].set(other.left, other.top);
        const lb = tempPoints[1].set(other.left, other.bottom);
        const rt = tempPoints[2].set(other.right, other.top);
        const rb = tempPoints[3].set(other.right, other.bottom);
        if (rt.x <= lt.x || lb.y <= lt.y) {
          return false;
        }
        const s = Math.sign(transform.a * transform.d - transform.b * transform.c);
        if (s === 0) {
          return false;
        }
        transform.apply(lt, lt);
        transform.apply(lb, lb);
        transform.apply(rt, rt);
        transform.apply(rb, rb);
        if (Math.max(lt.x, lb.x, rt.x, rb.x) <= x0 || Math.min(lt.x, lb.x, rt.x, rb.x) >= x1 || Math.max(lt.y, lb.y, rt.y, rb.y) <= y0 || Math.min(lt.y, lb.y, rt.y, rb.y) >= y1) {
          return false;
        }
        const nx = s * (lb.y - lt.y);
        const ny = s * (lt.x - lb.x);
        const n00 = nx * x0 + ny * y0;
        const n10 = nx * x1 + ny * y0;
        const n01 = nx * x0 + ny * y1;
        const n11 = nx * x1 + ny * y1;
        if (Math.max(n00, n10, n01, n11) <= nx * lt.x + ny * lt.y || Math.min(n00, n10, n01, n11) >= nx * rb.x + ny * rb.y) {
          return false;
        }
        const mx = s * (lt.y - rt.y);
        const my = s * (rt.x - lt.x);
        const m00 = mx * x0 + my * y0;
        const m10 = mx * x1 + my * y0;
        const m01 = mx * x0 + my * y1;
        const m11 = mx * x1 + my * y1;
        if (Math.max(m00, m10, m01, m11) <= mx * lt.x + my * lt.y || Math.min(m00, m10, m01, m11) >= mx * rb.x + my * rb.y) {
          return false;
        }
        return true;
      }
      /**
       * Pads the rectangle making it grow in all directions.
       * If paddingY is omitted, both paddingX and paddingY will be set to paddingX.
       * @param paddingX - The horizontal padding amount.
       * @param paddingY - The vertical padding amount.
       * @returns Returns itself.
       */
      pad(paddingX = 0, paddingY = paddingX) {
        this.x -= paddingX;
        this.y -= paddingY;
        this.width += paddingX * 2;
        this.height += paddingY * 2;
        return this;
      }
      /**
       * Fits this rectangle around the passed one.
       * @param rectangle - The rectangle to fit.
       * @returns Returns itself.
       */
      fit(rectangle) {
        const x1 = Math.max(this.x, rectangle.x);
        const x2 = Math.min(this.x + this.width, rectangle.x + rectangle.width);
        const y1 = Math.max(this.y, rectangle.y);
        const y2 = Math.min(this.y + this.height, rectangle.y + rectangle.height);
        this.x = x1;
        this.width = Math.max(x2 - x1, 0);
        this.y = y1;
        this.height = Math.max(y2 - y1, 0);
        return this;
      }
      /**
       * Enlarges rectangle that way its corners lie on grid
       * @param resolution - resolution
       * @param eps - precision
       * @returns Returns itself.
       */
      ceil(resolution = 1, eps = 1e-3) {
        const x2 = Math.ceil((this.x + this.width - eps) * resolution) / resolution;
        const y2 = Math.ceil((this.y + this.height - eps) * resolution) / resolution;
        this.x = Math.floor((this.x + eps) * resolution) / resolution;
        this.y = Math.floor((this.y + eps) * resolution) / resolution;
        this.width = x2 - this.x;
        this.height = y2 - this.y;
        return this;
      }
      /**
       * Enlarges this rectangle to include the passed rectangle.
       * @param rectangle - The rectangle to include.
       * @returns Returns itself.
       */
      enlarge(rectangle) {
        const x1 = Math.min(this.x, rectangle.x);
        const x2 = Math.max(this.x + this.width, rectangle.x + rectangle.width);
        const y1 = Math.min(this.y, rectangle.y);
        const y2 = Math.max(this.y + this.height, rectangle.y + rectangle.height);
        this.x = x1;
        this.width = x2 - x1;
        this.y = y1;
        this.height = y2 - y1;
        return this;
      }
      /**
       * Returns the framing rectangle of the rectangle as a Rectangle object
       * @param out - optional rectangle to store the result
       * @returns The framing rectangle
       */
      getBounds(out) {
        out || (out = new Rectangle());
        out.copyFrom(this);
        return out;
      }
      toString() {
        return `[pixi.js/math:Rectangle x=${this.x} y=${this.y} width=${this.width} height=${this.height}]`;
      }
    }

    "use strict";
    const uidCache = {
      default: -1
    };
    function uid$1(name = "default") {
      if (uidCache[name] === void 0) {
        uidCache[name] = -1;
      }
      return ++uidCache[name];
    }
    function resetUids() {
      for (const key in uidCache) {
        delete uidCache[key];
      }
    }

    "use strict";
    const warnings = {};
    const v8_0_0 = "8.0.0";
    const v8_3_4 = "8.3.4";
    function deprecation(version, message, ignoreDepth = 3) {
      if (warnings[message]) {
        return;
      }
      let stack = new Error().stack;
      if (typeof stack === "undefined") {
        console.warn("PixiJS Deprecation Warning: ", `${message}
Deprecated since v${version}`);
      } else {
        stack = stack.split("\n").splice(ignoreDepth).join("\n");
        if (console.groupCollapsed) {
          console.groupCollapsed(
            "%cPixiJS Deprecation Warning: %c%s",
            "color:#614108;background:#fffbe6",
            "font-weight:normal;color:#614108;background:#fffbe6",
            `${message}
Deprecated since v${version}`
          );
          console.warn(stack);
          console.groupEnd();
        } else {
          console.warn("PixiJS Deprecation Warning: ", `${message}
Deprecated since v${version}`);
          console.warn(stack);
        }
      }
      warnings[message] = true;
    }

    "use strict";
    const NOOP = () => {
    };

    "use strict";
    function nextPow2(v) {
      v += v === 0 ? 1 : 0;
      --v;
      v |= v >>> 1;
      v |= v >>> 2;
      v |= v >>> 4;
      v |= v >>> 8;
      v |= v >>> 16;
      return v + 1;
    }
    function isPow2(v) {
      return !(v & v - 1) && !!v;
    }
    function log2(v) {
      let r = (v > 65535 ? 1 : 0) << 4;
      v >>>= r;
      let shift = (v > 255 ? 1 : 0) << 3;
      v >>>= shift;
      r |= shift;
      shift = (v > 15 ? 1 : 0) << 2;
      v >>>= shift;
      r |= shift;
      shift = (v > 3 ? 1 : 0) << 1;
      v >>>= shift;
      r |= shift;
      return r | v >> 1;
    }

    "use strict";
    function definedProps(obj) {
      const result = {};
      for (const key in obj) {
        if (obj[key] !== void 0) {
          result[key] = obj[key];
        }
      }
      return result;
    }

    "use strict";
    var __defProp$16 = Object.defineProperty;
    var __getOwnPropSymbols$16 = Object.getOwnPropertySymbols;
    var __hasOwnProp$16 = Object.prototype.hasOwnProperty;
    var __propIsEnum$16 = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$16 = (obj, key, value) => key in obj ? __defProp$16(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$16 = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$16.call(b, prop))
          __defNormalProp$16(a, prop, b[prop]);
      if (__getOwnPropSymbols$16)
        for (var prop of __getOwnPropSymbols$16(b)) {
          if (__propIsEnum$16.call(b, prop))
            __defNormalProp$16(a, prop, b[prop]);
        }
      return a;
    };
    const idHash$1 = /* @__PURE__ */ Object.create(null);
    function createResourceIdFromString(value) {
      const id = idHash$1[value];
      if (id === void 0) {
        idHash$1[value] = uid$1("resource");
      }
      return id;
    }
    const _TextureStyle = class _TextureStyle extends EventEmitter {
      /**
       * @param options - options for the style
       */
      constructor(options = {}) {
        var _a, _b, _c, _d, _e, _f, _g;
        super();
        this._resourceType = "textureSampler";
        this._touched = 0;
        /**
         * Specifies the maximum anisotropy value clamp used by the sampler.
         * Note: Most implementations support {@link GPUSamplerDescriptor#maxAnisotropy} values in range
         * between 1 and 16, inclusive. The used value of {@link GPUSamplerDescriptor#maxAnisotropy} will
         * be clamped to the maximum value that the platform supports.
         * @internal
         * @ignore
         */
        this._maxAnisotropy = 1;
        /**
         * Has the style been destroyed?
         * @readonly
         */
        this.destroyed = false;
        options = __spreadValues$16(__spreadValues$16({}, _TextureStyle.defaultOptions), options);
        this.addressMode = options.addressMode;
        this.addressModeU = (_a = options.addressModeU) != null ? _a : this.addressModeU;
        this.addressModeV = (_b = options.addressModeV) != null ? _b : this.addressModeV;
        this.addressModeW = (_c = options.addressModeW) != null ? _c : this.addressModeW;
        this.scaleMode = options.scaleMode;
        this.magFilter = (_d = options.magFilter) != null ? _d : this.magFilter;
        this.minFilter = (_e = options.minFilter) != null ? _e : this.minFilter;
        this.mipmapFilter = (_f = options.mipmapFilter) != null ? _f : this.mipmapFilter;
        this.lodMinClamp = options.lodMinClamp;
        this.lodMaxClamp = options.lodMaxClamp;
        this.compare = options.compare;
        this.maxAnisotropy = (_g = options.maxAnisotropy) != null ? _g : 1;
      }
      set addressMode(value) {
        this.addressModeU = value;
        this.addressModeV = value;
        this.addressModeW = value;
      }
      /** setting this will set wrapModeU,wrapModeV and wrapModeW all at once! */
      get addressMode() {
        return this.addressModeU;
      }
      set wrapMode(value) {
        deprecation(v8_0_0, "TextureStyle.wrapMode is now TextureStyle.addressMode");
        this.addressMode = value;
      }
      get wrapMode() {
        return this.addressMode;
      }
      set scaleMode(value) {
        this.magFilter = value;
        this.minFilter = value;
        this.mipmapFilter = value;
      }
      /** setting this will set magFilter,minFilter and mipmapFilter all at once!  */
      get scaleMode() {
        return this.magFilter;
      }
      /** Specifies the maximum anisotropy value clamp used by the sampler. */
      set maxAnisotropy(value) {
        this._maxAnisotropy = Math.min(value, 16);
        if (this._maxAnisotropy > 1) {
          this.scaleMode = "linear";
        }
      }
      get maxAnisotropy() {
        return this._maxAnisotropy;
      }
      // TODO - move this to WebGL?
      get _resourceId() {
        return this._sharedResourceId || this._generateResourceId();
      }
      update() {
        this.emit("change", this);
        this._sharedResourceId = null;
      }
      _generateResourceId() {
        const bigKey = `${this.addressModeU}-${this.addressModeV}-${this.addressModeW}-${this.magFilter}-${this.minFilter}-${this.mipmapFilter}-${this.lodMinClamp}-${this.lodMaxClamp}-${this.compare}-${this._maxAnisotropy}`;
        this._sharedResourceId = createResourceIdFromString(bigKey);
        return this._resourceId;
      }
      /** Destroys the style */
      destroy() {
        this.destroyed = true;
        this.emit("destroy", this);
        this.emit("change", this);
        this.removeAllListeners();
      }
    };
    /** default options for the style */
    _TextureStyle.defaultOptions = {
      addressMode: "clamp-to-edge",
      scaleMode: "linear"
    };
    let TextureStyle = _TextureStyle;

    "use strict";
    var __defProp$15 = Object.defineProperty;
    var __getOwnPropSymbols$15 = Object.getOwnPropertySymbols;
    var __hasOwnProp$15 = Object.prototype.hasOwnProperty;
    var __propIsEnum$15 = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$15 = (obj, key, value) => key in obj ? __defProp$15(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$15 = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$15.call(b, prop))
          __defNormalProp$15(a, prop, b[prop]);
      if (__getOwnPropSymbols$15)
        for (var prop of __getOwnPropSymbols$15(b)) {
          if (__propIsEnum$15.call(b, prop))
            __defNormalProp$15(a, prop, b[prop]);
        }
      return a;
    };
    const _TextureSource = class _TextureSource extends EventEmitter {
      /**
       * @param options - options for creating a new TextureSource
       */
      constructor(options = {}) {
        var _a, _b, _c;
        super();
        this.options = options;
        /** unique id for this Texture source */
        this.uid = uid$1("textureSource");
        /**
         * The resource type used by this TextureSource. This is used by the bind groups to determine
         * how to handle this resource.
         * @ignore
         * @internal
         */
        this._resourceType = "textureSource";
        /**
         * i unique resource id, used by the bind group systems.
         * This can change if the texture is resized or its resource changes
         */
        this._resourceId = uid$1("resource");
        /**
         * this is how the backends know how to upload this texture to the GPU
         * It changes depending on the resource type. Classes that extend TextureSource
         * should override this property.
         * @ignore
         * @internal
         */
        this.uploadMethodId = "unknown";
        // dimensions
        this._resolution = 1;
        /** the pixel width of this texture source. This is the REAL pure number, not accounting resolution */
        this.pixelWidth = 1;
        /** the pixel height of this texture source. This is the REAL pure number, not accounting resolution */
        this.pixelHeight = 1;
        /**
         * the width of this texture source, accounting for resolution
         * eg pixelWidth 200, resolution 2, then width will be 100
         */
        this.width = 1;
        /**
         * the height of this texture source, accounting for resolution
         * eg pixelHeight 200, resolution 2, then height will be 100
         */
        this.height = 1;
        /**
         * The number of samples of a multisample texture. This is always 1 for non-multisample textures.
         * To enable multisample for a texture, set antialias to true
         * @internal
         * @ignore
         */
        this.sampleCount = 1;
        /** The number of mip levels to generate for this texture. this is  overridden if autoGenerateMipmaps is true */
        this.mipLevelCount = 1;
        /**
         * Should we auto generate mipmaps for this texture? This will automatically generate mipmaps
         * for this texture when uploading to the GPU. Mipmapped textures take up more memory, but
         * can look better when scaled down.
         *
         * For performance reasons, it is recommended to NOT use this with RenderTextures, as they are often updated every frame.
         * If you do, make sure to call `updateMipmaps` after you update the texture.
         */
        this.autoGenerateMipmaps = false;
        /** the format that the texture data has */
        this.format = "rgba8unorm";
        /** how many dimensions does this texture have? currently v8 only supports 2d */
        this.dimension = "2d";
        /**
         * Only really affects RenderTextures.
         * Should we use antialiasing for this texture. It will look better, but may impact performance as a
         * Blit operation will be required to resolve the texture.
         */
        this.antialias = false;
        /**
         * Used by automatic texture Garbage Collection, stores last GC tick when it was bound
         * @protected
         */
        this._touched = 0;
        /**
         * Used by the batcher to build texture batches. faster to have the variable here!
         * @protected
         */
        this._batchTick = -1;
        /**
         * A temporary batch location for the texture batching. Here for performance reasons only!
         * @protected
         */
        this._textureBindLocation = -1;
        options = __spreadValues$15(__spreadValues$15({}, _TextureSource.defaultOptions), options);
        this.label = (_a = options.label) != null ? _a : "";
        this.resource = options.resource;
        this.autoGarbageCollect = options.autoGarbageCollect;
        this._resolution = options.resolution;
        if (options.width) {
          this.pixelWidth = options.width * this._resolution;
        } else {
          this.pixelWidth = this.resource ? (_b = this.resourceWidth) != null ? _b : 1 : 1;
        }
        if (options.height) {
          this.pixelHeight = options.height * this._resolution;
        } else {
          this.pixelHeight = this.resource ? (_c = this.resourceHeight) != null ? _c : 1 : 1;
        }
        this.width = this.pixelWidth / this._resolution;
        this.height = this.pixelHeight / this._resolution;
        this.format = options.format;
        this.dimension = options.dimensions;
        this.mipLevelCount = options.mipLevelCount;
        this.autoGenerateMipmaps = options.autoGenerateMipmaps;
        this.sampleCount = options.sampleCount;
        this.antialias = options.antialias;
        this.alphaMode = options.alphaMode;
        this.style = new TextureStyle(definedProps(options));
        this.destroyed = false;
        this._refreshPOT();
      }
      /** returns itself */
      get source() {
        return this;
      }
      /** the style of the texture */
      get style() {
        return this._style;
      }
      set style(value) {
        var _a, _b;
        if (this.style === value)
          return;
        (_a = this._style) == null ? void 0 : _a.off("change", this._onStyleChange, this);
        this._style = value;
        (_b = this._style) == null ? void 0 : _b.on("change", this._onStyleChange, this);
        this._onStyleChange();
      }
      /** setting this will set wrapModeU,wrapModeV and wrapModeW all at once! */
      get addressMode() {
        return this._style.addressMode;
      }
      set addressMode(value) {
        this._style.addressMode = value;
      }
      /** setting this will set wrapModeU,wrapModeV and wrapModeW all at once! */
      get repeatMode() {
        return this._style.addressMode;
      }
      set repeatMode(value) {
        this._style.addressMode = value;
      }
      /** Specifies the sampling behavior when the sample footprint is smaller than or equal to one texel. */
      get magFilter() {
        return this._style.magFilter;
      }
      set magFilter(value) {
        this._style.magFilter = value;
      }
      /** Specifies the sampling behavior when the sample footprint is larger than one texel. */
      get minFilter() {
        return this._style.minFilter;
      }
      set minFilter(value) {
        this._style.minFilter = value;
      }
      /** Specifies behavior for sampling between mipmap levels. */
      get mipmapFilter() {
        return this._style.mipmapFilter;
      }
      set mipmapFilter(value) {
        this._style.mipmapFilter = value;
      }
      /** Specifies the minimum and maximum levels of detail, respectively, used internally when sampling a texture. */
      get lodMinClamp() {
        return this._style.lodMinClamp;
      }
      set lodMinClamp(value) {
        this._style.lodMinClamp = value;
      }
      /** Specifies the minimum and maximum levels of detail, respectively, used internally when sampling a texture. */
      get lodMaxClamp() {
        return this._style.lodMaxClamp;
      }
      set lodMaxClamp(value) {
        this._style.lodMaxClamp = value;
      }
      _onStyleChange() {
        this.emit("styleChange", this);
      }
      /** call this if you have modified the texture outside of the constructor */
      update() {
        if (this.resource) {
          const resolution = this._resolution;
          const didResize = this.resize(this.resourceWidth / resolution, this.resourceHeight / resolution);
          if (didResize)
            return;
        }
        this.emit("update", this);
      }
      /** Destroys this texture source */
      destroy() {
        this.destroyed = true;
        this.emit("destroy", this);
        this.emit("change", this);
        if (this._style) {
          this._style.destroy();
          this._style = null;
        }
        this.uploadMethodId = null;
        this.resource = null;
        this.removeAllListeners();
      }
      /**
       * This will unload the Texture source from the GPU. This will free up the GPU memory
       * As soon as it is required fore rendering, it will be re-uploaded.
       */
      unload() {
        this._resourceId = uid$1("resource");
        this.emit("change", this);
        this.emit("unload", this);
      }
      /** the width of the resource. This is the REAL pure number, not accounting resolution   */
      get resourceWidth() {
        const { resource } = this;
        return resource.naturalWidth || resource.videoWidth || resource.displayWidth || resource.width;
      }
      /** the height of the resource. This is the REAL pure number, not accounting resolution */
      get resourceHeight() {
        const { resource } = this;
        return resource.naturalHeight || resource.videoHeight || resource.displayHeight || resource.height;
      }
      /**
       * the resolution of the texture. Changing this number, will not change the number of pixels in the actual texture
       * but will the size of the texture when rendered.
       *
       * changing the resolution of this texture to 2 for example will make it appear twice as small when rendered (as pixel
       * density will have increased)
       */
      get resolution() {
        return this._resolution;
      }
      set resolution(resolution) {
        if (this._resolution === resolution)
          return;
        this._resolution = resolution;
        this.width = this.pixelWidth / resolution;
        this.height = this.pixelHeight / resolution;
      }
      /**
       * Resize the texture, this is handy if you want to use the texture as a render texture
       * @param width - the new width of the texture
       * @param height - the new height of the texture
       * @param resolution - the new resolution of the texture
       * @returns - if the texture was resized
       */
      resize(width, height, resolution) {
        resolution || (resolution = this._resolution);
        width || (width = this.width);
        height || (height = this.height);
        const newPixelWidth = Math.round(width * resolution);
        const newPixelHeight = Math.round(height * resolution);
        this.width = newPixelWidth / resolution;
        this.height = newPixelHeight / resolution;
        this._resolution = resolution;
        if (this.pixelWidth === newPixelWidth && this.pixelHeight === newPixelHeight) {
          return false;
        }
        this._refreshPOT();
        this.pixelWidth = newPixelWidth;
        this.pixelHeight = newPixelHeight;
        this.emit("resize", this);
        this._resourceId = uid$1("resource");
        this.emit("change", this);
        return true;
      }
      /**
       * Lets the renderer know that this texture has been updated and its mipmaps should be re-generated.
       * This is only important for RenderTexture instances, as standard Texture instances will have their
       * mipmaps generated on upload. You should call this method after you make any change to the texture
       *
       * The reason for this is is can be quite expensive to update mipmaps for a texture. So by default,
       * We want you, the developer to specify when this action should happen.
       *
       * Generally you don't want to have mipmaps generated on Render targets that are changed every frame,
       */
      updateMipmaps() {
        if (this.autoGenerateMipmaps && this.mipLevelCount > 1) {
          this.emit("updateMipmaps", this);
        }
      }
      set wrapMode(value) {
        this._style.wrapMode = value;
      }
      get wrapMode() {
        return this._style.wrapMode;
      }
      set scaleMode(value) {
        this._style.scaleMode = value;
      }
      /** setting this will set magFilter,minFilter and mipmapFilter all at once!  */
      get scaleMode() {
        return this._style.scaleMode;
      }
      /**
       * Refresh check for isPowerOfTwo texture based on size
       * @private
       */
      _refreshPOT() {
        this.isPowerOfTwo = isPow2(this.pixelWidth) && isPow2(this.pixelHeight);
      }
      static test(_resource) {
        throw new Error("Unimplemented");
      }
    };
    /** The default options used when creating a new TextureSource. override these to add your own defaults */
    _TextureSource.defaultOptions = {
      resolution: 1,
      format: "bgra8unorm",
      alphaMode: "premultiply-alpha-on-upload",
      dimensions: "2d",
      mipLevelCount: 1,
      autoGenerateMipmaps: false,
      sampleCount: 1,
      antialias: false,
      autoGarbageCollect: false
    };
    let TextureSource = _TextureSource;

    "use strict";
    var __defProp$14 = Object.defineProperty;
    var __defProps$q = Object.defineProperties;
    var __getOwnPropDescs$q = Object.getOwnPropertyDescriptors;
    var __getOwnPropSymbols$14 = Object.getOwnPropertySymbols;
    var __hasOwnProp$14 = Object.prototype.hasOwnProperty;
    var __propIsEnum$14 = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$14 = (obj, key, value) => key in obj ? __defProp$14(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$14 = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$14.call(b, prop))
          __defNormalProp$14(a, prop, b[prop]);
      if (__getOwnPropSymbols$14)
        for (var prop of __getOwnPropSymbols$14(b)) {
          if (__propIsEnum$14.call(b, prop))
            __defNormalProp$14(a, prop, b[prop]);
        }
      return a;
    };
    var __spreadProps$q = (a, b) => __defProps$q(a, __getOwnPropDescs$q(b));
    class BufferImageSource extends TextureSource {
      constructor(options) {
        const buffer = options.resource || new Float32Array(options.width * options.height * 4);
        let format = options.format;
        if (!format) {
          if (buffer instanceof Float32Array) {
            format = "rgba32float";
          } else if (buffer instanceof Int32Array) {
            format = "rgba32uint";
          } else if (buffer instanceof Uint32Array) {
            format = "rgba32uint";
          } else if (buffer instanceof Int16Array) {
            format = "rgba16uint";
          } else if (buffer instanceof Uint16Array) {
            format = "rgba16uint";
          } else if (buffer instanceof Int8Array) {
            format = "bgra8unorm";
          } else {
            format = "bgra8unorm";
          }
        }
        super(__spreadProps$q(__spreadValues$14({}, options), {
          resource: buffer,
          format
        }));
        this.uploadMethodId = "buffer";
      }
      static test(resource) {
        return resource instanceof Int8Array || resource instanceof Uint8Array || resource instanceof Uint8ClampedArray || resource instanceof Int16Array || resource instanceof Uint16Array || resource instanceof Int32Array || resource instanceof Uint32Array || resource instanceof Float32Array;
      }
    }
    BufferImageSource.extension = ExtensionType.TextureSource;

    "use strict";
    const tempMat = new Matrix();
    class TextureMatrix {
      /**
       * @param texture - observed texture
       * @param clampMargin - Changes frame clamping, 0.5 by default. Use -0.5 for extra border.
       */
      constructor(texture, clampMargin) {
        this.mapCoord = new Matrix();
        this.uClampFrame = new Float32Array(4);
        this.uClampOffset = new Float32Array(2);
        this._textureID = -1;
        this._updateID = 0;
        this.clampOffset = 0;
        if (typeof clampMargin === "undefined") {
          this.clampMargin = texture.width < 10 ? 0 : 0.5;
        } else {
          this.clampMargin = clampMargin;
        }
        this.isSimple = false;
        this.texture = texture;
      }
      /** Texture property. */
      get texture() {
        return this._texture;
      }
      set texture(value) {
        var _a;
        if (this.texture === value)
          return;
        (_a = this._texture) == null ? void 0 : _a.removeListener("update", this.update, this);
        this._texture = value;
        this._texture.addListener("update", this.update, this);
        this.update();
      }
      /**
       * Multiplies uvs array to transform
       * @param uvs - mesh uvs
       * @param [out=uvs] - output
       * @returns - output
       */
      multiplyUvs(uvs, out) {
        if (out === void 0) {
          out = uvs;
        }
        const mat = this.mapCoord;
        for (let i = 0; i < uvs.length; i += 2) {
          const x = uvs[i];
          const y = uvs[i + 1];
          out[i] = x * mat.a + y * mat.c + mat.tx;
          out[i + 1] = x * mat.b + y * mat.d + mat.ty;
        }
        return out;
      }
      /**
       * Updates matrices if texture was changed
       * @returns - whether or not it was updated
       */
      update() {
        const tex = this._texture;
        this._updateID++;
        const uvs = tex.uvs;
        this.mapCoord.set(uvs.x1 - uvs.x0, uvs.y1 - uvs.y0, uvs.x3 - uvs.x0, uvs.y3 - uvs.y0, uvs.x0, uvs.y0);
        const orig = tex.orig;
        const trim = tex.trim;
        if (trim) {
          tempMat.set(
            orig.width / trim.width,
            0,
            0,
            orig.height / trim.height,
            -trim.x / trim.width,
            -trim.y / trim.height
          );
          this.mapCoord.append(tempMat);
        }
        const texBase = tex.source;
        const frame = this.uClampFrame;
        const margin = this.clampMargin / texBase._resolution;
        const offset = this.clampOffset / texBase._resolution;
        frame[0] = (tex.frame.x + margin + offset) / texBase.width;
        frame[1] = (tex.frame.y + margin + offset) / texBase.height;
        frame[2] = (tex.frame.x + tex.frame.width - margin + offset) / texBase.width;
        frame[3] = (tex.frame.y + tex.frame.height - margin + offset) / texBase.height;
        this.uClampOffset[0] = this.clampOffset / texBase.pixelWidth;
        this.uClampOffset[1] = this.clampOffset / texBase.pixelHeight;
        this.isSimple = tex.frame.width === texBase.width && tex.frame.height === texBase.height && tex.rotate === 0;
        return true;
      }
    }

    "use strict";
    class Texture extends EventEmitter {
      /**
       * @param {rendering.TextureOptions} options - Options for the texture
       */
      constructor({
        source,
        label,
        frame,
        orig,
        trim,
        defaultAnchor,
        defaultBorders,
        rotate,
        dynamic
      } = {}) {
        var _a;
        super();
        /** unique id for this texture */
        this.uid = uid$1("texture");
        /** A uvs object based on the given frame and the texture source */
        this.uvs = { x0: 0, y0: 0, x1: 0, y1: 0, x2: 0, y2: 0, x3: 0, y3: 0 };
        /**
         * This is the area of the BaseTexture image to actually copy to the Canvas / WebGL when rendering,
         * irrespective of the actual frame size or placement (which can be influenced by trimmed texture atlases)
         */
        this.frame = new Rectangle();
        /**
         * Does this Texture have any frame data assigned to it?
         *
         * This mode is enabled automatically if no frame was passed inside constructor.
         *
         * In this mode texture is subscribed to baseTexture events, and fires `update` on any change.
         *
         * Beware, after loading or resize of baseTexture event can fired two times!
         * If you want more control, subscribe on baseTexture itself.
         * @example
         * texture.on('update', () => {});
         */
        this.noFrame = false;
        /**
         * Set to true if you plan on modifying the uvs of this texture.
         * When this is the case, sprites and other objects using the texture will
         * make sure to listen for changes to the uvs and update their vertices accordingly.
         */
        this.dynamic = false;
        /** is it a texture? yes! used for type checking */
        this.isTexture = true;
        this.label = label;
        this.source = (_a = source == null ? void 0 : source.source) != null ? _a : new TextureSource();
        this.noFrame = !frame;
        if (frame) {
          this.frame.copyFrom(frame);
        } else {
          const { width, height } = this._source;
          this.frame.width = width;
          this.frame.height = height;
        }
        this.orig = orig || this.frame;
        this.trim = trim;
        this.rotate = rotate != null ? rotate : 0;
        this.defaultAnchor = defaultAnchor;
        this.defaultBorders = defaultBorders;
        this.destroyed = false;
        this.dynamic = dynamic || false;
        this.updateUvs();
      }
      set source(value) {
        if (this._source) {
          this._source.off("resize", this.update, this);
        }
        this._source = value;
        value.on("resize", this.update, this);
        this.emit("update", this);
      }
      /** the underlying source of the texture (equivalent of baseTexture in v7) */
      get source() {
        return this._source;
      }
      /** returns a TextureMatrix instance for this texture. By default, that object is not created because its heavy. */
      get textureMatrix() {
        if (!this._textureMatrix) {
          this._textureMatrix = new TextureMatrix(this);
        }
        return this._textureMatrix;
      }
      /** The width of the Texture in pixels. */
      get width() {
        return this.orig.width;
      }
      /** The height of the Texture in pixels. */
      get height() {
        return this.orig.height;
      }
      /** Call this function when you have modified the frame of this texture. */
      updateUvs() {
        const { uvs, frame } = this;
        const { width, height } = this._source;
        const nX = frame.x / width;
        const nY = frame.y / height;
        const nW = frame.width / width;
        const nH = frame.height / height;
        let rotate = this.rotate;
        if (rotate) {
          const w2 = nW / 2;
          const h2 = nH / 2;
          const cX = nX + w2;
          const cY = nY + h2;
          rotate = groupD8.add(rotate, groupD8.NW);
          uvs.x0 = cX + w2 * groupD8.uX(rotate);
          uvs.y0 = cY + h2 * groupD8.uY(rotate);
          rotate = groupD8.add(rotate, 2);
          uvs.x1 = cX + w2 * groupD8.uX(rotate);
          uvs.y1 = cY + h2 * groupD8.uY(rotate);
          rotate = groupD8.add(rotate, 2);
          uvs.x2 = cX + w2 * groupD8.uX(rotate);
          uvs.y2 = cY + h2 * groupD8.uY(rotate);
          rotate = groupD8.add(rotate, 2);
          uvs.x3 = cX + w2 * groupD8.uX(rotate);
          uvs.y3 = cY + h2 * groupD8.uY(rotate);
        } else {
          uvs.x0 = nX;
          uvs.y0 = nY;
          uvs.x1 = nX + nW;
          uvs.y1 = nY;
          uvs.x2 = nX + nW;
          uvs.y2 = nY + nH;
          uvs.x3 = nX;
          uvs.y3 = nY + nH;
        }
      }
      /**
       * Destroys this texture
       * @param destroySource - Destroy the source when the texture is destroyed.
       */
      destroy(destroySource = false) {
        if (this._source) {
          if (destroySource) {
            this._source.destroy();
            this._source = null;
          }
        }
        this._textureMatrix = null;
        this.destroyed = true;
        this.emit("destroy", this);
        this.removeAllListeners();
      }
      /**
       * Call this if you have modified the `texture outside` of the constructor.
       *
       * If you have modified this texture's source, you must separately call `texture.source.update()` to see those changes.
       */
      update() {
        if (this.noFrame) {
          this.frame.width = this._source.width;
          this.frame.height = this._source.height;
        }
        this.updateUvs();
        this.emit("update", this);
      }
      /** @deprecated since 8.0.0 */
      get baseTexture() {
        deprecation(v8_0_0, "Texture.baseTexture is now Texture.source");
        return this._source;
      }
    }
    Texture.EMPTY = new Texture({
      label: "EMPTY",
      source: new TextureSource({
        label: "EMPTY"
      })
    });
    Texture.EMPTY.destroy = NOOP;
    Texture.WHITE = new Texture({
      source: new BufferImageSource({
        resource: new Uint8Array([255, 255, 255, 255]),
        width: 1,
        height: 1,
        alphaMode: "premultiply-alpha-on-upload",
        label: "WHITE"
      }),
      label: "WHITE"
    });
    Texture.WHITE.destroy = NOOP;

    "use strict";
    const _Spritesheet = class _Spritesheet {
      /**
       * @param texture - Reference to the source BaseTexture object.
       * @param {object} data - Spritesheet image data.
       */
      constructor(texture, data) {
        /** For multi-packed spritesheets, this contains a reference to all the other spritesheets it depends on. */
        this.linkedSheets = [];
        this._texture = texture instanceof Texture ? texture : null;
        this.textureSource = texture.source;
        this.textures = {};
        this.animations = {};
        this.data = data;
        const metaResolution = parseFloat(data.meta.scale);
        if (metaResolution) {
          this.resolution = metaResolution;
          texture.source.resolution = this.resolution;
        } else {
          this.resolution = texture.source._resolution;
        }
        this._frames = this.data.frames;
        this._frameKeys = Object.keys(this._frames);
        this._batchIndex = 0;
        this._callback = null;
      }
      /**
       * Parser spritesheet from loaded data. This is done asynchronously
       * to prevent creating too many Texture within a single process.
       */
      parse() {
        return new Promise((resolve) => {
          this._callback = resolve;
          this._batchIndex = 0;
          if (this._frameKeys.length <= _Spritesheet.BATCH_SIZE) {
            this._processFrames(0);
            this._processAnimations();
            this._parseComplete();
          } else {
            this._nextBatch();
          }
        });
      }
      /**
       * Process a batch of frames
       * @param initialFrameIndex - The index of frame to start.
       */
      _processFrames(initialFrameIndex) {
        let frameIndex = initialFrameIndex;
        const maxFrames = _Spritesheet.BATCH_SIZE;
        while (frameIndex - initialFrameIndex < maxFrames && frameIndex < this._frameKeys.length) {
          const i = this._frameKeys[frameIndex];
          const data = this._frames[i];
          const rect = data.frame;
          if (rect) {
            let frame = null;
            let trim = null;
            const sourceSize = data.trimmed !== false && data.sourceSize ? data.sourceSize : data.frame;
            const orig = new Rectangle(
              0,
              0,
              Math.floor(sourceSize.w) / this.resolution,
              Math.floor(sourceSize.h) / this.resolution
            );
            if (data.rotated) {
              frame = new Rectangle(
                Math.floor(rect.x) / this.resolution,
                Math.floor(rect.y) / this.resolution,
                Math.floor(rect.h) / this.resolution,
                Math.floor(rect.w) / this.resolution
              );
            } else {
              frame = new Rectangle(
                Math.floor(rect.x) / this.resolution,
                Math.floor(rect.y) / this.resolution,
                Math.floor(rect.w) / this.resolution,
                Math.floor(rect.h) / this.resolution
              );
            }
            if (data.trimmed !== false && data.spriteSourceSize) {
              trim = new Rectangle(
                Math.floor(data.spriteSourceSize.x) / this.resolution,
                Math.floor(data.spriteSourceSize.y) / this.resolution,
                Math.floor(rect.w) / this.resolution,
                Math.floor(rect.h) / this.resolution
              );
            }
            this.textures[i] = new Texture({
              source: this.textureSource,
              frame,
              orig,
              trim,
              rotate: data.rotated ? 2 : 0,
              defaultAnchor: data.anchor,
              defaultBorders: data.borders,
              label: i.toString()
            });
          }
          frameIndex++;
        }
      }
      /** Parse animations config. */
      _processAnimations() {
        const animations = this.data.animations || {};
        for (const animName in animations) {
          this.animations[animName] = [];
          for (let i = 0; i < animations[animName].length; i++) {
            const frameName = animations[animName][i];
            this.animations[animName].push(this.textures[frameName]);
          }
        }
      }
      /** The parse has completed. */
      _parseComplete() {
        const callback = this._callback;
        this._callback = null;
        this._batchIndex = 0;
        callback.call(this, this.textures);
      }
      /** Begin the next batch of textures. */
      _nextBatch() {
        this._processFrames(this._batchIndex * _Spritesheet.BATCH_SIZE);
        this._batchIndex++;
        setTimeout(() => {
          if (this._batchIndex * _Spritesheet.BATCH_SIZE < this._frameKeys.length) {
            this._nextBatch();
          } else {
            this._processAnimations();
            this._parseComplete();
          }
        }, 0);
      }
      /**
       * Destroy Spritesheet and don't use after this.
       * @param {boolean} [destroyBase=false] - Whether to destroy the base texture as well
       */
      destroy(destroyBase = false) {
        var _a;
        for (const i in this.textures) {
          this.textures[i].destroy();
        }
        this._frames = null;
        this._frameKeys = null;
        this.data = null;
        this.textures = null;
        if (destroyBase) {
          (_a = this._texture) == null ? void 0 : _a.destroy();
          this.textureSource.destroy();
        }
        this._texture = null;
        this.textureSource = null;
        this.linkedSheets = [];
      }
    };
    /** The maximum number of Textures to build per process. */
    _Spritesheet.BATCH_SIZE = 1e3;
    let Spritesheet = _Spritesheet;

    "use strict";
    const validImages = [
      "jpg",
      "png",
      "jpeg",
      "avif",
      "webp",
      "basis",
      "etc2",
      "bc7",
      "bc6h",
      "bc5",
      "bc4",
      "bc3",
      "bc2",
      "bc1",
      "eac",
      "astc"
    ];
    function getCacheableAssets(keys, asset, ignoreMultiPack) {
      const out = {};
      keys.forEach((key) => {
        out[key] = asset;
      });
      Object.keys(asset.textures).forEach((key) => {
        out[key] = asset.textures[key];
      });
      if (!ignoreMultiPack) {
        const basePath = path.dirname(keys[0]);
        asset.linkedSheets.forEach((item, i) => {
          const out2 = getCacheableAssets([`${basePath}/${asset.data.meta.related_multi_packs[i]}`], item, true);
          Object.assign(out, out2);
        });
      }
      return out;
    }
    const spritesheetAsset = {
      extension: ExtensionType.Asset,
      /** Handle the caching of the related Spritesheet Textures */
      cache: {
        test: (asset) => asset instanceof Spritesheet,
        getCacheableAssets: (keys, asset) => getCacheableAssets(keys, asset, false)
      },
      /** Resolve the resolution of the asset. */
      resolver: {
        extension: {
          type: ExtensionType.ResolveParser,
          name: "resolveSpritesheet"
        },
        test: (value) => {
          const tempURL = value.split("?")[0];
          const split = tempURL.split(".");
          const extension = split.pop();
          const format = split.pop();
          return extension === "json" && validImages.includes(format);
        },
        parse: (value) => {
          var _a, _b;
          const split = value.split(".");
          return {
            resolution: parseFloat((_b = (_a = Resolver.RETINA_PREFIX.exec(value)) == null ? void 0 : _a[1]) != null ? _b : "1"),
            format: split[split.length - 2],
            src: value
          };
        }
      },
      /**
       * Loader plugin that parses sprite sheets!
       * once the JSON has been loaded this checks to see if the JSON is spritesheet data.
       * If it is, we load the spritesheets image and parse the data into Spritesheet
       * All textures in the sprite sheet are then added to the cache
       */
      loader: {
        name: "spritesheetLoader",
        extension: {
          type: ExtensionType.LoadParser,
          priority: LoaderParserPriority.Normal,
          name: "spritesheetLoader"
        },
        async testParse(asset, options) {
          return path.extname(options.src).toLowerCase() === ".json" && !!asset.frames;
        },
        async parse(asset, options, loader) {
          var _a, _b, _c;
          const {
            texture: imageTexture,
            // if user need to use preloaded texture
            imageFilename
            // if user need to use custom filename (not from jsonFile.meta.image)
          } = (_a = options == null ? void 0 : options.data) != null ? _a : {};
          let basePath = path.dirname(options.src);
          if (basePath && basePath.lastIndexOf("/") !== basePath.length - 1) {
            basePath += "/";
          }
          let texture;
          if (imageTexture instanceof Texture) {
            texture = imageTexture;
          } else {
            const imagePath = copySearchParams(basePath + (imageFilename != null ? imageFilename : asset.meta.image), options.src);
            const assets = await loader.load([imagePath]);
            texture = assets[imagePath];
          }
          const spritesheet = new Spritesheet(
            texture.source,
            asset
          );
          await spritesheet.parse();
          const multiPacks = (_b = asset == null ? void 0 : asset.meta) == null ? void 0 : _b.related_multi_packs;
          if (Array.isArray(multiPacks)) {
            const promises = [];
            for (const item of multiPacks) {
              if (typeof item !== "string") {
                continue;
              }
              let itemUrl = basePath + item;
              if ((_c = options.data) == null ? void 0 : _c.ignoreMultiPack) {
                continue;
              }
              itemUrl = copySearchParams(itemUrl, options.src);
              promises.push(loader.load({
                src: itemUrl,
                data: {
                  ignoreMultiPack: true
                }
              }));
            }
            const res = await Promise.all(promises);
            spritesheet.linkedSheets = res;
            res.forEach((item) => {
              item.linkedSheets = [spritesheet].concat(spritesheet.linkedSheets.filter((sp) => sp !== item));
            });
          }
          return spritesheet;
        },
        async unload(spritesheet, _resolvedAsset, loader) {
          await loader.unload(spritesheet.textureSource._sourceOrigin);
          spritesheet.destroy(false);
        }
      }
    };

    "use strict";
    extensions.add(spritesheetAsset);

    "use strict";
    class ObservablePoint {
      /**
       * Creates a new `ObservablePoint`
       * @param observer - Observer to pass to listen for change events.
       * @param {number} [x=0] - position of the point on the x axis
       * @param {number} [y=0] - position of the point on the y axis
       */
      constructor(observer, x, y) {
        this._x = x || 0;
        this._y = y || 0;
        this._observer = observer;
      }
      /**
       * Creates a clone of this point.
       * @param observer - Optional observer to pass to the new observable point.
       * @returns a copy of this observable point
       */
      clone(observer) {
        return new ObservablePoint(observer != null ? observer : this._observer, this._x, this._y);
      }
      /**
       * Sets the point to a new `x` and `y` position.
       * If `y` is omitted, both `x` and `y` will be set to `x`.
       * @param {number} [x=0] - position of the point on the x axis
       * @param {number} [y=x] - position of the point on the y axis
       * @returns The observable point instance itself
       */
      set(x = 0, y = x) {
        if (this._x !== x || this._y !== y) {
          this._x = x;
          this._y = y;
          this._observer._onUpdate(this);
        }
        return this;
      }
      /**
       * Copies x and y from the given point (`p`)
       * @param p - The point to copy from. Can be any of type that is or extends `PointData`
       * @returns The observable point instance itself
       */
      copyFrom(p) {
        if (this._x !== p.x || this._y !== p.y) {
          this._x = p.x;
          this._y = p.y;
          this._observer._onUpdate(this);
        }
        return this;
      }
      /**
       * Copies this point's x and y into that of the given point (`p`)
       * @param p - The point to copy to. Can be any of type that is or extends `PointData`
       * @returns The point (`p`) with values updated
       */
      copyTo(p) {
        p.set(this._x, this._y);
        return p;
      }
      /**
       * Accepts another point (`p`) and returns `true` if the given point is equal to this point
       * @param p - The point to check
       * @returns Returns `true` if both `x` and `y` are equal
       */
      equals(p) {
        return p.x === this._x && p.y === this._y;
      }
      toString() {
        return `[pixi.js/math:ObservablePoint x=${0} y=${0} scope=${this._observer}]`;
      }
      /** Position of the observable point on the x axis. */
      get x() {
        return this._x;
      }
      set x(value) {
        if (this._x !== value) {
          this._x = value;
          this._observer._onUpdate(this);
        }
      }
      /** Position of the observable point on the y axis. */
      get y() {
        return this._y;
      }
      set y(value) {
        if (this._y !== value) {
          this._y = value;
          this._observer._onUpdate(this);
        }
      }
    }

    "use strict";
    function updateQuadBounds(bounds, anchor, texture, padding) {
      const { width, height } = texture.orig;
      const trim = texture.trim;
      if (trim) {
        const sourceWidth = trim.width;
        const sourceHeight = trim.height;
        bounds.minX = trim.x - anchor._x * width - padding;
        bounds.maxX = bounds.minX + sourceWidth;
        bounds.minY = trim.y - anchor._y * height - padding;
        bounds.maxY = bounds.minY + sourceHeight;
      } else {
        bounds.minX = -anchor._x * width - padding;
        bounds.maxX = bounds.minX + width;
        bounds.minY = -anchor._y * height - padding;
        bounds.maxY = bounds.minY + height;
      }
      return;
    }

    "use strict";
    const defaultMatrix = new Matrix();
    class Bounds {
      constructor(minX = Infinity, minY = Infinity, maxX = -Infinity, maxY = -Infinity) {
        /** @default Infinity */
        this.minX = Infinity;
        /** @default Infinity */
        this.minY = Infinity;
        /** @default -Infinity */
        this.maxX = -Infinity;
        /** @default -Infinity */
        this.maxY = -Infinity;
        this.matrix = defaultMatrix;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
      }
      /**
       * Checks if bounds are empty.
       * @returns - True if empty.
       */
      isEmpty() {
        return this.minX > this.maxX || this.minY > this.maxY;
      }
      /** The bounding rectangle of the bounds. */
      get rectangle() {
        if (!this._rectangle) {
          this._rectangle = new Rectangle();
        }
        const rectangle = this._rectangle;
        if (this.minX > this.maxX || this.minY > this.maxY) {
          rectangle.x = 0;
          rectangle.y = 0;
          rectangle.width = 0;
          rectangle.height = 0;
        } else {
          rectangle.copyFromBounds(this);
        }
        return rectangle;
      }
      /** Clears the bounds and resets. */
      clear() {
        this.minX = Infinity;
        this.minY = Infinity;
        this.maxX = -Infinity;
        this.maxY = -Infinity;
        this.matrix = defaultMatrix;
        return this;
      }
      /**
       * Sets the bounds.
       * @param x0 - left X of frame
       * @param y0 - top Y of frame
       * @param x1 - right X of frame
       * @param y1 - bottom Y of frame
       */
      set(x0, y0, x1, y1) {
        this.minX = x0;
        this.minY = y0;
        this.maxX = x1;
        this.maxY = y1;
      }
      /**
       * Adds sprite frame
       * @param x0 - left X of frame
       * @param y0 - top Y of frame
       * @param x1 - right X of frame
       * @param y1 - bottom Y of frame
       * @param matrix
       */
      addFrame(x0, y0, x1, y1, matrix) {
        matrix || (matrix = this.matrix);
        const a = matrix.a;
        const b = matrix.b;
        const c = matrix.c;
        const d = matrix.d;
        const tx = matrix.tx;
        const ty = matrix.ty;
        let minX = this.minX;
        let minY = this.minY;
        let maxX = this.maxX;
        let maxY = this.maxY;
        let x = a * x0 + c * y0 + tx;
        let y = b * x0 + d * y0 + ty;
        if (x < minX)
          minX = x;
        if (y < minY)
          minY = y;
        if (x > maxX)
          maxX = x;
        if (y > maxY)
          maxY = y;
        x = a * x1 + c * y0 + tx;
        y = b * x1 + d * y0 + ty;
        if (x < minX)
          minX = x;
        if (y < minY)
          minY = y;
        if (x > maxX)
          maxX = x;
        if (y > maxY)
          maxY = y;
        x = a * x0 + c * y1 + tx;
        y = b * x0 + d * y1 + ty;
        if (x < minX)
          minX = x;
        if (y < minY)
          minY = y;
        if (x > maxX)
          maxX = x;
        if (y > maxY)
          maxY = y;
        x = a * x1 + c * y1 + tx;
        y = b * x1 + d * y1 + ty;
        if (x < minX)
          minX = x;
        if (y < minY)
          minY = y;
        if (x > maxX)
          maxX = x;
        if (y > maxY)
          maxY = y;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
      }
      /**
       * Adds a rectangle to the bounds.
       * @param rect - The rectangle to be added.
       * @param matrix - The matrix to apply to the bounds.
       */
      addRect(rect, matrix) {
        this.addFrame(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, matrix);
      }
      /**
       * Adds other {@link Bounds}.
       * @param bounds - The Bounds to be added
       * @param matrix
       */
      addBounds(bounds, matrix) {
        this.addFrame(bounds.minX, bounds.minY, bounds.maxX, bounds.maxY, matrix);
      }
      /**
       * Adds other Bounds, masked with Bounds.
       * @param mask - The Bounds to be added.
       */
      addBoundsMask(mask) {
        this.minX = this.minX > mask.minX ? this.minX : mask.minX;
        this.minY = this.minY > mask.minY ? this.minY : mask.minY;
        this.maxX = this.maxX < mask.maxX ? this.maxX : mask.maxX;
        this.maxY = this.maxY < mask.maxY ? this.maxY : mask.maxY;
      }
      /**
       * Adds other Bounds, multiplied with matrix.
       * @param matrix - The matrix to apply to the bounds.
       */
      applyMatrix(matrix) {
        const minX = this.minX;
        const minY = this.minY;
        const maxX = this.maxX;
        const maxY = this.maxY;
        const { a, b, c, d, tx, ty } = matrix;
        let x = a * minX + c * minY + tx;
        let y = b * minX + d * minY + ty;
        this.minX = x;
        this.minY = y;
        this.maxX = x;
        this.maxY = y;
        x = a * maxX + c * minY + tx;
        y = b * maxX + d * minY + ty;
        this.minX = x < this.minX ? x : this.minX;
        this.minY = y < this.minY ? y : this.minY;
        this.maxX = x > this.maxX ? x : this.maxX;
        this.maxY = y > this.maxY ? y : this.maxY;
        x = a * minX + c * maxY + tx;
        y = b * minX + d * maxY + ty;
        this.minX = x < this.minX ? x : this.minX;
        this.minY = y < this.minY ? y : this.minY;
        this.maxX = x > this.maxX ? x : this.maxX;
        this.maxY = y > this.maxY ? y : this.maxY;
        x = a * maxX + c * maxY + tx;
        y = b * maxX + d * maxY + ty;
        this.minX = x < this.minX ? x : this.minX;
        this.minY = y < this.minY ? y : this.minY;
        this.maxX = x > this.maxX ? x : this.maxX;
        this.maxY = y > this.maxY ? y : this.maxY;
      }
      /**
       * Resizes the bounds object to include the given rectangle.
       * @param rect - The rectangle to be included.
       */
      fit(rect) {
        if (this.minX < rect.left)
          this.minX = rect.left;
        if (this.maxX > rect.right)
          this.maxX = rect.right;
        if (this.minY < rect.top)
          this.minY = rect.top;
        if (this.maxY > rect.bottom)
          this.maxY = rect.bottom;
        return this;
      }
      /**
       * Resizes the bounds object to include the given bounds.
       * @param left - The left value of the bounds.
       * @param right - The right value of the bounds.
       * @param top - The top value of the bounds.
       * @param bottom - The bottom value of the bounds.
       */
      fitBounds(left, right, top, bottom) {
        if (this.minX < left)
          this.minX = left;
        if (this.maxX > right)
          this.maxX = right;
        if (this.minY < top)
          this.minY = top;
        if (this.maxY > bottom)
          this.maxY = bottom;
        return this;
      }
      /**
       * Pads bounds object, making it grow in all directions.
       * If paddingY is omitted, both paddingX and paddingY will be set to paddingX.
       * @param paddingX - The horizontal padding amount.
       * @param paddingY - The vertical padding amount.
       */
      pad(paddingX, paddingY = paddingX) {
        this.minX -= paddingX;
        this.maxX += paddingX;
        this.minY -= paddingY;
        this.maxY += paddingY;
        return this;
      }
      /** Ceils the bounds. */
      ceil() {
        this.minX = Math.floor(this.minX);
        this.minY = Math.floor(this.minY);
        this.maxX = Math.ceil(this.maxX);
        this.maxY = Math.ceil(this.maxY);
        return this;
      }
      /** Clones the bounds. */
      clone() {
        return new Bounds(this.minX, this.minY, this.maxX, this.maxY);
      }
      /**
       * Scales the bounds by the given values
       * @param x - The X value to scale by.
       * @param y - The Y value to scale by.
       */
      scale(x, y = x) {
        this.minX *= x;
        this.minY *= y;
        this.maxX *= x;
        this.maxY *= y;
        return this;
      }
      /** the x value of the bounds. */
      get x() {
        return this.minX;
      }
      set x(value) {
        const width = this.maxX - this.minX;
        this.minX = value;
        this.maxX = value + width;
      }
      /** the y value of the bounds. */
      get y() {
        return this.minY;
      }
      set y(value) {
        const height = this.maxY - this.minY;
        this.minY = value;
        this.maxY = value + height;
      }
      /** the width value of the bounds. */
      get width() {
        return this.maxX - this.minX;
      }
      set width(value) {
        this.maxX = this.minX + value;
      }
      /** the height value of the bounds. */
      get height() {
        return this.maxY - this.minY;
      }
      set height(value) {
        this.maxY = this.minY + value;
      }
      /** the left value of the bounds. */
      get left() {
        return this.minX;
      }
      /** the right value of the bounds. */
      get right() {
        return this.maxX;
      }
      /** the top value of the bounds. */
      get top() {
        return this.minY;
      }
      /** the bottom value of the bounds. */
      get bottom() {
        return this.maxY;
      }
      /** Is the bounds positive. */
      get isPositive() {
        return this.maxX - this.minX > 0 && this.maxY - this.minY > 0;
      }
      get isValid() {
        return this.minX + this.minY !== Infinity;
      }
      /**
       * Adds screen vertices from array
       * @param vertexData - calculated vertices
       * @param beginOffset - begin offset
       * @param endOffset - end offset, excluded
       * @param matrix
       */
      addVertexData(vertexData, beginOffset, endOffset, matrix) {
        let minX = this.minX;
        let minY = this.minY;
        let maxX = this.maxX;
        let maxY = this.maxY;
        matrix || (matrix = this.matrix);
        const a = matrix.a;
        const b = matrix.b;
        const c = matrix.c;
        const d = matrix.d;
        const tx = matrix.tx;
        const ty = matrix.ty;
        for (let i = beginOffset; i < endOffset; i += 2) {
          const localX = vertexData[i];
          const localY = vertexData[i + 1];
          const x = a * localX + c * localY + tx;
          const y = b * localX + d * localY + ty;
          minX = x < minX ? x : minX;
          minY = y < minY ? y : minY;
          maxX = x > maxX ? x : maxX;
          maxY = y > maxY ? y : maxY;
        }
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
      }
      /**
       * Checks if the point is contained within the bounds.
       * @param x - x coordinate
       * @param y - y coordinate
       */
      containsPoint(x, y) {
        if (this.minX <= x && this.minY <= y && this.maxX >= x && this.maxY >= y) {
          return true;
        }
        return false;
      }
      toString() {
        return `[pixi.js:Bounds minX=${this.minX} minY=${this.minY} maxX=${this.maxX} maxY=${this.maxY} width=${this.width} height=${this.height}]`;
      }
      /**
       * Copies the bounds from another bounds object.
       * @param bounds - The bounds to copy from.
       * @returns - This bounds object.
       */
      copyFrom(bounds) {
        this.minX = bounds.minX;
        this.minY = bounds.minY;
        this.maxX = bounds.maxX;
        this.maxY = bounds.maxY;
        return this;
      }
    }

    var r={grad:.9,turn:360,rad:360/(2*Math.PI)},t=function(r){return "string"==typeof r?r.length>0:"number"==typeof r},n=function(r,t,n){return void 0===t&&(t=0),void 0===n&&(n=Math.pow(10,t)),Math.round(n*r)/n+0},e=function(r,t,n){return void 0===t&&(t=0),void 0===n&&(n=1),r>n?n:r>t?r:t},u=function(r){return (r=isFinite(r)?r%360:0)>0?r:r+360},a=function(r){return {r:e(r.r,0,255),g:e(r.g,0,255),b:e(r.b,0,255),a:e(r.a)}},o=function(r){return {r:n(r.r),g:n(r.g),b:n(r.b),a:n(r.a,3)}},i=/^#([0-9a-f]{3,8})$/i,s=function(r){var t=r.toString(16);return t.length<2?"0"+t:t},h=function(r){var t=r.r,n=r.g,e=r.b,u=r.a,a=Math.max(t,n,e),o=a-Math.min(t,n,e),i=o?a===t?(n-e)/o:a===n?2+(e-t)/o:4+(t-n)/o:0;return {h:60*(i<0?i+6:i),s:a?o/a*100:0,v:a/255*100,a:u}},b=function(r){var t=r.h,n=r.s,e=r.v,u=r.a;t=t/360*6,n/=100,e/=100;var a=Math.floor(t),o=e*(1-n),i=e*(1-(t-a)*n),s=e*(1-(1-t+a)*n),h=a%6;return {r:255*[e,i,o,o,s,e][h],g:255*[s,e,e,i,o,o][h],b:255*[o,o,s,e,e,i][h],a:u}},g=function(r){return {h:u(r.h),s:e(r.s,0,100),l:e(r.l,0,100),a:e(r.a)}},d=function(r){return {h:n(r.h),s:n(r.s),l:n(r.l),a:n(r.a,3)}},f=function(r){return b((n=(t=r).s,{h:t.h,s:(n*=((e=t.l)<50?e:100-e)/100)>0?2*n/(e+n)*100:0,v:e+n,a:t.a}));var t,n,e;},c=function(r){return {h:(t=h(r)).h,s:(u=(200-(n=t.s))*(e=t.v)/100)>0&&u<200?n*e/100/(u<=100?u:200-u)*100:0,l:u/2,a:t.a};var t,n,e,u;},l=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s*,\s*([+-]?\d*\.?\d+)%\s*,\s*([+-]?\d*\.?\d+)%\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,p=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s+([+-]?\d*\.?\d+)%\s+([+-]?\d*\.?\d+)%\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,v=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,m=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,y={string:[[function(r){var t=i.exec(r);return t?(r=t[1]).length<=4?{r:parseInt(r[0]+r[0],16),g:parseInt(r[1]+r[1],16),b:parseInt(r[2]+r[2],16),a:4===r.length?n(parseInt(r[3]+r[3],16)/255,2):1}:6===r.length||8===r.length?{r:parseInt(r.substr(0,2),16),g:parseInt(r.substr(2,2),16),b:parseInt(r.substr(4,2),16),a:8===r.length?n(parseInt(r.substr(6,2),16)/255,2):1}:null:null},"hex"],[function(r){var t=v.exec(r)||m.exec(r);return t?t[2]!==t[4]||t[4]!==t[6]?null:a({r:Number(t[1])/(t[2]?100/255:1),g:Number(t[3])/(t[4]?100/255:1),b:Number(t[5])/(t[6]?100/255:1),a:void 0===t[7]?1:Number(t[7])/(t[8]?100:1)}):null},"rgb"],[function(t){var n=l.exec(t)||p.exec(t);if(!n)return null;var e,u,a=g({h:(e=n[1],u=n[2],void 0===u&&(u="deg"),Number(e)*(r[u]||1)),s:Number(n[3]),l:Number(n[4]),a:void 0===n[5]?1:Number(n[5])/(n[6]?100:1)});return f(a)},"hsl"]],object:[[function(r){var n=r.r,e=r.g,u=r.b,o=r.a,i=void 0===o?1:o;return t(n)&&t(e)&&t(u)?a({r:Number(n),g:Number(e),b:Number(u),a:Number(i)}):null},"rgb"],[function(r){var n=r.h,e=r.s,u=r.l,a=r.a,o=void 0===a?1:a;if(!t(n)||!t(e)||!t(u))return null;var i=g({h:Number(n),s:Number(e),l:Number(u),a:Number(o)});return f(i)},"hsl"],[function(r){var n=r.h,a=r.s,o=r.v,i=r.a,s=void 0===i?1:i;if(!t(n)||!t(a)||!t(o))return null;var h=function(r){return {h:u(r.h),s:e(r.s,0,100),v:e(r.v,0,100),a:e(r.a)}}({h:Number(n),s:Number(a),v:Number(o),a:Number(s)});return b(h)},"hsv"]]},N=function(r,t){for(var n=0;n<t.length;n++){var e=t[n][0](r);if(e)return [e,t[n][1]]}return [null,void 0]},x=function(r){return "string"==typeof r?N(r.trim(),y.string):"object"==typeof r&&null!==r?N(r,y.object):[null,void 0]},I=function(r){return x(r)[1]},M=function(r,t){var n=c(r);return {h:n.h,s:e(n.s+100*t,0,100),l:n.l,a:n.a}},H=function(r){return (299*r.r+587*r.g+114*r.b)/1e3/255},$=function(r,t){var n=c(r);return {h:n.h,s:n.s,l:e(n.l+100*t,0,100),a:n.a}},j=function(){function r(r){this.parsed=x(r)[0],this.rgba=this.parsed||{r:0,g:0,b:0,a:1};}return r.prototype.isValid=function(){return null!==this.parsed},r.prototype.brightness=function(){return n(H(this.rgba),2)},r.prototype.isDark=function(){return H(this.rgba)<.5},r.prototype.isLight=function(){return H(this.rgba)>=.5},r.prototype.toHex=function(){return r=o(this.rgba),t=r.r,e=r.g,u=r.b,i=(a=r.a)<1?s(n(255*a)):"","#"+s(t)+s(e)+s(u)+i;var r,t,e,u,a,i;},r.prototype.toRgb=function(){return o(this.rgba)},r.prototype.toRgbString=function(){return r=o(this.rgba),t=r.r,n=r.g,e=r.b,(u=r.a)<1?"rgba("+t+", "+n+", "+e+", "+u+")":"rgb("+t+", "+n+", "+e+")";var r,t,n,e,u;},r.prototype.toHsl=function(){return d(c(this.rgba))},r.prototype.toHslString=function(){return r=d(c(this.rgba)),t=r.h,n=r.s,e=r.l,(u=r.a)<1?"hsla("+t+", "+n+"%, "+e+"%, "+u+")":"hsl("+t+", "+n+"%, "+e+"%)";var r,t,n,e,u;},r.prototype.toHsv=function(){return r=h(this.rgba),{h:n(r.h),s:n(r.s),v:n(r.v),a:n(r.a,3)};var r;},r.prototype.invert=function(){return w({r:255-(r=this.rgba).r,g:255-r.g,b:255-r.b,a:r.a});var r;},r.prototype.saturate=function(r){return void 0===r&&(r=.1),w(M(this.rgba,r))},r.prototype.desaturate=function(r){return void 0===r&&(r=.1),w(M(this.rgba,-r))},r.prototype.grayscale=function(){return w(M(this.rgba,-1))},r.prototype.lighten=function(r){return void 0===r&&(r=.1),w($(this.rgba,r))},r.prototype.darken=function(r){return void 0===r&&(r=.1),w($(this.rgba,-r))},r.prototype.rotate=function(r){return void 0===r&&(r=15),this.hue(this.hue()+r)},r.prototype.alpha=function(r){return "number"==typeof r?w({r:(t=this.rgba).r,g:t.g,b:t.b,a:r}):n(this.rgba.a,3);var t;},r.prototype.hue=function(r){var t=c(this.rgba);return "number"==typeof r?w({h:r,s:t.s,l:t.l,a:t.a}):n(t.h)},r.prototype.isEqual=function(r){return this.toHex()===w(r).toHex()},r}(),w=function(r){return r instanceof j?r:new j(r)},S=[],k=function(r){r.forEach(function(r){S.indexOf(r)<0&&(r(j,y),S.push(r));});},E=function(){return new j({r:255*Math.random(),g:255*Math.random(),b:255*Math.random()})};

    function namesPlugin(e,f){var a={white:"#ffffff",bisque:"#ffe4c4",blue:"#0000ff",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",antiquewhite:"#faebd7",aqua:"#00ffff",azure:"#f0ffff",whitesmoke:"#f5f5f5",papayawhip:"#ffefd5",plum:"#dda0dd",blanchedalmond:"#ffebcd",black:"#000000",gold:"#ffd700",goldenrod:"#daa520",gainsboro:"#dcdcdc",cornsilk:"#fff8dc",cornflowerblue:"#6495ed",burlywood:"#deb887",aquamarine:"#7fffd4",beige:"#f5f5dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkkhaki:"#bdb76b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",peachpuff:"#ffdab9",darkmagenta:"#8b008b",darkred:"#8b0000",darkorchid:"#9932cc",darkorange:"#ff8c00",darkslateblue:"#483d8b",gray:"#808080",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",deeppink:"#ff1493",deepskyblue:"#00bfff",wheat:"#f5deb3",firebrick:"#b22222",floralwhite:"#fffaf0",ghostwhite:"#f8f8ff",darkviolet:"#9400d3",magenta:"#ff00ff",green:"#008000",dodgerblue:"#1e90ff",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",blueviolet:"#8a2be2",forestgreen:"#228b22",lawngreen:"#7cfc00",indianred:"#cd5c5c",indigo:"#4b0082",fuchsia:"#ff00ff",brown:"#a52a2a",maroon:"#800000",mediumblue:"#0000cd",lightcoral:"#f08080",darkturquoise:"#00ced1",lightcyan:"#e0ffff",ivory:"#fffff0",lightyellow:"#ffffe0",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",linen:"#faf0e6",mediumaquamarine:"#66cdaa",lemonchiffon:"#fffacd",lime:"#00ff00",khaki:"#f0e68c",mediumseagreen:"#3cb371",limegreen:"#32cd32",mediumspringgreen:"#00fa9a",lightskyblue:"#87cefa",lightblue:"#add8e6",midnightblue:"#191970",lightpink:"#ffb6c1",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",mintcream:"#f5fffa",lightslategray:"#778899",lightslategrey:"#778899",navajowhite:"#ffdead",navy:"#000080",mediumvioletred:"#c71585",powderblue:"#b0e0e6",palegoldenrod:"#eee8aa",oldlace:"#fdf5e6",paleturquoise:"#afeeee",mediumturquoise:"#48d1cc",mediumorchid:"#ba55d3",rebeccapurple:"#663399",lightsteelblue:"#b0c4de",mediumslateblue:"#7b68ee",thistle:"#d8bfd8",tan:"#d2b48c",orchid:"#da70d6",mediumpurple:"#9370db",purple:"#800080",pink:"#ffc0cb",skyblue:"#87ceeb",springgreen:"#00ff7f",palegreen:"#98fb98",red:"#ff0000",yellow:"#ffff00",slateblue:"#6a5acd",lavenderblush:"#fff0f5",peru:"#cd853f",palevioletred:"#db7093",violet:"#ee82ee",teal:"#008080",slategray:"#708090",slategrey:"#708090",aliceblue:"#f0f8ff",darkseagreen:"#8fbc8f",darkolivegreen:"#556b2f",greenyellow:"#adff2f",seagreen:"#2e8b57",seashell:"#fff5ee",tomato:"#ff6347",silver:"#c0c0c0",sienna:"#a0522d",lavender:"#e6e6fa",lightgreen:"#90ee90",orange:"#ffa500",orangered:"#ff4500",steelblue:"#4682b4",royalblue:"#4169e1",turquoise:"#40e0d0",yellowgreen:"#9acd32",salmon:"#fa8072",saddlebrown:"#8b4513",sandybrown:"#f4a460",rosybrown:"#bc8f8f",darksalmon:"#e9967a",lightgoldenrodyellow:"#fafad2",snow:"#fffafa",lightgrey:"#d3d3d3",lightgray:"#d3d3d3",dimgray:"#696969",dimgrey:"#696969",olivedrab:"#6b8e23",olive:"#808000"},r={};for(var d in a)r[a[d]]=d;var l={};e.prototype.toName=function(f){if(!(this.rgba.a||this.rgba.r||this.rgba.g||this.rgba.b))return "transparent";var d,i,n=r[this.toHex()];if(n)return n;if(null==f?void 0:f.closest){var o=this.toRgb(),t=1/0,b="black";if(!l.length)for(var c in a)l[c]=new e(a[c]).toRgb();for(var g in a){var u=(d=o,i=l[g],Math.pow(d.r-i.r,2)+Math.pow(d.g-i.g,2)+Math.pow(d.b-i.b,2));u<t&&(t=u,b=g);}return b}};f.string.push([function(f){var r=f.toLowerCase(),d="transparent"===r?"#0000":a[r];return d?new e(d).toRgb():null},"name"]);}

    "use strict";
    var __defProp$13 = Object.defineProperty;
    var __getOwnPropSymbols$13 = Object.getOwnPropertySymbols;
    var __hasOwnProp$13 = Object.prototype.hasOwnProperty;
    var __propIsEnum$13 = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$13 = (obj, key, value) => key in obj ? __defProp$13(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$13 = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$13.call(b, prop))
          __defNormalProp$13(a, prop, b[prop]);
      if (__getOwnPropSymbols$13)
        for (var prop of __getOwnPropSymbols$13(b)) {
          if (__propIsEnum$13.call(b, prop))
            __defNormalProp$13(a, prop, b[prop]);
        }
      return a;
    };
    k([namesPlugin]);
    const _Color = class _Color {
      /**
       * @param {ColorSource} value - Optional value to use, if not provided, white is used.
       */
      constructor(value = 16777215) {
        this._value = null;
        this._components = new Float32Array(4);
        this._components.fill(1);
        this._int = 16777215;
        this.value = value;
      }
      /** Get red component (0 - 1) */
      get red() {
        return this._components[0];
      }
      /** Get green component (0 - 1) */
      get green() {
        return this._components[1];
      }
      /** Get blue component (0 - 1) */
      get blue() {
        return this._components[2];
      }
      /** Get alpha component (0 - 1) */
      get alpha() {
        return this._components[3];
      }
      /**
       * Set the value, suitable for chaining
       * @param value
       * @see Color.value
       */
      setValue(value) {
        this.value = value;
        return this;
      }
      /**
       * The current color source.
       *
       * When setting:
       * - Setting to an instance of `Color` will copy its color source and components.
       * - Otherwise, `Color` will try to normalize the color source and set the components.
       *   If the color source is invalid, an `Error` will be thrown and the `Color` will left unchanged.
       *
       * Note: The `null` in the setter's parameter type is added to match the TypeScript rule: return type of getter
       * must be assignable to its setter's parameter type. Setting `value` to `null` will throw an `Error`.
       *
       * When getting:
       * - A return value of `null` means the previous value was overridden (e.g., {@link Color.multiply multiply},
       *   {@link Color.premultiply premultiply} or {@link Color.round round}).
       * - Otherwise, the color source used when setting is returned.
       */
      set value(value) {
        if (value instanceof _Color) {
          this._value = this._cloneSource(value._value);
          this._int = value._int;
          this._components.set(value._components);
        } else if (value === null) {
          throw new Error("Cannot set Color#value to null");
        } else if (this._value === null || !this._isSourceEqual(this._value, value)) {
          this._value = this._cloneSource(value);
          this._normalize(this._value);
        }
      }
      get value() {
        return this._value;
      }
      /**
       * Copy a color source internally.
       * @param value - Color source
       */
      _cloneSource(value) {
        if (typeof value === "string" || typeof value === "number" || value instanceof Number || value === null) {
          return value;
        } else if (Array.isArray(value) || ArrayBuffer.isView(value)) {
          return value.slice(0);
        } else if (typeof value === "object" && value !== null) {
          return __spreadValues$13({}, value);
        }
        return value;
      }
      /**
       * Equality check for color sources.
       * @param value1 - First color source
       * @param value2 - Second color source
       * @returns `true` if the color sources are equal, `false` otherwise.
       */
      _isSourceEqual(value1, value2) {
        const type1 = typeof value1;
        const type2 = typeof value2;
        if (type1 !== type2) {
          return false;
        } else if (type1 === "number" || type1 === "string" || value1 instanceof Number) {
          return value1 === value2;
        } else if (Array.isArray(value1) && Array.isArray(value2) || ArrayBuffer.isView(value1) && ArrayBuffer.isView(value2)) {
          if (value1.length !== value2.length) {
            return false;
          }
          return value1.every((v, i) => v === value2[i]);
        } else if (value1 !== null && value2 !== null) {
          const keys1 = Object.keys(value1);
          const keys2 = Object.keys(value2);
          if (keys1.length !== keys2.length) {
            return false;
          }
          return keys1.every((key) => value1[key] === value2[key]);
        }
        return value1 === value2;
      }
      /**
       * Convert to a RGBA color object.
       * @example
       * import { Color } from 'pixi.js';
       * new Color('white').toRgb(); // returns { r: 1, g: 1, b: 1, a: 1 }
       */
      toRgba() {
        const [r, g, b, a] = this._components;
        return { r, g, b, a };
      }
      /**
       * Convert to a RGB color object.
       * @example
       * import { Color } from 'pixi.js';
       * new Color('white').toRgb(); // returns { r: 1, g: 1, b: 1 }
       */
      toRgb() {
        const [r, g, b] = this._components;
        return { r, g, b };
      }
      /** Convert to a CSS-style rgba string: `rgba(255,255,255,1.0)`. */
      toRgbaString() {
        const [r, g, b] = this.toUint8RgbArray();
        return `rgba(${r},${g},${b},${this.alpha})`;
      }
      toUint8RgbArray(out) {
        const [r, g, b] = this._components;
        if (!this._arrayRgb) {
          this._arrayRgb = [];
        }
        out || (out = this._arrayRgb);
        out[0] = Math.round(r * 255);
        out[1] = Math.round(g * 255);
        out[2] = Math.round(b * 255);
        return out;
      }
      toArray(out) {
        if (!this._arrayRgba) {
          this._arrayRgba = [];
        }
        out || (out = this._arrayRgba);
        const [r, g, b, a] = this._components;
        out[0] = r;
        out[1] = g;
        out[2] = b;
        out[3] = a;
        return out;
      }
      toRgbArray(out) {
        if (!this._arrayRgb) {
          this._arrayRgb = [];
        }
        out || (out = this._arrayRgb);
        const [r, g, b] = this._components;
        out[0] = r;
        out[1] = g;
        out[2] = b;
        return out;
      }
      /**
       * Convert to a hexadecimal number.
       * @example
       * import { Color } from 'pixi.js';
       * new Color('white').toNumber(); // returns 16777215
       */
      toNumber() {
        return this._int;
      }
      /**
       * Convert to a BGR number
       * @example
       * import { Color } from 'pixi.js';
       * new Color(0xffcc99).toBgrNumber(); // returns 0x99ccff
       */
      toBgrNumber() {
        const [r, g, b] = this.toUint8RgbArray();
        return (b << 16) + (g << 8) + r;
      }
      /**
       * Convert to a hexadecimal number in little endian format (e.g., BBGGRR).
       * @example
       * import { Color } from 'pixi.js';
       * new Color(0xffcc99).toLittleEndianNumber(); // returns 0x99ccff
       * @returns {number} - The color as a number in little endian format.
       */
      toLittleEndianNumber() {
        const value = this._int;
        return (value >> 16) + (value & 65280) + ((value & 255) << 16);
      }
      /**
       * Multiply with another color. This action is destructive, and will
       * override the previous `value` property to be `null`.
       * @param {ColorSource} value - The color to multiply by.
       */
      multiply(value) {
        const [r, g, b, a] = _Color._temp.setValue(value)._components;
        this._components[0] *= r;
        this._components[1] *= g;
        this._components[2] *= b;
        this._components[3] *= a;
        this._refreshInt();
        this._value = null;
        return this;
      }
      /**
       * Converts color to a premultiplied alpha format. This action is destructive, and will
       * override the previous `value` property to be `null`.
       * @param alpha - The alpha to multiply by.
       * @param {boolean} [applyToRGB=true] - Whether to premultiply RGB channels.
       * @returns {Color} - Itself.
       */
      premultiply(alpha, applyToRGB = true) {
        if (applyToRGB) {
          this._components[0] *= alpha;
          this._components[1] *= alpha;
          this._components[2] *= alpha;
        }
        this._components[3] = alpha;
        this._refreshInt();
        this._value = null;
        return this;
      }
      /**
       * Premultiplies alpha with current color.
       * @param {number} alpha - The alpha to multiply by.
       * @param {boolean} [applyToRGB=true] - Whether to premultiply RGB channels.
       * @returns {number} tint multiplied by alpha
       */
      toPremultiplied(alpha, applyToRGB = true) {
        if (alpha === 1) {
          return (255 << 24) + this._int;
        }
        if (alpha === 0) {
          return applyToRGB ? 0 : this._int;
        }
        let r = this._int >> 16 & 255;
        let g = this._int >> 8 & 255;
        let b = this._int & 255;
        if (applyToRGB) {
          r = r * alpha + 0.5 | 0;
          g = g * alpha + 0.5 | 0;
          b = b * alpha + 0.5 | 0;
        }
        return (alpha * 255 << 24) + (r << 16) + (g << 8) + b;
      }
      /**
       * Convert to a hexadecimal string.
       * @example
       * import { Color } from 'pixi.js';
       * new Color('white').toHex(); // returns "#ffffff"
       */
      toHex() {
        const hexString = this._int.toString(16);
        return `#${"000000".substring(0, 6 - hexString.length) + hexString}`;
      }
      /**
       * Convert to a hexadecimal string with alpha.
       * @example
       * import { Color } from 'pixi.js';
       * new Color('white').toHexa(); // returns "#ffffffff"
       */
      toHexa() {
        const alphaValue = Math.round(this._components[3] * 255);
        const alphaString = alphaValue.toString(16);
        return this.toHex() + "00".substring(0, 2 - alphaString.length) + alphaString;
      }
      /**
       * Set alpha, suitable for chaining.
       * @param alpha
       */
      setAlpha(alpha) {
        this._components[3] = this._clamp(alpha);
        return this;
      }
      /**
       * Normalize the input value into rgba
       * @param value - Input value
       */
      _normalize(value) {
        let r;
        let g;
        let b;
        let a;
        if ((typeof value === "number" || value instanceof Number) && value >= 0 && value <= 16777215) {
          const int = value;
          r = (int >> 16 & 255) / 255;
          g = (int >> 8 & 255) / 255;
          b = (int & 255) / 255;
          a = 1;
        } else if ((Array.isArray(value) || value instanceof Float32Array) && value.length >= 3 && value.length <= 4) {
          value = this._clamp(value);
          [r, g, b, a = 1] = value;
        } else if ((value instanceof Uint8Array || value instanceof Uint8ClampedArray) && value.length >= 3 && value.length <= 4) {
          value = this._clamp(value, 0, 255);
          [r, g, b, a = 255] = value;
          r /= 255;
          g /= 255;
          b /= 255;
          a /= 255;
        } else if (typeof value === "string" || typeof value === "object") {
          if (typeof value === "string") {
            const match = _Color.HEX_PATTERN.exec(value);
            if (match) {
              value = `#${match[2]}`;
            }
          }
          const color = w(value);
          if (color.isValid()) {
            ({ r, g, b, a } = color.rgba);
            r /= 255;
            g /= 255;
            b /= 255;
          }
        }
        if (r !== void 0) {
          this._components[0] = r;
          this._components[1] = g;
          this._components[2] = b;
          this._components[3] = a;
          this._refreshInt();
        } else {
          throw new Error(`Unable to convert color ${value}`);
        }
      }
      /** Refresh the internal color rgb number */
      _refreshInt() {
        this._clamp(this._components);
        const [r, g, b] = this._components;
        this._int = (r * 255 << 16) + (g * 255 << 8) + (b * 255 | 0);
      }
      /**
       * Clamps values to a range. Will override original values
       * @param value - Value(s) to clamp
       * @param min - Minimum value
       * @param max - Maximum value
       */
      _clamp(value, min = 0, max = 1) {
        if (typeof value === "number") {
          return Math.min(Math.max(value, min), max);
        }
        value.forEach((v, i) => {
          value[i] = Math.min(Math.max(v, min), max);
        });
        return value;
      }
      /**
       * Check if the value is a color-like object
       * @param value - Value to check
       * @returns True if the value is a color-like object
       * @static
       * @example
       * import { Color } from 'pixi.js';
       * Color.isColorLike('white'); // returns true
       * Color.isColorLike(0xffffff); // returns true
       * Color.isColorLike([1, 1, 1]); // returns true
       */
      static isColorLike(value) {
        return typeof value === "number" || typeof value === "string" || value instanceof Number || value instanceof _Color || Array.isArray(value) || value instanceof Uint8Array || value instanceof Uint8ClampedArray || value instanceof Float32Array || value.r !== void 0 && value.g !== void 0 && value.b !== void 0 || value.r !== void 0 && value.g !== void 0 && value.b !== void 0 && value.a !== void 0 || value.h !== void 0 && value.s !== void 0 && value.l !== void 0 || value.h !== void 0 && value.s !== void 0 && value.l !== void 0 && value.a !== void 0 || value.h !== void 0 && value.s !== void 0 && value.v !== void 0 || value.h !== void 0 && value.s !== void 0 && value.v !== void 0 && value.a !== void 0;
      }
    };
    /**
     * Default Color object for static uses
     * @example
     * import { Color } from 'pixi.js';
     * Color.shared.setValue(0xffffff).toHex(); // '#ffffff'
     */
    _Color.shared = new _Color();
    /**
     * Temporary Color object for static uses internally.
     * As to not conflict with Color.shared.
     * @ignore
     */
    _Color._temp = new _Color();
    /** Pattern for hex strings */
    // eslint-disable-next-line @typescript-eslint/naming-convention
    _Color.HEX_PATTERN = /^(#|0x)?(([a-f0-9]{3}){1,2}([a-f0-9]{2})?)$/i;
    let Color = _Color;

    "use strict";
    const cullingMixin = {
      cullArea: null,
      cullable: false,
      cullableChildren: true
    };

    "use strict";
    class Pool {
      /**
       * Constructs a new Pool.
       * @param ClassType - The constructor of the items in the pool.
       * @param {number} [initialSize] - The initial size of the pool.
       */
      constructor(ClassType, initialSize) {
        this._pool = [];
        this._count = 0;
        this._index = 0;
        this._classType = ClassType;
        if (initialSize) {
          this.prepopulate(initialSize);
        }
      }
      /**
       * Prepopulates the pool with a given number of items.
       * @param total - The number of items to add to the pool.
       */
      prepopulate(total) {
        for (let i = 0; i < total; i++) {
          this._pool[this._index++] = new this._classType();
        }
        this._count += total;
      }
      /**
       * Gets an item from the pool. Calls the item's `init` method if it exists.
       * If there are no items left in the pool, a new one will be created.
       * @param {unknown} [data] - Optional data to pass to the item's constructor.
       * @returns {T} The item from the pool.
       */
      get(data) {
        var _a;
        let item;
        if (this._index > 0) {
          item = this._pool[--this._index];
        } else {
          item = new this._classType();
        }
        (_a = item.init) == null ? void 0 : _a.call(item, data);
        return item;
      }
      /**
       * Returns an item to the pool. Calls the item's `reset` method if it exists.
       * @param {T} item - The item to return to the pool.
       */
      return(item) {
        var _a;
        (_a = item.reset) == null ? void 0 : _a.call(item);
        this._pool[this._index++] = item;
      }
      /**
       * Gets the number of items in the pool.
       * @readonly
       * @member {number}
       */
      get totalSize() {
        return this._count;
      }
      /**
       * Gets the number of items in the pool that are free to use without needing to create more.
       * @readonly
       * @member {number}
       */
      get totalFree() {
        return this._index;
      }
      /**
       * Gets the number of items in the pool that are currently in use.
       * @readonly
       * @member {number}
       */
      get totalUsed() {
        return this._count - this._index;
      }
      /** clears the pool - mainly used for debugging! */
      clear() {
        this._pool.length = 0;
        this._index = 0;
      }
    }

    "use strict";
    class PoolGroupClass {
      constructor() {
        /**
         * A map to store the pools by their class type.
         * @private
         */
        this._poolsByClass = /* @__PURE__ */ new Map();
      }
      /**
       * Prepopulates a specific pool with a given number of items.
       * @template T The type of items in the pool. Must extend PoolItem.
       * @param {PoolItemConstructor<T>} Class - The constructor of the items in the pool.
       * @param {number} total - The number of items to add to the pool.
       */
      prepopulate(Class, total) {
        const classPool = this.getPool(Class);
        classPool.prepopulate(total);
      }
      /**
       * Gets an item from a specific pool.
       * @template T The type of items in the pool. Must extend PoolItem.
       * @param {PoolItemConstructor<T>} Class - The constructor of the items in the pool.
       * @param {unknown} [data] - Optional data to pass to the item's constructor.
       * @returns {T} The item from the pool.
       */
      get(Class, data) {
        const pool = this.getPool(Class);
        return pool.get(data);
      }
      /**
       * Returns an item to its respective pool.
       * @param {PoolItem} item - The item to return to the pool.
       */
      return(item) {
        const pool = this.getPool(item.constructor);
        pool.return(item);
      }
      /**
       * Gets a specific pool based on the class type.
       * @template T The type of items in the pool. Must extend PoolItem.
       * @param {PoolItemConstructor<T>} ClassType - The constructor of the items in the pool.
       * @returns {Pool<T>} The pool of the given class type.
       */
      getPool(ClassType) {
        if (!this._poolsByClass.has(ClassType)) {
          this._poolsByClass.set(ClassType, new Pool(ClassType));
        }
        return this._poolsByClass.get(ClassType);
      }
      /** gets the usage stats of each pool in the system */
      stats() {
        const stats = {};
        this._poolsByClass.forEach((pool) => {
          const name = stats[pool._classType.name] ? pool._classType.name + pool._classType.ID : pool._classType.name;
          stats[name] = {
            free: pool.totalFree,
            used: pool.totalUsed,
            size: pool.totalSize
          };
        });
        return stats;
      }
    }
    const BigPool = new PoolGroupClass();

    "use strict";
    const cacheAsTextureMixin = {
      /**
       * Is this container cached as a texture?
       * @readonly
       * @type {boolean}
       * @memberof scene.Container#
       */
      get isCachedAsTexture() {
        var _a;
        return !!((_a = this.renderGroup) == null ? void 0 : _a.isCachedAsTexture);
      },
      cacheAsTexture(val) {
        if (typeof val === "boolean" && val === false) {
          this.disableRenderGroup();
        } else {
          this.enableRenderGroup();
          this.renderGroup.enableCacheAsTexture(val === true ? {} : val);
        }
      },
      /**
       * Updates the cached texture. Will flag that this container's cached texture needs to be redrawn.
       * This will happen on the next render.
       * @memberof scene.Container#
       */
      updateCacheTexture() {
        var _a;
        (_a = this.renderGroup) == null ? void 0 : _a.updateCacheTexture();
      },
      /**
       * Allows backwards compatibility with pixi.js below version v8. Use `cacheAsTexture` instead.
       * @deprecated
       */
      get cacheAsBitmap() {
        return this.isCachedAsTexture;
      },
      /**
       * @deprecated
       */
      set cacheAsBitmap(val) {
        deprecation("v8.6.0", "cacheAsBitmap is deprecated, use cacheAsTexture instead.");
        this.cacheAsTexture(val);
      }
    };

    "use strict";
    function removeItems(arr, startIdx, removeCount) {
      const length = arr.length;
      let i;
      if (startIdx >= length || removeCount === 0) {
        return;
      }
      removeCount = startIdx + removeCount > length ? length - startIdx : removeCount;
      const len = length - removeCount;
      for (i = startIdx; i < len; ++i) {
        arr[i] = arr[i + removeCount];
      }
      arr.length = len;
    }

    "use strict";
    const childrenHelperMixin = {
      allowChildren: true,
      /**
       * Removes all children from this container that are within the begin and end indexes.
       * @param beginIndex - The beginning position.
       * @param endIndex - The ending position. Default value is size of the container.
       * @returns - List of removed children
       * @memberof scene.Container#
       */
      removeChildren(beginIndex = 0, endIndex) {
        const end = endIndex != null ? endIndex : this.children.length;
        const range = end - beginIndex;
        const removed = [];
        if (range > 0 && range <= end) {
          for (let i = end - 1; i >= beginIndex; i--) {
            const child = this.children[i];
            if (!child)
              continue;
            removed.push(child);
            child.parent = null;
          }
          removeItems(this.children, beginIndex, end);
          const renderGroup = this.renderGroup || this.parentRenderGroup;
          if (renderGroup) {
            renderGroup.removeChildren(removed);
          }
          for (let i = 0; i < removed.length; ++i) {
            this.emit("childRemoved", removed[i], this, i);
            removed[i].emit("removed", this);
          }
          return removed;
        } else if (range === 0 && this.children.length === 0) {
          return removed;
        }
        throw new RangeError("removeChildren: numeric values are outside the acceptable range.");
      },
      /**
       * Removes a child from the specified index position.
       * @param index - The index to get the child from
       * @returns The child that was removed.
       * @memberof scene.Container#
       */
      removeChildAt(index) {
        const child = this.getChildAt(index);
        return this.removeChild(child);
      },
      /**
       * Returns the child at the specified index
       * @param index - The index to get the child at
       * @returns - The child at the given index, if any.
       * @memberof scene.Container#
       */
      getChildAt(index) {
        if (index < 0 || index >= this.children.length) {
          throw new Error(`getChildAt: Index (${index}) does not exist.`);
        }
        return this.children[index];
      },
      /**
       * Changes the position of an existing child in the container
       * @param child - The child Container instance for which you want to change the index number
       * @param index - The resulting index number for the child container
       * @memberof scene.Container#
       */
      setChildIndex(child, index) {
        if (index < 0 || index >= this.children.length) {
          throw new Error(`The index ${index} supplied is out of bounds ${this.children.length}`);
        }
        this.getChildIndex(child);
        this.addChildAt(child, index);
      },
      /**
       * Returns the index position of a child Container instance
       * @param child - The Container instance to identify
       * @returns - The index position of the child container to identify
       * @memberof scene.Container#
       */
      getChildIndex(child) {
        const index = this.children.indexOf(child);
        if (index === -1) {
          throw new Error("The supplied Container must be a child of the caller");
        }
        return index;
      },
      /**
       * Adds a child to the container at a specified index. If the index is out of bounds an error will be thrown.
       * If the child is already in this container, it will be moved to the specified index.
       * @param {Container} child - The child to add.
       * @param {number} index - The absolute index where the child will be positioned at the end of the operation.
       * @returns {Container} The child that was added.
       * @memberof scene.Container#
       */
      addChildAt(child, index) {
        if (!this.allowChildren) {
          deprecation(v8_0_0, "addChildAt: Only Containers will be allowed to add children in v8.0.0");
        }
        const { children } = this;
        if (index < 0 || index > children.length) {
          throw new Error(`${child}addChildAt: The index ${index} supplied is out of bounds ${children.length}`);
        }
        if (child.parent) {
          const currentIndex = child.parent.children.indexOf(child);
          if (child.parent === this && currentIndex === index) {
            return child;
          }
          if (currentIndex !== -1) {
            child.parent.children.splice(currentIndex, 1);
          }
        }
        if (index === children.length) {
          children.push(child);
        } else {
          children.splice(index, 0, child);
        }
        child.parent = this;
        child.didChange = true;
        child._updateFlags = 15;
        const renderGroup = this.renderGroup || this.parentRenderGroup;
        if (renderGroup) {
          renderGroup.addChild(child);
        }
        if (this.sortableChildren)
          this.sortDirty = true;
        this.emit("childAdded", child, this, index);
        child.emit("added", this);
        return child;
      },
      /**
       * Swaps the position of 2 Containers within this container.
       * @param child - First container to swap
       * @param child2 - Second container to swap
       * @memberof scene.Container#
       */
      swapChildren(child, child2) {
        if (child === child2) {
          return;
        }
        const index1 = this.getChildIndex(child);
        const index2 = this.getChildIndex(child2);
        this.children[index1] = child2;
        this.children[index2] = child;
        const renderGroup = this.renderGroup || this.parentRenderGroup;
        if (renderGroup) {
          renderGroup.structureDidChange = true;
        }
        this._didContainerChangeTick++;
      },
      /**
       * Remove the Container from its parent Container. If the Container has no parent, do nothing.
       * @memberof scene.Container#
       */
      removeFromParent() {
        var _a;
        (_a = this.parent) == null ? void 0 : _a.removeChild(this);
      },
      /**
       * Reparent the child to this container, keeping the same worldTransform.
       * @param child - The child to reparent
       * @returns The first child that was reparented.
       * @memberof scene.Container#
       */
      reparentChild(...child) {
        if (child.length === 1) {
          return this.reparentChildAt(child[0], this.children.length);
        }
        child.forEach((c) => this.reparentChildAt(c, this.children.length));
        return child[0];
      },
      /**
       * Reparent the child to this container at the specified index, keeping the same worldTransform.
       * @param child - The child to reparent
       * @param index - The index to reparent the child to
       * @memberof scene.Container#
       */
      reparentChildAt(child, index) {
        if (child.parent === this) {
          this.setChildIndex(child, index);
          return child;
        }
        const childMat = child.worldTransform.clone();
        child.removeFromParent();
        this.addChildAt(child, index);
        const newMatrix = this.worldTransform.clone();
        newMatrix.invert();
        childMat.prepend(newMatrix);
        child.setFromMatrix(childMat);
        return child;
      }
    };

    "use strict";
    class FilterEffect {
      constructor() {
        /** the pipe that knows how to handle this effect */
        this.pipe = "filter";
        /** the priority of this effect */
        this.priority = 1;
      }
      destroy() {
        for (let i = 0; i < this.filters.length; i++) {
          this.filters[i].destroy();
        }
        this.filters = null;
        this.filterArea = null;
      }
    }

    "use strict";
    class MaskEffectManagerClass {
      constructor() {
        /**
         * @private
         */
        this._effectClasses = [];
        this._tests = [];
        this._initialized = false;
      }
      init() {
        if (this._initialized)
          return;
        this._initialized = true;
        this._effectClasses.forEach((test) => {
          this.add({
            test: test.test,
            maskClass: test
          });
        });
      }
      add(test) {
        this._tests.push(test);
      }
      getMaskEffect(item) {
        if (!this._initialized)
          this.init();
        for (let i = 0; i < this._tests.length; i++) {
          const test = this._tests[i];
          if (test.test(item)) {
            return BigPool.get(test.maskClass, item);
          }
        }
        return item;
      }
      returnMaskEffect(effect) {
        BigPool.return(effect);
      }
    }
    const MaskEffectManager = new MaskEffectManagerClass();
    extensions.handleByList(ExtensionType.MaskEffect, MaskEffectManager._effectClasses);

    "use strict";
    var __defProp$12 = Object.defineProperty;
    var __getOwnPropSymbols$12 = Object.getOwnPropertySymbols;
    var __hasOwnProp$12 = Object.prototype.hasOwnProperty;
    var __propIsEnum$12 = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$12 = (obj, key, value) => key in obj ? __defProp$12(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$12 = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$12.call(b, prop))
          __defNormalProp$12(a, prop, b[prop]);
      if (__getOwnPropSymbols$12)
        for (var prop of __getOwnPropSymbols$12(b)) {
          if (__propIsEnum$12.call(b, prop))
            __defNormalProp$12(a, prop, b[prop]);
        }
      return a;
    };
    const effectsMixin = {
      _maskEffect: null,
      _maskOptions: {
        inverse: false
      },
      _filterEffect: null,
      /**
       * @todo Needs docs.
       * @memberof scene.Container#
       * @type {Array<Effect>}
       */
      effects: [],
      _markStructureAsChanged() {
        const renderGroup = this.renderGroup || this.parentRenderGroup;
        if (renderGroup) {
          renderGroup.structureDidChange = true;
        }
      },
      /**
       * @todo Needs docs.
       * @param effect - The effect to add.
       * @memberof scene.Container#
       * @ignore
       */
      addEffect(effect) {
        const index = this.effects.indexOf(effect);
        if (index !== -1)
          return;
        this.effects.push(effect);
        this.effects.sort((a, b) => a.priority - b.priority);
        this._markStructureAsChanged();
        this._updateIsSimple();
      },
      /**
       * @todo Needs docs.
       * @param effect - The effect to remove.
       * @memberof scene.Container#
       * @ignore
       */
      removeEffect(effect) {
        const index = this.effects.indexOf(effect);
        if (index === -1)
          return;
        this.effects.splice(index, 1);
        this._markStructureAsChanged();
        this._updateIsSimple();
      },
      set mask(value) {
        const effect = this._maskEffect;
        if ((effect == null ? void 0 : effect.mask) === value)
          return;
        if (effect) {
          this.removeEffect(effect);
          MaskEffectManager.returnMaskEffect(effect);
          this._maskEffect = null;
        }
        if (value === null || value === void 0)
          return;
        this._maskEffect = MaskEffectManager.getMaskEffect(value);
        this.addEffect(this._maskEffect);
      },
      /**
       * Used to set mask and control mask options.
       * @param options
       * @example
       * import { Graphics, Sprite } from 'pixi.js';
       *
       * const graphics = new Graphics();
       * graphics.beginFill(0xFF3300);
       * graphics.drawRect(50, 250, 100, 100);
       * graphics.endFill();
       *
       * const sprite = new Sprite(texture);
       * sprite.setMask({
       *     mask: graphics,
       *     inverse: true,
       * });
       * @memberof scene.Container#
       */
      setMask(options) {
        this._maskOptions = __spreadValues$12(__spreadValues$12({}, this._maskOptions), options);
        if (options.mask) {
          this.mask = options.mask;
        }
        this._markStructureAsChanged();
      },
      /**
       * Sets a mask for the displayObject. A mask is an object that limits the visibility of an
       * object to the shape of the mask applied to it. In PixiJS a regular mask must be a
       * {@link Graphics} or a {@link Sprite} object. This allows for much faster masking in canvas as it
       * utilities shape clipping. Furthermore, a mask of an object must be in the subtree of its parent.
       * Otherwise, `getLocalBounds` may calculate incorrect bounds, which makes the container's width and height wrong.
       * To remove a mask, set this property to `null`.
       *
       * For sprite mask both alpha and red channel are used. Black mask is the same as transparent mask.
       * @example
       * import { Graphics, Sprite } from 'pixi.js';
       *
       * const graphics = new Graphics();
       * graphics.beginFill(0xFF3300);
       * graphics.drawRect(50, 250, 100, 100);
       * graphics.endFill();
       *
       * const sprite = new Sprite(texture);
       * sprite.mask = graphics;
       * @memberof scene.Container#
       */
      get mask() {
        var _a;
        return (_a = this._maskEffect) == null ? void 0 : _a.mask;
      },
      set filters(value) {
        var _a;
        if (!Array.isArray(value) && value)
          value = [value];
        const effect = this._filterEffect || (this._filterEffect = new FilterEffect());
        value = value;
        const hasFilters = (value == null ? void 0 : value.length) > 0;
        const hadFilters = ((_a = effect.filters) == null ? void 0 : _a.length) > 0;
        const didChange = hasFilters !== hadFilters;
        value = Array.isArray(value) ? value.slice(0) : value;
        effect.filters = Object.freeze(value);
        if (didChange) {
          if (hasFilters) {
            this.addEffect(effect);
          } else {
            this.removeEffect(effect);
            effect.filters = value != null ? value : null;
          }
        }
      },
      /**
       * Sets the filters for the displayObject.
       * IMPORTANT: This is a WebGL only feature and will be ignored by the canvas renderer.
       * To remove filters simply set this property to `'null'`.
       * @memberof scene.Container#
       */
      get filters() {
        var _a;
        return (_a = this._filterEffect) == null ? void 0 : _a.filters;
      },
      set filterArea(value) {
        this._filterEffect || (this._filterEffect = new FilterEffect());
        this._filterEffect.filterArea = value;
      },
      /**
       * The area the filter is applied to. This is used as more of an optimization
       * rather than figuring out the dimensions of the displayObject each frame you can set this rectangle.
       *
       * Also works as an interaction mask.
       * @memberof scene.Container#
       */
      get filterArea() {
        var _a;
        return (_a = this._filterEffect) == null ? void 0 : _a.filterArea;
      }
    };

    "use strict";
    const findMixin = {
      /**
       * The instance label of the object.
       * @memberof scene.Container#
       * @member {string} label
       */
      label: null,
      /**
       * The instance name of the object.
       * @deprecated since 8.0.0
       * @see scene.Container#label
       * @member {string} name
       * @memberof scene.Container#
       */
      get name() {
        deprecation(v8_0_0, "Container.name property has been removed, use Container.label instead");
        return this.label;
      },
      set name(value) {
        deprecation(v8_0_0, "Container.name property has been removed, use Container.label instead");
        this.label = value;
      },
      /**
       * @method getChildByName
       * @deprecated since 8.0.0
       * @param {string} name - Instance name.
       * @param {boolean}[deep=false] - Whether to search recursively
       * @returns {Container} The child with the specified name.
       * @see scene.Container#getChildByLabel
       * @memberof scene.Container#
       */
      getChildByName(name, deep = false) {
        return this.getChildByLabel(name, deep);
      },
      /**
       * Returns the first child in the container with the specified label.
       *
       * Recursive searches are done in a pre-order traversal.
       * @memberof scene.Container#
       * @param {string|RegExp} label - Instance label.
       * @param {boolean}[deep=false] - Whether to search recursively
       * @returns {Container} The child with the specified label.
       */
      getChildByLabel(label, deep = false) {
        const children = this.children;
        for (let i = 0; i < children.length; i++) {
          const child = children[i];
          if (child.label === label || label instanceof RegExp && label.test(child.label))
            return child;
        }
        if (deep) {
          for (let i = 0; i < children.length; i++) {
            const child = children[i];
            const found = child.getChildByLabel(label, true);
            if (found) {
              return found;
            }
          }
        }
        return null;
      },
      /**
       * Returns all children in the container with the specified label.
       * @memberof scene.Container#
       * @param {string|RegExp} label - Instance label.
       * @param {boolean}[deep=false] - Whether to search recursively
       * @param {Container[]} [out=[]] - The array to store matching children in.
       * @returns {Container[]} An array of children with the specified label.
       */
      getChildrenByLabel(label, deep = false, out = []) {
        const children = this.children;
        for (let i = 0; i < children.length; i++) {
          const child = children[i];
          if (child.label === label || label instanceof RegExp && label.test(child.label)) {
            out.push(child);
          }
        }
        if (deep) {
          for (let i = 0; i < children.length; i++) {
            children[i].getChildrenByLabel(label, true, out);
          }
        }
        return out;
      }
    };

    "use strict";
    const matrixPool = new Pool(Matrix);
    const boundsPool = new Pool(Bounds);

    "use strict";
    function getGlobalBounds(target, skipUpdateTransform, bounds) {
      bounds.clear();
      let parentTransform;
      let pooledMatrix;
      if (target.parent) {
        if (!skipUpdateTransform) {
          pooledMatrix = matrixPool.get().identity();
          parentTransform = updateTransformBackwards(target, pooledMatrix);
        } else {
          parentTransform = target.parent.worldTransform;
        }
      } else {
        parentTransform = Matrix.IDENTITY;
      }
      _getGlobalBounds(target, bounds, parentTransform, skipUpdateTransform);
      if (pooledMatrix) {
        matrixPool.return(pooledMatrix);
      }
      if (!bounds.isValid) {
        bounds.set(0, 0, 0, 0);
      }
      return bounds;
    }
    function _getGlobalBounds(target, bounds, parentTransform, skipUpdateTransform) {
      var _a, _b;
      if (!target.visible || !target.measurable)
        return;
      let worldTransform;
      if (!skipUpdateTransform) {
        target.updateLocalTransform();
        worldTransform = matrixPool.get();
        worldTransform.appendFrom(target.localTransform, parentTransform);
      } else {
        worldTransform = target.worldTransform;
      }
      const parentBounds = bounds;
      const preserveBounds = !!target.effects.length;
      if (preserveBounds) {
        bounds = boundsPool.get().clear();
      }
      if (target.boundsArea) {
        bounds.addRect(target.boundsArea, worldTransform);
      } else {
        if (target.bounds) {
          bounds.matrix = worldTransform;
          bounds.addBounds(target.bounds);
        }
        for (let i = 0; i < target.children.length; i++) {
          _getGlobalBounds(target.children[i], bounds, worldTransform, skipUpdateTransform);
        }
      }
      if (preserveBounds) {
        for (let i = 0; i < target.effects.length; i++) {
          (_b = (_a = target.effects[i]).addBounds) == null ? void 0 : _b.call(_a, bounds);
        }
        parentBounds.addBounds(bounds, Matrix.IDENTITY);
        boundsPool.return(bounds);
      }
      if (!skipUpdateTransform) {
        matrixPool.return(worldTransform);
      }
    }
    function updateTransformBackwards(target, parentTransform) {
      const parent = target.parent;
      if (parent) {
        updateTransformBackwards(parent, parentTransform);
        parent.updateLocalTransform();
        parentTransform.append(parent.localTransform);
      }
      return parentTransform;
    }

    "use strict";
    function multiplyHexColors(color1, color2) {
      if (color1 === 16777215 || !color2)
        return color2;
      if (color2 === 16777215 || !color1)
        return color1;
      const r1 = color1 >> 16 & 255;
      const g1 = color1 >> 8 & 255;
      const b1 = color1 & 255;
      const r2 = color2 >> 16 & 255;
      const g2 = color2 >> 8 & 255;
      const b2 = color2 & 255;
      const r = r1 * r2 / 255 | 0;
      const g = g1 * g2 / 255 | 0;
      const b = b1 * b2 / 255 | 0;
      return (r << 16) + (g << 8) + b;
    }

    "use strict";
    const WHITE_BGR = 16777215;
    function multiplyColors(localBGRColor, parentBGRColor) {
      if (localBGRColor === WHITE_BGR) {
        return parentBGRColor;
      }
      if (parentBGRColor === WHITE_BGR) {
        return localBGRColor;
      }
      return multiplyHexColors(localBGRColor, parentBGRColor);
    }

    "use strict";
    function bgr2rgb(color) {
      return ((color & 255) << 16) + (color & 65280) + (color >> 16 & 255);
    }
    const getGlobalMixin = {
      /**
       * Returns the global (compound) alpha of the container within the scene.
       * @param skipUpdate - Performance optimization flag:
       *   - If false (default): Recalculates the entire alpha chain through parents for accuracy
       *   - If true: Uses cached worldAlpha from the last render pass for better performance
       * @returns The resulting alpha value (between 0 and 1)
       * @example
       * // Accurate but slower - recalculates entire alpha chain
       * const preciseAlpha = container.getGlobalAlpha();
       *
       * // Faster but may be outdated - uses cached alpha
       * const cachedAlpha = container.getGlobalAlpha(true);
       */
      getGlobalAlpha(skipUpdate) {
        if (skipUpdate) {
          if (this.renderGroup) {
            return this.renderGroup.worldAlpha;
          }
          if (this.parentRenderGroup) {
            return this.parentRenderGroup.worldAlpha * this.alpha;
          }
          return this.alpha;
        }
        let alpha = this.alpha;
        let current = this.parent;
        while (current) {
          alpha *= current.alpha;
          current = current.parent;
        }
        return alpha;
      },
      /**
       * Returns the global transform matrix of the container within the scene.
       * @param matrix - Optional matrix to store the result. If not provided, a new Matrix will be created.
       * @param skipUpdate - Performance optimization flag:
       *   - If false (default): Recalculates the entire transform chain for accuracy
       *   - If true: Uses cached worldTransform from the last render pass for better performance
       * @returns The resulting transformation matrix (either the input matrix or a new one)
       * @example
       * // Accurate but slower - recalculates entire transform chain
       * const preciseTransform = container.getGlobalTransform();
       *
       * // Faster but may be outdated - uses cached transform
       * const cachedTransform = container.getGlobalTransform(undefined, true);
       *
       * // Reuse existing matrix
       * const existingMatrix = new Matrix();
       * container.getGlobalTransform(existingMatrix);
       */
      getGlobalTransform(matrix, skipUpdate) {
        if (skipUpdate) {
          return matrix.copyFrom(this.worldTransform);
        }
        this.updateLocalTransform();
        const parentTransform = updateTransformBackwards(this, matrixPool.get().identity());
        matrix.appendFrom(this.localTransform, parentTransform);
        matrixPool.return(parentTransform);
        return matrix;
      },
      /**
       * Returns the global (compound) tint color of the container within the scene.
       * @param skipUpdate - Performance optimization flag:
       *   - If false (default): Recalculates the entire tint chain through parents for accuracy
       *   - If true: Uses cached worldColor from the last render pass for better performance
       * @returns The resulting tint color as a 24-bit RGB number (0xRRGGBB)
       * @example
       * // Accurate but slower - recalculates entire tint chain
       * const preciseTint = container.getGlobalTint();
       *
       * // Faster but may be outdated - uses cached tint
       * const cachedTint = container.getGlobalTint(true);
       */
      getGlobalTint(skipUpdate) {
        if (skipUpdate) {
          if (this.renderGroup) {
            return bgr2rgb(this.renderGroup.worldColor);
          }
          if (this.parentRenderGroup) {
            return bgr2rgb(
              multiplyColors(this.localColor, this.parentRenderGroup.worldColor)
            );
          }
          return this.tint;
        }
        let color = this.localColor;
        let parent = this.parent;
        while (parent) {
          color = multiplyColors(color, parent.localColor);
          parent = parent.parent;
        }
        return bgr2rgb(color);
      }
    };

    "use strict";
    function getLocalBounds(target, bounds, relativeMatrix) {
      bounds.clear();
      relativeMatrix || (relativeMatrix = Matrix.IDENTITY);
      _getLocalBounds(target, bounds, relativeMatrix, target, true);
      if (!bounds.isValid) {
        bounds.set(0, 0, 0, 0);
      }
      return bounds;
    }
    function _getLocalBounds(target, bounds, parentTransform, rootContainer, isRoot) {
      var _a, _b;
      let relativeTransform;
      if (!isRoot) {
        if (!target.visible || !target.measurable)
          return;
        target.updateLocalTransform();
        const localTransform = target.localTransform;
        relativeTransform = matrixPool.get();
        relativeTransform.appendFrom(localTransform, parentTransform);
      } else {
        relativeTransform = matrixPool.get();
        relativeTransform = parentTransform.copyTo(relativeTransform);
      }
      const parentBounds = bounds;
      const preserveBounds = !!target.effects.length;
      if (preserveBounds) {
        bounds = boundsPool.get().clear();
      }
      if (target.boundsArea) {
        bounds.addRect(target.boundsArea, relativeTransform);
      } else {
        if (target.renderPipeId) {
          bounds.matrix = relativeTransform;
          bounds.addBounds(target.bounds);
        }
        const children = target.children;
        for (let i = 0; i < children.length; i++) {
          _getLocalBounds(children[i], bounds, relativeTransform, rootContainer, false);
        }
      }
      if (preserveBounds) {
        for (let i = 0; i < target.effects.length; i++) {
          (_b = (_a = target.effects[i]).addLocalBounds) == null ? void 0 : _b.call(_a, bounds, rootContainer);
        }
        parentBounds.addBounds(bounds, Matrix.IDENTITY);
        boundsPool.return(bounds);
      }
      matrixPool.return(relativeTransform);
    }
    function getParent(target, root, matrix) {
      const parent = target.parent;
      if (!parent) {
        warn("Item is not inside the root container");
        return;
      }
      if (parent !== root) {
        getParent(parent, root, matrix);
        parent.updateLocalTransform();
        matrix.append(parent.localTransform);
      }
    }

    "use strict";
    function checkChildrenDidChange(container, previousData) {
      const children = container.children;
      for (let i = 0; i < children.length; i++) {
        const child = children[i];
        const uid = child.uid;
        const didChange = (child._didViewChangeTick & 65535) << 16 | child._didContainerChangeTick & 65535;
        const index = previousData.index;
        if (previousData.data[index] !== uid || previousData.data[index + 1] !== didChange) {
          previousData.data[previousData.index] = uid;
          previousData.data[previousData.index + 1] = didChange;
          previousData.didChange = true;
        }
        previousData.index = index + 2;
        if (child.children.length) {
          checkChildrenDidChange(child, previousData);
        }
      }
      return previousData.didChange;
    }

    "use strict";
    const tempMatrix$5 = new Matrix();
    const measureMixin = {
      _localBoundsCacheId: -1,
      _localBoundsCacheData: null,
      _setWidth(value, localWidth) {
        const sign = Math.sign(this.scale.x) || 1;
        if (localWidth !== 0) {
          this.scale.x = value / localWidth * sign;
        } else {
          this.scale.x = sign;
        }
      },
      _setHeight(value, localHeight) {
        const sign = Math.sign(this.scale.y) || 1;
        if (localHeight !== 0) {
          this.scale.y = value / localHeight * sign;
        } else {
          this.scale.y = sign;
        }
      },
      /**
       * Retrieves the local bounds of the container as a Bounds object.
       * @returns - The bounding area.
       * @memberof scene.Container#
       */
      getLocalBounds() {
        if (!this._localBoundsCacheData) {
          this._localBoundsCacheData = {
            data: [],
            index: 1,
            didChange: false,
            localBounds: new Bounds()
          };
        }
        const localBoundsCacheData = this._localBoundsCacheData;
        localBoundsCacheData.index = 1;
        localBoundsCacheData.didChange = false;
        if (localBoundsCacheData.data[0] !== this._didViewChangeTick) {
          localBoundsCacheData.didChange = true;
          localBoundsCacheData.data[0] = this._didViewChangeTick;
        }
        checkChildrenDidChange(this, localBoundsCacheData);
        if (localBoundsCacheData.didChange) {
          getLocalBounds(this, localBoundsCacheData.localBounds, tempMatrix$5);
        }
        return localBoundsCacheData.localBounds;
      },
      /**
       * Calculates and returns the (world) bounds of the display object as a [Rectangle]{@link Rectangle}.
       * @param skipUpdate - Setting to `true` will stop the transforms of the scene graph from
       *  being updated. This means the calculation returned MAY be out of date BUT will give you a
       *  nice performance boost.
       * @param bounds - Optional bounds to store the result of the bounds calculation.
       * @returns - The minimum axis-aligned rectangle in world space that fits around this object.
       * @memberof scene.Container#
       */
      getBounds(skipUpdate, bounds) {
        return getGlobalBounds(this, skipUpdate, bounds || new Bounds());
      }
    };

    "use strict";
    const onRenderMixin = {
      _onRender: null,
      set onRender(func) {
        const renderGroup = this.renderGroup || this.parentRenderGroup;
        if (!func) {
          if (this._onRender) {
            renderGroup == null ? void 0 : renderGroup.removeOnRender(this);
          }
          this._onRender = null;
          return;
        }
        if (!this._onRender) {
          renderGroup == null ? void 0 : renderGroup.addOnRender(this);
        }
        this._onRender = func;
      },
      /**
       * This callback is used when the container is rendered. This is where you should add your custom
       * logic that is needed to be run every frame.
       *
       * In v7 many users used `updateTransform` for this, however the way v8 renders objects is different
       * and "updateTransform" is no longer called every frame
       * @example
       * const container = new Container();
       * container.onRender = () => {
       *    container.rotation += 0.01;
       * };
       * @memberof scene.Container#
       */
      get onRender() {
        return this._onRender;
      }
    };

    "use strict";
    const sortMixin = {
      _zIndex: 0,
      /**
       * Should children be sorted by zIndex at the next render call.
       *
       * Will get automatically set to true if a new child is added, or if a child's zIndex changes.
       * @type {boolean}
       * @memberof scene.Container#
       */
      sortDirty: false,
      /**
       * If set to true, the container will sort its children by `zIndex` value
       * when the next render is called, or manually if `sortChildren()` is called.
       *
       * This actually changes the order of elements in the array, so should be treated
       * as a basic solution that is not performant compared to other solutions,
       * such as {@link https://github.com/pixijs/layers PixiJS Layers}
       *
       * Also be aware of that this may not work nicely with the `addChildAt()` function,
       * as the `zIndex` sorting may cause the child to automatically sorted to another position.
       * @type {boolean}
       * @memberof scene.Container#
       */
      sortableChildren: false,
      /**
       * The zIndex of the container.
       *
       * Setting this value, will automatically set the parent to be sortable. Children will be automatically
       * sorted by zIndex value; a higher value will mean it will be moved towards the end of the array,
       * and thus rendered on top of other display objects within the same container.
       * @see scene.Container#sortableChildren
       * @memberof scene.Container#
       */
      get zIndex() {
        return this._zIndex;
      },
      set zIndex(value) {
        if (this._zIndex === value)
          return;
        this._zIndex = value;
        this.depthOfChildModified();
      },
      depthOfChildModified() {
        if (this.parent) {
          this.parent.sortableChildren = true;
          this.parent.sortDirty = true;
        }
        if (this.parentRenderGroup) {
          this.parentRenderGroup.structureDidChange = true;
        }
      },
      /**
       * Sorts children by zIndex.
       * @memberof scene.Container#
       */
      sortChildren() {
        if (!this.sortDirty)
          return;
        this.sortDirty = false;
        this.children.sort(sortChildren);
      }
    };
    function sortChildren(a, b) {
      return a._zIndex - b._zIndex;
    }

    "use strict";
    const toLocalGlobalMixin = {
      /**
       * Returns the global position of the container.
       * @param point - The optional point to write the global value to.
       * @param skipUpdate - Should we skip the update transform.
       * @returns - The updated point.
       * @memberof scene.Container#
       */
      getGlobalPosition(point = new Point(), skipUpdate = false) {
        if (this.parent) {
          this.parent.toGlobal(this._position, point, skipUpdate);
        } else {
          point.x = this._position.x;
          point.y = this._position.y;
        }
        return point;
      },
      /**
       * Calculates the global position of the container.
       * @param position - The world origin to calculate from.
       * @param point - A Point object in which to store the value, optional
       *  (otherwise will create a new Point).
       * @param skipUpdate - Should we skip the update transform.
       * @returns - A point object representing the position of this object.
       * @memberof scene.Container#
       */
      toGlobal(position, point, skipUpdate = false) {
        const globalMatrix = this.getGlobalTransform(matrixPool.get(), skipUpdate);
        point = globalMatrix.apply(position, point);
        matrixPool.return(globalMatrix);
        return point;
      },
      /**
       * Calculates the local position of the container relative to another point.
       * @param position - The world origin to calculate from.
       * @param from - The Container to calculate the global position from.
       * @param point - A Point object in which to store the value, optional
       *  (otherwise will create a new Point).
       * @param skipUpdate - Should we skip the update transform
       * @returns - A point object representing the position of this object
       * @memberof scene.Container#
       */
      toLocal(position, from, point, skipUpdate) {
        if (from) {
          position = from.toGlobal(position, point, skipUpdate);
        }
        const globalMatrix = this.getGlobalTransform(matrixPool.get(), skipUpdate);
        point = globalMatrix.applyInverse(position, point);
        matrixPool.return(globalMatrix);
        return point;
      }
    };

    "use strict";
    let _tick = 0;
    class InstructionSet {
      constructor() {
        /** a unique id for this instruction set used through the renderer */
        this.uid = uid$1("instructionSet");
        /** the array of instructions */
        this.instructions = [];
        /** the actual size of the array (any instructions passed this should be ignored) */
        this.instructionSize = 0;
        this.renderables = [];
        this.tick = 0;
      }
      /** reset the instruction set so it can be reused set size back to 0 */
      reset() {
        this.instructionSize = 0;
        this.tick = _tick++;
      }
      /**
       * Add an instruction to the set
       * @param instruction - add an instruction to the set
       */
      add(instruction) {
        this.instructions[this.instructionSize++] = instruction;
      }
      /**
       * Log the instructions to the console (for debugging)
       * @internal
       * @ignore
       */
      log() {
        this.instructions.length = this.instructionSize;
        console.table(this.instructions, ["type", "action"]);
      }
    }

    "use strict";
    var __defProp$11 = Object.defineProperty;
    var __defProps$p = Object.defineProperties;
    var __getOwnPropDescs$p = Object.getOwnPropertyDescriptors;
    var __getOwnPropSymbols$11 = Object.getOwnPropertySymbols;
    var __hasOwnProp$11 = Object.prototype.hasOwnProperty;
    var __propIsEnum$11 = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$11 = (obj, key, value) => key in obj ? __defProp$11(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$11 = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$11.call(b, prop))
          __defNormalProp$11(a, prop, b[prop]);
      if (__getOwnPropSymbols$11)
        for (var prop of __getOwnPropSymbols$11(b)) {
          if (__propIsEnum$11.call(b, prop))
            __defNormalProp$11(a, prop, b[prop]);
        }
      return a;
    };
    var __spreadProps$p = (a, b) => __defProps$p(a, __getOwnPropDescs$p(b));
    let count = 0;
    class TexturePoolClass {
      /**
       * @param textureOptions - options that will be passed to BaseRenderTexture constructor
       * @param {SCALE_MODE} [textureOptions.scaleMode] - See {@link SCALE_MODE} for possible values.
       */
      constructor(textureOptions) {
        this._poolKeyHash = /* @__PURE__ */ Object.create(null);
        this._texturePool = {};
        this.textureOptions = textureOptions || {};
        this.enableFullScreen = false;
      }
      /**
       * Creates texture with params that were specified in pool constructor.
       * @param pixelWidth - Width of texture in pixels.
       * @param pixelHeight - Height of texture in pixels.
       * @param antialias
       */
      createTexture(pixelWidth, pixelHeight, antialias) {
        const textureSource = new TextureSource(__spreadProps$p(__spreadValues$11({}, this.textureOptions), {
          width: pixelWidth,
          height: pixelHeight,
          resolution: 1,
          antialias,
          autoGarbageCollect: true
        }));
        return new Texture({
          source: textureSource,
          label: `texturePool_${count++}`
        });
      }
      /**
       * Gets a Power-of-Two render texture or fullScreen texture
       * @param frameWidth - The minimum width of the render texture.
       * @param frameHeight - The minimum height of the render texture.
       * @param resolution - The resolution of the render texture.
       * @param antialias
       * @returns The new render texture.
       */
      getOptimalTexture(frameWidth, frameHeight, resolution = 1, antialias) {
        let po2Width = Math.ceil(frameWidth * resolution - 1e-6);
        let po2Height = Math.ceil(frameHeight * resolution - 1e-6);
        po2Width = nextPow2(po2Width);
        po2Height = nextPow2(po2Height);
        const key = (po2Width << 17) + (po2Height << 1) + (antialias ? 1 : 0);
        if (!this._texturePool[key]) {
          this._texturePool[key] = [];
        }
        let texture = this._texturePool[key].pop();
        if (!texture) {
          texture = this.createTexture(po2Width, po2Height, antialias);
        }
        texture.source._resolution = resolution;
        texture.source.width = po2Width / resolution;
        texture.source.height = po2Height / resolution;
        texture.source.pixelWidth = po2Width;
        texture.source.pixelHeight = po2Height;
        texture.frame.x = 0;
        texture.frame.y = 0;
        texture.frame.width = frameWidth;
        texture.frame.height = frameHeight;
        texture.updateUvs();
        this._poolKeyHash[texture.uid] = key;
        return texture;
      }
      /**
       * Gets extra texture of the same size as input renderTexture
       * @param texture - The texture to check what size it is.
       * @param antialias - Whether to use antialias.
       * @returns A texture that is a power of two
       */
      getSameSizeTexture(texture, antialias = false) {
        const source = texture.source;
        return this.getOptimalTexture(texture.width, texture.height, source._resolution, antialias);
      }
      /**
       * Place a render texture back into the pool.
       * @param renderTexture - The renderTexture to free
       */
      returnTexture(renderTexture) {
        const key = this._poolKeyHash[renderTexture.uid];
        this._texturePool[key].push(renderTexture);
      }
      /**
       * Clears the pool.
       * @param destroyTextures - Destroy all stored textures.
       */
      clear(destroyTextures) {
        destroyTextures = destroyTextures !== false;
        if (destroyTextures) {
          for (const i in this._texturePool) {
            const textures = this._texturePool[i];
            if (textures) {
              for (let j = 0; j < textures.length; j++) {
                textures[j].destroy(true);
              }
            }
          }
        }
        this._texturePool = {};
      }
    }
    const TexturePool = new TexturePoolClass();

    "use strict";
    class RenderGroup {
      constructor() {
        this.renderPipeId = "renderGroup";
        this.root = null;
        this.canBundle = false;
        this.renderGroupParent = null;
        this.renderGroupChildren = [];
        this.worldTransform = new Matrix();
        this.worldColorAlpha = 4294967295;
        this.worldColor = 16777215;
        this.worldAlpha = 1;
        // these updates are transform changes..
        this.childrenToUpdate = /* @__PURE__ */ Object.create(null);
        this.updateTick = 0;
        // these update are renderable changes..
        this.childrenRenderablesToUpdate = { list: [], index: 0 };
        // other
        this.structureDidChange = true;
        this.instructionSet = new InstructionSet();
        this._onRenderContainers = [];
        /**
         * Indicates if the cached texture needs to be updated.
         * @default true
         */
        this.textureNeedsUpdate = true;
        /**
         * Indicates if the container should be cached as a texture.
         * @default false
         */
        this.isCachedAsTexture = false;
        this._matrixDirty = 7;
      }
      init(root) {
        this.root = root;
        if (root._onRender)
          this.addOnRender(root);
        root.didChange = true;
        const children = root.children;
        for (let i = 0; i < children.length; i++) {
          this.addChild(children[i]);
        }
      }
      enableCacheAsTexture(options = {}) {
        this.textureOptions = options;
        this.isCachedAsTexture = true;
        this.textureNeedsUpdate = true;
      }
      disableCacheAsTexture() {
        this.isCachedAsTexture = false;
        if (this.texture) {
          TexturePool.returnTexture(this.texture);
          this.texture = null;
        }
      }
      updateCacheTexture() {
        this.textureNeedsUpdate = true;
      }
      reset() {
        this.renderGroupChildren.length = 0;
        for (const i in this.childrenToUpdate) {
          const childrenAtDepth = this.childrenToUpdate[i];
          childrenAtDepth.list.fill(null);
          childrenAtDepth.index = 0;
        }
        this.childrenRenderablesToUpdate.index = 0;
        this.childrenRenderablesToUpdate.list.fill(null);
        this.root = null;
        this.updateTick = 0;
        this.structureDidChange = true;
        this._onRenderContainers.length = 0;
        this.renderGroupParent = null;
        this.disableCacheAsTexture();
      }
      get localTransform() {
        return this.root.localTransform;
      }
      addRenderGroupChild(renderGroupChild) {
        if (renderGroupChild.renderGroupParent) {
          renderGroupChild.renderGroupParent._removeRenderGroupChild(renderGroupChild);
        }
        renderGroupChild.renderGroupParent = this;
        this.renderGroupChildren.push(renderGroupChild);
      }
      _removeRenderGroupChild(renderGroupChild) {
        const index = this.renderGroupChildren.indexOf(renderGroupChild);
        if (index > -1) {
          this.renderGroupChildren.splice(index, 1);
        }
        renderGroupChild.renderGroupParent = null;
      }
      addChild(child) {
        this.structureDidChange = true;
        child.parentRenderGroup = this;
        child.updateTick = -1;
        if (child.parent === this.root) {
          child.relativeRenderGroupDepth = 1;
        } else {
          child.relativeRenderGroupDepth = child.parent.relativeRenderGroupDepth + 1;
        }
        child.didChange = true;
        this.onChildUpdate(child);
        if (child.renderGroup) {
          this.addRenderGroupChild(child.renderGroup);
          return;
        }
        if (child._onRender)
          this.addOnRender(child);
        const children = child.children;
        for (let i = 0; i < children.length; i++) {
          this.addChild(children[i]);
        }
      }
      removeChild(child) {
        this.structureDidChange = true;
        if (child._onRender) {
          if (!child.renderGroup) {
            this.removeOnRender(child);
          }
        }
        child.parentRenderGroup = null;
        if (child.renderGroup) {
          this._removeRenderGroupChild(child.renderGroup);
          return;
        }
        const children = child.children;
        for (let i = 0; i < children.length; i++) {
          this.removeChild(children[i]);
        }
      }
      removeChildren(children) {
        for (let i = 0; i < children.length; i++) {
          this.removeChild(children[i]);
        }
      }
      onChildUpdate(child) {
        let childrenToUpdate = this.childrenToUpdate[child.relativeRenderGroupDepth];
        if (!childrenToUpdate) {
          childrenToUpdate = this.childrenToUpdate[child.relativeRenderGroupDepth] = {
            index: 0,
            list: []
          };
        }
        childrenToUpdate.list[childrenToUpdate.index++] = child;
      }
      updateRenderable(renderable) {
        if (renderable.globalDisplayStatus < 7)
          return;
        this.instructionSet.renderPipes[renderable.renderPipeId].updateRenderable(renderable);
        renderable.didViewUpdate = false;
      }
      onChildViewUpdate(child) {
        this.childrenRenderablesToUpdate.list[this.childrenRenderablesToUpdate.index++] = child;
      }
      get isRenderable() {
        return this.root.localDisplayStatus === 7 && this.worldAlpha > 0;
      }
      /**
       * adding a container to the onRender list will make sure the user function
       * passed in to the user defined 'onRender` callBack
       * @param container - the container to add to the onRender list
       */
      addOnRender(container) {
        this._onRenderContainers.push(container);
      }
      removeOnRender(container) {
        this._onRenderContainers.splice(this._onRenderContainers.indexOf(container), 1);
      }
      runOnRender() {
        for (let i = 0; i < this._onRenderContainers.length; i++) {
          this._onRenderContainers[i]._onRender();
        }
      }
      destroy() {
        this.disableCacheAsTexture();
        this.renderGroupParent = null;
        this.root = null;
        this.childrenRenderablesToUpdate = null;
        this.childrenToUpdate = null;
        this.renderGroupChildren = null;
        this._onRenderContainers = null;
        this.instructionSet = null;
      }
      getChildren(out = []) {
        const children = this.root.children;
        for (let i = 0; i < children.length; i++) {
          this._getChildren(children[i], out);
        }
        return out;
      }
      _getChildren(container, out = []) {
        out.push(container);
        if (container.renderGroup)
          return out;
        const children = container.children;
        for (let i = 0; i < children.length; i++) {
          this._getChildren(children[i], out);
        }
        return out;
      }
      invalidateMatrices() {
        this._matrixDirty = 7;
      }
      /**
       * Returns the inverse of the world transform matrix.
       * @returns {Matrix} The inverse of the world transform matrix.
       */
      get inverseWorldTransform() {
        if ((this._matrixDirty & 1) === 0)
          return this._inverseWorldTransform;
        this._matrixDirty &= ~1;
        this._inverseWorldTransform || (this._inverseWorldTransform = new Matrix());
        return this._inverseWorldTransform.copyFrom(this.worldTransform).invert();
      }
      /**
       * Returns the inverse of the texture offset transform matrix.
       * @returns {Matrix} The inverse of the texture offset transform matrix.
       */
      get textureOffsetInverseTransform() {
        if ((this._matrixDirty & 2) === 0)
          return this._textureOffsetInverseTransform;
        this._matrixDirty &= ~2;
        this._textureOffsetInverseTransform || (this._textureOffsetInverseTransform = new Matrix());
        return this._textureOffsetInverseTransform.copyFrom(this.inverseWorldTransform).translate(
          -this._textureBounds.x,
          -this._textureBounds.y
        );
      }
      /**
       * Returns the inverse of the parent texture transform matrix.
       * This is used to properly transform coordinates when rendering into cached textures.
       * @returns {Matrix} The inverse of the parent texture transform matrix.
       */
      get inverseParentTextureTransform() {
        if ((this._matrixDirty & 4) === 0)
          return this._inverseParentTextureTransform;
        this._matrixDirty &= ~4;
        const parentCacheAsTexture = this._parentCacheAsTextureRenderGroup;
        if (parentCacheAsTexture) {
          this._inverseParentTextureTransform || (this._inverseParentTextureTransform = new Matrix());
          return this._inverseParentTextureTransform.copyFrom(this.worldTransform).prepend(parentCacheAsTexture.inverseWorldTransform).translate(
            -parentCacheAsTexture._textureBounds.x,
            -parentCacheAsTexture._textureBounds.y
          );
        }
        return this.worldTransform;
      }
      /**
       * Returns a matrix that transforms coordinates to the correct coordinate space of the texture being rendered to.
       * This is the texture offset inverse transform of the closest parent RenderGroup that is cached as a texture.
       * @returns {Matrix | null} The transform matrix for the cached texture coordinate space,
       * or null if no parent is cached as texture.
       */
      get cacheToLocalTransform() {
        if (!this._parentCacheAsTextureRenderGroup)
          return null;
        return this._parentCacheAsTextureRenderGroup.textureOffsetInverseTransform;
      }
    }

    "use strict";
    function assignWithIgnore(target, options, ignore = {}) {
      for (const key in options) {
        if (!ignore[key] && options[key] !== void 0) {
          target[key] = options[key];
        }
      }
    }

    "use strict";
    const defaultSkew = new ObservablePoint(null);
    const defaultPivot = new ObservablePoint(null);
    const defaultScale = new ObservablePoint(null, 1, 1);
    const UPDATE_COLOR = 1;
    const UPDATE_BLEND = 2;
    const UPDATE_VISIBLE = 4;
    const UPDATE_TRANSFORM = 8;
    class Container extends EventEmitter {
      constructor(options = {}) {
        var _a, _b;
        super();
        /** unique id for this container */
        this.uid = uid$1("renderable");
        /** @private */
        this._updateFlags = 15;
        // the render group this container owns
        /** @private */
        this.renderGroup = null;
        // the render group this container belongs to
        /** @private */
        this.parentRenderGroup = null;
        // the index of the container in the render group
        /** @private */
        this.parentRenderGroupIndex = 0;
        // set to true if the container has changed. It is reset once the changes have been applied
        // by the transform system
        // its here to stop ensure that when things change, only one update gets registers with the transform system
        /** @private */
        this.didChange = false;
        // same as above, but for the renderable
        /** @private */
        this.didViewUpdate = false;
        // how deep is the container relative to its render group..
        // unless the element is the root render group - it will be relative to its parent
        /** @private */
        this.relativeRenderGroupDepth = 0;
        /**
         * The array of children of this container.
         * @readonly
         */
        this.children = [];
        /** The display object container that contains this display object. */
        this.parent = null;
        // used internally for changing up the render order.. mainly for masks and filters
        // TODO setting this should cause a rebuild??
        /** @private */
        this.includeInBuild = true;
        /** @private */
        this.measurable = true;
        /** @private */
        this.isSimple = true;
        // / /////////////Transform related props//////////////
        // used by the transform system to check if a container needs to be updated that frame
        // if the tick matches the current transform system tick, it is not updated again
        /**
         * @internal
         * @ignore
         */
        this.updateTick = -1;
        /**
         * Current transform of the object based on local factors: position, scale, other stuff.
         * @readonly
         */
        this.localTransform = new Matrix();
        /**
         * The relative group transform is a transform relative to the render group it belongs too. It will include all parent
         * transforms and up to the render group (think of it as kind of like a stage - but the stage can be nested).
         * If this container is is self a render group matrix will be relative to its parent render group
         * @readonly
         */
        this.relativeGroupTransform = new Matrix();
        /**
         * The group transform is a transform relative to the render group it belongs too.
         * If this container is render group then this will be an identity matrix. other wise it
         * will be the same as the relativeGroupTransform.
         * Use this value when actually rendering things to the screen
         * @readonly
         */
        this.groupTransform = this.relativeGroupTransform;
        /** If the object has been destroyed via destroy(). If true, it should not be used. */
        this.destroyed = false;
        // transform data..
        /**
         * The coordinate of the object relative to the local coordinates of the parent.
         * @internal
         * @ignore
         */
        this._position = new ObservablePoint(this, 0, 0);
        /**
         * The scale factor of the object.
         * @internal
         * @ignore
         */
        this._scale = defaultScale;
        /**
         * The pivot point of the container that it rotates around.
         * @internal
         * @ignore
         */
        this._pivot = defaultPivot;
        /**
         * The skew amount, on the x and y axis.
         * @internal
         * @ignore
         */
        this._skew = defaultSkew;
        /**
         * The X-coordinate value of the normalized local X axis,
         * the first column of the local transformation matrix without a scale.
         * @internal
         * @ignore
         */
        this._cx = 1;
        /**
         * The Y-coordinate value of the normalized local X axis,
         * the first column of the local transformation matrix without a scale.
         * @internal
         * @ignore
         */
        this._sx = 0;
        /**
         * The X-coordinate value of the normalized local Y axis,
         * the second column of the local transformation matrix without a scale.
         * @internal
         * @ignore
         */
        this._cy = 0;
        /**
         * The Y-coordinate value of the normalized local Y axis,
         * the second column of the local transformation matrix without a scale.
         * @internal
         * @ignore
         */
        this._sy = 1;
        /**
         * The rotation amount.
         * @internal
         * @ignore
         */
        this._rotation = 0;
        // / COLOR related props //////////////
        // color stored as ABGR
        this.localColor = 16777215;
        this.localAlpha = 1;
        this.groupAlpha = 1;
        // A
        this.groupColor = 16777215;
        // BGR
        this.groupColorAlpha = 4294967295;
        // ABGR
        // / BLEND related props //////////////
        /**
         * @internal
         * @ignore
         */
        this.localBlendMode = "inherit";
        /**
         * @internal
         * @ignore
         */
        this.groupBlendMode = "normal";
        // / VISIBILITY related props //////////////
        // visibility
        // 0b11
        // first bit is visible, second bit is renderable
        /**
         * This property holds three bits: culled, visible, renderable
         * the third bit represents culling (0 = culled, 1 = not culled) 0b100
         * the second bit represents visibility (0 = not visible, 1 = visible) 0b010
         * the first bit represents renderable (0 = not renderable, 1 = renderable) 0b001
         * @internal
         * @ignore
         */
        this.localDisplayStatus = 7;
        // 0b11 | 0b10 | 0b01 | 0b00
        /**
         * @internal
         * @ignore
         */
        this.globalDisplayStatus = 7;
        /**
         * A value that increments each time the containe is modified
         * eg children added, removed etc
         * @ignore
         */
        this._didContainerChangeTick = 0;
        /**
         * A value that increments each time the container view is modified
         * eg texture swap, geometry change etc
         * @ignore
         */
        this._didViewChangeTick = 0;
        /**
         * property that tracks if the container transform has changed
         * @ignore
         */
        this._didLocalTransformChangeId = -1;
        this.effects = [];
        assignWithIgnore(this, options, {
          children: true,
          parent: true,
          effects: true
        });
        (_a = options.children) == null ? void 0 : _a.forEach((child) => this.addChild(child));
        (_b = options.parent) == null ? void 0 : _b.addChild(this);
      }
      /**
       * Mixes all enumerable properties and methods from a source object to Container.
       * @param source - The source of properties and methods to mix in.
       */
      static mixin(source) {
        Object.defineProperties(Container.prototype, Object.getOwnPropertyDescriptors(source));
      }
      /**
       * We now use the _didContainerChangeTick and _didViewChangeTick to track changes
       * @deprecated since 8.2.6
       * @ignore
       */
      set _didChangeId(value) {
        this._didViewChangeTick = value >> 12 & 4095;
        this._didContainerChangeTick = value & 4095;
      }
      get _didChangeId() {
        return this._didContainerChangeTick & 4095 | (this._didViewChangeTick & 4095) << 12;
      }
      /**
       * Adds one or more children to the container.
       *
       * Multiple items can be added like so: `myContainer.addChild(thingOne, thingTwo, thingThree)`
       * @param {...Container} children - The Container(s) to add to the container
       * @returns {Container} - The first child that was added.
       */
      addChild(...children) {
        if (!this.allowChildren) {
          deprecation(v8_0_0, "addChild: Only Containers will be allowed to add children in v8.0.0");
        }
        if (children.length > 1) {
          for (let i = 0; i < children.length; i++) {
            this.addChild(children[i]);
          }
          return children[0];
        }
        const child = children[0];
        const renderGroup = this.renderGroup || this.parentRenderGroup;
        if (child.parent === this) {
          this.children.splice(this.children.indexOf(child), 1);
          this.children.push(child);
          if (renderGroup) {
            renderGroup.structureDidChange = true;
          }
          return child;
        }
        if (child.parent) {
          child.parent.removeChild(child);
        }
        this.children.push(child);
        if (this.sortableChildren)
          this.sortDirty = true;
        child.parent = this;
        child.didChange = true;
        child._updateFlags = 15;
        if (renderGroup) {
          renderGroup.addChild(child);
        }
        this.emit("childAdded", child, this, this.children.length - 1);
        child.emit("added", this);
        this._didViewChangeTick++;
        if (child._zIndex !== 0) {
          child.depthOfChildModified();
        }
        return child;
      }
      /**
       * Removes one or more children from the container.
       * @param {...Container} children - The Container(s) to remove
       * @returns {Container} The first child that was removed.
       */
      removeChild(...children) {
        if (children.length > 1) {
          for (let i = 0; i < children.length; i++) {
            this.removeChild(children[i]);
          }
          return children[0];
        }
        const child = children[0];
        const index = this.children.indexOf(child);
        if (index > -1) {
          this._didViewChangeTick++;
          this.children.splice(index, 1);
          if (this.renderGroup) {
            this.renderGroup.removeChild(child);
          } else if (this.parentRenderGroup) {
            this.parentRenderGroup.removeChild(child);
          }
          child.parent = null;
          this.emit("childRemoved", child, this, index);
          child.emit("removed", this);
        }
        return child;
      }
      /** @ignore */
      _onUpdate(point) {
        if (point) {
          if (point === this._skew) {
            this._updateSkew();
          }
        }
        this._didContainerChangeTick++;
        if (this.didChange)
          return;
        this.didChange = true;
        if (this.parentRenderGroup) {
          this.parentRenderGroup.onChildUpdate(this);
        }
      }
      set isRenderGroup(value) {
        if (!!this.renderGroup === value)
          return;
        if (value) {
          this.enableRenderGroup();
        } else {
          this.disableRenderGroup();
        }
      }
      /**
       * Returns true if this container is a render group.
       * This means that it will be rendered as a separate pass, with its own set of instructions
       */
      get isRenderGroup() {
        return !!this.renderGroup;
      }
      /**
       * Calling this enables a render group for this container.
       * This means it will be rendered as a separate set of instructions.
       * The transform of the container will also be handled on the GPU rather than the CPU.
       */
      enableRenderGroup() {
        if (this.renderGroup)
          return;
        const parentRenderGroup = this.parentRenderGroup;
        parentRenderGroup == null ? void 0 : parentRenderGroup.removeChild(this);
        this.renderGroup = BigPool.get(RenderGroup, this);
        this.groupTransform = Matrix.IDENTITY;
        parentRenderGroup == null ? void 0 : parentRenderGroup.addChild(this);
        this._updateIsSimple();
      }
      /** This will disable the render group for this container. */
      disableRenderGroup() {
        if (!this.renderGroup)
          return;
        const parentRenderGroup = this.parentRenderGroup;
        parentRenderGroup == null ? void 0 : parentRenderGroup.removeChild(this);
        BigPool.return(this.renderGroup);
        this.renderGroup = null;
        this.groupTransform = this.relativeGroupTransform;
        parentRenderGroup == null ? void 0 : parentRenderGroup.addChild(this);
        this._updateIsSimple();
      }
      /** @ignore */
      _updateIsSimple() {
        this.isSimple = !this.renderGroup && this.effects.length === 0;
      }
      /**
       * Current transform of the object based on world (parent) factors.
       * @readonly
       */
      get worldTransform() {
        this._worldTransform || (this._worldTransform = new Matrix());
        if (this.renderGroup) {
          this._worldTransform.copyFrom(this.renderGroup.worldTransform);
        } else if (this.parentRenderGroup) {
          this._worldTransform.appendFrom(this.relativeGroupTransform, this.parentRenderGroup.worldTransform);
        }
        return this._worldTransform;
      }
      /**
       * The position of the container on the x axis relative to the local coordinates of the parent.
       * An alias to position.x
       */
      get x() {
        return this._position.x;
      }
      set x(value) {
        this._position.x = value;
      }
      /**
       * The position of the container on the y axis relative to the local coordinates of the parent.
       * An alias to position.y
       */
      get y() {
        return this._position.y;
      }
      set y(value) {
        this._position.y = value;
      }
      /**
       * The coordinate of the object relative to the local coordinates of the parent.
       * @since 4.0.0
       */
      get position() {
        return this._position;
      }
      set position(value) {
        this._position.copyFrom(value);
      }
      /**
       * The rotation of the object in radians.
       * 'rotation' and 'angle' have the same effect on a display object; rotation is in radians, angle is in degrees.
       */
      get rotation() {
        return this._rotation;
      }
      set rotation(value) {
        if (this._rotation !== value) {
          this._rotation = value;
          this._onUpdate(this._skew);
        }
      }
      /**
       * The angle of the object in degrees.
       * 'rotation' and 'angle' have the same effect on a display object; rotation is in radians, angle is in degrees.
       */
      get angle() {
        return this.rotation * RAD_TO_DEG;
      }
      set angle(value) {
        this.rotation = value * DEG_TO_RAD;
      }
      /**
       * The center of rotation, scaling, and skewing for this display object in its local space. The `position`
       * is the projection of `pivot` in the parent's local space.
       *
       * By default, the pivot is the origin (0, 0).
       * @since 4.0.0
       */
      get pivot() {
        if (this._pivot === defaultPivot) {
          this._pivot = new ObservablePoint(this, 0, 0);
        }
        return this._pivot;
      }
      set pivot(value) {
        if (this._pivot === defaultPivot) {
          this._pivot = new ObservablePoint(this, 0, 0);
        }
        typeof value === "number" ? this._pivot.set(value) : this._pivot.copyFrom(value);
      }
      /**
       * The skew factor for the object in radians.
       * @since 4.0.0
       */
      get skew() {
        if (this._skew === defaultSkew) {
          this._skew = new ObservablePoint(this, 0, 0);
        }
        return this._skew;
      }
      set skew(value) {
        if (this._skew === defaultSkew) {
          this._skew = new ObservablePoint(this, 0, 0);
        }
        this._skew.copyFrom(value);
      }
      /**
       * The scale factors of this object along the local coordinate axes.
       *
       * The default scale is (1, 1).
       * @since 4.0.0
       */
      get scale() {
        if (this._scale === defaultScale) {
          this._scale = new ObservablePoint(this, 1, 1);
        }
        return this._scale;
      }
      set scale(value) {
        if (this._scale === defaultScale) {
          this._scale = new ObservablePoint(this, 0, 0);
        }
        typeof value === "number" ? this._scale.set(value) : this._scale.copyFrom(value);
      }
      /**
       * The width of the Container, setting this will actually modify the scale to achieve the value set.
       * @memberof scene.Container#
       */
      get width() {
        return Math.abs(this.scale.x * this.getLocalBounds().width);
      }
      set width(value) {
        const localWidth = this.getLocalBounds().width;
        this._setWidth(value, localWidth);
      }
      /**
       * The height of the Container, setting this will actually modify the scale to achieve the value set.
       * @memberof scene.Container#
       */
      get height() {
        return Math.abs(this.scale.y * this.getLocalBounds().height);
      }
      set height(value) {
        const localHeight = this.getLocalBounds().height;
        this._setHeight(value, localHeight);
      }
      /**
       * Retrieves the size of the container as a [Size]{@link Size} object.
       * This is faster than get the width and height separately.
       * @param out - Optional object to store the size in.
       * @returns - The size of the container.
       * @memberof scene.Container#
       */
      getSize(out) {
        if (!out) {
          out = {};
        }
        const bounds = this.getLocalBounds();
        out.width = Math.abs(this.scale.x * bounds.width);
        out.height = Math.abs(this.scale.y * bounds.height);
        return out;
      }
      /**
       * Sets the size of the container to the specified width and height.
       * This is faster than setting the width and height separately.
       * @param value - This can be either a number or a [Size]{@link Size} object.
       * @param height - The height to set. Defaults to the value of `width` if not provided.
       * @memberof scene.Container#
       */
      setSize(value, height) {
        var _a;
        const size = this.getLocalBounds();
        if (typeof value === "object") {
          height = (_a = value.height) != null ? _a : value.width;
          value = value.width;
        } else {
          height != null ? height : height = value;
        }
        value !== void 0 && this._setWidth(value, size.width);
        height !== void 0 && this._setHeight(height, size.height);
      }
      /** Called when the skew or the rotation changes. */
      _updateSkew() {
        const rotation = this._rotation;
        const skew = this._skew;
        this._cx = Math.cos(rotation + skew._y);
        this._sx = Math.sin(rotation + skew._y);
        this._cy = -Math.sin(rotation - skew._x);
        this._sy = Math.cos(rotation - skew._x);
      }
      /**
       * Updates the transform properties of the container (accepts partial values).
       * @param {object} opts - The options for updating the transform.
       * @param {number} opts.x - The x position of the container.
       * @param {number} opts.y - The y position of the container.
       * @param {number} opts.scaleX - The scale factor on the x-axis.
       * @param {number} opts.scaleY - The scale factor on the y-axis.
       * @param {number} opts.rotation - The rotation of the container, in radians.
       * @param {number} opts.skewX - The skew factor on the x-axis.
       * @param {number} opts.skewY - The skew factor on the y-axis.
       * @param {number} opts.pivotX - The x coordinate of the pivot point.
       * @param {number} opts.pivotY - The y coordinate of the pivot point.
       */
      updateTransform(opts) {
        this.position.set(
          typeof opts.x === "number" ? opts.x : this.position.x,
          typeof opts.y === "number" ? opts.y : this.position.y
        );
        this.scale.set(
          typeof opts.scaleX === "number" ? opts.scaleX || 1 : this.scale.x,
          typeof opts.scaleY === "number" ? opts.scaleY || 1 : this.scale.y
        );
        this.rotation = typeof opts.rotation === "number" ? opts.rotation : this.rotation;
        this.skew.set(
          typeof opts.skewX === "number" ? opts.skewX : this.skew.x,
          typeof opts.skewY === "number" ? opts.skewY : this.skew.y
        );
        this.pivot.set(
          typeof opts.pivotX === "number" ? opts.pivotX : this.pivot.x,
          typeof opts.pivotY === "number" ? opts.pivotY : this.pivot.y
        );
        return this;
      }
      /**
       * Updates the local transform using the given matrix.
       * @param matrix - The matrix to use for updating the transform.
       */
      setFromMatrix(matrix) {
        matrix.decompose(this);
      }
      /** Updates the local transform. */
      updateLocalTransform() {
        const localTransformChangeId = this._didContainerChangeTick;
        if (this._didLocalTransformChangeId === localTransformChangeId)
          return;
        this._didLocalTransformChangeId = localTransformChangeId;
        const lt = this.localTransform;
        const scale = this._scale;
        const pivot = this._pivot;
        const position = this._position;
        const sx = scale._x;
        const sy = scale._y;
        const px = pivot._x;
        const py = pivot._y;
        lt.a = this._cx * sx;
        lt.b = this._sx * sx;
        lt.c = this._cy * sy;
        lt.d = this._sy * sy;
        lt.tx = position._x - (px * lt.a + py * lt.c);
        lt.ty = position._y - (px * lt.b + py * lt.d);
      }
      // / ///// color related stuff
      set alpha(value) {
        if (value === this.localAlpha)
          return;
        this.localAlpha = value;
        this._updateFlags |= UPDATE_COLOR;
        this._onUpdate();
      }
      /** The opacity of the object. */
      get alpha() {
        return this.localAlpha;
      }
      set tint(value) {
        const tempColor = Color.shared.setValue(value != null ? value : 16777215);
        const bgr = tempColor.toBgrNumber();
        if (bgr === this.localColor)
          return;
        this.localColor = bgr;
        this._updateFlags |= UPDATE_COLOR;
        this._onUpdate();
      }
      /**
       * The tint applied to the sprite. This is a hex value.
       *
       * A value of 0xFFFFFF will remove any tint effect.
       * @default 0xFFFFFF
       */
      get tint() {
        return bgr2rgb(this.localColor);
      }
      // / //////////////// blend related stuff
      set blendMode(value) {
        if (this.localBlendMode === value)
          return;
        if (this.parentRenderGroup) {
          this.parentRenderGroup.structureDidChange = true;
        }
        this._updateFlags |= UPDATE_BLEND;
        this.localBlendMode = value;
        this._onUpdate();
      }
      /**
       * The blend mode to be applied to the sprite. Apply a value of `'normal'` to reset the blend mode.
       * @default 'normal'
       */
      get blendMode() {
        return this.localBlendMode;
      }
      // / ///////// VISIBILITY / RENDERABLE /////////////////
      /** The visibility of the object. If false the object will not be drawn, and the transform will not be updated. */
      get visible() {
        return !!(this.localDisplayStatus & 2);
      }
      set visible(value) {
        const valueNumber = value ? 2 : 0;
        if ((this.localDisplayStatus & 2) === valueNumber)
          return;
        if (this.parentRenderGroup) {
          this.parentRenderGroup.structureDidChange = true;
        }
        this._updateFlags |= UPDATE_VISIBLE;
        this.localDisplayStatus ^= 2;
        this._onUpdate();
      }
      /** @ignore */
      get culled() {
        return !(this.localDisplayStatus & 4);
      }
      /** @ignore */
      set culled(value) {
        const valueNumber = value ? 0 : 4;
        if ((this.localDisplayStatus & 4) === valueNumber)
          return;
        if (this.parentRenderGroup) {
          this.parentRenderGroup.structureDidChange = true;
        }
        this._updateFlags |= UPDATE_VISIBLE;
        this.localDisplayStatus ^= 4;
        this._onUpdate();
      }
      /** Can this object be rendered, if false the object will not be drawn but the transform will still be updated. */
      get renderable() {
        return !!(this.localDisplayStatus & 1);
      }
      set renderable(value) {
        const valueNumber = value ? 1 : 0;
        if ((this.localDisplayStatus & 1) === valueNumber)
          return;
        this._updateFlags |= UPDATE_VISIBLE;
        this.localDisplayStatus ^= 1;
        if (this.parentRenderGroup) {
          this.parentRenderGroup.structureDidChange = true;
        }
        this._onUpdate();
      }
      /** Whether or not the object should be rendered. */
      get isRenderable() {
        return this.localDisplayStatus === 7 && this.groupAlpha > 0;
      }
      /**
       * Removes all internal references and listeners as well as removes children from the display list.
       * Do not use a Container after calling `destroy`.
       * @param options - Options parameter. A boolean will act as if all options
       *  have been set to that value
       * @param {boolean} [options.children=false] - if set to true, all the children will have their destroy
       *  method called as well. 'options' will be passed on to those calls.
       * @param {boolean} [options.texture=false] - Only used for children with textures e.g. Sprites. If options.children
       * is set to true it should destroy the texture of the child sprite
       * @param {boolean} [options.textureSource=false] - Only used for children with textures e.g. Sprites.
       * If options.children is set to true it should destroy the texture source of the child sprite
       * @param {boolean} [options.context=false] - Only used for children with graphicsContexts e.g. Graphics.
       * If options.children is set to true it should destroy the context of the child graphics
       */
      destroy(options = false) {
        var _a;
        if (this.destroyed)
          return;
        this.destroyed = true;
        let oldChildren;
        if (this.children.length) {
          oldChildren = this.removeChildren(0, this.children.length);
        }
        this.removeFromParent();
        this.parent = null;
        this._maskEffect = null;
        this._filterEffect = null;
        this.effects = null;
        this._position = null;
        this._scale = null;
        this._pivot = null;
        this._skew = null;
        this.emit("destroyed", this);
        this.removeAllListeners();
        const destroyChildren = typeof options === "boolean" ? options : options == null ? void 0 : options.children;
        if (destroyChildren && oldChildren) {
          for (let i = 0; i < oldChildren.length; ++i) {
            oldChildren[i].destroy(options);
          }
        }
        (_a = this.renderGroup) == null ? void 0 : _a.destroy();
        this.renderGroup = null;
      }
    }
    Container.mixin(childrenHelperMixin);
    Container.mixin(toLocalGlobalMixin);
    Container.mixin(onRenderMixin);
    Container.mixin(measureMixin);
    Container.mixin(effectsMixin);
    Container.mixin(findMixin);
    Container.mixin(sortMixin);
    Container.mixin(cullingMixin);
    Container.mixin(cacheAsTextureMixin);
    Container.mixin(getGlobalMixin);

    "use strict";
    class ViewContainer extends Container {
      constructor() {
        super(...arguments);
        /** @private */
        this.canBundle = true;
        /** @private */
        this.allowChildren = false;
        /** @private */
        this._roundPixels = 0;
        /** @private */
        this._lastUsed = 0;
        /** @private */
        this._lastInstructionTick = -1;
        this._bounds = new Bounds(0, 1, 0, 0);
        this._boundsDirty = true;
      }
      /**
       * The local bounds of the view.
       * @type {rendering.Bounds}
       */
      get bounds() {
        if (!this._boundsDirty)
          return this._bounds;
        this.updateBounds();
        this._boundsDirty = false;
        return this._bounds;
      }
      /**
       * Whether or not to round the x/y position of the sprite.
       * @type {boolean}
       */
      get roundPixels() {
        return !!this._roundPixels;
      }
      set roundPixels(value) {
        this._roundPixels = value ? 1 : 0;
      }
      /**
       * Checks if the object contains the given point.
       * @param point - The point to check
       */
      containsPoint(point) {
        const bounds = this.bounds;
        const { x, y } = point;
        return x >= bounds.minX && x <= bounds.maxX && y >= bounds.minY && y <= bounds.maxY;
      }
      /** @private */
      onViewUpdate() {
        this._didViewChangeTick++;
        this._boundsDirty = true;
        if (this.didViewUpdate)
          return;
        this.didViewUpdate = true;
        const renderGroup = this.renderGroup || this.parentRenderGroup;
        if (renderGroup) {
          renderGroup.onChildViewUpdate(this);
        }
      }
      destroy(options) {
        super.destroy(options);
        this._bounds = null;
      }
    }

    "use strict";
    var __defProp$10 = Object.defineProperty;
    var __getOwnPropSymbols$10 = Object.getOwnPropertySymbols;
    var __hasOwnProp$10 = Object.prototype.hasOwnProperty;
    var __propIsEnum$10 = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$10 = (obj, key, value) => key in obj ? __defProp$10(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$10 = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$10.call(b, prop))
          __defNormalProp$10(a, prop, b[prop]);
      if (__getOwnPropSymbols$10)
        for (var prop of __getOwnPropSymbols$10(b)) {
          if (__propIsEnum$10.call(b, prop))
            __defNormalProp$10(a, prop, b[prop]);
        }
      return a;
    };
    var __objRest$l = (source, exclude) => {
      var target = {};
      for (var prop in source)
        if (__hasOwnProp$10.call(source, prop) && exclude.indexOf(prop) < 0)
          target[prop] = source[prop];
      if (source != null && __getOwnPropSymbols$10)
        for (var prop of __getOwnPropSymbols$10(source)) {
          if (exclude.indexOf(prop) < 0 && __propIsEnum$10.call(source, prop))
            target[prop] = source[prop];
        }
      return target;
    };
    class Sprite extends ViewContainer {
      /**
       * @param options - The options for creating the sprite.
       */
      constructor(options = Texture.EMPTY) {
        if (options instanceof Texture) {
          options = { texture: options };
        }
        const _a = options, { texture = Texture.EMPTY, anchor, roundPixels, width, height } = _a, rest = __objRest$l(_a, ["texture", "anchor", "roundPixels", "width", "height"]);
        super(__spreadValues$10({
          label: "Sprite"
        }, rest));
        this.renderPipeId = "sprite";
        this.batched = true;
        this._visualBounds = { minX: 0, maxX: 1, minY: 0, maxY: 0 };
        this._anchor = new ObservablePoint(
          {
            _onUpdate: () => {
              this.onViewUpdate();
            }
          }
        );
        if (anchor) {
          this.anchor = anchor;
        } else if (texture.defaultAnchor) {
          this.anchor = texture.defaultAnchor;
        }
        this.texture = texture;
        this.allowChildren = false;
        this.roundPixels = roundPixels != null ? roundPixels : false;
        if (width !== void 0)
          this.width = width;
        if (height !== void 0)
          this.height = height;
      }
      /**
       * Helper function that creates a new sprite based on the source you provide.
       * The source can be - frame id, image, video, canvas element, video element, texture
       * @param source - Source to create texture from
       * @param [skipCache] - Whether to skip the cache or not
       * @returns The newly created sprite
       */
      static from(source, skipCache = false) {
        if (source instanceof Texture) {
          return new Sprite(source);
        }
        return new Sprite(Texture.from(source, skipCache));
      }
      set texture(value) {
        value || (value = Texture.EMPTY);
        const currentTexture = this._texture;
        if (currentTexture === value)
          return;
        if (currentTexture && currentTexture.dynamic)
          currentTexture.off("update", this.onViewUpdate, this);
        if (value.dynamic)
          value.on("update", this.onViewUpdate, this);
        this._texture = value;
        if (this._width) {
          this._setWidth(this._width, this._texture.orig.width);
        }
        if (this._height) {
          this._setHeight(this._height, this._texture.orig.height);
        }
        this.onViewUpdate();
      }
      /** The texture that the sprite is using. */
      get texture() {
        return this._texture;
      }
      /**
       * The bounds of the sprite, taking the texture's trim into account.
       * @type {rendering.Bounds}
       */
      get visualBounds() {
        updateQuadBounds(this._visualBounds, this._anchor, this._texture, 0);
        return this._visualBounds;
      }
      /**
       * @deprecated
       */
      get sourceBounds() {
        deprecation("8.6.1", "Sprite.sourceBounds is deprecated, use visualBounds instead.");
        return this.visualBounds;
      }
      /** @private */
      updateBounds() {
        const anchor = this._anchor;
        const texture = this._texture;
        const bounds = this._bounds;
        const { width, height } = texture.orig;
        bounds.minX = -anchor._x * width;
        bounds.maxX = bounds.minX + width;
        bounds.minY = -anchor._y * height;
        bounds.maxY = bounds.minY + height;
      }
      /**
       * Destroys this sprite renderable and optionally its texture.
       * @param options - Options parameter. A boolean will act as if all options
       *  have been set to that value
       * @param {boolean} [options.texture=false] - Should it destroy the current texture of the renderable as well
       * @param {boolean} [options.textureSource=false] - Should it destroy the textureSource of the renderable as well
       */
      destroy(options = false) {
        super.destroy(options);
        const destroyTexture = typeof options === "boolean" ? options : options == null ? void 0 : options.texture;
        if (destroyTexture) {
          const destroyTextureSource = typeof options === "boolean" ? options : options == null ? void 0 : options.textureSource;
          this._texture.destroy(destroyTextureSource);
        }
        this._texture = null;
        this._visualBounds = null;
        this._bounds = null;
        this._anchor = null;
      }
      /**
       * The anchor sets the origin point of the sprite. The default value is taken from the {@link Texture}
       * and passed to the constructor.
       *
       * The default is `(0,0)`, this means the sprite's origin is the top left.
       *
       * Setting the anchor to `(0.5,0.5)` means the sprite's origin is centered.
       *
       * Setting the anchor to `(1,1)` would mean the sprite's origin point will be the bottom right corner.
       *
       * If you pass only single parameter, it will set both x and y to the same value as shown in the example below.
       * @example
       * import { Sprite } from 'pixi.js';
       *
       * const sprite = new Sprite({texture: Texture.WHITE});
       * sprite.anchor.set(0.5); // This will set the origin to center. (0.5) is same as (0.5, 0.5).
       */
      get anchor() {
        return this._anchor;
      }
      set anchor(value) {
        typeof value === "number" ? this._anchor.set(value) : this._anchor.copyFrom(value);
      }
      /** The width of the sprite, setting this will actually modify the scale to achieve the value set. */
      get width() {
        return Math.abs(this.scale.x) * this._texture.orig.width;
      }
      set width(value) {
        this._setWidth(value, this._texture.orig.width);
        this._width = value;
      }
      /** The height of the sprite, setting this will actually modify the scale to achieve the value set. */
      get height() {
        return Math.abs(this.scale.y) * this._texture.orig.height;
      }
      set height(value) {
        this._setHeight(value, this._texture.orig.height);
        this._height = value;
      }
      /**
       * Retrieves the size of the Sprite as a [Size]{@link Size} object.
       * This is faster than get the width and height separately.
       * @param out - Optional object to store the size in.
       * @returns - The size of the Sprite.
       */
      getSize(out) {
        out || (out = {});
        out.width = Math.abs(this.scale.x) * this._texture.orig.width;
        out.height = Math.abs(this.scale.y) * this._texture.orig.height;
        return out;
      }
      /**
       * Sets the size of the Sprite to the specified width and height.
       * This is faster than setting the width and height separately.
       * @param value - This can be either a number or a [Size]{@link Size} object.
       * @param height - The height to set. Defaults to the value of `width` if not provided.
       */
      setSize(value, height) {
        var _a;
        if (typeof value === "object") {
          height = (_a = value.height) != null ? _a : value.width;
          value = value.width;
        } else {
          height != null ? height : height = value;
        }
        value !== void 0 && this._setWidth(value, this._texture.orig.width);
        height !== void 0 && this._setHeight(height, this._texture.orig.height);
      }
    }

    "use strict";
    const tempBounds$4 = new Bounds();
    function addMaskBounds(mask, bounds, skipUpdateTransform) {
      const boundsToMask = tempBounds$4;
      mask.measurable = true;
      getGlobalBounds(mask, skipUpdateTransform, boundsToMask);
      bounds.addBoundsMask(boundsToMask);
      mask.measurable = false;
    }

    "use strict";
    function addMaskLocalBounds(mask, bounds, localRoot) {
      const boundsToMask = boundsPool.get();
      mask.measurable = true;
      const tempMatrix = matrixPool.get().identity();
      const relativeMask = getMatrixRelativeToParent(mask, localRoot, tempMatrix);
      getLocalBounds(mask, boundsToMask, relativeMask);
      mask.measurable = false;
      bounds.addBoundsMask(boundsToMask);
      matrixPool.return(tempMatrix);
      boundsPool.return(boundsToMask);
    }
    function getMatrixRelativeToParent(target, root, matrix) {
      if (!target) {
        warn("Mask bounds, renderable is not inside the root container");
        return matrix;
      }
      if (target !== root) {
        getMatrixRelativeToParent(target.parent, root, matrix);
        target.updateLocalTransform();
        matrix.append(target.localTransform);
      }
      return matrix;
    }

    "use strict";
    class AlphaMask {
      constructor(options) {
        this.priority = 0;
        this.inverse = false;
        this.pipe = "alphaMask";
        if (options == null ? void 0 : options.mask) {
          this.init(options.mask);
        }
      }
      init(mask) {
        this.mask = mask;
        this.renderMaskToTexture = !(mask instanceof Sprite);
        this.mask.renderable = this.renderMaskToTexture;
        this.mask.includeInBuild = !this.renderMaskToTexture;
        this.mask.measurable = false;
      }
      reset() {
        this.mask.measurable = true;
        this.mask = null;
      }
      addBounds(bounds, skipUpdateTransform) {
        if (!this.inverse) {
          addMaskBounds(this.mask, bounds, skipUpdateTransform);
        }
      }
      addLocalBounds(bounds, localRoot) {
        addMaskLocalBounds(this.mask, bounds, localRoot);
      }
      containsPoint(point, hitTestFn) {
        const mask = this.mask;
        return hitTestFn(mask, point);
      }
      destroy() {
        this.reset();
      }
      static test(mask) {
        return mask instanceof Sprite;
      }
    }
    AlphaMask.extension = ExtensionType.MaskEffect;

    "use strict";
    class ColorMask {
      constructor(options) {
        this.priority = 0;
        this.pipe = "colorMask";
        if (options == null ? void 0 : options.mask) {
          this.init(options.mask);
        }
      }
      init(mask) {
        this.mask = mask;
      }
      destroy() {
      }
      static test(mask) {
        return typeof mask === "number";
      }
    }
    ColorMask.extension = ExtensionType.MaskEffect;

    "use strict";
    class StencilMask {
      constructor(options) {
        this.priority = 0;
        this.pipe = "stencilMask";
        if (options == null ? void 0 : options.mask) {
          this.init(options.mask);
        }
      }
      init(mask) {
        this.mask = mask;
        this.mask.includeInBuild = false;
        this.mask.measurable = false;
      }
      reset() {
        this.mask.measurable = true;
        this.mask.includeInBuild = true;
        this.mask = null;
      }
      addBounds(bounds, skipUpdateTransform) {
        addMaskBounds(this.mask, bounds, skipUpdateTransform);
      }
      addLocalBounds(bounds, localRoot) {
        addMaskLocalBounds(this.mask, bounds, localRoot);
      }
      containsPoint(point, hitTestFn) {
        const mask = this.mask;
        return hitTestFn(mask, point);
      }
      destroy() {
        this.reset();
      }
      static test(mask) {
        return mask instanceof Container;
      }
    }
    StencilMask.extension = ExtensionType.MaskEffect;

    "use strict";
    class CanvasSource extends TextureSource {
      constructor(options) {
        if (!options.resource) {
          options.resource = DOMAdapter.get().createCanvas();
        }
        if (!options.width) {
          options.width = options.resource.width;
          if (!options.autoDensity) {
            options.width /= options.resolution;
          }
        }
        if (!options.height) {
          options.height = options.resource.height;
          if (!options.autoDensity) {
            options.height /= options.resolution;
          }
        }
        super(options);
        this.uploadMethodId = "image";
        this.autoDensity = options.autoDensity;
        this.resizeCanvas();
        this.transparent = !!options.transparent;
      }
      resizeCanvas() {
        if (this.autoDensity) {
          this.resource.style.width = `${this.width}px`;
          this.resource.style.height = `${this.height}px`;
        }
        if (this.resource.width !== this.pixelWidth || this.resource.height !== this.pixelHeight) {
          this.resource.width = this.pixelWidth;
          this.resource.height = this.pixelHeight;
        }
      }
      resize(width = this.width, height = this.height, resolution = this._resolution) {
        const didResize = super.resize(width, height, resolution);
        if (didResize) {
          this.resizeCanvas();
        }
        return didResize;
      }
      static test(resource) {
        return globalThis.HTMLCanvasElement && resource instanceof HTMLCanvasElement || globalThis.OffscreenCanvas && resource instanceof OffscreenCanvas;
      }
      /**
       * Returns the 2D rendering context for the canvas.
       * Caches the context after creating it.
       * @returns The 2D rendering context of the canvas.
       */
      get context2D() {
        return this._context2D || (this._context2D = this.resource.getContext("2d"));
      }
    }
    CanvasSource.extension = ExtensionType.TextureSource;

    "use strict";
    class ImageSource extends TextureSource {
      constructor(options) {
        if (options.resource && (globalThis.HTMLImageElement && options.resource instanceof HTMLImageElement)) {
          const canvas = DOMAdapter.get().createCanvas(options.resource.width, options.resource.height);
          const context = canvas.getContext("2d");
          context.drawImage(options.resource, 0, 0, options.resource.width, options.resource.height);
          options.resource = canvas;
          warn("ImageSource: Image element passed, converting to canvas. Use CanvasSource instead.");
        }
        super(options);
        this.uploadMethodId = "image";
        this.autoGarbageCollect = true;
      }
      static test(resource) {
        return globalThis.HTMLImageElement && resource instanceof HTMLImageElement || typeof ImageBitmap !== "undefined" && resource instanceof ImageBitmap || globalThis.VideoFrame && resource instanceof VideoFrame;
      }
    }
    ImageSource.extension = ExtensionType.TextureSource;

    "use strict";
    let promise;
    async function detectVideoAlphaMode() {
      promise != null ? promise : promise = (async () => {
        var _a;
        const canvas = document.createElement("canvas");
        const gl = canvas.getContext("webgl");
        if (!gl) {
          return "premultiply-alpha-on-upload";
        }
        const video = await new Promise((resolve) => {
          const video2 = document.createElement("video");
          video2.onloadeddata = () => resolve(video2);
          video2.onerror = () => resolve(null);
          video2.autoplay = false;
          video2.crossOrigin = "anonymous";
          video2.preload = "auto";
          video2.src = "data:video/webm;base64,GkXfo59ChoEBQveBAULygQRC84EIQoKEd2VibUKHgQJChYECGFOAZwEAAAAAAAHTEU2bdLpNu4tTq4QVSalmU6yBoU27i1OrhBZUrmtTrIHGTbuMU6uEElTDZ1OsggEXTbuMU6uEHFO7a1OsggG97AEAAAAAAABZAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAVSalmoCrXsYMPQkBNgIRMYXZmV0GETGF2ZkSJiEBEAAAAAAAAFlSua8yuAQAAAAAAAEPXgQFzxYgAAAAAAAAAAZyBACK1nIN1bmSIgQCGhVZfVlA5g4EBI+ODhAJiWgDglLCBArqBApqBAlPAgQFVsIRVuYEBElTDZ9Vzc9JjwItjxYgAAAAAAAAAAWfInEWjh0VOQ09ERVJEh49MYXZjIGxpYnZweC12cDlnyKJFo4hEVVJBVElPTkSHlDAwOjAwOjAwLjA0MDAwMDAwMAAAH0O2dcfngQCgwqGggQAAAIJJg0IAABAAFgA4JBwYSgAAICAAEb///4r+AAB1oZ2mm+6BAaWWgkmDQgAAEAAWADgkHBhKAAAgIABIQBxTu2uRu4+zgQC3iveBAfGCAXHwgQM=";
          video2.load();
        });
        if (!video) {
          return "premultiply-alpha-on-upload";
        }
        const texture = gl.createTexture();
        gl.bindTexture(gl.TEXTURE_2D, texture);
        const framebuffer = gl.createFramebuffer();
        gl.bindFramebuffer(gl.FRAMEBUFFER, framebuffer);
        gl.framebufferTexture2D(
          gl.FRAMEBUFFER,
          gl.COLOR_ATTACHMENT0,
          gl.TEXTURE_2D,
          texture,
          0
        );
        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
        gl.pixelStorei(gl.UNPACK_COLORSPACE_CONVERSION_WEBGL, gl.NONE);
        gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, video);
        const pixel = new Uint8Array(4);
        gl.readPixels(0, 0, 1, 1, gl.RGBA, gl.UNSIGNED_BYTE, pixel);
        gl.deleteFramebuffer(framebuffer);
        gl.deleteTexture(texture);
        (_a = gl.getExtension("WEBGL_lose_context")) == null ? void 0 : _a.loseContext();
        return pixel[0] <= pixel[3] ? "premultiplied-alpha" : "premultiply-alpha-on-upload";
      })();
      return promise;
    }

    "use strict";
    var __defProp$$ = Object.defineProperty;
    var __defProps$o = Object.defineProperties;
    var __getOwnPropDescs$o = Object.getOwnPropertyDescriptors;
    var __getOwnPropSymbols$$ = Object.getOwnPropertySymbols;
    var __hasOwnProp$$ = Object.prototype.hasOwnProperty;
    var __propIsEnum$$ = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$$ = (obj, key, value) => key in obj ? __defProp$$(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$$ = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$$.call(b, prop))
          __defNormalProp$$(a, prop, b[prop]);
      if (__getOwnPropSymbols$$)
        for (var prop of __getOwnPropSymbols$$(b)) {
          if (__propIsEnum$$.call(b, prop))
            __defNormalProp$$(a, prop, b[prop]);
        }
      return a;
    };
    var __spreadProps$o = (a, b) => __defProps$o(a, __getOwnPropDescs$o(b));
    const _VideoSource = class _VideoSource extends TextureSource {
      constructor(options) {
        var _a;
        super(options);
        // Public
        /** Whether or not the video is ready to play. */
        this.isReady = false;
        /** The upload method for this texture. */
        this.uploadMethodId = "video";
        options = __spreadValues$$(__spreadValues$$({}, _VideoSource.defaultOptions), options);
        this._autoUpdate = true;
        this._isConnectedToTicker = false;
        this._updateFPS = options.updateFPS || 0;
        this._msToNextUpdate = 0;
        this.autoPlay = options.autoPlay !== false;
        this.alphaMode = (_a = options.alphaMode) != null ? _a : "premultiply-alpha-on-upload";
        this._videoFrameRequestCallback = this._videoFrameRequestCallback.bind(this);
        this._videoFrameRequestCallbackHandle = null;
        this._load = null;
        this._resolve = null;
        this._reject = null;
        this._onCanPlay = this._onCanPlay.bind(this);
        this._onCanPlayThrough = this._onCanPlayThrough.bind(this);
        this._onError = this._onError.bind(this);
        this._onPlayStart = this._onPlayStart.bind(this);
        this._onPlayStop = this._onPlayStop.bind(this);
        this._onSeeked = this._onSeeked.bind(this);
        if (options.autoLoad !== false) {
          void this.load();
        }
      }
      /** Update the video frame if the source is not destroyed and meets certain conditions. */
      updateFrame() {
        if (this.destroyed) {
          return;
        }
        if (this._updateFPS) {
          const elapsedMS = Ticker.shared.elapsedMS * this.resource.playbackRate;
          this._msToNextUpdate = Math.floor(this._msToNextUpdate - elapsedMS);
        }
        if (!this._updateFPS || this._msToNextUpdate <= 0) {
          this._msToNextUpdate = this._updateFPS ? Math.floor(1e3 / this._updateFPS) : 0;
        }
        if (this.isValid) {
          this.update();
        }
      }
      /** Callback to update the video frame and potentially request the next frame update. */
      _videoFrameRequestCallback() {
        this.updateFrame();
        if (this.destroyed) {
          this._videoFrameRequestCallbackHandle = null;
        } else {
          this._videoFrameRequestCallbackHandle = this.resource.requestVideoFrameCallback(
            this._videoFrameRequestCallback
          );
        }
      }
      /**
       * Checks if the resource has valid dimensions.
       * @returns {boolean} True if width and height are set, otherwise false.
       */
      get isValid() {
        return !!this.resource.videoWidth && !!this.resource.videoHeight;
      }
      /**
       * Start preloading the video resource.
       * @returns {Promise<this>} Handle the validate event
       */
      async load() {
        if (this._load) {
          return this._load;
        }
        const source = this.resource;
        const options = this.options;
        if ((source.readyState === source.HAVE_ENOUGH_DATA || source.readyState === source.HAVE_FUTURE_DATA) && source.width && source.height) {
          source.complete = true;
        }
        source.addEventListener("play", this._onPlayStart);
        source.addEventListener("pause", this._onPlayStop);
        source.addEventListener("seeked", this._onSeeked);
        if (!this._isSourceReady()) {
          if (!options.preload) {
            source.addEventListener("canplay", this._onCanPlay);
          }
          source.addEventListener("canplaythrough", this._onCanPlayThrough);
          source.addEventListener("error", this._onError, true);
        } else {
          this._mediaReady();
        }
        this.alphaMode = await detectVideoAlphaMode();
        this._load = new Promise((resolve, reject) => {
          if (this.isValid) {
            resolve(this);
          } else {
            this._resolve = resolve;
            this._reject = reject;
            if (options.preloadTimeoutMs !== void 0) {
              this._preloadTimeout = setTimeout(() => {
                this._onError(new ErrorEvent(`Preload exceeded timeout of ${options.preloadTimeoutMs}ms`));
              });
            }
            source.load();
          }
        });
        return this._load;
      }
      /**
       * Handle video error events.
       * @param event - The error event
       */
      _onError(event) {
        this.resource.removeEventListener("error", this._onError, true);
        this.emit("error", event);
        if (this._reject) {
          this._reject(event);
          this._reject = null;
          this._resolve = null;
        }
      }
      /**
       * Checks if the underlying source is playing.
       * @returns True if playing.
       */
      _isSourcePlaying() {
        const source = this.resource;
        return !source.paused && !source.ended;
      }
      /**
       * Checks if the underlying source is ready for playing.
       * @returns True if ready.
       */
      _isSourceReady() {
        const source = this.resource;
        return source.readyState > 2;
      }
      /** Runs the update loop when the video is ready to play. */
      _onPlayStart() {
        if (!this.isValid) {
          this._mediaReady();
        }
        this._configureAutoUpdate();
      }
      /** Stops the update loop when a pause event is triggered. */
      _onPlayStop() {
        this._configureAutoUpdate();
      }
      /** Handles behavior when the video completes seeking to the current playback position. */
      _onSeeked() {
        if (this._autoUpdate && !this._isSourcePlaying()) {
          this._msToNextUpdate = 0;
          this.updateFrame();
          this._msToNextUpdate = 0;
        }
      }
      _onCanPlay() {
        const source = this.resource;
        source.removeEventListener("canplay", this._onCanPlay);
        this._mediaReady();
      }
      _onCanPlayThrough() {
        const source = this.resource;
        source.removeEventListener("canplaythrough", this._onCanPlay);
        if (this._preloadTimeout) {
          clearTimeout(this._preloadTimeout);
          this._preloadTimeout = void 0;
        }
        this._mediaReady();
      }
      /** Fired when the video is loaded and ready to play. */
      _mediaReady() {
        const source = this.resource;
        if (this.isValid) {
          this.isReady = true;
          this.resize(source.videoWidth, source.videoHeight);
        }
        this._msToNextUpdate = 0;
        this.updateFrame();
        this._msToNextUpdate = 0;
        if (this._resolve) {
          this._resolve(this);
          this._resolve = null;
          this._reject = null;
        }
        if (this._isSourcePlaying()) {
          this._onPlayStart();
        } else if (this.autoPlay) {
          void this.resource.play();
        }
      }
      /** Cleans up resources and event listeners associated with this texture. */
      destroy() {
        this._configureAutoUpdate();
        const source = this.resource;
        if (source) {
          source.removeEventListener("play", this._onPlayStart);
          source.removeEventListener("pause", this._onPlayStop);
          source.removeEventListener("seeked", this._onSeeked);
          source.removeEventListener("canplay", this._onCanPlay);
          source.removeEventListener("canplaythrough", this._onCanPlayThrough);
          source.removeEventListener("error", this._onError, true);
          source.pause();
          source.src = "";
          source.load();
        }
        super.destroy();
      }
      /** Should the base texture automatically update itself, set to true by default. */
      get autoUpdate() {
        return this._autoUpdate;
      }
      set autoUpdate(value) {
        if (value !== this._autoUpdate) {
          this._autoUpdate = value;
          this._configureAutoUpdate();
        }
      }
      /**
       * How many times a second to update the texture from the video.
       * Leave at 0 to update at every render.
       * A lower fps can help performance, as updating the texture at 60fps on a 30ps video may not be efficient.
       */
      get updateFPS() {
        return this._updateFPS;
      }
      set updateFPS(value) {
        if (value !== this._updateFPS) {
          this._updateFPS = value;
          this._configureAutoUpdate();
        }
      }
      /**
       * Configures the updating mechanism based on the current state and settings.
       *
       * This method decides between using the browser's native video frame callback or a custom ticker
       * for updating the video frame. It ensures optimal performance and responsiveness
       * based on the video's state, playback status, and the desired frames-per-second setting.
       *
       * - If `_autoUpdate` is enabled and the video source is playing:
       *   - It will prefer the native video frame callback if available and no specific FPS is set.
       *   - Otherwise, it will use a custom ticker for manual updates.
       * - If `_autoUpdate` is disabled or the video isn't playing, any active update mechanisms are halted.
       */
      _configureAutoUpdate() {
        if (this._autoUpdate && this._isSourcePlaying()) {
          if (!this._updateFPS && this.resource.requestVideoFrameCallback) {
            if (this._isConnectedToTicker) {
              Ticker.shared.remove(this.updateFrame, this);
              this._isConnectedToTicker = false;
              this._msToNextUpdate = 0;
            }
            if (this._videoFrameRequestCallbackHandle === null) {
              this._videoFrameRequestCallbackHandle = this.resource.requestVideoFrameCallback(
                this._videoFrameRequestCallback
              );
            }
          } else {
            if (this._videoFrameRequestCallbackHandle !== null) {
              this.resource.cancelVideoFrameCallback(this._videoFrameRequestCallbackHandle);
              this._videoFrameRequestCallbackHandle = null;
            }
            if (!this._isConnectedToTicker) {
              Ticker.shared.add(this.updateFrame, this);
              this._isConnectedToTicker = true;
              this._msToNextUpdate = 0;
            }
          }
        } else {
          if (this._videoFrameRequestCallbackHandle !== null) {
            this.resource.cancelVideoFrameCallback(this._videoFrameRequestCallbackHandle);
            this._videoFrameRequestCallbackHandle = null;
          }
          if (this._isConnectedToTicker) {
            Ticker.shared.remove(this.updateFrame, this);
            this._isConnectedToTicker = false;
            this._msToNextUpdate = 0;
          }
        }
      }
      static test(resource) {
        return globalThis.HTMLVideoElement && resource instanceof HTMLVideoElement;
      }
    };
    _VideoSource.extension = ExtensionType.TextureSource;
    /** The default options for video sources. */
    _VideoSource.defaultOptions = __spreadProps$o(__spreadValues$$({}, TextureSource.defaultOptions), {
      /** If true, the video will start loading immediately. */
      autoLoad: true,
      /** If true, the video will start playing as soon as it is loaded. */
      autoPlay: true,
      /** The number of times a second to update the texture from the video. Leave at 0 to update at every render. */
      updateFPS: 0,
      /** If true, the video will be loaded with the `crossorigin` attribute. */
      crossorigin: true,
      /** If true, the video will loop when it ends. */
      loop: false,
      /** If true, the video will be muted. */
      muted: true,
      /** If true, the video will play inline. */
      playsinline: true,
      /** If true, the video will be preloaded. */
      preload: false
    });
    /**
     * Map of video MIME types that can't be directly derived from file extensions.
     * @readonly
     */
    _VideoSource.MIME_TYPES = {
      ogv: "video/ogg",
      mov: "video/quicktime",
      m4v: "video/mp4"
    };
    let VideoSource = _VideoSource;

    "use strict";
    class CacheClass {
      constructor() {
        this._parsers = [];
        this._cache = /* @__PURE__ */ new Map();
        this._cacheMap = /* @__PURE__ */ new Map();
      }
      /** Clear all entries. */
      reset() {
        this._cacheMap.clear();
        this._cache.clear();
      }
      /**
       * Check if the key exists
       * @param key - The key to check
       */
      has(key) {
        return this._cache.has(key);
      }
      /**
       * Fetch entry by key
       * @param key - The key of the entry to get
       */
      get(key) {
        const result = this._cache.get(key);
        if (!result) {
          warn(`[Assets] Asset id ${key} was not found in the Cache`);
        }
        return result;
      }
      /**
       * Set a value by key or keys name
       * @param key - The key or keys to set
       * @param value - The value to store in the cache or from which cacheable assets will be derived.
       */
      set(key, value) {
        const keys = convertToList(key);
        let cacheableAssets;
        for (let i = 0; i < this.parsers.length; i++) {
          const parser = this.parsers[i];
          if (parser.test(value)) {
            cacheableAssets = parser.getCacheableAssets(keys, value);
            break;
          }
        }
        const cacheableMap = new Map(Object.entries(cacheableAssets || {}));
        if (!cacheableAssets) {
          keys.forEach((key2) => {
            cacheableMap.set(key2, value);
          });
        }
        const cacheKeys = [...cacheableMap.keys()];
        const cachedAssets = {
          cacheKeys,
          keys
        };
        keys.forEach((key2) => {
          this._cacheMap.set(key2, cachedAssets);
        });
        cacheKeys.forEach((key2) => {
          const val = cacheableAssets ? cacheableAssets[key2] : value;
          if (this._cache.has(key2) && this._cache.get(key2) !== val) {
            warn("[Cache] already has key:", key2);
          }
          this._cache.set(key2, cacheableMap.get(key2));
        });
      }
      /**
       * Remove entry by key
       *
       * This function will also remove any associated alias from the cache also.
       * @param key - The key of the entry to remove
       */
      remove(key) {
        if (!this._cacheMap.has(key)) {
          warn(`[Assets] Asset id ${key} was not found in the Cache`);
          return;
        }
        const cacheMap = this._cacheMap.get(key);
        const cacheKeys = cacheMap.cacheKeys;
        cacheKeys.forEach((key2) => {
          this._cache.delete(key2);
        });
        cacheMap.keys.forEach((key2) => {
          this._cacheMap.delete(key2);
        });
      }
      /** All loader parsers registered */
      get parsers() {
        return this._parsers;
      }
    }
    const Cache = new CacheClass();

    "use strict";
    const sources = [];
    extensions.handleByList(ExtensionType.TextureSource, sources);
    function autoDetectSource(options = {}) {
      return textureSourceFrom(options);
    }
    function textureSourceFrom(options = {}) {
      const hasResource = options && options.resource;
      const res = hasResource ? options.resource : options;
      const opts = hasResource ? options : { resource: options };
      for (let i = 0; i < sources.length; i++) {
        const Source = sources[i];
        if (Source.test(res)) {
          return new Source(opts);
        }
      }
      throw new Error(`Could not find a source type for resource: ${opts.resource}`);
    }
    function resourceToTexture(options = {}, skipCache = false) {
      const hasResource = options && options.resource;
      const resource = hasResource ? options.resource : options;
      const opts = hasResource ? options : { resource: options };
      if (!skipCache && Cache.has(resource)) {
        return Cache.get(resource);
      }
      const texture = new Texture({ source: textureSourceFrom(opts) });
      texture.on("destroy", () => {
        if (Cache.has(resource)) {
          Cache.remove(resource);
        }
      });
      if (!skipCache) {
        Cache.set(resource, texture);
      }
      return texture;
    }
    function textureFrom(id, skipCache = false) {
      if (typeof id === "string") {
        return Cache.get(id);
      } else if (id instanceof TextureSource) {
        return new Texture({ source: id });
      }
      return resourceToTexture(id, skipCache);
    }
    Texture.from = textureFrom;
    TextureSource.from = textureSourceFrom;

    "use strict";
    extensions.add(AlphaMask, ColorMask, StencilMask, VideoSource, ImageSource, CanvasSource, BufferImageSource);

    "use strict";
    class BindGroup {
      /**
       * Create a new instance eof the Bind Group.
       * @param resources - The resources that are bound together for use by a shader.
       */
      constructor(resources) {
        /** The resources that are bound together for use by a shader. */
        this.resources = /* @__PURE__ */ Object.create(null);
        this._dirty = true;
        let index = 0;
        for (const i in resources) {
          const resource = resources[i];
          this.setResource(resource, index++);
        }
        this._updateKey();
      }
      /**
       * Updates the key if its flagged as dirty. This is used internally to
       * match this bind group to a WebGPU BindGroup.
       * @internal
       * @ignore
       */
      _updateKey() {
        if (!this._dirty)
          return;
        this._dirty = false;
        const keyParts = [];
        let index = 0;
        for (const i in this.resources) {
          keyParts[index++] = this.resources[i]._resourceId;
        }
        this._key = keyParts.join("|");
      }
      /**
       * Set a resource at a given index. this function will
       * ensure that listeners will be removed from the current resource
       * and added to the new resource.
       * @param resource - The resource to set.
       * @param index - The index to set the resource at.
       */
      setResource(resource, index) {
        var _a, _b;
        const currentResource = this.resources[index];
        if (resource === currentResource)
          return;
        if (currentResource) {
          (_a = resource.off) == null ? void 0 : _a.call(resource, "change", this.onResourceChange, this);
        }
        (_b = resource.on) == null ? void 0 : _b.call(resource, "change", this.onResourceChange, this);
        this.resources[index] = resource;
        this._dirty = true;
      }
      /**
       * Returns the resource at the current specified index.
       * @param index - The index of the resource to get.
       * @returns - The resource at the specified index.
       */
      getResource(index) {
        return this.resources[index];
      }
      /**
       * Used internally to 'touch' each resource, to ensure that the GC
       * knows that all resources in this bind group are still being used.
       * @param tick - The current tick.
       * @internal
       * @ignore
       */
      _touch(tick) {
        const resources = this.resources;
        for (const i in resources) {
          resources[i]._touched = tick;
        }
      }
      /** Destroys this bind group and removes all listeners. */
      destroy() {
        var _a;
        const resources = this.resources;
        for (const i in resources) {
          const resource = resources[i];
          (_a = resource.off) == null ? void 0 : _a.call(resource, "change", this.onResourceChange, this);
        }
        this.resources = null;
      }
      onResourceChange(resource) {
        this._dirty = true;
        if (resource.destroyed) {
          const resources = this.resources;
          for (const i in resources) {
            if (resources[i] === resource) {
              resources[i] = null;
            }
          }
        } else {
          this._updateKey();
        }
      }
    }

    "use strict";
    let context;
    function getTestContext() {
      if (!context || (context == null ? void 0 : context.isContextLost())) {
        const canvas = DOMAdapter.get().createCanvas();
        context = canvas.getContext("webgl", {});
      }
      return context;
    }

    "use strict";
    const fragTemplate$1 = [
      "precision mediump float;",
      "void main(void){",
      "float test = 0.1;",
      "%forloop%",
      "gl_FragColor = vec4(0.0);",
      "}"
    ].join("\n");
    function generateIfTestSrc(maxIfs) {
      let src = "";
      for (let i = 0; i < maxIfs; ++i) {
        if (i > 0) {
          src += "\nelse ";
        }
        if (i < maxIfs - 1) {
          src += `if(test == ${i}.0){}`;
        }
      }
      return src;
    }
    function checkMaxIfStatementsInShader(maxIfs, gl) {
      if (maxIfs === 0) {
        throw new Error("Invalid value of `0` passed to `checkMaxIfStatementsInShader`");
      }
      const shader = gl.createShader(gl.FRAGMENT_SHADER);
      try {
        while (true) {
          const fragmentSrc = fragTemplate$1.replace(/%forloop%/gi, generateIfTestSrc(maxIfs));
          gl.shaderSource(shader, fragmentSrc);
          gl.compileShader(shader);
          if (!gl.getShaderParameter(shader, gl.COMPILE_STATUS)) {
            maxIfs = maxIfs / 2 | 0;
          } else {
            break;
          }
        }
      } finally {
        gl.deleteShader(shader);
      }
      return maxIfs;
    }

    "use strict";
    let maxTexturesPerBatchCache = null;
    function getMaxTexturesPerBatch() {
      var _a;
      if (maxTexturesPerBatchCache)
        return maxTexturesPerBatchCache;
      const gl = getTestContext();
      maxTexturesPerBatchCache = gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS);
      maxTexturesPerBatchCache = checkMaxIfStatementsInShader(
        maxTexturesPerBatchCache,
        gl
      );
      (_a = gl.getExtension("WEBGL_lose_context")) == null ? void 0 : _a.loseContext();
      return maxTexturesPerBatchCache;
    }

    "use strict";
    const cachedGroups = {};
    function getTextureBatchBindGroup(textures, size) {
      let uid = 2166136261;
      for (let i = 0; i < size; i++) {
        uid ^= textures[i].uid;
        uid = Math.imul(uid, 16777619);
        uid >>>= 0;
      }
      return cachedGroups[uid] || generateTextureBatchBindGroup(textures, size, uid);
    }
    let maxTextures = 0;
    function generateTextureBatchBindGroup(textures, size, key) {
      const bindGroupResources = {};
      let bindIndex = 0;
      if (!maxTextures)
        maxTextures = getMaxTexturesPerBatch();
      for (let i = 0; i < maxTextures; i++) {
        const texture = i < size ? textures[i] : Texture.EMPTY.source;
        bindGroupResources[bindIndex++] = texture.source;
        bindGroupResources[bindIndex++] = texture.style;
      }
      const bindGroup = new BindGroup(bindGroupResources);
      cachedGroups[key] = bindGroup;
      return bindGroup;
    }

    "use strict";
    class ViewableBuffer {
      constructor(sizeOrBuffer) {
        if (typeof sizeOrBuffer === "number") {
          this.rawBinaryData = new ArrayBuffer(sizeOrBuffer);
        } else if (sizeOrBuffer instanceof Uint8Array) {
          this.rawBinaryData = sizeOrBuffer.buffer;
        } else {
          this.rawBinaryData = sizeOrBuffer;
        }
        this.uint32View = new Uint32Array(this.rawBinaryData);
        this.float32View = new Float32Array(this.rawBinaryData);
        this.size = this.rawBinaryData.byteLength;
      }
      /** View on the raw binary data as a `Int8Array`. */
      get int8View() {
        if (!this._int8View) {
          this._int8View = new Int8Array(this.rawBinaryData);
        }
        return this._int8View;
      }
      /** View on the raw binary data as a `Uint8Array`. */
      get uint8View() {
        if (!this._uint8View) {
          this._uint8View = new Uint8Array(this.rawBinaryData);
        }
        return this._uint8View;
      }
      /**  View on the raw binary data as a `Int16Array`. */
      get int16View() {
        if (!this._int16View) {
          this._int16View = new Int16Array(this.rawBinaryData);
        }
        return this._int16View;
      }
      /** View on the raw binary data as a `Int32Array`. */
      get int32View() {
        if (!this._int32View) {
          this._int32View = new Int32Array(this.rawBinaryData);
        }
        return this._int32View;
      }
      /** View on the raw binary data as a `Float64Array`. */
      get float64View() {
        if (!this._float64Array) {
          this._float64Array = new Float64Array(this.rawBinaryData);
        }
        return this._float64Array;
      }
      /** View on the raw binary data as a `BigUint64Array`. */
      get bigUint64View() {
        if (!this._bigUint64Array) {
          this._bigUint64Array = new BigUint64Array(this.rawBinaryData);
        }
        return this._bigUint64Array;
      }
      /**
       * Returns the view of the given type.
       * @param type - One of `int8`, `uint8`, `int16`,
       *    `uint16`, `int32`, `uint32`, and `float32`.
       * @returns - typed array of given type
       */
      view(type) {
        return this[`${type}View`];
      }
      /** Destroys all buffer references. Do not use after calling this. */
      destroy() {
        this.rawBinaryData = null;
        this._int8View = null;
        this._uint8View = null;
        this._int16View = null;
        this.uint16View = null;
        this._int32View = null;
        this.uint32View = null;
        this.float32View = null;
      }
      /**
       * Returns the size of the given type in bytes.
       * @param type - One of `int8`, `uint8`, `int16`,
       *   `uint16`, `int32`, `uint32`, and `float32`.
       * @returns - size of the type in bytes
       */
      static sizeOf(type) {
        switch (type) {
          case "int8":
          case "uint8":
            return 1;
          case "int16":
          case "uint16":
            return 2;
          case "int32":
          case "uint32":
          case "float32":
            return 4;
          default:
            throw new Error(`${type} isn't a valid view type`);
        }
      }
    }

    "use strict";
    function fastCopy(sourceBuffer, destinationBuffer) {
      const lengthDouble = sourceBuffer.byteLength / 8 | 0;
      const sourceFloat64View = new Float64Array(sourceBuffer, 0, lengthDouble);
      const destinationFloat64View = new Float64Array(destinationBuffer, 0, lengthDouble);
      destinationFloat64View.set(sourceFloat64View);
      const remainingBytes = sourceBuffer.byteLength - lengthDouble * 8;
      if (remainingBytes > 0) {
        const sourceUint8View = new Uint8Array(sourceBuffer, lengthDouble * 8, remainingBytes);
        const destinationUint8View = new Uint8Array(destinationBuffer, lengthDouble * 8, remainingBytes);
        destinationUint8View.set(sourceUint8View);
      }
    }

    "use strict";
    const BLEND_TO_NPM = {
      normal: "normal-npm",
      add: "add-npm",
      screen: "screen-npm"
    };
    var STENCIL_MODES = /* @__PURE__ */ ((STENCIL_MODES2) => {
      STENCIL_MODES2[STENCIL_MODES2["DISABLED"] = 0] = "DISABLED";
      STENCIL_MODES2[STENCIL_MODES2["RENDERING_MASK_ADD"] = 1] = "RENDERING_MASK_ADD";
      STENCIL_MODES2[STENCIL_MODES2["MASK_ACTIVE"] = 2] = "MASK_ACTIVE";
      STENCIL_MODES2[STENCIL_MODES2["INVERSE_MASK_ACTIVE"] = 3] = "INVERSE_MASK_ACTIVE";
      STENCIL_MODES2[STENCIL_MODES2["RENDERING_MASK_REMOVE"] = 4] = "RENDERING_MASK_REMOVE";
      STENCIL_MODES2[STENCIL_MODES2["NONE"] = 5] = "NONE";
      return STENCIL_MODES2;
    })(STENCIL_MODES || {});

    "use strict";
    function getAdjustedBlendModeBlend(blendMode, textureSource) {
      if (textureSource.alphaMode === "no-premultiply-alpha") {
        return BLEND_TO_NPM[blendMode] || blendMode;
      }
      return blendMode;
    }

    "use strict";
    class BatchTextureArray {
      constructor() {
        /** Respective locations for textures. */
        this.ids = /* @__PURE__ */ Object.create(null);
        this.textures = [];
        this.count = 0;
      }
      /** Clear the textures and their locations. */
      clear() {
        for (let i = 0; i < this.count; i++) {
          const t = this.textures[i];
          this.textures[i] = null;
          this.ids[t.uid] = null;
        }
        this.count = 0;
      }
    }

    "use strict";
    var __defProp$_ = Object.defineProperty;
    var __getOwnPropSymbols$_ = Object.getOwnPropertySymbols;
    var __hasOwnProp$_ = Object.prototype.hasOwnProperty;
    var __propIsEnum$_ = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$_ = (obj, key, value) => key in obj ? __defProp$_(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$_ = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$_.call(b, prop))
          __defNormalProp$_(a, prop, b[prop]);
      if (__getOwnPropSymbols$_)
        for (var prop of __getOwnPropSymbols$_(b)) {
          if (__propIsEnum$_.call(b, prop))
            __defNormalProp$_(a, prop, b[prop]);
        }
      return a;
    };
    class Batch {
      constructor() {
        this.renderPipeId = "batch";
        this.action = "startBatch";
        // TODO - eventually this could be useful for flagging batches as dirty and then only rebuilding those ones
        // public elementStart = 0;
        // public elementSize = 0;
        // for drawing..
        this.start = 0;
        this.size = 0;
        this.textures = new BatchTextureArray();
        this.blendMode = "normal";
        this.topology = "triangle-strip";
        this.canBundle = true;
      }
      destroy() {
        this.textures = null;
        this.gpuBindGroup = null;
        this.bindGroup = null;
        this.batcher = null;
      }
    }
    const batchPool = [];
    let batchPoolIndex = 0;
    function getBatchFromPool() {
      return batchPoolIndex > 0 ? batchPool[--batchPoolIndex] : new Batch();
    }
    function returnBatchToPool(batch) {
      batchPool[batchPoolIndex++] = batch;
    }
    let BATCH_TICK = 0;
    const _Batcher = class _Batcher {
      constructor(options = {}) {
        /** unique id for this batcher */
        this.uid = uid$1("batcher");
        /** Indicates whether the batch data has been modified and needs updating. */
        this.dirty = true;
        /** The current index of the batch being processed. */
        this.batchIndex = 0;
        /** An array of all batches created during the current rendering process. */
        this.batches = [];
        this._elements = [];
        var _a;
        _Batcher.defaultOptions.maxTextures = (_a = _Batcher.defaultOptions.maxTextures) != null ? _a : getMaxTexturesPerBatch();
        options = __spreadValues$_(__spreadValues$_({}, _Batcher.defaultOptions), options);
        const { maxTextures, attributesInitialSize, indicesInitialSize } = options;
        this.attributeBuffer = new ViewableBuffer(attributesInitialSize * 4);
        this.indexBuffer = new Uint16Array(indicesInitialSize);
        this.maxTextures = maxTextures;
      }
      begin() {
        this.elementSize = 0;
        this.elementStart = 0;
        this.indexSize = 0;
        this.attributeSize = 0;
        for (let i = 0; i < this.batchIndex; i++) {
          returnBatchToPool(this.batches[i]);
        }
        this.batchIndex = 0;
        this._batchIndexStart = 0;
        this._batchIndexSize = 0;
        this.dirty = true;
      }
      add(batchableObject) {
        this._elements[this.elementSize++] = batchableObject;
        batchableObject._indexStart = this.indexSize;
        batchableObject._attributeStart = this.attributeSize;
        batchableObject._batcher = this;
        this.indexSize += batchableObject.indexSize;
        this.attributeSize += batchableObject.attributeSize * this.vertexSize;
      }
      checkAndUpdateTexture(batchableObject, texture) {
        const textureId = batchableObject._batch.textures.ids[texture._source.uid];
        if (!textureId && textureId !== 0)
          return false;
        batchableObject._textureId = textureId;
        batchableObject.texture = texture;
        return true;
      }
      updateElement(batchableObject) {
        this.dirty = true;
        const attributeBuffer = this.attributeBuffer;
        if (batchableObject.packAsQuad) {
          this.packQuadAttributes(
            batchableObject,
            attributeBuffer.float32View,
            attributeBuffer.uint32View,
            batchableObject._attributeStart,
            batchableObject._textureId
          );
        } else {
          this.packAttributes(
            batchableObject,
            attributeBuffer.float32View,
            attributeBuffer.uint32View,
            batchableObject._attributeStart,
            batchableObject._textureId
          );
        }
      }
      /**
       * breaks the batcher. This happens when a batch gets too big,
       * or we need to switch to a different type of rendering (a filter for example)
       * @param instructionSet
       */
      break(instructionSet) {
        const elements = this._elements;
        if (!elements[this.elementStart])
          return;
        let batch = getBatchFromPool();
        let textureBatch = batch.textures;
        textureBatch.clear();
        const firstElement = elements[this.elementStart];
        let blendMode = getAdjustedBlendModeBlend(firstElement.blendMode, firstElement.texture._source);
        let topology = firstElement.topology;
        if (this.attributeSize * 4 > this.attributeBuffer.size) {
          this._resizeAttributeBuffer(this.attributeSize * 4);
        }
        if (this.indexSize > this.indexBuffer.length) {
          this._resizeIndexBuffer(this.indexSize);
        }
        const f32 = this.attributeBuffer.float32View;
        const u32 = this.attributeBuffer.uint32View;
        const indexBuffer = this.indexBuffer;
        let size = this._batchIndexSize;
        let start = this._batchIndexStart;
        let action = "startBatch";
        const maxTextures = this.maxTextures;
        for (let i = this.elementStart; i < this.elementSize; ++i) {
          const element = elements[i];
          elements[i] = null;
          const texture = element.texture;
          const source = texture._source;
          const adjustedBlendMode = getAdjustedBlendModeBlend(element.blendMode, source);
          const breakRequired = blendMode !== adjustedBlendMode || topology !== element.topology;
          if (source._batchTick === BATCH_TICK && !breakRequired) {
            element._textureId = source._textureBindLocation;
            size += element.indexSize;
            if (element.packAsQuad) {
              this.packQuadAttributes(
                element,
                f32,
                u32,
                element._attributeStart,
                element._textureId
              );
              this.packQuadIndex(
                indexBuffer,
                element._indexStart,
                element._attributeStart / this.vertexSize
              );
            } else {
              this.packAttributes(
                element,
                f32,
                u32,
                element._attributeStart,
                element._textureId
              );
              this.packIndex(
                element,
                indexBuffer,
                element._indexStart,
                element._attributeStart / this.vertexSize
              );
            }
            element._batch = batch;
            continue;
          }
          source._batchTick = BATCH_TICK;
          if (textureBatch.count >= maxTextures || breakRequired) {
            this._finishBatch(
              batch,
              start,
              size - start,
              textureBatch,
              blendMode,
              topology,
              instructionSet,
              action
            );
            action = "renderBatch";
            start = size;
            blendMode = adjustedBlendMode;
            topology = element.topology;
            batch = getBatchFromPool();
            textureBatch = batch.textures;
            textureBatch.clear();
            ++BATCH_TICK;
          }
          element._textureId = source._textureBindLocation = textureBatch.count;
          textureBatch.ids[source.uid] = textureBatch.count;
          textureBatch.textures[textureBatch.count++] = source;
          element._batch = batch;
          size += element.indexSize;
          if (element.packAsQuad) {
            this.packQuadAttributes(
              element,
              f32,
              u32,
              element._attributeStart,
              element._textureId
            );
            this.packQuadIndex(
              indexBuffer,
              element._indexStart,
              element._attributeStart / this.vertexSize
            );
          } else {
            this.packAttributes(
              element,
              f32,
              u32,
              element._attributeStart,
              element._textureId
            );
            this.packIndex(
              element,
              indexBuffer,
              element._indexStart,
              element._attributeStart / this.vertexSize
            );
          }
        }
        if (textureBatch.count > 0) {
          this._finishBatch(
            batch,
            start,
            size - start,
            textureBatch,
            blendMode,
            topology,
            instructionSet,
            action
          );
          start = size;
          ++BATCH_TICK;
        }
        this.elementStart = this.elementSize;
        this._batchIndexStart = start;
        this._batchIndexSize = size;
      }
      _finishBatch(batch, indexStart, indexSize, textureBatch, blendMode, topology, instructionSet, action) {
        batch.gpuBindGroup = null;
        batch.bindGroup = null;
        batch.action = action;
        batch.batcher = this;
        batch.textures = textureBatch;
        batch.blendMode = blendMode;
        batch.topology = topology;
        batch.start = indexStart;
        batch.size = indexSize;
        ++BATCH_TICK;
        this.batches[this.batchIndex++] = batch;
        instructionSet.add(batch);
      }
      finish(instructionSet) {
        this.break(instructionSet);
      }
      /**
       * Resizes the attribute buffer to the given size (1 = 1 float32)
       * @param size - the size in vertices to ensure (not bytes!)
       */
      ensureAttributeBuffer(size) {
        if (size * 4 <= this.attributeBuffer.size)
          return;
        this._resizeAttributeBuffer(size * 4);
      }
      /**
       * Resizes the index buffer to the given size (1 = 1 float32)
       * @param size - the size in vertices to ensure (not bytes!)
       */
      ensureIndexBuffer(size) {
        if (size <= this.indexBuffer.length)
          return;
        this._resizeIndexBuffer(size);
      }
      _resizeAttributeBuffer(size) {
        const newSize = Math.max(size, this.attributeBuffer.size * 2);
        const newArrayBuffer = new ViewableBuffer(newSize);
        fastCopy(this.attributeBuffer.rawBinaryData, newArrayBuffer.rawBinaryData);
        this.attributeBuffer = newArrayBuffer;
      }
      _resizeIndexBuffer(size) {
        const indexBuffer = this.indexBuffer;
        let newSize = Math.max(size, indexBuffer.length * 1.5);
        newSize += newSize % 2;
        const newIndexBuffer = newSize > 65535 ? new Uint32Array(newSize) : new Uint16Array(newSize);
        if (newIndexBuffer.BYTES_PER_ELEMENT !== indexBuffer.BYTES_PER_ELEMENT) {
          for (let i = 0; i < indexBuffer.length; i++) {
            newIndexBuffer[i] = indexBuffer[i];
          }
        } else {
          fastCopy(indexBuffer.buffer, newIndexBuffer.buffer);
        }
        this.indexBuffer = newIndexBuffer;
      }
      packQuadIndex(indexBuffer, index, indicesOffset) {
        indexBuffer[index] = indicesOffset + 0;
        indexBuffer[index + 1] = indicesOffset + 1;
        indexBuffer[index + 2] = indicesOffset + 2;
        indexBuffer[index + 3] = indicesOffset + 0;
        indexBuffer[index + 4] = indicesOffset + 2;
        indexBuffer[index + 5] = indicesOffset + 3;
      }
      packIndex(element, indexBuffer, index, indicesOffset) {
        const indices = element.indices;
        const size = element.indexSize;
        const indexOffset = element.indexOffset;
        const attributeOffset = element.attributeOffset;
        for (let i = 0; i < size; i++) {
          indexBuffer[index++] = indicesOffset + indices[i + indexOffset] - attributeOffset;
        }
      }
      destroy() {
        for (let i = 0; i < this.batches.length; i++) {
          returnBatchToPool(this.batches[i]);
        }
        this.batches = null;
        for (let i = 0; i < this._elements.length; i++) {
          this._elements[i]._batch = null;
        }
        this._elements = null;
        this.indexBuffer = null;
        this.attributeBuffer.destroy();
        this.attributeBuffer = null;
      }
    };
    _Batcher.defaultOptions = {
      maxTextures: null,
      attributesInitialSize: 4,
      indicesInitialSize: 6
    };
    let Batcher = _Batcher;

    "use strict";
    var BufferUsage = /* @__PURE__ */ ((BufferUsage2) => {
      BufferUsage2[BufferUsage2["MAP_READ"] = 1] = "MAP_READ";
      BufferUsage2[BufferUsage2["MAP_WRITE"] = 2] = "MAP_WRITE";
      BufferUsage2[BufferUsage2["COPY_SRC"] = 4] = "COPY_SRC";
      BufferUsage2[BufferUsage2["COPY_DST"] = 8] = "COPY_DST";
      BufferUsage2[BufferUsage2["INDEX"] = 16] = "INDEX";
      BufferUsage2[BufferUsage2["VERTEX"] = 32] = "VERTEX";
      BufferUsage2[BufferUsage2["UNIFORM"] = 64] = "UNIFORM";
      BufferUsage2[BufferUsage2["STORAGE"] = 128] = "STORAGE";
      BufferUsage2[BufferUsage2["INDIRECT"] = 256] = "INDIRECT";
      BufferUsage2[BufferUsage2["QUERY_RESOLVE"] = 512] = "QUERY_RESOLVE";
      BufferUsage2[BufferUsage2["STATIC"] = 1024] = "STATIC";
      return BufferUsage2;
    })(BufferUsage || {});

    "use strict";
    class Buffer extends EventEmitter {
      /**
       * Creates a new Buffer with the given options
       * @param options - the options for the buffer
       */
      constructor(options) {
        let { data, size } = options;
        const { usage, label, shrinkToFit } = options;
        super();
        /**
         * emits when the underlying buffer has changed shape (i.e. resized)
         * letting the renderer know that it needs to discard the old buffer on the GPU and create a new one
         * @event change
         */
        /**
         * emits when the underlying buffer data has been updated. letting the renderer know
         * that it needs to update the buffer on the GPU
         * @event update
         */
        /**
         * emits when the buffer is destroyed. letting the renderer know that it needs to destroy the buffer on the GPU
         * @event destroy
         */
        /** a unique id for this uniform group used through the renderer */
        this.uid = uid$1("buffer");
        /**
         * a resource type, used to identify how to handle it when its in a bind group / shader resource
         * @internal
         * @ignore
         */
        this._resourceType = "buffer";
        /**
         * the resource id used internally by the renderer to build bind group keys
         * @internal
         * @ignore
         */
        this._resourceId = uid$1("resource");
        /**
         * used internally to know if a uniform group was used in the last render pass
         * @internal
         * @ignore
         */
        this._touched = 0;
        /**
         * @internal
         * @ignore
         */
        this._updateID = 1;
        this._dataInt32 = null;
        /**
         * should the GPU buffer be shrunk when the data becomes smaller?
         * changing this will cause the buffer to be destroyed and a new one created on the GPU
         * this can be expensive, especially if the buffer is already big enough!
         * setting this to false will prevent the buffer from being shrunk. This will yield better performance
         * if you are constantly setting data that is changing size often.
         * @default true
         */
        this.shrinkToFit = true;
        /**
         * Has the buffer been destroyed?
         * @readonly
         */
        this.destroyed = false;
        if (data instanceof Array) {
          data = new Float32Array(data);
        }
        this._data = data;
        size != null ? size : size = data == null ? void 0 : data.byteLength;
        const mappedAtCreation = !!data;
        this.descriptor = {
          size,
          usage,
          mappedAtCreation,
          label
        };
        this.shrinkToFit = shrinkToFit != null ? shrinkToFit : true;
      }
      /** the data in the buffer */
      get data() {
        return this._data;
      }
      set data(value) {
        this.setDataWithSize(value, value.length, true);
      }
      get dataInt32() {
        if (!this._dataInt32) {
          this._dataInt32 = new Int32Array(this.data.buffer);
        }
        return this._dataInt32;
      }
      /** whether the buffer is static or not */
      get static() {
        return !!(this.descriptor.usage & BufferUsage.STATIC);
      }
      set static(value) {
        if (value) {
          this.descriptor.usage |= BufferUsage.STATIC;
        } else {
          this.descriptor.usage &= ~BufferUsage.STATIC;
        }
      }
      /**
       * Sets the data in the buffer to the given value. This will immediately update the buffer on the GPU.
       * If you only want to update a subset of the buffer, you can pass in the size of the data.
       * @param value - the data to set
       * @param size - the size of the data in bytes
       * @param syncGPU - should the buffer be updated on the GPU immediately?
       */
      setDataWithSize(value, size, syncGPU) {
        this._updateID++;
        this._updateSize = size * value.BYTES_PER_ELEMENT;
        if (this._data === value) {
          if (syncGPU)
            this.emit("update", this);
          return;
        }
        const oldData = this._data;
        this._data = value;
        this._dataInt32 = null;
        if (!oldData || oldData.length !== value.length) {
          if (!this.shrinkToFit && oldData && value.byteLength < oldData.byteLength) {
            if (syncGPU)
              this.emit("update", this);
          } else {
            this.descriptor.size = value.byteLength;
            this._resourceId = uid$1("resource");
            this.emit("change", this);
          }
          return;
        }
        if (syncGPU)
          this.emit("update", this);
      }
      /**
       * updates the buffer on the GPU to reflect the data in the buffer.
       * By default it will update the entire buffer. If you only want to update a subset of the buffer,
       * you can pass in the size of the buffer to update.
       * @param sizeInBytes - the new size of the buffer in bytes
       */
      update(sizeInBytes) {
        this._updateSize = sizeInBytes != null ? sizeInBytes : this._updateSize;
        this._updateID++;
        this.emit("update", this);
      }
      /** Destroys the buffer */
      destroy() {
        this.destroyed = true;
        this.emit("destroy", this);
        this.emit("change", this);
        this._data = null;
        this.descriptor = null;
        this.removeAllListeners();
      }
    }

    "use strict";
    function ensureIsBuffer(buffer, index) {
      if (!(buffer instanceof Buffer)) {
        let usage = index ? BufferUsage.INDEX : BufferUsage.VERTEX;
        if (buffer instanceof Array) {
          if (index) {
            buffer = new Uint32Array(buffer);
            usage = BufferUsage.INDEX | BufferUsage.COPY_DST;
          } else {
            buffer = new Float32Array(buffer);
            usage = BufferUsage.VERTEX | BufferUsage.COPY_DST;
          }
        }
        buffer = new Buffer({
          data: buffer,
          label: index ? "index-mesh-buffer" : "vertex-mesh-buffer",
          usage
        });
      }
      return buffer;
    }

    "use strict";
    function getGeometryBounds(geometry, attributeId, bounds) {
      const attribute = geometry.getAttribute(attributeId);
      if (!attribute) {
        bounds.minX = 0;
        bounds.minY = 0;
        bounds.maxX = 0;
        bounds.maxY = 0;
        return bounds;
      }
      const data = attribute.buffer.data;
      let minX = Infinity;
      let minY = Infinity;
      let maxX = -Infinity;
      let maxY = -Infinity;
      const byteSize = data.BYTES_PER_ELEMENT;
      const offset = (attribute.offset || 0) / byteSize;
      const stride = (attribute.stride || 2 * 4) / byteSize;
      for (let i = offset; i < data.length; i += stride) {
        const x = data[i];
        const y = data[i + 1];
        if (x > maxX)
          maxX = x;
        if (y > maxY)
          maxY = y;
        if (x < minX)
          minX = x;
        if (y < minY)
          minY = y;
      }
      bounds.minX = minX;
      bounds.minY = minY;
      bounds.maxX = maxX;
      bounds.maxY = maxY;
      return bounds;
    }

    "use strict";
    function ensureIsAttribute(attribute) {
      if (attribute instanceof Buffer || Array.isArray(attribute) || attribute.BYTES_PER_ELEMENT) {
        attribute = {
          buffer: attribute
        };
      }
      attribute.buffer = ensureIsBuffer(attribute.buffer, false);
      return attribute;
    }
    class Geometry extends EventEmitter {
      /**
       * Create a new instance of a geometry
       * @param options - The options for the geometry.
       */
      constructor(options = {}) {
        var _a;
        super();
        /** The unique id of the geometry. */
        this.uid = uid$1("geometry");
        /**
         * the layout key will be generated by WebGPU all geometries that have the same structure
         * will have the same layout key. This is used to cache the pipeline layout
         * @internal
         * @ignore
         */
        this._layoutKey = 0;
        /** the instance count of the geometry to draw */
        this.instanceCount = 1;
        this._bounds = new Bounds();
        this._boundsDirty = true;
        const { attributes, indexBuffer, topology } = options;
        this.buffers = [];
        this.attributes = {};
        if (attributes) {
          for (const i in attributes) {
            this.addAttribute(i, attributes[i]);
          }
        }
        this.instanceCount = (_a = options.instanceCount) != null ? _a : 1;
        if (indexBuffer) {
          this.addIndex(indexBuffer);
        }
        this.topology = topology || "triangle-list";
      }
      onBufferUpdate() {
        this._boundsDirty = true;
        this.emit("update", this);
      }
      /**
       * Returns the requested attribute.
       * @param id - The name of the attribute required
       * @returns - The attribute requested.
       */
      getAttribute(id) {
        return this.attributes[id];
      }
      /**
       * Returns the index buffer
       * @returns - The index buffer.
       */
      getIndex() {
        return this.indexBuffer;
      }
      /**
       * Returns the requested buffer.
       * @param id - The name of the buffer required.
       * @returns - The buffer requested.
       */
      getBuffer(id) {
        return this.getAttribute(id).buffer;
      }
      /**
       * Used to figure out how many vertices there are in this geometry
       * @returns the number of vertices in the geometry
       */
      getSize() {
        for (const i in this.attributes) {
          const attribute = this.attributes[i];
          const buffer = attribute.buffer;
          return buffer.data.length / (attribute.stride / 4 || attribute.size);
        }
        return 0;
      }
      /**
       * Adds an attribute to the geometry.
       * @param name - The name of the attribute to add.
       * @param attributeOption - The attribute option to add.
       */
      addAttribute(name, attributeOption) {
        const attribute = ensureIsAttribute(attributeOption);
        const bufferIndex = this.buffers.indexOf(attribute.buffer);
        if (bufferIndex === -1) {
          this.buffers.push(attribute.buffer);
          attribute.buffer.on("update", this.onBufferUpdate, this);
          attribute.buffer.on("change", this.onBufferUpdate, this);
        }
        this.attributes[name] = attribute;
      }
      /**
       * Adds an index buffer to the geometry.
       * @param indexBuffer - The index buffer to add. Can be a Buffer, TypedArray, or an array of numbers.
       */
      addIndex(indexBuffer) {
        this.indexBuffer = ensureIsBuffer(indexBuffer, true);
        this.buffers.push(this.indexBuffer);
      }
      /** Returns the bounds of the geometry. */
      get bounds() {
        if (!this._boundsDirty)
          return this._bounds;
        this._boundsDirty = false;
        return getGeometryBounds(this, "aPosition", this._bounds);
      }
      /**
       * destroys the geometry.
       * @param destroyBuffers - destroy the buffers associated with this geometry
       */
      destroy(destroyBuffers = false) {
        this.emit("destroy", this);
        this.removeAllListeners();
        if (destroyBuffers) {
          this.buffers.forEach((buffer) => buffer.destroy());
        }
        this.attributes = null;
        this.buffers = null;
        this.indexBuffer = null;
        this._bounds = null;
      }
    }

    "use strict";
    const placeHolderBufferData = new Float32Array(1);
    const placeHolderIndexData = new Uint32Array(1);
    class BatchGeometry extends Geometry {
      constructor() {
        const vertexSize = 6;
        const attributeBuffer = new Buffer({
          data: placeHolderBufferData,
          label: "attribute-batch-buffer",
          usage: BufferUsage.VERTEX | BufferUsage.COPY_DST,
          shrinkToFit: false
        });
        const indexBuffer = new Buffer({
          data: placeHolderIndexData,
          label: "index-batch-buffer",
          usage: BufferUsage.INDEX | BufferUsage.COPY_DST,
          // | BufferUsage.STATIC,
          shrinkToFit: false
        });
        const stride = vertexSize * 4;
        super({
          attributes: {
            aPosition: {
              buffer: attributeBuffer,
              format: "float32x2",
              stride,
              offset: 0
            },
            aUV: {
              buffer: attributeBuffer,
              format: "float32x2",
              stride,
              offset: 2 * 4
            },
            aColor: {
              buffer: attributeBuffer,
              format: "unorm8x4",
              stride,
              offset: 4 * 4
            },
            aTextureIdAndRound: {
              buffer: attributeBuffer,
              format: "uint16x2",
              stride,
              offset: 5 * 4
            }
          },
          indexBuffer
        });
      }
    }

    "use strict";
    const idCounts = /* @__PURE__ */ Object.create(null);
    const idHash = /* @__PURE__ */ Object.create(null);
    function createIdFromString(value, groupId) {
      let id = idHash[value];
      if (id === void 0) {
        if (idCounts[groupId] === void 0) {
          idCounts[groupId] = 1;
        }
        idHash[value] = id = idCounts[groupId]++;
      }
      return id;
    }

    "use strict";
    let maxFragmentPrecision;
    function getMaxFragmentPrecision() {
      if (!maxFragmentPrecision) {
        maxFragmentPrecision = "mediump";
        const gl = getTestContext();
        if (gl) {
          if (gl.getShaderPrecisionFormat) {
            const shaderFragment = gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER, gl.HIGH_FLOAT);
            maxFragmentPrecision = shaderFragment.precision ? "highp" : "mediump";
          }
        }
      }
      return maxFragmentPrecision;
    }

    "use strict";
    function addProgramDefines(src, isES300, isFragment) {
      if (isES300)
        return src;
      if (isFragment) {
        src = src.replace("out vec4 finalColor;", "");
        return `
        
        #ifdef GL_ES // This checks if it is WebGL1
        #define in varying
        #define finalColor gl_FragColor
        #define texture texture2D
        #endif
        ${src}
        `;
      }
      return `
        
        #ifdef GL_ES // This checks if it is WebGL1
        #define in attribute
        #define out varying
        #endif
        ${src}
        `;
    }

    "use strict";
    function ensurePrecision(src, options, isFragment) {
      const maxSupportedPrecision = isFragment ? options.maxSupportedFragmentPrecision : options.maxSupportedVertexPrecision;
      if (src.substring(0, 9) !== "precision") {
        let precision = isFragment ? options.requestedFragmentPrecision : options.requestedVertexPrecision;
        if (precision === "highp" && maxSupportedPrecision !== "highp") {
          precision = "mediump";
        }
        return `precision ${precision} float;
${src}`;
      } else if (maxSupportedPrecision !== "highp" && src.substring(0, 15) === "precision highp") {
        return src.replace("precision highp", "precision mediump");
      }
      return src;
    }

    "use strict";
    function insertVersion(src, isES300) {
      if (!isES300)
        return src;
      return `#version 300 es
${src}`;
    }

    "use strict";
    const fragmentNameCache = {};
    const VertexNameCache = {};
    function setProgramName(src, { name = `pixi-program` }, isFragment = true) {
      name = name.replace(/\s+/g, "-");
      name += isFragment ? "-fragment" : "-vertex";
      const nameCache = isFragment ? fragmentNameCache : VertexNameCache;
      if (nameCache[name]) {
        nameCache[name]++;
        name += `-${nameCache[name]}`;
      } else {
        nameCache[name] = 1;
      }
      if (src.indexOf("#define SHADER_NAME") !== -1)
        return src;
      const shaderName = `#define SHADER_NAME ${name}`;
      return `${shaderName}
${src}`;
    }

    "use strict";
    function stripVersion(src, isES300) {
      if (!isES300)
        return src;
      return src.replace("#version 300 es", "");
    }

    "use strict";
    var __defProp$Z = Object.defineProperty;
    var __getOwnPropSymbols$Z = Object.getOwnPropertySymbols;
    var __hasOwnProp$Z = Object.prototype.hasOwnProperty;
    var __propIsEnum$Z = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$Z = (obj, key, value) => key in obj ? __defProp$Z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$Z = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$Z.call(b, prop))
          __defNormalProp$Z(a, prop, b[prop]);
      if (__getOwnPropSymbols$Z)
        for (var prop of __getOwnPropSymbols$Z(b)) {
          if (__propIsEnum$Z.call(b, prop))
            __defNormalProp$Z(a, prop, b[prop]);
        }
      return a;
    };
    const processes = {
      // strips any version headers..
      stripVersion,
      // adds precision string if not already present
      ensurePrecision,
      // add some defines if WebGL1 to make it more compatible with WebGL2 shaders
      addProgramDefines,
      // add the program name to the shader
      setProgramName,
      // add the version string to the shader header
      insertVersion
    };
    const programCache$1 = /* @__PURE__ */ Object.create(null);
    const _GlProgram = class _GlProgram {
      /**
       * Creates a shiny new GlProgram. Used by WebGL renderer.
       * @param options - The options for the program.
       */
      constructor(options) {
        options = __spreadValues$Z(__spreadValues$Z({}, _GlProgram.defaultOptions), options);
        const isES300 = options.fragment.indexOf("#version 300 es") !== -1;
        const preprocessorOptions = {
          stripVersion: isES300,
          ensurePrecision: {
            requestedFragmentPrecision: options.preferredFragmentPrecision,
            requestedVertexPrecision: options.preferredVertexPrecision,
            maxSupportedVertexPrecision: "highp",
            maxSupportedFragmentPrecision: getMaxFragmentPrecision()
          },
          setProgramName: {
            name: options.name
          },
          addProgramDefines: isES300,
          insertVersion: isES300
        };
        let fragment = options.fragment;
        let vertex = options.vertex;
        Object.keys(processes).forEach((processKey) => {
          const processOptions = preprocessorOptions[processKey];
          fragment = processes[processKey](fragment, processOptions, true);
          vertex = processes[processKey](vertex, processOptions, false);
        });
        this.fragment = fragment;
        this.vertex = vertex;
        this.transformFeedbackVaryings = options.transformFeedbackVaryings;
        this._key = createIdFromString(`${this.vertex}:${this.fragment}`, "gl-program");
      }
      /** destroys the program */
      destroy() {
        this.fragment = null;
        this.vertex = null;
        this._attributeData = null;
        this._uniformData = null;
        this._uniformBlockData = null;
        this.transformFeedbackVaryings = null;
      }
      /**
       * Helper function that creates a program for a given source.
       * It will check the program cache if the program has already been created.
       * If it has that one will be returned, if not a new one will be created and cached.
       * @param options - The options for the program.
       * @returns A program using the same source
       */
      static from(options) {
        const key = `${options.vertex}:${options.fragment}`;
        if (!programCache$1[key]) {
          programCache$1[key] = new _GlProgram(options);
        }
        return programCache$1[key];
      }
    };
    /** The default options used by the program. */
    _GlProgram.defaultOptions = {
      preferredVertexPrecision: "highp",
      preferredFragmentPrecision: "mediump"
    };
    let GlProgram = _GlProgram;

    "use strict";
    const attributeFormatData = {
      uint8x2: { size: 2, stride: 2, normalised: false },
      uint8x4: { size: 4, stride: 4, normalised: false },
      sint8x2: { size: 2, stride: 2, normalised: false },
      sint8x4: { size: 4, stride: 4, normalised: false },
      unorm8x2: { size: 2, stride: 2, normalised: true },
      unorm8x4: { size: 4, stride: 4, normalised: true },
      snorm8x2: { size: 2, stride: 2, normalised: true },
      snorm8x4: { size: 4, stride: 4, normalised: true },
      uint16x2: { size: 2, stride: 4, normalised: false },
      uint16x4: { size: 4, stride: 8, normalised: false },
      sint16x2: { size: 2, stride: 4, normalised: false },
      sint16x4: { size: 4, stride: 8, normalised: false },
      unorm16x2: { size: 2, stride: 4, normalised: true },
      unorm16x4: { size: 4, stride: 8, normalised: true },
      snorm16x2: { size: 2, stride: 4, normalised: true },
      snorm16x4: { size: 4, stride: 8, normalised: true },
      float16x2: { size: 2, stride: 4, normalised: false },
      float16x4: { size: 4, stride: 8, normalised: false },
      float32: { size: 1, stride: 4, normalised: false },
      float32x2: { size: 2, stride: 8, normalised: false },
      float32x3: { size: 3, stride: 12, normalised: false },
      float32x4: { size: 4, stride: 16, normalised: false },
      uint32: { size: 1, stride: 4, normalised: false },
      uint32x2: { size: 2, stride: 8, normalised: false },
      uint32x3: { size: 3, stride: 12, normalised: false },
      uint32x4: { size: 4, stride: 16, normalised: false },
      sint32: { size: 1, stride: 4, normalised: false },
      sint32x2: { size: 2, stride: 8, normalised: false },
      sint32x3: { size: 3, stride: 12, normalised: false },
      sint32x4: { size: 4, stride: 16, normalised: false }
    };
    function getAttributeInfoFromFormat(format) {
      var _a;
      return (_a = attributeFormatData[format]) != null ? _a : attributeFormatData.float32;
    }

    "use strict";
    const WGSL_TO_VERTEX_TYPES = {
      f32: "float32",
      "vec2<f32>": "float32x2",
      "vec3<f32>": "float32x3",
      "vec4<f32>": "float32x4",
      vec2f: "float32x2",
      vec3f: "float32x3",
      vec4f: "float32x4",
      i32: "sint32",
      "vec2<i32>": "sint32x2",
      "vec3<i32>": "sint32x3",
      "vec4<i32>": "sint32x4",
      u32: "uint32",
      "vec2<u32>": "uint32x2",
      "vec3<u32>": "uint32x3",
      "vec4<u32>": "uint32x4",
      bool: "uint32",
      "vec2<bool>": "uint32x2",
      "vec3<bool>": "uint32x3",
      "vec4<bool>": "uint32x4"
    };
    function extractAttributesFromGpuProgram({ source, entryPoint }) {
      var _a;
      const results = {};
      const mainVertStart = source.indexOf(`fn ${entryPoint}`);
      if (mainVertStart !== -1) {
        const arrowFunctionStart = source.indexOf("->", mainVertStart);
        if (arrowFunctionStart !== -1) {
          const functionArgsSubstring = source.substring(mainVertStart, arrowFunctionStart);
          const inputsRegex = /@location\((\d+)\)\s+([a-zA-Z0-9_]+)\s*:\s*([a-zA-Z0-9_<>]+)(?:,|\s|$)/g;
          let match;
          while ((match = inputsRegex.exec(functionArgsSubstring)) !== null) {
            const format = (_a = WGSL_TO_VERTEX_TYPES[match[3]]) != null ? _a : "float32";
            results[match[2]] = {
              location: parseInt(match[1], 10),
              format,
              stride: getAttributeInfoFromFormat(format).stride,
              offset: 0,
              instance: false,
              start: 0
            };
          }
        }
      }
      return results;
    }

    "use strict";
    function extractStructAndGroups(wgsl) {
      var _a, _b, _c;
      const linePattern = /(^|[^/])@(group|binding)\(\d+\)[^;]+;/g;
      const groupPattern = /@group\((\d+)\)/;
      const bindingPattern = /@binding\((\d+)\)/;
      const namePattern = /var(<[^>]+>)? (\w+)/;
      const typePattern = /:\s*(\w+)/;
      const structPattern = /struct\s+(\w+)\s*{([^}]+)}/g;
      const structMemberPattern = /(\w+)\s*:\s*([\w\<\>]+)/g;
      const structName = /struct\s+(\w+)/;
      const groups = (_a = wgsl.match(linePattern)) == null ? void 0 : _a.map((item) => ({
        group: parseInt(item.match(groupPattern)[1], 10),
        binding: parseInt(item.match(bindingPattern)[1], 10),
        name: item.match(namePattern)[2],
        isUniform: item.match(namePattern)[1] === "<uniform>",
        type: item.match(typePattern)[1]
      }));
      if (!groups) {
        return {
          groups: [],
          structs: []
        };
      }
      const structs = (_c = (_b = wgsl.match(structPattern)) == null ? void 0 : _b.map((struct) => {
        const name = struct.match(structName)[1];
        const members = struct.match(structMemberPattern).reduce((acc, member) => {
          const [name2, type] = member.split(":");
          acc[name2.trim()] = type.trim();
          return acc;
        }, {});
        if (!members) {
          return null;
        }
        return { name, members };
      }).filter(({ name }) => groups.some((group) => group.type === name))) != null ? _c : [];
      return {
        groups,
        structs
      };
    }

    "use strict";
    var ShaderStage = /* @__PURE__ */ ((ShaderStage2) => {
      ShaderStage2[ShaderStage2["VERTEX"] = 1] = "VERTEX";
      ShaderStage2[ShaderStage2["FRAGMENT"] = 2] = "FRAGMENT";
      ShaderStage2[ShaderStage2["COMPUTE"] = 4] = "COMPUTE";
      return ShaderStage2;
    })(ShaderStage || {});

    "use strict";
    function generateGpuLayoutGroups({ groups }) {
      const layout = [];
      for (let i = 0; i < groups.length; i++) {
        const group = groups[i];
        if (!layout[group.group]) {
          layout[group.group] = [];
        }
        if (group.isUniform) {
          layout[group.group].push({
            binding: group.binding,
            visibility: ShaderStage.VERTEX | ShaderStage.FRAGMENT,
            buffer: {
              type: "uniform"
            }
          });
        } else if (group.type === "sampler") {
          layout[group.group].push({
            binding: group.binding,
            visibility: ShaderStage.FRAGMENT,
            sampler: {
              type: "filtering"
            }
          });
        } else if (group.type === "texture_2d") {
          layout[group.group].push({
            binding: group.binding,
            visibility: ShaderStage.FRAGMENT,
            texture: {
              sampleType: "float",
              viewDimension: "2d",
              multisampled: false
            }
          });
        }
      }
      return layout;
    }

    "use strict";
    function generateLayoutHash({ groups }) {
      const layout = [];
      for (let i = 0; i < groups.length; i++) {
        const group = groups[i];
        if (!layout[group.group]) {
          layout[group.group] = {};
        }
        layout[group.group][group.name] = group.binding;
      }
      return layout;
    }

    "use strict";
    function removeStructAndGroupDuplicates(vertexStructsAndGroups, fragmentStructsAndGroups) {
      const structNameSet = /* @__PURE__ */ new Set();
      const dupeGroupKeySet = /* @__PURE__ */ new Set();
      const structs = [...vertexStructsAndGroups.structs, ...fragmentStructsAndGroups.structs].filter((struct) => {
        if (structNameSet.has(struct.name)) {
          return false;
        }
        structNameSet.add(struct.name);
        return true;
      });
      const groups = [...vertexStructsAndGroups.groups, ...fragmentStructsAndGroups.groups].filter((group) => {
        const key = `${group.name}-${group.binding}`;
        if (dupeGroupKeySet.has(key)) {
          return false;
        }
        dupeGroupKeySet.add(key);
        return true;
      });
      return { structs, groups };
    }

    "use strict";
    const programCache = /* @__PURE__ */ Object.create(null);
    class GpuProgram {
      /**
       * Create a new GpuProgram
       * @param options - The options for the gpu program
       */
      constructor(options) {
        /**
         * @internal
         * @ignore
         */
        this._layoutKey = 0;
        /**
         * @internal
         * @ignore
         */
        this._attributeLocationsKey = 0;
        var _a, _b;
        const { fragment, vertex, layout, gpuLayout, name } = options;
        this.name = name;
        this.fragment = fragment;
        this.vertex = vertex;
        if (fragment.source === vertex.source) {
          const structsAndGroups = extractStructAndGroups(fragment.source);
          this.structsAndGroups = structsAndGroups;
        } else {
          const vertexStructsAndGroups = extractStructAndGroups(vertex.source);
          const fragmentStructsAndGroups = extractStructAndGroups(fragment.source);
          this.structsAndGroups = removeStructAndGroupDuplicates(vertexStructsAndGroups, fragmentStructsAndGroups);
        }
        this.layout = layout != null ? layout : generateLayoutHash(this.structsAndGroups);
        this.gpuLayout = gpuLayout != null ? gpuLayout : generateGpuLayoutGroups(this.structsAndGroups);
        this.autoAssignGlobalUniforms = !!(((_a = this.layout[0]) == null ? void 0 : _a.globalUniforms) !== void 0);
        this.autoAssignLocalUniforms = !!(((_b = this.layout[1]) == null ? void 0 : _b.localUniforms) !== void 0);
        this._generateProgramKey();
      }
      // TODO maker this pure
      _generateProgramKey() {
        const { vertex, fragment } = this;
        const bigKey = vertex.source + fragment.source + vertex.entryPoint + fragment.entryPoint;
        this._layoutKey = createIdFromString(bigKey, "program");
      }
      get attributeData() {
        var _a;
        (_a = this._attributeData) != null ? _a : this._attributeData = extractAttributesFromGpuProgram(this.vertex);
        return this._attributeData;
      }
      /** destroys the program */
      destroy() {
        this.gpuLayout = null;
        this.layout = null;
        this.structsAndGroups = null;
        this.fragment = null;
        this.vertex = null;
      }
      /**
       * Helper function that creates a program for a given source.
       * It will check the program cache if the program has already been created.
       * If it has that one will be returned, if not a new one will be created and cached.
       * @param options - The options for the program.
       * @returns A program using the same source
       */
      static from(options) {
        const key = `${options.vertex.source}:${options.fragment.source}:${options.fragment.entryPoint}:${options.vertex.entryPoint}`;
        if (!programCache[key]) {
          programCache[key] = new GpuProgram(options);
        }
        return programCache[key];
      }
    }

    "use strict";
    function addBits(srcParts, parts, name) {
      if (srcParts) {
        for (const i in srcParts) {
          const id = i.toLocaleLowerCase();
          const part = parts[id];
          if (part) {
            let sanitisedPart = srcParts[i];
            if (i === "header") {
              sanitisedPart = sanitisedPart.replace(/@in\s+[^;]+;\s*/g, "").replace(/@out\s+[^;]+;\s*/g, "");
            }
            if (name) {
              part.push(`//----${name}----//`);
            }
            part.push(sanitisedPart);
          } else {
            warn(`${i} placement hook does not exist in shader`);
          }
        }
      }
    }

    "use strict";
    const findHooksRx = /\{\{(.*?)\}\}/g;
    function compileHooks(programSrc) {
      var _a, _b;
      const parts = {};
      const partMatches = (_b = (_a = programSrc.match(findHooksRx)) == null ? void 0 : _a.map((hook) => hook.replace(/[{()}]/g, ""))) != null ? _b : [];
      partMatches.forEach((hook) => {
        parts[hook] = [];
      });
      return parts;
    }

    "use strict";
    function extractInputs(fragmentSource, out) {
      let match;
      const regex = /@in\s+([^;]+);/g;
      while ((match = regex.exec(fragmentSource)) !== null) {
        out.push(match[1]);
      }
    }
    function compileInputs(fragments, template, sort = false) {
      const results = [];
      extractInputs(template, results);
      fragments.forEach((fragment) => {
        if (fragment.header) {
          extractInputs(fragment.header, results);
        }
      });
      const mainInput = results;
      if (sort) {
        mainInput.sort();
      }
      const finalString = mainInput.map((inValue, i) => `       @location(${i}) ${inValue},`).join("\n");
      let cleanedString = template.replace(/@in\s+[^;]+;\s*/g, "");
      cleanedString = cleanedString.replace("{{in}}", `
${finalString}
`);
      return cleanedString;
    }

    "use strict";
    function extractOutputs(fragmentSource, out) {
      let match;
      const regex = /@out\s+([^;]+);/g;
      while ((match = regex.exec(fragmentSource)) !== null) {
        out.push(match[1]);
      }
    }
    function extractVariableName(value) {
      const regex = /\b(\w+)\s*:/g;
      const match = regex.exec(value);
      return match ? match[1] : "";
    }
    function stripVariable(value) {
      const regex = /@.*?\s+/g;
      return value.replace(regex, "");
    }
    function compileOutputs(fragments, template) {
      const results = [];
      extractOutputs(template, results);
      fragments.forEach((fragment) => {
        if (fragment.header) {
          extractOutputs(fragment.header, results);
        }
      });
      let index = 0;
      const mainStruct = results.sort().map((inValue) => {
        if (inValue.indexOf("builtin") > -1) {
          return inValue;
        }
        return `@location(${index++}) ${inValue}`;
      }).join(",\n");
      const mainStart = results.sort().map((inValue) => `       var ${stripVariable(inValue)};`).join("\n");
      const mainEnd = `return VSOutput(
                ${results.sort().map((inValue) => ` ${extractVariableName(inValue)}`).join(",\n")});`;
      let compiledCode = template.replace(/@out\s+[^;]+;\s*/g, "");
      compiledCode = compiledCode.replace("{{struct}}", `
${mainStruct}
`);
      compiledCode = compiledCode.replace("{{start}}", `
${mainStart}
`);
      compiledCode = compiledCode.replace("{{return}}", `
${mainEnd}
`);
      return compiledCode;
    }

    "use strict";
    function injectBits(templateSrc, fragmentParts) {
      let out = templateSrc;
      for (const i in fragmentParts) {
        const parts = fragmentParts[i];
        const toInject = parts.join("\n");
        if (toInject.length) {
          out = out.replace(`{{${i}}}`, `//-----${i} START-----//
${parts.join("\n")}
//----${i} FINISH----//`);
        } else {
          out = out.replace(`{{${i}}}`, "");
        }
      }
      return out;
    }

    "use strict";
    const cacheMap = /* @__PURE__ */ Object.create(null);
    const bitCacheMap = /* @__PURE__ */ new Map();
    let CACHE_UID = 0;
    function compileHighShader({
      template,
      bits
    }) {
      const cacheId = generateCacheId(template, bits);
      if (cacheMap[cacheId])
        return cacheMap[cacheId];
      const { vertex, fragment } = compileInputsAndOutputs(template, bits);
      cacheMap[cacheId] = compileBits(vertex, fragment, bits);
      return cacheMap[cacheId];
    }
    function compileHighShaderGl({
      template,
      bits
    }) {
      const cacheId = generateCacheId(template, bits);
      if (cacheMap[cacheId])
        return cacheMap[cacheId];
      cacheMap[cacheId] = compileBits(template.vertex, template.fragment, bits);
      return cacheMap[cacheId];
    }
    function compileInputsAndOutputs(template, bits) {
      const vertexFragments = bits.map((shaderBit) => shaderBit.vertex).filter((v) => !!v);
      const fragmentFragments = bits.map((shaderBit) => shaderBit.fragment).filter((v) => !!v);
      let compiledVertex = compileInputs(vertexFragments, template.vertex, true);
      compiledVertex = compileOutputs(vertexFragments, compiledVertex);
      const compiledFragment = compileInputs(fragmentFragments, template.fragment, true);
      return {
        vertex: compiledVertex,
        fragment: compiledFragment
      };
    }
    function generateCacheId(template, bits) {
      return bits.map((highFragment) => {
        if (!bitCacheMap.has(highFragment)) {
          bitCacheMap.set(highFragment, CACHE_UID++);
        }
        return bitCacheMap.get(highFragment);
      }).sort((a, b) => a - b).join("-") + template.vertex + template.fragment;
    }
    function compileBits(vertex, fragment, bits) {
      const vertexParts = compileHooks(vertex);
      const fragmentParts = compileHooks(fragment);
      bits.forEach((shaderBit) => {
        addBits(shaderBit.vertex, vertexParts, shaderBit.name);
        addBits(shaderBit.fragment, fragmentParts, shaderBit.name);
      });
      return {
        vertex: injectBits(vertex, vertexParts),
        fragment: injectBits(fragment, fragmentParts)
      };
    }

    "use strict";
    const vertexGPUTemplate = (
      /* wgsl */
      `
    @in aPosition: vec2<f32>;
    @in aUV: vec2<f32>;

    @out @builtin(position) vPosition: vec4<f32>;
    @out vUV : vec2<f32>;
    @out vColor : vec4<f32>;

    {{header}}

    struct VSOutput {
        {{struct}}
    };

    @vertex
    fn main( {{in}} ) -> VSOutput {

        var worldTransformMatrix = globalUniforms.uWorldTransformMatrix;
        var modelMatrix = mat3x3<f32>(
            1.0, 0.0, 0.0,
            0.0, 1.0, 0.0,
            0.0, 0.0, 1.0
          );
        var position = aPosition;
        var uv = aUV;

        {{start}}
        
        vColor = vec4<f32>(1., 1., 1., 1.);

        {{main}}

        vUV = uv;

        var modelViewProjectionMatrix = globalUniforms.uProjectionMatrix * worldTransformMatrix * modelMatrix;

        vPosition =  vec4<f32>((modelViewProjectionMatrix *  vec3<f32>(position, 1.0)).xy, 0.0, 1.0);
       
        vColor *= globalUniforms.uWorldColorAlpha;

        {{end}}

        {{return}}
    };
`
    );
    const fragmentGPUTemplate = (
      /* wgsl */
      `
    @in vUV : vec2<f32>;
    @in vColor : vec4<f32>;
   
    {{header}}

    @fragment
    fn main(
        {{in}}
      ) -> @location(0) vec4<f32> {
        
        {{start}}

        var outColor:vec4<f32>;
      
        {{main}}
        
        var finalColor:vec4<f32> = outColor * vColor;

        {{end}}

        return finalColor;
      };
`
    );
    const vertexGlTemplate = (
      /* glsl */
      `
    in vec2 aPosition;
    in vec2 aUV;

    out vec4 vColor;
    out vec2 vUV;

    {{header}}

    void main(void){

        mat3 worldTransformMatrix = uWorldTransformMatrix;
        mat3 modelMatrix = mat3(
            1.0, 0.0, 0.0,
            0.0, 1.0, 0.0,
            0.0, 0.0, 1.0
          );
        vec2 position = aPosition;
        vec2 uv = aUV;
        
        {{start}}
        
        vColor = vec4(1.);
        
        {{main}}
        
        vUV = uv;
        
        mat3 modelViewProjectionMatrix = uProjectionMatrix * worldTransformMatrix * modelMatrix;

        gl_Position = vec4((modelViewProjectionMatrix * vec3(position, 1.0)).xy, 0.0, 1.0);

        vColor *= uWorldColorAlpha;

        {{end}}
    }
`
    );
    const fragmentGlTemplate = (
      /* glsl */
      `
   
    in vec4 vColor;
    in vec2 vUV;

    out vec4 finalColor;

    {{header}}

    void main(void) {
        
        {{start}}

        vec4 outColor;
      
        {{main}}
        
        finalColor = outColor * vColor;
        
        {{end}}
    }
`
    );

    "use strict";
    const globalUniformsBit = {
      name: "global-uniforms-bit",
      vertex: {
        header: (
          /* wgsl */
          `
        struct GlobalUniforms {
            uProjectionMatrix:mat3x3<f32>,
            uWorldTransformMatrix:mat3x3<f32>,
            uWorldColorAlpha: vec4<f32>,
            uResolution: vec2<f32>,
        }

        @group(0) @binding(0) var<uniform> globalUniforms : GlobalUniforms;
        `
        )
      }
    };
    const globalUniformsUBOBitGl = {
      name: "global-uniforms-ubo-bit",
      vertex: {
        header: (
          /* glsl */
          `
          uniform globalUniforms {
            mat3 uProjectionMatrix;
            mat3 uWorldTransformMatrix;
            vec4 uWorldColorAlpha;
            vec2 uResolution;
          };
        `
        )
      }
    };
    const globalUniformsBitGl = {
      name: "global-uniforms-bit",
      vertex: {
        header: (
          /* glsl */
          `
          uniform mat3 uProjectionMatrix;
          uniform mat3 uWorldTransformMatrix;
          uniform vec4 uWorldColorAlpha;
          uniform vec2 uResolution;
        `
        )
      }
    };

    "use strict";
    var __defProp$Y = Object.defineProperty;
    var __getOwnPropSymbols$Y = Object.getOwnPropertySymbols;
    var __hasOwnProp$Y = Object.prototype.hasOwnProperty;
    var __propIsEnum$Y = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$Y = (obj, key, value) => key in obj ? __defProp$Y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$Y = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$Y.call(b, prop))
          __defNormalProp$Y(a, prop, b[prop]);
      if (__getOwnPropSymbols$Y)
        for (var prop of __getOwnPropSymbols$Y(b)) {
          if (__propIsEnum$Y.call(b, prop))
            __defNormalProp$Y(a, prop, b[prop]);
        }
      return a;
    };
    function compileHighShaderGpuProgram({ bits, name }) {
      const source = compileHighShader({
        template: {
          fragment: fragmentGPUTemplate,
          vertex: vertexGPUTemplate
        },
        bits: [
          globalUniformsBit,
          ...bits
        ]
      });
      return GpuProgram.from({
        name,
        vertex: {
          source: source.vertex,
          entryPoint: "main"
        },
        fragment: {
          source: source.fragment,
          entryPoint: "main"
        }
      });
    }
    function compileHighShaderGlProgram({ bits, name }) {
      return new GlProgram(__spreadValues$Y({
        name
      }, compileHighShaderGl({
        template: {
          vertex: vertexGlTemplate,
          fragment: fragmentGlTemplate
        },
        bits: [
          globalUniformsBitGl,
          ...bits
        ]
      })));
    }

    "use strict";
    const colorBit = {
      name: "color-bit",
      vertex: {
        header: (
          /* wgsl */
          `
            @in aColor: vec4<f32>;
        `
        ),
        main: (
          /* wgsl */
          `
            vColor *= vec4<f32>(aColor.rgb * aColor.a, aColor.a);
        `
        )
      }
    };
    const colorBitGl = {
      name: "color-bit",
      vertex: {
        header: (
          /* glsl */
          `
            in vec4 aColor;
        `
        ),
        main: (
          /* glsl */
          `
            vColor *= vec4(aColor.rgb * aColor.a, aColor.a);
        `
        )
      }
    };

    "use strict";
    const textureBatchBitGpuCache = {};
    function generateBindingSrc(maxTextures) {
      const src = [];
      if (maxTextures === 1) {
        src.push("@group(1) @binding(0) var textureSource1: texture_2d<f32>;");
        src.push("@group(1) @binding(1) var textureSampler1: sampler;");
      } else {
        let bindingIndex = 0;
        for (let i = 0; i < maxTextures; i++) {
          src.push(`@group(1) @binding(${bindingIndex++}) var textureSource${i + 1}: texture_2d<f32>;`);
          src.push(`@group(1) @binding(${bindingIndex++}) var textureSampler${i + 1}: sampler;`);
        }
      }
      return src.join("\n");
    }
    function generateSampleSrc(maxTextures) {
      const src = [];
      if (maxTextures === 1) {
        src.push("outColor = textureSampleGrad(textureSource1, textureSampler1, vUV, uvDx, uvDy);");
      } else {
        src.push("switch vTextureId {");
        for (let i = 0; i < maxTextures; i++) {
          if (i === maxTextures - 1) {
            src.push(`  default:{`);
          } else {
            src.push(`  case ${i}:{`);
          }
          src.push(`      outColor = textureSampleGrad(textureSource${i + 1}, textureSampler${i + 1}, vUV, uvDx, uvDy);`);
          src.push(`      break;}`);
        }
        src.push(`}`);
      }
      return src.join("\n");
    }
    function generateTextureBatchBit(maxTextures) {
      if (!textureBatchBitGpuCache[maxTextures]) {
        textureBatchBitGpuCache[maxTextures] = {
          name: "texture-batch-bit",
          vertex: {
            header: `
                @in aTextureIdAndRound: vec2<u32>;
                @out @interpolate(flat) vTextureId : u32;
            `,
            main: `
                vTextureId = aTextureIdAndRound.y;
            `,
            end: `
                if(aTextureIdAndRound.x == 1)
                {
                    vPosition = vec4<f32>(roundPixels(vPosition.xy, globalUniforms.uResolution), vPosition.zw);
                }
            `
          },
          fragment: {
            header: `
                @in @interpolate(flat) vTextureId: u32;

                ${generateBindingSrc(maxTextures)}
            `,
            main: `
                var uvDx = dpdx(vUV);
                var uvDy = dpdy(vUV);

                ${generateSampleSrc(maxTextures)}
            `
          }
        };
      }
      return textureBatchBitGpuCache[maxTextures];
    }
    const textureBatchBitGlCache = {};
    function generateSampleGlSrc(maxTextures) {
      const src = [];
      for (let i = 0; i < maxTextures; i++) {
        if (i > 0) {
          src.push("else");
        }
        if (i < maxTextures - 1) {
          src.push(`if(vTextureId < ${i}.5)`);
        }
        src.push("{");
        src.push(`	outColor = texture(uTextures[${i}], vUV);`);
        src.push("}");
      }
      return src.join("\n");
    }
    function generateTextureBatchBitGl(maxTextures) {
      if (!textureBatchBitGlCache[maxTextures]) {
        textureBatchBitGlCache[maxTextures] = {
          name: "texture-batch-bit",
          vertex: {
            header: `
                in vec2 aTextureIdAndRound;
                out float vTextureId;

            `,
            main: `
                vTextureId = aTextureIdAndRound.y;
            `,
            end: `
                if(aTextureIdAndRound.x == 1.)
                {
                    gl_Position.xy = roundPixels(gl_Position.xy, uResolution);
                }
            `
          },
          fragment: {
            header: `
                in float vTextureId;

                uniform sampler2D uTextures[${maxTextures}];

            `,
            main: `

                ${generateSampleGlSrc(maxTextures)}
            `
          }
        };
      }
      return textureBatchBitGlCache[maxTextures];
    }

    "use strict";
    const roundPixelsBit = {
      name: "round-pixels-bit",
      vertex: {
        header: (
          /* wgsl */
          `
            fn roundPixels(position: vec2<f32>, targetSize: vec2<f32>) -> vec2<f32> 
            {
                return (floor(((position * 0.5 + 0.5) * targetSize) + 0.5) / targetSize) * 2.0 - 1.0;
            }
        `
        )
      }
    };
    const roundPixelsBitGl = {
      name: "round-pixels-bit",
      vertex: {
        header: (
          /* glsl */
          `   
            vec2 roundPixels(vec2 position, vec2 targetSize)
            {       
                return (floor(((position * 0.5 + 0.5) * targetSize) + 0.5) / targetSize) * 2.0 - 1.0;
            }
        `
        )
      }
    };

    "use strict";
    const UNIFORM_TYPES_VALUES = [
      "f32",
      "i32",
      "vec2<f32>",
      "vec3<f32>",
      "vec4<f32>",
      "mat2x2<f32>",
      "mat3x3<f32>",
      "mat4x4<f32>",
      "mat3x2<f32>",
      "mat4x2<f32>",
      "mat2x3<f32>",
      "mat4x3<f32>",
      "mat2x4<f32>",
      "mat3x4<f32>",
      "vec2<i32>",
      "vec3<i32>",
      "vec4<i32>"
    ];
    const UNIFORM_TYPES_MAP = UNIFORM_TYPES_VALUES.reduce((acc, type) => {
      acc[type] = true;
      return acc;
    }, {});

    "use strict";
    function getDefaultUniformValue(type, size) {
      switch (type) {
        case "f32":
          return 0;
        case "vec2<f32>":
          return new Float32Array(2 * size);
        case "vec3<f32>":
          return new Float32Array(3 * size);
        case "vec4<f32>":
          return new Float32Array(4 * size);
        case "mat2x2<f32>":
          return new Float32Array([
            1,
            0,
            0,
            1
          ]);
        case "mat3x3<f32>":
          return new Float32Array([
            1,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            1
          ]);
        case "mat4x4<f32>":
          return new Float32Array([
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1
          ]);
      }
      return null;
    }

    "use strict";
    var __defProp$X = Object.defineProperty;
    var __getOwnPropSymbols$X = Object.getOwnPropertySymbols;
    var __hasOwnProp$X = Object.prototype.hasOwnProperty;
    var __propIsEnum$X = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$X = (obj, key, value) => key in obj ? __defProp$X(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$X = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$X.call(b, prop))
          __defNormalProp$X(a, prop, b[prop]);
      if (__getOwnPropSymbols$X)
        for (var prop of __getOwnPropSymbols$X(b)) {
          if (__propIsEnum$X.call(b, prop))
            __defNormalProp$X(a, prop, b[prop]);
        }
      return a;
    };
    const _UniformGroup = class _UniformGroup {
      /**
       * Create a new Uniform group
       * @param uniformStructures - The structures of the uniform group
       * @param options - The optional parameters of this uniform group
       */
      constructor(uniformStructures, options) {
        /** used internally to know if a uniform group was used in the last render pass */
        this._touched = 0;
        /** a unique id for this uniform group used through the renderer */
        this.uid = uid$1("uniform");
        /** a resource type, used to identify how to handle it when its in a bind group / shader resource */
        this._resourceType = "uniformGroup";
        /** the resource id used internally by the renderer to build bind group keys */
        this._resourceId = uid$1("resource");
        /** used ito identify if this is a uniform group */
        this.isUniformGroup = true;
        /**
         * used to flag if this Uniform groups data is different from what it has stored in its buffer / on the GPU
         * @internal
         * @ignore
         */
        this._dirtyId = 0;
        // implementing the interface - UniformGroup are not destroyed
        this.destroyed = false;
        var _a, _b;
        options = __spreadValues$X(__spreadValues$X({}, _UniformGroup.defaultOptions), options);
        this.uniformStructures = uniformStructures;
        const uniforms = {};
        for (const i in uniformStructures) {
          const uniformData = uniformStructures[i];
          uniformData.name = i;
          uniformData.size = (_a = uniformData.size) != null ? _a : 1;
          if (!UNIFORM_TYPES_MAP[uniformData.type]) {
            throw new Error(`Uniform type ${uniformData.type} is not supported. Supported uniform types are: ${UNIFORM_TYPES_VALUES.join(", ")}`);
          }
          (_b = uniformData.value) != null ? _b : uniformData.value = getDefaultUniformValue(uniformData.type, uniformData.size);
          uniforms[i] = uniformData.value;
        }
        this.uniforms = uniforms;
        this._dirtyId = 1;
        this.ubo = options.ubo;
        this.isStatic = options.isStatic;
        this._signature = createIdFromString(Object.keys(uniforms).map(
          (i) => `${i}-${uniformStructures[i].type}`
        ).join("-"), "uniform-group");
      }
      /** Call this if you want the uniform groups data to be uploaded to the GPU only useful if `isStatic` is true. */
      update() {
        this._dirtyId++;
      }
    };
    /** The default options used by the uniform group. */
    _UniformGroup.defaultOptions = {
      /** if true the UniformGroup is handled as an Uniform buffer object. */
      ubo: false,
      /** if true, then you are responsible for when the data is uploaded to the GPU by calling `update()` */
      isStatic: false
    };
    let UniformGroup = _UniformGroup;

    "use strict";
    const batchSamplersUniformGroupHash = {};
    function getBatchSamplersUniformGroup(maxTextures) {
      let batchSamplersUniformGroup = batchSamplersUniformGroupHash[maxTextures];
      if (batchSamplersUniformGroup)
        return batchSamplersUniformGroup;
      const sampleValues = new Int32Array(maxTextures);
      for (let i = 0; i < maxTextures; i++) {
        sampleValues[i] = i;
      }
      batchSamplersUniformGroup = batchSamplersUniformGroupHash[maxTextures] = new UniformGroup({
        uTextures: { value: sampleValues, type: `i32`, size: maxTextures }
      }, { isStatic: true });
      return batchSamplersUniformGroup;
    }

    "use strict";
    var RendererType = /* @__PURE__ */ ((RendererType2) => {
      RendererType2[RendererType2["WEBGL"] = 1] = "WEBGL";
      RendererType2[RendererType2["WEBGPU"] = 2] = "WEBGPU";
      RendererType2[RendererType2["BOTH"] = 3] = "BOTH";
      return RendererType2;
    })(RendererType || {});

    "use strict";
    var __defProp$W = Object.defineProperty;
    var __getOwnPropSymbols$W = Object.getOwnPropertySymbols;
    var __hasOwnProp$W = Object.prototype.hasOwnProperty;
    var __propIsEnum$W = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$W = (obj, key, value) => key in obj ? __defProp$W(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$W = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$W.call(b, prop))
          __defNormalProp$W(a, prop, b[prop]);
      if (__getOwnPropSymbols$W)
        for (var prop of __getOwnPropSymbols$W(b)) {
          if (__propIsEnum$W.call(b, prop))
            __defNormalProp$W(a, prop, b[prop]);
        }
      return a;
    };
    var __objRest$k = (source, exclude) => {
      var target = {};
      for (var prop in source)
        if (__hasOwnProp$W.call(source, prop) && exclude.indexOf(prop) < 0)
          target[prop] = source[prop];
      if (source != null && __getOwnPropSymbols$W)
        for (var prop of __getOwnPropSymbols$W(source)) {
          if (exclude.indexOf(prop) < 0 && __propIsEnum$W.call(source, prop))
            target[prop] = source[prop];
        }
      return target;
    };
    class Shader extends EventEmitter {
      constructor(options) {
        super();
        /**
         * A record of the uniform groups and resources used by the shader.
         * This is used by WebGL renderer to sync uniform data.
         * @internal
         * @ignore
         */
        this._uniformBindMap = /* @__PURE__ */ Object.create(null);
        this._ownedBindGroups = [];
        let {
          gpuProgram,
          glProgram,
          groups,
          resources,
          compatibleRenderers,
          groupMap
        } = options;
        this.gpuProgram = gpuProgram;
        this.glProgram = glProgram;
        if (compatibleRenderers === void 0) {
          compatibleRenderers = 0;
          if (gpuProgram)
            compatibleRenderers |= RendererType.WEBGPU;
          if (glProgram)
            compatibleRenderers |= RendererType.WEBGL;
        }
        this.compatibleRenderers = compatibleRenderers;
        const nameHash = {};
        if (!resources && !groups) {
          resources = {};
        }
        if (resources && groups) {
          throw new Error("[Shader] Cannot have both resources and groups");
        } else if (!gpuProgram && groups && !groupMap) {
          throw new Error("[Shader] No group map or WebGPU shader provided - consider using resources instead.");
        } else if (!gpuProgram && groups && groupMap) {
          for (const i in groupMap) {
            for (const j in groupMap[i]) {
              const uniformName = groupMap[i][j];
              nameHash[uniformName] = {
                group: i,
                binding: j,
                name: uniformName
              };
            }
          }
        } else if (gpuProgram && groups && !groupMap) {
          const groupData = gpuProgram.structsAndGroups.groups;
          groupMap = {};
          groupData.forEach((data) => {
            groupMap[data.group] = groupMap[data.group] || {};
            groupMap[data.group][data.binding] = data.name;
            nameHash[data.name] = data;
          });
        } else if (resources) {
          groups = {};
          groupMap = {};
          if (gpuProgram) {
            const groupData = gpuProgram.structsAndGroups.groups;
            groupData.forEach((data) => {
              groupMap[data.group] = groupMap[data.group] || {};
              groupMap[data.group][data.binding] = data.name;
              nameHash[data.name] = data;
            });
          }
          let bindTick = 0;
          for (const i in resources) {
            if (nameHash[i])
              continue;
            if (!groups[99]) {
              groups[99] = new BindGroup();
              this._ownedBindGroups.push(groups[99]);
            }
            nameHash[i] = { group: 99, binding: bindTick, name: i };
            groupMap[99] = groupMap[99] || {};
            groupMap[99][bindTick] = i;
            bindTick++;
          }
          for (const i in resources) {
            const name = i;
            let value = resources[i];
            if (!value.source && !value._resourceType) {
              value = new UniformGroup(value);
            }
            const data = nameHash[name];
            if (data) {
              if (!groups[data.group]) {
                groups[data.group] = new BindGroup();
                this._ownedBindGroups.push(groups[data.group]);
              }
              groups[data.group].setResource(value, data.binding);
            }
          }
        }
        this.groups = groups;
        this._uniformBindMap = groupMap;
        this.resources = this._buildResourceAccessor(groups, nameHash);
      }
      /**
       * Sometimes a resource group will be provided later (for example global uniforms)
       * In such cases, this method can be used to let the shader know about the group.
       * @param name - the name of the resource group
       * @param groupIndex - the index of the group (should match the webGPU shader group location)
       * @param bindIndex - the index of the bind point (should match the webGPU shader bind point)
       */
      addResource(name, groupIndex, bindIndex) {
        var _a, _b;
        (_a = this._uniformBindMap)[groupIndex] || (_a[groupIndex] = {});
        (_b = this._uniformBindMap[groupIndex])[bindIndex] || (_b[bindIndex] = name);
        if (!this.groups[groupIndex]) {
          this.groups[groupIndex] = new BindGroup();
          this._ownedBindGroups.push(this.groups[groupIndex]);
        }
      }
      _buildResourceAccessor(groups, nameHash) {
        const uniformsOut = {};
        for (const i in nameHash) {
          const data = nameHash[i];
          Object.defineProperty(uniformsOut, data.name, {
            get() {
              return groups[data.group].getResource(data.binding);
            },
            set(value) {
              groups[data.group].setResource(value, data.binding);
            }
          });
        }
        return uniformsOut;
      }
      /**
       * Use to destroy the shader when its not longer needed.
       * It will destroy the resources and remove listeners.
       * @param destroyPrograms - if the programs should be destroyed as well.
       * Make sure its not being used by other shaders!
       */
      destroy(destroyPrograms = false) {
        var _a, _b;
        this.emit("destroy", this);
        if (destroyPrograms) {
          (_a = this.gpuProgram) == null ? void 0 : _a.destroy();
          (_b = this.glProgram) == null ? void 0 : _b.destroy();
        }
        this.gpuProgram = null;
        this.glProgram = null;
        this.removeAllListeners();
        this._uniformBindMap = null;
        this._ownedBindGroups.forEach((bindGroup) => {
          bindGroup.destroy();
        });
        this._ownedBindGroups = null;
        this.resources = null;
        this.groups = null;
      }
      static from(options) {
        const _a = options, { gpu, gl } = _a, rest = __objRest$k(_a, ["gpu", "gl"]);
        let gpuProgram;
        let glProgram;
        if (gpu) {
          gpuProgram = GpuProgram.from(gpu);
        }
        if (gl) {
          glProgram = GlProgram.from(gl);
        }
        return new Shader(__spreadValues$W({
          gpuProgram,
          glProgram
        }, rest));
      }
    }

    "use strict";
    class DefaultShader extends Shader {
      constructor(maxTextures) {
        const glProgram = compileHighShaderGlProgram({
          name: "batch",
          bits: [
            colorBitGl,
            generateTextureBatchBitGl(maxTextures),
            roundPixelsBitGl
          ]
        });
        const gpuProgram = compileHighShaderGpuProgram({
          name: "batch",
          bits: [
            colorBit,
            generateTextureBatchBit(maxTextures),
            roundPixelsBit
          ]
        });
        super({
          glProgram,
          gpuProgram,
          resources: {
            batchSamplers: getBatchSamplersUniformGroup(maxTextures)
          }
        });
      }
    }

    "use strict";
    let defaultShader = null;
    const _DefaultBatcher = class _DefaultBatcher extends Batcher {
      constructor() {
        super(...arguments);
        this.geometry = new BatchGeometry();
        this.shader = defaultShader || (defaultShader = new DefaultShader(this.maxTextures));
        this.name = _DefaultBatcher.extension.name;
        /** The size of one attribute. 1 = 32 bit. x, y, u, v, color, textureIdAndRound -> total = 6 */
        this.vertexSize = 6;
      }
      /**
       * Packs the attributes of a DefaultBatchableMeshElement into the provided views.
       * @param element - The DefaultBatchableMeshElement to pack.
       * @param float32View - The Float32Array view to pack into.
       * @param uint32View - The Uint32Array view to pack into.
       * @param index - The starting index in the views.
       * @param textureId - The texture ID to use.
       */
      packAttributes(element, float32View, uint32View, index, textureId) {
        const textureIdAndRound = textureId << 16 | element.roundPixels & 65535;
        const wt = element.transform;
        const a = wt.a;
        const b = wt.b;
        const c = wt.c;
        const d = wt.d;
        const tx = wt.tx;
        const ty = wt.ty;
        const { positions, uvs } = element;
        const argb = element.color;
        const offset = element.attributeOffset;
        const end = offset + element.attributeSize;
        for (let i = offset; i < end; i++) {
          const i2 = i * 2;
          const x = positions[i2];
          const y = positions[i2 + 1];
          float32View[index++] = a * x + c * y + tx;
          float32View[index++] = d * y + b * x + ty;
          float32View[index++] = uvs[i2];
          float32View[index++] = uvs[i2 + 1];
          uint32View[index++] = argb;
          uint32View[index++] = textureIdAndRound;
        }
      }
      /**
       * Packs the attributes of a DefaultBatchableQuadElement into the provided views.
       * @param element - The DefaultBatchableQuadElement to pack.
       * @param float32View - The Float32Array view to pack into.
       * @param uint32View - The Uint32Array view to pack into.
       * @param index - The starting index in the views.
       * @param textureId - The texture ID to use.
       */
      packQuadAttributes(element, float32View, uint32View, index, textureId) {
        const texture = element.texture;
        const wt = element.transform;
        const a = wt.a;
        const b = wt.b;
        const c = wt.c;
        const d = wt.d;
        const tx = wt.tx;
        const ty = wt.ty;
        const bounds = element.bounds;
        const w0 = bounds.maxX;
        const w1 = bounds.minX;
        const h0 = bounds.maxY;
        const h1 = bounds.minY;
        const uvs = texture.uvs;
        const argb = element.color;
        const textureIdAndRound = textureId << 16 | element.roundPixels & 65535;
        float32View[index + 0] = a * w1 + c * h1 + tx;
        float32View[index + 1] = d * h1 + b * w1 + ty;
        float32View[index + 2] = uvs.x0;
        float32View[index + 3] = uvs.y0;
        uint32View[index + 4] = argb;
        uint32View[index + 5] = textureIdAndRound;
        float32View[index + 6] = a * w0 + c * h1 + tx;
        float32View[index + 7] = d * h1 + b * w0 + ty;
        float32View[index + 8] = uvs.x1;
        float32View[index + 9] = uvs.y1;
        uint32View[index + 10] = argb;
        uint32View[index + 11] = textureIdAndRound;
        float32View[index + 12] = a * w0 + c * h0 + tx;
        float32View[index + 13] = d * h0 + b * w0 + ty;
        float32View[index + 14] = uvs.x2;
        float32View[index + 15] = uvs.y2;
        uint32View[index + 16] = argb;
        uint32View[index + 17] = textureIdAndRound;
        float32View[index + 18] = a * w1 + c * h0 + tx;
        float32View[index + 19] = d * h0 + b * w1 + ty;
        float32View[index + 20] = uvs.x3;
        float32View[index + 21] = uvs.y3;
        uint32View[index + 22] = argb;
        uint32View[index + 23] = textureIdAndRound;
      }
    };
    /** @ignore */
    _DefaultBatcher.extension = {
      type: [
        ExtensionType.Batcher
      ],
      name: "default"
    };
    let DefaultBatcher = _DefaultBatcher;

    "use strict";
    function buildUvs(vertices, verticesStride, verticesOffset, uvs, uvsOffset, uvsStride, size, matrix = null) {
      let index = 0;
      verticesOffset *= verticesStride;
      uvsOffset *= uvsStride;
      const a = matrix.a;
      const b = matrix.b;
      const c = matrix.c;
      const d = matrix.d;
      const tx = matrix.tx;
      const ty = matrix.ty;
      while (index < size) {
        const x = vertices[verticesOffset];
        const y = vertices[verticesOffset + 1];
        uvs[uvsOffset] = a * x + c * y + tx;
        uvs[uvsOffset + 1] = b * x + d * y + ty;
        uvsOffset += uvsStride;
        verticesOffset += verticesStride;
        index++;
      }
    }
    function buildSimpleUvs(uvs, uvsOffset, uvsStride, size) {
      let index = 0;
      uvsOffset *= uvsStride;
      while (index < size) {
        uvs[uvsOffset] = 0;
        uvs[uvsOffset + 1] = 0;
        uvsOffset += uvsStride;
        index++;
      }
    }

    "use strict";
    function transformVertices(vertices, m, offset, stride, size) {
      const a = m.a;
      const b = m.b;
      const c = m.c;
      const d = m.d;
      const tx = m.tx;
      const ty = m.ty;
      offset || (offset = 0);
      stride || (stride = 2);
      size || (size = vertices.length / stride - offset);
      let index = offset * stride;
      for (let i = 0; i < size; i++) {
        const x = vertices[index];
        const y = vertices[index + 1];
        vertices[index] = a * x + c * y + tx;
        vertices[index + 1] = b * x + d * y + ty;
        index += stride;
      }
    }

    "use strict";
    const identityMatrix = new Matrix();
    class BatchableGraphics {
      constructor() {
        this.packAsQuad = false;
        this.batcherName = "default";
        this.topology = "triangle-list";
        this.applyTransform = true;
        this.roundPixels = 0;
        this._batcher = null;
        this._batch = null;
      }
      get uvs() {
        return this.geometryData.uvs;
      }
      get positions() {
        return this.geometryData.vertices;
      }
      get indices() {
        return this.geometryData.indices;
      }
      get blendMode() {
        if (this.applyTransform) {
          return this.renderable.groupBlendMode;
        }
        return "normal";
      }
      get color() {
        const rgb = this.baseColor;
        const bgr = rgb >> 16 | rgb & 65280 | (rgb & 255) << 16;
        const renderable = this.renderable;
        if (renderable) {
          return multiplyHexColors(bgr, renderable.groupColor) + (this.alpha * renderable.groupAlpha * 255 << 24);
        }
        return bgr + (this.alpha * 255 << 24);
      }
      get transform() {
        var _a;
        return ((_a = this.renderable) == null ? void 0 : _a.groupTransform) || identityMatrix;
      }
      copyTo(gpuBuffer) {
        gpuBuffer.indexOffset = this.indexOffset;
        gpuBuffer.indexSize = this.indexSize;
        gpuBuffer.attributeOffset = this.attributeOffset;
        gpuBuffer.attributeSize = this.attributeSize;
        gpuBuffer.baseColor = this.baseColor;
        gpuBuffer.alpha = this.alpha;
        gpuBuffer.texture = this.texture;
        gpuBuffer.geometryData = this.geometryData;
        gpuBuffer.topology = this.topology;
      }
      reset() {
        this.applyTransform = true;
        this.renderable = null;
        this.topology = "triangle-list";
      }
    }

    "use strict";
    var __defProp$V = Object.defineProperty;
    var __defProps$n = Object.defineProperties;
    var __getOwnPropDescs$n = Object.getOwnPropertyDescriptors;
    var __getOwnPropSymbols$V = Object.getOwnPropertySymbols;
    var __hasOwnProp$V = Object.prototype.hasOwnProperty;
    var __propIsEnum$V = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$V = (obj, key, value) => key in obj ? __defProp$V(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$V = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$V.call(b, prop))
          __defNormalProp$V(a, prop, b[prop]);
      if (__getOwnPropSymbols$V)
        for (var prop of __getOwnPropSymbols$V(b)) {
          if (__propIsEnum$V.call(b, prop))
            __defNormalProp$V(a, prop, b[prop]);
        }
      return a;
    };
    var __spreadProps$n = (a, b) => __defProps$n(a, __getOwnPropDescs$n(b));
    const buildCircle = {
      extension: {
        type: ExtensionType.ShapeBuilder,
        name: "circle"
      },
      build(shape, points) {
        let x;
        let y;
        let dx;
        let dy;
        let rx;
        let ry;
        if (shape.type === "circle") {
          const circle = shape;
          x = circle.x;
          y = circle.y;
          rx = ry = circle.radius;
          dx = dy = 0;
        } else if (shape.type === "ellipse") {
          const ellipse = shape;
          x = ellipse.x;
          y = ellipse.y;
          rx = ellipse.halfWidth;
          ry = ellipse.halfHeight;
          dx = dy = 0;
        } else {
          const roundedRect = shape;
          const halfWidth = roundedRect.width / 2;
          const halfHeight = roundedRect.height / 2;
          x = roundedRect.x + halfWidth;
          y = roundedRect.y + halfHeight;
          rx = ry = Math.max(0, Math.min(roundedRect.radius, Math.min(halfWidth, halfHeight)));
          dx = halfWidth - rx;
          dy = halfHeight - ry;
        }
        if (!(rx >= 0 && ry >= 0 && dx >= 0 && dy >= 0)) {
          return points;
        }
        const n = Math.ceil(2.3 * Math.sqrt(rx + ry));
        const m = n * 8 + (dx ? 4 : 0) + (dy ? 4 : 0);
        if (m === 0) {
          return points;
        }
        if (n === 0) {
          points[0] = points[6] = x + dx;
          points[1] = points[3] = y + dy;
          points[2] = points[4] = x - dx;
          points[5] = points[7] = y - dy;
          return points;
        }
        let j1 = 0;
        let j2 = n * 4 + (dx ? 2 : 0) + 2;
        let j3 = j2;
        let j4 = m;
        let x0 = dx + rx;
        let y0 = dy;
        let x1 = x + x0;
        let x2 = x - x0;
        let y1 = y + y0;
        points[j1++] = x1;
        points[j1++] = y1;
        points[--j2] = y1;
        points[--j2] = x2;
        if (dy) {
          const y22 = y - y0;
          points[j3++] = x2;
          points[j3++] = y22;
          points[--j4] = y22;
          points[--j4] = x1;
        }
        for (let i = 1; i < n; i++) {
          const a = Math.PI / 2 * (i / n);
          const x02 = dx + Math.cos(a) * rx;
          const y02 = dy + Math.sin(a) * ry;
          const x12 = x + x02;
          const x22 = x - x02;
          const y12 = y + y02;
          const y22 = y - y02;
          points[j1++] = x12;
          points[j1++] = y12;
          points[--j2] = y12;
          points[--j2] = x22;
          points[j3++] = x22;
          points[j3++] = y22;
          points[--j4] = y22;
          points[--j4] = x12;
        }
        x0 = dx;
        y0 = dy + ry;
        x1 = x + x0;
        x2 = x - x0;
        y1 = y + y0;
        const y2 = y - y0;
        points[j1++] = x1;
        points[j1++] = y1;
        points[--j4] = y2;
        points[--j4] = x1;
        if (dx) {
          points[j1++] = x2;
          points[j1++] = y1;
          points[--j4] = y2;
          points[--j4] = x2;
        }
        return points;
      },
      triangulate(points, vertices, verticesStride, verticesOffset, indices, indicesOffset) {
        if (points.length === 0) {
          return;
        }
        let centerX = 0;
        let centerY = 0;
        for (let i = 0; i < points.length; i += 2) {
          centerX += points[i];
          centerY += points[i + 1];
        }
        centerX /= points.length / 2;
        centerY /= points.length / 2;
        let count = verticesOffset;
        vertices[count * verticesStride] = centerX;
        vertices[count * verticesStride + 1] = centerY;
        const centerIndex = count++;
        for (let i = 0; i < points.length; i += 2) {
          vertices[count * verticesStride] = points[i];
          vertices[count * verticesStride + 1] = points[i + 1];
          if (i > 0) {
            indices[indicesOffset++] = count;
            indices[indicesOffset++] = centerIndex;
            indices[indicesOffset++] = count - 1;
          }
          count++;
        }
        indices[indicesOffset++] = centerIndex + 1;
        indices[indicesOffset++] = centerIndex;
        indices[indicesOffset++] = count - 1;
      }
    };
    const buildEllipse = __spreadProps$n(__spreadValues$V({}, buildCircle), { extension: __spreadProps$n(__spreadValues$V({}, buildCircle.extension), { name: "ellipse" }) });
    const buildRoundedRectangle = __spreadProps$n(__spreadValues$V({}, buildCircle), { extension: __spreadProps$n(__spreadValues$V({}, buildCircle.extension), { name: "roundedRectangle" }) });

    "use strict";
    const closePointEps = 1e-4;
    const curveEps = 1e-4;

    "use strict";
    function getOrientationOfPoints(points) {
      const m = points.length;
      if (m < 6) {
        return 1;
      }
      let area = 0;
      for (let i = 0, x1 = points[m - 2], y1 = points[m - 1]; i < m; i += 2) {
        const x2 = points[i];
        const y2 = points[i + 1];
        area += (x2 - x1) * (y2 + y1);
        x1 = x2;
        y1 = y2;
      }
      if (area < 0) {
        return -1;
      }
      return 1;
    }

    "use strict";
    function square(x, y, nx, ny, innerWeight, outerWeight, clockwise, verts) {
      const ix = x - nx * innerWeight;
      const iy = y - ny * innerWeight;
      const ox = x + nx * outerWeight;
      const oy = y + ny * outerWeight;
      let exx;
      let eyy;
      if (clockwise) {
        exx = ny;
        eyy = -nx;
      } else {
        exx = -ny;
        eyy = nx;
      }
      const eix = ix + exx;
      const eiy = iy + eyy;
      const eox = ox + exx;
      const eoy = oy + eyy;
      verts.push(eix, eiy);
      verts.push(eox, eoy);
      return 2;
    }
    function round(cx, cy, sx, sy, ex, ey, verts, clockwise) {
      const cx2p0x = sx - cx;
      const cy2p0y = sy - cy;
      let angle0 = Math.atan2(cx2p0x, cy2p0y);
      let angle1 = Math.atan2(ex - cx, ey - cy);
      if (clockwise && angle0 < angle1) {
        angle0 += Math.PI * 2;
      } else if (!clockwise && angle0 > angle1) {
        angle1 += Math.PI * 2;
      }
      let startAngle = angle0;
      const angleDiff = angle1 - angle0;
      const absAngleDiff = Math.abs(angleDiff);
      const radius = Math.sqrt(cx2p0x * cx2p0x + cy2p0y * cy2p0y);
      const segCount = (15 * absAngleDiff * Math.sqrt(radius) / Math.PI >> 0) + 1;
      const angleInc = angleDiff / segCount;
      startAngle += angleInc;
      if (clockwise) {
        verts.push(cx, cy);
        verts.push(sx, sy);
        for (let i = 1, angle = startAngle; i < segCount; i++, angle += angleInc) {
          verts.push(cx, cy);
          verts.push(
            cx + Math.sin(angle) * radius,
            cy + Math.cos(angle) * radius
          );
        }
        verts.push(cx, cy);
        verts.push(ex, ey);
      } else {
        verts.push(sx, sy);
        verts.push(cx, cy);
        for (let i = 1, angle = startAngle; i < segCount; i++, angle += angleInc) {
          verts.push(
            cx + Math.sin(angle) * radius,
            cy + Math.cos(angle) * radius
          );
          verts.push(cx, cy);
        }
        verts.push(ex, ey);
        verts.push(cx, cy);
      }
      return segCount * 2;
    }
    function buildLine(points, lineStyle, flipAlignment, closed, vertices, indices) {
      const eps = closePointEps;
      if (points.length === 0) {
        return;
      }
      const style = lineStyle;
      let alignment = style.alignment;
      if (lineStyle.alignment !== 0.5) {
        let orientation = getOrientationOfPoints(points);
        if (flipAlignment)
          orientation *= -1;
        alignment = (alignment - 0.5) * orientation + 0.5;
      }
      const firstPoint = new Point(points[0], points[1]);
      const lastPoint = new Point(points[points.length - 2], points[points.length - 1]);
      const closedShape = closed;
      const closedPath = Math.abs(firstPoint.x - lastPoint.x) < eps && Math.abs(firstPoint.y - lastPoint.y) < eps;
      if (closedShape) {
        points = points.slice();
        if (closedPath) {
          points.pop();
          points.pop();
          lastPoint.set(points[points.length - 2], points[points.length - 1]);
        }
        const midPointX = (firstPoint.x + lastPoint.x) * 0.5;
        const midPointY = (lastPoint.y + firstPoint.y) * 0.5;
        points.unshift(midPointX, midPointY);
        points.push(midPointX, midPointY);
      }
      const verts = vertices;
      const length = points.length / 2;
      let indexCount = points.length;
      const indexStart = verts.length / 2;
      const width = style.width / 2;
      const widthSquared = width * width;
      const miterLimitSquared = style.miterLimit * style.miterLimit;
      let x0 = points[0];
      let y0 = points[1];
      let x1 = points[2];
      let y1 = points[3];
      let x2 = 0;
      let y2 = 0;
      let perpX = -(y0 - y1);
      let perpY = x0 - x1;
      let perp1x = 0;
      let perp1y = 0;
      let dist = Math.sqrt(perpX * perpX + perpY * perpY);
      perpX /= dist;
      perpY /= dist;
      perpX *= width;
      perpY *= width;
      const ratio = alignment;
      const innerWeight = (1 - ratio) * 2;
      const outerWeight = ratio * 2;
      if (!closedShape) {
        if (style.cap === "round") {
          indexCount += round(
            x0 - perpX * (innerWeight - outerWeight) * 0.5,
            y0 - perpY * (innerWeight - outerWeight) * 0.5,
            x0 - perpX * innerWeight,
            y0 - perpY * innerWeight,
            x0 + perpX * outerWeight,
            y0 + perpY * outerWeight,
            verts,
            true
          ) + 2;
        } else if (style.cap === "square") {
          indexCount += square(x0, y0, perpX, perpY, innerWeight, outerWeight, true, verts);
        }
      }
      verts.push(
        x0 - perpX * innerWeight,
        y0 - perpY * innerWeight
      );
      verts.push(
        x0 + perpX * outerWeight,
        y0 + perpY * outerWeight
      );
      for (let i = 1; i < length - 1; ++i) {
        x0 = points[(i - 1) * 2];
        y0 = points[(i - 1) * 2 + 1];
        x1 = points[i * 2];
        y1 = points[i * 2 + 1];
        x2 = points[(i + 1) * 2];
        y2 = points[(i + 1) * 2 + 1];
        perpX = -(y0 - y1);
        perpY = x0 - x1;
        dist = Math.sqrt(perpX * perpX + perpY * perpY);
        perpX /= dist;
        perpY /= dist;
        perpX *= width;
        perpY *= width;
        perp1x = -(y1 - y2);
        perp1y = x1 - x2;
        dist = Math.sqrt(perp1x * perp1x + perp1y * perp1y);
        perp1x /= dist;
        perp1y /= dist;
        perp1x *= width;
        perp1y *= width;
        const dx0 = x1 - x0;
        const dy0 = y0 - y1;
        const dx1 = x1 - x2;
        const dy1 = y2 - y1;
        const dot = dx0 * dx1 + dy0 * dy1;
        const cross = dy0 * dx1 - dy1 * dx0;
        const clockwise = cross < 0;
        if (Math.abs(cross) < 1e-3 * Math.abs(dot)) {
          verts.push(
            x1 - perpX * innerWeight,
            y1 - perpY * innerWeight
          );
          verts.push(
            x1 + perpX * outerWeight,
            y1 + perpY * outerWeight
          );
          if (dot >= 0) {
            if (style.join === "round") {
              indexCount += round(
                x1,
                y1,
                x1 - perpX * innerWeight,
                y1 - perpY * innerWeight,
                x1 - perp1x * innerWeight,
                y1 - perp1y * innerWeight,
                verts,
                false
              ) + 4;
            } else {
              indexCount += 2;
            }
            verts.push(
              x1 - perp1x * outerWeight,
              y1 - perp1y * outerWeight
            );
            verts.push(
              x1 + perp1x * innerWeight,
              y1 + perp1y * innerWeight
            );
          }
          continue;
        }
        const c1 = (-perpX + x0) * (-perpY + y1) - (-perpX + x1) * (-perpY + y0);
        const c2 = (-perp1x + x2) * (-perp1y + y1) - (-perp1x + x1) * (-perp1y + y2);
        const px = (dx0 * c2 - dx1 * c1) / cross;
        const py = (dy1 * c1 - dy0 * c2) / cross;
        const pDist = (px - x1) * (px - x1) + (py - y1) * (py - y1);
        const imx = x1 + (px - x1) * innerWeight;
        const imy = y1 + (py - y1) * innerWeight;
        const omx = x1 - (px - x1) * outerWeight;
        const omy = y1 - (py - y1) * outerWeight;
        const smallerInsideSegmentSq = Math.min(dx0 * dx0 + dy0 * dy0, dx1 * dx1 + dy1 * dy1);
        const insideWeight = clockwise ? innerWeight : outerWeight;
        const smallerInsideDiagonalSq = smallerInsideSegmentSq + insideWeight * insideWeight * widthSquared;
        const insideMiterOk = pDist <= smallerInsideDiagonalSq;
        if (insideMiterOk) {
          if (style.join === "bevel" || pDist / widthSquared > miterLimitSquared) {
            if (clockwise) {
              verts.push(imx, imy);
              verts.push(x1 + perpX * outerWeight, y1 + perpY * outerWeight);
              verts.push(imx, imy);
              verts.push(x1 + perp1x * outerWeight, y1 + perp1y * outerWeight);
            } else {
              verts.push(x1 - perpX * innerWeight, y1 - perpY * innerWeight);
              verts.push(omx, omy);
              verts.push(x1 - perp1x * innerWeight, y1 - perp1y * innerWeight);
              verts.push(omx, omy);
            }
            indexCount += 2;
          } else if (style.join === "round") {
            if (clockwise) {
              verts.push(imx, imy);
              verts.push(x1 + perpX * outerWeight, y1 + perpY * outerWeight);
              indexCount += round(
                x1,
                y1,
                x1 + perpX * outerWeight,
                y1 + perpY * outerWeight,
                x1 + perp1x * outerWeight,
                y1 + perp1y * outerWeight,
                verts,
                true
              ) + 4;
              verts.push(imx, imy);
              verts.push(x1 + perp1x * outerWeight, y1 + perp1y * outerWeight);
            } else {
              verts.push(x1 - perpX * innerWeight, y1 - perpY * innerWeight);
              verts.push(omx, omy);
              indexCount += round(
                x1,
                y1,
                x1 - perpX * innerWeight,
                y1 - perpY * innerWeight,
                x1 - perp1x * innerWeight,
                y1 - perp1y * innerWeight,
                verts,
                false
              ) + 4;
              verts.push(x1 - perp1x * innerWeight, y1 - perp1y * innerWeight);
              verts.push(omx, omy);
            }
          } else {
            verts.push(imx, imy);
            verts.push(omx, omy);
          }
        } else {
          verts.push(x1 - perpX * innerWeight, y1 - perpY * innerWeight);
          verts.push(x1 + perpX * outerWeight, y1 + perpY * outerWeight);
          if (style.join === "round") {
            if (clockwise) {
              indexCount += round(
                x1,
                y1,
                x1 + perpX * outerWeight,
                y1 + perpY * outerWeight,
                x1 + perp1x * outerWeight,
                y1 + perp1y * outerWeight,
                verts,
                true
              ) + 2;
            } else {
              indexCount += round(
                x1,
                y1,
                x1 - perpX * innerWeight,
                y1 - perpY * innerWeight,
                x1 - perp1x * innerWeight,
                y1 - perp1y * innerWeight,
                verts,
                false
              ) + 2;
            }
          } else if (style.join === "miter" && pDist / widthSquared <= miterLimitSquared) {
            if (clockwise) {
              verts.push(omx, omy);
              verts.push(omx, omy);
            } else {
              verts.push(imx, imy);
              verts.push(imx, imy);
            }
            indexCount += 2;
          }
          verts.push(x1 - perp1x * innerWeight, y1 - perp1y * innerWeight);
          verts.push(x1 + perp1x * outerWeight, y1 + perp1y * outerWeight);
          indexCount += 2;
        }
      }
      x0 = points[(length - 2) * 2];
      y0 = points[(length - 2) * 2 + 1];
      x1 = points[(length - 1) * 2];
      y1 = points[(length - 1) * 2 + 1];
      perpX = -(y0 - y1);
      perpY = x0 - x1;
      dist = Math.sqrt(perpX * perpX + perpY * perpY);
      perpX /= dist;
      perpY /= dist;
      perpX *= width;
      perpY *= width;
      verts.push(x1 - perpX * innerWeight, y1 - perpY * innerWeight);
      verts.push(x1 + perpX * outerWeight, y1 + perpY * outerWeight);
      if (!closedShape) {
        if (style.cap === "round") {
          indexCount += round(
            x1 - perpX * (innerWeight - outerWeight) * 0.5,
            y1 - perpY * (innerWeight - outerWeight) * 0.5,
            x1 - perpX * innerWeight,
            y1 - perpY * innerWeight,
            x1 + perpX * outerWeight,
            y1 + perpY * outerWeight,
            verts,
            false
          ) + 2;
        } else if (style.cap === "square") {
          indexCount += square(x1, y1, perpX, perpY, innerWeight, outerWeight, false, verts);
        }
      }
      const eps2 = curveEps * curveEps;
      for (let i = indexStart; i < indexCount + indexStart - 2; ++i) {
        x0 = verts[i * 2];
        y0 = verts[i * 2 + 1];
        x1 = verts[(i + 1) * 2];
        y1 = verts[(i + 1) * 2 + 1];
        x2 = verts[(i + 2) * 2];
        y2 = verts[(i + 2) * 2 + 1];
        if (Math.abs(x0 * (y1 - y2) + x1 * (y2 - y0) + x2 * (y0 - y1)) < eps2) {
          continue;
        }
        indices.push(i, i + 1, i + 2);
      }
    }

    "use strict";
    function buildPixelLine(points, closed, vertices, indices) {
      const eps = closePointEps;
      if (points.length === 0) {
        return;
      }
      const fx = points[0];
      const fy = points[1];
      const lx = points[points.length - 2];
      const ly = points[points.length - 1];
      const closePath = closed || Math.abs(fx - lx) < eps && Math.abs(fy - ly) < eps;
      const verts = vertices;
      const length = points.length / 2;
      const indexStart = verts.length / 2;
      for (let i = 0; i < length; i++) {
        verts.push(points[i * 2]);
        verts.push(points[i * 2 + 1]);
      }
      for (let i = 0; i < length - 1; i++) {
        indices.push(indexStart + i, indexStart + i + 1);
      }
      if (closePath) {
        indices.push(indexStart + length - 1, indexStart);
      }
    }

    var earcut$2 = {exports: {}};

    var earcut_1 = earcut$2.exports;

    'use strict';

    earcut$2.exports = earcut;
    var _default = earcut$2.exports.default = earcut;

    function earcut(data, holeIndices, dim) {

        dim = dim || 2;

        var hasHoles = holeIndices && holeIndices.length,
            outerLen = hasHoles ? holeIndices[0] * dim : data.length,
            outerNode = linkedList(data, 0, outerLen, dim, true),
            triangles = [];

        if (!outerNode || outerNode.next === outerNode.prev) return triangles;

        var minX, minY, maxX, maxY, x, y, invSize;

        if (hasHoles) outerNode = eliminateHoles(data, holeIndices, outerNode, dim);

        // if the shape is not too simple, we'll use z-order curve hash later; calculate polygon bbox
        if (data.length > 80 * dim) {
            minX = maxX = data[0];
            minY = maxY = data[1];

            for (var i = dim; i < outerLen; i += dim) {
                x = data[i];
                y = data[i + 1];
                if (x < minX) minX = x;
                if (y < minY) minY = y;
                if (x > maxX) maxX = x;
                if (y > maxY) maxY = y;
            }

            // minX, minY and invSize are later used to transform coords into integers for z-order calculation
            invSize = Math.max(maxX - minX, maxY - minY);
            invSize = invSize !== 0 ? 32767 / invSize : 0;
        }

        earcutLinked(outerNode, triangles, dim, minX, minY, invSize, 0);

        return triangles;
    }

    // create a circular doubly linked list from polygon points in the specified winding order
    function linkedList(data, start, end, dim, clockwise) {
        var i, last;

        if (clockwise === (signedArea(data, start, end, dim) > 0)) {
            for (i = start; i < end; i += dim) last = insertNode(i, data[i], data[i + 1], last);
        } else {
            for (i = end - dim; i >= start; i -= dim) last = insertNode(i, data[i], data[i + 1], last);
        }

        if (last && equals(last, last.next)) {
            removeNode(last);
            last = last.next;
        }

        return last;
    }

    // eliminate colinear or duplicate points
    function filterPoints(start, end) {
        if (!start) return start;
        if (!end) end = start;

        var p = start,
            again;
        do {
            again = false;

            if (!p.steiner && (equals(p, p.next) || area(p.prev, p, p.next) === 0)) {
                removeNode(p);
                p = end = p.prev;
                if (p === p.next) break;
                again = true;

            } else {
                p = p.next;
            }
        } while (again || p !== end);

        return end;
    }

    // main ear slicing loop which triangulates a polygon (given as a linked list)
    function earcutLinked(ear, triangles, dim, minX, minY, invSize, pass) {
        if (!ear) return;

        // interlink polygon nodes in z-order
        if (!pass && invSize) indexCurve(ear, minX, minY, invSize);

        var stop = ear,
            prev, next;

        // iterate through ears, slicing them one by one
        while (ear.prev !== ear.next) {
            prev = ear.prev;
            next = ear.next;

            if (invSize ? isEarHashed(ear, minX, minY, invSize) : isEar(ear)) {
                // cut off the triangle
                triangles.push(prev.i / dim | 0);
                triangles.push(ear.i / dim | 0);
                triangles.push(next.i / dim | 0);

                removeNode(ear);

                // skipping the next vertex leads to less sliver triangles
                ear = next.next;
                stop = next.next;

                continue;
            }

            ear = next;

            // if we looped through the whole remaining polygon and can't find any more ears
            if (ear === stop) {
                // try filtering points and slicing again
                if (!pass) {
                    earcutLinked(filterPoints(ear), triangles, dim, minX, minY, invSize, 1);

                // if this didn't work, try curing all small self-intersections locally
                } else if (pass === 1) {
                    ear = cureLocalIntersections(filterPoints(ear), triangles, dim);
                    earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);

                // as a last resort, try splitting the remaining polygon into two
                } else if (pass === 2) {
                    splitEarcut(ear, triangles, dim, minX, minY, invSize);
                }

                break;
            }
        }
    }

    // check whether a polygon node forms a valid ear with adjacent nodes
    function isEar(ear) {
        var a = ear.prev,
            b = ear,
            c = ear.next;

        if (area(a, b, c) >= 0) return false; // reflex, can't be an ear

        // now make sure we don't have other points inside the potential ear
        var ax = a.x, bx = b.x, cx = c.x, ay = a.y, by = b.y, cy = c.y;

        // triangle bbox; min & max are calculated like this for speed
        var x0 = ax < bx ? (ax < cx ? ax : cx) : (bx < cx ? bx : cx),
            y0 = ay < by ? (ay < cy ? ay : cy) : (by < cy ? by : cy),
            x1 = ax > bx ? (ax > cx ? ax : cx) : (bx > cx ? bx : cx),
            y1 = ay > by ? (ay > cy ? ay : cy) : (by > cy ? by : cy);

        var p = c.next;
        while (p !== a) {
            if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 &&
                pointInTriangle$1(ax, ay, bx, by, cx, cy, p.x, p.y) &&
                area(p.prev, p, p.next) >= 0) return false;
            p = p.next;
        }

        return true;
    }

    function isEarHashed(ear, minX, minY, invSize) {
        var a = ear.prev,
            b = ear,
            c = ear.next;

        if (area(a, b, c) >= 0) return false; // reflex, can't be an ear

        var ax = a.x, bx = b.x, cx = c.x, ay = a.y, by = b.y, cy = c.y;

        // triangle bbox; min & max are calculated like this for speed
        var x0 = ax < bx ? (ax < cx ? ax : cx) : (bx < cx ? bx : cx),
            y0 = ay < by ? (ay < cy ? ay : cy) : (by < cy ? by : cy),
            x1 = ax > bx ? (ax > cx ? ax : cx) : (bx > cx ? bx : cx),
            y1 = ay > by ? (ay > cy ? ay : cy) : (by > cy ? by : cy);

        // z-order range for the current triangle bbox;
        var minZ = zOrder(x0, y0, minX, minY, invSize),
            maxZ = zOrder(x1, y1, minX, minY, invSize);

        var p = ear.prevZ,
            n = ear.nextZ;

        // look for points inside the triangle in both directions
        while (p && p.z >= minZ && n && n.z <= maxZ) {
            if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && p !== a && p !== c &&
                pointInTriangle$1(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0) return false;
            p = p.prevZ;

            if (n.x >= x0 && n.x <= x1 && n.y >= y0 && n.y <= y1 && n !== a && n !== c &&
                pointInTriangle$1(ax, ay, bx, by, cx, cy, n.x, n.y) && area(n.prev, n, n.next) >= 0) return false;
            n = n.nextZ;
        }

        // look for remaining points in decreasing z-order
        while (p && p.z >= minZ) {
            if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && p !== a && p !== c &&
                pointInTriangle$1(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0) return false;
            p = p.prevZ;
        }

        // look for remaining points in increasing z-order
        while (n && n.z <= maxZ) {
            if (n.x >= x0 && n.x <= x1 && n.y >= y0 && n.y <= y1 && n !== a && n !== c &&
                pointInTriangle$1(ax, ay, bx, by, cx, cy, n.x, n.y) && area(n.prev, n, n.next) >= 0) return false;
            n = n.nextZ;
        }

        return true;
    }

    // go through all polygon nodes and cure small local self-intersections
    function cureLocalIntersections(start, triangles, dim) {
        var p = start;
        do {
            var a = p.prev,
                b = p.next.next;

            if (!equals(a, b) && intersects(a, p, p.next, b) && locallyInside(a, b) && locallyInside(b, a)) {

                triangles.push(a.i / dim | 0);
                triangles.push(p.i / dim | 0);
                triangles.push(b.i / dim | 0);

                // remove two nodes involved
                removeNode(p);
                removeNode(p.next);

                p = start = b;
            }
            p = p.next;
        } while (p !== start);

        return filterPoints(p);
    }

    // try splitting polygon into two and triangulate them independently
    function splitEarcut(start, triangles, dim, minX, minY, invSize) {
        // look for a valid diagonal that divides the polygon into two
        var a = start;
        do {
            var b = a.next.next;
            while (b !== a.prev) {
                if (a.i !== b.i && isValidDiagonal(a, b)) {
                    // split the polygon in two by the diagonal
                    var c = splitPolygon(a, b);

                    // filter colinear points around the cuts
                    a = filterPoints(a, a.next);
                    c = filterPoints(c, c.next);

                    // run earcut on each half
                    earcutLinked(a, triangles, dim, minX, minY, invSize, 0);
                    earcutLinked(c, triangles, dim, minX, minY, invSize, 0);
                    return;
                }
                b = b.next;
            }
            a = a.next;
        } while (a !== start);
    }

    // link every hole into the outer loop, producing a single-ring polygon without holes
    function eliminateHoles(data, holeIndices, outerNode, dim) {
        var queue = [],
            i, len, start, end, list;

        for (i = 0, len = holeIndices.length; i < len; i++) {
            start = holeIndices[i] * dim;
            end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
            list = linkedList(data, start, end, dim, false);
            if (list === list.next) list.steiner = true;
            queue.push(getLeftmost(list));
        }

        queue.sort(compareX);

        // process holes from left to right
        for (i = 0; i < queue.length; i++) {
            outerNode = eliminateHole(queue[i], outerNode);
        }

        return outerNode;
    }

    function compareX(a, b) {
        return a.x - b.x;
    }

    // find a bridge between vertices that connects hole with an outer ring and and link it
    function eliminateHole(hole, outerNode) {
        var bridge = findHoleBridge(hole, outerNode);
        if (!bridge) {
            return outerNode;
        }

        var bridgeReverse = splitPolygon(bridge, hole);

        // filter collinear points around the cuts
        filterPoints(bridgeReverse, bridgeReverse.next);
        return filterPoints(bridge, bridge.next);
    }

    // David Eberly's algorithm for finding a bridge between hole and outer polygon
    function findHoleBridge(hole, outerNode) {
        var p = outerNode,
            hx = hole.x,
            hy = hole.y,
            qx = -Infinity,
            m;

        // find a segment intersected by a ray from the hole's leftmost point to the left;
        // segment's endpoint with lesser x will be potential connection point
        do {
            if (hy <= p.y && hy >= p.next.y && p.next.y !== p.y) {
                var x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y);
                if (x <= hx && x > qx) {
                    qx = x;
                    m = p.x < p.next.x ? p : p.next;
                    if (x === hx) return m; // hole touches outer segment; pick leftmost endpoint
                }
            }
            p = p.next;
        } while (p !== outerNode);

        if (!m) return null;

        // look for points inside the triangle of hole point, segment intersection and endpoint;
        // if there are no points found, we have a valid connection;
        // otherwise choose the point of the minimum angle with the ray as connection point

        var stop = m,
            mx = m.x,
            my = m.y,
            tanMin = Infinity,
            tan;

        p = m;

        do {
            if (hx >= p.x && p.x >= mx && hx !== p.x &&
                    pointInTriangle$1(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {

                tan = Math.abs(hy - p.y) / (hx - p.x); // tangential

                if (locallyInside(p, hole) &&
                    (tan < tanMin || (tan === tanMin && (p.x > m.x || (p.x === m.x && sectorContainsSector(m, p)))))) {
                    m = p;
                    tanMin = tan;
                }
            }

            p = p.next;
        } while (p !== stop);

        return m;
    }

    // whether sector in vertex m contains sector in vertex p in the same coordinates
    function sectorContainsSector(m, p) {
        return area(m.prev, m, p.prev) < 0 && area(p.next, m, m.next) < 0;
    }

    // interlink polygon nodes in z-order
    function indexCurve(start, minX, minY, invSize) {
        var p = start;
        do {
            if (p.z === 0) p.z = zOrder(p.x, p.y, minX, minY, invSize);
            p.prevZ = p.prev;
            p.nextZ = p.next;
            p = p.next;
        } while (p !== start);

        p.prevZ.nextZ = null;
        p.prevZ = null;

        sortLinked(p);
    }

    // Simon Tatham's linked list merge sort algorithm
    // http://www.chiark.greenend.org.uk/~sgtatham/algorithms/listsort.html
    function sortLinked(list) {
        var i, p, q, e, tail, numMerges, pSize, qSize,
            inSize = 1;

        do {
            p = list;
            list = null;
            tail = null;
            numMerges = 0;

            while (p) {
                numMerges++;
                q = p;
                pSize = 0;
                for (i = 0; i < inSize; i++) {
                    pSize++;
                    q = q.nextZ;
                    if (!q) break;
                }
                qSize = inSize;

                while (pSize > 0 || (qSize > 0 && q)) {

                    if (pSize !== 0 && (qSize === 0 || !q || p.z <= q.z)) {
                        e = p;
                        p = p.nextZ;
                        pSize--;
                    } else {
                        e = q;
                        q = q.nextZ;
                        qSize--;
                    }

                    if (tail) tail.nextZ = e;
                    else list = e;

                    e.prevZ = tail;
                    tail = e;
                }

                p = q;
            }

            tail.nextZ = null;
            inSize *= 2;

        } while (numMerges > 1);

        return list;
    }

    // z-order of a point given coords and inverse of the longer side of data bbox
    function zOrder(x, y, minX, minY, invSize) {
        // coords are transformed into non-negative 15-bit integer range
        x = (x - minX) * invSize | 0;
        y = (y - minY) * invSize | 0;

        x = (x | (x << 8)) & 0x00FF00FF;
        x = (x | (x << 4)) & 0x0F0F0F0F;
        x = (x | (x << 2)) & 0x33333333;
        x = (x | (x << 1)) & 0x55555555;

        y = (y | (y << 8)) & 0x00FF00FF;
        y = (y | (y << 4)) & 0x0F0F0F0F;
        y = (y | (y << 2)) & 0x33333333;
        y = (y | (y << 1)) & 0x55555555;

        return x | (y << 1);
    }

    // find the leftmost node of a polygon ring
    function getLeftmost(start) {
        var p = start,
            leftmost = start;
        do {
            if (p.x < leftmost.x || (p.x === leftmost.x && p.y < leftmost.y)) leftmost = p;
            p = p.next;
        } while (p !== start);

        return leftmost;
    }

    // check if a point lies within a convex triangle
    function pointInTriangle$1(ax, ay, bx, by, cx, cy, px, py) {
        return (cx - px) * (ay - py) >= (ax - px) * (cy - py) &&
               (ax - px) * (by - py) >= (bx - px) * (ay - py) &&
               (bx - px) * (cy - py) >= (cx - px) * (by - py);
    }

    // check if a diagonal between two polygon nodes is valid (lies in polygon interior)
    function isValidDiagonal(a, b) {
        return a.next.i !== b.i && a.prev.i !== b.i && !intersectsPolygon(a, b) && // dones't intersect other edges
               (locallyInside(a, b) && locallyInside(b, a) && middleInside(a, b) && // locally visible
                (area(a.prev, a, b.prev) || area(a, b.prev, b)) || // does not create opposite-facing sectors
                equals(a, b) && area(a.prev, a, a.next) > 0 && area(b.prev, b, b.next) > 0); // special zero-length case
    }

    // signed area of a triangle
    function area(p, q, r) {
        return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
    }

    // check if two points are equal
    function equals(p1, p2) {
        return p1.x === p2.x && p1.y === p2.y;
    }

    // check if two segments intersect
    function intersects(p1, q1, p2, q2) {
        var o1 = sign(area(p1, q1, p2));
        var o2 = sign(area(p1, q1, q2));
        var o3 = sign(area(p2, q2, p1));
        var o4 = sign(area(p2, q2, q1));

        if (o1 !== o2 && o3 !== o4) return true; // general case

        if (o1 === 0 && onSegment(p1, p2, q1)) return true; // p1, q1 and p2 are collinear and p2 lies on p1q1
        if (o2 === 0 && onSegment(p1, q2, q1)) return true; // p1, q1 and q2 are collinear and q2 lies on p1q1
        if (o3 === 0 && onSegment(p2, p1, q2)) return true; // p2, q2 and p1 are collinear and p1 lies on p2q2
        if (o4 === 0 && onSegment(p2, q1, q2)) return true; // p2, q2 and q1 are collinear and q1 lies on p2q2

        return false;
    }

    // for collinear points p, q, r, check if point q lies on segment pr
    function onSegment(p, q, r) {
        return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
    }

    function sign(num) {
        return num > 0 ? 1 : num < 0 ? -1 : 0;
    }

    // check if a polygon diagonal intersects any polygon segments
    function intersectsPolygon(a, b) {
        var p = a;
        do {
            if (p.i !== a.i && p.next.i !== a.i && p.i !== b.i && p.next.i !== b.i &&
                    intersects(p, p.next, a, b)) return true;
            p = p.next;
        } while (p !== a);

        return false;
    }

    // check if a polygon diagonal is locally inside the polygon
    function locallyInside(a, b) {
        return area(a.prev, a, a.next) < 0 ?
            area(a, b, a.next) >= 0 && area(a, a.prev, b) >= 0 :
            area(a, b, a.prev) < 0 || area(a, a.next, b) < 0;
    }

    // check if the middle point of a polygon diagonal is inside the polygon
    function middleInside(a, b) {
        var p = a,
            inside = false,
            px = (a.x + b.x) / 2,
            py = (a.y + b.y) / 2;
        do {
            if (((p.y > py) !== (p.next.y > py)) && p.next.y !== p.y &&
                    (px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x))
                inside = !inside;
            p = p.next;
        } while (p !== a);

        return inside;
    }

    // link two polygon vertices with a bridge; if the vertices belong to the same ring, it splits polygon into two;
    // if one belongs to the outer ring and another to a hole, it merges it into a single ring
    function splitPolygon(a, b) {
        var a2 = new Node(a.i, a.x, a.y),
            b2 = new Node(b.i, b.x, b.y),
            an = a.next,
            bp = b.prev;

        a.next = b;
        b.prev = a;

        a2.next = an;
        an.prev = a2;

        b2.next = a2;
        a2.prev = b2;

        bp.next = b2;
        b2.prev = bp;

        return b2;
    }

    // create a node and optionally link it with previous one (in a circular doubly linked list)
    function insertNode(i, x, y, last) {
        var p = new Node(i, x, y);

        if (!last) {
            p.prev = p;
            p.next = p;

        } else {
            p.next = last.next;
            p.prev = last;
            last.next.prev = p;
            last.next = p;
        }
        return p;
    }

    function removeNode(p) {
        p.next.prev = p.prev;
        p.prev.next = p.next;

        if (p.prevZ) p.prevZ.nextZ = p.nextZ;
        if (p.nextZ) p.nextZ.prevZ = p.prevZ;
    }

    function Node(i, x, y) {
        // vertex index in coordinates array
        this.i = i;

        // vertex coordinates
        this.x = x;
        this.y = y;

        // previous and next vertex nodes in a polygon ring
        this.prev = null;
        this.next = null;

        // z-order curve value
        this.z = 0;

        // previous and next nodes in z-order
        this.prevZ = null;
        this.nextZ = null;

        // indicates whether this is a steiner point
        this.steiner = false;
    }

    // return a percentage difference between the polygon area and its triangulation area;
    // used to verify correctness of triangulation
    earcut.deviation = function (data, holeIndices, dim, triangles) {
        var hasHoles = holeIndices && holeIndices.length;
        var outerLen = hasHoles ? holeIndices[0] * dim : data.length;

        var polygonArea = Math.abs(signedArea(data, 0, outerLen, dim));
        if (hasHoles) {
            for (var i = 0, len = holeIndices.length; i < len; i++) {
                var start = holeIndices[i] * dim;
                var end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
                polygonArea -= Math.abs(signedArea(data, start, end, dim));
            }
        }

        var trianglesArea = 0;
        for (i = 0; i < triangles.length; i += 3) {
            var a = triangles[i] * dim;
            var b = triangles[i + 1] * dim;
            var c = triangles[i + 2] * dim;
            trianglesArea += Math.abs(
                (data[a] - data[c]) * (data[b + 1] - data[a + 1]) -
                (data[a] - data[b]) * (data[c + 1] - data[a + 1]));
        }

        return polygonArea === 0 && trianglesArea === 0 ? 0 :
            Math.abs((trianglesArea - polygonArea) / polygonArea);
    };

    function signedArea(data, start, end, dim) {
        var sum = 0;
        for (var i = start, j = end - dim; i < end; i += dim) {
            sum += (data[j] - data[i]) * (data[i + 1] + data[j + 1]);
            j = i;
        }
        return sum;
    }

    // turn a polygon in a multi-dimensional array form (e.g. as in GeoJSON) into a form Earcut accepts
    earcut.flatten = function (data) {
        var dim = data[0][0].length,
            result = {vertices: [], holes: [], dimensions: dim},
            holeIndex = 0;

        for (var i = 0; i < data.length; i++) {
            for (var j = 0; j < data[i].length; j++) {
                for (var d = 0; d < dim; d++) result.vertices.push(data[i][j][d]);
            }
            if (i > 0) {
                holeIndex += data[i - 1].length;
                result.holes.push(holeIndex);
            }
        }
        return result;
    };

    var earcutExports = earcut$2.exports;
    var earcut$1 = /*@__PURE__*/getDefaultExportFromCjs(earcutExports);

    "use strict";
    function triangulateWithHoles(points, holes, vertices, verticesStride, verticesOffset, indices, indicesOffset) {
      const triangles = earcut$1(points, holes, 2);
      if (!triangles) {
        return;
      }
      for (let i = 0; i < triangles.length; i += 3) {
        indices[indicesOffset++] = triangles[i] + verticesOffset;
        indices[indicesOffset++] = triangles[i + 1] + verticesOffset;
        indices[indicesOffset++] = triangles[i + 2] + verticesOffset;
      }
      let index = verticesOffset * verticesStride;
      for (let i = 0; i < points.length; i += 2) {
        vertices[index] = points[i];
        vertices[index + 1] = points[i + 1];
        index += verticesStride;
      }
    }

    "use strict";
    const emptyArray = [];
    const buildPolygon = {
      extension: {
        type: ExtensionType.ShapeBuilder,
        name: "polygon"
      },
      build(shape, points) {
        for (let i = 0; i < shape.points.length; i++) {
          points[i] = shape.points[i];
        }
        return points;
      },
      triangulate(points, vertices, verticesStride, verticesOffset, indices, indicesOffset) {
        triangulateWithHoles(points, emptyArray, vertices, verticesStride, verticesOffset, indices, indicesOffset);
      }
    };

    "use strict";
    const buildRectangle = {
      extension: {
        type: ExtensionType.ShapeBuilder,
        name: "rectangle"
      },
      build(shape, points) {
        const rectData = shape;
        const x = rectData.x;
        const y = rectData.y;
        const width = rectData.width;
        const height = rectData.height;
        if (!(width >= 0 && height >= 0)) {
          return points;
        }
        points[0] = x;
        points[1] = y;
        points[2] = x + width;
        points[3] = y;
        points[4] = x + width;
        points[5] = y + height;
        points[6] = x;
        points[7] = y + height;
        return points;
      },
      triangulate(points, vertices, verticesStride, verticesOffset, indices, indicesOffset) {
        let count = 0;
        verticesOffset *= verticesStride;
        vertices[verticesOffset + count] = points[0];
        vertices[verticesOffset + count + 1] = points[1];
        count += verticesStride;
        vertices[verticesOffset + count] = points[2];
        vertices[verticesOffset + count + 1] = points[3];
        count += verticesStride;
        vertices[verticesOffset + count] = points[6];
        vertices[verticesOffset + count + 1] = points[7];
        count += verticesStride;
        vertices[verticesOffset + count] = points[4];
        vertices[verticesOffset + count + 1] = points[5];
        count += verticesStride;
        const verticesIndex = verticesOffset / verticesStride;
        indices[indicesOffset++] = verticesIndex;
        indices[indicesOffset++] = verticesIndex + 1;
        indices[indicesOffset++] = verticesIndex + 2;
        indices[indicesOffset++] = verticesIndex + 1;
        indices[indicesOffset++] = verticesIndex + 3;
        indices[indicesOffset++] = verticesIndex + 2;
      }
    };

    "use strict";
    const buildTriangle = {
      extension: {
        type: ExtensionType.ShapeBuilder,
        name: "triangle"
      },
      build(shape, points) {
        points[0] = shape.x;
        points[1] = shape.y;
        points[2] = shape.x2;
        points[3] = shape.y2;
        points[4] = shape.x3;
        points[5] = shape.y3;
        return points;
      },
      triangulate(points, vertices, verticesStride, verticesOffset, indices, indicesOffset) {
        let count = 0;
        verticesOffset *= verticesStride;
        vertices[verticesOffset + count] = points[0];
        vertices[verticesOffset + count + 1] = points[1];
        count += verticesStride;
        vertices[verticesOffset + count] = points[2];
        vertices[verticesOffset + count + 1] = points[3];
        count += verticesStride;
        vertices[verticesOffset + count] = points[4];
        vertices[verticesOffset + count + 1] = points[5];
        const verticesIndex = verticesOffset / verticesStride;
        indices[indicesOffset++] = verticesIndex;
        indices[indicesOffset++] = verticesIndex + 1;
        indices[indicesOffset++] = verticesIndex + 2;
      }
    };

    "use strict";
    const shapeBuilders = {};
    extensions.handleByMap(ExtensionType.ShapeBuilder, shapeBuilders);
    extensions.add(buildRectangle, buildPolygon, buildTriangle, buildCircle, buildEllipse, buildRoundedRectangle);
    const tempRect$1 = new Rectangle();
    function buildContextBatches(context, gpuContext) {
      const { geometryData, batches } = gpuContext;
      batches.length = 0;
      geometryData.indices.length = 0;
      geometryData.vertices.length = 0;
      geometryData.uvs.length = 0;
      for (let i = 0; i < context.instructions.length; i++) {
        const instruction = context.instructions[i];
        if (instruction.action === "texture") {
          addTextureToGeometryData(instruction.data, batches, geometryData);
        } else if (instruction.action === "fill" || instruction.action === "stroke") {
          const isStroke = instruction.action === "stroke";
          const shapePath = instruction.data.path.shapePath;
          const style = instruction.data.style;
          const hole = instruction.data.hole;
          if (isStroke && hole) {
            addShapePathToGeometryData(hole.shapePath, style, null, true, batches, geometryData);
          }
          addShapePathToGeometryData(shapePath, style, hole, isStroke, batches, geometryData);
        }
      }
    }
    function addTextureToGeometryData(data, batches, geometryData) {
      const { vertices, uvs, indices } = geometryData;
      const indexOffset = indices.length;
      const vertOffset = vertices.length / 2;
      const points = [];
      const build = shapeBuilders.rectangle;
      const rect = tempRect$1;
      const texture = data.image;
      rect.x = data.dx;
      rect.y = data.dy;
      rect.width = data.dw;
      rect.height = data.dh;
      const matrix = data.transform;
      build.build(rect, points);
      if (matrix) {
        transformVertices(points, matrix);
      }
      build.triangulate(points, vertices, 2, vertOffset, indices, indexOffset);
      const textureUvs = texture.uvs;
      uvs.push(
        textureUvs.x0,
        textureUvs.y0,
        textureUvs.x1,
        textureUvs.y1,
        textureUvs.x3,
        textureUvs.y3,
        textureUvs.x2,
        textureUvs.y2
      );
      const graphicsBatch = BigPool.get(BatchableGraphics);
      graphicsBatch.indexOffset = indexOffset;
      graphicsBatch.indexSize = indices.length - indexOffset;
      graphicsBatch.attributeOffset = vertOffset;
      graphicsBatch.attributeSize = vertices.length / 2 - vertOffset;
      graphicsBatch.baseColor = data.style;
      graphicsBatch.alpha = data.alpha;
      graphicsBatch.texture = texture;
      graphicsBatch.geometryData = geometryData;
      batches.push(graphicsBatch);
    }
    function addShapePathToGeometryData(shapePath, style, hole, isStroke, batches, geometryData) {
      const { vertices, uvs, indices } = geometryData;
      const lastIndex = shapePath.shapePrimitives.length - 1;
      shapePath.shapePrimitives.forEach(({ shape, transform: matrix }, i) => {
        var _a;
        const indexOffset = indices.length;
        const vertOffset = vertices.length / 2;
        const points = [];
        const build = shapeBuilders[shape.type];
        let topology = "triangle-list";
        build.build(shape, points);
        if (matrix) {
          transformVertices(points, matrix);
        }
        if (!isStroke) {
          if (hole && lastIndex === i) {
            if (lastIndex !== 0) {
              console.warn("[Pixi Graphics] only the last shape have be cut out");
            }
            const holeIndices = [];
            const otherPoints = points.slice();
            const holeArrays = getHoleArrays(hole.shapePath);
            holeArrays.forEach((holePoints) => {
              holeIndices.push(otherPoints.length / 2);
              otherPoints.push(...holePoints);
            });
            triangulateWithHoles(otherPoints, holeIndices, vertices, 2, vertOffset, indices, indexOffset);
          } else {
            build.triangulate(points, vertices, 2, vertOffset, indices, indexOffset);
          }
        } else {
          const close = (_a = shape.closePath) != null ? _a : true;
          const lineStyle = style;
          if (!lineStyle.pixelLine) {
            buildLine(points, lineStyle, false, close, vertices, indices);
          } else {
            buildPixelLine(points, close, vertices, indices);
            topology = "line-list";
          }
        }
        const uvsOffset = uvs.length / 2;
        const texture = style.texture;
        if (texture !== Texture.WHITE) {
          const textureMatrix = style.matrix;
          if (textureMatrix) {
            if (matrix) {
              textureMatrix.append(matrix.clone().invert());
            }
            buildUvs(vertices, 2, vertOffset, uvs, uvsOffset, 2, vertices.length / 2 - vertOffset, textureMatrix);
          }
        } else {
          buildSimpleUvs(uvs, uvsOffset, 2, vertices.length / 2 - vertOffset);
        }
        const graphicsBatch = BigPool.get(BatchableGraphics);
        graphicsBatch.indexOffset = indexOffset;
        graphicsBatch.indexSize = indices.length - indexOffset;
        graphicsBatch.attributeOffset = vertOffset;
        graphicsBatch.attributeSize = vertices.length / 2 - vertOffset;
        graphicsBatch.baseColor = style.color;
        graphicsBatch.alpha = style.alpha;
        graphicsBatch.texture = texture;
        graphicsBatch.geometryData = geometryData;
        graphicsBatch.topology = topology;
        batches.push(graphicsBatch);
      });
    }
    function getHoleArrays(shape) {
      if (!shape)
        return [];
      const holePrimitives = shape.shapePrimitives;
      const holeArrays = [];
      for (let k = 0; k < holePrimitives.length; k++) {
        const holePrimitive = holePrimitives[k].shape;
        const holePoints = [];
        const holeBuilder = shapeBuilders[holePrimitive.type];
        holeBuilder.build(holePrimitive, holePoints);
        holeArrays.push(holePoints);
      }
      return holeArrays;
    }

    "use strict";
    class GpuGraphicsContext {
      constructor() {
        this.batches = [];
        this.geometryData = {
          vertices: [],
          uvs: [],
          indices: []
        };
      }
    }
    class GraphicsContextRenderData {
      constructor() {
        this.batcher = new DefaultBatcher();
        this.instructions = new InstructionSet();
      }
      init() {
        this.instructions.reset();
      }
      /**
       * @deprecated since version 8.0.0
       * Use `batcher.geometry` instead.
       * @see {Batcher#geometry}
       */
      get geometry() {
        deprecation(v8_3_4, "GraphicsContextRenderData#geometry is deprecated, please use batcher.geometry instead.");
        return this.batcher.geometry;
      }
    }
    const _GraphicsContextSystem = class _GraphicsContextSystem {
      constructor(renderer) {
        // the root context batches, used to either make a batch or geometry
        // all graphics use this as a base
        this._gpuContextHash = {};
        // used for non-batchable graphics
        this._graphicsDataContextHash = /* @__PURE__ */ Object.create(null);
        renderer.renderableGC.addManagedHash(this, "_gpuContextHash");
        renderer.renderableGC.addManagedHash(this, "_graphicsDataContextHash");
      }
      /**
       * Runner init called, update the default options
       * @ignore
       */
      init(options) {
        var _a;
        _GraphicsContextSystem.defaultOptions.bezierSmoothness = (_a = options == null ? void 0 : options.bezierSmoothness) != null ? _a : _GraphicsContextSystem.defaultOptions.bezierSmoothness;
      }
      getContextRenderData(context) {
        return this._graphicsDataContextHash[context.uid] || this._initContextRenderData(context);
      }
      // Context management functions
      updateGpuContext(context) {
        let gpuContext = this._gpuContextHash[context.uid] || this._initContext(context);
        if (context.dirty) {
          if (gpuContext) {
            this._cleanGraphicsContextData(context);
          } else {
            gpuContext = this._initContext(context);
          }
          buildContextBatches(context, gpuContext);
          const batchMode = context.batchMode;
          if (context.customShader || batchMode === "no-batch") {
            gpuContext.isBatchable = false;
          } else if (batchMode === "auto") {
            gpuContext.isBatchable = gpuContext.geometryData.vertices.length < 400;
          }
          context.dirty = false;
        }
        return gpuContext;
      }
      getGpuContext(context) {
        return this._gpuContextHash[context.uid] || this._initContext(context);
      }
      _initContextRenderData(context) {
        const graphicsData = BigPool.get(GraphicsContextRenderData);
        const { batches, geometryData } = this._gpuContextHash[context.uid];
        const vertexSize = geometryData.vertices.length;
        const indexSize = geometryData.indices.length;
        for (let i = 0; i < batches.length; i++) {
          batches[i].applyTransform = false;
        }
        const batcher = graphicsData.batcher;
        batcher.ensureAttributeBuffer(vertexSize);
        batcher.ensureIndexBuffer(indexSize);
        batcher.begin();
        for (let i = 0; i < batches.length; i++) {
          const batch = batches[i];
          batcher.add(batch);
        }
        batcher.finish(graphicsData.instructions);
        const geometry = batcher.geometry;
        geometry.indexBuffer.setDataWithSize(batcher.indexBuffer, batcher.indexSize, true);
        geometry.buffers[0].setDataWithSize(batcher.attributeBuffer.float32View, batcher.attributeSize, true);
        const drawBatches = batcher.batches;
        for (let i = 0; i < drawBatches.length; i++) {
          const batch = drawBatches[i];
          batch.bindGroup = getTextureBatchBindGroup(batch.textures.textures, batch.textures.count);
        }
        this._graphicsDataContextHash[context.uid] = graphicsData;
        return graphicsData;
      }
      _initContext(context) {
        const gpuContext = new GpuGraphicsContext();
        gpuContext.context = context;
        this._gpuContextHash[context.uid] = gpuContext;
        context.on("destroy", this.onGraphicsContextDestroy, this);
        return this._gpuContextHash[context.uid];
      }
      onGraphicsContextDestroy(context) {
        this._cleanGraphicsContextData(context);
        context.off("destroy", this.onGraphicsContextDestroy, this);
        this._gpuContextHash[context.uid] = null;
      }
      _cleanGraphicsContextData(context) {
        const gpuContext = this._gpuContextHash[context.uid];
        if (!gpuContext.isBatchable) {
          if (this._graphicsDataContextHash[context.uid]) {
            BigPool.return(this.getContextRenderData(context));
            this._graphicsDataContextHash[context.uid] = null;
          }
        }
        if (gpuContext.batches) {
          gpuContext.batches.forEach((batch) => {
            BigPool.return(batch);
          });
        }
      }
      destroy() {
        for (const i in this._gpuContextHash) {
          if (this._gpuContextHash[i]) {
            this.onGraphicsContextDestroy(this._gpuContextHash[i].context);
          }
        }
      }
    };
    /** @ignore */
    _GraphicsContextSystem.extension = {
      type: [
        ExtensionType.WebGLSystem,
        ExtensionType.WebGPUSystem,
        ExtensionType.CanvasSystem
      ],
      name: "graphicsContext"
    };
    /** The default options for the GraphicsContextSystem. */
    _GraphicsContextSystem.defaultOptions = {
      /**
       * A value from 0 to 1 that controls the smoothness of bezier curves (the higher the smoother)
       * @default 0.5
       */
      bezierSmoothness: 0.5
    };
    let GraphicsContextSystem = _GraphicsContextSystem;

    "use strict";
    const blendModeIds = {
      normal: 0,
      add: 1,
      multiply: 2,
      screen: 3,
      overlay: 4,
      erase: 5,
      "normal-npm": 6,
      "add-npm": 7,
      "screen-npm": 8,
      min: 9,
      max: 10
    };
    const BLEND$1 = 0;
    const OFFSET$1 = 1;
    const CULLING$1 = 2;
    const DEPTH_TEST$1 = 3;
    const WINDING$1 = 4;
    const DEPTH_MASK$1 = 5;
    const _State = class _State {
      constructor() {
        this.data = 0;
        this.blendMode = "normal";
        this.polygonOffset = 0;
        this.blend = true;
        this.depthMask = true;
      }
      /**
       * Activates blending of the computed fragment color values.
       * @default true
       */
      get blend() {
        return !!(this.data & 1 << BLEND$1);
      }
      set blend(value) {
        if (!!(this.data & 1 << BLEND$1) !== value) {
          this.data ^= 1 << BLEND$1;
        }
      }
      /**
       * Activates adding an offset to depth values of polygon's fragments
       * @default false
       */
      get offsets() {
        return !!(this.data & 1 << OFFSET$1);
      }
      set offsets(value) {
        if (!!(this.data & 1 << OFFSET$1) !== value) {
          this.data ^= 1 << OFFSET$1;
        }
      }
      /** The culling settings for this state none - No culling back - Back face culling front - Front face culling */
      set cullMode(value) {
        if (value === "none") {
          this.culling = false;
          return;
        }
        this.culling = true;
        this.clockwiseFrontFace = value === "front";
      }
      get cullMode() {
        if (!this.culling) {
          return "none";
        }
        return this.clockwiseFrontFace ? "front" : "back";
      }
      /**
       * Activates culling of polygons.
       * @default false
       */
      get culling() {
        return !!(this.data & 1 << CULLING$1);
      }
      set culling(value) {
        if (!!(this.data & 1 << CULLING$1) !== value) {
          this.data ^= 1 << CULLING$1;
        }
      }
      /**
       * Activates depth comparisons and updates to the depth buffer.
       * @default false
       */
      get depthTest() {
        return !!(this.data & 1 << DEPTH_TEST$1);
      }
      set depthTest(value) {
        if (!!(this.data & 1 << DEPTH_TEST$1) !== value) {
          this.data ^= 1 << DEPTH_TEST$1;
        }
      }
      /**
       * Enables or disables writing to the depth buffer.
       * @default true
       */
      get depthMask() {
        return !!(this.data & 1 << DEPTH_MASK$1);
      }
      set depthMask(value) {
        if (!!(this.data & 1 << DEPTH_MASK$1) !== value) {
          this.data ^= 1 << DEPTH_MASK$1;
        }
      }
      /**
       * Specifies whether or not front or back-facing polygons can be culled.
       * @default false
       */
      get clockwiseFrontFace() {
        return !!(this.data & 1 << WINDING$1);
      }
      set clockwiseFrontFace(value) {
        if (!!(this.data & 1 << WINDING$1) !== value) {
          this.data ^= 1 << WINDING$1;
        }
      }
      /**
       * The blend mode to be applied when this state is set. Apply a value of `normal` to reset the blend mode.
       * Setting this mode to anything other than NO_BLEND will automatically switch blending on.
       * @default 'normal'
       */
      get blendMode() {
        return this._blendMode;
      }
      set blendMode(value) {
        this.blend = value !== "none";
        this._blendMode = value;
        this._blendModeId = blendModeIds[value] || 0;
      }
      /**
       * The polygon offset. Setting this property to anything other than 0 will automatically enable polygon offset fill.
       * @default 0
       */
      get polygonOffset() {
        return this._polygonOffset;
      }
      set polygonOffset(value) {
        this.offsets = !!value;
        this._polygonOffset = value;
      }
      toString() {
        return `[pixi.js/core:State blendMode=${this.blendMode} clockwiseFrontFace=${this.clockwiseFrontFace} culling=${this.culling} depthMask=${this.depthMask} polygonOffset=${this.polygonOffset}]`;
      }
      /**
       * A quickly getting an instance of a State that is configured for 2d rendering.
       * @returns a new State with values set for 2d rendering
       */
      static for2d() {
        const state = new _State();
        state.depthTest = false;
        state.blend = true;
        return state;
      }
    };
    _State.default2d = _State.for2d();
    let State = _State;

    "use strict";
    function colorToUniform(rgb, alpha, out, offset) {
      out[offset++] = (rgb >> 16 & 255) / 255;
      out[offset++] = (rgb >> 8 & 255) / 255;
      out[offset++] = (rgb & 255) / 255;
      out[offset++] = alpha;
    }
    function color32BitToUniform(abgr, out, offset) {
      const alpha = (abgr >> 24 & 255) / 255;
      out[offset++] = (abgr & 255) / 255 * alpha;
      out[offset++] = (abgr >> 8 & 255) / 255 * alpha;
      out[offset++] = (abgr >> 16 & 255) / 255 * alpha;
      out[offset++] = alpha;
    }

    "use strict";
    class GraphicsPipe {
      constructor(renderer, adaptor) {
        this.state = State.for2d();
        // batchable graphics list, used to render batches
        this._graphicsBatchesHash = /* @__PURE__ */ Object.create(null);
        this._destroyRenderableBound = this.destroyRenderable.bind(this);
        this.renderer = renderer;
        this._adaptor = adaptor;
        this._adaptor.init();
        this.renderer.renderableGC.addManagedHash(this, "_graphicsBatchesHash");
      }
      validateRenderable(graphics) {
        const context = graphics.context;
        const wasBatched = !!this._graphicsBatchesHash[graphics.uid];
        const gpuContext = this.renderer.graphicsContext.updateGpuContext(context);
        if (gpuContext.isBatchable || wasBatched !== gpuContext.isBatchable) {
          return true;
        }
        return false;
      }
      addRenderable(graphics, instructionSet) {
        const gpuContext = this.renderer.graphicsContext.updateGpuContext(graphics.context);
        if (graphics.didViewUpdate) {
          this._rebuild(graphics);
        }
        if (gpuContext.isBatchable) {
          this._addToBatcher(graphics, instructionSet);
        } else {
          this.renderer.renderPipes.batch.break(instructionSet);
          instructionSet.add(graphics);
        }
      }
      updateRenderable(graphics) {
        const batches = this._graphicsBatchesHash[graphics.uid];
        if (batches) {
          for (let i = 0; i < batches.length; i++) {
            const batch = batches[i];
            batch._batcher.updateElement(batch);
          }
        }
      }
      destroyRenderable(graphics) {
        if (this._graphicsBatchesHash[graphics.uid]) {
          this._removeBatchForRenderable(graphics.uid);
        }
        graphics.off("destroyed", this._destroyRenderableBound);
      }
      execute(graphics) {
        if (!graphics.isRenderable)
          return;
        const renderer = this.renderer;
        const context = graphics.context;
        const contextSystem = renderer.graphicsContext;
        if (!contextSystem.getGpuContext(context).batches.length) {
          return;
        }
        const shader = context.customShader || this._adaptor.shader;
        this.state.blendMode = graphics.groupBlendMode;
        const localUniforms = shader.resources.localUniforms.uniforms;
        localUniforms.uTransformMatrix = graphics.groupTransform;
        localUniforms.uRound = renderer._roundPixels | graphics._roundPixels;
        color32BitToUniform(
          graphics.groupColorAlpha,
          localUniforms.uColor,
          0
        );
        this._adaptor.execute(this, graphics);
      }
      _rebuild(graphics) {
        const wasBatched = !!this._graphicsBatchesHash[graphics.uid];
        const gpuContext = this.renderer.graphicsContext.updateGpuContext(graphics.context);
        if (wasBatched) {
          this._removeBatchForRenderable(graphics.uid);
        }
        if (gpuContext.isBatchable) {
          this._initBatchesForRenderable(graphics);
        }
        graphics.batched = gpuContext.isBatchable;
      }
      _addToBatcher(graphics, instructionSet) {
        const batchPipe = this.renderer.renderPipes.batch;
        const batches = this._getBatchesForRenderable(graphics);
        for (let i = 0; i < batches.length; i++) {
          const batch = batches[i];
          batchPipe.addToBatch(batch, instructionSet);
        }
      }
      _getBatchesForRenderable(graphics) {
        return this._graphicsBatchesHash[graphics.uid] || this._initBatchesForRenderable(graphics);
      }
      _initBatchesForRenderable(graphics) {
        const context = graphics.context;
        const gpuContext = this.renderer.graphicsContext.getGpuContext(context);
        const roundPixels = this.renderer._roundPixels | graphics._roundPixels;
        const batches = gpuContext.batches.map((batch) => {
          const batchClone = BigPool.get(BatchableGraphics);
          batch.copyTo(batchClone);
          batchClone.renderable = graphics;
          batchClone.roundPixels = roundPixels;
          return batchClone;
        });
        if (this._graphicsBatchesHash[graphics.uid] === void 0) {
          graphics.on("destroyed", this._destroyRenderableBound);
        }
        this._graphicsBatchesHash[graphics.uid] = batches;
        return batches;
      }
      _removeBatchForRenderable(graphicsUid) {
        this._graphicsBatchesHash[graphicsUid].forEach((batch) => {
          BigPool.return(batch);
        });
        this._graphicsBatchesHash[graphicsUid] = null;
      }
      destroy() {
        this.renderer = null;
        this._adaptor.destroy();
        this._adaptor = null;
        this.state = null;
        for (const i in this._graphicsBatchesHash) {
          this._removeBatchForRenderable(i);
        }
        this._graphicsBatchesHash = null;
      }
    }
    /** @ignore */
    GraphicsPipe.extension = {
      type: [
        ExtensionType.WebGLPipes,
        ExtensionType.WebGPUPipes,
        ExtensionType.CanvasPipes
      ],
      name: "graphics"
    };

    "use strict";
    extensions.add(GraphicsPipe);
    extensions.add(GraphicsContextSystem);

    "use strict";
    class BatchableMesh {
      constructor() {
        this.batcherName = "default";
        this.packAsQuad = false;
        this.indexOffset = 0;
        this.attributeOffset = 0;
        this.roundPixels = 0;
        this._batcher = null;
        this._batch = null;
        this._uvUpdateId = -1;
        this._textureMatrixUpdateId = -1;
      }
      get blendMode() {
        return this.renderable.groupBlendMode;
      }
      get topology() {
        return this._topology || this.geometry.topology;
      }
      set topology(value) {
        this._topology = value;
      }
      reset() {
        this.renderable = null;
        this.texture = null;
        this._batcher = null;
        this._batch = null;
        this.geometry = null;
        this._uvUpdateId = -1;
        this._textureMatrixUpdateId = -1;
      }
      get uvs() {
        const geometry = this.geometry;
        const uvBuffer = geometry.getBuffer("aUV");
        const uvs = uvBuffer.data;
        let transformedUvs = uvs;
        const textureMatrix = this.texture.textureMatrix;
        if (!textureMatrix.isSimple) {
          transformedUvs = this._transformedUvs;
          if (this._textureMatrixUpdateId !== textureMatrix._updateID || this._uvUpdateId !== uvBuffer._updateID) {
            if (!transformedUvs || transformedUvs.length < uvs.length) {
              transformedUvs = this._transformedUvs = new Float32Array(uvs.length);
            }
            this._textureMatrixUpdateId = textureMatrix._updateID;
            this._uvUpdateId = uvBuffer._updateID;
            textureMatrix.multiplyUvs(uvs, transformedUvs);
          }
        }
        return transformedUvs;
      }
      get positions() {
        return this.geometry.positions;
      }
      get indices() {
        return this.geometry.indices;
      }
      get color() {
        return this.renderable.groupColorAlpha;
      }
      get groupTransform() {
        return this.renderable.groupTransform;
      }
      get attributeSize() {
        return this.geometry.positions.length / 2;
      }
      get indexSize() {
        return this.geometry.indices.length;
      }
    }

    "use strict";
    class MeshPipe {
      constructor(renderer, adaptor) {
        this.localUniforms = new UniformGroup({
          uTransformMatrix: { value: new Matrix(), type: "mat3x3<f32>" },
          uColor: { value: new Float32Array([1, 1, 1, 1]), type: "vec4<f32>" },
          uRound: { value: 0, type: "f32" }
        });
        this.localUniformsBindGroup = new BindGroup({
          0: this.localUniforms
        });
        this._meshDataHash = /* @__PURE__ */ Object.create(null);
        this._gpuBatchableMeshHash = /* @__PURE__ */ Object.create(null);
        this._destroyRenderableBound = this.destroyRenderable.bind(this);
        this.renderer = renderer;
        this._adaptor = adaptor;
        this._adaptor.init();
        renderer.renderableGC.addManagedHash(this, "_gpuBatchableMeshHash");
        renderer.renderableGC.addManagedHash(this, "_meshDataHash");
      }
      validateRenderable(mesh) {
        const meshData = this._getMeshData(mesh);
        const wasBatched = meshData.batched;
        const isBatched = mesh.batched;
        meshData.batched = isBatched;
        if (wasBatched !== isBatched) {
          return true;
        } else if (isBatched) {
          const geometry = mesh._geometry;
          if (geometry.indices.length !== meshData.indexSize || geometry.positions.length !== meshData.vertexSize) {
            meshData.indexSize = geometry.indices.length;
            meshData.vertexSize = geometry.positions.length;
            return true;
          }
          const batchableMesh = this._getBatchableMesh(mesh);
          const texture = mesh.texture;
          if (batchableMesh.texture._source !== texture._source) {
            if (batchableMesh.texture._source !== texture._source) {
              return !batchableMesh._batcher.checkAndUpdateTexture(batchableMesh, texture);
            }
          }
        }
        return false;
      }
      addRenderable(mesh, instructionSet) {
        const batcher = this.renderer.renderPipes.batch;
        const { batched } = this._getMeshData(mesh);
        if (batched) {
          const gpuBatchableMesh = this._getBatchableMesh(mesh);
          gpuBatchableMesh.texture = mesh._texture;
          gpuBatchableMesh.geometry = mesh._geometry;
          batcher.addToBatch(gpuBatchableMesh, instructionSet);
        } else {
          batcher.break(instructionSet);
          instructionSet.add(mesh);
        }
      }
      updateRenderable(mesh) {
        if (mesh.batched) {
          const gpuBatchableMesh = this._gpuBatchableMeshHash[mesh.uid];
          gpuBatchableMesh.texture = mesh._texture;
          gpuBatchableMesh.geometry = mesh._geometry;
          gpuBatchableMesh._batcher.updateElement(gpuBatchableMesh);
        }
      }
      destroyRenderable(mesh) {
        this._meshDataHash[mesh.uid] = null;
        const gpuMesh = this._gpuBatchableMeshHash[mesh.uid];
        if (gpuMesh) {
          BigPool.return(gpuMesh);
          this._gpuBatchableMeshHash[mesh.uid] = null;
        }
        mesh.off("destroyed", this._destroyRenderableBound);
      }
      execute(mesh) {
        if (!mesh.isRenderable)
          return;
        mesh.state.blendMode = getAdjustedBlendModeBlend(mesh.groupBlendMode, mesh.texture._source);
        const localUniforms = this.localUniforms;
        localUniforms.uniforms.uTransformMatrix = mesh.groupTransform;
        localUniforms.uniforms.uRound = this.renderer._roundPixels | mesh._roundPixels;
        localUniforms.update();
        color32BitToUniform(
          mesh.groupColorAlpha,
          localUniforms.uniforms.uColor,
          0
        );
        this._adaptor.execute(this, mesh);
      }
      _getMeshData(mesh) {
        return this._meshDataHash[mesh.uid] || this._initMeshData(mesh);
      }
      _initMeshData(mesh) {
        var _a, _b;
        this._meshDataHash[mesh.uid] = {
          batched: mesh.batched,
          indexSize: (_a = mesh._geometry.indices) == null ? void 0 : _a.length,
          vertexSize: (_b = mesh._geometry.positions) == null ? void 0 : _b.length
        };
        mesh.on("destroyed", this._destroyRenderableBound);
        return this._meshDataHash[mesh.uid];
      }
      _getBatchableMesh(mesh) {
        return this._gpuBatchableMeshHash[mesh.uid] || this._initBatchableMesh(mesh);
      }
      _initBatchableMesh(mesh) {
        const gpuMesh = BigPool.get(BatchableMesh);
        gpuMesh.renderable = mesh;
        gpuMesh.texture = mesh._texture;
        gpuMesh.transform = mesh.groupTransform;
        gpuMesh.roundPixels = this.renderer._roundPixels | mesh._roundPixels;
        this._gpuBatchableMeshHash[mesh.uid] = gpuMesh;
        return gpuMesh;
      }
      destroy() {
        for (const i in this._gpuBatchableMeshHash) {
          if (this._gpuBatchableMeshHash[i]) {
            BigPool.return(this._gpuBatchableMeshHash[i]);
          }
        }
        this._gpuBatchableMeshHash = null;
        this._meshDataHash = null;
        this.localUniforms = null;
        this.localUniformsBindGroup = null;
        this._adaptor.destroy();
        this._adaptor = null;
        this.renderer = null;
      }
    }
    /** @ignore */
    MeshPipe.extension = {
      type: [
        ExtensionType.WebGLPipes,
        ExtensionType.WebGPUPipes,
        ExtensionType.CanvasPipes
      ],
      name: "mesh"
    };

    "use strict";
    extensions.add(MeshPipe);

    "use strict";
    class GlParticleContainerAdaptor {
      execute(particleContainerPipe, container) {
        const state = particleContainerPipe.state;
        const renderer = particleContainerPipe.renderer;
        const shader = container.shader || particleContainerPipe.defaultShader;
        shader.resources.uTexture = container.texture._source;
        shader.resources.uniforms = particleContainerPipe.localUniforms;
        const gl = renderer.gl;
        const buffer = particleContainerPipe.getBuffers(container);
        renderer.shader.bind(shader);
        renderer.state.set(state);
        renderer.geometry.bind(buffer.geometry, shader.glProgram);
        const byteSize = buffer.geometry.indexBuffer.data.BYTES_PER_ELEMENT;
        const glType = byteSize === 2 ? gl.UNSIGNED_SHORT : gl.UNSIGNED_INT;
        gl.drawElements(gl.TRIANGLES, container.particleChildren.length * 6, glType, 0);
      }
    }

    "use strict";
    function createIndicesForQuads(size, outBuffer = null) {
      const totalIndices = size * 6;
      if (totalIndices > 65535) {
        outBuffer || (outBuffer = new Uint32Array(totalIndices));
      } else {
        outBuffer || (outBuffer = new Uint16Array(totalIndices));
      }
      if (outBuffer.length !== totalIndices) {
        throw new Error(`Out buffer length is incorrect, got ${outBuffer.length} and expected ${totalIndices}`);
      }
      for (let i = 0, j = 0; i < totalIndices; i += 6, j += 4) {
        outBuffer[i + 0] = j + 0;
        outBuffer[i + 1] = j + 1;
        outBuffer[i + 2] = j + 2;
        outBuffer[i + 3] = j + 0;
        outBuffer[i + 4] = j + 2;
        outBuffer[i + 5] = j + 3;
      }
      return outBuffer;
    }

    "use strict";
    function generateParticleUpdateFunction(properties) {
      return {
        dynamicUpdate: generateUpdateFunction(properties, true),
        staticUpdate: generateUpdateFunction(properties, false)
      };
    }
    function generateUpdateFunction(properties, dynamic) {
      const funcFragments = [];
      funcFragments.push(`
      
        var index = 0;

        for (let i = 0; i < ps.length; ++i)
        {
            const p = ps[i];

            `);
      let offset = 0;
      for (const i in properties) {
        const property = properties[i];
        if (dynamic !== property.dynamic)
          continue;
        funcFragments.push(`offset = index + ${offset}`);
        funcFragments.push(property.code);
        const attributeInfo = getAttributeInfoFromFormat(property.format);
        offset += attributeInfo.stride / 4;
      }
      funcFragments.push(`
            index += stride * 4;
        }
    `);
      funcFragments.unshift(`
        var stride = ${offset};
    `);
      const functionSource = funcFragments.join("\n");
      return new Function("ps", "f32v", "u32v", functionSource);
    }

    "use strict";
    class ParticleBuffer {
      constructor(options) {
        this._size = 0;
        this._generateParticleUpdateCache = {};
        var _a;
        const size = this._size = (_a = options.size) != null ? _a : 1e3;
        const properties = options.properties;
        let staticVertexSize = 0;
        let dynamicVertexSize = 0;
        for (const i in properties) {
          const property = properties[i];
          const attributeInfo = getAttributeInfoFromFormat(property.format);
          if (property.dynamic) {
            dynamicVertexSize += attributeInfo.stride;
          } else {
            staticVertexSize += attributeInfo.stride;
          }
        }
        this._dynamicStride = dynamicVertexSize / 4;
        this._staticStride = staticVertexSize / 4;
        this.staticAttributeBuffer = new ViewableBuffer(size * 4 * staticVertexSize);
        this.dynamicAttributeBuffer = new ViewableBuffer(size * 4 * dynamicVertexSize);
        this.indexBuffer = createIndicesForQuads(size);
        const geometry = new Geometry();
        let dynamicOffset = 0;
        let staticOffset = 0;
        this._staticBuffer = new Buffer({
          data: new Float32Array(1),
          label: "static-particle-buffer",
          shrinkToFit: false,
          usage: BufferUsage.VERTEX | BufferUsage.COPY_DST
        });
        this._dynamicBuffer = new Buffer({
          data: new Float32Array(1),
          label: "dynamic-particle-buffer",
          shrinkToFit: false,
          usage: BufferUsage.VERTEX | BufferUsage.COPY_DST
        });
        for (const i in properties) {
          const property = properties[i];
          const attributeInfo = getAttributeInfoFromFormat(property.format);
          if (property.dynamic) {
            geometry.addAttribute(property.attributeName, {
              buffer: this._dynamicBuffer,
              stride: this._dynamicStride * 4,
              offset: dynamicOffset * 4,
              format: property.format
            });
            dynamicOffset += attributeInfo.size;
          } else {
            geometry.addAttribute(property.attributeName, {
              buffer: this._staticBuffer,
              stride: this._staticStride * 4,
              offset: staticOffset * 4,
              format: property.format
            });
            staticOffset += attributeInfo.size;
          }
        }
        geometry.addIndex(this.indexBuffer);
        const uploadFunction = this.getParticleUpdate(properties);
        this._dynamicUpload = uploadFunction.dynamicUpdate;
        this._staticUpload = uploadFunction.staticUpdate;
        this.geometry = geometry;
      }
      getParticleUpdate(properties) {
        const key = getParticleSyncKey(properties);
        if (this._generateParticleUpdateCache[key]) {
          return this._generateParticleUpdateCache[key];
        }
        this._generateParticleUpdateCache[key] = this.generateParticleUpdate(properties);
        return this._generateParticleUpdateCache[key];
      }
      generateParticleUpdate(properties) {
        return generateParticleUpdateFunction(properties);
      }
      update(particles, uploadStatic) {
        if (particles.length > this._size) {
          uploadStatic = true;
          this._size = Math.max(particles.length, this._size * 1.5 | 0);
          this.staticAttributeBuffer = new ViewableBuffer(this._size * this._staticStride * 4 * 4);
          this.dynamicAttributeBuffer = new ViewableBuffer(this._size * this._dynamicStride * 4 * 4);
          this.indexBuffer = createIndicesForQuads(this._size);
          this.geometry.indexBuffer.setDataWithSize(
            this.indexBuffer,
            this.indexBuffer.byteLength,
            true
          );
        }
        const dynamicAttributeBuffer = this.dynamicAttributeBuffer;
        this._dynamicUpload(particles, dynamicAttributeBuffer.float32View, dynamicAttributeBuffer.uint32View);
        this._dynamicBuffer.setDataWithSize(
          this.dynamicAttributeBuffer.float32View,
          particles.length * this._dynamicStride * 4,
          true
        );
        if (uploadStatic) {
          const staticAttributeBuffer = this.staticAttributeBuffer;
          this._staticUpload(particles, staticAttributeBuffer.float32View, staticAttributeBuffer.uint32View);
          this._staticBuffer.setDataWithSize(
            staticAttributeBuffer.float32View,
            particles.length * this._staticStride * 4,
            true
          );
        }
      }
      destroy() {
        this._staticBuffer.destroy();
        this._dynamicBuffer.destroy();
        this.geometry.destroy();
      }
    }
    function getParticleSyncKey(properties) {
      const keyGen = [];
      for (const key in properties) {
        const property = properties[key];
        keyGen.push(key, property.code, property.dynamic ? "d" : "s");
      }
      return keyGen.join("_");
    }

    var fragment$5 = "varying vec2 vUV;\nvarying vec4 vColor;\n\nuniform sampler2D uTexture;\n\nvoid main(void){\n    vec4 color = texture2D(uTexture, vUV) * vColor;\n    gl_FragColor = color;\n}";

    var vertex$3 = "attribute vec2 aVertex;\nattribute vec2 aUV;\nattribute vec4 aColor;\n\nattribute vec2 aPosition;\nattribute float aRotation;\n\nuniform mat3 uTranslationMatrix;\nuniform float uRound;\nuniform vec2 uResolution;\nuniform vec4 uColor;\n\nvarying vec2 vUV;\nvarying vec4 vColor;\n\nvec2 roundPixels(vec2 position, vec2 targetSize)\n{       \n    return (floor(((position * 0.5 + 0.5) * targetSize) + 0.5) / targetSize) * 2.0 - 1.0;\n}\n\nvoid main(void){\n    float cosRotation = cos(aRotation);\n    float sinRotation = sin(aRotation);\n    float x = aVertex.x * cosRotation - aVertex.y * sinRotation;\n    float y = aVertex.x * sinRotation + aVertex.y * cosRotation;\n\n    vec2 v = vec2(x, y);\n    v = v + aPosition;\n\n    gl_Position = vec4((uTranslationMatrix * vec3(v, 1.0)).xy, 0.0, 1.0);\n\n    if(uRound == 1.0)\n    {\n        gl_Position.xy = roundPixels(gl_Position.xy, uResolution);\n    }\n\n    vUV = aUV;\n    vColor = vec4(aColor.rgb * aColor.a, aColor.a) * uColor;\n}\n";

    var wgsl = "\nstruct ParticleUniforms {\n  uProjectionMatrix:mat3x3<f32>,\n  uColor:vec4<f32>,\n  uResolution:vec2<f32>,\n  uRoundPixels:f32,\n};\n\n@group(0) @binding(0) var<uniform> uniforms: ParticleUniforms;\n\n@group(1) @binding(0) var uTexture: texture_2d<f32>;\n@group(1) @binding(1) var uSampler : sampler;\n\nstruct VSOutput {\n    @builtin(position) position: vec4<f32>,\n    @location(0) uv : vec2<f32>,\n    @location(1) color : vec4<f32>,\n  };\n@vertex\nfn mainVertex(\n  @location(0) aVertex: vec2<f32>,\n  @location(1) aPosition: vec2<f32>,\n  @location(2) aUV: vec2<f32>,\n  @location(3) aColor: vec4<f32>,\n  @location(4) aRotation: f32,\n) -> VSOutput {\n  \n   let v = vec2(\n       aVertex.x * cos(aRotation) - aVertex.y * sin(aRotation),\n       aVertex.x * sin(aRotation) + aVertex.y * cos(aRotation)\n   ) + aPosition;\n\n   let position = vec4((uniforms.uProjectionMatrix * vec3(v, 1.0)).xy, 0.0, 1.0);\n\n    let vColor = vec4(aColor.rgb * aColor.a, aColor.a) * uniforms.uColor;\n\n  return VSOutput(\n   position,\n   aUV,\n   vColor,\n  );\n}\n\n@fragment\nfn mainFragment(\n  @location(0) uv: vec2<f32>,\n  @location(1) color: vec4<f32>,\n  @builtin(position) position: vec4<f32>,\n) -> @location(0) vec4<f32> {\n\n    var sample = textureSample(uTexture, uSampler, uv) * color;\n   \n    return sample;\n}";

    "use strict";
    class ParticleShader extends Shader {
      constructor() {
        const glProgram = GlProgram.from({
          vertex: vertex$3,
          fragment: fragment$5
        });
        const gpuProgram = GpuProgram.from({
          fragment: {
            source: wgsl,
            entryPoint: "mainFragment"
          },
          vertex: {
            source: wgsl,
            entryPoint: "mainVertex"
          }
        });
        super({
          glProgram,
          gpuProgram,
          resources: {
            // this will be replaced with the texture from the particle container
            uTexture: Texture.WHITE.source,
            // this will be replaced with the texture style from the particle container
            uSampler: new TextureStyle({}),
            // this will be replaced with the local uniforms from the particle container
            uniforms: {
              uTranslationMatrix: { value: new Matrix(), type: "mat3x3<f32>" },
              uColor: { value: new Color(16777215), type: "vec4<f32>" },
              uRound: { value: 1, type: "f32" },
              uResolution: { value: [0, 0], type: "vec2<f32>" }
            }
          }
        });
      }
    }

    "use strict";
    class ParticleContainerPipe {
      /**
       * @param renderer - The renderer this sprite batch works for.
       * @param adaptor
       */
      constructor(renderer, adaptor) {
        this.state = State.for2d();
        this._gpuBufferHash = /* @__PURE__ */ Object.create(null);
        // eslint-disable-next-line max-len
        this._destroyRenderableBound = this.destroyRenderable.bind(this);
        this.localUniforms = new UniformGroup({
          uTranslationMatrix: { value: new Matrix(), type: "mat3x3<f32>" },
          uColor: { value: new Float32Array(4), type: "vec4<f32>" },
          uRound: { value: 1, type: "f32" },
          uResolution: { value: [0, 0], type: "vec2<f32>" }
        });
        this.renderer = renderer;
        this.adaptor = adaptor;
        this.defaultShader = new ParticleShader();
        this.state = State.for2d();
      }
      validateRenderable(_renderable) {
        return false;
      }
      addRenderable(renderable, instructionSet) {
        this.renderer.renderPipes.batch.break(instructionSet);
        instructionSet.add(renderable);
      }
      getBuffers(renderable) {
        return this._gpuBufferHash[renderable.uid] || this._initBuffer(renderable);
      }
      _initBuffer(renderable) {
        this._gpuBufferHash[renderable.uid] = new ParticleBuffer({
          size: renderable.particleChildren.length,
          properties: renderable._properties
        });
        renderable.on("destroyed", this._destroyRenderableBound);
        return this._gpuBufferHash[renderable.uid];
      }
      updateRenderable(_renderable) {
      }
      destroyRenderable(renderable) {
        const buffer = this._gpuBufferHash[renderable.uid];
        buffer.destroy();
        this._gpuBufferHash[renderable.uid] = null;
        renderable.off("destroyed", this._destroyRenderableBound);
      }
      execute(container) {
        const children = container.particleChildren;
        if (children.length === 0) {
          return;
        }
        const renderer = this.renderer;
        const buffer = this.getBuffers(container);
        container.texture || (container.texture = children[0].texture);
        const state = this.state;
        buffer.update(children, container._childrenDirty);
        container._childrenDirty = false;
        state.blendMode = getAdjustedBlendModeBlend(container.blendMode, container.texture._source);
        const uniforms = this.localUniforms.uniforms;
        const transformationMatrix = uniforms.uTranslationMatrix;
        container.worldTransform.copyTo(transformationMatrix);
        transformationMatrix.prepend(renderer.globalUniforms.globalUniformData.projectionMatrix);
        uniforms.uResolution = renderer.globalUniforms.globalUniformData.resolution;
        uniforms.uRound = renderer._roundPixels | container._roundPixels;
        color32BitToUniform(
          container.groupColorAlpha,
          uniforms.uColor,
          0
        );
        this.adaptor.execute(this, container);
      }
      /** Destroys the ParticleRenderer. */
      destroy() {
        if (this.defaultShader) {
          this.defaultShader.destroy();
          this.defaultShader = null;
        }
      }
    }

    "use strict";
    class GlParticleContainerPipe extends ParticleContainerPipe {
      constructor(renderer) {
        super(renderer, new GlParticleContainerAdaptor());
      }
    }
    /** @ignore */
    GlParticleContainerPipe.extension = {
      type: [
        ExtensionType.WebGLPipes
      ],
      name: "particle"
    };

    "use strict";
    class GpuParticleContainerAdaptor {
      execute(particleContainerPipe, container) {
        const renderer = particleContainerPipe.renderer;
        const shader = container.shader || particleContainerPipe.defaultShader;
        shader.groups[0] = renderer.renderPipes.uniformBatch.getUniformBindGroup(particleContainerPipe.localUniforms, true);
        shader.groups[1] = renderer.texture.getTextureBindGroup(container.texture);
        const state = particleContainerPipe.state;
        const buffer = particleContainerPipe.getBuffers(container);
        renderer.encoder.draw({
          geometry: buffer.geometry,
          shader: container.shader || particleContainerPipe.defaultShader,
          state,
          size: container.particleChildren.length * 6
        });
      }
    }

    "use strict";
    class GpuParticleContainerPipe extends ParticleContainerPipe {
      constructor(renderer) {
        super(renderer, new GpuParticleContainerAdaptor());
      }
    }
    /** @ignore */
    GpuParticleContainerPipe.extension = {
      type: [
        ExtensionType.WebGPUPipes
      ],
      name: "particle"
    };

    "use strict";
    extensions.add(GlParticleContainerPipe);
    extensions.add(GpuParticleContainerPipe);

    "use strict";
    class BatchableSprite {
      constructor() {
        this.batcherName = "default";
        this.topology = "triangle-list";
        // batch specific..
        this.attributeSize = 4;
        this.indexSize = 6;
        this.packAsQuad = true;
        this.roundPixels = 0;
        this._attributeStart = 0;
        // location in the buffer
        this._batcher = null;
        this._batch = null;
      }
      get blendMode() {
        return this.renderable.groupBlendMode;
      }
      get color() {
        return this.renderable.groupColorAlpha;
      }
      reset() {
        this.renderable = null;
        this.texture = null;
        this._batcher = null;
        this._batch = null;
        this.bounds = null;
      }
    }

    "use strict";
    class CanvasTextPipe {
      constructor(renderer) {
        this._gpuText = /* @__PURE__ */ Object.create(null);
        this._destroyRenderableBound = this.destroyRenderable.bind(this);
        this._renderer = renderer;
        this._renderer.runners.resolutionChange.add(this);
        this._renderer.renderableGC.addManagedHash(this, "_gpuText");
      }
      resolutionChange() {
        for (const i in this._gpuText) {
          const gpuText = this._gpuText[i];
          if (!gpuText)
            continue;
          const text = gpuText.batchableSprite.renderable;
          if (text._autoResolution) {
            text._resolution = this._renderer.resolution;
            text.onViewUpdate();
          }
        }
      }
      validateRenderable(text) {
        const gpuText = this._getGpuText(text);
        const newKey = text._getKey();
        if (gpuText.currentKey !== newKey) {
          return true;
        }
        return false;
      }
      addRenderable(text, instructionSet) {
        const gpuText = this._getGpuText(text);
        const batchableSprite = gpuText.batchableSprite;
        if (text._didTextUpdate) {
          this._updateText(text);
        }
        this._renderer.renderPipes.batch.addToBatch(batchableSprite, instructionSet);
      }
      updateRenderable(text) {
        const gpuText = this._getGpuText(text);
        const batchableSprite = gpuText.batchableSprite;
        if (text._didTextUpdate) {
          this._updateText(text);
        }
        batchableSprite._batcher.updateElement(batchableSprite);
      }
      destroyRenderable(text) {
        text.off("destroyed", this._destroyRenderableBound);
        this._destroyRenderableById(text.uid);
      }
      _destroyRenderableById(textUid) {
        const gpuText = this._gpuText[textUid];
        this._renderer.canvasText.decreaseReferenceCount(gpuText.currentKey);
        BigPool.return(gpuText.batchableSprite);
        this._gpuText[textUid] = null;
      }
      _updateText(text) {
        const newKey = text._getKey();
        const gpuText = this._getGpuText(text);
        const batchableSprite = gpuText.batchableSprite;
        if (gpuText.currentKey !== newKey) {
          this._updateGpuText(text);
        }
        text._didTextUpdate = false;
        const padding = text._style.padding;
        updateQuadBounds(batchableSprite.bounds, text._anchor, batchableSprite.texture, padding);
      }
      _updateGpuText(text) {
        const gpuText = this._getGpuText(text);
        const batchableSprite = gpuText.batchableSprite;
        if (gpuText.texture) {
          this._renderer.canvasText.decreaseReferenceCount(gpuText.currentKey);
        }
        gpuText.texture = batchableSprite.texture = this._renderer.canvasText.getManagedTexture(text);
        gpuText.currentKey = text._getKey();
        batchableSprite.texture = gpuText.texture;
      }
      _getGpuText(text) {
        return this._gpuText[text.uid] || this.initGpuText(text);
      }
      initGpuText(text) {
        const gpuTextData = {
          texture: null,
          currentKey: "--",
          batchableSprite: BigPool.get(BatchableSprite)
        };
        gpuTextData.batchableSprite.renderable = text;
        gpuTextData.batchableSprite.transform = text.groupTransform;
        gpuTextData.batchableSprite.bounds = { minX: 0, maxX: 1, minY: 0, maxY: 0 };
        gpuTextData.batchableSprite.roundPixels = this._renderer._roundPixels | text._roundPixels;
        this._gpuText[text.uid] = gpuTextData;
        text._resolution = text._autoResolution ? this._renderer.resolution : text.resolution;
        this._updateText(text);
        text.on("destroyed", this._destroyRenderableBound);
        return gpuTextData;
      }
      destroy() {
        for (const i in this._gpuText) {
          this._destroyRenderableById(i);
        }
        this._gpuText = null;
        this._renderer = null;
      }
    }
    /** @ignore */
    CanvasTextPipe.extension = {
      type: [
        ExtensionType.WebGLPipes,
        ExtensionType.WebGPUPipes,
        ExtensionType.CanvasPipes
      ],
      name: "text"
    };

    "use strict";
    class CanvasPoolClass {
      constructor(canvasOptions) {
        this._canvasPool = /* @__PURE__ */ Object.create(null);
        this.canvasOptions = canvasOptions || {};
        this.enableFullScreen = false;
      }
      /**
       * Creates texture with params that were specified in pool constructor.
       * @param pixelWidth - Width of texture in pixels.
       * @param pixelHeight - Height of texture in pixels.
       */
      _createCanvasAndContext(pixelWidth, pixelHeight) {
        const canvas = DOMAdapter.get().createCanvas();
        canvas.width = pixelWidth;
        canvas.height = pixelHeight;
        const context = canvas.getContext("2d");
        return { canvas, context };
      }
      /**
       * Gets a Power-of-Two render texture or fullScreen texture
       * @param minWidth - The minimum width of the render texture.
       * @param minHeight - The minimum height of the render texture.
       * @param resolution - The resolution of the render texture.
       * @returns The new render texture.
       */
      getOptimalCanvasAndContext(minWidth, minHeight, resolution = 1) {
        minWidth = Math.ceil(minWidth * resolution - 1e-6);
        minHeight = Math.ceil(minHeight * resolution - 1e-6);
        minWidth = nextPow2(minWidth);
        minHeight = nextPow2(minHeight);
        const key = (minWidth << 17) + (minHeight << 1);
        if (!this._canvasPool[key]) {
          this._canvasPool[key] = [];
        }
        let canvasAndContext = this._canvasPool[key].pop();
        if (!canvasAndContext) {
          canvasAndContext = this._createCanvasAndContext(minWidth, minHeight);
        }
        return canvasAndContext;
      }
      /**
       * Place a render texture back into the pool.
       * @param canvasAndContext
       */
      returnCanvasAndContext(canvasAndContext) {
        const canvas = canvasAndContext.canvas;
        const { width, height } = canvas;
        const key = (width << 17) + (height << 1);
        canvasAndContext.context.clearRect(0, 0, width, height);
        this._canvasPool[key].push(canvasAndContext);
      }
      clear() {
        this._canvasPool = {};
      }
    }
    const CanvasPool = new CanvasPoolClass();

    "use strict";
    function checkRow(data, width, y) {
      for (let x = 0, index = 4 * y * width; x < width; ++x, index += 4) {
        if (data[index + 3] !== 0)
          return false;
      }
      return true;
    }
    function checkColumn(data, width, x, top, bottom) {
      const stride = 4 * width;
      for (let y = top, index = top * stride + 4 * x; y <= bottom; ++y, index += stride) {
        if (data[index + 3] !== 0)
          return false;
      }
      return true;
    }
    function getCanvasBoundingBox(canvas, resolution = 1) {
      const { width, height } = canvas;
      const context = canvas.getContext("2d", {
        willReadFrequently: true
      });
      if (context === null) {
        throw new TypeError("Failed to get canvas 2D context");
      }
      const imageData = context.getImageData(0, 0, width, height);
      const data = imageData.data;
      let left = 0;
      let top = 0;
      let right = width - 1;
      let bottom = height - 1;
      while (top < height && checkRow(data, width, top))
        ++top;
      if (top === height)
        return Rectangle.EMPTY;
      while (checkRow(data, width, bottom))
        --bottom;
      while (checkColumn(data, width, left, top, bottom))
        ++left;
      while (checkColumn(data, width, right, top, bottom))
        --right;
      ++right;
      ++bottom;
      return new Rectangle(left / resolution, top / resolution, (right - left) / resolution, (bottom - top) / resolution);
    }

    "use strict";
    const _FillGradient = class _FillGradient {
      constructor(x0, y0, x1, y1) {
        /** unique id for this fill gradient */
        this.uid = uid$1("fillGradient");
        this.type = "linear";
        this.gradientStops = [];
        this._styleKey = null;
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
      }
      addColorStop(offset, color) {
        this.gradientStops.push({ offset, color: Color.shared.setValue(color).toHexa() });
        this._styleKey = null;
        return this;
      }
      // TODO move to the system!
      buildLinearGradient() {
        if (this.texture)
          return;
        const defaultSize = _FillGradient.defaultTextureSize;
        const { gradientStops } = this;
        const canvas = DOMAdapter.get().createCanvas();
        canvas.width = defaultSize;
        canvas.height = defaultSize;
        const ctx = canvas.getContext("2d");
        const gradient = ctx.createLinearGradient(0, 0, _FillGradient.defaultTextureSize, 1);
        for (let i = 0; i < gradientStops.length; i++) {
          const stop = gradientStops[i];
          gradient.addColorStop(stop.offset, stop.color);
        }
        ctx.fillStyle = gradient;
        ctx.fillRect(0, 0, defaultSize, defaultSize);
        this.texture = new Texture({
          source: new ImageSource({
            resource: canvas,
            addressModeU: "clamp-to-edge",
            addressModeV: "repeat"
          })
        });
        const { x0, y0, x1, y1 } = this;
        const m = new Matrix();
        const dx = x1 - x0;
        const dy = y1 - y0;
        const dist = Math.sqrt(dx * dx + dy * dy);
        const angle = Math.atan2(dy, dx);
        m.translate(-x0, -y0);
        m.scale(1 / defaultSize, 1 / defaultSize);
        m.rotate(-angle);
        m.scale(256 / dist, 1);
        this.transform = m;
        this._styleKey = null;
      }
      get styleKey() {
        if (this._styleKey) {
          return this._styleKey;
        }
        const stops = this.gradientStops.map((stop) => `${stop.offset}-${stop.color}`).join("-");
        const texture = this.texture.uid;
        const transform = this.transform.toArray().join("-");
        return `fill-gradient-${this.uid}-${stops}-${texture}-${transform}-${this.x0}-${this.y0}-${this.x1}-${this.y1}`;
      }
    };
    _FillGradient.defaultTextureSize = 256;
    let FillGradient = _FillGradient;

    "use strict";
    const repetitionMap = {
      repeat: {
        addressModeU: "repeat",
        addressModeV: "repeat"
      },
      "repeat-x": {
        addressModeU: "repeat",
        addressModeV: "clamp-to-edge"
      },
      "repeat-y": {
        addressModeU: "clamp-to-edge",
        addressModeV: "repeat"
      },
      "no-repeat": {
        addressModeU: "clamp-to-edge",
        addressModeV: "clamp-to-edge"
      }
    };
    class FillPattern {
      constructor(texture, repetition) {
        /** unique id for this fill pattern */
        this.uid = uid$1("fillPattern");
        this.transform = new Matrix();
        this._styleKey = null;
        this.texture = texture;
        this.transform.scale(
          1 / texture.frame.width,
          1 / texture.frame.height
        );
        if (repetition) {
          texture.source.style.addressModeU = repetitionMap[repetition].addressModeU;
          texture.source.style.addressModeV = repetitionMap[repetition].addressModeV;
        }
      }
      setTransform(transform) {
        const texture = this.texture;
        this.transform.copyFrom(transform);
        this.transform.invert();
        this.transform.scale(
          1 / texture.frame.width,
          1 / texture.frame.height
        );
        this._styleKey = null;
      }
      get styleKey() {
        if (this._styleKey)
          return this._styleKey;
        this._styleKey = `fill-pattern-${this.uid}-${this.texture.uid}-${this.transform.toArray().join("-")}`;
        return this._styleKey;
      }
    }

    var parseSvgPath = parse;

    /**
     * expected argument lengths
     * @type {Object}
     */

    var length = {a: 7, c: 6, h: 1, l: 2, m: 2, q: 4, s: 4, t: 2, v: 1, z: 0};

    /**
     * segment pattern
     * @type {RegExp}
     */

    var segment = /([astvzqmhlc])([^astvzqmhlc]*)/ig;

    /**
     * parse an svg path data string. Generates an Array
     * of commands where each command is an Array of the
     * form `[command, arg1, arg2, ...]`
     *
     * @param {String} path
     * @return {Array}
     */

    function parse(path) {
    	var data = [];
    	path.replace(segment, function(_, command, args){
    		var type = command.toLowerCase();
    		args = parseValues(args);

    		// overloaded moveTo
    		if (type == 'm' && args.length > 2) {
    			data.push([command].concat(args.splice(0, 2)));
    			type = 'l';
    			command = command == 'm' ? 'l' : 'L';
    		}

    		while (true) {
    			if (args.length == length[type]) {
    				args.unshift(command);
    				return data.push(args)
    			}
    			if (args.length < length[type]) throw new Error('malformed path data')
    			data.push([command].concat(args.splice(0, length[type])));
    		}
    	});
    	return data
    }

    var number = /-?[0-9]*\.?[0-9]+(?:e[-+]?\d+)?/ig;

    function parseValues(args) {
    	var numbers = args.match(number);
    	return numbers ? numbers.map(Number) : []
    }

    var parse$1 = /*@__PURE__*/getDefaultExportFromCjs(parseSvgPath);

    "use strict";
    function SVGToGraphicsPath(svgPath, path) {
      const commands = parse$1(svgPath);
      const subpaths = [];
      let currentSubPath = null;
      let lastX = 0;
      let lastY = 0;
      for (let i = 0; i < commands.length; i++) {
        const command = commands[i];
        const type = command[0];
        const data = command;
        switch (type) {
          case "M":
            lastX = data[1];
            lastY = data[2];
            path.moveTo(lastX, lastY);
            break;
          case "m":
            lastX += data[1];
            lastY += data[2];
            path.moveTo(lastX, lastY);
            break;
          case "H":
            lastX = data[1];
            path.lineTo(lastX, lastY);
            break;
          case "h":
            lastX += data[1];
            path.lineTo(lastX, lastY);
            break;
          case "V":
            lastY = data[1];
            path.lineTo(lastX, lastY);
            break;
          case "v":
            lastY += data[1];
            path.lineTo(lastX, lastY);
            break;
          case "L":
            lastX = data[1];
            lastY = data[2];
            path.lineTo(lastX, lastY);
            break;
          case "l":
            lastX += data[1];
            lastY += data[2];
            path.lineTo(lastX, lastY);
            break;
          case "C":
            lastX = data[5];
            lastY = data[6];
            path.bezierCurveTo(
              data[1],
              data[2],
              data[3],
              data[4],
              lastX,
              lastY
            );
            break;
          case "c":
            path.bezierCurveTo(
              lastX + data[1],
              lastY + data[2],
              lastX + data[3],
              lastY + data[4],
              lastX + data[5],
              lastY + data[6]
            );
            lastX += data[5];
            lastY += data[6];
            break;
          case "S":
            lastX = data[3];
            lastY = data[4];
            path.bezierCurveToShort(
              data[1],
              data[2],
              lastX,
              lastY
            );
            break;
          case "s":
            path.bezierCurveToShort(
              lastX + data[1],
              lastY + data[2],
              lastX + data[3],
              lastY + data[4]
            );
            lastX += data[3];
            lastY += data[4];
            break;
          case "Q":
            lastX = data[3];
            lastY = data[4];
            path.quadraticCurveTo(
              data[1],
              data[2],
              lastX,
              lastY
            );
            break;
          case "q":
            path.quadraticCurveTo(
              lastX + data[1],
              lastY + data[2],
              lastX + data[3],
              lastY + data[4]
            );
            lastX += data[3];
            lastY += data[4];
            break;
          case "T":
            lastX = data[1];
            lastY = data[2];
            path.quadraticCurveToShort(
              lastX,
              lastY
            );
            break;
          case "t":
            lastX += data[1];
            lastY += data[2];
            path.quadraticCurveToShort(
              lastX,
              lastY
            );
            break;
          case "A":
            lastX = data[6];
            lastY = data[7];
            path.arcToSvg(
              data[1],
              data[2],
              data[3],
              data[4],
              data[5],
              lastX,
              lastY
            );
            break;
          case "a":
            lastX += data[6];
            lastY += data[7];
            path.arcToSvg(
              data[1],
              data[2],
              data[3],
              data[4],
              data[5],
              lastX,
              lastY
            );
            break;
          case "Z":
          case "z":
            path.closePath();
            if (subpaths.length > 0) {
              currentSubPath = subpaths.pop();
              if (currentSubPath) {
                lastX = currentSubPath.startX;
                lastY = currentSubPath.startY;
              } else {
                lastX = 0;
                lastY = 0;
              }
            }
            currentSubPath = null;
            break;
          default:
            warn(`Unknown SVG path command: ${type}`);
        }
        if (type !== "Z" && type !== "z") {
          if (currentSubPath === null) {
            currentSubPath = { startX: lastX, startY: lastY };
            subpaths.push(currentSubPath);
          }
        }
      }
      return path;
    }

    "use strict";
    class Circle {
      /**
       * @param x - The X coordinate of the center of this circle
       * @param y - The Y coordinate of the center of this circle
       * @param radius - The radius of the circle
       */
      constructor(x = 0, y = 0, radius = 0) {
        /**
         * The type of the object, mainly used to avoid `instanceof` checks
         * @default 'circle'
         */
        this.type = "circle";
        this.x = x;
        this.y = y;
        this.radius = radius;
      }
      /**
       * Creates a clone of this Circle instance
       * @returns A copy of the Circle
       */
      clone() {
        return new Circle(this.x, this.y, this.radius);
      }
      /**
       * Checks whether the x and y coordinates given are contained within this circle
       * @param x - The X coordinate of the point to test
       * @param y - The Y coordinate of the point to test
       * @returns Whether the x/y coordinates are within this Circle
       */
      contains(x, y) {
        if (this.radius <= 0)
          return false;
        const r2 = this.radius * this.radius;
        let dx = this.x - x;
        let dy = this.y - y;
        dx *= dx;
        dy *= dy;
        return dx + dy <= r2;
      }
      /**
       * Checks whether the x and y coordinates given are contained within this circle including the stroke.
       * @param x - The X coordinate of the point to test
       * @param y - The Y coordinate of the point to test
       * @param width - The width of the line to check
       * @returns Whether the x/y coordinates are within this Circle
       */
      strokeContains(x, y, width) {
        if (this.radius === 0)
          return false;
        const dx = this.x - x;
        const dy = this.y - y;
        const r = this.radius;
        const w2 = width / 2;
        const distance = Math.sqrt(dx * dx + dy * dy);
        return distance < r + w2 && distance > r - w2;
      }
      /**
       * Returns the framing rectangle of the circle as a Rectangle object
       * @param out
       * @returns The framing rectangle
       */
      getBounds(out) {
        out || (out = new Rectangle());
        out.x = this.x - this.radius;
        out.y = this.y - this.radius;
        out.width = this.radius * 2;
        out.height = this.radius * 2;
        return out;
      }
      /**
       * Copies another circle to this one.
       * @param circle - The circle to copy from.
       * @returns Returns itself.
       */
      copyFrom(circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.radius = circle.radius;
        return this;
      }
      /**
       * Copies this circle to another one.
       * @param circle - The circle to copy to.
       * @returns Returns given parameter.
       */
      copyTo(circle) {
        circle.copyFrom(this);
        return circle;
      }
      toString() {
        return `[pixi.js/math:Circle x=${this.x} y=${this.y} radius=${this.radius}]`;
      }
    }

    "use strict";
    class Ellipse {
      /**
       * @param x - The X coordinate of the center of this ellipse
       * @param y - The Y coordinate of the center of this ellipse
       * @param halfWidth - The half width of this ellipse
       * @param halfHeight - The half height of this ellipse
       */
      constructor(x = 0, y = 0, halfWidth = 0, halfHeight = 0) {
        /**
         * The type of the object, mainly used to avoid `instanceof` checks
         * @default 'ellipse'
         */
        this.type = "ellipse";
        this.x = x;
        this.y = y;
        this.halfWidth = halfWidth;
        this.halfHeight = halfHeight;
      }
      /**
       * Creates a clone of this Ellipse instance
       * @returns {Ellipse} A copy of the ellipse
       */
      clone() {
        return new Ellipse(this.x, this.y, this.halfWidth, this.halfHeight);
      }
      /**
       * Checks whether the x and y coordinates given are contained within this ellipse
       * @param x - The X coordinate of the point to test
       * @param y - The Y coordinate of the point to test
       * @returns Whether the x/y coords are within this ellipse
       */
      contains(x, y) {
        if (this.halfWidth <= 0 || this.halfHeight <= 0) {
          return false;
        }
        let normx = (x - this.x) / this.halfWidth;
        let normy = (y - this.y) / this.halfHeight;
        normx *= normx;
        normy *= normy;
        return normx + normy <= 1;
      }
      /**
       * Checks whether the x and y coordinates given are contained within this ellipse including stroke
       * @param x - The X coordinate of the point to test
       * @param y - The Y coordinate of the point to test
       * @param width
       * @returns Whether the x/y coords are within this ellipse
       */
      strokeContains(x, y, width) {
        const { halfWidth, halfHeight } = this;
        if (halfWidth <= 0 || halfHeight <= 0) {
          return false;
        }
        const halfStrokeWidth = width / 2;
        const innerA = halfWidth - halfStrokeWidth;
        const innerB = halfHeight - halfStrokeWidth;
        const outerA = halfWidth + halfStrokeWidth;
        const outerB = halfHeight + halfStrokeWidth;
        const normalizedX = x - this.x;
        const normalizedY = y - this.y;
        const innerEllipse = normalizedX * normalizedX / (innerA * innerA) + normalizedY * normalizedY / (innerB * innerB);
        const outerEllipse = normalizedX * normalizedX / (outerA * outerA) + normalizedY * normalizedY / (outerB * outerB);
        return innerEllipse > 1 && outerEllipse <= 1;
      }
      /**
       * Returns the framing rectangle of the ellipse as a Rectangle object
       * @param out
       * @returns The framing rectangle
       */
      getBounds(out) {
        out || (out = new Rectangle());
        out.x = this.x - this.halfWidth;
        out.y = this.y - this.halfHeight;
        out.width = this.halfWidth * 2;
        out.height = this.halfHeight * 2;
        return out;
      }
      /**
       * Copies another ellipse to this one.
       * @param ellipse - The ellipse to copy from.
       * @returns Returns itself.
       */
      copyFrom(ellipse) {
        this.x = ellipse.x;
        this.y = ellipse.y;
        this.halfWidth = ellipse.halfWidth;
        this.halfHeight = ellipse.halfHeight;
        return this;
      }
      /**
       * Copies this ellipse to another one.
       * @param ellipse - The ellipse to copy to.
       * @returns Returns given parameter.
       */
      copyTo(ellipse) {
        ellipse.copyFrom(this);
        return ellipse;
      }
      toString() {
        return `[pixi.js/math:Ellipse x=${this.x} y=${this.y} halfWidth=${this.halfWidth} halfHeight=${this.halfHeight}]`;
      }
    }

    "use strict";
    function squaredDistanceToLineSegment(x, y, x1, y1, x2, y2) {
      const a = x - x1;
      const b = y - y1;
      const c = x2 - x1;
      const d = y2 - y1;
      const dot = a * c + b * d;
      const lenSq = c * c + d * d;
      let param = -1;
      if (lenSq !== 0) {
        param = dot / lenSq;
      }
      let xx;
      let yy;
      if (param < 0) {
        xx = x1;
        yy = y1;
      } else if (param > 1) {
        xx = x2;
        yy = y2;
      } else {
        xx = x1 + param * c;
        yy = y1 + param * d;
      }
      const dx = x - xx;
      const dy = y - yy;
      return dx * dx + dy * dy;
    }

    "use strict";
    class Polygon {
      /**
       * @param points - This can be an array of Points
       *  that form the polygon, a flat array of numbers that will be interpreted as [x,y, x,y, ...], or
       *  the arguments passed can be all the points of the polygon e.g.
       *  `new Polygon(new Point(), new Point(), ...)`, or the arguments passed can be flat
       *  x,y values e.g. `new Polygon(x,y, x,y, x,y, ...)` where `x` and `y` are Numbers.
       */
      constructor(...points) {
        /**
         * The type of the object, mainly used to avoid `instanceof` checks
         * @default 'polygon'
         */
        this.type = "polygon";
        let flat = Array.isArray(points[0]) ? points[0] : points;
        if (typeof flat[0] !== "number") {
          const p = [];
          for (let i = 0, il = flat.length; i < il; i++) {
            p.push(flat[i].x, flat[i].y);
          }
          flat = p;
        }
        this.points = flat;
        this.closePath = true;
      }
      /**
       * Creates a clone of this polygon.
       * @returns - A copy of the polygon.
       */
      clone() {
        const points = this.points.slice();
        const polygon = new Polygon(points);
        polygon.closePath = this.closePath;
        return polygon;
      }
      /**
       * Checks whether the x and y coordinates passed to this function are contained within this polygon.
       * @param x - The X coordinate of the point to test.
       * @param y - The Y coordinate of the point to test.
       * @returns - Whether the x/y coordinates are within this polygon.
       */
      contains(x, y) {
        let inside = false;
        const length = this.points.length / 2;
        for (let i = 0, j = length - 1; i < length; j = i++) {
          const xi = this.points[i * 2];
          const yi = this.points[i * 2 + 1];
          const xj = this.points[j * 2];
          const yj = this.points[j * 2 + 1];
          const intersect = yi > y !== yj > y && x < (xj - xi) * ((y - yi) / (yj - yi)) + xi;
          if (intersect) {
            inside = !inside;
          }
        }
        return inside;
      }
      /**
       * Checks whether the x and y coordinates given are contained within this polygon including the stroke.
       * @param x - The X coordinate of the point to test
       * @param y - The Y coordinate of the point to test
       * @param strokeWidth - The width of the line to check
       * @returns Whether the x/y coordinates are within this polygon
       */
      strokeContains(x, y, strokeWidth) {
        const halfStrokeWidth = strokeWidth / 2;
        const halfStrokeWidthSqrd = halfStrokeWidth * halfStrokeWidth;
        const { points } = this;
        const iterationLength = points.length - (this.closePath ? 0 : 2);
        for (let i = 0; i < iterationLength; i += 2) {
          const x1 = points[i];
          const y1 = points[i + 1];
          const x2 = points[(i + 2) % points.length];
          const y2 = points[(i + 3) % points.length];
          const distanceSqrd = squaredDistanceToLineSegment(x, y, x1, y1, x2, y2);
          if (distanceSqrd <= halfStrokeWidthSqrd) {
            return true;
          }
        }
        return false;
      }
      /**
       * Returns the framing rectangle of the polygon as a Rectangle object
       * @param out - optional rectangle to store the result
       * @returns The framing rectangle
       */
      getBounds(out) {
        out || (out = new Rectangle());
        const points = this.points;
        let minX = Infinity;
        let maxX = -Infinity;
        let minY = Infinity;
        let maxY = -Infinity;
        for (let i = 0, n = points.length; i < n; i += 2) {
          const x = points[i];
          const y = points[i + 1];
          minX = x < minX ? x : minX;
          maxX = x > maxX ? x : maxX;
          minY = y < minY ? y : minY;
          maxY = y > maxY ? y : maxY;
        }
        out.x = minX;
        out.width = maxX - minX;
        out.y = minY;
        out.height = maxY - minY;
        return out;
      }
      /**
       * Copies another polygon to this one.
       * @param polygon - The polygon to copy from.
       * @returns Returns itself.
       */
      copyFrom(polygon) {
        this.points = polygon.points.slice();
        this.closePath = polygon.closePath;
        return this;
      }
      /**
       * Copies this polygon to another one.
       * @param polygon - The polygon to copy to.
       * @returns Returns given parameter.
       */
      copyTo(polygon) {
        polygon.copyFrom(this);
        return polygon;
      }
      toString() {
        return `[pixi.js/math:PolygoncloseStroke=${this.closePath}points=${this.points.reduce((pointsDesc, currentPoint) => `${pointsDesc}, ${currentPoint}`, "")}]`;
      }
      /**
       * Get the last X coordinate of the polygon
       * @readonly
       */
      get lastX() {
        return this.points[this.points.length - 2];
      }
      /**
       * Get the last Y coordinate of the polygon
       * @readonly
       */
      get lastY() {
        return this.points[this.points.length - 1];
      }
      /**
       * Get the first X coordinate of the polygon
       * @readonly
       */
      get x() {
        return this.points[this.points.length - 2];
      }
      /**
       * Get the first Y coordinate of the polygon
       * @readonly
       */
      get y() {
        return this.points[this.points.length - 1];
      }
    }

    "use strict";
    const isCornerWithinStroke = (pX, pY, cornerX, cornerY, radius, halfStrokeWidth) => {
      const dx = pX - cornerX;
      const dy = pY - cornerY;
      const distance = Math.sqrt(dx * dx + dy * dy);
      return distance >= radius - halfStrokeWidth && distance <= radius + halfStrokeWidth;
    };
    class RoundedRectangle {
      /**
       * @param x - The X coordinate of the upper-left corner of the rounded rectangle
       * @param y - The Y coordinate of the upper-left corner of the rounded rectangle
       * @param width - The overall width of this rounded rectangle
       * @param height - The overall height of this rounded rectangle
       * @param radius - Controls the radius of the rounded corners
       */
      constructor(x = 0, y = 0, width = 0, height = 0, radius = 20) {
        /**
         * The type of the object, mainly used to avoid `instanceof` checks
         * @default 'roundedRectangle'
         */
        this.type = "roundedRectangle";
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.radius = radius;
      }
      /**
       * Returns the framing rectangle of the rounded rectangle as a Rectangle object
       * @param out - optional rectangle to store the result
       * @returns The framing rectangle
       */
      getBounds(out) {
        out || (out = new Rectangle());
        out.x = this.x;
        out.y = this.y;
        out.width = this.width;
        out.height = this.height;
        return out;
      }
      /**
       * Creates a clone of this Rounded Rectangle.
       * @returns - A copy of the rounded rectangle.
       */
      clone() {
        return new RoundedRectangle(this.x, this.y, this.width, this.height, this.radius);
      }
      /**
       * Copies another rectangle to this one.
       * @param rectangle - The rectangle to copy from.
       * @returns Returns itself.
       */
      copyFrom(rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        return this;
      }
      /**
       * Copies this rectangle to another one.
       * @param rectangle - The rectangle to copy to.
       * @returns Returns given parameter.
       */
      copyTo(rectangle) {
        rectangle.copyFrom(this);
        return rectangle;
      }
      /**
       * Checks whether the x and y coordinates given are contained within this Rounded Rectangle
       * @param x - The X coordinate of the point to test.
       * @param y - The Y coordinate of the point to test.
       * @returns - Whether the x/y coordinates are within this Rounded Rectangle.
       */
      contains(x, y) {
        if (this.width <= 0 || this.height <= 0) {
          return false;
        }
        if (x >= this.x && x <= this.x + this.width) {
          if (y >= this.y && y <= this.y + this.height) {
            const radius = Math.max(0, Math.min(this.radius, Math.min(this.width, this.height) / 2));
            if (y >= this.y + radius && y <= this.y + this.height - radius || x >= this.x + radius && x <= this.x + this.width - radius) {
              return true;
            }
            let dx = x - (this.x + radius);
            let dy = y - (this.y + radius);
            const radius2 = radius * radius;
            if (dx * dx + dy * dy <= radius2) {
              return true;
            }
            dx = x - (this.x + this.width - radius);
            if (dx * dx + dy * dy <= radius2) {
              return true;
            }
            dy = y - (this.y + this.height - radius);
            if (dx * dx + dy * dy <= radius2) {
              return true;
            }
            dx = x - (this.x + radius);
            if (dx * dx + dy * dy <= radius2) {
              return true;
            }
          }
        }
        return false;
      }
      /**
       * Checks whether the x and y coordinates given are contained within this rectangle including the stroke.
       * @param pX - The X coordinate of the point to test
       * @param pY - The Y coordinate of the point to test
       * @param strokeWidth - The width of the line to check
       * @returns Whether the x/y coordinates are within this rectangle
       */
      strokeContains(pX, pY, strokeWidth) {
        const { x, y, width, height, radius } = this;
        const halfStrokeWidth = strokeWidth / 2;
        const innerX = x + radius;
        const innerY = y + radius;
        const innerWidth = width - radius * 2;
        const innerHeight = height - radius * 2;
        const rightBound = x + width;
        const bottomBound = y + height;
        if ((pX >= x - halfStrokeWidth && pX <= x + halfStrokeWidth || pX >= rightBound - halfStrokeWidth && pX <= rightBound + halfStrokeWidth) && pY >= innerY && pY <= innerY + innerHeight) {
          return true;
        }
        if ((pY >= y - halfStrokeWidth && pY <= y + halfStrokeWidth || pY >= bottomBound - halfStrokeWidth && pY <= bottomBound + halfStrokeWidth) && pX >= innerX && pX <= innerX + innerWidth) {
          return true;
        }
        return (
          // Top-left
          pX < innerX && pY < innerY && isCornerWithinStroke(pX, pY, innerX, innerY, radius, halfStrokeWidth) || pX > rightBound - radius && pY < innerY && isCornerWithinStroke(pX, pY, rightBound - radius, innerY, radius, halfStrokeWidth) || pX > rightBound - radius && pY > bottomBound - radius && isCornerWithinStroke(pX, pY, rightBound - radius, bottomBound - radius, radius, halfStrokeWidth) || pX < innerX && pY > bottomBound - radius && isCornerWithinStroke(pX, pY, innerX, bottomBound - radius, radius, halfStrokeWidth)
        );
      }
      toString() {
        return `[pixi.js/math:RoundedRectangle x=${this.x} y=${this.y}width=${this.width} height=${this.height} radius=${this.radius}]`;
      }
    }

    "use strict";
    const RECURSION_LIMIT$1 = 8;
    const FLT_EPSILON$1 = 11920929e-14;
    const PATH_DISTANCE_EPSILON$1 = 1;
    const curveAngleToleranceEpsilon$1 = 0.01;
    const mAngleTolerance$1 = 0;
    const mCuspLimit = 0;
    function buildAdaptiveBezier(points, sX, sY, cp1x, cp1y, cp2x, cp2y, eX, eY, smoothness) {
      const scale = 1;
      const smoothing = Math.min(
        0.99,
        // a value of 1.0 actually inverts smoothing, so we cap it at 0.99
        Math.max(0, smoothness != null ? smoothness : GraphicsContextSystem.defaultOptions.bezierSmoothness)
      );
      let distanceTolerance = (PATH_DISTANCE_EPSILON$1 - smoothing) / scale;
      distanceTolerance *= distanceTolerance;
      begin$1(sX, sY, cp1x, cp1y, cp2x, cp2y, eX, eY, points, distanceTolerance);
      return points;
    }
    function begin$1(sX, sY, cp1x, cp1y, cp2x, cp2y, eX, eY, points, distanceTolerance) {
      recursive$1(sX, sY, cp1x, cp1y, cp2x, cp2y, eX, eY, points, distanceTolerance, 0);
      points.push(eX, eY);
    }
    function recursive$1(x1, y1, x2, y2, x3, y3, x4, y4, points, distanceTolerance, level) {
      if (level > RECURSION_LIMIT$1) {
        return;
      }
      const pi = Math.PI;
      const x12 = (x1 + x2) / 2;
      const y12 = (y1 + y2) / 2;
      const x23 = (x2 + x3) / 2;
      const y23 = (y2 + y3) / 2;
      const x34 = (x3 + x4) / 2;
      const y34 = (y3 + y4) / 2;
      const x123 = (x12 + x23) / 2;
      const y123 = (y12 + y23) / 2;
      const x234 = (x23 + x34) / 2;
      const y234 = (y23 + y34) / 2;
      const x1234 = (x123 + x234) / 2;
      const y1234 = (y123 + y234) / 2;
      if (level > 0) {
        let dx = x4 - x1;
        let dy = y4 - y1;
        const d2 = Math.abs((x2 - x4) * dy - (y2 - y4) * dx);
        const d3 = Math.abs((x3 - x4) * dy - (y3 - y4) * dx);
        let da1;
        let da2;
        if (d2 > FLT_EPSILON$1 && d3 > FLT_EPSILON$1) {
          if ((d2 + d3) * (d2 + d3) <= distanceTolerance * (dx * dx + dy * dy)) {
            if (mAngleTolerance$1 < curveAngleToleranceEpsilon$1) {
              points.push(x1234, y1234);
              return;
            }
            const a23 = Math.atan2(y3 - y2, x3 - x2);
            da1 = Math.abs(a23 - Math.atan2(y2 - y1, x2 - x1));
            da2 = Math.abs(Math.atan2(y4 - y3, x4 - x3) - a23);
            if (da1 >= pi)
              da1 = 2 * pi - da1;
            if (da2 >= pi)
              da2 = 2 * pi - da2;
            if (da1 + da2 < mAngleTolerance$1) {
              points.push(x1234, y1234);
              return;
            }
            if (mCuspLimit !== 0) {
              if (da1 > mCuspLimit) {
                points.push(x2, y2);
                return;
              }
              if (da2 > mCuspLimit) {
                points.push(x3, y3);
                return;
              }
            }
          }
        } else if (d2 > FLT_EPSILON$1) {
          if (d2 * d2 <= distanceTolerance * (dx * dx + dy * dy)) {
            if (mAngleTolerance$1 < curveAngleToleranceEpsilon$1) {
              points.push(x1234, y1234);
              return;
            }
            da1 = Math.abs(Math.atan2(y3 - y2, x3 - x2) - Math.atan2(y2 - y1, x2 - x1));
            if (da1 >= pi)
              da1 = 2 * pi - da1;
            if (da1 < mAngleTolerance$1) {
              points.push(x2, y2);
              points.push(x3, y3);
              return;
            }
            if (mCuspLimit !== 0) {
              if (da1 > mCuspLimit) {
                points.push(x2, y2);
                return;
              }
            }
          }
        } else if (d3 > FLT_EPSILON$1) {
          if (d3 * d3 <= distanceTolerance * (dx * dx + dy * dy)) {
            if (mAngleTolerance$1 < curveAngleToleranceEpsilon$1) {
              points.push(x1234, y1234);
              return;
            }
            da1 = Math.abs(Math.atan2(y4 - y3, x4 - x3) - Math.atan2(y3 - y2, x3 - x2));
            if (da1 >= pi)
              da1 = 2 * pi - da1;
            if (da1 < mAngleTolerance$1) {
              points.push(x2, y2);
              points.push(x3, y3);
              return;
            }
            if (mCuspLimit !== 0) {
              if (da1 > mCuspLimit) {
                points.push(x3, y3);
                return;
              }
            }
          }
        } else {
          dx = x1234 - (x1 + x4) / 2;
          dy = y1234 - (y1 + y4) / 2;
          if (dx * dx + dy * dy <= distanceTolerance) {
            points.push(x1234, y1234);
            return;
          }
        }
      }
      recursive$1(x1, y1, x12, y12, x123, y123, x1234, y1234, points, distanceTolerance, level + 1);
      recursive$1(x1234, y1234, x234, y234, x34, y34, x4, y4, points, distanceTolerance, level + 1);
    }

    "use strict";
    const RECURSION_LIMIT = 8;
    const FLT_EPSILON = 11920929e-14;
    const PATH_DISTANCE_EPSILON = 1;
    const curveAngleToleranceEpsilon = 0.01;
    const mAngleTolerance = 0;
    function buildAdaptiveQuadratic(points, sX, sY, cp1x, cp1y, eX, eY, smoothness) {
      const scale = 1;
      const smoothing = Math.min(
        0.99,
        // a value of 1.0 actually inverts smoothing, so we cap it at 0.99
        Math.max(0, smoothness != null ? smoothness : GraphicsContextSystem.defaultOptions.bezierSmoothness)
      );
      let distanceTolerance = (PATH_DISTANCE_EPSILON - smoothing) / scale;
      distanceTolerance *= distanceTolerance;
      begin(sX, sY, cp1x, cp1y, eX, eY, points, distanceTolerance);
      return points;
    }
    function begin(sX, sY, cp1x, cp1y, eX, eY, points, distanceTolerance) {
      recursive(points, sX, sY, cp1x, cp1y, eX, eY, distanceTolerance, 0);
      points.push(eX, eY);
    }
    function recursive(points, x1, y1, x2, y2, x3, y3, distanceTolerance, level) {
      if (level > RECURSION_LIMIT) {
        return;
      }
      const pi = Math.PI;
      const x12 = (x1 + x2) / 2;
      const y12 = (y1 + y2) / 2;
      const x23 = (x2 + x3) / 2;
      const y23 = (y2 + y3) / 2;
      const x123 = (x12 + x23) / 2;
      const y123 = (y12 + y23) / 2;
      let dx = x3 - x1;
      let dy = y3 - y1;
      const d = Math.abs((x2 - x3) * dy - (y2 - y3) * dx);
      if (d > FLT_EPSILON) {
        if (d * d <= distanceTolerance * (dx * dx + dy * dy)) {
          if (mAngleTolerance < curveAngleToleranceEpsilon) {
            points.push(x123, y123);
            return;
          }
          let da = Math.abs(Math.atan2(y3 - y2, x3 - x2) - Math.atan2(y2 - y1, x2 - x1));
          if (da >= pi)
            da = 2 * pi - da;
          if (da < mAngleTolerance) {
            points.push(x123, y123);
            return;
          }
        }
      } else {
        dx = x123 - (x1 + x3) / 2;
        dy = y123 - (y1 + y3) / 2;
        if (dx * dx + dy * dy <= distanceTolerance) {
          points.push(x123, y123);
          return;
        }
      }
      recursive(points, x1, y1, x12, y12, x123, y123, distanceTolerance, level + 1);
      recursive(points, x123, y123, x23, y23, x3, y3, distanceTolerance, level + 1);
    }

    "use strict";
    function buildArc(points, x, y, radius, start, end, clockwise, steps) {
      let dist = Math.abs(start - end);
      if (!clockwise && start > end) {
        dist = 2 * Math.PI - dist;
      } else if (clockwise && end > start) {
        dist = 2 * Math.PI - dist;
      }
      steps || (steps = Math.max(6, Math.floor(6 * Math.pow(radius, 1 / 3) * (dist / Math.PI))));
      steps = Math.max(steps, 3);
      let f = dist / steps;
      let t = start;
      f *= clockwise ? -1 : 1;
      for (let i = 0; i < steps + 1; i++) {
        const cs = Math.cos(t);
        const sn = Math.sin(t);
        const nx = x + cs * radius;
        const ny = y + sn * radius;
        points.push(nx, ny);
        t += f;
      }
    }

    "use strict";
    function buildArcTo(points, x1, y1, x2, y2, radius) {
      const fromX = points[points.length - 2];
      const fromY = points[points.length - 1];
      const a1 = fromY - y1;
      const b1 = fromX - x1;
      const a2 = y2 - y1;
      const b2 = x2 - x1;
      const mm = Math.abs(a1 * b2 - b1 * a2);
      if (mm < 1e-8 || radius === 0) {
        if (points[points.length - 2] !== x1 || points[points.length - 1] !== y1) {
          points.push(x1, y1);
        }
        return;
      }
      const dd = a1 * a1 + b1 * b1;
      const cc = a2 * a2 + b2 * b2;
      const tt = a1 * a2 + b1 * b2;
      const k1 = radius * Math.sqrt(dd) / mm;
      const k2 = radius * Math.sqrt(cc) / mm;
      const j1 = k1 * tt / dd;
      const j2 = k2 * tt / cc;
      const cx = k1 * b2 + k2 * b1;
      const cy = k1 * a2 + k2 * a1;
      const px = b1 * (k2 + j1);
      const py = a1 * (k2 + j1);
      const qx = b2 * (k1 + j2);
      const qy = a2 * (k1 + j2);
      const startAngle = Math.atan2(py - cy, px - cx);
      const endAngle = Math.atan2(qy - cy, qx - cx);
      buildArc(
        points,
        cx + x1,
        cy + y1,
        radius,
        startAngle,
        endAngle,
        b1 * a2 > b2 * a1
      );
    }

    "use strict";
    const TAU = Math.PI * 2;
    const out = {
      centerX: 0,
      centerY: 0,
      ang1: 0,
      ang2: 0
    };
    const mapToEllipse = ({ x, y }, rx, ry, cosPhi, sinPhi, centerX, centerY, out2) => {
      x *= rx;
      y *= ry;
      const xp = cosPhi * x - sinPhi * y;
      const yp = sinPhi * x + cosPhi * y;
      out2.x = xp + centerX;
      out2.y = yp + centerY;
      return out2;
    };
    function approxUnitArc(ang1, ang2) {
      const a1 = ang2 === -1.5707963267948966 ? -0.551915024494 : 4 / 3 * Math.tan(ang2 / 4);
      const a = ang2 === 1.5707963267948966 ? 0.551915024494 : a1;
      const x1 = Math.cos(ang1);
      const y1 = Math.sin(ang1);
      const x2 = Math.cos(ang1 + ang2);
      const y2 = Math.sin(ang1 + ang2);
      return [
        {
          x: x1 - y1 * a,
          y: y1 + x1 * a
        },
        {
          x: x2 + y2 * a,
          y: y2 - x2 * a
        },
        {
          x: x2,
          y: y2
        }
      ];
    }
    const vectorAngle = (ux, uy, vx, vy) => {
      const sign = ux * vy - uy * vx < 0 ? -1 : 1;
      let dot = ux * vx + uy * vy;
      if (dot > 1) {
        dot = 1;
      }
      if (dot < -1) {
        dot = -1;
      }
      return sign * Math.acos(dot);
    };
    const getArcCenter = (px, py, cx, cy, rx, ry, largeArcFlag, sweepFlag, sinPhi, cosPhi, pxp, pyp, out2) => {
      const rxSq = Math.pow(rx, 2);
      const rySq = Math.pow(ry, 2);
      const pxpSq = Math.pow(pxp, 2);
      const pypSq = Math.pow(pyp, 2);
      let radicant = rxSq * rySq - rxSq * pypSq - rySq * pxpSq;
      if (radicant < 0) {
        radicant = 0;
      }
      radicant /= rxSq * pypSq + rySq * pxpSq;
      radicant = Math.sqrt(radicant) * (largeArcFlag === sweepFlag ? -1 : 1);
      const centerXp = radicant * rx / ry * pyp;
      const centerYp = radicant * -ry / rx * pxp;
      const centerX = cosPhi * centerXp - sinPhi * centerYp + (px + cx) / 2;
      const centerY = sinPhi * centerXp + cosPhi * centerYp + (py + cy) / 2;
      const vx1 = (pxp - centerXp) / rx;
      const vy1 = (pyp - centerYp) / ry;
      const vx2 = (-pxp - centerXp) / rx;
      const vy2 = (-pyp - centerYp) / ry;
      const ang1 = vectorAngle(1, 0, vx1, vy1);
      let ang2 = vectorAngle(vx1, vy1, vx2, vy2);
      if (sweepFlag === 0 && ang2 > 0) {
        ang2 -= TAU;
      }
      if (sweepFlag === 1 && ang2 < 0) {
        ang2 += TAU;
      }
      out2.centerX = centerX;
      out2.centerY = centerY;
      out2.ang1 = ang1;
      out2.ang2 = ang2;
    };
    function buildArcToSvg(points, px, py, cx, cy, rx, ry, xAxisRotation = 0, largeArcFlag = 0, sweepFlag = 0) {
      if (rx === 0 || ry === 0) {
        return;
      }
      const sinPhi = Math.sin(xAxisRotation * TAU / 360);
      const cosPhi = Math.cos(xAxisRotation * TAU / 360);
      const pxp = cosPhi * (px - cx) / 2 + sinPhi * (py - cy) / 2;
      const pyp = -sinPhi * (px - cx) / 2 + cosPhi * (py - cy) / 2;
      if (pxp === 0 && pyp === 0) {
        return;
      }
      rx = Math.abs(rx);
      ry = Math.abs(ry);
      const lambda = Math.pow(pxp, 2) / Math.pow(rx, 2) + Math.pow(pyp, 2) / Math.pow(ry, 2);
      if (lambda > 1) {
        rx *= Math.sqrt(lambda);
        ry *= Math.sqrt(lambda);
      }
      getArcCenter(
        px,
        py,
        cx,
        cy,
        rx,
        ry,
        largeArcFlag,
        sweepFlag,
        sinPhi,
        cosPhi,
        pxp,
        pyp,
        out
      );
      let { ang1, ang2 } = out;
      const { centerX, centerY } = out;
      let ratio = Math.abs(ang2) / (TAU / 4);
      if (Math.abs(1 - ratio) < 1e-7) {
        ratio = 1;
      }
      const segments = Math.max(Math.ceil(ratio), 1);
      ang2 /= segments;
      let lastX = points[points.length - 2];
      let lastY = points[points.length - 1];
      const outCurvePoint = { x: 0, y: 0 };
      for (let i = 0; i < segments; i++) {
        const curve = approxUnitArc(ang1, ang2);
        const { x: x1, y: y1 } = mapToEllipse(curve[0], rx, ry, cosPhi, sinPhi, centerX, centerY, outCurvePoint);
        const { x: x2, y: y2 } = mapToEllipse(curve[1], rx, ry, cosPhi, sinPhi, centerX, centerY, outCurvePoint);
        const { x, y } = mapToEllipse(curve[2], rx, ry, cosPhi, sinPhi, centerX, centerY, outCurvePoint);
        buildAdaptiveBezier(
          points,
          lastX,
          lastY,
          x1,
          y1,
          x2,
          y2,
          x,
          y
        );
        lastX = x;
        lastY = y;
        ang1 += ang2;
      }
    }

    "use strict";
    function roundedShapeArc(g, points, radius) {
      var _a;
      const vecFrom = (p, pp) => {
        const x = pp.x - p.x;
        const y = pp.y - p.y;
        const len = Math.sqrt(x * x + y * y);
        const nx = x / len;
        const ny = y / len;
        return { len, nx, ny };
      };
      const sharpCorner = (i, p) => {
        if (i === 0) {
          g.moveTo(p.x, p.y);
        } else {
          g.lineTo(p.x, p.y);
        }
      };
      let p1 = points[points.length - 1];
      for (let i = 0; i < points.length; i++) {
        const p2 = points[i % points.length];
        const pRadius = (_a = p2.radius) != null ? _a : radius;
        if (pRadius <= 0) {
          sharpCorner(i, p2);
          p1 = p2;
          continue;
        }
        const p3 = points[(i + 1) % points.length];
        const v1 = vecFrom(p2, p1);
        const v2 = vecFrom(p2, p3);
        if (v1.len < 1e-4 || v2.len < 1e-4) {
          sharpCorner(i, p2);
          p1 = p2;
          continue;
        }
        let angle = Math.asin(v1.nx * v2.ny - v1.ny * v2.nx);
        let radDirection = 1;
        let drawDirection = false;
        if (v1.nx * v2.nx - v1.ny * -v2.ny < 0) {
          if (angle < 0) {
            angle = Math.PI + angle;
          } else {
            angle = Math.PI - angle;
            radDirection = -1;
            drawDirection = true;
          }
        } else if (angle > 0) {
          radDirection = -1;
          drawDirection = true;
        }
        const halfAngle = angle / 2;
        let cRadius;
        let lenOut = Math.abs(
          Math.cos(halfAngle) * pRadius / Math.sin(halfAngle)
        );
        if (lenOut > Math.min(v1.len / 2, v2.len / 2)) {
          lenOut = Math.min(v1.len / 2, v2.len / 2);
          cRadius = Math.abs(lenOut * Math.sin(halfAngle) / Math.cos(halfAngle));
        } else {
          cRadius = pRadius;
        }
        const cX = p2.x + v2.nx * lenOut + -v2.ny * cRadius * radDirection;
        const cY = p2.y + v2.ny * lenOut + v2.nx * cRadius * radDirection;
        const startAngle = Math.atan2(v1.ny, v1.nx) + Math.PI / 2 * radDirection;
        const endAngle = Math.atan2(v2.ny, v2.nx) - Math.PI / 2 * radDirection;
        if (i === 0) {
          g.moveTo(
            cX + Math.cos(startAngle) * cRadius,
            cY + Math.sin(startAngle) * cRadius
          );
        }
        g.arc(cX, cY, cRadius, startAngle, endAngle, drawDirection);
        p1 = p2;
      }
    }
    function roundedShapeQuadraticCurve(g, points, radius, smoothness) {
      var _a;
      const distance = (p1, p2) => Math.sqrt((p1.x - p2.x) ** 2 + (p1.y - p2.y) ** 2);
      const pointLerp = (p1, p2, t) => ({
        x: p1.x + (p2.x - p1.x) * t,
        y: p1.y + (p2.y - p1.y) * t
      });
      const numPoints = points.length;
      for (let i = 0; i < numPoints; i++) {
        const thisPoint = points[(i + 1) % numPoints];
        const pRadius = (_a = thisPoint.radius) != null ? _a : radius;
        if (pRadius <= 0) {
          if (i === 0) {
            g.moveTo(thisPoint.x, thisPoint.y);
          } else {
            g.lineTo(thisPoint.x, thisPoint.y);
          }
          continue;
        }
        const lastPoint = points[i];
        const nextPoint = points[(i + 2) % numPoints];
        const lastEdgeLength = distance(lastPoint, thisPoint);
        let start;
        if (lastEdgeLength < 1e-4) {
          start = thisPoint;
        } else {
          const lastOffsetDistance = Math.min(lastEdgeLength / 2, pRadius);
          start = pointLerp(
            thisPoint,
            lastPoint,
            lastOffsetDistance / lastEdgeLength
          );
        }
        const nextEdgeLength = distance(nextPoint, thisPoint);
        let end;
        if (nextEdgeLength < 1e-4) {
          end = thisPoint;
        } else {
          const nextOffsetDistance = Math.min(nextEdgeLength / 2, pRadius);
          end = pointLerp(
            thisPoint,
            nextPoint,
            nextOffsetDistance / nextEdgeLength
          );
        }
        if (i === 0) {
          g.moveTo(start.x, start.y);
        } else {
          g.lineTo(start.x, start.y);
        }
        g.quadraticCurveTo(thisPoint.x, thisPoint.y, end.x, end.y, smoothness);
      }
    }

    "use strict";
    const tempRectangle = new Rectangle();
    class ShapePath {
      constructor(graphicsPath2D) {
        /** The list of shape primitives that make up the path. */
        this.shapePrimitives = [];
        this._currentPoly = null;
        this._bounds = new Bounds();
        this._graphicsPath2D = graphicsPath2D;
      }
      /**
       * Sets the starting point for a new sub-path. Any subsequent drawing commands are considered part of this path.
       * @param x - The x-coordinate for the starting point.
       * @param y - The y-coordinate for the starting point.
       * @returns The instance of the current object for chaining.
       */
      moveTo(x, y) {
        this.startPoly(x, y);
        return this;
      }
      /**
       * Connects the current point to a new point with a straight line. This method updates the current path.
       * @param x - The x-coordinate of the new point to connect to.
       * @param y - The y-coordinate of the new point to connect to.
       * @returns The instance of the current object for chaining.
       */
      lineTo(x, y) {
        this._ensurePoly();
        const points = this._currentPoly.points;
        const fromX = points[points.length - 2];
        const fromY = points[points.length - 1];
        if (fromX !== x || fromY !== y) {
          points.push(x, y);
        }
        return this;
      }
      /**
       * Adds an arc to the path. The arc is centered at (x, y)
       *  position with radius `radius` starting at `startAngle` and ending at `endAngle`.
       * @param x - The x-coordinate of the arc's center.
       * @param y - The y-coordinate of the arc's center.
       * @param radius - The radius of the arc.
       * @param startAngle - The starting angle of the arc, in radians.
       * @param endAngle - The ending angle of the arc, in radians.
       * @param counterclockwise - Specifies whether the arc should be drawn in the anticlockwise direction. False by default.
       * @returns The instance of the current object for chaining.
       */
      arc(x, y, radius, startAngle, endAngle, counterclockwise) {
        this._ensurePoly(false);
        const points = this._currentPoly.points;
        buildArc(points, x, y, radius, startAngle, endAngle, counterclockwise);
        return this;
      }
      /**
       * Adds an arc to the path with the arc tangent to the line joining two specified points.
       * The arc radius is specified by `radius`.
       * @param x1 - The x-coordinate of the first point.
       * @param y1 - The y-coordinate of the first point.
       * @param x2 - The x-coordinate of the second point.
       * @param y2 - The y-coordinate of the second point.
       * @param radius - The radius of the arc.
       * @returns The instance of the current object for chaining.
       */
      arcTo(x1, y1, x2, y2, radius) {
        this._ensurePoly();
        const points = this._currentPoly.points;
        buildArcTo(points, x1, y1, x2, y2, radius);
        return this;
      }
      /**
       * Adds an SVG-style arc to the path, allowing for elliptical arcs based on the SVG spec.
       * @param rx - The x-radius of the ellipse.
       * @param ry - The y-radius of the ellipse.
       * @param xAxisRotation - The rotation of the ellipse's x-axis relative
       * to the x-axis of the coordinate system, in degrees.
       * @param largeArcFlag - Determines if the arc should be greater than or less than 180 degrees.
       * @param sweepFlag - Determines if the arc should be swept in a positive angle direction.
       * @param x - The x-coordinate of the arc's end point.
       * @param y - The y-coordinate of the arc's end point.
       * @returns The instance of the current object for chaining.
       */
      arcToSvg(rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y) {
        const points = this._currentPoly.points;
        buildArcToSvg(
          points,
          this._currentPoly.lastX,
          this._currentPoly.lastY,
          x,
          y,
          rx,
          ry,
          xAxisRotation,
          largeArcFlag,
          sweepFlag
        );
        return this;
      }
      /**
       * Adds a cubic Bezier curve to the path.
       * It requires three points: the first two are control points and the third one is the end point.
       * The starting point is the last point in the current path.
       * @param cp1x - The x-coordinate of the first control point.
       * @param cp1y - The y-coordinate of the first control point.
       * @param cp2x - The x-coordinate of the second control point.
       * @param cp2y - The y-coordinate of the second control point.
       * @param x - The x-coordinate of the end point.
       * @param y - The y-coordinate of the end point.
       * @param smoothness - Optional parameter to adjust the smoothness of the curve.
       * @returns The instance of the current object for chaining.
       */
      bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y, smoothness) {
        this._ensurePoly();
        const currentPoly = this._currentPoly;
        buildAdaptiveBezier(
          this._currentPoly.points,
          currentPoly.lastX,
          currentPoly.lastY,
          cp1x,
          cp1y,
          cp2x,
          cp2y,
          x,
          y,
          smoothness
        );
        return this;
      }
      /**
       * Adds a quadratic curve to the path. It requires two points: the control point and the end point.
       * The starting point is the last point in the current path.
       * @param cp1x - The x-coordinate of the control point.
       * @param cp1y - The y-coordinate of the control point.
       * @param x - The x-coordinate of the end point.
       * @param y - The y-coordinate of the end point.
       * @param smoothing - Optional parameter to adjust the smoothness of the curve.
       * @returns The instance of the current object for chaining.
       */
      quadraticCurveTo(cp1x, cp1y, x, y, smoothing) {
        this._ensurePoly();
        const currentPoly = this._currentPoly;
        buildAdaptiveQuadratic(
          this._currentPoly.points,
          currentPoly.lastX,
          currentPoly.lastY,
          cp1x,
          cp1y,
          x,
          y,
          smoothing
        );
        return this;
      }
      /**
       * Closes the current path by drawing a straight line back to the start.
       * If the shape is already closed or there are no points in the path, this method does nothing.
       * @returns The instance of the current object for chaining.
       */
      closePath() {
        this.endPoly(true);
        return this;
      }
      /**
       * Adds another path to the current path. This method allows for the combination of multiple paths into one.
       * @param path - The `GraphicsPath` object representing the path to add.
       * @param transform - An optional `Matrix` object to apply a transformation to the path before adding it.
       * @returns The instance of the current object for chaining.
       */
      addPath(path, transform) {
        this.endPoly();
        if (transform && !transform.isIdentity()) {
          path = path.clone(true);
          path.transform(transform);
        }
        for (let i = 0; i < path.instructions.length; i++) {
          const instruction = path.instructions[i];
          this[instruction.action](...instruction.data);
        }
        return this;
      }
      /**
       * Finalizes the drawing of the current path. Optionally, it can close the path.
       * @param closePath - A boolean indicating whether to close the path after finishing. False by default.
       */
      finish(closePath = false) {
        this.endPoly(closePath);
      }
      /**
       * Draws a rectangle shape. This method adds a new rectangle path to the current drawing.
       * @param x - The x-coordinate of the top-left corner of the rectangle.
       * @param y - The y-coordinate of the top-left corner of the rectangle.
       * @param w - The width of the rectangle.
       * @param h - The height of the rectangle.
       * @param transform - An optional `Matrix` object to apply a transformation to the rectangle.
       * @returns The instance of the current object for chaining.
       */
      rect(x, y, w, h, transform) {
        this.drawShape(new Rectangle(x, y, w, h), transform);
        return this;
      }
      /**
       * Draws a circle shape. This method adds a new circle path to the current drawing.
       * @param x - The x-coordinate of the center of the circle.
       * @param y - The y-coordinate of the center of the circle.
       * @param radius - The radius of the circle.
       * @param transform - An optional `Matrix` object to apply a transformation to the circle.
       * @returns The instance of the current object for chaining.
       */
      circle(x, y, radius, transform) {
        this.drawShape(new Circle(x, y, radius), transform);
        return this;
      }
      /**
       * Draws a polygon shape. This method allows for the creation of complex polygons by specifying a sequence of points.
       * @param points - An array of numbers, or or an array of PointData objects eg [{x,y}, {x,y}, {x,y}]
       * representing the x and y coordinates of the polygon's vertices, in sequence.
       * @param close - A boolean indicating whether to close the polygon path. True by default.
       * @param transform - An optional `Matrix` object to apply a transformation to the polygon.
       * @returns The instance of the current object for chaining.
       */
      poly(points, close, transform) {
        const polygon = new Polygon(points);
        polygon.closePath = close;
        this.drawShape(polygon, transform);
        return this;
      }
      /**
       * Draws a regular polygon with a specified number of sides. All sides and angles are equal.
       * @param x - The x-coordinate of the center of the polygon.
       * @param y - The y-coordinate of the center of the polygon.
       * @param radius - The radius of the circumscribed circle of the polygon.
       * @param sides - The number of sides of the polygon. Must be 3 or more.
       * @param rotation - The rotation angle of the polygon, in radians. Zero by default.
       * @param transform - An optional `Matrix` object to apply a transformation to the polygon.
       * @returns The instance of the current object for chaining.
       */
      regularPoly(x, y, radius, sides, rotation = 0, transform) {
        sides = Math.max(sides | 0, 3);
        const startAngle = -1 * Math.PI / 2 + rotation;
        const delta = Math.PI * 2 / sides;
        const polygon = [];
        for (let i = 0; i < sides; i++) {
          const angle = i * delta + startAngle;
          polygon.push(
            x + radius * Math.cos(angle),
            y + radius * Math.sin(angle)
          );
        }
        this.poly(polygon, true, transform);
        return this;
      }
      /**
       * Draws a polygon with rounded corners.
       * Similar to `regularPoly` but with the ability to round the corners of the polygon.
       * @param x - The x-coordinate of the center of the polygon.
       * @param y - The y-coordinate of the center of the polygon.
       * @param radius - The radius of the circumscribed circle of the polygon.
       * @param sides - The number of sides of the polygon. Must be 3 or more.
       * @param corner - The radius of the rounding of the corners.
       * @param rotation - The rotation angle of the polygon, in radians. Zero by default.
       * @param smoothness - Optional parameter to adjust the smoothness of the rounding.
       * @returns The instance of the current object for chaining.
       */
      roundPoly(x, y, radius, sides, corner, rotation = 0, smoothness) {
        sides = Math.max(sides | 0, 3);
        if (corner <= 0) {
          return this.regularPoly(x, y, radius, sides, rotation);
        }
        const sideLength = radius * Math.sin(Math.PI / sides) - 1e-3;
        corner = Math.min(corner, sideLength);
        const startAngle = -1 * Math.PI / 2 + rotation;
        const delta = Math.PI * 2 / sides;
        const internalAngle = (sides - 2) * Math.PI / sides / 2;
        for (let i = 0; i < sides; i++) {
          const angle = i * delta + startAngle;
          const x0 = x + radius * Math.cos(angle);
          const y0 = y + radius * Math.sin(angle);
          const a1 = angle + Math.PI + internalAngle;
          const a2 = angle - Math.PI - internalAngle;
          const x1 = x0 + corner * Math.cos(a1);
          const y1 = y0 + corner * Math.sin(a1);
          const x3 = x0 + corner * Math.cos(a2);
          const y3 = y0 + corner * Math.sin(a2);
          if (i === 0) {
            this.moveTo(x1, y1);
          } else {
            this.lineTo(x1, y1);
          }
          this.quadraticCurveTo(x0, y0, x3, y3, smoothness);
        }
        return this.closePath();
      }
      /**
       * Draws a shape with rounded corners. This function supports custom radius for each corner of the shape.
       * Optionally, corners can be rounded using a quadratic curve instead of an arc, providing a different aesthetic.
       * @param points - An array of `RoundedPoint` representing the corners of the shape to draw.
       * A minimum of 3 points is required.
       * @param radius - The default radius for the corners.
       * This radius is applied to all corners unless overridden in `points`.
       * @param useQuadratic - If set to true, rounded corners are drawn using a quadraticCurve
       *  method instead of an arc method. Defaults to false.
       * @param smoothness - Specifies the smoothness of the curve when `useQuadratic` is true.
       * Higher values make the curve smoother.
       * @returns The instance of the current object for chaining.
       */
      roundShape(points, radius, useQuadratic = false, smoothness) {
        if (points.length < 3) {
          return this;
        }
        if (useQuadratic) {
          roundedShapeQuadraticCurve(this, points, radius, smoothness);
        } else {
          roundedShapeArc(this, points, radius);
        }
        return this.closePath();
      }
      /**
       * Draw Rectangle with fillet corners. This is much like rounded rectangle
       * however it support negative numbers as well for the corner radius.
       * @param x - Upper left corner of rect
       * @param y - Upper right corner of rect
       * @param width - Width of rect
       * @param height - Height of rect
       * @param fillet - accept negative or positive values
       */
      filletRect(x, y, width, height, fillet) {
        if (fillet === 0) {
          return this.rect(x, y, width, height);
        }
        const maxFillet = Math.min(width, height) / 2;
        const inset = Math.min(maxFillet, Math.max(-maxFillet, fillet));
        const right = x + width;
        const bottom = y + height;
        const dir = inset < 0 ? -inset : 0;
        const size = Math.abs(inset);
        return this.moveTo(x, y + size).arcTo(x + dir, y + dir, x + size, y, size).lineTo(right - size, y).arcTo(right - dir, y + dir, right, y + size, size).lineTo(right, bottom - size).arcTo(right - dir, bottom - dir, x + width - size, bottom, size).lineTo(x + size, bottom).arcTo(x + dir, bottom - dir, x, bottom - size, size).closePath();
      }
      /**
       * Draw Rectangle with chamfer corners. These are angled corners.
       * @param x - Upper left corner of rect
       * @param y - Upper right corner of rect
       * @param width - Width of rect
       * @param height - Height of rect
       * @param chamfer - non-zero real number, size of corner cutout
       * @param transform
       */
      chamferRect(x, y, width, height, chamfer, transform) {
        if (chamfer <= 0) {
          return this.rect(x, y, width, height);
        }
        const inset = Math.min(chamfer, Math.min(width, height) / 2);
        const right = x + width;
        const bottom = y + height;
        const points = [
          x + inset,
          y,
          right - inset,
          y,
          right,
          y + inset,
          right,
          bottom - inset,
          right - inset,
          bottom,
          x + inset,
          bottom,
          x,
          bottom - inset,
          x,
          y + inset
        ];
        for (let i = points.length - 1; i >= 2; i -= 2) {
          if (points[i] === points[i - 2] && points[i - 1] === points[i - 3]) {
            points.splice(i - 1, 2);
          }
        }
        return this.poly(points, true, transform);
      }
      /**
       * Draws an ellipse at the specified location and with the given x and y radii.
       * An optional transformation can be applied, allowing for rotation, scaling, and translation.
       * @param x - The x-coordinate of the center of the ellipse.
       * @param y - The y-coordinate of the center of the ellipse.
       * @param radiusX - The horizontal radius of the ellipse.
       * @param radiusY - The vertical radius of the ellipse.
       * @param transform - An optional `Matrix` object to apply a transformation to the ellipse. This can include rotations.
       * @returns The instance of the current object for chaining.
       */
      ellipse(x, y, radiusX, radiusY, transform) {
        this.drawShape(new Ellipse(x, y, radiusX, radiusY), transform);
        return this;
      }
      /**
       * Draws a rectangle with rounded corners.
       * The corner radius can be specified to determine how rounded the corners should be.
       * An optional transformation can be applied, which allows for rotation, scaling, and translation of the rectangle.
       * @param x - The x-coordinate of the top-left corner of the rectangle.
       * @param y - The y-coordinate of the top-left corner of the rectangle.
       * @param w - The width of the rectangle.
       * @param h - The height of the rectangle.
       * @param radius - The radius of the rectangle's corners. If not specified, corners will be sharp.
       * @param transform - An optional `Matrix` object to apply a transformation to the rectangle.
       * @returns The instance of the current object for chaining.
       */
      roundRect(x, y, w, h, radius, transform) {
        this.drawShape(new RoundedRectangle(x, y, w, h, radius), transform);
        return this;
      }
      /**
       * Draws a given shape on the canvas.
       * This is a generic method that can draw any type of shape specified by the `ShapePrimitive` parameter.
       * An optional transformation matrix can be applied to the shape, allowing for complex transformations.
       * @param shape - The shape to draw, defined as a `ShapePrimitive` object.
       * @param matrix - An optional `Matrix` for transforming the shape. This can include rotations,
       * scaling, and translations.
       * @returns The instance of the current object for chaining.
       */
      drawShape(shape, matrix) {
        this.endPoly();
        this.shapePrimitives.push({ shape, transform: matrix });
        return this;
      }
      /**
       * Starts a new polygon path from the specified starting point.
       * This method initializes a new polygon or ends the current one if it exists.
       * @param x - The x-coordinate of the starting point of the new polygon.
       * @param y - The y-coordinate of the starting point of the new polygon.
       * @returns The instance of the current object for chaining.
       */
      startPoly(x, y) {
        let currentPoly = this._currentPoly;
        if (currentPoly) {
          this.endPoly();
        }
        currentPoly = new Polygon();
        currentPoly.points.push(x, y);
        this._currentPoly = currentPoly;
        return this;
      }
      /**
       * Ends the current polygon path. If `closePath` is set to true,
       * the path is closed by connecting the last point to the first one.
       * This method finalizes the current polygon and prepares it for drawing or adding to the shape primitives.
       * @param closePath - A boolean indicating whether to close the polygon by connecting the last point
       *  back to the starting point. False by default.
       * @returns The instance of the current object for chaining.
       */
      endPoly(closePath = false) {
        const shape = this._currentPoly;
        if (shape && shape.points.length > 2) {
          shape.closePath = closePath;
          this.shapePrimitives.push({ shape });
        }
        this._currentPoly = null;
        return this;
      }
      _ensurePoly(start = true) {
        if (this._currentPoly)
          return;
        this._currentPoly = new Polygon();
        if (start) {
          const lastShape = this.shapePrimitives[this.shapePrimitives.length - 1];
          if (lastShape) {
            let lx = lastShape.shape.x;
            let ly = lastShape.shape.y;
            if (lastShape.transform && !lastShape.transform.isIdentity()) {
              const t = lastShape.transform;
              const tempX = lx;
              lx = t.a * lx + t.c * ly + t.tx;
              ly = t.b * tempX + t.d * ly + t.ty;
            }
            this._currentPoly.points.push(lx, ly);
          } else {
            this._currentPoly.points.push(0, 0);
          }
        }
      }
      /** Builds the path. */
      buildPath() {
        const path = this._graphicsPath2D;
        this.shapePrimitives.length = 0;
        this._currentPoly = null;
        for (let i = 0; i < path.instructions.length; i++) {
          const instruction = path.instructions[i];
          this[instruction.action](...instruction.data);
        }
        this.finish();
      }
      /** Gets the bounds of the path. */
      get bounds() {
        const bounds = this._bounds;
        bounds.clear();
        const shapePrimitives = this.shapePrimitives;
        for (let i = 0; i < shapePrimitives.length; i++) {
          const shapePrimitive = shapePrimitives[i];
          const boundsRect = shapePrimitive.shape.getBounds(tempRectangle);
          if (shapePrimitive.transform) {
            bounds.addRect(boundsRect, shapePrimitive.transform);
          } else {
            bounds.addRect(boundsRect);
          }
        }
        return bounds;
      }
    }

    "use strict";
    class GraphicsPath {
      /**
       * Creates a `GraphicsPath` instance optionally from an SVG path string or an array of `PathInstruction`.
       * @param instructions - An SVG path string or an array of `PathInstruction` objects.
       */
      constructor(instructions) {
        this.instructions = [];
        /** unique id for this graphics path */
        this.uid = uid$1("graphicsPath");
        this._dirty = true;
        var _a;
        if (typeof instructions === "string") {
          SVGToGraphicsPath(instructions, this);
        } else {
          this.instructions = (_a = instructions == null ? void 0 : instructions.slice()) != null ? _a : [];
        }
      }
      /**
       * Provides access to the internal shape path, ensuring it is up-to-date with the current instructions.
       * @returns The `ShapePath` instance associated with this `GraphicsPath`.
       */
      get shapePath() {
        if (!this._shapePath) {
          this._shapePath = new ShapePath(this);
        }
        if (this._dirty) {
          this._dirty = false;
          this._shapePath.buildPath();
        }
        return this._shapePath;
      }
      /**
       * Adds another `GraphicsPath` to this path, optionally applying a transformation.
       * @param path - The `GraphicsPath` to add.
       * @param transform - An optional transformation to apply to the added path.
       * @returns The instance of the current object for chaining.
       */
      addPath(path, transform) {
        path = path.clone();
        this.instructions.push({ action: "addPath", data: [path, transform] });
        this._dirty = true;
        return this;
      }
      arc(...args) {
        this.instructions.push({ action: "arc", data: args });
        this._dirty = true;
        return this;
      }
      arcTo(...args) {
        this.instructions.push({ action: "arcTo", data: args });
        this._dirty = true;
        return this;
      }
      arcToSvg(...args) {
        this.instructions.push({ action: "arcToSvg", data: args });
        this._dirty = true;
        return this;
      }
      bezierCurveTo(...args) {
        this.instructions.push({ action: "bezierCurveTo", data: args });
        this._dirty = true;
        return this;
      }
      /**
       * Adds a cubic Bezier curve to the path.
       * It requires two points: the second control point and the end point. The first control point is assumed to be
       * The starting point is the last point in the current path.
       * @param cp2x - The x-coordinate of the second control point.
       * @param cp2y - The y-coordinate of the second control point.
       * @param x - The x-coordinate of the end point.
       * @param y - The y-coordinate of the end point.
       * @param smoothness - Optional parameter to adjust the smoothness of the curve.
       * @returns The instance of the current object for chaining.
       */
      bezierCurveToShort(cp2x, cp2y, x, y, smoothness) {
        const last = this.instructions[this.instructions.length - 1];
        const lastPoint = this.getLastPoint(Point.shared);
        let cp1x = 0;
        let cp1y = 0;
        if (!last || last.action !== "bezierCurveTo") {
          cp1x = lastPoint.x;
          cp1y = lastPoint.y;
        } else {
          cp1x = last.data[2];
          cp1y = last.data[3];
          const currentX = lastPoint.x;
          const currentY = lastPoint.y;
          cp1x = currentX + (currentX - cp1x);
          cp1y = currentY + (currentY - cp1y);
        }
        this.instructions.push({ action: "bezierCurveTo", data: [cp1x, cp1y, cp2x, cp2y, x, y, smoothness] });
        this._dirty = true;
        return this;
      }
      /**
       * Closes the current path by drawing a straight line back to the start.
       * If the shape is already closed or there are no points in the path, this method does nothing.
       * @returns The instance of the current object for chaining.
       */
      closePath() {
        this.instructions.push({ action: "closePath", data: [] });
        this._dirty = true;
        return this;
      }
      ellipse(...args) {
        this.instructions.push({ action: "ellipse", data: args });
        this._dirty = true;
        return this;
      }
      lineTo(...args) {
        this.instructions.push({ action: "lineTo", data: args });
        this._dirty = true;
        return this;
      }
      moveTo(...args) {
        this.instructions.push({ action: "moveTo", data: args });
        return this;
      }
      quadraticCurveTo(...args) {
        this.instructions.push({ action: "quadraticCurveTo", data: args });
        this._dirty = true;
        return this;
      }
      /**
       * Adds a quadratic curve to the path. It uses the previous point as the control point.
       * @param x - The x-coordinate of the end point.
       * @param y - The y-coordinate of the end point.
       * @param smoothness - Optional parameter to adjust the smoothness of the curve.
       * @returns The instance of the current object for chaining.
       */
      quadraticCurveToShort(x, y, smoothness) {
        const last = this.instructions[this.instructions.length - 1];
        const lastPoint = this.getLastPoint(Point.shared);
        let cpx1 = 0;
        let cpy1 = 0;
        if (!last || last.action !== "quadraticCurveTo") {
          cpx1 = lastPoint.x;
          cpy1 = lastPoint.y;
        } else {
          cpx1 = last.data[0];
          cpy1 = last.data[1];
          const currentX = lastPoint.x;
          const currentY = lastPoint.y;
          cpx1 = currentX + (currentX - cpx1);
          cpy1 = currentY + (currentY - cpy1);
        }
        this.instructions.push({ action: "quadraticCurveTo", data: [cpx1, cpy1, x, y, smoothness] });
        this._dirty = true;
        return this;
      }
      /**
       * Draws a rectangle shape. This method adds a new rectangle path to the current drawing.
       * @param x - The x-coordinate of the top-left corner of the rectangle.
       * @param y - The y-coordinate of the top-left corner of the rectangle.
       * @param w - The width of the rectangle.
       * @param h - The height of the rectangle.
       * @param transform - An optional `Matrix` object to apply a transformation to the rectangle.
       * @returns The instance of the current object for chaining.
       */
      rect(x, y, w, h, transform) {
        this.instructions.push({ action: "rect", data: [x, y, w, h, transform] });
        this._dirty = true;
        return this;
      }
      /**
       * Draws a circle shape. This method adds a new circle path to the current drawing.
       * @param x - The x-coordinate of the center of the circle.
       * @param y - The y-coordinate of the center of the circle.
       * @param radius - The radius of the circle.
       * @param transform - An optional `Matrix` object to apply a transformation to the circle.
       * @returns The instance of the current object for chaining.
       */
      circle(x, y, radius, transform) {
        this.instructions.push({ action: "circle", data: [x, y, radius, transform] });
        this._dirty = true;
        return this;
      }
      roundRect(...args) {
        this.instructions.push({ action: "roundRect", data: args });
        this._dirty = true;
        return this;
      }
      poly(...args) {
        this.instructions.push({ action: "poly", data: args });
        this._dirty = true;
        return this;
      }
      regularPoly(...args) {
        this.instructions.push({ action: "regularPoly", data: args });
        this._dirty = true;
        return this;
      }
      roundPoly(...args) {
        this.instructions.push({ action: "roundPoly", data: args });
        this._dirty = true;
        return this;
      }
      roundShape(...args) {
        this.instructions.push({ action: "roundShape", data: args });
        this._dirty = true;
        return this;
      }
      filletRect(...args) {
        this.instructions.push({ action: "filletRect", data: args });
        this._dirty = true;
        return this;
      }
      chamferRect(...args) {
        this.instructions.push({ action: "chamferRect", data: args });
        this._dirty = true;
        return this;
      }
      /**
       * Draws a star shape centered at a specified location. This method allows for the creation
       *  of stars with a variable number of points, outer radius, optional inner radius, and rotation.
       * The star is drawn as a closed polygon with alternating outer and inner vertices to create the star's points.
       * An optional transformation can be applied to scale, rotate, or translate the star as needed.
       * @param x - The x-coordinate of the center of the star.
       * @param y - The y-coordinate of the center of the star.
       * @param points - The number of points of the star.
       * @param radius - The outer radius of the star (distance from the center to the outer points).
       * @param innerRadius - Optional. The inner radius of the star
       * (distance from the center to the inner points between the outer points).
       * If not provided, defaults to half of the `radius`.
       * @param rotation - Optional. The rotation of the star in radians, where 0 is aligned with the y-axis.
       * Defaults to 0, meaning one point is directly upward.
       * @param transform - An optional `Matrix` object to apply a transformation to the star.
       * This can include rotations, scaling, and translations.
       * @returns The instance of the current object for chaining further drawing commands.
       */
      // eslint-disable-next-line max-len
      star(x, y, points, radius, innerRadius, rotation, transform) {
        innerRadius || (innerRadius = radius / 2);
        const startAngle = -1 * Math.PI / 2 + rotation;
        const len = points * 2;
        const delta = Math.PI * 2 / len;
        const polygon = [];
        for (let i = 0; i < len; i++) {
          const r = i % 2 ? innerRadius : radius;
          const angle = i * delta + startAngle;
          polygon.push(
            x + r * Math.cos(angle),
            y + r * Math.sin(angle)
          );
        }
        this.poly(polygon, true, transform);
        return this;
      }
      /**
       * Creates a copy of the current `GraphicsPath` instance. This method supports both shallow and deep cloning.
       * A shallow clone copies the reference of the instructions array, while a deep clone creates a new array and
       * copies each instruction individually, ensuring that modifications to the instructions of the cloned `GraphicsPath`
       * do not affect the original `GraphicsPath` and vice versa.
       * @param deep - A boolean flag indicating whether the clone should be deep.
       * @returns A new `GraphicsPath` instance that is a clone of the current instance.
       */
      clone(deep = false) {
        const newGraphicsPath2D = new GraphicsPath();
        if (!deep) {
          newGraphicsPath2D.instructions = this.instructions.slice();
        } else {
          for (let i = 0; i < this.instructions.length; i++) {
            const instruction = this.instructions[i];
            newGraphicsPath2D.instructions.push({ action: instruction.action, data: instruction.data.slice() });
          }
        }
        return newGraphicsPath2D;
      }
      clear() {
        this.instructions.length = 0;
        this._dirty = true;
        return this;
      }
      /**
       * Applies a transformation matrix to all drawing instructions within the `GraphicsPath`.
       * This method enables the modification of the path's geometry according to the provided
       * transformation matrix, which can include translations, rotations, scaling, and skewing.
       *
       * Each drawing instruction in the path is updated to reflect the transformation,
       * ensuring the visual representation of the path is consistent with the applied matrix.
       *
       * Note: The transformation is applied directly to the coordinates and control points of the drawing instructions,
       * not to the path as a whole. This means the transformation's effects are baked into the individual instructions,
       * allowing for fine-grained control over the path's appearance.
       * @param matrix - A `Matrix` object representing the transformation to apply.
       * @returns The instance of the current object for chaining further operations.
       */
      transform(matrix) {
        if (matrix.isIdentity())
          return this;
        const a = matrix.a;
        const b = matrix.b;
        const c = matrix.c;
        const d = matrix.d;
        const tx = matrix.tx;
        const ty = matrix.ty;
        let x = 0;
        let y = 0;
        let cpx1 = 0;
        let cpy1 = 0;
        let cpx2 = 0;
        let cpy2 = 0;
        let rx = 0;
        let ry = 0;
        for (let i = 0; i < this.instructions.length; i++) {
          const instruction = this.instructions[i];
          const data = instruction.data;
          switch (instruction.action) {
            case "moveTo":
            case "lineTo":
              x = data[0];
              y = data[1];
              data[0] = a * x + c * y + tx;
              data[1] = b * x + d * y + ty;
              break;
            case "bezierCurveTo":
              cpx1 = data[0];
              cpy1 = data[1];
              cpx2 = data[2];
              cpy2 = data[3];
              x = data[4];
              y = data[5];
              data[0] = a * cpx1 + c * cpy1 + tx;
              data[1] = b * cpx1 + d * cpy1 + ty;
              data[2] = a * cpx2 + c * cpy2 + tx;
              data[3] = b * cpx2 + d * cpy2 + ty;
              data[4] = a * x + c * y + tx;
              data[5] = b * x + d * y + ty;
              break;
            case "quadraticCurveTo":
              cpx1 = data[0];
              cpy1 = data[1];
              x = data[2];
              y = data[3];
              data[0] = a * cpx1 + c * cpy1 + tx;
              data[1] = b * cpx1 + d * cpy1 + ty;
              data[2] = a * x + c * y + tx;
              data[3] = b * x + d * y + ty;
              break;
            case "arcToSvg":
              x = data[5];
              y = data[6];
              rx = data[0];
              ry = data[1];
              data[0] = a * rx + c * ry;
              data[1] = b * rx + d * ry;
              data[5] = a * x + c * y + tx;
              data[6] = b * x + d * y + ty;
              break;
            case "circle":
              data[4] = adjustTransform(data[3], matrix);
              break;
            case "rect":
              data[4] = adjustTransform(data[4], matrix);
              break;
            case "ellipse":
              data[8] = adjustTransform(data[8], matrix);
              break;
            case "roundRect":
              data[5] = adjustTransform(data[5], matrix);
              break;
            case "addPath":
              data[0].transform(matrix);
              break;
            case "poly":
              data[2] = adjustTransform(data[2], matrix);
              break;
            default:
              warn("unknown transform action", instruction.action);
              break;
          }
        }
        this._dirty = true;
        return this;
      }
      get bounds() {
        return this.shapePath.bounds;
      }
      /**
       * Retrieves the last point from the current drawing instructions in the `GraphicsPath`.
       * This method is useful for operations that depend on the path's current endpoint,
       * such as connecting subsequent shapes or paths. It supports various drawing instructions,
       * ensuring the last point's position is accurately determined regardless of the path's complexity.
       *
       * If the last instruction is a `closePath`, the method iterates backward through the instructions
       *  until it finds an actionable instruction that defines a point (e.g., `moveTo`, `lineTo`,
       * `quadraticCurveTo`, etc.). For compound paths added via `addPath`, it recursively retrieves
       * the last point from the nested path.
       * @param out - A `Point` object where the last point's coordinates will be stored.
       * This object is modified directly to contain the result.
       * @returns The `Point` object containing the last point's coordinates.
       */
      getLastPoint(out) {
        let index = this.instructions.length - 1;
        let lastInstruction = this.instructions[index];
        if (!lastInstruction) {
          out.x = 0;
          out.y = 0;
          return out;
        }
        while (lastInstruction.action === "closePath") {
          index--;
          if (index < 0) {
            out.x = 0;
            out.y = 0;
            return out;
          }
          lastInstruction = this.instructions[index];
        }
        switch (lastInstruction.action) {
          case "moveTo":
          case "lineTo":
            out.x = lastInstruction.data[0];
            out.y = lastInstruction.data[1];
            break;
          case "quadraticCurveTo":
            out.x = lastInstruction.data[2];
            out.y = lastInstruction.data[3];
            break;
          case "bezierCurveTo":
            out.x = lastInstruction.data[4];
            out.y = lastInstruction.data[5];
            break;
          case "arc":
          case "arcToSvg":
            out.x = lastInstruction.data[5];
            out.y = lastInstruction.data[6];
            break;
          case "addPath":
            lastInstruction.data[0].getLastPoint(out);
            break;
        }
        return out;
      }
    }
    function adjustTransform(currentMatrix, transform) {
      if (currentMatrix) {
        return currentMatrix.prepend(transform);
      }
      return transform.clone();
    }

    "use strict";
    var __defProp$U = Object.defineProperty;
    var __getOwnPropSymbols$U = Object.getOwnPropertySymbols;
    var __hasOwnProp$U = Object.prototype.hasOwnProperty;
    var __propIsEnum$U = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$U = (obj, key, value) => key in obj ? __defProp$U(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$U = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$U.call(b, prop))
          __defNormalProp$U(a, prop, b[prop]);
      if (__getOwnPropSymbols$U)
        for (var prop of __getOwnPropSymbols$U(b)) {
          if (__propIsEnum$U.call(b, prop))
            __defNormalProp$U(a, prop, b[prop]);
        }
      return a;
    };
    function SVGParser(svg, graphicsContext) {
      if (typeof svg === "string") {
        const div = document.createElement("div");
        div.innerHTML = svg.trim();
        svg = div.querySelector("svg");
      }
      const session = {
        context: graphicsContext,
        path: new GraphicsPath()
      };
      renderChildren(svg, session, null, null);
      return graphicsContext;
    }
    function renderChildren(svg, session, fillStyle, strokeStyle) {
      const children = svg.children;
      const { fillStyle: f1, strokeStyle: s1 } = parseStyle(svg);
      if (f1 && fillStyle) {
        fillStyle = __spreadValues$U(__spreadValues$U({}, fillStyle), f1);
      } else if (f1) {
        fillStyle = f1;
      }
      if (s1 && strokeStyle) {
        strokeStyle = __spreadValues$U(__spreadValues$U({}, strokeStyle), s1);
      } else if (s1) {
        strokeStyle = s1;
      }
      session.context.fillStyle = fillStyle;
      session.context.strokeStyle = strokeStyle;
      let x;
      let y;
      let x1;
      let y1;
      let x2;
      let y2;
      let cx;
      let cy;
      let r;
      let rx;
      let ry;
      let points;
      let pointsString;
      let d;
      let graphicsPath;
      let width;
      let height;
      switch (svg.nodeName.toLowerCase()) {
        case "path":
          d = svg.getAttribute("d");
          graphicsPath = new GraphicsPath(d);
          session.context.path(graphicsPath);
          if (fillStyle)
            session.context.fill();
          if (strokeStyle)
            session.context.stroke();
          break;
        case "circle":
          cx = parseFloatAttribute(svg, "cx", 0);
          cy = parseFloatAttribute(svg, "cy", 0);
          r = parseFloatAttribute(svg, "r", 0);
          session.context.ellipse(cx, cy, r, r);
          if (fillStyle)
            session.context.fill();
          if (strokeStyle)
            session.context.stroke();
          break;
        case "rect":
          x = parseFloatAttribute(svg, "x", 0);
          y = parseFloatAttribute(svg, "y", 0);
          width = parseFloatAttribute(svg, "width", 0);
          height = parseFloatAttribute(svg, "height", 0);
          rx = parseFloatAttribute(svg, "rx", 0);
          ry = parseFloatAttribute(svg, "ry", 0);
          if (rx || ry) {
            session.context.roundRect(x, y, width, height, rx || ry);
          } else {
            session.context.rect(x, y, width, height);
          }
          if (fillStyle)
            session.context.fill();
          if (strokeStyle)
            session.context.stroke();
          break;
        case "ellipse":
          cx = parseFloatAttribute(svg, "cx", 0);
          cy = parseFloatAttribute(svg, "cy", 0);
          rx = parseFloatAttribute(svg, "rx", 0);
          ry = parseFloatAttribute(svg, "ry", 0);
          session.context.beginPath();
          session.context.ellipse(cx, cy, rx, ry);
          if (fillStyle)
            session.context.fill();
          if (strokeStyle)
            session.context.stroke();
          break;
        case "line":
          x1 = parseFloatAttribute(svg, "x1", 0);
          y1 = parseFloatAttribute(svg, "y1", 0);
          x2 = parseFloatAttribute(svg, "x2", 0);
          y2 = parseFloatAttribute(svg, "y2", 0);
          session.context.beginPath();
          session.context.moveTo(x1, y1);
          session.context.lineTo(x2, y2);
          if (strokeStyle)
            session.context.stroke();
          break;
        case "polygon":
          pointsString = svg.getAttribute("points");
          points = pointsString.match(/\d+/g).map((n) => parseInt(n, 10));
          session.context.poly(points, true);
          if (fillStyle)
            session.context.fill();
          if (strokeStyle)
            session.context.stroke();
          break;
        case "polyline":
          pointsString = svg.getAttribute("points");
          points = pointsString.match(/\d+/g).map((n) => parseInt(n, 10));
          session.context.poly(points, false);
          if (strokeStyle)
            session.context.stroke();
          break;
        case "g":
        case "svg":
          break;
        default: {
          console.info(`[SVG parser] <${svg.nodeName}> elements unsupported`);
          break;
        }
      }
      for (let i = 0; i < children.length; i++) {
        renderChildren(children[i], session, fillStyle, strokeStyle);
      }
    }
    function parseFloatAttribute(svg, id, defaultValue) {
      const value = svg.getAttribute(id);
      return value ? Number(value) : defaultValue;
    }
    function parseStyle(svg) {
      const style = svg.getAttribute("style");
      const strokeStyle = {};
      const fillStyle = {};
      let useFill = false;
      let useStroke = false;
      if (style) {
        const styleParts = style.split(";");
        for (let i = 0; i < styleParts.length; i++) {
          const stylePart = styleParts[i];
          const [key, value] = stylePart.split(":");
          switch (key) {
            case "stroke":
              if (value !== "none") {
                strokeStyle.color = Color.shared.setValue(value).toNumber();
                useStroke = true;
              }
              break;
            case "stroke-width":
              strokeStyle.width = Number(value);
              break;
            case "fill":
              if (value !== "none") {
                useFill = true;
                fillStyle.color = Color.shared.setValue(value).toNumber();
              }
              break;
            case "fill-opacity":
              fillStyle.alpha = Number(value);
              break;
            case "stroke-opacity":
              strokeStyle.alpha = Number(value);
              break;
            case "opacity":
              fillStyle.alpha = Number(value);
              strokeStyle.alpha = Number(value);
              break;
          }
        }
      } else {
        const stroke = svg.getAttribute("stroke");
        if (stroke && stroke !== "none") {
          useStroke = true;
          strokeStyle.color = Color.shared.setValue(stroke).toNumber();
          strokeStyle.width = parseFloatAttribute(svg, "stroke-width", 1);
        }
        const fill = svg.getAttribute("fill");
        if (fill && fill !== "none") {
          useFill = true;
          fillStyle.color = Color.shared.setValue(fill).toNumber();
        }
      }
      return {
        strokeStyle: useStroke ? strokeStyle : null,
        fillStyle: useFill ? fillStyle : null
      };
    }

    "use strict";
    var __defProp$T = Object.defineProperty;
    var __getOwnPropSymbols$T = Object.getOwnPropertySymbols;
    var __hasOwnProp$T = Object.prototype.hasOwnProperty;
    var __propIsEnum$T = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$T = (obj, key, value) => key in obj ? __defProp$T(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$T = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$T.call(b, prop))
          __defNormalProp$T(a, prop, b[prop]);
      if (__getOwnPropSymbols$T)
        for (var prop of __getOwnPropSymbols$T(b)) {
          if (__propIsEnum$T.call(b, prop))
            __defNormalProp$T(a, prop, b[prop]);
        }
      return a;
    };
    var __objRest$j = (source, exclude) => {
      var target = {};
      for (var prop in source)
        if (__hasOwnProp$T.call(source, prop) && exclude.indexOf(prop) < 0)
          target[prop] = source[prop];
      if (source != null && __getOwnPropSymbols$T)
        for (var prop of __getOwnPropSymbols$T(source)) {
          if (exclude.indexOf(prop) < 0 && __propIsEnum$T.call(source, prop))
            target[prop] = source[prop];
        }
      return target;
    };
    function isColorLike(value) {
      return Color.isColorLike(value);
    }
    function isFillPattern(value) {
      return value instanceof FillPattern;
    }
    function isFillGradient(value) {
      return value instanceof FillGradient;
    }
    function handleColorLike(fill, value, defaultStyle) {
      const temp = Color.shared.setValue(value != null ? value : 0);
      fill.color = temp.toNumber();
      fill.alpha = temp.alpha === 1 ? defaultStyle.alpha : temp.alpha;
      fill.texture = Texture.WHITE;
      return __spreadValues$T(__spreadValues$T({}, defaultStyle), fill);
    }
    function handleFillPattern(fill, value, defaultStyle) {
      fill.fill = value;
      fill.color = 16777215;
      fill.texture = value.texture;
      fill.matrix = value.transform;
      return __spreadValues$T(__spreadValues$T({}, defaultStyle), fill);
    }
    function handleFillGradient(fill, value, defaultStyle) {
      value.buildLinearGradient();
      fill.fill = value;
      fill.color = 16777215;
      fill.texture = value.texture;
      fill.matrix = value.transform;
      return __spreadValues$T(__spreadValues$T({}, defaultStyle), fill);
    }
    function handleFillObject(value, defaultStyle) {
      var _a;
      const style = __spreadValues$T(__spreadValues$T({}, defaultStyle), value);
      if (style.texture) {
        if (style.texture !== Texture.WHITE) {
          const m = ((_a = style.matrix) == null ? void 0 : _a.clone().invert()) || new Matrix();
          m.translate(style.texture.frame.x, style.texture.frame.y);
          m.scale(1 / style.texture.source.width, 1 / style.texture.source.height);
          style.matrix = m;
        }
        const sourceStyle = style.texture.source.style;
        if (sourceStyle.addressMode === "clamp-to-edge") {
          sourceStyle.addressMode = "repeat";
          sourceStyle.update();
        }
      }
      const color = Color.shared.setValue(style.color);
      style.alpha *= color.alpha;
      style.color = color.toNumber();
      style.matrix = style.matrix ? style.matrix.clone() : null;
      return style;
    }
    function toFillStyle(value, defaultStyle) {
      if (value === void 0 || value === null) {
        return null;
      }
      const fill = {};
      const objectStyle = value;
      if (isColorLike(value)) {
        return handleColorLike(fill, value, defaultStyle);
      } else if (isFillPattern(value)) {
        return handleFillPattern(fill, value, defaultStyle);
      } else if (isFillGradient(value)) {
        return handleFillGradient(fill, value, defaultStyle);
      } else if (objectStyle.fill && isFillPattern(objectStyle.fill)) {
        return handleFillPattern(objectStyle, objectStyle.fill, defaultStyle);
      } else if (objectStyle.fill && isFillGradient(objectStyle.fill)) {
        return handleFillGradient(objectStyle, objectStyle.fill, defaultStyle);
      }
      return handleFillObject(objectStyle, defaultStyle);
    }
    function toStrokeStyle(value, defaultStyle) {
      const _a = defaultStyle, { width, alignment, miterLimit, cap, join, pixelLine } = _a, rest = __objRest$j(_a, ["width", "alignment", "miterLimit", "cap", "join", "pixelLine"]);
      const fill = toFillStyle(value, rest);
      if (!fill) {
        return null;
      }
      return __spreadValues$T({
        width,
        alignment,
        miterLimit,
        cap,
        join,
        pixelLine
      }, fill);
    }

    "use strict";
    var __defProp$S = Object.defineProperty;
    var __getOwnPropSymbols$S = Object.getOwnPropertySymbols;
    var __hasOwnProp$S = Object.prototype.hasOwnProperty;
    var __propIsEnum$S = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$S = (obj, key, value) => key in obj ? __defProp$S(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$S = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$S.call(b, prop))
          __defNormalProp$S(a, prop, b[prop]);
      if (__getOwnPropSymbols$S)
        for (var prop of __getOwnPropSymbols$S(b)) {
          if (__propIsEnum$S.call(b, prop))
            __defNormalProp$S(a, prop, b[prop]);
        }
      return a;
    };
    const tmpPoint = new Point();
    const tempMatrix$4 = new Matrix();
    const _GraphicsContext = class _GraphicsContext extends EventEmitter {
      constructor() {
        super(...arguments);
        /** unique id for this graphics context */
        this.uid = uid$1("graphicsContext");
        this.dirty = true;
        this.batchMode = "auto";
        this.instructions = [];
        this._activePath = new GraphicsPath();
        this._transform = new Matrix();
        this._fillStyle = __spreadValues$S({}, _GraphicsContext.defaultFillStyle);
        this._strokeStyle = __spreadValues$S({}, _GraphicsContext.defaultStrokeStyle);
        this._stateStack = [];
        this._tick = 0;
        this._bounds = new Bounds();
        this._boundsDirty = true;
      }
      /**
       * Creates a new GraphicsContext object that is a clone of this instance, copying all properties,
       * including the current drawing state, transformations, styles, and instructions.
       * @returns A new GraphicsContext instance with the same properties and state as this one.
       */
      clone() {
        const clone = new _GraphicsContext();
        clone.batchMode = this.batchMode;
        clone.instructions = this.instructions.slice();
        clone._activePath = this._activePath.clone();
        clone._transform = this._transform.clone();
        clone._fillStyle = __spreadValues$S({}, this._fillStyle);
        clone._strokeStyle = __spreadValues$S({}, this._strokeStyle);
        clone._stateStack = this._stateStack.slice();
        clone._bounds = this._bounds.clone();
        clone._boundsDirty = true;
        return clone;
      }
      /**
       * The current fill style of the graphics context. This can be a color, gradient, pattern, or a more complex style defined by a FillStyle object.
       */
      get fillStyle() {
        return this._fillStyle;
      }
      set fillStyle(value) {
        this._fillStyle = toFillStyle(value, _GraphicsContext.defaultFillStyle);
      }
      /**
       * The current stroke style of the graphics context. Similar to fill styles, stroke styles can encompass colors, gradients, patterns, or more detailed configurations via a StrokeStyle object.
       */
      get strokeStyle() {
        return this._strokeStyle;
      }
      set strokeStyle(value) {
        this._strokeStyle = toStrokeStyle(value, _GraphicsContext.defaultStrokeStyle);
      }
      /**
       * Sets the current fill style of the graphics context. The fill style can be a color, gradient,
       * pattern, or a more complex style defined by a FillStyle object.
       * @param style - The fill style to apply. This can be a simple color, a gradient or pattern object,
       *                or a FillStyle or ConvertedFillStyle object.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      setFillStyle(style) {
        this._fillStyle = toFillStyle(style, _GraphicsContext.defaultFillStyle);
        return this;
      }
      /**
       * Sets the current stroke style of the graphics context. Similar to fill styles, stroke styles can
       * encompass colors, gradients, patterns, or more detailed configurations via a StrokeStyle object.
       * @param style - The stroke style to apply. Can be defined as a color, a gradient or pattern,
       *                or a StrokeStyle or ConvertedStrokeStyle object.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      setStrokeStyle(style) {
        this._strokeStyle = toFillStyle(style, _GraphicsContext.defaultStrokeStyle);
        return this;
      }
      texture(texture, tint, dx, dy, dw, dh) {
        this.instructions.push({
          action: "texture",
          data: {
            image: texture,
            dx: dx || 0,
            dy: dy || 0,
            dw: dw || texture.frame.width,
            dh: dh || texture.frame.height,
            transform: this._transform.clone(),
            alpha: this._fillStyle.alpha,
            style: tint ? Color.shared.setValue(tint).toNumber() : 16777215
          }
        });
        this.onUpdate();
        return this;
      }
      /**
       * Resets the current path. Any previous path and its commands are discarded and a new path is
       * started. This is typically called before beginning a new shape or series of drawing commands.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      beginPath() {
        this._activePath = new GraphicsPath();
        return this;
      }
      fill(style, alpha) {
        let path;
        const lastInstruction = this.instructions[this.instructions.length - 1];
        if (this._tick === 0 && lastInstruction && lastInstruction.action === "stroke") {
          path = lastInstruction.data.path;
        } else {
          path = this._activePath.clone();
        }
        if (!path)
          return this;
        if (style != null) {
          if (alpha !== void 0 && typeof style === "number") {
            deprecation(v8_0_0, "GraphicsContext.fill(color, alpha) is deprecated, use GraphicsContext.fill({ color, alpha }) instead");
            style = { color: style, alpha };
          }
          this._fillStyle = toFillStyle(style, _GraphicsContext.defaultFillStyle);
        }
        this.instructions.push({
          action: "fill",
          // TODO copy fill style!
          data: { style: this.fillStyle, path }
        });
        this.onUpdate();
        this._initNextPathLocation();
        this._tick = 0;
        return this;
      }
      _initNextPathLocation() {
        const { x, y } = this._activePath.getLastPoint(Point.shared);
        this._activePath.clear();
        this._activePath.moveTo(x, y);
      }
      /**
       * Strokes the current path with the current stroke style. This method can take an optional
       * FillInput parameter to define the stroke's appearance, including its color, width, and other properties.
       * @param style - (Optional) The stroke style to apply. Can be defined as a simple color or a more complex style object. If omitted, uses the current stroke style.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      stroke(style) {
        let path;
        const lastInstruction = this.instructions[this.instructions.length - 1];
        if (this._tick === 0 && lastInstruction && lastInstruction.action === "fill") {
          path = lastInstruction.data.path;
        } else {
          path = this._activePath.clone();
        }
        if (!path)
          return this;
        if (style != null) {
          this._strokeStyle = toStrokeStyle(style, _GraphicsContext.defaultStrokeStyle);
        }
        this.instructions.push({
          action: "stroke",
          // TODO copy fill style!
          data: { style: this.strokeStyle, path }
        });
        this.onUpdate();
        this._initNextPathLocation();
        this._tick = 0;
        return this;
      }
      /**
       * Applies a cutout to the last drawn shape. This is used to create holes or complex shapes by
       * subtracting a path from the previously drawn path. If a hole is not completely in a shape, it will
       * fail to cut correctly!
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      cut() {
        for (let i = 0; i < 2; i++) {
          const lastInstruction = this.instructions[this.instructions.length - 1 - i];
          const holePath = this._activePath.clone();
          if (lastInstruction) {
            if (lastInstruction.action === "stroke" || lastInstruction.action === "fill") {
              if (lastInstruction.data.hole) {
                lastInstruction.data.hole.addPath(holePath);
              } else {
                lastInstruction.data.hole = holePath;
                break;
              }
            }
          }
        }
        this._initNextPathLocation();
        return this;
      }
      /**
       * Adds an arc to the current path, which is centered at (x, y) with the specified radius,
       * starting and ending angles, and direction.
       * @param x - The x-coordinate of the arc's center.
       * @param y - The y-coordinate of the arc's center.
       * @param radius - The arc's radius.
       * @param startAngle - The starting angle, in radians.
       * @param endAngle - The ending angle, in radians.
       * @param counterclockwise - (Optional) Specifies whether the arc is drawn counterclockwise (true) or clockwise (false). Defaults to false.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      arc(x, y, radius, startAngle, endAngle, counterclockwise) {
        this._tick++;
        const t = this._transform;
        this._activePath.arc(
          t.a * x + t.c * y + t.tx,
          t.b * x + t.d * y + t.ty,
          radius,
          startAngle,
          endAngle,
          counterclockwise
        );
        return this;
      }
      /**
       * Adds an arc to the current path with the given control points and radius, connected to the previous point
       * by a straight line if necessary.
       * @param x1 - The x-coordinate of the first control point.
       * @param y1 - The y-coordinate of the first control point.
       * @param x2 - The x-coordinate of the second control point.
       * @param y2 - The y-coordinate of the second control point.
       * @param radius - The arc's radius.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      arcTo(x1, y1, x2, y2, radius) {
        this._tick++;
        const t = this._transform;
        this._activePath.arcTo(
          t.a * x1 + t.c * y1 + t.tx,
          t.b * x1 + t.d * y1 + t.ty,
          t.a * x2 + t.c * y2 + t.tx,
          t.b * x2 + t.d * y2 + t.ty,
          radius
        );
        return this;
      }
      /**
       * Adds an SVG-style arc to the path, allowing for elliptical arcs based on the SVG spec.
       * @param rx - The x-radius of the ellipse.
       * @param ry - The y-radius of the ellipse.
       * @param xAxisRotation - The rotation of the ellipse's x-axis relative
       * to the x-axis of the coordinate system, in degrees.
       * @param largeArcFlag - Determines if the arc should be greater than or less than 180 degrees.
       * @param sweepFlag - Determines if the arc should be swept in a positive angle direction.
       * @param x - The x-coordinate of the arc's end point.
       * @param y - The y-coordinate of the arc's end point.
       * @returns The instance of the current object for chaining.
       */
      arcToSvg(rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y) {
        this._tick++;
        const t = this._transform;
        this._activePath.arcToSvg(
          rx,
          ry,
          xAxisRotation,
          // should we rotate this with transform??
          largeArcFlag,
          sweepFlag,
          t.a * x + t.c * y + t.tx,
          t.b * x + t.d * y + t.ty
        );
        return this;
      }
      /**
       * Adds a cubic Bezier curve to the path.
       * It requires three points: the first two are control points and the third one is the end point.
       * The starting point is the last point in the current path.
       * @param cp1x - The x-coordinate of the first control point.
       * @param cp1y - The y-coordinate of the first control point.
       * @param cp2x - The x-coordinate of the second control point.
       * @param cp2y - The y-coordinate of the second control point.
       * @param x - The x-coordinate of the end point.
       * @param y - The y-coordinate of the end point.
       * @param smoothness - Optional parameter to adjust the smoothness of the curve.
       * @returns The instance of the current object for chaining.
       */
      bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y, smoothness) {
        this._tick++;
        const t = this._transform;
        this._activePath.bezierCurveTo(
          t.a * cp1x + t.c * cp1y + t.tx,
          t.b * cp1x + t.d * cp1y + t.ty,
          t.a * cp2x + t.c * cp2y + t.tx,
          t.b * cp2x + t.d * cp2y + t.ty,
          t.a * x + t.c * y + t.tx,
          t.b * x + t.d * y + t.ty,
          smoothness
        );
        return this;
      }
      /**
       * Closes the current path by drawing a straight line back to the start.
       * If the shape is already closed or there are no points in the path, this method does nothing.
       * @returns The instance of the current object for chaining.
       */
      closePath() {
        var _a;
        this._tick++;
        (_a = this._activePath) == null ? void 0 : _a.closePath();
        return this;
      }
      /**
       * Draws an ellipse at the specified location and with the given x and y radii.
       * An optional transformation can be applied, allowing for rotation, scaling, and translation.
       * @param x - The x-coordinate of the center of the ellipse.
       * @param y - The y-coordinate of the center of the ellipse.
       * @param radiusX - The horizontal radius of the ellipse.
       * @param radiusY - The vertical radius of the ellipse.
       * @returns The instance of the current object for chaining.
       */
      ellipse(x, y, radiusX, radiusY) {
        this._tick++;
        this._activePath.ellipse(x, y, radiusX, radiusY, this._transform.clone());
        return this;
      }
      /**
       * Draws a circle shape. This method adds a new circle path to the current drawing.
       * @param x - The x-coordinate of the center of the circle.
       * @param y - The y-coordinate of the center of the circle.
       * @param radius - The radius of the circle.
       * @returns The instance of the current object for chaining.
       */
      circle(x, y, radius) {
        this._tick++;
        this._activePath.circle(x, y, radius, this._transform.clone());
        return this;
      }
      /**
       * Adds another `GraphicsPath` to this path, optionally applying a transformation.
       * @param path - The `GraphicsPath` to add.
       * @returns The instance of the current object for chaining.
       */
      path(path) {
        this._tick++;
        this._activePath.addPath(path, this._transform.clone());
        return this;
      }
      /**
       * Connects the current point to a new point with a straight line. This method updates the current path.
       * @param x - The x-coordinate of the new point to connect to.
       * @param y - The y-coordinate of the new point to connect to.
       * @returns The instance of the current object for chaining.
       */
      lineTo(x, y) {
        this._tick++;
        const t = this._transform;
        this._activePath.lineTo(
          t.a * x + t.c * y + t.tx,
          t.b * x + t.d * y + t.ty
        );
        return this;
      }
      /**
       * Sets the starting point for a new sub-path. Any subsequent drawing commands are considered part of this path.
       * @param x - The x-coordinate for the starting point.
       * @param y - The y-coordinate for the starting point.
       * @returns The instance of the current object for chaining.
       */
      moveTo(x, y) {
        this._tick++;
        const t = this._transform;
        const instructions = this._activePath.instructions;
        const transformedX = t.a * x + t.c * y + t.tx;
        const transformedY = t.b * x + t.d * y + t.ty;
        if (instructions.length === 1 && instructions[0].action === "moveTo") {
          instructions[0].data[0] = transformedX;
          instructions[0].data[1] = transformedY;
          return this;
        }
        this._activePath.moveTo(
          transformedX,
          transformedY
        );
        return this;
      }
      /**
       * Adds a quadratic curve to the path. It requires two points: the control point and the end point.
       * The starting point is the last point in the current path.
       * @param cpx - The x-coordinate of the control point.
       * @param cpy - The y-coordinate of the control point.
       * @param x - The x-coordinate of the end point.
       * @param y - The y-coordinate of the end point.
       * @param smoothness - Optional parameter to adjust the smoothness of the curve.
       * @returns The instance of the current object for chaining.
       */
      quadraticCurveTo(cpx, cpy, x, y, smoothness) {
        this._tick++;
        const t = this._transform;
        this._activePath.quadraticCurveTo(
          t.a * cpx + t.c * cpy + t.tx,
          t.b * cpx + t.d * cpy + t.ty,
          t.a * x + t.c * y + t.tx,
          t.b * x + t.d * y + t.ty,
          smoothness
        );
        return this;
      }
      /**
       * Draws a rectangle shape. This method adds a new rectangle path to the current drawing.
       * @param x - The x-coordinate of the top-left corner of the rectangle.
       * @param y - The y-coordinate of the top-left corner of the rectangle.
       * @param w - The width of the rectangle.
       * @param h - The height of the rectangle.
       * @returns The instance of the current object for chaining.
       */
      rect(x, y, w, h) {
        this._tick++;
        this._activePath.rect(x, y, w, h, this._transform.clone());
        return this;
      }
      /**
       * Draws a rectangle with rounded corners.
       * The corner radius can be specified to determine how rounded the corners should be.
       * An optional transformation can be applied, which allows for rotation, scaling, and translation of the rectangle.
       * @param x - The x-coordinate of the top-left corner of the rectangle.
       * @param y - The y-coordinate of the top-left corner of the rectangle.
       * @param w - The width of the rectangle.
       * @param h - The height of the rectangle.
       * @param radius - The radius of the rectangle's corners. If not specified, corners will be sharp.
       * @returns The instance of the current object for chaining.
       */
      roundRect(x, y, w, h, radius) {
        this._tick++;
        this._activePath.roundRect(x, y, w, h, radius, this._transform.clone());
        return this;
      }
      /**
       * Draws a polygon shape by specifying a sequence of points. This method allows for the creation of complex polygons,
       * which can be both open and closed. An optional transformation can be applied, enabling the polygon to be scaled,
       * rotated, or translated as needed.
       * @param points - An array of numbers, or an array of PointData objects eg [{x,y}, {x,y}, {x,y}]
       * representing the x and y coordinates, of the polygon's vertices, in sequence.
       * @param close - A boolean indicating whether to close the polygon path. True by default.
       */
      poly(points, close) {
        this._tick++;
        this._activePath.poly(points, close, this._transform.clone());
        return this;
      }
      /**
       * Draws a regular polygon with a specified number of sides. All sides and angles are equal.
       * @param x - The x-coordinate of the center of the polygon.
       * @param y - The y-coordinate of the center of the polygon.
       * @param radius - The radius of the circumscribed circle of the polygon.
       * @param sides - The number of sides of the polygon. Must be 3 or more.
       * @param rotation - The rotation angle of the polygon, in radians. Zero by default.
       * @param transform - An optional `Matrix` object to apply a transformation to the polygon.
       * @returns The instance of the current object for chaining.
       */
      regularPoly(x, y, radius, sides, rotation = 0, transform) {
        this._tick++;
        this._activePath.regularPoly(x, y, radius, sides, rotation, transform);
        return this;
      }
      /**
       * Draws a polygon with rounded corners.
       * Similar to `regularPoly` but with the ability to round the corners of the polygon.
       * @param x - The x-coordinate of the center of the polygon.
       * @param y - The y-coordinate of the center of the polygon.
       * @param radius - The radius of the circumscribed circle of the polygon.
       * @param sides - The number of sides of the polygon. Must be 3 or more.
       * @param corner - The radius of the rounding of the corners.
       * @param rotation - The rotation angle of the polygon, in radians. Zero by default.
       * @returns The instance of the current object for chaining.
       */
      roundPoly(x, y, radius, sides, corner, rotation) {
        this._tick++;
        this._activePath.roundPoly(x, y, radius, sides, corner, rotation);
        return this;
      }
      /**
       * Draws a shape with rounded corners. This function supports custom radius for each corner of the shape.
       * Optionally, corners can be rounded using a quadratic curve instead of an arc, providing a different aesthetic.
       * @param points - An array of `RoundedPoint` representing the corners of the shape to draw.
       * A minimum of 3 points is required.
       * @param radius - The default radius for the corners.
       * This radius is applied to all corners unless overridden in `points`.
       * @param useQuadratic - If set to true, rounded corners are drawn using a quadraticCurve
       *  method instead of an arc method. Defaults to false.
       * @param smoothness - Specifies the smoothness of the curve when `useQuadratic` is true.
       * Higher values make the curve smoother.
       * @returns The instance of the current object for chaining.
       */
      roundShape(points, radius, useQuadratic, smoothness) {
        this._tick++;
        this._activePath.roundShape(points, radius, useQuadratic, smoothness);
        return this;
      }
      /**
       * Draw Rectangle with fillet corners. This is much like rounded rectangle
       * however it support negative numbers as well for the corner radius.
       * @param x - Upper left corner of rect
       * @param y - Upper right corner of rect
       * @param width - Width of rect
       * @param height - Height of rect
       * @param fillet - accept negative or positive values
       */
      filletRect(x, y, width, height, fillet) {
        this._tick++;
        this._activePath.filletRect(x, y, width, height, fillet);
        return this;
      }
      /**
       * Draw Rectangle with chamfer corners. These are angled corners.
       * @param x - Upper left corner of rect
       * @param y - Upper right corner of rect
       * @param width - Width of rect
       * @param height - Height of rect
       * @param chamfer - non-zero real number, size of corner cutout
       * @param transform
       */
      chamferRect(x, y, width, height, chamfer, transform) {
        this._tick++;
        this._activePath.chamferRect(x, y, width, height, chamfer, transform);
        return this;
      }
      /**
       * Draws a star shape centered at a specified location. This method allows for the creation
       *  of stars with a variable number of points, outer radius, optional inner radius, and rotation.
       * The star is drawn as a closed polygon with alternating outer and inner vertices to create the star's points.
       * An optional transformation can be applied to scale, rotate, or translate the star as needed.
       * @param x - The x-coordinate of the center of the star.
       * @param y - The y-coordinate of the center of the star.
       * @param points - The number of points of the star.
       * @param radius - The outer radius of the star (distance from the center to the outer points).
       * @param innerRadius - Optional. The inner radius of the star
       * (distance from the center to the inner points between the outer points).
       * If not provided, defaults to half of the `radius`.
       * @param rotation - Optional. The rotation of the star in radians, where 0 is aligned with the y-axis.
       * Defaults to 0, meaning one point is directly upward.
       * @returns The instance of the current object for chaining further drawing commands.
       */
      star(x, y, points, radius, innerRadius = 0, rotation = 0) {
        this._tick++;
        this._activePath.star(x, y, points, radius, innerRadius, rotation, this._transform.clone());
        return this;
      }
      /**
       * Parses and renders an SVG string into the graphics context. This allows for complex shapes and paths
       * defined in SVG format to be drawn within the graphics context.
       * @param svg - The SVG string to be parsed and rendered.
       */
      svg(svg) {
        this._tick++;
        SVGParser(svg, this);
        return this;
      }
      /**
       * Restores the most recently saved graphics state by popping the top of the graphics state stack.
       * This includes transformations, fill styles, and stroke styles.
       */
      restore() {
        const state = this._stateStack.pop();
        if (state) {
          this._transform = state.transform;
          this._fillStyle = state.fillStyle;
          this._strokeStyle = state.strokeStyle;
        }
        return this;
      }
      /** Saves the current graphics state, including transformations, fill styles, and stroke styles, onto a stack. */
      save() {
        this._stateStack.push({
          transform: this._transform.clone(),
          fillStyle: __spreadValues$S({}, this._fillStyle),
          strokeStyle: __spreadValues$S({}, this._strokeStyle)
        });
        return this;
      }
      /**
       * Returns the current transformation matrix of the graphics context.
       * @returns The current transformation matrix.
       */
      getTransform() {
        return this._transform;
      }
      /**
       * Resets the current transformation matrix to the identity matrix, effectively removing any transformations (rotation, scaling, translation) previously applied.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      resetTransform() {
        this._transform.identity();
        return this;
      }
      /**
       * Applies a rotation transformation to the graphics context around the current origin.
       * @param angle - The angle of rotation in radians.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      rotate(angle) {
        this._transform.rotate(angle);
        return this;
      }
      /**
       * Applies a scaling transformation to the graphics context, scaling drawings by x horizontally and by y vertically.
       * @param x - The scale factor in the horizontal direction.
       * @param y - (Optional) The scale factor in the vertical direction. If not specified, the x value is used for both directions.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      scale(x, y = x) {
        this._transform.scale(x, y);
        return this;
      }
      setTransform(a, b, c, d, dx, dy) {
        if (a instanceof Matrix) {
          this._transform.set(a.a, a.b, a.c, a.d, a.tx, a.ty);
          return this;
        }
        this._transform.set(a, b, c, d, dx, dy);
        return this;
      }
      transform(a, b, c, d, dx, dy) {
        if (a instanceof Matrix) {
          this._transform.append(a);
          return this;
        }
        tempMatrix$4.set(a, b, c, d, dx, dy);
        this._transform.append(tempMatrix$4);
        return this;
      }
      /**
       * Applies a translation transformation to the graphics context, moving the origin by the specified amounts.
       * @param x - The amount to translate in the horizontal direction.
       * @param y - (Optional) The amount to translate in the vertical direction. If not specified, the x value is used for both directions.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      translate(x, y = x) {
        this._transform.translate(x, y);
        return this;
      }
      /**
       * Clears all drawing commands from the graphics context, effectively resetting it. This includes clearing the path,
       * and optionally resetting transformations to the identity matrix.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      clear() {
        this._activePath.clear();
        this.instructions.length = 0;
        this.resetTransform();
        this.onUpdate();
        return this;
      }
      onUpdate() {
        if (this.dirty)
          return;
        this.emit("update", this, 16);
        this.dirty = true;
        this._boundsDirty = true;
      }
      /** The bounds of the graphic shape. */
      get bounds() {
        if (!this._boundsDirty)
          return this._bounds;
        const bounds = this._bounds;
        bounds.clear();
        for (let i = 0; i < this.instructions.length; i++) {
          const instruction = this.instructions[i];
          const action = instruction.action;
          if (action === "fill") {
            const data = instruction.data;
            bounds.addBounds(data.path.bounds);
          } else if (action === "texture") {
            const data = instruction.data;
            bounds.addFrame(data.dx, data.dy, data.dx + data.dw, data.dy + data.dh, data.transform);
          }
          if (action === "stroke") {
            const data = instruction.data;
            const alignment = data.style.alignment;
            const padding = data.style.width * (1 - alignment);
            const _bounds = data.path.bounds;
            bounds.addFrame(
              _bounds.minX - padding,
              _bounds.minY - padding,
              _bounds.maxX + padding,
              _bounds.maxY + padding
            );
          }
        }
        return bounds;
      }
      /**
       * Check to see if a point is contained within this geometry.
       * @param point - Point to check if it's contained.
       * @returns {boolean} `true` if the point is contained within geometry.
       */
      containsPoint(point) {
        var _a;
        if (!this.bounds.containsPoint(point.x, point.y))
          return false;
        const instructions = this.instructions;
        let hasHit = false;
        for (let k = 0; k < instructions.length; k++) {
          const instruction = instructions[k];
          const data = instruction.data;
          const path = data.path;
          if (!instruction.action || !path)
            continue;
          const style = data.style;
          const shapes = path.shapePath.shapePrimitives;
          for (let i = 0; i < shapes.length; i++) {
            const shape = shapes[i].shape;
            if (!style || !shape)
              continue;
            const transform = shapes[i].transform;
            const transformedPoint = transform ? transform.applyInverse(point, tmpPoint) : point;
            if (instruction.action === "fill") {
              hasHit = shape.contains(transformedPoint.x, transformedPoint.y);
            } else {
              hasHit = shape.strokeContains(transformedPoint.x, transformedPoint.y, style.width);
            }
            const holes = data.hole;
            if (holes) {
              const holeShapes = (_a = holes.shapePath) == null ? void 0 : _a.shapePrimitives;
              if (holeShapes) {
                for (let j = 0; j < holeShapes.length; j++) {
                  if (holeShapes[j].shape.contains(transformedPoint.x, transformedPoint.y)) {
                    hasHit = false;
                  }
                }
              }
            }
            if (hasHit) {
              return true;
            }
          }
        }
        return hasHit;
      }
      /**
       * Destroys the GraphicsData object.
       * @param options - Options parameter. A boolean will act as if all options
       *  have been set to that value
       * @param {boolean} [options.texture=false] - Should it destroy the current texture of the fill/stroke style?
       * @param {boolean} [options.textureSource=false] - Should it destroy the texture source of the fill/stroke style?
       */
      destroy(options = false) {
        this._stateStack.length = 0;
        this._transform = null;
        this.emit("destroy", this);
        this.removeAllListeners();
        const destroyTexture = typeof options === "boolean" ? options : options == null ? void 0 : options.texture;
        if (destroyTexture) {
          const destroyTextureSource = typeof options === "boolean" ? options : options == null ? void 0 : options.textureSource;
          if (this._fillStyle.texture) {
            this._fillStyle.texture.destroy(destroyTextureSource);
          }
          if (this._strokeStyle.texture) {
            this._strokeStyle.texture.destroy(destroyTextureSource);
          }
        }
        this._fillStyle = null;
        this._strokeStyle = null;
        this.instructions = null;
        this._activePath = null;
        this._bounds = null;
        this._stateStack = null;
        this.customShader = null;
        this._transform = null;
      }
    };
    /** The default fill style to use when none is provided. */
    _GraphicsContext.defaultFillStyle = {
      /** The color to use for the fill. */
      color: 16777215,
      /** The alpha value to use for the fill. */
      alpha: 1,
      /** The texture to use for the fill. */
      texture: Texture.WHITE,
      /** The matrix to apply. */
      matrix: null,
      /** The fill pattern to use. */
      fill: null
    };
    /** The default stroke style to use when none is provided. */
    _GraphicsContext.defaultStrokeStyle = {
      /** The width of the stroke. */
      width: 1,
      /** The color to use for the stroke. */
      color: 16777215,
      /** The alpha value to use for the stroke. */
      alpha: 1,
      /** The alignment of the stroke. */
      alignment: 0.5,
      /** The miter limit to use. */
      miterLimit: 10,
      /** The line cap style to use. */
      cap: "butt",
      /** The line join style to use. */
      join: "miter",
      /** The texture to use for the fill. */
      texture: Texture.WHITE,
      /** The matrix to apply. */
      matrix: null,
      /** The fill pattern to use. */
      fill: null,
      /** If the stroke is a pixel line. */
      pixelLine: false
    };
    let GraphicsContext = _GraphicsContext;

    "use strict";
    const valuesToIterateForKeys = [
      "align",
      "breakWords",
      "cssOverrides",
      "fontVariant",
      "fontWeight",
      "leading",
      "letterSpacing",
      "lineHeight",
      "padding",
      "textBaseline",
      "trim",
      "whiteSpace",
      "wordWrap",
      "wordWrapWidth",
      "fontFamily",
      "fontStyle",
      "fontSize"
    ];
    function generateTextStyleKey(style) {
      const key = [];
      let index = 0;
      for (let i = 0; i < valuesToIterateForKeys.length; i++) {
        const prop = `_${valuesToIterateForKeys[i]}`;
        key[index++] = style[prop];
      }
      index = addFillStyleKey(style._fill, key, index);
      index = addStokeStyleKey(style._stroke, key, index);
      index = addDropShadowKey(style.dropShadow, key, index);
      return key.join("-");
    }
    function addFillStyleKey(fillStyle, key, index) {
      var _a;
      if (!fillStyle)
        return index;
      key[index++] = fillStyle.color;
      key[index++] = fillStyle.alpha;
      key[index++] = (_a = fillStyle.fill) == null ? void 0 : _a.styleKey;
      return index;
    }
    function addStokeStyleKey(strokeStyle, key, index) {
      if (!strokeStyle)
        return index;
      index = addFillStyleKey(strokeStyle, key, index);
      key[index++] = strokeStyle.width;
      key[index++] = strokeStyle.alignment;
      key[index++] = strokeStyle.cap;
      key[index++] = strokeStyle.join;
      key[index++] = strokeStyle.miterLimit;
      return index;
    }
    function addDropShadowKey(dropShadow, key, index) {
      if (!dropShadow)
        return index;
      key[index++] = dropShadow.alpha;
      key[index++] = dropShadow.angle;
      key[index++] = dropShadow.blur;
      key[index++] = dropShadow.distance;
      key[index++] = Color.shared.setValue(dropShadow.color).toNumber();
      return index;
    }

    "use strict";
    var __defProp$R = Object.defineProperty;
    var __defProps$m = Object.defineProperties;
    var __getOwnPropDescs$m = Object.getOwnPropertyDescriptors;
    var __getOwnPropSymbols$R = Object.getOwnPropertySymbols;
    var __hasOwnProp$R = Object.prototype.hasOwnProperty;
    var __propIsEnum$R = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$R = (obj, key, value) => key in obj ? __defProp$R(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$R = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$R.call(b, prop))
          __defNormalProp$R(a, prop, b[prop]);
      if (__getOwnPropSymbols$R)
        for (var prop of __getOwnPropSymbols$R(b)) {
          if (__propIsEnum$R.call(b, prop))
            __defNormalProp$R(a, prop, b[prop]);
        }
      return a;
    };
    var __spreadProps$m = (a, b) => __defProps$m(a, __getOwnPropDescs$m(b));
    const _TextStyle = class _TextStyle extends EventEmitter {
      constructor(style = {}) {
        super();
        convertV7Tov8Style(style);
        const fullStyle = __spreadValues$R(__spreadValues$R({}, _TextStyle.defaultTextStyle), style);
        for (const key in fullStyle) {
          const thisKey = key;
          this[thisKey] = fullStyle[key];
        }
        this.update();
      }
      /**
       * Alignment for multiline text, does not affect single line text.
       * @member {'left'|'center'|'right'|'justify'}
       */
      get align() {
        return this._align;
      }
      set align(value) {
        this._align = value;
        this.update();
      }
      /** Indicates if lines can be wrapped within words, it needs wordWrap to be set to true. */
      get breakWords() {
        return this._breakWords;
      }
      set breakWords(value) {
        this._breakWords = value;
        this.update();
      }
      /** Set a drop shadow for the text. */
      get dropShadow() {
        return this._dropShadow;
      }
      set dropShadow(value) {
        if (value !== null && typeof value === "object") {
          this._dropShadow = this._createProxy(__spreadValues$R(__spreadValues$R({}, _TextStyle.defaultDropShadow), value));
        } else {
          this._dropShadow = value ? this._createProxy(__spreadValues$R({}, _TextStyle.defaultDropShadow)) : null;
        }
        this.update();
      }
      /** The font family, can be a single font name, or a list of names where the first is the preferred font. */
      get fontFamily() {
        return this._fontFamily;
      }
      set fontFamily(value) {
        this._fontFamily = value;
        this.update();
      }
      /** The font size (as a number it converts to px, but as a string, equivalents are '26px','20pt','160%' or '1.6em') */
      get fontSize() {
        return this._fontSize;
      }
      set fontSize(value) {
        if (typeof value === "string") {
          this._fontSize = parseInt(value, 10);
        } else {
          this._fontSize = value;
        }
        this.update();
      }
      /**
       * The font style.
       * @member {'normal'|'italic'|'oblique'}
       */
      get fontStyle() {
        return this._fontStyle;
      }
      set fontStyle(value) {
        this._fontStyle = value.toLowerCase();
        this.update();
      }
      /**
       * The font variant.
       * @member {'normal'|'small-caps'}
       */
      get fontVariant() {
        return this._fontVariant;
      }
      set fontVariant(value) {
        this._fontVariant = value;
        this.update();
      }
      /**
       * The font weight.
       * @member {'normal'|'bold'|'bolder'|'lighter'|'100'|'200'|'300'|'400'|'500'|'600'|'700'|'800'|'900'}
       */
      get fontWeight() {
        return this._fontWeight;
      }
      set fontWeight(value) {
        this._fontWeight = value;
        this.update();
      }
      /** The space between lines. */
      get leading() {
        return this._leading;
      }
      set leading(value) {
        this._leading = value;
        this.update();
      }
      /** The amount of spacing between letters, default is 0. */
      get letterSpacing() {
        return this._letterSpacing;
      }
      set letterSpacing(value) {
        this._letterSpacing = value;
        this.update();
      }
      /** The line height, a number that represents the vertical space that a letter uses. */
      get lineHeight() {
        return this._lineHeight;
      }
      set lineHeight(value) {
        this._lineHeight = value;
        this.update();
      }
      /**
       * Occasionally some fonts are cropped. Adding some padding will prevent this from happening
       * by adding padding to all sides of the text.
       */
      get padding() {
        return this._padding;
      }
      set padding(value) {
        this._padding = value;
        this.update();
      }
      /** Trim transparent borders. This is an expensive operation so only use this if you have to! */
      get trim() {
        return this._trim;
      }
      set trim(value) {
        this._trim = value;
        this.update();
      }
      /**
       * The baseline of the text that is rendered.
       * @member {'alphabetic'|'top'|'hanging'|'middle'|'ideographic'|'bottom'}
       */
      get textBaseline() {
        return this._textBaseline;
      }
      set textBaseline(value) {
        this._textBaseline = value;
        this.update();
      }
      /**
       * How newlines and spaces should be handled.
       * Default is 'pre' (preserve, preserve).
       *
       *  value       | New lines     |   Spaces
       *  ---         | ---           |   ---
       * 'normal'     | Collapse      |   Collapse
       * 'pre'        | Preserve      |   Preserve
       * 'pre-line'   | Preserve      |   Collapse
       * @member {'normal'|'pre'|'pre-line'}
       */
      get whiteSpace() {
        return this._whiteSpace;
      }
      set whiteSpace(value) {
        this._whiteSpace = value;
        this.update();
      }
      /** Indicates if word wrap should be used. */
      get wordWrap() {
        return this._wordWrap;
      }
      set wordWrap(value) {
        this._wordWrap = value;
        this.update();
      }
      /** The width at which text will wrap, it needs wordWrap to be set to true. */
      get wordWrapWidth() {
        return this._wordWrapWidth;
      }
      set wordWrapWidth(value) {
        this._wordWrapWidth = value;
        this.update();
      }
      /** A fillstyle that will be used on the text e.g., 'red', '#00FF00'. */
      get fill() {
        return this._originalFill;
      }
      set fill(value) {
        if (value === this._originalFill)
          return;
        this._originalFill = value;
        if (this._isFillStyle(value)) {
          this._originalFill = this._createProxy(__spreadValues$R(__spreadValues$R({}, GraphicsContext.defaultFillStyle), value), () => {
            this._fill = toFillStyle(
              __spreadValues$R({}, this._originalFill),
              GraphicsContext.defaultFillStyle
            );
          });
        }
        this._fill = toFillStyle(
          value === 0 ? "black" : value,
          GraphicsContext.defaultFillStyle
        );
        this.update();
      }
      /** A fillstyle that will be used on the text stroke, e.g., 'blue', '#FCFF00'. */
      get stroke() {
        return this._originalStroke;
      }
      set stroke(value) {
        if (value === this._originalStroke)
          return;
        this._originalStroke = value;
        if (this._isFillStyle(value)) {
          this._originalStroke = this._createProxy(__spreadValues$R(__spreadValues$R({}, GraphicsContext.defaultStrokeStyle), value), () => {
            this._stroke = toStrokeStyle(
              __spreadValues$R({}, this._originalStroke),
              GraphicsContext.defaultStrokeStyle
            );
          });
        }
        this._stroke = toStrokeStyle(value, GraphicsContext.defaultStrokeStyle);
        this.update();
      }
      _generateKey() {
        this._styleKey = generateTextStyleKey(this);
        return this._styleKey;
      }
      update() {
        this._styleKey = null;
        this.emit("update", this);
      }
      /** Resets all properties to the default values */
      reset() {
        const defaultStyle = _TextStyle.defaultTextStyle;
        for (const key in defaultStyle) {
          this[key] = defaultStyle[key];
        }
      }
      get styleKey() {
        return this._styleKey || this._generateKey();
      }
      /**
       * Creates a new TextStyle object with the same values as this one.
       * @returns New cloned TextStyle object
       */
      clone() {
        return new _TextStyle({
          align: this.align,
          breakWords: this.breakWords,
          dropShadow: this._dropShadow ? __spreadValues$R({}, this._dropShadow) : null,
          fill: this._fill,
          fontFamily: this.fontFamily,
          fontSize: this.fontSize,
          fontStyle: this.fontStyle,
          fontVariant: this.fontVariant,
          fontWeight: this.fontWeight,
          leading: this.leading,
          letterSpacing: this.letterSpacing,
          lineHeight: this.lineHeight,
          padding: this.padding,
          stroke: this._stroke,
          textBaseline: this.textBaseline,
          whiteSpace: this.whiteSpace,
          wordWrap: this.wordWrap,
          wordWrapWidth: this.wordWrapWidth
        });
      }
      /**
       * Destroys this text style.
       * @param options - Options parameter. A boolean will act as if all options
       *  have been set to that value
       * @param {boolean} [options.texture=false] - Should it destroy the texture of the this style
       * @param {boolean} [options.textureSource=false] - Should it destroy the textureSource of the this style
       */
      destroy(options = false) {
        var _a, _b, _c, _d;
        this.removeAllListeners();
        const destroyTexture = typeof options === "boolean" ? options : options == null ? void 0 : options.texture;
        if (destroyTexture) {
          const destroyTextureSource = typeof options === "boolean" ? options : options == null ? void 0 : options.textureSource;
          if ((_a = this._fill) == null ? void 0 : _a.texture) {
            this._fill.texture.destroy(destroyTextureSource);
          }
          if ((_b = this._originalFill) == null ? void 0 : _b.texture) {
            this._originalFill.texture.destroy(destroyTextureSource);
          }
          if ((_c = this._stroke) == null ? void 0 : _c.texture) {
            this._stroke.texture.destroy(destroyTextureSource);
          }
          if ((_d = this._originalStroke) == null ? void 0 : _d.texture) {
            this._originalStroke.texture.destroy(destroyTextureSource);
          }
        }
        this._fill = null;
        this._stroke = null;
        this.dropShadow = null;
        this._originalStroke = null;
        this._originalFill = null;
      }
      _createProxy(value, cb) {
        return new Proxy(value, {
          set: (target, property, newValue) => {
            target[property] = newValue;
            cb == null ? void 0 : cb(property, newValue);
            this.update();
            return true;
          }
        });
      }
      _isFillStyle(value) {
        return (value != null ? value : null) !== null && !(Color.isColorLike(value) || value instanceof FillGradient || value instanceof FillPattern);
      }
    };
    /** The default drop shadow settings */
    _TextStyle.defaultDropShadow = {
      /** Set alpha for the drop shadow */
      alpha: 1,
      /** Set a angle of the drop shadow */
      angle: Math.PI / 6,
      /** Set a shadow blur radius */
      blur: 0,
      /** A fill style to be used on the  e.g., 'red', '#00FF00' */
      color: "black",
      /** Set a distance of the drop shadow */
      distance: 5
    };
    /** The default text style settings */
    _TextStyle.defaultTextStyle = {
      /**
       * See {@link TextStyle.align}
       * @type {'left'|'center'|'right'|'justify'}
       */
      align: "left",
      /** See {@link TextStyle.breakWords} */
      breakWords: false,
      /** See {@link TextStyle.dropShadow} */
      dropShadow: null,
      /**
       * See {@link TextStyle.fill}
       * @type {string|string[]|number|number[]|CanvasGradient|CanvasPattern}
       */
      fill: "black",
      /**
       * See {@link TextStyle.fontFamily}
       * @type {string|string[]}
       */
      fontFamily: "Arial",
      /**
       * See {@link TextStyle.fontSize}
       * @type {number|string}
       */
      fontSize: 26,
      /**
       * See {@link TextStyle.fontStyle}
       * @type {'normal'|'italic'|'oblique'}
       */
      fontStyle: "normal",
      /**
       * See {@link TextStyle.fontVariant}
       * @type {'normal'|'small-caps'}
       */
      fontVariant: "normal",
      /**
       * See {@link TextStyle.fontWeight}
       * @type {'normal'|'bold'|'bolder'|'lighter'|'100'|'200'|'300'|'400'|'500'|'600'|'700'|'800'|'900'}
       */
      fontWeight: "normal",
      /** See {@link TextStyle.leading} */
      leading: 0,
      /** See {@link TextStyle.letterSpacing} */
      letterSpacing: 0,
      /** See {@link TextStyle.lineHeight} */
      lineHeight: 0,
      /** See {@link TextStyle.padding} */
      padding: 0,
      /**
       * See {@link TextStyle.stroke}
       * @type {string|number}
       */
      stroke: null,
      /**
       * See {@link TextStyle.textBaseline}
       * @type {'alphabetic'|'top'|'hanging'|'middle'|'ideographic'|'bottom'}
       */
      textBaseline: "alphabetic",
      /** See {@link TextStyle.trim} */
      trim: false,
      /**
       * See {@link TextStyle.whiteSpace}
       * @type {'normal'|'pre'|'pre-line'}
       */
      whiteSpace: "pre",
      /** See {@link TextStyle.wordWrap} */
      wordWrap: false,
      /** See {@link TextStyle.wordWrapWidth} */
      wordWrapWidth: 100
    };
    let TextStyle = _TextStyle;
    function convertV7Tov8Style(style) {
      var _a, _b, _c, _d, _e;
      const oldStyle = style;
      if (typeof oldStyle.dropShadow === "boolean" && oldStyle.dropShadow) {
        const defaults = TextStyle.defaultDropShadow;
        style.dropShadow = {
          alpha: (_a = oldStyle.dropShadowAlpha) != null ? _a : defaults.alpha,
          angle: (_b = oldStyle.dropShadowAngle) != null ? _b : defaults.angle,
          blur: (_c = oldStyle.dropShadowBlur) != null ? _c : defaults.blur,
          color: (_d = oldStyle.dropShadowColor) != null ? _d : defaults.color,
          distance: (_e = oldStyle.dropShadowDistance) != null ? _e : defaults.distance
        };
      }
      if (oldStyle.strokeThickness !== void 0) {
        deprecation(v8_0_0, "strokeThickness is now a part of stroke");
        const color = oldStyle.stroke;
        let obj = {};
        if (Color.isColorLike(color)) {
          obj.color = color;
        } else if (color instanceof FillGradient || color instanceof FillPattern) {
          obj.fill = color;
        } else if (Object.hasOwnProperty.call(color, "color") || Object.hasOwnProperty.call(color, "fill")) {
          obj = color;
        } else {
          throw new Error("Invalid stroke value.");
        }
        style.stroke = __spreadProps$m(__spreadValues$R({}, obj), {
          width: oldStyle.strokeThickness
        });
      }
      if (Array.isArray(oldStyle.fillGradientStops)) {
        deprecation(v8_0_0, "gradient fill is now a fill pattern: `new FillGradient(...)`");
        let fontSize;
        if (style.fontSize == null) {
          style.fontSize = TextStyle.defaultTextStyle.fontSize;
        } else if (typeof style.fontSize === "string") {
          fontSize = parseInt(style.fontSize, 10);
        } else {
          fontSize = style.fontSize;
        }
        const gradientFill = new FillGradient(0, 0, 0, fontSize * 1.7);
        const fills = oldStyle.fillGradientStops.map((color) => Color.shared.setValue(color).toNumber());
        fills.forEach((number, index) => {
          const ratio = index / (fills.length - 1);
          gradientFill.addColorStop(ratio, number);
        });
        style.fill = {
          fill: gradientFill
        };
      }
    }

    "use strict";
    const tempBounds$3 = new Bounds();
    function getPo2TextureFromSource(image, width, height, resolution) {
      const bounds = tempBounds$3;
      bounds.minX = 0;
      bounds.minY = 0;
      bounds.maxX = image.width / resolution | 0;
      bounds.maxY = image.height / resolution | 0;
      const texture = TexturePool.getOptimalTexture(
        bounds.width,
        bounds.height,
        resolution,
        false
      );
      texture.source.uploadMethodId = "image";
      texture.source.resource = image;
      texture.source.alphaMode = "premultiply-alpha-on-upload";
      texture.frame.width = width / resolution;
      texture.frame.height = height / resolution;
      texture.source.emit("update", texture.source);
      texture.updateUvs();
      return texture;
    }

    "use strict";
    const genericFontFamilies = [
      "serif",
      "sans-serif",
      "monospace",
      "cursive",
      "fantasy",
      "system-ui"
    ];
    function fontStringFromTextStyle(style) {
      const fontSizeString = typeof style.fontSize === "number" ? `${style.fontSize}px` : style.fontSize;
      let fontFamilies = style.fontFamily;
      if (!Array.isArray(style.fontFamily)) {
        fontFamilies = style.fontFamily.split(",");
      }
      for (let i = fontFamilies.length - 1; i >= 0; i--) {
        let fontFamily = fontFamilies[i].trim();
        if (!/([\"\'])[^\'\"]+\1/.test(fontFamily) && !genericFontFamilies.includes(fontFamily)) {
          fontFamily = `"${fontFamily}"`;
        }
        fontFamilies[i] = fontFamily;
      }
      return `${style.fontStyle} ${style.fontVariant} ${style.fontWeight} ${fontSizeString} ${fontFamilies.join(",")}`;
    }

    "use strict";
    const contextSettings = {
      // TextMetrics requires getImageData readback for measuring fonts.
      willReadFrequently: true
    };
    const _CanvasTextMetrics = class _CanvasTextMetrics {
      /**
       * Checking that we can use modern canvas 2D API.
       *
       * Note: This is an unstable API, Chrome < 94 use `textLetterSpacing`, later versions use `letterSpacing`.
       * @see TextMetrics.experimentalLetterSpacing
       * @see https://developer.mozilla.org/en-US/docs/Web/API/ICanvasRenderingContext2D/letterSpacing
       * @see https://developer.chrome.com/origintrials/#/view_trial/3585991203293757441
       */
      static get experimentalLetterSpacingSupported() {
        let result = _CanvasTextMetrics._experimentalLetterSpacingSupported;
        if (result !== void 0) {
          const proto = DOMAdapter.get().getCanvasRenderingContext2D().prototype;
          result = _CanvasTextMetrics._experimentalLetterSpacingSupported = "letterSpacing" in proto || "textLetterSpacing" in proto;
        }
        return result;
      }
      /**
       * @param text - the text that was measured
       * @param style - the style that was measured
       * @param width - the measured width of the text
       * @param height - the measured height of the text
       * @param lines - an array of the lines of text broken by new lines and wrapping if specified in style
       * @param lineWidths - an array of the line widths for each line matched to `lines`
       * @param lineHeight - the measured line height for this style
       * @param maxLineWidth - the maximum line width for all measured lines
       * @param {FontMetrics} fontProperties - the font properties object from TextMetrics.measureFont
       */
      constructor(text, style, width, height, lines, lineWidths, lineHeight, maxLineWidth, fontProperties) {
        this.text = text;
        this.style = style;
        this.width = width;
        this.height = height;
        this.lines = lines;
        this.lineWidths = lineWidths;
        this.lineHeight = lineHeight;
        this.maxLineWidth = maxLineWidth;
        this.fontProperties = fontProperties;
      }
      /**
       * Measures the supplied string of text and returns a Rectangle.
       * @param text - The text to measure.
       * @param style - The text style to use for measuring
       * @param canvas - optional specification of the canvas to use for measuring.
       * @param wordWrap
       * @returns Measured width and height of the text.
       */
      static measureText(text = " ", style, canvas = _CanvasTextMetrics._canvas, wordWrap = style.wordWrap) {
        var _a;
        const textKey = `${text}:${style.styleKey}`;
        if (_CanvasTextMetrics._measurementCache[textKey])
          return _CanvasTextMetrics._measurementCache[textKey];
        const font = fontStringFromTextStyle(style);
        const fontProperties = _CanvasTextMetrics.measureFont(font);
        if (fontProperties.fontSize === 0) {
          fontProperties.fontSize = style.fontSize;
          fontProperties.ascent = style.fontSize;
        }
        const context = _CanvasTextMetrics.__context;
        context.font = font;
        const outputText = wordWrap ? _CanvasTextMetrics._wordWrap(text, style, canvas) : text;
        const lines = outputText.split(/(?:\r\n|\r|\n)/);
        const lineWidths = new Array(lines.length);
        let maxLineWidth = 0;
        for (let i = 0; i < lines.length; i++) {
          const lineWidth = _CanvasTextMetrics._measureText(lines[i], style.letterSpacing, context);
          lineWidths[i] = lineWidth;
          maxLineWidth = Math.max(maxLineWidth, lineWidth);
        }
        const strokeWidth = ((_a = style._stroke) == null ? void 0 : _a.width) || 0;
        let width = maxLineWidth + strokeWidth;
        if (style.dropShadow) {
          width += style.dropShadow.distance;
        }
        const lineHeight = style.lineHeight || fontProperties.fontSize;
        let height = Math.max(lineHeight, fontProperties.fontSize + strokeWidth) + (lines.length - 1) * (lineHeight + style.leading);
        if (style.dropShadow) {
          height += style.dropShadow.distance;
        }
        const measurements = new _CanvasTextMetrics(
          text,
          style,
          width,
          height,
          lines,
          lineWidths,
          lineHeight + style.leading,
          maxLineWidth,
          fontProperties
        );
        return measurements;
      }
      static _measureText(text, letterSpacing, context) {
        let useExperimentalLetterSpacing = false;
        if (_CanvasTextMetrics.experimentalLetterSpacingSupported) {
          if (_CanvasTextMetrics.experimentalLetterSpacing) {
            context.letterSpacing = `${letterSpacing}px`;
            context.textLetterSpacing = `${letterSpacing}px`;
            useExperimentalLetterSpacing = true;
          } else {
            context.letterSpacing = "0px";
            context.textLetterSpacing = "0px";
          }
        }
        const metrics = context.measureText(text);
        let metricWidth = metrics.width;
        const actualBoundingBoxLeft = -metrics.actualBoundingBoxLeft;
        const actualBoundingBoxRight = metrics.actualBoundingBoxRight;
        let boundsWidth = actualBoundingBoxRight - actualBoundingBoxLeft;
        if (metricWidth > 0) {
          if (useExperimentalLetterSpacing) {
            metricWidth -= letterSpacing;
            boundsWidth -= letterSpacing;
          } else {
            const val = (_CanvasTextMetrics.graphemeSegmenter(text).length - 1) * letterSpacing;
            metricWidth += val;
            boundsWidth += val;
          }
        }
        return Math.max(metricWidth, boundsWidth);
      }
      /**
       * Applies newlines to a string to have it optimally fit into the horizontal
       * bounds set by the Text object's wordWrapWidth property.
       * @param text - String to apply word wrapping to
       * @param style - the style to use when wrapping
       * @param canvas - optional specification of the canvas to use for measuring.
       * @returns New string with new lines applied where required
       */
      static _wordWrap(text, style, canvas = _CanvasTextMetrics._canvas) {
        const context = canvas.getContext("2d", contextSettings);
        let width = 0;
        let line = "";
        let lines = "";
        const cache = /* @__PURE__ */ Object.create(null);
        const { letterSpacing, whiteSpace } = style;
        const collapseSpaces = _CanvasTextMetrics._collapseSpaces(whiteSpace);
        const collapseNewlines = _CanvasTextMetrics._collapseNewlines(whiteSpace);
        let canPrependSpaces = !collapseSpaces;
        const wordWrapWidth = style.wordWrapWidth + letterSpacing;
        const tokens = _CanvasTextMetrics._tokenize(text);
        for (let i = 0; i < tokens.length; i++) {
          let token = tokens[i];
          if (_CanvasTextMetrics._isNewline(token)) {
            if (!collapseNewlines) {
              lines += _CanvasTextMetrics._addLine(line);
              canPrependSpaces = !collapseSpaces;
              line = "";
              width = 0;
              continue;
            }
            token = " ";
          }
          if (collapseSpaces) {
            const currIsBreakingSpace = _CanvasTextMetrics.isBreakingSpace(token);
            const lastIsBreakingSpace = _CanvasTextMetrics.isBreakingSpace(line[line.length - 1]);
            if (currIsBreakingSpace && lastIsBreakingSpace) {
              continue;
            }
          }
          const tokenWidth = _CanvasTextMetrics._getFromCache(token, letterSpacing, cache, context);
          if (tokenWidth > wordWrapWidth) {
            if (line !== "") {
              lines += _CanvasTextMetrics._addLine(line);
              line = "";
              width = 0;
            }
            if (_CanvasTextMetrics.canBreakWords(token, style.breakWords)) {
              const characters = _CanvasTextMetrics.wordWrapSplit(token);
              for (let j = 0; j < characters.length; j++) {
                let char = characters[j];
                let lastChar = char;
                let k = 1;
                while (characters[j + k]) {
                  const nextChar = characters[j + k];
                  if (!_CanvasTextMetrics.canBreakChars(lastChar, nextChar, token, j, style.breakWords)) {
                    char += nextChar;
                  } else {
                    break;
                  }
                  lastChar = nextChar;
                  k++;
                }
                j += k - 1;
                const characterWidth = _CanvasTextMetrics._getFromCache(char, letterSpacing, cache, context);
                if (characterWidth + width > wordWrapWidth) {
                  lines += _CanvasTextMetrics._addLine(line);
                  canPrependSpaces = false;
                  line = "";
                  width = 0;
                }
                line += char;
                width += characterWidth;
              }
            } else {
              if (line.length > 0) {
                lines += _CanvasTextMetrics._addLine(line);
                line = "";
                width = 0;
              }
              const isLastToken = i === tokens.length - 1;
              lines += _CanvasTextMetrics._addLine(token, !isLastToken);
              canPrependSpaces = false;
              line = "";
              width = 0;
            }
          } else {
            if (tokenWidth + width > wordWrapWidth) {
              canPrependSpaces = false;
              lines += _CanvasTextMetrics._addLine(line);
              line = "";
              width = 0;
            }
            if (line.length > 0 || !_CanvasTextMetrics.isBreakingSpace(token) || canPrependSpaces) {
              line += token;
              width += tokenWidth;
            }
          }
        }
        lines += _CanvasTextMetrics._addLine(line, false);
        return lines;
      }
      /**
       * Convenience function for logging each line added during the wordWrap method.
       * @param line    - The line of text to add
       * @param newLine - Add new line character to end
       * @returns A formatted line
       */
      static _addLine(line, newLine = true) {
        line = _CanvasTextMetrics._trimRight(line);
        line = newLine ? `${line}
` : line;
        return line;
      }
      /**
       * Gets & sets the widths of calculated characters in a cache object
       * @param key            - The key
       * @param letterSpacing  - The letter spacing
       * @param cache          - The cache
       * @param context        - The canvas context
       * @returns The from cache.
       */
      static _getFromCache(key, letterSpacing, cache, context) {
        let width = cache[key];
        if (typeof width !== "number") {
          width = _CanvasTextMetrics._measureText(key, letterSpacing, context) + letterSpacing;
          cache[key] = width;
        }
        return width;
      }
      /**
       * Determines whether we should collapse breaking spaces.
       * @param whiteSpace - The TextStyle property whiteSpace
       * @returns Should collapse
       */
      static _collapseSpaces(whiteSpace) {
        return whiteSpace === "normal" || whiteSpace === "pre-line";
      }
      /**
       * Determines whether we should collapse newLine chars.
       * @param whiteSpace - The white space
       * @returns should collapse
       */
      static _collapseNewlines(whiteSpace) {
        return whiteSpace === "normal";
      }
      /**
       * Trims breaking whitespaces from string.
       * @param text - The text
       * @returns Trimmed string
       */
      static _trimRight(text) {
        if (typeof text !== "string") {
          return "";
        }
        for (let i = text.length - 1; i >= 0; i--) {
          const char = text[i];
          if (!_CanvasTextMetrics.isBreakingSpace(char)) {
            break;
          }
          text = text.slice(0, -1);
        }
        return text;
      }
      /**
       * Determines if char is a newline.
       * @param char - The character
       * @returns True if newline, False otherwise.
       */
      static _isNewline(char) {
        if (typeof char !== "string") {
          return false;
        }
        return _CanvasTextMetrics._newlines.includes(char.charCodeAt(0));
      }
      /**
       * Determines if char is a breaking whitespace.
       *
       * It allows one to determine whether char should be a breaking whitespace
       * For example certain characters in CJK langs or numbers.
       * It must return a boolean.
       * @param char - The character
       * @param [_nextChar] - The next character
       * @returns True if whitespace, False otherwise.
       */
      static isBreakingSpace(char, _nextChar) {
        if (typeof char !== "string") {
          return false;
        }
        return _CanvasTextMetrics._breakingSpaces.includes(char.charCodeAt(0));
      }
      /**
       * Splits a string into words, breaking-spaces and newLine characters
       * @param text - The text
       * @returns A tokenized array
       */
      static _tokenize(text) {
        const tokens = [];
        let token = "";
        if (typeof text !== "string") {
          return tokens;
        }
        for (let i = 0; i < text.length; i++) {
          const char = text[i];
          const nextChar = text[i + 1];
          if (_CanvasTextMetrics.isBreakingSpace(char, nextChar) || _CanvasTextMetrics._isNewline(char)) {
            if (token !== "") {
              tokens.push(token);
              token = "";
            }
            tokens.push(char);
            continue;
          }
          token += char;
        }
        if (token !== "") {
          tokens.push(token);
        }
        return tokens;
      }
      /**
       * Overridable helper method used internally by TextMetrics, exposed to allow customizing the class's behavior.
       *
       * It allows one to customise which words should break
       * Examples are if the token is CJK or numbers.
       * It must return a boolean.
       * @param _token - The token
       * @param breakWords - The style attr break words
       * @returns Whether to break word or not
       */
      static canBreakWords(_token, breakWords) {
        return breakWords;
      }
      /**
       * Overridable helper method used internally by TextMetrics, exposed to allow customizing the class's behavior.
       *
       * It allows one to determine whether a pair of characters
       * should be broken by newlines
       * For example certain characters in CJK langs or numbers.
       * It must return a boolean.
       * @param _char - The character
       * @param _nextChar - The next character
       * @param _token - The token/word the characters are from
       * @param _index - The index in the token of the char
       * @param _breakWords - The style attr break words
       * @returns whether to break word or not
       */
      static canBreakChars(_char, _nextChar, _token, _index, _breakWords) {
        return true;
      }
      /**
       * Overridable helper method used internally by TextMetrics, exposed to allow customizing the class's behavior.
       *
       * It is called when a token (usually a word) has to be split into separate pieces
       * in order to determine the point to break a word.
       * It must return an array of characters.
       * @param token - The token to split
       * @returns The characters of the token
       * @see CanvasTextMetrics.graphemeSegmenter
       */
      static wordWrapSplit(token) {
        return _CanvasTextMetrics.graphemeSegmenter(token);
      }
      /**
       * Calculates the ascent, descent and fontSize of a given font-style
       * @param font - String representing the style of the font
       * @returns Font properties object
       */
      static measureFont(font) {
        if (_CanvasTextMetrics._fonts[font]) {
          return _CanvasTextMetrics._fonts[font];
        }
        const context = _CanvasTextMetrics._context;
        context.font = font;
        const metrics = context.measureText(_CanvasTextMetrics.METRICS_STRING + _CanvasTextMetrics.BASELINE_SYMBOL);
        const properties = {
          ascent: metrics.actualBoundingBoxAscent,
          descent: metrics.actualBoundingBoxDescent,
          fontSize: metrics.actualBoundingBoxAscent + metrics.actualBoundingBoxDescent
        };
        _CanvasTextMetrics._fonts[font] = properties;
        return properties;
      }
      /**
       * Clear font metrics in metrics cache.
       * @param {string} [font] - font name. If font name not set then clear cache for all fonts.
       */
      static clearMetrics(font = "") {
        if (font) {
          delete _CanvasTextMetrics._fonts[font];
        } else {
          _CanvasTextMetrics._fonts = {};
        }
      }
      /**
       * Cached canvas element for measuring text
       * TODO: this should be private, but isn't because of backward compat, will fix later.
       * @ignore
       */
      static get _canvas() {
        if (!_CanvasTextMetrics.__canvas) {
          let canvas;
          try {
            const c = new OffscreenCanvas(0, 0);
            const context = c.getContext("2d", contextSettings);
            if (context == null ? void 0 : context.measureText) {
              _CanvasTextMetrics.__canvas = c;
              return c;
            }
            canvas = DOMAdapter.get().createCanvas();
          } catch (ex) {
            canvas = DOMAdapter.get().createCanvas();
          }
          canvas.width = canvas.height = 10;
          _CanvasTextMetrics.__canvas = canvas;
        }
        return _CanvasTextMetrics.__canvas;
      }
      /**
       * TODO: this should be private, but isn't because of backward compat, will fix later.
       * @ignore
       */
      static get _context() {
        if (!_CanvasTextMetrics.__context) {
          _CanvasTextMetrics.__context = _CanvasTextMetrics._canvas.getContext("2d", contextSettings);
        }
        return _CanvasTextMetrics.__context;
      }
    };
    /**
     * String used for calculate font metrics.
     * These characters are all tall to help calculate the height required for text.
     */
    _CanvasTextMetrics.METRICS_STRING = "|\xC9q\xC5";
    /** Baseline symbol for calculate font metrics. */
    _CanvasTextMetrics.BASELINE_SYMBOL = "M";
    /** Baseline multiplier for calculate font metrics. */
    _CanvasTextMetrics.BASELINE_MULTIPLIER = 1.4;
    /** Height multiplier for setting height of canvas to calculate font metrics. */
    _CanvasTextMetrics.HEIGHT_MULTIPLIER = 2;
    /**
     * A Unicode "character", or "grapheme cluster", can be composed of multiple Unicode code points,
     * such as letters with diacritical marks (e.g. `'\u0065\u0301'`, letter e with acute)
     * or emojis with modifiers (e.g. `'\uD83E\uDDD1\u200D\uD83D\uDCBB'`, technologist).
     * The new `Intl.Segmenter` API in ES2022 can split the string into grapheme clusters correctly. If it is not available,
     * PixiJS will fallback to use the iterator of String, which can only spilt the string into code points.
     * If you want to get full functionality in environments that don't support `Intl.Segmenter` (such as Firefox),
     * you can use other libraries such as [grapheme-splitter]{@link https://www.npmjs.com/package/grapheme-splitter}
     * or [graphemer]{@link https://www.npmjs.com/package/graphemer} to create a polyfill. Since these libraries can be
     * relatively large in size to handle various Unicode grapheme clusters properly, PixiJS won't use them directly.
     */
    _CanvasTextMetrics.graphemeSegmenter = (() => {
      if (typeof (Intl == null ? void 0 : Intl.Segmenter) === "function") {
        const segmenter = new Intl.Segmenter();
        return (s) => [...segmenter.segment(s)].map((x) => x.segment);
      }
      return (s) => [...s];
    })();
    /**
     * New rendering behavior for letter-spacing which uses Chrome's new native API. This will
     * lead to more accurate letter-spacing results because it does not try to manually draw
     * each character. However, this Chrome API is experimental and may not serve all cases yet.
     * @see TextMetrics.experimentalLetterSpacingSupported
     */
    _CanvasTextMetrics.experimentalLetterSpacing = false;
    /** Cache of {@see TextMetrics.FontMetrics} objects. */
    _CanvasTextMetrics._fonts = {};
    /** Cache of new line chars. */
    _CanvasTextMetrics._newlines = [
      10,
      // line feed
      13
      // carriage return
    ];
    /** Cache of breaking spaces. */
    _CanvasTextMetrics._breakingSpaces = [
      9,
      // character tabulation
      32,
      // space
      8192,
      // en quad
      8193,
      // em quad
      8194,
      // en space
      8195,
      // em space
      8196,
      // three-per-em space
      8197,
      // four-per-em space
      8198,
      // six-per-em space
      8200,
      // punctuation space
      8201,
      // thin space
      8202,
      // hair space
      8287,
      // medium mathematical space
      12288
      // ideographic space
    ];
    _CanvasTextMetrics._measurementCache = {};
    let CanvasTextMetrics = _CanvasTextMetrics;

    "use strict";
    function getCanvasFillStyle(fillStyle, context) {
      var _a;
      if (fillStyle.texture === Texture.WHITE && !fillStyle.fill) {
        return Color.shared.setValue(fillStyle.color).setAlpha((_a = fillStyle.alpha) != null ? _a : 1).toHexa();
      } else if (!fillStyle.fill) {
        const pattern = context.createPattern(fillStyle.texture.source.resource, "repeat");
        const tempMatrix = fillStyle.matrix.copyTo(Matrix.shared);
        tempMatrix.scale(fillStyle.texture.frame.width, fillStyle.texture.frame.height);
        pattern.setTransform(tempMatrix);
        return pattern;
      } else if (fillStyle.fill instanceof FillPattern) {
        const fillPattern = fillStyle.fill;
        const pattern = context.createPattern(fillPattern.texture.source.resource, "repeat");
        const tempMatrix = fillPattern.transform.copyTo(Matrix.shared);
        tempMatrix.scale(
          fillPattern.texture.frame.width,
          fillPattern.texture.frame.height
        );
        pattern.setTransform(tempMatrix);
        return pattern;
      } else if (fillStyle.fill instanceof FillGradient) {
        const fillGradient = fillStyle.fill;
        if (fillGradient.type === "linear") {
          const gradient = context.createLinearGradient(
            fillGradient.x0,
            fillGradient.y0,
            fillGradient.x1,
            fillGradient.y1
          );
          fillGradient.gradientStops.forEach((stop) => {
            gradient.addColorStop(stop.offset, Color.shared.setValue(stop.color).toHex());
          });
          return gradient;
        }
      }
      warn("FillStyle not recognised", fillStyle);
      return "red";
    }

    "use strict";
    class CanvasTextSystem {
      constructor(_renderer) {
        this._activeTextures = {};
        this._renderer = _renderer;
      }
      getTextureSize(text, resolution, style) {
        const measured = CanvasTextMetrics.measureText(text || " ", style);
        let width = Math.ceil(Math.ceil(Math.max(1, measured.width) + style.padding * 2) * resolution);
        let height = Math.ceil(Math.ceil(Math.max(1, measured.height) + style.padding * 2) * resolution);
        width = Math.ceil(width - 1e-6);
        height = Math.ceil(height - 1e-6);
        width = nextPow2(width);
        height = nextPow2(height);
        return { width, height };
      }
      getTexture(options, resolution, style, _textKey) {
        if (typeof options === "string") {
          deprecation("8.0.0", "CanvasTextSystem.getTexture: Use object TextOptions instead of separate arguments");
          options = {
            text: options,
            style,
            resolution
          };
        }
        if (!(options.style instanceof TextStyle)) {
          options.style = new TextStyle(options.style);
        }
        const { texture, canvasAndContext } = this.createTextureAndCanvas(
          options
        );
        this._renderer.texture.initSource(texture._source);
        CanvasPool.returnCanvasAndContext(canvasAndContext);
        return texture;
      }
      createTextureAndCanvas(options) {
        var _a;
        const { text, style } = options;
        const resolution = (_a = options.resolution) != null ? _a : this._renderer.resolution;
        const measured = CanvasTextMetrics.measureText(text || " ", style);
        const width = Math.ceil(Math.ceil(Math.max(1, measured.width) + style.padding * 2) * resolution);
        const height = Math.ceil(Math.ceil(Math.max(1, measured.height) + style.padding * 2) * resolution);
        const canvasAndContext = CanvasPool.getOptimalCanvasAndContext(width, height);
        const { canvas } = canvasAndContext;
        this.renderTextToCanvas(text, style, resolution, canvasAndContext);
        const texture = getPo2TextureFromSource(canvas, width, height, resolution);
        if (style.trim) {
          const trimmed = getCanvasBoundingBox(canvas, resolution);
          texture.frame.copyFrom(trimmed);
          texture.updateUvs();
        }
        return { texture, canvasAndContext };
      }
      getManagedTexture(text) {
        text._resolution = text._autoResolution ? this._renderer.resolution : text.resolution;
        const textKey = text._getKey();
        if (this._activeTextures[textKey]) {
          this._increaseReferenceCount(textKey);
          return this._activeTextures[textKey].texture;
        }
        const { texture, canvasAndContext } = this.createTextureAndCanvas(text);
        this._activeTextures[textKey] = {
          canvasAndContext,
          texture,
          usageCount: 1
        };
        return texture;
      }
      _increaseReferenceCount(textKey) {
        this._activeTextures[textKey].usageCount++;
      }
      decreaseReferenceCount(textKey) {
        const activeTexture = this._activeTextures[textKey];
        activeTexture.usageCount--;
        if (activeTexture.usageCount === 0) {
          CanvasPool.returnCanvasAndContext(activeTexture.canvasAndContext);
          TexturePool.returnTexture(activeTexture.texture);
          const source = activeTexture.texture.source;
          source.resource = null;
          source.uploadMethodId = "unknown";
          source.alphaMode = "no-premultiply-alpha";
          this._activeTextures[textKey] = null;
        }
      }
      getReferenceCount(textKey) {
        return this._activeTextures[textKey].usageCount;
      }
      /**
       * Renders text to its canvas, and updates its texture.
       *
       * By default this is used internally to ensure the texture is correct before rendering,
       * but it can be used called externally, for example from this class to 'pre-generate' the texture from a piece of text,
       * and then shared across multiple Sprites.
       * @param text
       * @param style
       * @param resolution
       * @param canvasAndContext
       */
      renderTextToCanvas(text, style, resolution, canvasAndContext) {
        var _a, _b, _c, _d, _e;
        const { canvas, context } = canvasAndContext;
        const font = fontStringFromTextStyle(style);
        const measured = CanvasTextMetrics.measureText(text || " ", style);
        const lines = measured.lines;
        const lineHeight = measured.lineHeight;
        const lineWidths = measured.lineWidths;
        const maxLineWidth = measured.maxLineWidth;
        const fontProperties = measured.fontProperties;
        const height = canvas.height;
        context.resetTransform();
        context.scale(resolution, resolution);
        context.textBaseline = style.textBaseline;
        if ((_a = style._stroke) == null ? void 0 : _a.width) {
          const strokeStyle = style._stroke;
          context.lineWidth = strokeStyle.width;
          context.miterLimit = strokeStyle.miterLimit;
          context.lineJoin = strokeStyle.join;
          context.lineCap = strokeStyle.cap;
        }
        context.font = font;
        let linePositionX;
        let linePositionY;
        const passesCount = style.dropShadow ? 2 : 1;
        for (let i = 0; i < passesCount; ++i) {
          const isShadowPass = style.dropShadow && i === 0;
          const dsOffsetText = isShadowPass ? Math.ceil(Math.max(1, height) + style.padding * 2) : 0;
          const dsOffsetShadow = dsOffsetText * resolution;
          if (isShadowPass) {
            context.fillStyle = "black";
            context.strokeStyle = "black";
            const shadowOptions = style.dropShadow;
            const dropShadowColor = shadowOptions.color;
            const dropShadowAlpha = shadowOptions.alpha;
            context.shadowColor = Color.shared.setValue(dropShadowColor).setAlpha(dropShadowAlpha).toRgbaString();
            const dropShadowBlur = shadowOptions.blur * resolution;
            const dropShadowDistance = shadowOptions.distance * resolution;
            context.shadowBlur = dropShadowBlur;
            context.shadowOffsetX = Math.cos(shadowOptions.angle) * dropShadowDistance;
            context.shadowOffsetY = Math.sin(shadowOptions.angle) * dropShadowDistance + dsOffsetShadow;
          } else {
            context.fillStyle = style._fill ? getCanvasFillStyle(style._fill, context) : null;
            if ((_b = style._stroke) == null ? void 0 : _b.width) {
              context.strokeStyle = getCanvasFillStyle(style._stroke, context);
            }
            context.shadowColor = "black";
          }
          let linePositionYShift = (lineHeight - fontProperties.fontSize) / 2;
          if (lineHeight - fontProperties.fontSize < 0) {
            linePositionYShift = 0;
          }
          const strokeWidth = (_d = (_c = style._stroke) == null ? void 0 : _c.width) != null ? _d : 0;
          for (let i2 = 0; i2 < lines.length; i2++) {
            linePositionX = strokeWidth / 2;
            linePositionY = strokeWidth / 2 + i2 * lineHeight + fontProperties.ascent + linePositionYShift;
            if (style.align === "right") {
              linePositionX += maxLineWidth - lineWidths[i2];
            } else if (style.align === "center") {
              linePositionX += (maxLineWidth - lineWidths[i2]) / 2;
            }
            if ((_e = style._stroke) == null ? void 0 : _e.width) {
              this._drawLetterSpacing(
                lines[i2],
                style,
                canvasAndContext,
                linePositionX + style.padding,
                linePositionY + style.padding - dsOffsetText,
                true
              );
            }
            if (style._fill !== void 0) {
              this._drawLetterSpacing(
                lines[i2],
                style,
                canvasAndContext,
                linePositionX + style.padding,
                linePositionY + style.padding - dsOffsetText
              );
            }
          }
        }
      }
      /**
       * Render the text with letter-spacing.
       * @param text - The text to draw
       * @param style
       * @param canvasAndContext
       * @param x - Horizontal position to draw the text
       * @param y - Vertical position to draw the text
       * @param isStroke - Is this drawing for the outside stroke of the
       *  text? If not, it's for the inside fill
       */
      _drawLetterSpacing(text, style, canvasAndContext, x, y, isStroke = false) {
        const { context } = canvasAndContext;
        const letterSpacing = style.letterSpacing;
        let useExperimentalLetterSpacing = false;
        if (CanvasTextMetrics.experimentalLetterSpacingSupported) {
          if (CanvasTextMetrics.experimentalLetterSpacing) {
            context.letterSpacing = `${letterSpacing}px`;
            context.textLetterSpacing = `${letterSpacing}px`;
            useExperimentalLetterSpacing = true;
          } else {
            context.letterSpacing = "0px";
            context.textLetterSpacing = "0px";
          }
        }
        if (letterSpacing === 0 || useExperimentalLetterSpacing) {
          if (isStroke) {
            context.strokeText(text, x, y);
          } else {
            context.fillText(text, x, y);
          }
          return;
        }
        let currentPosition = x;
        const stringArray = CanvasTextMetrics.graphemeSegmenter(text);
        let previousWidth = context.measureText(text).width;
        let currentWidth = 0;
        for (let i = 0; i < stringArray.length; ++i) {
          const currentChar = stringArray[i];
          if (isStroke) {
            context.strokeText(currentChar, currentPosition, y);
          } else {
            context.fillText(currentChar, currentPosition, y);
          }
          let textStr = "";
          for (let j = i + 1; j < stringArray.length; ++j) {
            textStr += stringArray[j];
          }
          currentWidth = context.measureText(textStr).width;
          currentPosition += previousWidth - currentWidth + letterSpacing;
          previousWidth = currentWidth;
        }
      }
      destroy() {
        this._activeTextures = null;
      }
    }
    /** @ignore */
    CanvasTextSystem.extension = {
      type: [
        ExtensionType.WebGLSystem,
        ExtensionType.WebGPUSystem,
        ExtensionType.CanvasSystem
      ],
      name: "canvasText"
    };

    "use strict";
    extensions.add(CanvasTextSystem);
    extensions.add(CanvasTextPipe);

    "use strict";
    var __defProp$Q = Object.defineProperty;
    var __getOwnPropSymbols$Q = Object.getOwnPropertySymbols;
    var __hasOwnProp$Q = Object.prototype.hasOwnProperty;
    var __propIsEnum$Q = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$Q = (obj, key, value) => key in obj ? __defProp$Q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$Q = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$Q.call(b, prop))
          __defNormalProp$Q(a, prop, b[prop]);
      if (__getOwnPropSymbols$Q)
        for (var prop of __getOwnPropSymbols$Q(b)) {
          if (__propIsEnum$Q.call(b, prop))
            __defNormalProp$Q(a, prop, b[prop]);
        }
      return a;
    };
    var __objRest$i = (source, exclude) => {
      var target = {};
      for (var prop in source)
        if (__hasOwnProp$Q.call(source, prop) && exclude.indexOf(prop) < 0)
          target[prop] = source[prop];
      if (source != null && __getOwnPropSymbols$Q)
        for (var prop of __getOwnPropSymbols$Q(source)) {
          if (exclude.indexOf(prop) < 0 && __propIsEnum$Q.call(source, prop))
            target[prop] = source[prop];
        }
      return target;
    };
    class Graphics extends ViewContainer {
      /**
       * @param options - Options for the Graphics.
       */
      constructor(options) {
        if (options instanceof GraphicsContext) {
          options = { context: options };
        }
        const _a = options || {}, { context, roundPixels } = _a, rest = __objRest$i(_a, ["context", "roundPixels"]);
        super(__spreadValues$Q({
          label: "Graphics"
        }, rest));
        this.renderPipeId = "graphics";
        if (!context) {
          this._context = this._ownedContext = new GraphicsContext();
        } else {
          this._context = context;
        }
        this._context.on("update", this.onViewUpdate, this);
        this.allowChildren = false;
        this.roundPixels = roundPixels != null ? roundPixels : false;
      }
      set context(context) {
        if (context === this._context)
          return;
        this._context.off("update", this.onViewUpdate, this);
        this._context = context;
        this._context.on("update", this.onViewUpdate, this);
        this.onViewUpdate();
      }
      get context() {
        return this._context;
      }
      /**
       * The local bounds of the graphic.
       * @type {rendering.Bounds}
       */
      get bounds() {
        return this._context.bounds;
      }
      /**
       * Graphics objects do not need to update their bounds as the context handles this.
       * @private
       */
      updateBounds() {
      }
      /**
       * Checks if the object contains the given point.
       * @param point - The point to check
       */
      containsPoint(point) {
        return this._context.containsPoint(point);
      }
      /**
       * Destroys this graphics renderable and optionally its context.
       * @param options - Options parameter. A boolean will act as if all options
       *
       * If the context was created by this graphics and `destroy(false)` or `destroy()` is called
       * then the context will still be destroyed.
       *
       * If you want to explicitly not destroy this context that this graphics created,
       * then you should pass destroy({ context: false })
       *
       * If the context was passed in as an argument to the constructor then it will not be destroyed
       * @param {boolean} [options.texture=false] - Should destroy the texture of the graphics context
       * @param {boolean} [options.textureSource=false] - Should destroy the texture source of the graphics context
       * @param {boolean} [options.context=false] - Should destroy the context
       */
      destroy(options) {
        if (this._ownedContext && !options) {
          this._ownedContext.destroy(options);
        } else if (options === true || (options == null ? void 0 : options.context) === true) {
          this._context.destroy(options);
        }
        this._ownedContext = null;
        this._context = null;
        super.destroy(options);
      }
      _callContextMethod(method, args) {
        this.context[method](...args);
        return this;
      }
      // --------------------------------------- GraphicsContext methods ---------------------------------------
      /**
       * Sets the current fill style of the graphics context. The fill style can be a color, gradient,
       * pattern, or a more complex style defined by a FillStyle object.
       * @param {FillInput} args - The fill style to apply. This can be a simple color, a gradient or
       * pattern object, or a FillStyle or ConvertedFillStyle object.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      setFillStyle(...args) {
        return this._callContextMethod("setFillStyle", args);
      }
      /**
       * Sets the current stroke style of the graphics context. Similar to fill styles, stroke styles can
       * encompass colors, gradients, patterns, or more detailed configurations via a StrokeStyle object.
       * @param {StrokeInput} args - The stroke style to apply. Can be defined as a color, a gradient or pattern,
       * or a StrokeStyle or ConvertedStrokeStyle object.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      setStrokeStyle(...args) {
        return this._callContextMethod("setStrokeStyle", args);
      }
      fill(...args) {
        return this._callContextMethod("fill", args);
      }
      /**
       * Strokes the current path with the current stroke style. This method can take an optional
       * FillStyle parameter to define the stroke's appearance, including its color, width, and other properties.
       * @param {FillStyle} args - (Optional) The stroke style to apply. Can be defined as a simple color or a more
       * complex style object. If omitted, uses the current stroke style.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      stroke(...args) {
        return this._callContextMethod("stroke", args);
      }
      texture(...args) {
        return this._callContextMethod("texture", args);
      }
      /**
       * Resets the current path. Any previous path and its commands are discarded and a new path is
       * started. This is typically called before beginning a new shape or series of drawing commands.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      beginPath() {
        return this._callContextMethod("beginPath", []);
      }
      /**
       * Applies a cutout to the last drawn shape. This is used to create holes or complex shapes by
       * subtracting a path from the previously drawn path. If a hole is not completely in a shape, it will
       * fail to cut correctly!
       */
      cut() {
        return this._callContextMethod("cut", []);
      }
      arc(...args) {
        return this._callContextMethod("arc", args);
      }
      arcTo(...args) {
        return this._callContextMethod("arcTo", args);
      }
      arcToSvg(...args) {
        return this._callContextMethod("arcToSvg", args);
      }
      bezierCurveTo(...args) {
        return this._callContextMethod("bezierCurveTo", args);
      }
      /**
       * Closes the current path by drawing a straight line back to the start.
       * If the shape is already closed or there are no points in the path, this method does nothing.
       * @returns The instance of the current object for chaining.
       */
      closePath() {
        return this._callContextMethod("closePath", []);
      }
      ellipse(...args) {
        return this._callContextMethod("ellipse", args);
      }
      circle(...args) {
        return this._callContextMethod("circle", args);
      }
      path(...args) {
        return this._callContextMethod("path", args);
      }
      lineTo(...args) {
        return this._callContextMethod("lineTo", args);
      }
      moveTo(...args) {
        return this._callContextMethod("moveTo", args);
      }
      quadraticCurveTo(...args) {
        return this._callContextMethod("quadraticCurveTo", args);
      }
      rect(...args) {
        return this._callContextMethod("rect", args);
      }
      roundRect(...args) {
        return this._callContextMethod("roundRect", args);
      }
      poly(...args) {
        return this._callContextMethod("poly", args);
      }
      regularPoly(...args) {
        return this._callContextMethod("regularPoly", args);
      }
      roundPoly(...args) {
        return this._callContextMethod("roundPoly", args);
      }
      roundShape(...args) {
        return this._callContextMethod("roundShape", args);
      }
      filletRect(...args) {
        return this._callContextMethod("filletRect", args);
      }
      chamferRect(...args) {
        return this._callContextMethod("chamferRect", args);
      }
      star(...args) {
        return this._callContextMethod("star", args);
      }
      svg(...args) {
        return this._callContextMethod("svg", args);
      }
      restore(...args) {
        return this._callContextMethod("restore", args);
      }
      /** Saves the current graphics state, including transformations, fill styles, and stroke styles, onto a stack. */
      save() {
        return this._callContextMethod("save", []);
      }
      /**
       * Returns the current transformation matrix of the graphics context.
       * @returns The current transformation matrix.
       */
      getTransform() {
        return this.context.getTransform();
      }
      /**
       * Resets the current transformation matrix to the identity matrix, effectively removing
       * any transformations (rotation, scaling, translation) previously applied.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      resetTransform() {
        return this._callContextMethod("resetTransform", []);
      }
      rotateTransform(...args) {
        return this._callContextMethod("rotate", args);
      }
      scaleTransform(...args) {
        return this._callContextMethod("scale", args);
      }
      setTransform(...args) {
        return this._callContextMethod("setTransform", args);
      }
      transform(...args) {
        return this._callContextMethod("transform", args);
      }
      translateTransform(...args) {
        return this._callContextMethod("translate", args);
      }
      /**
       * Clears all drawing commands from the graphics context, effectively resetting it. This includes clearing the path,
       * and optionally resetting transformations to the identity matrix.
       * @returns The instance of the current GraphicsContext for method chaining.
       */
      clear() {
        return this._callContextMethod("clear", []);
      }
      /**
       * The fill style to use.
       * @type {ConvertedFillStyle}
       */
      get fillStyle() {
        return this._context.fillStyle;
      }
      set fillStyle(value) {
        this._context.fillStyle = value;
      }
      /**
       * The stroke style to use.
       * @type {ConvertedStrokeStyle}
       */
      get strokeStyle() {
        return this._context.strokeStyle;
      }
      set strokeStyle(value) {
        this._context.strokeStyle = value;
      }
      /**
       * Creates a new Graphics object.
       * Note that only the context of the object is cloned, not its transform (position,scale,etc)
       * @param deep - Whether to create a deep clone of the graphics object. If false, the context
       * will be shared between the two objects (default false). If true, the context will be
       * cloned (recommended if you need to modify the context in any way).
       * @returns - A clone of the graphics object
       */
      clone(deep = false) {
        if (deep) {
          return new Graphics(this._context.clone());
        }
        this._ownedContext = null;
        const clone = new Graphics(this._context);
        return clone;
      }
      // -------- v7 deprecations ---------
      /**
       * @param width
       * @param color
       * @param alpha
       * @deprecated since 8.0.0 Use {@link Graphics#setStrokeStyle} instead
       */
      lineStyle(width, color, alpha) {
        deprecation(v8_0_0, "Graphics#lineStyle is no longer needed. Use Graphics#setStrokeStyle to set the stroke style.");
        const strokeStyle = {};
        width && (strokeStyle.width = width);
        color && (strokeStyle.color = color);
        alpha && (strokeStyle.alpha = alpha);
        this.context.strokeStyle = strokeStyle;
        return this;
      }
      /**
       * @param color
       * @param alpha
       * @deprecated since 8.0.0 Use {@link Graphics#fill} instead
       */
      beginFill(color, alpha) {
        deprecation(v8_0_0, "Graphics#beginFill is no longer needed. Use Graphics#fill to fill the shape with the desired style.");
        const fillStyle = {};
        if (color !== void 0)
          fillStyle.color = color;
        if (alpha !== void 0)
          fillStyle.alpha = alpha;
        this.context.fillStyle = fillStyle;
        return this;
      }
      /**
       * @deprecated since 8.0.0 Use {@link Graphics#fill} instead
       */
      endFill() {
        deprecation(v8_0_0, "Graphics#endFill is no longer needed. Use Graphics#fill to fill the shape with the desired style.");
        this.context.fill();
        const strokeStyle = this.context.strokeStyle;
        if (strokeStyle.width !== GraphicsContext.defaultStrokeStyle.width || strokeStyle.color !== GraphicsContext.defaultStrokeStyle.color || strokeStyle.alpha !== GraphicsContext.defaultStrokeStyle.alpha) {
          this.context.stroke();
        }
        return this;
      }
      /**
       * @param {...any} args
       * @deprecated since 8.0.0 Use {@link Graphics#circle} instead
       */
      drawCircle(...args) {
        deprecation(v8_0_0, "Graphics#drawCircle has been renamed to Graphics#circle");
        return this._callContextMethod("circle", args);
      }
      /**
       * @param {...any} args
       * @deprecated since 8.0.0 Use {@link Graphics#ellipse} instead
       */
      drawEllipse(...args) {
        deprecation(v8_0_0, "Graphics#drawEllipse has been renamed to Graphics#ellipse");
        return this._callContextMethod("ellipse", args);
      }
      /**
       * @param {...any} args
       * @deprecated since 8.0.0 Use {@link Graphics#poly} instead
       */
      drawPolygon(...args) {
        deprecation(v8_0_0, "Graphics#drawPolygon has been renamed to Graphics#poly");
        return this._callContextMethod("poly", args);
      }
      /**
       * @param {...any} args
       * @deprecated since 8.0.0 Use {@link Graphics#rect} instead
       */
      drawRect(...args) {
        deprecation(v8_0_0, "Graphics#drawRect has been renamed to Graphics#rect");
        return this._callContextMethod("rect", args);
      }
      /**
       * @param {...any} args
       * @deprecated since 8.0.0 Use {@link Graphics#roundRect} instead
       */
      drawRoundedRect(...args) {
        deprecation(v8_0_0, "Graphics#drawRoundedRect has been renamed to Graphics#roundRect");
        return this._callContextMethod("roundRect", args);
      }
      /**
       * @param {...any} args
       * @deprecated since 8.0.0 Use {@link Graphics#star} instead
       */
      drawStar(...args) {
        deprecation(v8_0_0, "Graphics#drawStar has been renamed to Graphics#star");
        return this._callContextMethod("star", args);
      }
    }

    "use strict";
    const localUniformMSDFBit = {
      name: "local-uniform-msdf-bit",
      vertex: {
        header: (
          /* wgsl */
          `
            struct LocalUniforms {
                uColor:vec4<f32>,
                uTransformMatrix:mat3x3<f32>,
                uDistance: f32,
                uRound:f32,
            }

            @group(2) @binding(0) var<uniform> localUniforms : LocalUniforms;
        `
        ),
        main: (
          /* wgsl */
          `
            vColor *= localUniforms.uColor;
            modelMatrix *= localUniforms.uTransformMatrix;
        `
        ),
        end: (
          /* wgsl */
          `
            if(localUniforms.uRound == 1)
            {
                vPosition = vec4(roundPixels(vPosition.xy, globalUniforms.uResolution), vPosition.zw);
            }
        `
        )
      },
      fragment: {
        header: (
          /* wgsl */
          `
            struct LocalUniforms {
                uColor:vec4<f32>,
                uTransformMatrix:mat3x3<f32>,
                uDistance: f32
            }

            @group(2) @binding(0) var<uniform> localUniforms : LocalUniforms;
         `
        ),
        main: (
          /* wgsl */
          ` 
            outColor = vec4<f32>(calculateMSDFAlpha(outColor, localUniforms.uColor, localUniforms.uDistance));
        `
        )
      }
    };
    const localUniformMSDFBitGl = {
      name: "local-uniform-msdf-bit",
      vertex: {
        header: (
          /* glsl */
          `
            uniform mat3 uTransformMatrix;
            uniform vec4 uColor;
            uniform float uRound;
        `
        ),
        main: (
          /* glsl */
          `
            vColor *= uColor;
            modelMatrix *= uTransformMatrix;
        `
        ),
        end: (
          /* glsl */
          `
            if(uRound == 1.)
            {
                gl_Position.xy = roundPixels(gl_Position.xy, uResolution);
            }
        `
        )
      },
      fragment: {
        header: (
          /* glsl */
          `
            uniform float uDistance;
         `
        ),
        main: (
          /* glsl */
          ` 
            outColor = vec4(calculateMSDFAlpha(outColor, vColor, uDistance));
        `
        )
      }
    };

    "use strict";
    const mSDFBit = {
      name: "msdf-bit",
      fragment: {
        header: (
          /* wgsl */
          `
            fn calculateMSDFAlpha(msdfColor:vec4<f32>, shapeColor:vec4<f32>, distance:f32) -> f32 {
                
                // MSDF
                var median = msdfColor.r + msdfColor.g + msdfColor.b -
                    min(msdfColor.r, min(msdfColor.g, msdfColor.b)) -
                    max(msdfColor.r, max(msdfColor.g, msdfColor.b));
            
                // SDF
                median = min(median, msdfColor.a);

                var screenPxDistance = distance * (median - 0.5);
                var alpha = clamp(screenPxDistance + 0.5, 0.0, 1.0);
                if (median < 0.01) {
                    alpha = 0.0;
                } else if (median > 0.99) {
                    alpha = 1.0;
                }

                // Gamma correction for coverage-like alpha
                var luma: f32 = dot(shapeColor.rgb, vec3<f32>(0.299, 0.587, 0.114));
                var gamma: f32 = mix(1.0, 1.0 / 2.2, luma);
                var coverage: f32 = pow(shapeColor.a * alpha, gamma);

                return coverage;
             
            }
        `
        )
      }
    };
    const mSDFBitGl = {
      name: "msdf-bit",
      fragment: {
        header: (
          /* glsl */
          `
            float calculateMSDFAlpha(vec4 msdfColor, vec4 shapeColor, float distance) {
                
                // MSDF
                float median = msdfColor.r + msdfColor.g + msdfColor.b -
                                min(msdfColor.r, min(msdfColor.g, msdfColor.b)) -
                                max(msdfColor.r, max(msdfColor.g, msdfColor.b));
               
                // SDF
                median = min(median, msdfColor.a);
            
                float screenPxDistance = distance * (median - 0.5);
                float alpha = clamp(screenPxDistance + 0.5, 0.0, 1.0);
           
                if (median < 0.01) {
                    alpha = 0.0;
                } else if (median > 0.99) {
                    alpha = 1.0;
                }

                // Gamma correction for coverage-like alpha
                float luma = dot(shapeColor.rgb, vec3(0.299, 0.587, 0.114));
                float gamma = mix(1.0, 1.0 / 2.2, luma);
                float coverage = pow(shapeColor.a * alpha, gamma);  
              
                return coverage;
            }
        `
        )
      }
    };

    "use strict";
    let gpuProgram$1;
    let glProgram$1;
    class SdfShader extends Shader {
      constructor() {
        const uniforms = new UniformGroup({
          uColor: { value: new Float32Array([1, 1, 1, 1]), type: "vec4<f32>" },
          uTransformMatrix: { value: new Matrix(), type: "mat3x3<f32>" },
          uDistance: { value: 4, type: "f32" },
          uRound: { value: 0, type: "f32" }
        });
        const maxTextures = getMaxTexturesPerBatch();
        gpuProgram$1 != null ? gpuProgram$1 : gpuProgram$1 = compileHighShaderGpuProgram({
          name: "sdf-shader",
          bits: [
            colorBit,
            generateTextureBatchBit(maxTextures),
            localUniformMSDFBit,
            mSDFBit,
            roundPixelsBit
          ]
        });
        glProgram$1 != null ? glProgram$1 : glProgram$1 = compileHighShaderGlProgram({
          name: "sdf-shader",
          bits: [
            colorBitGl,
            generateTextureBatchBitGl(maxTextures),
            localUniformMSDFBitGl,
            mSDFBitGl,
            roundPixelsBitGl
          ]
        });
        super({
          glProgram: glProgram$1,
          gpuProgram: gpuProgram$1,
          resources: {
            localUniforms: uniforms,
            batchSamplers: getBatchSamplersUniformGroup(maxTextures)
          }
        });
      }
    }

    "use strict";
    class AbstractBitmapFont extends EventEmitter {
      constructor() {
        super(...arguments);
        /** The map of characters by character code. */
        this.chars = /* @__PURE__ */ Object.create(null);
        /**
         * The line-height of the font face in pixels.
         * @type {number}
         */
        this.lineHeight = 0;
        /**
         * The name of the font face
         * @type {string}
         */
        this.fontFamily = "";
        /** The metrics of the font face. */
        this.fontMetrics = { fontSize: 0, ascent: 0, descent: 0 };
        /**
         * The offset of the font face from the baseline.
         * @type {number}
         */
        this.baseLineOffset = 0;
        /** The range and type of the distance field for this font. */
        this.distanceField = { type: "none", range: 0 };
        /** The map of base page textures (i.e., sheets of glyphs). */
        this.pages = [];
        /** should the fill for this font be applied as a tint to the text. */
        this.applyFillAsTint = true;
        /** The size of the font face in pixels. */
        this.baseMeasurementFontSize = 100;
        this.baseRenderedFontSize = 100;
      }
      /**
       * The name of the font face.
       * @deprecated since 8.0.0 Use `fontFamily` instead.
       */
      get font() {
        deprecation(v8_0_0, "BitmapFont.font is deprecated, please use BitmapFont.fontFamily instead.");
        return this.fontFamily;
      }
      /**
       * The map of base page textures (i.e., sheets of glyphs).
       * @deprecated since 8.0.0 Use `pages` instead.
       */
      get pageTextures() {
        deprecation(v8_0_0, "BitmapFont.pageTextures is deprecated, please use BitmapFont.pages instead.");
        return this.pages;
      }
      /**
       * The size of the font face in pixels.
       * @deprecated since 8.0.0 Use `fontMetrics.fontSize` instead.
       */
      get size() {
        deprecation(v8_0_0, "BitmapFont.size is deprecated, please use BitmapFont.fontMetrics.fontSize instead.");
        return this.fontMetrics.fontSize;
      }
      /**
       * The kind of distance field for this font or "none".
       * @deprecated since 8.0.0 Use `distanceField.type` instead.
       */
      get distanceFieldRange() {
        deprecation(v8_0_0, "BitmapFont.distanceFieldRange is deprecated, please use BitmapFont.distanceField.range instead.");
        return this.distanceField.range;
      }
      /**
       * The range of the distance field in pixels.
       * @deprecated since 8.0.0 Use `distanceField.range` instead.
       */
      get distanceFieldType() {
        deprecation(v8_0_0, "BitmapFont.distanceFieldType is deprecated, please use BitmapFont.distanceField.type instead.");
        return this.distanceField.type;
      }
      destroy(destroyTextures = false) {
        var _a;
        this.emit("destroy", this);
        this.removeAllListeners();
        for (const i in this.chars) {
          (_a = this.chars[i].texture) == null ? void 0 : _a.destroy();
        }
        this.chars = null;
        if (destroyTextures) {
          this.pages.forEach((page) => page.texture.destroy(true));
          this.pages = null;
        }
      }
    }

    "use strict";
    function resolveCharacters(chars) {
      if (chars === "") {
        return [];
      }
      if (typeof chars === "string") {
        chars = [chars];
      }
      const result = [];
      for (let i = 0, j = chars.length; i < j; i++) {
        const item = chars[i];
        if (Array.isArray(item)) {
          if (item.length !== 2) {
            throw new Error(`[BitmapFont]: Invalid character range length, expecting 2 got ${item.length}.`);
          }
          if (item[0].length === 0 || item[1].length === 0) {
            throw new Error("[BitmapFont]: Invalid character delimiter.");
          }
          const startCode = item[0].charCodeAt(0);
          const endCode = item[1].charCodeAt(0);
          if (endCode < startCode) {
            throw new Error("[BitmapFont]: Invalid character range.");
          }
          for (let i2 = startCode, j2 = endCode; i2 <= j2; i2++) {
            result.push(String.fromCharCode(i2));
          }
        } else {
          result.push(...Array.from(item));
        }
      }
      if (result.length === 0) {
        throw new Error("[BitmapFont]: Empty set when resolving characters.");
      }
      return result;
    }

    "use strict";
    var __defProp$P = Object.defineProperty;
    var __getOwnPropSymbols$P = Object.getOwnPropertySymbols;
    var __hasOwnProp$P = Object.prototype.hasOwnProperty;
    var __propIsEnum$P = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$P = (obj, key, value) => key in obj ? __defProp$P(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$P = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$P.call(b, prop))
          __defNormalProp$P(a, prop, b[prop]);
      if (__getOwnPropSymbols$P)
        for (var prop of __getOwnPropSymbols$P(b)) {
          if (__propIsEnum$P.call(b, prop))
            __defNormalProp$P(a, prop, b[prop]);
        }
      return a;
    };
    const _DynamicBitmapFont = class _DynamicBitmapFont extends AbstractBitmapFont {
      /**
       * @param options - The options for the dynamic bitmap font.
       */
      constructor(options) {
        var _a, _b, _c;
        super();
        /**
         * this is a resolution modifier for the font size..
         * texture resolution will also be used to scale texture according to its font size also
         */
        this.resolution = 1;
        /** The pages of the font. */
        this.pages = [];
        this._padding = 0;
        this._measureCache = /* @__PURE__ */ Object.create(null);
        this._currentChars = [];
        this._currentX = 0;
        this._currentY = 0;
        this._currentPageIndex = -1;
        this._skipKerning = false;
        const dynamicOptions = __spreadValues$P(__spreadValues$P({}, _DynamicBitmapFont.defaultOptions), options);
        this._textureSize = dynamicOptions.textureSize;
        this._mipmap = dynamicOptions.mipmap;
        const style = dynamicOptions.style.clone();
        if (dynamicOptions.overrideFill) {
          style._fill.color = 16777215;
          style._fill.alpha = 1;
          style._fill.texture = Texture.WHITE;
          style._fill.fill = null;
        }
        this.applyFillAsTint = dynamicOptions.overrideFill;
        const requestedFontSize = style.fontSize;
        style.fontSize = this.baseMeasurementFontSize;
        const font = fontStringFromTextStyle(style);
        if (dynamicOptions.overrideSize) {
          if (style._stroke) {
            style._stroke.width *= this.baseRenderedFontSize / requestedFontSize;
          }
        } else {
          style.fontSize = this.baseRenderedFontSize = requestedFontSize;
        }
        this._style = style;
        this._skipKerning = (_a = dynamicOptions.skipKerning) != null ? _a : false;
        this.resolution = (_b = dynamicOptions.resolution) != null ? _b : 1;
        this._padding = (_c = dynamicOptions.padding) != null ? _c : 4;
        this.fontMetrics = CanvasTextMetrics.measureFont(font);
        this.lineHeight = style.lineHeight || this.fontMetrics.fontSize || style.fontSize;
      }
      ensureCharacters(chars) {
        var _a, _b, _c, _d;
        const charList = resolveCharacters(chars).filter((char) => !this._currentChars.includes(char)).filter((char, index, self) => self.indexOf(char) === index);
        if (!charList.length)
          return;
        this._currentChars = [...this._currentChars, ...charList];
        let pageData;
        if (this._currentPageIndex === -1) {
          pageData = this._nextPage();
        } else {
          pageData = this.pages[this._currentPageIndex];
        }
        let { canvas, context } = pageData.canvasAndContext;
        let textureSource = pageData.texture.source;
        const style = this._style;
        let currentX = this._currentX;
        let currentY = this._currentY;
        const fontScale = this.baseRenderedFontSize / this.baseMeasurementFontSize;
        const padding = this._padding * fontScale;
        let maxCharHeight = 0;
        let skipTexture = false;
        const maxTextureWidth = canvas.width / this.resolution;
        const maxTextureHeight = canvas.height / this.resolution;
        for (let i = 0; i < charList.length; i++) {
          const char = charList[i];
          const metrics = CanvasTextMetrics.measureText(char, style, canvas, false);
          metrics.lineHeight = metrics.height;
          const width = metrics.width * fontScale;
          const textureGlyphWidth = Math.ceil((style.fontStyle === "italic" ? 2 : 1) * width);
          const height = metrics.height * fontScale;
          const paddedWidth = textureGlyphWidth + padding * 2;
          const paddedHeight = height + padding * 2;
          skipTexture = false;
          if (char !== "\n" && char !== "\r" && char !== "	" && char !== " ") {
            skipTexture = true;
            maxCharHeight = Math.ceil(Math.max(paddedHeight, maxCharHeight));
          }
          if (currentX + paddedWidth > maxTextureWidth) {
            currentY += maxCharHeight;
            maxCharHeight = paddedHeight;
            currentX = 0;
            if (currentY + maxCharHeight > maxTextureHeight) {
              textureSource.update();
              const pageData2 = this._nextPage();
              canvas = pageData2.canvasAndContext.canvas;
              context = pageData2.canvasAndContext.context;
              textureSource = pageData2.texture.source;
              currentY = 0;
            }
          }
          const xAdvance = width / fontScale - ((_b = (_a = style.dropShadow) == null ? void 0 : _a.distance) != null ? _b : 0) - ((_d = (_c = style._stroke) == null ? void 0 : _c.width) != null ? _d : 0);
          this.chars[char] = {
            id: char.codePointAt(0),
            xOffset: -this._padding,
            yOffset: -this._padding,
            xAdvance,
            kerning: {}
          };
          if (skipTexture) {
            this._drawGlyph(
              context,
              metrics,
              currentX + padding,
              currentY + padding,
              fontScale,
              style
            );
            const px = textureSource.width * fontScale;
            const py = textureSource.height * fontScale;
            const frame = new Rectangle(
              currentX / px * textureSource.width,
              currentY / py * textureSource.height,
              paddedWidth / px * textureSource.width,
              paddedHeight / py * textureSource.height
            );
            this.chars[char].texture = new Texture({
              source: textureSource,
              frame
            });
            currentX += Math.ceil(paddedWidth);
          }
        }
        textureSource.update();
        this._currentX = currentX;
        this._currentY = currentY;
        this._skipKerning && this._applyKerning(charList, context);
      }
      /**
       * @deprecated since 8.0.0
       * The map of base page textures (i.e., sheets of glyphs).
       */
      get pageTextures() {
        deprecation(v8_0_0, "BitmapFont.pageTextures is deprecated, please use BitmapFont.pages instead.");
        return this.pages;
      }
      _applyKerning(newChars, context) {
        const measureCache = this._measureCache;
        for (let i = 0; i < newChars.length; i++) {
          const first = newChars[i];
          for (let j = 0; j < this._currentChars.length; j++) {
            const second = this._currentChars[j];
            let c1 = measureCache[first];
            if (!c1)
              c1 = measureCache[first] = context.measureText(first).width;
            let c2 = measureCache[second];
            if (!c2)
              c2 = measureCache[second] = context.measureText(second).width;
            let total = context.measureText(first + second).width;
            let amount = total - (c1 + c2);
            if (amount) {
              this.chars[first].kerning[second] = amount;
            }
            total = context.measureText(first + second).width;
            amount = total - (c1 + c2);
            if (amount) {
              this.chars[second].kerning[first] = amount;
            }
          }
        }
      }
      _nextPage() {
        this._currentPageIndex++;
        const textureResolution = this.resolution;
        const canvasAndContext = CanvasPool.getOptimalCanvasAndContext(
          this._textureSize,
          this._textureSize,
          textureResolution
        );
        this._setupContext(canvasAndContext.context, this._style, textureResolution);
        const resolution = textureResolution * (this.baseRenderedFontSize / this.baseMeasurementFontSize);
        const texture = new Texture({
          source: new ImageSource({
            resource: canvasAndContext.canvas,
            resolution,
            alphaMode: "premultiply-alpha-on-upload",
            autoGenerateMipmaps: this._mipmap
          })
        });
        const pageData = {
          canvasAndContext,
          texture
        };
        this.pages[this._currentPageIndex] = pageData;
        return pageData;
      }
      // canvas style!
      _setupContext(context, style, resolution) {
        var _a;
        style.fontSize = this.baseRenderedFontSize;
        context.scale(resolution, resolution);
        context.font = fontStringFromTextStyle(style);
        style.fontSize = this.baseMeasurementFontSize;
        context.textBaseline = style.textBaseline;
        const stroke = style._stroke;
        const strokeThickness = (_a = stroke == null ? void 0 : stroke.width) != null ? _a : 0;
        if (stroke) {
          context.lineWidth = strokeThickness;
          context.lineJoin = stroke.join;
          context.miterLimit = stroke.miterLimit;
          context.strokeStyle = getCanvasFillStyle(stroke, context);
        }
        if (style._fill) {
          context.fillStyle = getCanvasFillStyle(style._fill, context);
        }
        if (style.dropShadow) {
          const shadowOptions = style.dropShadow;
          const rgb = Color.shared.setValue(shadowOptions.color).toArray();
          const dropShadowBlur = shadowOptions.blur * resolution;
          const dropShadowDistance = shadowOptions.distance * resolution;
          context.shadowColor = `rgba(${rgb[0] * 255},${rgb[1] * 255},${rgb[2] * 255},${shadowOptions.alpha})`;
          context.shadowBlur = dropShadowBlur;
          context.shadowOffsetX = Math.cos(shadowOptions.angle) * dropShadowDistance;
          context.shadowOffsetY = Math.sin(shadowOptions.angle) * dropShadowDistance;
        } else {
          context.shadowColor = "black";
          context.shadowBlur = 0;
          context.shadowOffsetX = 0;
          context.shadowOffsetY = 0;
        }
      }
      _drawGlyph(context, metrics, x, y, fontScale, style) {
        var _a;
        const char = metrics.text;
        const fontProperties = metrics.fontProperties;
        const stroke = style._stroke;
        const strokeThickness = ((_a = stroke == null ? void 0 : stroke.width) != null ? _a : 0) * fontScale;
        const tx = x + strokeThickness / 2;
        const ty = y - strokeThickness / 2;
        const descent = fontProperties.descent * fontScale;
        const lineHeight = metrics.lineHeight * fontScale;
        if (style.stroke && strokeThickness) {
          context.strokeText(char, tx, ty + lineHeight - descent);
        }
        if (style._fill) {
          context.fillText(char, tx, ty + lineHeight - descent);
        }
      }
      destroy() {
        super.destroy();
        for (let i = 0; i < this.pages.length; i++) {
          const { canvasAndContext, texture } = this.pages[i];
          CanvasPool.returnCanvasAndContext(canvasAndContext);
          texture.destroy(true);
        }
        this.pages = null;
      }
    };
    _DynamicBitmapFont.defaultOptions = {
      textureSize: 512,
      style: new TextStyle(),
      mipmap: true
    };
    let DynamicBitmapFont = _DynamicBitmapFont;

    "use strict";
    function getBitmapTextLayout(chars, style, font, trimEnd) {
      const layoutData = {
        width: 0,
        height: 0,
        offsetY: 0,
        scale: style.fontSize / font.baseMeasurementFontSize,
        lines: [{
          width: 0,
          charPositions: [],
          spaceWidth: 0,
          spacesIndex: [],
          chars: []
        }]
      };
      layoutData.offsetY = font.baseLineOffset;
      let currentLine = layoutData.lines[0];
      let previousChar = null;
      let firstWord = true;
      const currentWord = {
        spaceWord: false,
        width: 0,
        start: 0,
        index: 0,
        // use index to not modify the array as we use it a lot!
        positions: [],
        chars: []
      };
      const nextWord = (word) => {
        const start = currentLine.width;
        for (let j = 0; j < currentWord.index; j++) {
          const position = word.positions[j];
          currentLine.chars.push(word.chars[j]);
          currentLine.charPositions.push(position + start);
        }
        currentLine.width += word.width;
        firstWord = false;
        currentWord.width = 0;
        currentWord.index = 0;
        currentWord.chars.length = 0;
      };
      const nextLine = () => {
        let index = currentLine.chars.length - 1;
        if (trimEnd) {
          let lastChar = currentLine.chars[index];
          while (lastChar === " ") {
            currentLine.width -= font.chars[lastChar].xAdvance;
            lastChar = currentLine.chars[--index];
          }
        }
        layoutData.width = Math.max(layoutData.width, currentLine.width);
        currentLine = {
          width: 0,
          charPositions: [],
          chars: [],
          spaceWidth: 0,
          spacesIndex: []
        };
        firstWord = true;
        layoutData.lines.push(currentLine);
        layoutData.height += font.lineHeight;
      };
      const scale = font.baseMeasurementFontSize / style.fontSize;
      const adjustedLetterSpacing = style.letterSpacing * scale;
      const adjustedWordWrapWidth = style.wordWrapWidth * scale;
      for (let i = 0; i < chars.length + 1; i++) {
        let char;
        const isEnd = i === chars.length;
        if (!isEnd) {
          char = chars[i];
        }
        const charData = font.chars[char] || font.chars[" "];
        const isSpace = /(?:\s)/.test(char);
        const isWordBreak = isSpace || char === "\r" || char === "\n" || isEnd;
        if (isWordBreak) {
          const addWordToNextLine = !firstWord && style.wordWrap && currentLine.width + currentWord.width - adjustedLetterSpacing > adjustedWordWrapWidth;
          if (addWordToNextLine) {
            nextLine();
            nextWord(currentWord);
            if (!isEnd) {
              currentLine.charPositions.push(0);
            }
          } else {
            currentWord.start = currentLine.width;
            nextWord(currentWord);
            if (!isEnd) {
              currentLine.charPositions.push(0);
            }
          }
          if (char === "\r" || char === "\n") {
            if (currentLine.width !== 0) {
              nextLine();
            }
          } else if (!isEnd) {
            const spaceWidth = charData.xAdvance + (charData.kerning[previousChar] || 0) + adjustedLetterSpacing;
            currentLine.width += spaceWidth;
            currentLine.spaceWidth = spaceWidth;
            currentLine.spacesIndex.push(currentLine.charPositions.length);
            currentLine.chars.push(char);
          }
        } else {
          const kerning = charData.kerning[previousChar] || 0;
          const nextCharWidth = charData.xAdvance + kerning + adjustedLetterSpacing;
          currentWord.positions[currentWord.index++] = currentWord.width + kerning;
          currentWord.chars.push(char);
          currentWord.width += nextCharWidth;
        }
        previousChar = char;
      }
      nextLine();
      if (style.align === "center") {
        alignCenter(layoutData);
      } else if (style.align === "right") {
        alignRight(layoutData);
      } else if (style.align === "justify") {
        alignJustify(layoutData);
      }
      return layoutData;
    }
    function alignCenter(measurementData) {
      for (let i = 0; i < measurementData.lines.length; i++) {
        const line = measurementData.lines[i];
        const offset = measurementData.width / 2 - line.width / 2;
        for (let j = 0; j < line.charPositions.length; j++) {
          line.charPositions[j] += offset;
        }
      }
    }
    function alignRight(measurementData) {
      for (let i = 0; i < measurementData.lines.length; i++) {
        const line = measurementData.lines[i];
        const offset = measurementData.width - line.width;
        for (let j = 0; j < line.charPositions.length; j++) {
          line.charPositions[j] += offset;
        }
      }
    }
    function alignJustify(measurementData) {
      const width = measurementData.width;
      for (let i = 0; i < measurementData.lines.length; i++) {
        const line = measurementData.lines[i];
        let indy = 0;
        let spaceIndex = line.spacesIndex[indy++];
        let offset = 0;
        const totalSpaces = line.spacesIndex.length;
        const newSpaceWidth = (width - line.width) / totalSpaces;
        const spaceWidth = newSpaceWidth;
        for (let j = 0; j < line.charPositions.length; j++) {
          if (j === spaceIndex) {
            spaceIndex = line.spacesIndex[indy++];
            offset += spaceWidth;
          }
          line.charPositions[j] += offset;
        }
      }
    }

    "use strict";
    var __defProp$O = Object.defineProperty;
    var __getOwnPropSymbols$O = Object.getOwnPropertySymbols;
    var __hasOwnProp$O = Object.prototype.hasOwnProperty;
    var __propIsEnum$O = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$O = (obj, key, value) => key in obj ? __defProp$O(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$O = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$O.call(b, prop))
          __defNormalProp$O(a, prop, b[prop]);
      if (__getOwnPropSymbols$O)
        for (var prop of __getOwnPropSymbols$O(b)) {
          if (__propIsEnum$O.call(b, prop))
            __defNormalProp$O(a, prop, b[prop]);
        }
      return a;
    };
    let fontCount = 0;
    class BitmapFontManagerClass {
      constructor() {
        /**
         * This character set includes all the letters in the alphabet (both lower- and upper- case).
         * @type {string[][]}
         * @example
         * BitmapFont.from('ExampleFont', style, { chars: BitmapFont.ALPHA })
         */
        this.ALPHA = [["a", "z"], ["A", "Z"], " "];
        /**
         * This character set includes all decimal digits (from 0 to 9).
         * @type {string[][]}
         * @example
         * BitmapFont.from('ExampleFont', style, { chars: BitmapFont.NUMERIC })
         */
        this.NUMERIC = [["0", "9"]];
        /**
         * This character set is the union of `BitmapFont.ALPHA` and `BitmapFont.NUMERIC`.
         * @type {string[][]}
         */
        this.ALPHANUMERIC = [["a", "z"], ["A", "Z"], ["0", "9"], " "];
        /**
         * This character set consists of all the ASCII table.
         * @member {string[][]}
         * @see http://www.asciitable.com/
         */
        this.ASCII = [[" ", "~"]];
        /** Default options for installing a new BitmapFont. */
        this.defaultOptions = {
          chars: this.ALPHANUMERIC,
          resolution: 1,
          padding: 4,
          skipKerning: false
        };
      }
      /**
       * Get a font for the specified text and style.
       * @param text - The text to get the font for
       * @param style - The style to use
       */
      getFont(text, style) {
        var _a;
        let fontFamilyKey = `${style.fontFamily}-bitmap`;
        let overrideFill = true;
        if (style._fill.fill && !style._stroke) {
          fontFamilyKey += style._fill.fill.styleKey;
          overrideFill = false;
        } else if (style._stroke || style.dropShadow) {
          let key = style.styleKey;
          key = key.substring(0, key.lastIndexOf("-"));
          fontFamilyKey = `${key}-bitmap`;
          overrideFill = false;
        }
        if (!Cache.has(fontFamilyKey)) {
          const fnt = new DynamicBitmapFont(__spreadValues$O({
            style,
            overrideFill,
            overrideSize: true
          }, this.defaultOptions));
          fontCount++;
          if (fontCount > 50) {
            warn("BitmapText", `You have dynamically created ${fontCount} bitmap fonts, this can be inefficient. Try pre installing your font styles using \`BitmapFont.install({name:"style1", style})\``);
          }
          fnt.once("destroy", () => {
            fontCount--;
            Cache.remove(fontFamilyKey);
          });
          Cache.set(
            fontFamilyKey,
            fnt
          );
        }
        const dynamicFont = Cache.get(fontFamilyKey);
        (_a = dynamicFont.ensureCharacters) == null ? void 0 : _a.call(dynamicFont, text);
        return dynamicFont;
      }
      /**
       * Get the layout of a text for the specified style.
       * @param text - The text to get the layout for
       * @param style - The style to use
       * @param trimEnd - Whether to ignore whitespaces at the end of each line
       */
      getLayout(text, style, trimEnd = true) {
        const bitmapFont = this.getFont(text, style);
        return getBitmapTextLayout([...text], style, bitmapFont, trimEnd);
      }
      /**
       * Measure the text using the specified style.
       * @param text - The text to measure
       * @param style - The style to use
       * @param trimEnd - Whether to ignore whitespaces at the end of each line
       */
      measureText(text, style, trimEnd = true) {
        return this.getLayout(text, style, trimEnd);
      }
      // eslint-disable-next-line max-len
      install(...args) {
        var _a, _b, _c, _d;
        let options = args[0];
        if (typeof options === "string") {
          options = {
            name: options,
            style: args[1],
            chars: (_a = args[2]) == null ? void 0 : _a.chars,
            resolution: (_b = args[2]) == null ? void 0 : _b.resolution,
            padding: (_c = args[2]) == null ? void 0 : _c.padding,
            skipKerning: (_d = args[2]) == null ? void 0 : _d.skipKerning
          };
          deprecation(v8_0_0, "BitmapFontManager.install(name, style, options) is deprecated, use BitmapFontManager.install({name, style, ...options})");
        }
        const name = options == null ? void 0 : options.name;
        if (!name) {
          throw new Error("[BitmapFontManager] Property `name` is required.");
        }
        options = __spreadValues$O(__spreadValues$O({}, this.defaultOptions), options);
        const textStyle = options.style;
        const style = textStyle instanceof TextStyle ? textStyle : new TextStyle(textStyle);
        const overrideFill = style._fill.fill !== null && style._fill.fill !== void 0;
        const font = new DynamicBitmapFont({
          style,
          overrideFill,
          skipKerning: options.skipKerning,
          padding: options.padding,
          resolution: options.resolution,
          overrideSize: false
        });
        const flatChars = resolveCharacters(options.chars);
        font.ensureCharacters(flatChars.join(""));
        Cache.set(`${name}-bitmap`, font);
        font.once("destroy", () => Cache.remove(`${name}-bitmap`));
        return font;
      }
      /**
       * Uninstalls a bitmap font from the cache.
       * @param {string} name - The name of the bitmap font to uninstall.
       */
      uninstall(name) {
        const cacheKey = `${name}-bitmap`;
        const font = Cache.get(cacheKey);
        if (font) {
          font.destroy();
        }
      }
    }
    const BitmapFontManager = new BitmapFontManagerClass();

    "use strict";
    class BitmapTextPipe {
      constructor(renderer) {
        this._gpuBitmapText = {};
        this._destroyRenderableBound = this.destroyRenderable.bind(this);
        this._renderer = renderer;
        this._renderer.renderableGC.addManagedHash(this, "_gpuBitmapText");
      }
      validateRenderable(bitmapText) {
        const graphicsRenderable = this._getGpuBitmapText(bitmapText);
        if (bitmapText._didTextUpdate) {
          bitmapText._didTextUpdate = false;
          this._updateContext(bitmapText, graphicsRenderable);
        }
        return this._renderer.renderPipes.graphics.validateRenderable(graphicsRenderable);
      }
      addRenderable(bitmapText, instructionSet) {
        const graphicsRenderable = this._getGpuBitmapText(bitmapText);
        syncWithProxy(bitmapText, graphicsRenderable);
        if (bitmapText._didTextUpdate) {
          bitmapText._didTextUpdate = false;
          this._updateContext(bitmapText, graphicsRenderable);
        }
        this._renderer.renderPipes.graphics.addRenderable(graphicsRenderable, instructionSet);
        if (graphicsRenderable.context.customShader) {
          this._updateDistanceField(bitmapText);
        }
      }
      destroyRenderable(bitmapText) {
        bitmapText.off("destroyed", this._destroyRenderableBound);
        this._destroyRenderableByUid(bitmapText.uid);
      }
      _destroyRenderableByUid(renderableUid) {
        const context = this._gpuBitmapText[renderableUid].context;
        if (context.customShader) {
          BigPool.return(context.customShader);
          context.customShader = null;
        }
        BigPool.return(this._gpuBitmapText[renderableUid]);
        this._gpuBitmapText[renderableUid] = null;
      }
      updateRenderable(bitmapText) {
        const graphicsRenderable = this._getGpuBitmapText(bitmapText);
        syncWithProxy(bitmapText, graphicsRenderable);
        this._renderer.renderPipes.graphics.updateRenderable(graphicsRenderable);
        if (graphicsRenderable.context.customShader) {
          this._updateDistanceField(bitmapText);
        }
      }
      _updateContext(bitmapText, proxyGraphics) {
        const { context } = proxyGraphics;
        const bitmapFont = BitmapFontManager.getFont(bitmapText.text, bitmapText._style);
        context.clear();
        if (bitmapFont.distanceField.type !== "none") {
          if (!context.customShader) {
            context.customShader = BigPool.get(SdfShader);
          }
        }
        const chars = Array.from(bitmapText.text);
        const style = bitmapText._style;
        let currentY = bitmapFont.baseLineOffset;
        const bitmapTextLayout = getBitmapTextLayout(chars, style, bitmapFont, true);
        let index = 0;
        const padding = style.padding;
        const scale = bitmapTextLayout.scale;
        let tx = bitmapTextLayout.width;
        let ty = bitmapTextLayout.height + bitmapTextLayout.offsetY;
        if (style._stroke) {
          tx += style._stroke.width / scale;
          ty += style._stroke.width / scale;
        }
        context.translate(-bitmapText._anchor._x * tx - padding, -bitmapText._anchor._y * ty - padding).scale(scale, scale);
        const tint = bitmapFont.applyFillAsTint ? style._fill.color : 16777215;
        for (let i = 0; i < bitmapTextLayout.lines.length; i++) {
          const line = bitmapTextLayout.lines[i];
          for (let j = 0; j < line.charPositions.length; j++) {
            const char = chars[index++];
            const charData = bitmapFont.chars[char];
            if (charData == null ? void 0 : charData.texture) {
              context.texture(
                charData.texture,
                tint ? tint : "black",
                Math.round(line.charPositions[j] + charData.xOffset),
                Math.round(currentY + charData.yOffset)
              );
            }
          }
          currentY += bitmapFont.lineHeight;
        }
      }
      _getGpuBitmapText(bitmapText) {
        return this._gpuBitmapText[bitmapText.uid] || this.initGpuText(bitmapText);
      }
      initGpuText(bitmapText) {
        const proxyRenderable = BigPool.get(Graphics);
        this._gpuBitmapText[bitmapText.uid] = proxyRenderable;
        this._updateContext(bitmapText, proxyRenderable);
        bitmapText.on("destroyed", this._destroyRenderableBound);
        return this._gpuBitmapText[bitmapText.uid];
      }
      _updateDistanceField(bitmapText) {
        const context = this._getGpuBitmapText(bitmapText).context;
        const fontFamily = bitmapText._style.fontFamily;
        const dynamicFont = Cache.get(`${fontFamily}-bitmap`);
        const { a, b, c, d } = bitmapText.groupTransform;
        const dx = Math.sqrt(a * a + b * b);
        const dy = Math.sqrt(c * c + d * d);
        const worldScale = (Math.abs(dx) + Math.abs(dy)) / 2;
        const fontScale = dynamicFont.baseRenderedFontSize / bitmapText._style.fontSize;
        const distance = worldScale * dynamicFont.distanceField.range * (1 / fontScale);
        context.customShader.resources.localUniforms.uniforms.uDistance = distance;
      }
      destroy() {
        for (const uid in this._gpuBitmapText) {
          this._destroyRenderableByUid(uid);
        }
        this._gpuBitmapText = null;
        this._renderer = null;
      }
    }
    /** @ignore */
    BitmapTextPipe.extension = {
      type: [
        ExtensionType.WebGLPipes,
        ExtensionType.WebGPUPipes,
        ExtensionType.CanvasPipes
      ],
      name: "bitmapText"
    };
    function syncWithProxy(container, proxy) {
      proxy.groupTransform = container.groupTransform;
      proxy.groupColorAlpha = container.groupColorAlpha;
      proxy.groupColor = container.groupColor;
      proxy.groupBlendMode = container.groupBlendMode;
      proxy.globalDisplayStatus = container.globalDisplayStatus;
      proxy.groupTransform = container.groupTransform;
      proxy.localDisplayStatus = container.localDisplayStatus;
      proxy.groupAlpha = container.groupAlpha;
      proxy._roundPixels = container._roundPixels;
    }

    "use strict";
    extensions.add(BitmapTextPipe);

    "use strict";
    class HTMLTextPipe {
      constructor(renderer) {
        this._gpuText = /* @__PURE__ */ Object.create(null);
        this._destroyRenderableBound = this.destroyRenderable.bind(this);
        this._renderer = renderer;
        this._renderer.runners.resolutionChange.add(this);
        this._renderer.renderableGC.addManagedHash(this, "_gpuText");
      }
      resolutionChange() {
        for (const i in this._gpuText) {
          const gpuText = this._gpuText[i];
          if (!gpuText)
            continue;
          const text = gpuText.batchableSprite.renderable;
          if (text._autoResolution) {
            text._resolution = this._renderer.resolution;
            text.onViewUpdate();
          }
        }
      }
      validateRenderable(htmlText) {
        const gpuText = this._getGpuText(htmlText);
        const newKey = htmlText._getKey();
        if (gpuText.textureNeedsUploading) {
          gpuText.textureNeedsUploading = false;
          return true;
        }
        if (gpuText.currentKey !== newKey) {
          return true;
        }
        return false;
      }
      addRenderable(htmlText, instructionSet) {
        const gpuText = this._getGpuText(htmlText);
        const batchableSprite = gpuText.batchableSprite;
        if (htmlText._didTextUpdate) {
          this._updateText(htmlText);
        }
        this._renderer.renderPipes.batch.addToBatch(batchableSprite, instructionSet);
      }
      updateRenderable(htmlText) {
        const gpuText = this._getGpuText(htmlText);
        const batchableSprite = gpuText.batchableSprite;
        if (htmlText._didTextUpdate) {
          this._updateText(htmlText);
        }
        batchableSprite._batcher.updateElement(batchableSprite);
      }
      destroyRenderable(htmlText) {
        htmlText.off("destroyed", this._destroyRenderableBound);
        this._destroyRenderableById(htmlText.uid);
      }
      _destroyRenderableById(htmlTextUid) {
        const gpuText = this._gpuText[htmlTextUid];
        this._renderer.htmlText.decreaseReferenceCount(gpuText.currentKey);
        BigPool.return(gpuText.batchableSprite);
        this._gpuText[htmlTextUid] = null;
      }
      _updateText(htmlText) {
        const newKey = htmlText._getKey();
        const gpuText = this._getGpuText(htmlText);
        const batchableSprite = gpuText.batchableSprite;
        if (gpuText.currentKey !== newKey) {
          this._updateGpuText(htmlText).catch((e) => {
            console.error(e);
          });
        }
        htmlText._didTextUpdate = false;
        const padding = htmlText._style.padding;
        updateQuadBounds(batchableSprite.bounds, htmlText._anchor, batchableSprite.texture, padding);
      }
      async _updateGpuText(htmlText) {
        var _a;
        htmlText._didTextUpdate = false;
        const gpuText = this._getGpuText(htmlText);
        if (gpuText.generatingTexture)
          return;
        const newKey = htmlText._getKey();
        this._renderer.htmlText.decreaseReferenceCount(gpuText.currentKey);
        gpuText.generatingTexture = true;
        gpuText.currentKey = newKey;
        const resolution = (_a = htmlText.resolution) != null ? _a : this._renderer.resolution;
        const texture = await this._renderer.htmlText.getManagedTexture(
          htmlText.text,
          resolution,
          htmlText._style,
          htmlText._getKey()
        );
        const batchableSprite = gpuText.batchableSprite;
        batchableSprite.texture = gpuText.texture = texture;
        gpuText.generatingTexture = false;
        gpuText.textureNeedsUploading = true;
        htmlText.onViewUpdate();
        const padding = htmlText._style.padding;
        updateQuadBounds(batchableSprite.bounds, htmlText._anchor, batchableSprite.texture, padding);
      }
      _getGpuText(htmlText) {
        return this._gpuText[htmlText.uid] || this.initGpuText(htmlText);
      }
      initGpuText(htmlText) {
        const gpuTextData = {
          texture: Texture.EMPTY,
          currentKey: "--",
          batchableSprite: BigPool.get(BatchableSprite),
          textureNeedsUploading: false,
          generatingTexture: false
        };
        const batchableSprite = gpuTextData.batchableSprite;
        batchableSprite.renderable = htmlText;
        batchableSprite.transform = htmlText.groupTransform;
        batchableSprite.texture = Texture.EMPTY;
        batchableSprite.bounds = { minX: 0, maxX: 1, minY: 0, maxY: 0 };
        batchableSprite.roundPixels = this._renderer._roundPixels | htmlText._roundPixels;
        htmlText._resolution = htmlText._autoResolution ? this._renderer.resolution : htmlText.resolution;
        this._gpuText[htmlText.uid] = gpuTextData;
        htmlText.on("destroyed", this._destroyRenderableBound);
        return gpuTextData;
      }
      destroy() {
        for (const i in this._gpuText) {
          this._destroyRenderableById(i);
        }
        this._gpuText = null;
        this._renderer = null;
      }
    }
    /** @ignore */
    HTMLTextPipe.extension = {
      type: [
        ExtensionType.WebGLPipes,
        ExtensionType.WebGPUPipes,
        ExtensionType.CanvasPipes
      ],
      name: "htmlText"
    };

    "use strict";
    function isSafari() {
      const { userAgent } = DOMAdapter.get().getNavigator();
      return /^((?!chrome|android).)*safari/i.test(userAgent);
    }

    "use strict";
    const nssvg = "http://www.w3.org/2000/svg";
    const nsxhtml = "http://www.w3.org/1999/xhtml";
    class HTMLTextRenderData {
      constructor() {
        this.svgRoot = document.createElementNS(nssvg, "svg");
        this.foreignObject = document.createElementNS(nssvg, "foreignObject");
        this.domElement = document.createElementNS(nsxhtml, "div");
        this.styleElement = document.createElementNS(nsxhtml, "style");
        this.image = new Image();
        const { foreignObject, svgRoot, styleElement, domElement } = this;
        foreignObject.setAttribute("width", "10000");
        foreignObject.setAttribute("height", "10000");
        foreignObject.style.overflow = "hidden";
        svgRoot.appendChild(foreignObject);
        foreignObject.appendChild(styleElement);
        foreignObject.appendChild(domElement);
      }
    }

    "use strict";
    function textStyleToCSS(style) {
      const stroke = style._stroke;
      const fill = style._fill;
      const cssStyleString = [
        `color: ${Color.shared.setValue(fill.color).toHex()}`,
        `font-size: ${style.fontSize}px`,
        `font-family: ${style.fontFamily}`,
        `font-weight: ${style.fontWeight}`,
        `font-style: ${style.fontStyle}`,
        `font-variant: ${style.fontVariant}`,
        `letter-spacing: ${style.letterSpacing}px`,
        `text-align: ${style.align}`,
        `padding: ${style.padding}px`,
        `white-space: ${style.whiteSpace === "pre" && style.wordWrap ? "pre-wrap" : style.whiteSpace}`,
        ...style.lineHeight ? [`line-height: ${style.lineHeight}px`] : [],
        ...style.wordWrap ? [
          `word-wrap: ${style.breakWords ? "break-all" : "break-word"}`,
          `max-width: ${style.wordWrapWidth}px`
        ] : [],
        ...stroke ? [strokeToCSS(stroke)] : [],
        ...style.dropShadow ? [dropShadowToCSS(style.dropShadow)] : [],
        ...style.cssOverrides
      ].join(";");
      const cssStyles = [`div { ${cssStyleString} }`];
      tagStyleToCSS(style.tagStyles, cssStyles);
      return cssStyles.join(" ");
    }
    function dropShadowToCSS(dropShadowStyle) {
      const color = Color.shared.setValue(dropShadowStyle.color).setAlpha(dropShadowStyle.alpha).toHexa();
      const x = Math.round(Math.cos(dropShadowStyle.angle) * dropShadowStyle.distance);
      const y = Math.round(Math.sin(dropShadowStyle.angle) * dropShadowStyle.distance);
      const position = `${x}px ${y}px`;
      if (dropShadowStyle.blur > 0) {
        return `text-shadow: ${position} ${dropShadowStyle.blur}px ${color}`;
      }
      return `text-shadow: ${position} ${color}`;
    }
    function strokeToCSS(stroke) {
      return [
        `-webkit-text-stroke-width: ${stroke.width}px`,
        `-webkit-text-stroke-color: ${Color.shared.setValue(stroke.color).toHex()}`,
        `text-stroke-width: ${stroke.width}px`,
        `text-stroke-color: ${Color.shared.setValue(stroke.color).toHex()}`,
        "paint-order: stroke"
      ].join(";");
    }
    const templates = {
      fontSize: `font-size: {{VALUE}}px`,
      fontFamily: `font-family: {{VALUE}}`,
      fontWeight: `font-weight: {{VALUE}}`,
      fontStyle: `font-style: {{VALUE}}`,
      fontVariant: `font-variant: {{VALUE}}`,
      letterSpacing: `letter-spacing: {{VALUE}}px`,
      align: `text-align: {{VALUE}}`,
      padding: `padding: {{VALUE}}px`,
      whiteSpace: `white-space: {{VALUE}}`,
      lineHeight: `line-height: {{VALUE}}px`,
      wordWrapWidth: `max-width: {{VALUE}}px`
    };
    const transform = {
      fill: (value) => `color: ${Color.shared.setValue(value).toHex()}`,
      breakWords: (value) => `word-wrap: ${value ? "break-all" : "break-word"}`,
      stroke: strokeToCSS,
      dropShadow: dropShadowToCSS
    };
    function tagStyleToCSS(tagStyles, out) {
      for (const i in tagStyles) {
        const tagStyle = tagStyles[i];
        const cssTagStyle = [];
        for (const j in tagStyle) {
          if (transform[j]) {
            cssTagStyle.push(transform[j](tagStyle[j]));
          } else if (templates[j]) {
            cssTagStyle.push(templates[j].replace("{{VALUE}}", tagStyle[j]));
          }
        }
        out.push(`${i} { ${cssTagStyle.join(";")} }`);
      }
    }

    "use strict";
    var __defProp$N = Object.defineProperty;
    var __getOwnPropSymbols$N = Object.getOwnPropertySymbols;
    var __hasOwnProp$N = Object.prototype.hasOwnProperty;
    var __propIsEnum$N = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$N = (obj, key, value) => key in obj ? __defProp$N(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$N = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$N.call(b, prop))
          __defNormalProp$N(a, prop, b[prop]);
      if (__getOwnPropSymbols$N)
        for (var prop of __getOwnPropSymbols$N(b)) {
          if (__propIsEnum$N.call(b, prop))
            __defNormalProp$N(a, prop, b[prop]);
        }
      return a;
    };
    class HTMLTextStyle extends TextStyle {
      constructor(options = {}) {
        var _a, _b;
        super(options);
        this._cssOverrides = [];
        (_a = this.cssOverrides) != null ? _a : this.cssOverrides = options.cssOverrides;
        this.tagStyles = (_b = options.tagStyles) != null ? _b : {};
      }
      /** List of style overrides that will be applied to the HTML text. */
      set cssOverrides(value) {
        this._cssOverrides = value instanceof Array ? value : [value];
        this.update();
      }
      get cssOverrides() {
        return this._cssOverrides;
      }
      _generateKey() {
        this._styleKey = generateTextStyleKey(this) + this._cssOverrides.join("-");
        return this._styleKey;
      }
      update() {
        this._cssStyle = null;
        super.update();
      }
      /**
       * Creates a new HTMLTextStyle object with the same values as this one.
       * @returns New cloned HTMLTextStyle object
       */
      clone() {
        return new HTMLTextStyle({
          align: this.align,
          breakWords: this.breakWords,
          dropShadow: this.dropShadow ? __spreadValues$N({}, this.dropShadow) : null,
          fill: this._fill,
          fontFamily: this.fontFamily,
          fontSize: this.fontSize,
          fontStyle: this.fontStyle,
          fontVariant: this.fontVariant,
          fontWeight: this.fontWeight,
          letterSpacing: this.letterSpacing,
          lineHeight: this.lineHeight,
          padding: this.padding,
          stroke: this._stroke,
          whiteSpace: this.whiteSpace,
          wordWrap: this.wordWrap,
          wordWrapWidth: this.wordWrapWidth,
          cssOverrides: this.cssOverrides
        });
      }
      get cssStyle() {
        if (!this._cssStyle) {
          this._cssStyle = textStyleToCSS(this);
        }
        return this._cssStyle;
      }
      /**
       * Add a style override, this can be any CSS property
       * it will override any built-in style. This is the
       * property and the value as a string (e.g., `color: red`).
       * This will override any other internal style.
       * @param {string} value - CSS style(s) to add.
       * @example
       * style.addOverride('background-color: red');
       */
      addOverride(...value) {
        const toAdd = value.filter((v) => !this.cssOverrides.includes(v));
        if (toAdd.length > 0) {
          this.cssOverrides.push(...toAdd);
          this.update();
        }
      }
      /**
       * Remove any overrides that match the value.
       * @param {string} value - CSS style to remove.
       * @example
       * style.removeOverride('background-color: red');
       */
      removeOverride(...value) {
        const toRemove = value.filter((v) => this.cssOverrides.includes(v));
        if (toRemove.length > 0) {
          this.cssOverrides = this.cssOverrides.filter((v) => !toRemove.includes(v));
          this.update();
        }
      }
      set fill(value) {
        if (typeof value !== "string" && typeof value !== "number") {
          warn("[HTMLTextStyle] only color fill is not supported by HTMLText");
        }
        super.fill = value;
      }
      set stroke(value) {
        if (value && typeof value !== "string" && typeof value !== "number") {
          warn("[HTMLTextStyle] only color stroke is not supported by HTMLText");
        }
        super.stroke = value;
      }
    }

    "use strict";
    function extractFontFamilies(text, style) {
      const fontFamily = style.fontFamily;
      const fontFamilies = [];
      const dedupe = {};
      const regex = /font-family:([^;"\s]+)/g;
      const matches = text.match(regex);
      function addFontFamily(fontFamily2) {
        if (!dedupe[fontFamily2]) {
          fontFamilies.push(fontFamily2);
          dedupe[fontFamily2] = true;
        }
      }
      if (Array.isArray(fontFamily)) {
        for (let i = 0; i < fontFamily.length; i++) {
          addFontFamily(fontFamily[i]);
        }
      } else {
        addFontFamily(fontFamily);
      }
      if (matches) {
        matches.forEach((match) => {
          const fontFamily2 = match.split(":")[1].trim();
          addFontFamily(fontFamily2);
        });
      }
      for (const i in style.tagStyles) {
        const fontFamily2 = style.tagStyles[i].fontFamily;
        addFontFamily(fontFamily2);
      }
      return fontFamilies;
    }

    "use strict";
    async function loadFontAsBase64(url) {
      const response = await DOMAdapter.get().fetch(url);
      const blob = await response.blob();
      const reader = new FileReader();
      const dataSrc = await new Promise((resolve, reject) => {
        reader.onloadend = () => resolve(reader.result);
        reader.onerror = reject;
        reader.readAsDataURL(blob);
      });
      return dataSrc;
    }

    "use strict";
    async function loadFontCSS(style, url) {
      const dataSrc = await loadFontAsBase64(url);
      return `@font-face {
        font-family: "${style.fontFamily}";
        src: url('${dataSrc}');
        font-weight: ${style.fontWeight};
        font-style: ${style.fontStyle};
    }`;
    }

    "use strict";
    const FontStylePromiseCache = /* @__PURE__ */ new Map();
    async function getFontCss(fontFamilies, style, defaultOptions) {
      const fontPromises = fontFamilies.filter((fontFamily) => Cache.has(`${fontFamily}-and-url`)).map((fontFamily, i) => {
        if (!FontStylePromiseCache.has(fontFamily)) {
          const { url } = Cache.get(`${fontFamily}-and-url`);
          if (i === 0) {
            FontStylePromiseCache.set(fontFamily, loadFontCSS({
              fontWeight: style.fontWeight,
              fontStyle: style.fontStyle,
              fontFamily
            }, url));
          } else {
            FontStylePromiseCache.set(fontFamily, loadFontCSS({
              fontWeight: defaultOptions.fontWeight,
              fontStyle: defaultOptions.fontStyle,
              fontFamily
            }, url));
          }
        }
        return FontStylePromiseCache.get(fontFamily);
      });
      return (await Promise.all(fontPromises)).join("\n");
    }

    "use strict";
    function getSVGUrl(text, style, resolution, fontCSS, htmlTextData) {
      const { domElement, styleElement, svgRoot } = htmlTextData;
      domElement.innerHTML = `<style>${style.cssStyle}</style><div style='padding:0;'>${text}</div>`;
      domElement.setAttribute("style", `transform: scale(${resolution});transform-origin: top left; display: inline-block`);
      styleElement.textContent = fontCSS;
      const { width, height } = htmlTextData.image;
      svgRoot.setAttribute("width", width.toString());
      svgRoot.setAttribute("height", height.toString());
      return new XMLSerializer().serializeToString(svgRoot);
    }

    "use strict";
    function getTemporaryCanvasFromImage(image, resolution) {
      const canvasAndContext = CanvasPool.getOptimalCanvasAndContext(
        image.width,
        image.height,
        resolution
      );
      const { context } = canvasAndContext;
      context.clearRect(0, 0, image.width, image.height);
      context.drawImage(image, 0, 0);
      return canvasAndContext;
    }

    "use strict";
    function loadSVGImage(image, url, delay) {
      return new Promise(async (resolve) => {
        if (delay) {
          await new Promise((resolve2) => setTimeout(resolve2, 100));
        }
        image.onload = () => {
          resolve();
        };
        image.src = `data:image/svg+xml;charset=utf8,${encodeURIComponent(url)}`;
        image.crossOrigin = "anonymous";
      });
    }

    "use strict";
    let tempHTMLTextRenderData;
    function measureHtmlText(text, style, fontStyleCSS, htmlTextRenderData) {
      htmlTextRenderData || (htmlTextRenderData = tempHTMLTextRenderData || (tempHTMLTextRenderData = new HTMLTextRenderData()));
      const { domElement, styleElement, svgRoot } = htmlTextRenderData;
      domElement.innerHTML = `<style>${style.cssStyle};</style><div style='padding:0'>${text}</div>`;
      domElement.setAttribute("style", "transform-origin: top left; display: inline-block");
      if (fontStyleCSS) {
        styleElement.textContent = fontStyleCSS;
      }
      document.body.appendChild(svgRoot);
      const contentBounds = domElement.getBoundingClientRect();
      svgRoot.remove();
      const doublePadding = style.padding * 2;
      return {
        width: contentBounds.width - doublePadding,
        height: contentBounds.height - doublePadding
      };
    }

    "use strict";
    class HTMLTextSystem {
      constructor(renderer) {
        this._activeTextures = {};
        this._renderer = renderer;
        this._createCanvas = renderer.type === RendererType.WEBGPU;
      }
      getTexture(options) {
        return this._buildTexturePromise(
          options.text,
          options.resolution,
          options.style
        );
      }
      getManagedTexture(text, resolution, style, textKey) {
        if (this._activeTextures[textKey]) {
          this._increaseReferenceCount(textKey);
          return this._activeTextures[textKey].promise;
        }
        const promise = this._buildTexturePromise(text, resolution, style).then((texture) => {
          this._activeTextures[textKey].texture = texture;
          return texture;
        });
        this._activeTextures[textKey] = {
          texture: null,
          promise,
          usageCount: 1
        };
        return promise;
      }
      async _buildTexturePromise(text, resolution, style) {
        const htmlTextData = BigPool.get(HTMLTextRenderData);
        const fontFamilies = extractFontFamilies(text, style);
        const fontCSS = await getFontCss(
          fontFamilies,
          style,
          HTMLTextStyle.defaultTextStyle
        );
        const measured = measureHtmlText(text, style, fontCSS, htmlTextData);
        const width = Math.ceil(Math.ceil(Math.max(1, measured.width) + style.padding * 2) * resolution);
        const height = Math.ceil(Math.ceil(Math.max(1, measured.height) + style.padding * 2) * resolution);
        const image = htmlTextData.image;
        const uvSafeOffset = 2;
        image.width = (width | 0) + uvSafeOffset;
        image.height = (height | 0) + uvSafeOffset;
        const svgURL = getSVGUrl(text, style, resolution, fontCSS, htmlTextData);
        await loadSVGImage(image, svgURL, isSafari() && fontFamilies.length > 0);
        const resource = image;
        let canvasAndContext;
        if (this._createCanvas) {
          canvasAndContext = getTemporaryCanvasFromImage(image, resolution);
        }
        const texture = getPo2TextureFromSource(
          canvasAndContext ? canvasAndContext.canvas : resource,
          image.width - uvSafeOffset,
          image.height - uvSafeOffset,
          resolution
        );
        if (this._createCanvas) {
          this._renderer.texture.initSource(texture.source);
          CanvasPool.returnCanvasAndContext(canvasAndContext);
        }
        BigPool.return(htmlTextData);
        return texture;
      }
      _increaseReferenceCount(textKey) {
        this._activeTextures[textKey].usageCount++;
      }
      decreaseReferenceCount(textKey) {
        const activeTexture = this._activeTextures[textKey];
        if (!activeTexture)
          return;
        activeTexture.usageCount--;
        if (activeTexture.usageCount === 0) {
          if (activeTexture.texture) {
            this._cleanUp(activeTexture);
          } else {
            activeTexture.promise.then((texture) => {
              activeTexture.texture = texture;
              this._cleanUp(activeTexture);
            }).catch(() => {
              warn("HTMLTextSystem: Failed to clean texture");
            });
          }
          this._activeTextures[textKey] = null;
        }
      }
      _cleanUp(activeTexture) {
        TexturePool.returnTexture(activeTexture.texture);
        activeTexture.texture.source.resource = null;
        activeTexture.texture.source.uploadMethodId = "unknown";
      }
      getReferenceCount(textKey) {
        return this._activeTextures[textKey].usageCount;
      }
      destroy() {
        this._activeTextures = null;
      }
    }
    /** @ignore */
    HTMLTextSystem.extension = {
      type: [
        ExtensionType.WebGLSystem,
        ExtensionType.WebGPUSystem,
        ExtensionType.CanvasSystem
      ],
      name: "htmlText"
    };
    HTMLTextSystem.defaultFontOptions = {
      fontFamily: "Arial",
      fontStyle: "normal",
      fontWeight: "normal"
    };

    "use strict";
    extensions.add(HTMLTextSystem);
    extensions.add(HTMLTextPipe);

    "use strict";
    var __defProp$M = Object.defineProperty;
    var __getOwnPropSymbols$M = Object.getOwnPropertySymbols;
    var __hasOwnProp$M = Object.prototype.hasOwnProperty;
    var __propIsEnum$M = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$M = (obj, key, value) => key in obj ? __defProp$M(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$M = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$M.call(b, prop))
          __defNormalProp$M(a, prop, b[prop]);
      if (__getOwnPropSymbols$M)
        for (var prop of __getOwnPropSymbols$M(b)) {
          if (__propIsEnum$M.call(b, prop))
            __defNormalProp$M(a, prop, b[prop]);
        }
      return a;
    };
    const _MeshGeometry = class _MeshGeometry extends Geometry {
      constructor(...args) {
        var _a;
        let options = (_a = args[0]) != null ? _a : {};
        if (options instanceof Float32Array) {
          deprecation(v8_0_0, "use new MeshGeometry({ positions, uvs, indices }) instead");
          options = {
            positions: options,
            uvs: args[1],
            indices: args[2]
          };
        }
        options = __spreadValues$M(__spreadValues$M({}, _MeshGeometry.defaultOptions), options);
        const positions = options.positions || new Float32Array([0, 0, 1, 0, 1, 1, 0, 1]);
        const uvs = options.uvs || new Float32Array([0, 0, 1, 0, 1, 1, 0, 1]);
        const indices = options.indices || new Uint32Array([0, 1, 2, 0, 2, 3]);
        const shrinkToFit = options.shrinkBuffersToFit;
        const positionBuffer = new Buffer({
          data: positions,
          label: "attribute-mesh-positions",
          shrinkToFit,
          usage: BufferUsage.VERTEX | BufferUsage.COPY_DST
        });
        const uvBuffer = new Buffer({
          data: uvs,
          label: "attribute-mesh-uvs",
          shrinkToFit,
          usage: BufferUsage.VERTEX | BufferUsage.COPY_DST
        });
        const indexBuffer = new Buffer({
          data: indices,
          label: "index-mesh-buffer",
          shrinkToFit,
          usage: BufferUsage.INDEX | BufferUsage.COPY_DST
        });
        super({
          attributes: {
            aPosition: {
              buffer: positionBuffer,
              format: "float32x2",
              stride: 2 * 4,
              offset: 0
            },
            aUV: {
              buffer: uvBuffer,
              format: "float32x2",
              stride: 2 * 4,
              offset: 0
            }
          },
          indexBuffer,
          topology: options.topology
        });
        this.batchMode = "auto";
      }
      /** The positions of the mesh. */
      get positions() {
        return this.attributes.aPosition.buffer.data;
      }
      set positions(value) {
        this.attributes.aPosition.buffer.data = value;
      }
      /** The UVs of the mesh. */
      get uvs() {
        return this.attributes.aUV.buffer.data;
      }
      set uvs(value) {
        this.attributes.aUV.buffer.data = value;
      }
      /** The indices of the mesh. */
      get indices() {
        return this.indexBuffer.data;
      }
      set indices(value) {
        this.indexBuffer.data = value;
      }
    };
    _MeshGeometry.defaultOptions = {
      topology: "triangle-list",
      shrinkBuffersToFit: false
    };
    let MeshGeometry = _MeshGeometry;

    "use strict";
    var __defProp$L = Object.defineProperty;
    var __defProps$l = Object.defineProperties;
    var __getOwnPropDescs$l = Object.getOwnPropertyDescriptors;
    var __getOwnPropSymbols$L = Object.getOwnPropertySymbols;
    var __hasOwnProp$L = Object.prototype.hasOwnProperty;
    var __propIsEnum$L = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$L = (obj, key, value) => key in obj ? __defProp$L(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$L = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$L.call(b, prop))
          __defNormalProp$L(a, prop, b[prop]);
      if (__getOwnPropSymbols$L)
        for (var prop of __getOwnPropSymbols$L(b)) {
          if (__propIsEnum$L.call(b, prop))
            __defNormalProp$L(a, prop, b[prop]);
        }
      return a;
    };
    var __spreadProps$l = (a, b) => __defProps$l(a, __getOwnPropDescs$l(b));
    const localUniformBit = {
      name: "local-uniform-bit",
      vertex: {
        header: (
          /* wgsl */
          `

            struct LocalUniforms {
                uTransformMatrix:mat3x3<f32>,
                uColor:vec4<f32>,
                uRound:f32,
            }

            @group(1) @binding(0) var<uniform> localUniforms : LocalUniforms;
        `
        ),
        main: (
          /* wgsl */
          `
            vColor *= localUniforms.uColor;
            modelMatrix *= localUniforms.uTransformMatrix;
        `
        ),
        end: (
          /* wgsl */
          `
            if(localUniforms.uRound == 1)
            {
                vPosition = vec4(roundPixels(vPosition.xy, globalUniforms.uResolution), vPosition.zw);
            }
        `
        )
      }
    };
    const localUniformBitGroup2 = __spreadProps$l(__spreadValues$L({}, localUniformBit), {
      vertex: __spreadProps$l(__spreadValues$L({}, localUniformBit.vertex), {
        // replace the group!
        header: localUniformBit.vertex.header.replace("group(1)", "group(2)")
      })
    });
    const localUniformBitGl = {
      name: "local-uniform-bit",
      vertex: {
        header: (
          /* glsl */
          `

            uniform mat3 uTransformMatrix;
            uniform vec4 uColor;
            uniform float uRound;
        `
        ),
        main: (
          /* glsl */
          `
            vColor *= uColor;
            modelMatrix = uTransformMatrix;
        `
        ),
        end: (
          /* glsl */
          `
            if(uRound == 1.)
            {
                gl_Position.xy = roundPixels(gl_Position.xy, uResolution);
            }
        `
        )
      }
    };

    "use strict";
    const tilingBit = {
      name: "tiling-bit",
      vertex: {
        header: (
          /* wgsl */
          `
            struct TilingUniforms {
                uMapCoord:mat3x3<f32>,
                uClampFrame:vec4<f32>,
                uClampOffset:vec2<f32>,
                uTextureTransform:mat3x3<f32>,
                uSizeAnchor:vec4<f32>
            };

            @group(2) @binding(0) var<uniform> tilingUniforms: TilingUniforms;
            @group(2) @binding(1) var uTexture: texture_2d<f32>;
            @group(2) @binding(2) var uSampler: sampler;
        `
        ),
        main: (
          /* wgsl */
          `
            uv = (tilingUniforms.uTextureTransform * vec3(uv, 1.0)).xy;

            position = (position - tilingUniforms.uSizeAnchor.zw) * tilingUniforms.uSizeAnchor.xy;
        `
        )
      },
      fragment: {
        header: (
          /* wgsl */
          `
            struct TilingUniforms {
                uMapCoord:mat3x3<f32>,
                uClampFrame:vec4<f32>,
                uClampOffset:vec2<f32>,
                uTextureTransform:mat3x3<f32>,
                uSizeAnchor:vec4<f32>
            };

            @group(2) @binding(0) var<uniform> tilingUniforms: TilingUniforms;
            @group(2) @binding(1) var uTexture: texture_2d<f32>;
            @group(2) @binding(2) var uSampler: sampler;
        `
        ),
        main: (
          /* wgsl */
          `

            var coord = vUV + ceil(tilingUniforms.uClampOffset - vUV);
            coord = (tilingUniforms.uMapCoord * vec3(coord, 1.0)).xy;
            var unclamped = coord;
            coord = clamp(coord, tilingUniforms.uClampFrame.xy, tilingUniforms.uClampFrame.zw);

            var bias = 0.;

            if(unclamped.x == coord.x && unclamped.y == coord.y)
            {
                bias = -32.;
            } 

            outColor = textureSampleBias(uTexture, uSampler, coord, bias);
        `
        )
      }
    };
    const tilingBitGl = {
      name: "tiling-bit",
      vertex: {
        header: (
          /* glsl */
          `
            uniform mat3 uTextureTransform;
            uniform vec4 uSizeAnchor;
        
        `
        ),
        main: (
          /* glsl */
          `
            uv = (uTextureTransform * vec3(aUV, 1.0)).xy;

            position = (position - uSizeAnchor.zw) * uSizeAnchor.xy;
        `
        )
      },
      fragment: {
        header: (
          /* glsl */
          `
            uniform sampler2D uTexture;
            uniform mat3 uMapCoord;
            uniform vec4 uClampFrame;
            uniform vec2 uClampOffset;
        `
        ),
        main: (
          /* glsl */
          `

        vec2 coord = vUV + ceil(uClampOffset - vUV);
        coord = (uMapCoord * vec3(coord, 1.0)).xy;
        vec2 unclamped = coord;
        coord = clamp(coord, uClampFrame.xy, uClampFrame.zw);
        
        outColor = texture(uTexture, coord, unclamped == coord ? 0.0 : -32.0);// lod-bias very negative to force lod 0
    
        `
        )
      }
    };

    "use strict";
    let gpuProgram;
    let glProgram;
    class TilingSpriteShader extends Shader {
      constructor() {
        gpuProgram != null ? gpuProgram : gpuProgram = compileHighShaderGpuProgram({
          name: "tiling-sprite-shader",
          bits: [
            localUniformBit,
            tilingBit,
            roundPixelsBit
          ]
        });
        glProgram != null ? glProgram : glProgram = compileHighShaderGlProgram({
          name: "tiling-sprite-shader",
          bits: [
            localUniformBitGl,
            tilingBitGl,
            roundPixelsBitGl
          ]
        });
        const tilingUniforms = new UniformGroup({
          uMapCoord: { value: new Matrix(), type: "mat3x3<f32>" },
          uClampFrame: { value: new Float32Array([0, 0, 1, 1]), type: "vec4<f32>" },
          uClampOffset: { value: new Float32Array([0, 0]), type: "vec2<f32>" },
          uTextureTransform: { value: new Matrix(), type: "mat3x3<f32>" },
          uSizeAnchor: { value: new Float32Array([100, 100, 0.5, 0.5]), type: "vec4<f32>" }
        });
        super({
          glProgram,
          gpuProgram,
          resources: {
            localUniforms: new UniformGroup({
              uTransformMatrix: { value: new Matrix(), type: "mat3x3<f32>" },
              uColor: { value: new Float32Array([1, 1, 1, 1]), type: "vec4<f32>" },
              uRound: { value: 0, type: "f32" }
            }),
            tilingUniforms,
            uTexture: Texture.EMPTY.source,
            uSampler: Texture.EMPTY.source.style
          }
        });
      }
      updateUniforms(width, height, matrix, anchorX, anchorY, texture) {
        const tilingUniforms = this.resources.tilingUniforms;
        const textureWidth = texture.width;
        const textureHeight = texture.height;
        const textureMatrix = texture.textureMatrix;
        const uTextureTransform = tilingUniforms.uniforms.uTextureTransform;
        uTextureTransform.set(
          matrix.a * textureWidth / width,
          matrix.b * textureWidth / height,
          matrix.c * textureHeight / width,
          matrix.d * textureHeight / height,
          matrix.tx / width,
          matrix.ty / height
        );
        uTextureTransform.invert();
        tilingUniforms.uniforms.uMapCoord = textureMatrix.mapCoord;
        tilingUniforms.uniforms.uClampFrame = textureMatrix.uClampFrame;
        tilingUniforms.uniforms.uClampOffset = textureMatrix.uClampOffset;
        tilingUniforms.uniforms.uTextureTransform = uTextureTransform;
        tilingUniforms.uniforms.uSizeAnchor[0] = width;
        tilingUniforms.uniforms.uSizeAnchor[1] = height;
        tilingUniforms.uniforms.uSizeAnchor[2] = anchorX;
        tilingUniforms.uniforms.uSizeAnchor[3] = anchorY;
        if (texture) {
          this.resources.uTexture = texture.source;
          this.resources.uSampler = texture.source.style;
        }
      }
    }

    "use strict";
    class QuadGeometry extends MeshGeometry {
      constructor() {
        super({
          positions: new Float32Array([0, 0, 1, 0, 1, 1, 0, 1]),
          uvs: new Float32Array([0, 0, 1, 0, 1, 1, 0, 1]),
          indices: new Uint32Array([0, 1, 2, 0, 2, 3])
        });
      }
    }

    "use strict";
    function setPositions(tilingSprite, positions) {
      const anchorX = tilingSprite.anchor.x;
      const anchorY = tilingSprite.anchor.y;
      positions[0] = -anchorX * tilingSprite.width;
      positions[1] = -anchorY * tilingSprite.height;
      positions[2] = (1 - anchorX) * tilingSprite.width;
      positions[3] = -anchorY * tilingSprite.height;
      positions[4] = (1 - anchorX) * tilingSprite.width;
      positions[5] = (1 - anchorY) * tilingSprite.height;
      positions[6] = -anchorX * tilingSprite.width;
      positions[7] = (1 - anchorY) * tilingSprite.height;
    }

    "use strict";
    function applyMatrix(array, stride, offset, matrix) {
      let index = 0;
      const size = array.length / (stride || 2);
      const a = matrix.a;
      const b = matrix.b;
      const c = matrix.c;
      const d = matrix.d;
      const tx = matrix.tx;
      const ty = matrix.ty;
      offset *= stride;
      while (index < size) {
        const x = array[offset];
        const y = array[offset + 1];
        array[offset] = a * x + c * y + tx;
        array[offset + 1] = b * x + d * y + ty;
        offset += stride;
        index++;
      }
    }

    "use strict";
    function setUvs(tilingSprite, uvs) {
      const texture = tilingSprite.texture;
      const width = texture.frame.width;
      const height = texture.frame.height;
      let anchorX = 0;
      let anchorY = 0;
      if (tilingSprite.applyAnchorToTexture) {
        anchorX = tilingSprite.anchor.x;
        anchorY = tilingSprite.anchor.y;
      }
      uvs[0] = uvs[6] = -anchorX;
      uvs[2] = uvs[4] = 1 - anchorX;
      uvs[1] = uvs[3] = -anchorY;
      uvs[5] = uvs[7] = 1 - anchorY;
      const textureMatrix = Matrix.shared;
      textureMatrix.copyFrom(tilingSprite._tileTransform.matrix);
      textureMatrix.tx /= tilingSprite.width;
      textureMatrix.ty /= tilingSprite.height;
      textureMatrix.invert();
      textureMatrix.scale(tilingSprite.width / width, tilingSprite.height / height);
      applyMatrix(uvs, 2, 0, textureMatrix);
    }

    "use strict";
    const sharedQuad = new QuadGeometry();
    class TilingSpritePipe {
      constructor(renderer) {
        this._state = State.default2d;
        this._tilingSpriteDataHash = /* @__PURE__ */ Object.create(null);
        this._destroyRenderableBound = this.destroyRenderable.bind(this);
        this._renderer = renderer;
        this._renderer.renderableGC.addManagedHash(this, "_tilingSpriteDataHash");
      }
      validateRenderable(renderable) {
        const tilingSpriteData = this._getTilingSpriteData(renderable);
        const couldBatch = tilingSpriteData.canBatch;
        this._updateCanBatch(renderable);
        const canBatch = tilingSpriteData.canBatch;
        if (canBatch && canBatch === couldBatch) {
          const { batchableMesh } = tilingSpriteData;
          if (batchableMesh && batchableMesh.texture._source !== renderable.texture._source) {
            return !batchableMesh._batcher.checkAndUpdateTexture(batchableMesh, renderable.texture);
          }
        }
        return couldBatch !== canBatch;
      }
      addRenderable(tilingSprite, instructionSet) {
        const batcher = this._renderer.renderPipes.batch;
        this._updateCanBatch(tilingSprite);
        const tilingSpriteData = this._getTilingSpriteData(tilingSprite);
        const { geometry, canBatch } = tilingSpriteData;
        if (canBatch) {
          tilingSpriteData.batchableMesh || (tilingSpriteData.batchableMesh = new BatchableMesh());
          const batchableMesh = tilingSpriteData.batchableMesh;
          if (tilingSprite.didViewUpdate) {
            this._updateBatchableMesh(tilingSprite);
            batchableMesh.geometry = geometry;
            batchableMesh.renderable = tilingSprite;
            batchableMesh.transform = tilingSprite.groupTransform;
            batchableMesh.texture = tilingSprite._texture;
          }
          batchableMesh.roundPixels = this._renderer._roundPixels | tilingSprite._roundPixels;
          batcher.addToBatch(batchableMesh, instructionSet);
        } else {
          batcher.break(instructionSet);
          tilingSpriteData.shader || (tilingSpriteData.shader = new TilingSpriteShader());
          this.updateRenderable(tilingSprite);
          instructionSet.add(tilingSprite);
        }
      }
      execute(tilingSprite) {
        const { shader } = this._tilingSpriteDataHash[tilingSprite.uid];
        shader.groups[0] = this._renderer.globalUniforms.bindGroup;
        const localUniforms = shader.resources.localUniforms.uniforms;
        localUniforms.uTransformMatrix = tilingSprite.groupTransform;
        localUniforms.uRound = this._renderer._roundPixels | tilingSprite._roundPixels;
        color32BitToUniform(
          tilingSprite.groupColorAlpha,
          localUniforms.uColor,
          0
        );
        this._state.blendMode = getAdjustedBlendModeBlend(tilingSprite.groupBlendMode, tilingSprite.texture._source);
        this._renderer.encoder.draw({
          geometry: sharedQuad,
          shader,
          state: this._state
        });
      }
      updateRenderable(tilingSprite) {
        const tilingSpriteData = this._getTilingSpriteData(tilingSprite);
        const { canBatch } = tilingSpriteData;
        if (canBatch) {
          const { batchableMesh } = tilingSpriteData;
          if (tilingSprite.didViewUpdate)
            this._updateBatchableMesh(tilingSprite);
          batchableMesh._batcher.updateElement(batchableMesh);
        } else if (tilingSprite.didViewUpdate) {
          const { shader } = tilingSpriteData;
          shader.updateUniforms(
            tilingSprite.width,
            tilingSprite.height,
            tilingSprite._tileTransform.matrix,
            tilingSprite.anchor.x,
            tilingSprite.anchor.y,
            tilingSprite.texture
          );
        }
      }
      destroyRenderable(tilingSprite) {
        var _a;
        const tilingSpriteData = this._getTilingSpriteData(tilingSprite);
        tilingSpriteData.batchableMesh = null;
        (_a = tilingSpriteData.shader) == null ? void 0 : _a.destroy();
        this._tilingSpriteDataHash[tilingSprite.uid] = null;
        tilingSprite.off("destroyed", this._destroyRenderableBound);
      }
      _getTilingSpriteData(renderable) {
        return this._tilingSpriteDataHash[renderable.uid] || this._initTilingSpriteData(renderable);
      }
      _initTilingSpriteData(tilingSprite) {
        const geometry = new MeshGeometry({
          indices: sharedQuad.indices,
          positions: sharedQuad.positions.slice(),
          uvs: sharedQuad.uvs.slice()
        });
        this._tilingSpriteDataHash[tilingSprite.uid] = {
          canBatch: true,
          renderable: tilingSprite,
          geometry
        };
        tilingSprite.on("destroyed", this._destroyRenderableBound);
        return this._tilingSpriteDataHash[tilingSprite.uid];
      }
      _updateBatchableMesh(tilingSprite) {
        const renderableData = this._getTilingSpriteData(tilingSprite);
        const { geometry } = renderableData;
        const style = tilingSprite.texture.source.style;
        if (style.addressMode !== "repeat") {
          style.addressMode = "repeat";
          style.update();
        }
        setUvs(tilingSprite, geometry.uvs);
        setPositions(tilingSprite, geometry.positions);
      }
      destroy() {
        for (const i in this._tilingSpriteDataHash) {
          this.destroyRenderable(this._tilingSpriteDataHash[i].renderable);
        }
        this._tilingSpriteDataHash = null;
        this._renderer = null;
      }
      _updateCanBatch(tilingSprite) {
        const renderableData = this._getTilingSpriteData(tilingSprite);
        const texture = tilingSprite.texture;
        let _nonPowOf2wrapping = true;
        if (this._renderer.type === RendererType.WEBGL) {
          _nonPowOf2wrapping = this._renderer.context.supports.nonPowOf2wrapping;
        }
        renderableData.canBatch = texture.textureMatrix.isSimple && (_nonPowOf2wrapping || texture.source.isPowerOfTwo);
        return renderableData.canBatch;
      }
    }
    /** @ignore */
    TilingSpritePipe.extension = {
      type: [
        ExtensionType.WebGLPipes,
        ExtensionType.WebGPUPipes,
        ExtensionType.CanvasPipes
      ],
      name: "tilingSprite"
    };

    "use strict";
    extensions.add(TilingSpritePipe);

    "use strict";
    var __defProp$K = Object.defineProperty;
    var __getOwnPropSymbols$K = Object.getOwnPropertySymbols;
    var __hasOwnProp$K = Object.prototype.hasOwnProperty;
    var __propIsEnum$K = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$K = (obj, key, value) => key in obj ? __defProp$K(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$K = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$K.call(b, prop))
          __defNormalProp$K(a, prop, b[prop]);
      if (__getOwnPropSymbols$K)
        for (var prop of __getOwnPropSymbols$K(b)) {
          if (__propIsEnum$K.call(b, prop))
            __defNormalProp$K(a, prop, b[prop]);
        }
      return a;
    };
    const _PlaneGeometry = class _PlaneGeometry extends MeshGeometry {
      constructor(...args) {
        var _a;
        super({});
        let options = (_a = args[0]) != null ? _a : {};
        if (typeof options === "number") {
          deprecation(v8_0_0, "PlaneGeometry constructor changed please use { width, height, verticesX, verticesY } instead");
          options = {
            width: options,
            height: args[1],
            verticesX: args[2],
            verticesY: args[3]
          };
        }
        this.build(options);
      }
      /**
       * Refreshes plane coordinates
       * @param options - Options to be applied to plane geometry
       */
      build(options) {
        var _a, _b, _c, _d;
        options = __spreadValues$K(__spreadValues$K({}, _PlaneGeometry.defaultOptions), options);
        this.verticesX = (_a = this.verticesX) != null ? _a : options.verticesX;
        this.verticesY = (_b = this.verticesY) != null ? _b : options.verticesY;
        this.width = (_c = this.width) != null ? _c : options.width;
        this.height = (_d = this.height) != null ? _d : options.height;
        const total = this.verticesX * this.verticesY;
        const verts = [];
        const uvs = [];
        const indices = [];
        const verticesX = this.verticesX - 1;
        const verticesY = this.verticesY - 1;
        const sizeX = this.width / verticesX;
        const sizeY = this.height / verticesY;
        for (let i = 0; i < total; i++) {
          const x = i % this.verticesX;
          const y = i / this.verticesX | 0;
          verts.push(x * sizeX, y * sizeY);
          uvs.push(x / verticesX, y / verticesY);
        }
        const totalSub = verticesX * verticesY;
        for (let i = 0; i < totalSub; i++) {
          const xpos = i % verticesX;
          const ypos = i / verticesX | 0;
          const value = ypos * this.verticesX + xpos;
          const value2 = ypos * this.verticesX + xpos + 1;
          const value3 = (ypos + 1) * this.verticesX + xpos;
          const value4 = (ypos + 1) * this.verticesX + xpos + 1;
          indices.push(
            value,
            value2,
            value3,
            value2,
            value4,
            value3
          );
        }
        this.buffers[0].data = new Float32Array(verts);
        this.buffers[1].data = new Float32Array(uvs);
        this.indexBuffer.data = new Uint32Array(indices);
        this.buffers[0].update();
        this.buffers[1].update();
        this.indexBuffer.update();
      }
    };
    _PlaneGeometry.defaultOptions = {
      width: 100,
      height: 100,
      verticesX: 10,
      verticesY: 10
    };
    let PlaneGeometry = _PlaneGeometry;

    "use strict";
    var __defProp$J = Object.defineProperty;
    var __getOwnPropSymbols$J = Object.getOwnPropertySymbols;
    var __hasOwnProp$J = Object.prototype.hasOwnProperty;
    var __propIsEnum$J = Object.prototype.propertyIsEnumerable;
    var __defNormalProp$J = (obj, key, value) => key in obj ? __defProp$J(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
    var __spreadValues$J = (a, b) => {
      for (var prop in b || (b = {}))
        if (__hasOwnProp$J.call(b, prop))
          __defNormalProp$J(a, prop, b[prop]);
      if (__getOwnPropSymbols$J)
        for (var prop of __getOwnPropSymbols$J(b)) {
          if (__propIsEnum$J.call(b, prop))
            __defNormalProp$J(a, prop, b[prop]);
        }
      return a;
    };
    const _NineSliceGeometry = class _NineSliceGeometry extends PlaneGeometry {
      constructor(options = {}) {
        options = __spreadValues$J(__spreadValues$J({}, _NineSliceGeometry.defaultOptions), options);
        super({
          width: options.width,
          height: options.height,
          verticesX: 4,
          verticesY: 4
        });
        this.update(options);
      }
      /**
       * Updates the NineSliceGeometry with the options.
       * @param options - The options of the NineSliceGeometry.
       */
      update(options) {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        this.width = (_a = options.width) != null ? _a : this.width;
        this.height = (_b = options.height) != null ? _b : this.height;
        this._originalWidth = (_c = options.originalWidth) != null ? _c : this._originalWidth;
        this._originalHeight = (_d = options.originalHeight) != null ? _d : this._originalHeight;
        this._leftWidth = (_e = options.leftWidth) != null ? _e : this._leftWidth;
        this._rightWidth = (_f = options.rightWidth) != null ? _f : this._rightWidth;
        this._topHeight = (_g = options.topHeight) != null ? _g : this._topHeight;
        this._bottomHeight = (_h = options.bottomHeight) != null ? _h : this._bottomHeight;
        this.updateUvs();
        this.updatePositions();
      }
      /** Updates the positions of the vertices. */
      updatePositions() {
        const positions = this.positions;
        const w = this._leftWidth + this._rightWidth;
        const scaleW = this.width > w ? 1 : this.width / w;
        const h = this._topHeight + this._bottomHeight;
        const scaleH = this.height > h ? 1 : this.height / h;
        const scale = Math.min(scaleW, scaleH);
        positions[9] = positions[11] = positions[13] = positions[15] = this._topHeight * scale;
        positions[17] = positions[19] = positions[21] = positions[23] = this.height - this._bottomHeight * scale;
        positions[25] = positions[27] = positions[29] = positions[31] = this.height;
        positions[2] = positions[10] = positions[18] = positions[26] = this._leftWidth * scale;
        positions[4] = positions[12] = positions[20] = positions[28] = this.width - this._rightWidth * scale;
        positions[6] = positions[14] = positions[22] = positions[30] = this.width;
        this.getBuffer("aPosition").update();
      }
      /** Updates the UVs of the vertices. */
      updateUvs() {
        const uvs = this.uvs;
        uvs[0] = uvs[8] = uvs[16] = uvs[24] = 0;
        uvs[1] = uvs[3] = uvs[5] = uvs[7] = 0;
        uvs[6] = uvs[14] = uvs[22] = uvs[30] = 1;
        uvs[25] = uvs[27] = uvs[29] = uvs[31] = 1;
        const _uvw = 1 / this._originalWidth;
        const _uvh = 1 / this._originalHeight;
        uvs[2] = uvs[10] = uvs[18] = uvs[26] = _uvw * this._leftWidth;
        uvs[9] = uvs[11] = uvs[13] = uvs[15] = _uvh * this._topHeight;
        uvs[4] = uvs[12] = uvs[20] = uvs[28] = 1 - _uvw * this._rightWidth;
        uvs[17] = uvs[19] = uvs[21] = uvs[23] = 1 - _uvh * this._bottomHeight;
        this.getBuffer("aUV").update();
      }
    };
    /** The default options for the NineSliceGeometry. */
    _NineSliceGeometry.defaultOptions = {
      /** The width of the NineSlicePlane, setting this will actually modify the vertices and UV's of this plane. */
      width: 100,
      /** The height of the NineSlicePlane, setting this will actually modify the vertices and UV's of this plane. */
      height: 100,
      /** The width of the left column. */
      leftWidth: 10,
      /** The height of the top row. */
      topHeight: 10,
      /** The width of the right column. */
      rightWidth: 10,
      /** The height of the bottom row. */
      bottomHeight: 10,
      /** The original width of the texture */
      originalWidth: 100,
      /** The original height of the texture */
      originalHeight: 100
    };
    let NineSliceGeometry = _NineSliceGeometry;

    "use strict";
    class NineSliceSpritePipe {
      constructor(renderer) {
        this._gpuSpriteHash = /* @__PURE__ */ Object.create(null);
        this._destroyRenderableBound = this.destroyRenderable.bind(this);
        this._renderer = renderer;
        this._renderer.renderableGC.addManagedHash(this, "_gpuSpriteHash");
      }
      addRenderable(sprite, instructionSet) {
        const gpuSprite = this._getGpuSprite(sprite);
        if (sprite.didViewUpdate)
          this._updateBatchableSprite(sprite, gpuSprite);
        this._renderer.renderPipes.batch.addToBatch(gpuSprite, instructionSet);
      }
      updateRenderable(sprite) {
        const gpuSprite = this._gpuSpriteHash[sprite.uid];
        if (sprite.didViewUpdate)
          this._updateBatchableSprite(sprite, gpuSprite);
        gpuSprite._batcher.updateElement(gpuSprite);
      }
      validateRenderable(sprite) {
        const texture = sprite._texture;
        const gpuSprite = this._getGpuSprite(sprite);
        if (gpuSprite.texture._source !== texture._source) {
          return !gpuSprite._batcher.checkAndUpdateTexture(gpuSprite, texture);
        }
        return false;
      }
      destroyRenderable(sprite) {
        const batchableMesh = this._gpuSpriteHash[sprite.uid];
        BigPool.return(batchableMesh.geometry);
        BigPool.return(batchableMesh);
        this._gpuSpriteHash[sprite.uid] = null;
        sprite.off("destroyed", this._destroyRenderableBound);
      }
      _updateBatchableSprite(sprite, batchableSprite) {
        batchableSprite.geometry.update(sprite);
        batchableSprite.texture = sprite._texture;
      }
      _getGpuSprite(sprite) {
        return this._gpuSpriteHash[sprite.uid] || this._initGPUSprite(sprite);
      }
      _initGPUSprite(sprite) {
        const batchableMesh = BigPool.get(BatchableMesh);
        batchableMesh.geometry = BigPool.get(NineSliceGeometry);
        batchableMesh.renderable = sprite;
        batchableMesh.transform = sprite.groupTransform;
        batchableMesh.texture = sprite._texture;
        batchableMesh.roundPixels = this._renderer._roundPixels | sprite._roundPixels;
        this._gpuSpriteHash[sprite.uid] = batchableMesh;
        if (!sprite.didViewUpdate) {
          this._updateBatchableSprite(sprite, batchableMesh);
        }
        sprite.on("destroyed", this._destroyRenderableBound);
        return batchableMesh;
      }
      destroy() {
        for (const i in this._gpuSpriteHash) {
          const batchableMesh = this._gpuSpriteHash[i];
          batchableMesh.geometry.destroy();
        }
        this._gpuSpriteHash = null;
        this._renderer = null;
      }
    }
    /** @ignore */
    NineSliceSpritePipe.extension = {
      type: [
        ExtensionType.WebGLPipes,
        ExtensionType.WebGPUPipes,
        ExtensionType.CanvasPipes
      ],
      name: "nineSliceSprite"
    };

    "use strict";
    extensions.add(NineSliceSpritePipe);

    "use strict";
    class FilterPipe {
      constructor(renderer) {
        this._renderer = renderer;
      }
      push(filterEffect, container, instructionSet) {
        const renderPipes = this._renderer.renderPipes;
        renderPipes.batch.break(instructionSet);
        instructionSet.add({
          renderPipeId: "filter",
          canBundle: false,
          action: "pushFilter",
          container,
          filterEffect
        });
      }
      pop(_filterEffect, _container, instructionSet) {
        this._renderer.renderPipes.batch.break(instructionSet);
        instructionSet.add({
          renderPipeId: "filter",
          action: "popFilter",
          canBundle: false
        });
      }
      execute(instruction) {
        if (instruction.action === "pushFilter") {
          this._renderer.filter.push(instruction);
        } else if (instruction.action === "popFilter") {
          this._renderer.filter.pop();
        }
      }
      destroy() {
        this._renderer = null;
      }
    }
    FilterPipe.extension = {
      type: [
        ExtensionType.WebGLPipes,
        ExtensionType.WebGPUPipes,
        ExtensionType.CanvasPipes
      ],
      name: "filter"
    };

    "use strict";
    const tempMatrix$3 = new Matrix();
    function getFastGlobalBounds(target, bounds) {
      bounds.clear();
      _getGlobalBoundsRecursive(target, bounds);
      if (!bounds.isValid) {
        bounds.set(0, 0, 0, 0);
      }
      const renderGroup = target.renderGroup || target.parentRenderGroup;
      bounds.applyMatrix(renderGroup.worldTransform);
      return bounds;
    }
    function _getGlobalBoundsRecursive(target, bounds) {
      if (target.localDisplayStatus !== 7 || !target.measurable) {
        return;
      }
      const manageEffects = !!target.effects.length;
      let localBounds = bounds;
      if (target.renderGroup || manageEffects) {
        localBounds = boundsPool.get().clear();
      }
      if (target.boundsArea) {
        bounds.addRect(target.boundsArea, target.worldTransform);
      } else {
        if (target.renderPipeId) {
          const viewBounds = target.bounds;
          localBounds.addFrame(
            viewBounds.minX,
            viewBounds.minY,
            viewBounds.maxX,
            viewBounds.maxY,
            target.groupTransform
          );
        }
        const children = target.children;
        for (let i = 0; i < children.length; i++) {
          _getGlobalBoundsRecursive(children[i], localBounds);
        }
      }
      if (manageEffects) {
        let advanced = false;
        for (let i = 0; i < target.effects.length; i++) {
          if (target.effects[i].addBounds) {
            if (!advanced) {
              advanced = true;
              localBounds.applyMatrix(target.parentRenderGroup.worldTransform);
            }
            target.effects[i].addBounds(localBounds, true);
          }
        }
        if (advanced) {
          localBounds.applyMatrix(target.parentRenderGroup.worldTransform.copyTo(tempMatrix$3).invert());
          bounds.addBounds(localBounds, target.relativeGroupTransform);
        }
        bounds.addBounds(localBounds);
        boundsPool.return(localBounds);
      } else if (target.renderGroup) {
        bounds.addBounds(localBounds, target.relativeGroupTransform);
        boundsPool.return(localBounds);
      }
    }

    "use strict";
    function getGlobalRenderableBounds(renderables, bounds) {
      bounds.clear();
      const tempMatrix = bounds.matrix;
      for (let i = 0; i < renderables.length; i++) {
        const renderable = renderables[i];
        if (renderable.globalDisplayStatus < 7) {
          continue;
        }
        bounds.matrix = renderable.worldTransform;
        bounds.addBounds(renderable.bounds);
      }
      bounds.matrix = tempMatrix;
      return bounds;
    }

    "use strict";
    const quadGeometry = new Geometry({
      attributes: {
        aPosition: {
          buffer: new Float32Array([0, 0, 1, 0, 1, 1, 0, 1]),
          format: "float32x2",
          stride: 2 * 4,
          offset: 0
        }
      },
      indexBuffer: new Uint32Array([0, 1, 2, 0, 2, 3])
    });
    class FilterSystem {
      constructor(renderer) {
        this._filterStackIndex = 0;
        this._filterStack = [];
        this._filterGlobalUniforms = new UniformGroup({
          uInputSize: { value: new Float32Array(4), type: "vec4<f32>" },
          uInputPixel: { value: new Float32Array(4), type: "vec4<f32>" },
          uInputClamp: { value: new Float32Array(4), type: "vec4<f32>" },
          uOutputFrame: { value: new Float32Array(4), type: "vec4<f32>" },
          uGlobalFrame: { value: new Float32Array(4), type: "vec4<f32>" },
          uOutputTexture: { value: new Float32Array(4), type: "vec4<f32>" }
        });
        this._globalFilterBindGroup = new BindGroup({});
        this.renderer = renderer;
      }
      /**
       * The back texture of the currently active filter. Requires the filter to have `blendRequired` set to true.
       * @readonly
       */
      get activeBackTexture() {
        var _a;
        return (_a = this._activeFilterData) == null ? void 0 : _a.backTexture;
      }
      push(instruction) {
        var _a, _b;
        const renderer = this.renderer;
        const filters = instruction.filterEffect.filters;
        if (!this._filterStack[this._filterStackIndex]) {
          this._filterStack[this._filterStackIndex] = this._getFilterData();
        }
        const filterData = this._filterStack[this._filterStackIndex];
        this._filterStackIndex++;
        if (filters.length === 0) {
          filterData.skip = true;
          return;
        }
        const bounds = filterData.bounds;
        if (instruction.renderables) {
          getGlobalRenderableBounds(instruction.renderables, bounds);
        } else if (instruction.filterEffect.filterArea) {
          bounds.clear();
          bounds.addRect(instruction.filterEffect.filterArea);
          bounds.applyMatrix(instruction.container.worldTransform);
        } else {
          getFastGlobalBounds(instruction.container, bounds);
        }
        if (instruction.container) {
          const renderGroup = instruction.container.renderGroup || instruction.container.parentRenderGroup;
          const filterFrameTransform = renderGroup.cacheToLocalTransform;
          if (filterFrameTransform) {
            bounds.applyMatrix(filterFrameTransform);
          }
        }
        const colorTextureSource = renderer.renderTarget.renderTarget.colorTexture.source;
        let resolution = Infinity;
        let padding = 0;
        let antialias = true;
        let blendRequired = false;
        let enabled = false;
        let clipToViewport = true;
        for (let i = 0; i < filters.length; i++) {
          const filter = filters[i];
          resolution = Math.min(resolution, filter.resolution === "inherit" ? colorTextureSource._resolution : filter.resolution);
          padding += filter.padding;
          if (filter.antialias === "off") {
            antialias = false;
          } else if (filter.antialias === "inherit") {
            antialias && (antialias = colorTextureSource.antialias);
          }
          if (!filter.clipToViewport) {
            clipToViewport = false;
          }
          const isCompatible = !!(filter.compatibleRenderers & renderer.type);
          if (!isCompatible) {
            enabled = false;
            break;
          }
          if (filter.blendRequired && !((_b = (_a = renderer.backBuffer) == null ? void 0 : _a.useBackBuffer) != null ? _b : true)) {
            warn("Blend filter requires backBuffer on WebGL renderer to be enabled. Set `useBackBuffer: true` in the renderer options.");
            enabled = false;
            break;
          }
          enabled = filter.enabled || enabled;
          blendRequired || (blendRequired = filter.blendRequired);
        }
        if (!enabled) {
          filterData.skip = true;
          return;
        }
        if (clipToViewport) {
          const viewPort = renderer.renderTarget.rootViewPort;
          bounds.fitBounds(0, viewPort.width, 0, viewPort.height);
        }
        bounds.scale(resolution).ceil().scale(1 / resolution).pad(padding | 0);
        if (!bounds.isPositive) {
          filterData.skip = true;
          return;
        }
        filterData.skip = false;
        filterData.bounds = bounds;
        filterData.blendRequired = blendRequired;
        filterData.container = instruction.container;
        filterData.filterEffect = instruction.filterEffect;
        filterData.previousRenderSurface = renderer.renderTarget.renderSurface;
        filterData.inputTexture = TexturePool.getOptimalTexture(
          bounds.width,
          bounds.height,
          resolution,
          antialias
        );
        renderer.renderTarget.bind(filterData.inputTexture, true);
        renderer.globalUniforms.push({
          offset: bounds
        });
      }
      pop() {
        const renderer = this.renderer;
        this._filterStackIndex--;
        const filterData = this._filterStack[this._filterStackIndex];
        if (filterData.skip) {
          return;
        }
        this._activeFilterData = filterData;
        const inputTexture = filterData.inputTexture;
        const bounds = filterData.bounds;
        let backTexture = Texture.EMPTY;
        renderer.renderTarget.finishRenderPass();
        if (filterData.blendRequired) {
          const previousBounds = this._filterStackIndex > 0 ? this._filterStack[this._filterStackIndex - 1].bounds : null;
          const renderTarget = renderer.renderTarget.getRenderTarget(filterData.previousRenderSurface);
          backTexture = this.getBackTexture(renderTarget, bounds, previousBounds);
        }
        filterData.backTexture = backTexture;
        const filters = filterData.filterEffect.filters;
        this._globalFilterBindGroup.setResource(inputTexture.source.style, 2);
        this._globalFilterBindGroup.setResource(backTexture.source, 3);
        renderer.globalUniforms.pop();
        if (filters.length === 1) {
          filters[0].apply(this, inputTexture, filterData.previousRenderSurface, false);
          TexturePool.returnTexture(inputTexture);
        } else {
          let flip = filterData.inputTexture;
          let flop = TexturePool.getOptimalTexture(
            bounds.width,
            bounds.height,
            flip.source._resolution,
            false
          );
          let i = 0;
          for (i = 0; i < filters.length - 1; ++i) {
            const filter = filters[i];
            filter.apply(this, flip, flop, true);
            const t = flip;
            flip = flop;
            flop = t;
          }
          filters[i].apply(this, flip, filterData.previousRenderSurface, false);
          TexturePool.returnTexture(flip);
          TexturePool.returnTexture(flop);
        }
        if (filterData.blendRequired) {
          TexturePool.returnTexture(backTexture);
        }
      }
      getBackTexture(lastRenderSurface, bounds, previousBounds) {
        const backgroundResolution = lastRenderSurface.colorTexture.source._resolution;
        const backTexture = TexturePool.getOptimalTexture(
          bounds.width,
          bounds.height,
          backgroundResolution,
          false
        );
        let x = bounds.minX;
        let y = bounds.minY;
        if (previousBounds) {
          x -= previousBounds.minX;
          y -= previousBounds.minY;
        }
        x = Math.floor(x * backgroundResolution);
        y = Math.floor(y * backgroundResolution);
        const width = Math.ceil(bounds.width * backgroundResolution);
        const height = Math.ceil(bounds.height * backgroundResolution);
        this.renderer.renderTarget.copyToTexture(
          lastRenderSurface,
          backTexture,
          { x, y },
          { width, height },
          { x: 0, y: 0 }
        );
        return backTexture;
      }
      applyFilter(filter, input, output, clear) {
        const renderer = this.renderer;
        const filterData = this._filterStack[this._filterStackIndex];
        const bounds = filterData.bounds;
        const offset = Point.shared;
        const previousRenderSurface = filterData.previousRenderSurface;
        const isFinalTarget = previousRenderSurface === output;
        let resolution = this.renderer.renderTarget.rootRenderTarget.colorTexture.source._resolution;
        let currentIndex = this._filterStackIndex - 1;
        while (currentIndex > 0 && this._filterStack[currentIndex].skip) {
          --currentIndex;
        }
        if (currentIndex > 0) {
          resolution = this._filterStack[currentIndex].inputTexture.source._resolution;
        }
        const filterUniforms = this._filterGlobalUniforms;
        const uniforms = filterUniforms.uniforms;
        const outputFrame = uniforms.uOutputFrame;
        const inputSize = uniforms.uInputSize;
        const inputPixel = uniforms.uInputPixel;
        const inputClamp = uniforms.uInputClamp;
        const globalFrame = uniforms.uGlobalFrame;
        const outputTexture = uniforms.uOutputTexture;
        if (isFinalTarget) {
          let lastIndex = this._filterStackIndex;
          while (lastIndex > 0) {
            lastIndex--;
            const filterData2 = this._filterStack[this._filterStackIndex - 1];
            if (!filterData2.skip) {
              offset.x = filterData2.bounds.minX;
              offset.y = filterData2.bounds.minY;
              break;
            }
          }
          outputFrame[0] = bounds.minX - offset.x;
          outputFrame[1] = bounds.minY - offset.y;
        } else {
          outputFrame[0] = 0;
          outputFrame[1] = 0;
        }
        outputFrame[2] = input.frame.width;
        outputFrame[3] = input.frame.height;
        inputSize[0] = input.source.width;
        inputSize[1] = input.source.height;
        inputSize[2] = 1 / inputSize[0];
        inputSize[3] = 1 / inputSize[1];
        inputPixel[0] = input.source.pixelWidth;
        inputPixel[1] = input.source.pixelHeight;
        inputPixel[2] = 1 / inputPixel[0];
        inputPixel[3] = 1 / inputPixel[1];
        inputClamp[0] = 0.5 * inputPixel[2];
        inputClamp[1] = 0.5 * inputPixel[3];
        inputClamp[2] = input.frame.width * inputSize[2] - 0.5 * inputPixel[2];
        inputClamp[3] = input.frame.height * inputSize[3] - 0.5 * inputPixel[3];
        const rootTexture = this.renderer.renderTarget.rootRenderTarget.colorTexture;
        globalFrame[0] = offset.x * resolution;
        globalFrame[1] = offset.y * resolution;
        globalFrame[2] = rootTexture.source.width * resolution;
        globalFrame[3] = rootTexture.source.height * resolution;
        const renderTarget = this.renderer.renderTarget.getRenderTarget(output);
        renderer.renderTarget.bind(output, !!clear);
        if (output instanceof Texture) {
          outputTexture[0] = output.frame.width;
          outputTexture[1] = output.frame.height;
        } else {
          outputTexture[0] = renderTarget.width;
          out