'use strict';

require('./AssetExtension.js');
var Assets = require('./Assets.js');
var BackgroundLoader = require('./BackgroundLoader.js');
var Cache = require('./cache/Cache.js');
require('./cache/CacheParser.js');
var cacheTextureArray = require('./cache/parsers/cacheTextureArray.js');
var detectAvif = require('./detections/parsers/detectAvif.js');
var detectDefaults = require('./detections/parsers/detectDefaults.js');
var detectMp4 = require('./detections/parsers/detectMp4.js');
var detectOgv = require('./detections/parsers/detectOgv.js');
var detectWebm = require('./detections/parsers/detectWebm.js');
var detectWebp = require('./detections/parsers/detectWebp.js');
require('./detections/types.js');
var testImageFormat = require('./detections/utils/testImageFormat.js');
var testVideoFormat = require('./detections/utils/testVideoFormat.js');
var Loader = require('./loader/Loader.js');
var LoaderParser = require('./loader/parsers/LoaderParser.js');
var loadJson = require('./loader/parsers/loadJson.js');
var loadTxt = require('./loader/parsers/loadTxt.js');
var loadWebFont = require('./loader/parsers/loadWebFont.js');
var loadSVG = require('./loader/parsers/textures/loadSVG.js');
var loadTextures = require('./loader/parsers/textures/loadTextures.js');
var loadVideoTextures = require('./loader/parsers/textures/loadVideoTextures.js');
var createTexture = require('./loader/parsers/textures/utils/createTexture.js');
require('./loader/types.js');
var WorkerManager = require('./loader/workers/WorkerManager.js');
var resolveJsonUrl = require('./resolver/parsers/resolveJsonUrl.js');
var resolveTextureUrl = require('./resolver/parsers/resolveTextureUrl.js');
var Resolver = require('./resolver/Resolver.js');
require('./resolver/types.js');
require('./types.js');
var checkDataUrl = require('./utils/checkDataUrl.js');
var checkExtension = require('./utils/checkExtension.js');
var convertToList = require('./utils/convertToList.js');
var copySearchParams = require('./utils/copySearchParams.js');
var createStringVariations = require('./utils/createStringVariations.js');
var isSingleItem = require('./utils/isSingleItem.js');

"use strict";

exports.Assets = Assets.Assets;
exports.AssetsClass = Assets.AssetsClass;
exports.BackgroundLoader = BackgroundLoader.BackgroundLoader;
exports.Cache = Cache.Cache;
exports.cacheTextureArray = cacheTextureArray.cacheTextureArray;
exports.detectAvif = detectAvif.detectAvif;
exports.detectDefaults = detectDefaults.detectDefaults;
exports.detectMp4 = detectMp4.detectMp4;
exports.detectOgv = detectOgv.detectOgv;
exports.detectWebm = detectWebm.detectWebm;
exports.detectWebp = detectWebp.detectWebp;
exports.testImageFormat = testImageFormat.testImageFormat;
exports.testVideoFormat = testVideoFormat.testVideoFormat;
exports.Loader = Loader.Loader;
exports.LoaderParserPriority = LoaderParser.LoaderParserPriority;
exports.loadJson = loadJson.loadJson;
exports.loadTxt = loadTxt.loadTxt;
exports.getFontFamilyName = loadWebFont.getFontFamilyName;
exports.loadWebFont = loadWebFont.loadWebFont;
exports.loadSvg = loadSVG.loadSvg;
exports.loadImageBitmap = loadTextures.loadImageBitmap;
exports.loadTextures = loadTextures.loadTextures;
exports.crossOrigin = loadVideoTextures.crossOrigin;
exports.determineCrossOrigin = loadVideoTextures.determineCrossOrigin;
exports.loadVideoTextures = loadVideoTextures.loadVideoTextures;
exports.preloadVideo = loadVideoTextures.preloadVideo;
exports.createTexture = createTexture.createTexture;
exports.WorkerManager = WorkerManager.WorkerManager;
exports.resolveJsonUrl = resolveJsonUrl.resolveJsonUrl;
exports.resolveTextureUrl = resolveTextureUrl.resolveTextureUrl;
exports.Resolver = Resolver.Resolver;
exports.getUrlExtension = Resolver.getUrlExtension;
exports.checkDataUrl = checkDataUrl.checkDataUrl;
exports.checkExtension = checkExtension.checkExtension;
exports.convertToList = convertToList.convertToList;
exports.copySearchParams = copySearchParams.copySearchParams;
exports.createStringVariations = createStringVariations.createStringVariations;
exports.isSingleItem = isSingleItem.isSingleItem;
//# sourceMappingURL=index.js.map
