'use strict';

var detectBasis = require('./basis/detectBasis.js');
var loadBasis = require('./basis/loadBasis.js');
require('./basis/types.js');
var createLevelBuffers = require('./basis/utils/createLevelBuffers.js');
var gpuFormatToBasisTranscoderFormat = require('./basis/utils/gpuFormatToBasisTranscoderFormat.js');
var setBasisTranscoderPath = require('./basis/utils/setBasisTranscoderPath.js');
var loadBasisOnWorker = require('./basis/worker/loadBasisOnWorker.js');
var _const = require('./dds/const.js');
var loadDDS = require('./dds/loadDDS.js');
var parseDDS = require('./dds/parseDDS.js');
var loadKTX = require('./ktx/loadKTX.js');
var parseKTX = require('./ktx/parseKTX.js');
var _const$1 = require('./ktx2/const.js');
var loadKTX2 = require('./ktx2/loadKTX2.js');
require('./ktx2/types.js');
var convertFormatIfRequired = require('./ktx2/utils/convertFormatIfRequired.js');
var createLevelBuffersFromKTX = require('./ktx2/utils/createLevelBuffersFromKTX.js');
var getTextureFormatFromKTXTexture = require('./ktx2/utils/getTextureFormatFromKTXTexture.js');
var glFormatToGPUFormat = require('./ktx2/utils/glFormatToGPUFormat.js');
var gpuFormatToKTXBasisTranscoderFormat = require('./ktx2/utils/gpuFormatToKTXBasisTranscoderFormat.js');
var setKTXTranscoderPath = require('./ktx2/utils/setKTXTranscoderPath.js');
var vkFormatToGPUFormat = require('./ktx2/utils/vkFormatToGPUFormat.js');
var loadKTX2onWorker = require('./ktx2/worker/loadKTX2onWorker.js');
var detectCompressed = require('./shared/detectCompressed.js');
var resolveCompressedTextureUrl = require('./shared/resolveCompressedTextureUrl.js');

"use strict";

exports.detectBasis = detectBasis.detectBasis;
exports.loadBasis = loadBasis.loadBasis;
exports.createLevelBuffers = createLevelBuffers.createLevelBuffers;
exports.gpuFormatToBasisTranscoderFormat = gpuFormatToBasisTranscoderFormat.gpuFormatToBasisTranscoderFormat;
exports.basisTranscoderUrls = setBasisTranscoderPath.basisTranscoderUrls;
exports.setBasisTranscoderPath = setBasisTranscoderPath.setBasisTranscoderPath;
exports.loadBasisOnWorker = loadBasisOnWorker.loadBasisOnWorker;
exports.D3D10_RESOURCE_DIMENSION = _const.D3D10_RESOURCE_DIMENSION;
exports.D3DFMT = _const.D3DFMT;
exports.DDS = _const.DDS;
exports.DXGI_FORMAT = _const.DXGI_FORMAT;
exports.DXGI_TO_TEXTURE_FORMAT = _const.DXGI_TO_TEXTURE_FORMAT;
exports.FOURCC_TO_TEXTURE_FORMAT = _const.FOURCC_TO_TEXTURE_FORMAT;
exports.TEXTURE_FORMAT_BLOCK_SIZE = _const.TEXTURE_FORMAT_BLOCK_SIZE;
exports.loadDDS = loadDDS.loadDDS;
exports.parseDDS = parseDDS.parseDDS;
exports.loadKTX = loadKTX.loadKTX;
exports.parseKTX = parseKTX.parseKTX;
exports.GL_INTERNAL_FORMAT = _const$1.GL_INTERNAL_FORMAT;
exports.KTX = _const$1.KTX;
exports.loadKTX2 = loadKTX2.loadKTX2;
exports.convertFormatIfRequired = convertFormatIfRequired.convertFormatIfRequired;
exports.createLevelBuffersFromKTX = createLevelBuffersFromKTX.createLevelBuffersFromKTX;
exports.getTextureFormatFromKTXTexture = getTextureFormatFromKTXTexture.getTextureFormatFromKTXTexture;
exports.glFormatToGPUFormat = glFormatToGPUFormat.glFormatToGPUFormat;
exports.gpuFormatToKTXBasisTranscoderFormat = gpuFormatToKTXBasisTranscoderFormat.gpuFormatToKTXBasisTranscoderFormat;
exports.ktxTranscoderUrls = setKTXTranscoderPath.ktxTranscoderUrls;
exports.setKTXTranscoderPath = setKTXTranscoderPath.setKTXTranscoderPath;
exports.vkFormatToGPUFormat = vkFormatToGPUFormat.vkFormatToGPUFormat;
exports.loadKTX2onWorker = loadKTX2onWorker.loadKTX2onWorker;
exports.detectCompressed = detectCompressed.detectCompressed;
exports.resolveCompressedTextureUrl = resolveCompressedTextureUrl.resolveCompressedTextureUrl;
exports.validFormats = resolveCompressedTextureUrl.validFormats;
//# sourceMappingURL=index.js.map
