'use strict';

var browserExt = require('./environment-browser/browserExt.js');
var webworkerExt = require('./environment-webworker/webworkerExt.js');
var Extensions = require('./extensions/Extensions.js');
require('./rendering/init.js');
require('./spritesheet/init.js');
require('./accessibility/index.js');
require('./advanced-blend-modes/index.js');
require('./app/index.js');
require('./assets/index.js');
require('./color/index.js');
require('./compressed-textures/index.js');
require('./culling/index.js');
require('./environment/index.js');
require('./environment-browser/index.js');
require('./environment-webworker/index.js');
require('./events/index.js');
require('./extensions/index.js');
require('./filters/index.js');
require('./maths/index.js');
require('./prepare/index.js');
require('./rendering/index.js');
require('./scene/index.js');
require('./spritesheet/index.js');
require('./ticker/index.js');
require('./utils/index.js');
var AccessibilitySystem = require('./accessibility/AccessibilitySystem.js');
var accessibilityTarget = require('./accessibility/accessibilityTarget.js');
var ColorBlend = require('./advanced-blend-modes/ColorBlend.js');
var ColorBurnBlend = require('./advanced-blend-modes/ColorBurnBlend.js');
var ColorDodgeBlend = require('./advanced-blend-modes/ColorDodgeBlend.js');
var DarkenBlend = require('./advanced-blend-modes/DarkenBlend.js');
var DifferenceBlend = require('./advanced-blend-modes/DifferenceBlend.js');
var DivideBlend = require('./advanced-blend-modes/DivideBlend.js');
var ExclusionBlend = require('./advanced-blend-modes/ExclusionBlend.js');
var HardLightBlend = require('./advanced-blend-modes/HardLightBlend.js');
var HardMixBlend = require('./advanced-blend-modes/HardMixBlend.js');
var LightenBlend = require('./advanced-blend-modes/LightenBlend.js');
var LinearBurnBlend = require('./advanced-blend-modes/LinearBurnBlend.js');
var LinearDodgeBlend = require('./advanced-blend-modes/LinearDodgeBlend.js');
var LinearLightBlend = require('./advanced-blend-modes/LinearLightBlend.js');
var LuminosityBlend = require('./advanced-blend-modes/LuminosityBlend.js');
var NegationBlend = require('./advanced-blend-modes/NegationBlend.js');
var OverlayBlend = require('./advanced-blend-modes/OverlayBlend.js');
var PinLightBlend = require('./advanced-blend-modes/PinLightBlend.js');
var SaturationBlend = require('./advanced-blend-modes/SaturationBlend.js');
var SoftLightBlend = require('./advanced-blend-modes/SoftLightBlend.js');
var SubtractBlend = require('./advanced-blend-modes/SubtractBlend.js');
var VividLightBlend = require('./advanced-blend-modes/VividLightBlend.js');
var Application = require('./app/Application.js');
var ResizePlugin = require('./app/ResizePlugin.js');
var TickerPlugin = require('./app/TickerPlugin.js');
var Assets = require('./assets/Assets.js');
var BackgroundLoader = require('./assets/BackgroundLoader.js');
var Cache = require('./assets/cache/Cache.js');
var cacheTextureArray = require('./assets/cache/parsers/cacheTextureArray.js');
var detectAvif = require('./assets/detections/parsers/detectAvif.js');
var detectDefaults = require('./assets/detections/parsers/detectDefaults.js');
var detectMp4 = require('./assets/detections/parsers/detectMp4.js');
var detectOgv = require('./assets/detections/parsers/detectOgv.js');
var detectWebm = require('./assets/detections/parsers/detectWebm.js');
var detectWebp = require('./assets/detections/parsers/detectWebp.js');
var testImageFormat = require('./assets/detections/utils/testImageFormat.js');
var testVideoFormat = require('./assets/detections/utils/testVideoFormat.js');
var Loader = require('./assets/loader/Loader.js');
var LoaderParser = require('./assets/loader/parsers/LoaderParser.js');
var loadJson = require('./assets/loader/parsers/loadJson.js');
var loadTxt = require('./assets/loader/parsers/loadTxt.js');
var loadWebFont = require('./assets/loader/parsers/loadWebFont.js');
var loadSVG = require('./assets/loader/parsers/textures/loadSVG.js');
var loadTextures = require('./assets/loader/parsers/textures/loadTextures.js');
var loadVideoTextures = require('./assets/loader/parsers/textures/loadVideoTextures.js');
var createTexture = require('./assets/loader/parsers/textures/utils/createTexture.js');
var WorkerManager = require('./assets/loader/workers/WorkerManager.js');
var resolveJsonUrl = require('./assets/resolver/parsers/resolveJsonUrl.js');
var resolveTextureUrl = require('./assets/resolver/parsers/resolveTextureUrl.js');
var Resolver = require('./assets/resolver/Resolver.js');
var checkDataUrl = require('./assets/utils/checkDataUrl.js');
var checkExtension = require('./assets/utils/checkExtension.js');
var convertToList = require('./assets/utils/convertToList.js');
var copySearchParams = require('./assets/utils/copySearchParams.js');
var createStringVariations = require('./assets/utils/createStringVariations.js');
var isSingleItem = require('./assets/utils/isSingleItem.js');
var Color = require('./color/Color.js');
var detectBasis = require('./compressed-textures/basis/detectBasis.js');
var loadBasis = require('./compressed-textures/basis/loadBasis.js');
var createLevelBuffers = require('./compressed-textures/basis/utils/createLevelBuffers.js');
var gpuFormatToBasisTranscoderFormat = require('./compressed-textures/basis/utils/gpuFormatToBasisTranscoderFormat.js');
var setBasisTranscoderPath = require('./compressed-textures/basis/utils/setBasisTranscoderPath.js');
var loadBasisOnWorker = require('./compressed-textures/basis/worker/loadBasisOnWorker.js');
var _const = require('./compressed-textures/dds/const.js');
var loadDDS = require('./compressed-textures/dds/loadDDS.js');
var parseDDS = require('./compressed-textures/dds/parseDDS.js');
var loadKTX = require('./compressed-textures/ktx/loadKTX.js');
var parseKTX = require('./compressed-textures/ktx/parseKTX.js');
var _const$1 = require('./compressed-textures/ktx2/const.js');
var loadKTX2 = require('./compressed-textures/ktx2/loadKTX2.js');
var convertFormatIfRequired = require('./compressed-textures/ktx2/utils/convertFormatIfRequired.js');
var createLevelBuffersFromKTX = require('./compressed-textures/ktx2/utils/createLevelBuffersFromKTX.js');
var getTextureFormatFromKTXTexture = require('./compressed-textures/ktx2/utils/getTextureFormatFromKTXTexture.js');
var glFormatToGPUFormat = require('./compressed-textures/ktx2/utils/glFormatToGPUFormat.js');
var gpuFormatToKTXBasisTranscoderFormat = require('./compressed-textures/ktx2/utils/gpuFormatToKTXBasisTranscoderFormat.js');
var setKTXTranscoderPath = require('./compressed-textures/ktx2/utils/setKTXTranscoderPath.js');
var vkFormatToGPUFormat = require('./compressed-textures/ktx2/utils/vkFormatToGPUFormat.js');
var loadKTX2onWorker = require('./compressed-textures/ktx2/worker/loadKTX2onWorker.js');
var detectCompressed = require('./compressed-textures/shared/detectCompressed.js');
var resolveCompressedTextureUrl = require('./compressed-textures/shared/resolveCompressedTextureUrl.js');
var Culler = require('./culling/Culler.js');
var CullerPlugin = require('./culling/CullerPlugin.js');
var cullingMixin = require('./culling/cullingMixin.js');
var adapter = require('./environment/adapter.js');
var autoDetectEnvironment = require('./environment/autoDetectEnvironment.js');
var BrowserAdapter = require('./environment-browser/BrowserAdapter.js');
var WebWorkerAdapter = require('./environment-webworker/WebWorkerAdapter.js');
var EventBoundary = require('./events/EventBoundary.js');
var EventSystem = require('./events/EventSystem.js');
var EventTicker = require('./events/EventTicker.js');
var FederatedEvent = require('./events/FederatedEvent.js');
var FederatedEventTarget = require('./events/FederatedEventTarget.js');
var FederatedMouseEvent = require('./events/FederatedMouseEvent.js');
var FederatedPointerEvent = require('./events/FederatedPointerEvent.js');
var FederatedWheelEvent = require('./events/FederatedWheelEvent.js');
var blendTemplate = require('./filters/blend-modes/blend-template.frag.js');
var blendTemplate$1 = require('./filters/blend-modes/blend-template.vert.js');
var blendTemplate$2 = require('./filters/blend-modes/blend-template.wgsl.js');
var hsl = require('./filters/blend-modes/hsl.wgsl.js');
var alpha = require('./filters/defaults/alpha/alpha.frag.js');
var alpha$1 = require('./filters/defaults/alpha/alpha.wgsl.js');
var blurTemplate = require('./filters/defaults/blur/gpu/blur-template.wgsl.js');
var colorMatrixFilter = require('./filters/defaults/color-matrix/colorMatrixFilter.frag.js');
var colorMatrixFilter$1 = require('./filters/defaults/color-matrix/colorMatrixFilter.wgsl.js');
var defaultFilter = require('./filters/defaults/defaultFilter.vert.js');
var displacement = require('./filters/defaults/displacement/displacement.frag.js');
var displacement$1 = require('./filters/defaults/displacement/displacement.vert.js');
var displacement$2 = require('./filters/defaults/displacement/displacement.wgsl.js');
var noise = require('./filters/defaults/noise/noise.frag.js');
var noise$1 = require('./filters/defaults/noise/noise.wgsl.js');
var mask = require('./filters/mask/mask.frag.js');
var mask$1 = require('./filters/mask/mask.vert.js');
var mask$2 = require('./filters/mask/mask.wgsl.js');
var BlendModeFilter = require('./filters/blend-modes/BlendModeFilter.js');
var GLhls = require('./filters/blend-modes/hls/GLhls.js');
var GPUhls = require('./filters/blend-modes/hls/GPUhls.js');
var AlphaFilter = require('./filters/defaults/alpha/AlphaFilter.js');
var BlurFilter = require('./filters/defaults/blur/BlurFilter.js');
var BlurFilterPass = require('./filters/defaults/blur/BlurFilterPass.js');
var _const$2 = require('./filters/defaults/blur/const.js');
var generateBlurFragSource = require('./filters/defaults/blur/gl/generateBlurFragSource.js');
var generateBlurGlProgram = require('./filters/defaults/blur/gl/generateBlurGlProgram.js');
var generateBlurVertSource = require('./filters/defaults/blur/gl/generateBlurVertSource.js');
var generateBlurProgram = require('./filters/defaults/blur/gpu/generateBlurProgram.js');
var ColorMatrixFilter = require('./filters/defaults/color-matrix/ColorMatrixFilter.js');
var DisplacementFilter = require('./filters/defaults/displacement/DisplacementFilter.js');
var NoiseFilter = require('./filters/defaults/noise/NoiseFilter.js');
var Filter = require('./filters/Filter.js');
var FilterEffect = require('./filters/FilterEffect.js');
var FilterPipe = require('./filters/FilterPipe.js');
var FilterSystem = require('./filters/FilterSystem.js');
var MaskFilter = require('./filters/mask/MaskFilter.js');
var groupD8 = require('./maths/matrix/groupD8.js');
var Matrix = require('./maths/matrix/Matrix.js');
var _const$3 = require('./maths/misc/const.js');
var pow2 = require('./maths/misc/pow2.js');
var squaredDistanceToLineSegment = require('./maths/misc/squaredDistanceToLineSegment.js');
var ObservablePoint = require('./maths/point/ObservablePoint.js');
var Point = require('./maths/point/Point.js');
var pointInTriangle = require('./maths/point/pointInTriangle.js');
var Circle = require('./maths/shapes/Circle.js');
var Ellipse = require('./maths/shapes/Ellipse.js');
var Polygon = require('./maths/shapes/Polygon.js');
var Rectangle = require('./maths/shapes/Rectangle.js');
var RoundedRectangle = require('./maths/shapes/RoundedRectangle.js');
var Triangle = require('./maths/shapes/Triangle.js');
var PrepareBase = require('./prepare/PrepareBase.js');
var PrepareQueue = require('./prepare/PrepareQueue.js');
var PrepareSystem = require('./prepare/PrepareSystem.js');
var PrepareUpload = require('./prepare/PrepareUpload.js');
var GlBatchAdaptor = require('./rendering/batcher/gl/GlBatchAdaptor.js');
var checkMaxIfStatementsInShader = require('./rendering/batcher/gl/utils/checkMaxIfStatementsInShader.js');
var maxRecommendedTextures = require('./rendering/batcher/gl/utils/maxRecommendedTextures.js');
var generateGPULayout = require('./rendering/batcher/gpu/generateGPULayout.js');
var generateLayout = require('./rendering/batcher/gpu/generateLayout.js');
var getTextureBatchBindGroup = require('./rendering/batcher/gpu/getTextureBatchBindGroup.js');
var GpuBatchAdaptor = require('./rendering/batcher/gpu/GpuBatchAdaptor.js');
var Batcher = require('./rendering/batcher/shared/Batcher.js');
var BatcherPipe = require('./rendering/batcher/shared/BatcherPipe.js');
var BatchGeometry = require('./rendering/batcher/shared/BatchGeometry.js');
var BatchTextureArray = require('./rendering/batcher/shared/BatchTextureArray.js');
var DefaultBatcher = require('./rendering/batcher/shared/DefaultBatcher.js');
var DefaultShader = require('./rendering/batcher/shared/DefaultShader.js');
var compileHighShaderToProgram = require('./rendering/high-shader/compileHighShaderToProgram.js');
var compileHighShader = require('./rendering/high-shader/compiler/compileHighShader.js');
var addBits = require('./rendering/high-shader/compiler/utils/addBits.js');
var compileHooks = require('./rendering/high-shader/compiler/utils/compileHooks.js');
var compileInputs = require('./rendering/high-shader/compiler/utils/compileInputs.js');
var compileOutputs = require('./rendering/high-shader/compiler/utils/compileOutputs.js');
var formatShader = require('./rendering/high-shader/compiler/utils/formatShader.js');
var injectBits = require('./rendering/high-shader/compiler/utils/injectBits.js');
var defaultProgramTemplate = require('./rendering/high-shader/defaultProgramTemplate.js');
var colorBit = require('./rendering/high-shader/shader-bits/colorBit.js');
var generateTextureBatchBit = require('./rendering/high-shader/shader-bits/generateTextureBatchBit.js');
var globalUniformsBit = require('./rendering/high-shader/shader-bits/globalUniformsBit.js');
var localUniformBit = require('./rendering/high-shader/shader-bits/localUniformBit.js');
var roundPixelsBit = require('./rendering/high-shader/shader-bits/roundPixelsBit.js');
var textureBit = require('./rendering/high-shader/shader-bits/textureBit.js');
var AlphaMask = require('./rendering/mask/alpha/AlphaMask.js');
var AlphaMaskPipe = require('./rendering/mask/alpha/AlphaMaskPipe.js');
var ColorMask = require('./rendering/mask/color/ColorMask.js');
var ColorMaskPipe = require('./rendering/mask/color/ColorMaskPipe.js');
var MaskEffectManager = require('./rendering/mask/MaskEffectManager.js');
var ScissorMask = require('./rendering/mask/scissor/ScissorMask.js');
var StencilMask = require('./rendering/mask/stencil/StencilMask.js');
var StencilMaskPipe = require('./rendering/mask/stencil/StencilMaskPipe.js');
var addMaskBounds = require('./rendering/mask/utils/addMaskBounds.js');
var addMaskLocalBounds = require('./rendering/mask/utils/addMaskLocalBounds.js');
var autoDetectRenderer = require('./rendering/renderers/autoDetectRenderer.js');
var _const$4 = require('./rendering/renderers/gl/buffer/const.js');
var GlBuffer = require('./rendering/renderers/gl/buffer/GlBuffer.js');
var GlBufferSystem = require('./rendering/renderers/gl/buffer/GlBufferSystem.js');
var _const$5 = require('./rendering/renderers/gl/const.js');
var GlContextSystem = require('./rendering/renderers/gl/context/GlContextSystem.js');
var GlGeometrySystem = require('./rendering/renderers/gl/geometry/GlGeometrySystem.js');
var getGlTypeFromFormat = require('./rendering/renderers/gl/geometry/utils/getGlTypeFromFormat.js');
var GlBackBufferSystem = require('./rendering/renderers/gl/GlBackBufferSystem.js');
var GlColorMaskSystem = require('./rendering/renderers/gl/GlColorMaskSystem.js');
var GlEncoderSystem = require('./rendering/renderers/gl/GlEncoderSystem.js');
var GlRenderTarget = require('./rendering/renderers/gl/GlRenderTarget.js');
var GlStencilSystem = require('./rendering/renderers/gl/GlStencilSystem.js');
var GlUboSystem = require('./rendering/renderers/gl/GlUboSystem.js');
var GlRenderTargetAdaptor = require('./rendering/renderers/gl/renderTarget/GlRenderTargetAdaptor.js');
var GlRenderTargetSystem = require('./rendering/renderers/gl/renderTarget/GlRenderTargetSystem.js');
var GenerateShaderSyncCode = require('./rendering/renderers/gl/shader/GenerateShaderSyncCode.js');
var getBatchSamplersUniformGroup = require('./rendering/renderers/gl/shader/getBatchSamplersUniformGroup.js');
var GlProgram = require('./rendering/renderers/gl/shader/GlProgram.js');
var GlProgramData = require('./rendering/renderers/gl/shader/GlProgramData.js');
var GlShaderSystem = require('./rendering/renderers/gl/shader/GlShaderSystem.js');
var GlUniformGroupSystem = require('./rendering/renderers/gl/shader/GlUniformGroupSystem.js');
var migrateFragmentFromV7toV8 = require('./rendering/renderers/gl/shader/migrateFragmentFromV7toV8.js');
var compileShader = require('./rendering/renderers/gl/shader/program/compileShader.js');
var defaultValue = require('./rendering/renderers/gl/shader/program/defaultValue.js');
var ensureAttributes = require('./rendering/renderers/gl/shader/program/ensureAttributes.js');
var extractAttributesFromGlProgram = require('./rendering/renderers/gl/shader/program/extractAttributesFromGlProgram.js');
var generateProgram = require('./rendering/renderers/gl/shader/program/generateProgram.js');
var getMaxFragmentPrecision = require('./rendering/renderers/gl/shader/program/getMaxFragmentPrecision.js');
var getTestContext = require('./rendering/renderers/gl/shader/program/getTestContext.js');
var getUboData = require('./rendering/renderers/gl/shader/program/getUboData.js');
var getUniformData = require('./rendering/renderers/gl/shader/program/getUniformData.js');
var logProgramError = require('./rendering/renderers/gl/shader/program/logProgramError.js');
var mapSize = require('./rendering/renderers/gl/shader/program/mapSize.js');
var mapType = require('./rendering/renderers/gl/shader/program/mapType.js');
var addProgramDefines = require('./rendering/renderers/gl/shader/program/preprocessors/addProgramDefines.js');
var ensurePrecision = require('./rendering/renderers/gl/shader/program/preprocessors/ensurePrecision.js');
var insertVersion = require('./rendering/renderers/gl/shader/program/preprocessors/insertVersion.js');
var setProgramName = require('./rendering/renderers/gl/shader/program/preprocessors/setProgramName.js');
var stripVersion = require('./rendering/renderers/gl/shader/program/preprocessors/stripVersion.js');
var createUboElementsSTD40 = require('./rendering/renderers/gl/shader/utils/createUboElementsSTD40.js');
var createUboSyncSTD40 = require('./rendering/renderers/gl/shader/utils/createUboSyncSTD40.js');
var generateArraySyncSTD40 = require('./rendering/renderers/gl/shader/utils/generateArraySyncSTD40.js');
var generateUniformsSync = require('./rendering/renderers/gl/shader/utils/generateUniformsSync.js');
var generateUniformsSyncTypes = require('./rendering/renderers/gl/shader/utils/generateUniformsSyncTypes.js');
var GlStateSystem = require('./rendering/renderers/gl/state/GlStateSystem.js');
var mapWebGLBlendModesToPixi = require('./rendering/renderers/gl/state/mapWebGLBlendModesToPixi.js');
var _const$6 = require('./rendering/renderers/gl/texture/const.js');
var GlTexture = require('./rendering/renderers/gl/texture/GlTexture.js');
var GlTextureSystem = require('./rendering/renderers/gl/texture/GlTextureSystem.js');
var glUploadBufferImageResource = require('./rendering/renderers/gl/texture/uploaders/glUploadBufferImageResource.js');
var glUploadCompressedTextureResource = require('./rendering/renderers/gl/texture/uploaders/glUploadCompressedTextureResource.js');
var glUploadImageResource = require('./rendering/renderers/gl/texture/uploaders/glUploadImageResource.js');
var glUploadVideoResource = require('./rendering/renderers/gl/texture/uploaders/glUploadVideoResource.js');
var applyStyleParams = require('./rendering/renderers/gl/texture/utils/applyStyleParams.js');
var getSupportedGlCompressedTextureFormats = require('./rendering/renderers/gl/texture/utils/getSupportedGlCompressedTextureFormats.js');
var mapFormatToGlFormat = require('./rendering/renderers/gl/texture/utils/mapFormatToGlFormat.js');
var mapFormatToGlInternalFormat = require('./rendering/renderers/gl/texture/utils/mapFormatToGlInternalFormat.js');
var mapFormatToGlType = require('./rendering/renderers/gl/texture/utils/mapFormatToGlType.js');
var pixiToGlMaps = require('./rendering/renderers/gl/texture/utils/pixiToGlMaps.js');
var unpremultiplyAlpha = require('./rendering/renderers/gl/texture/utils/unpremultiplyAlpha.js');
var WebGLRenderer = require('./rendering/renderers/gl/WebGLRenderer.js');
var BindGroupSystem = require('./rendering/renderers/gpu/BindGroupSystem.js');
var GpuBufferSystem = require('./rendering/renderers/gpu/buffer/GpuBufferSystem.js');
var GpuReadBuffer = require('./rendering/renderers/gpu/buffer/GpuReadBuffer.js');
var UboBatch = require('./rendering/renderers/gpu/buffer/UboBatch.js');
var GpuColorMaskSystem = require('./rendering/renderers/gpu/GpuColorMaskSystem.js');
var GpuDeviceSystem = require('./rendering/renderers/gpu/GpuDeviceSystem.js');
var GpuEncoderSystem = require('./rendering/renderers/gpu/GpuEncoderSystem.js');
var GpuStencilSystem = require('./rendering/renderers/gpu/GpuStencilSystem.js');
var GpuUboSystem = require('./rendering/renderers/gpu/GpuUboSystem.js');
var GpuUniformBatchPipe = require('./rendering/renderers/gpu/GpuUniformBatchPipe.js');
var PipelineSystem = require('./rendering/renderers/gpu/pipeline/PipelineSystem.js');
var calculateProjection = require('./rendering/renderers/gpu/renderTarget/calculateProjection.js');
var GpuRenderTarget = require('./rendering/renderers/gpu/renderTarget/GpuRenderTarget.js');
var GpuRenderTargetAdaptor = require('./rendering/renderers/gpu/renderTarget/GpuRenderTargetAdaptor.js');
var GpuRenderTargetSystem = require('./rendering/renderers/gpu/renderTarget/GpuRenderTargetSystem.js');
var BindGroup = require('./rendering/renderers/gpu/shader/BindGroup.js');
var GpuProgram = require('./rendering/renderers/gpu/shader/GpuProgram.js');
var GpuShaderSystem = require('./rendering/renderers/gpu/shader/GpuShaderSystem.js');
var createUboElementsWGSL = require('./rendering/renderers/gpu/shader/utils/createUboElementsWGSL.js');
var createUboSyncFunctionWGSL = require('./rendering/renderers/gpu/shader/utils/createUboSyncFunctionWGSL.js');
var extractAttributesFromGpuProgram = require('./rendering/renderers/gpu/shader/utils/extractAttributesFromGpuProgram.js');
var extractStructAndGroups = require('./rendering/renderers/gpu/shader/utils/extractStructAndGroups.js');
var generateArraySyncWGSL = require('./rendering/renderers/gpu/shader/utils/generateArraySyncWGSL.js');
var generateGpuLayoutGroups = require('./rendering/renderers/gpu/shader/utils/generateGpuLayoutGroups.js');
var generateLayoutHash = require('./rendering/renderers/gpu/shader/utils/generateLayoutHash.js');
var removeStructAndGroupDuplicates = require('./rendering/renderers/gpu/shader/utils/removeStructAndGroupDuplicates.js');
var GpuBlendModesToPixi = require('./rendering/renderers/gpu/state/GpuBlendModesToPixi.js');
var GpuStateSystem = require('./rendering/renderers/gpu/state/GpuStateSystem.js');
var GpuStencilModesToPixi = require('./rendering/renderers/gpu/state/GpuStencilModesToPixi.js');
var GpuTextureSystem = require('./rendering/renderers/gpu/texture/GpuTextureSystem.js');
var gpuUploadBufferImageResource = require('./rendering/renderers/gpu/texture/uploaders/gpuUploadBufferImageResource.js');
var gpuUploadCompressedTextureResource = require('./rendering/renderers/gpu/texture/uploaders/gpuUploadCompressedTextureResource.js');
var gpuUploadImageSource = require('./rendering/renderers/gpu/texture/uploaders/gpuUploadImageSource.js');
var gpuUploadVideoSource = require('./rendering/renderers/gpu/texture/uploaders/gpuUploadVideoSource.js');
var getSupportedGPUCompressedTextureFormats = require('./rendering/renderers/gpu/texture/utils/getSupportedGPUCompressedTextureFormats.js');
var GpuMipmapGenerator = require('./rendering/renderers/gpu/texture/utils/GpuMipmapGenerator.js');
var WebGPURenderer = require('./rendering/renderers/gpu/WebGPURenderer.js');
var BackgroundSystem = require('./rendering/renderers/shared/background/BackgroundSystem.js');
var BlendModePipe = require('./rendering/renderers/shared/blendModes/BlendModePipe.js');
var Buffer = require('./rendering/renderers/shared/buffer/Buffer.js');
var BufferResource = require('./rendering/renderers/shared/buffer/BufferResource.js');
var _const$7 = require('./rendering/renderers/shared/buffer/const.js');
var fastCopy = require('./rendering/renderers/shared/buffer/utils/fastCopy.js');
var ExtractSystem = require('./rendering/renderers/shared/extract/ExtractSystem.js');
var GenerateTextureSystem = require('./rendering/renderers/shared/extract/GenerateTextureSystem.js');
var _const$8 = require('./rendering/renderers/shared/geometry/const.js');
var Geometry = require('./rendering/renderers/shared/geometry/Geometry.js');
var buildUvs = require('./rendering/renderers/shared/geometry/utils/buildUvs.js');
var ensureIsBuffer = require('./rendering/renderers/shared/geometry/utils/ensureIsBuffer.js');
var getAttributeInfoFromFormat = require('./rendering/renderers/shared/geometry/utils/getAttributeInfoFromFormat.js');
var getGeometryBounds = require('./rendering/renderers/shared/geometry/utils/getGeometryBounds.js');
var transformVertices = require('./rendering/renderers/shared/geometry/utils/transformVertices.js');
var InstructionSet = require('./rendering/renderers/shared/instructions/InstructionSet.js');
var GlobalUniformSystem = require('./rendering/renderers/shared/renderTarget/GlobalUniformSystem.js');
var isRenderingToScreen = require('./rendering/renderers/shared/renderTarget/isRenderingToScreen.js');
var RenderTarget = require('./rendering/renderers/shared/renderTarget/RenderTarget.js');
var RenderTargetSystem = require('./rendering/renderers/shared/renderTarget/RenderTargetSystem.js');
var viewportFromFrame = require('./rendering/renderers/shared/renderTarget/viewportFromFrame.js');
var SchedulerSystem = require('./rendering/renderers/shared/SchedulerSystem.js');
var _const$9 = require('./rendering/renderers/shared/shader/const.js');
var Shader = require('./rendering/renderers/shared/shader/Shader.js');
var types = require('./rendering/renderers/shared/shader/types.js');
var UboSystem = require('./rendering/renderers/shared/shader/UboSystem.js');
var UniformGroup = require('./rendering/renderers/shared/shader/UniformGroup.js');
var createUboSyncFunction = require('./rendering/renderers/shared/shader/utils/createUboSyncFunction.js');
var getDefaultUniformValue = require('./rendering/renderers/shared/shader/utils/getDefaultUniformValue.js');
var uboSyncFunctions = require('./rendering/renderers/shared/shader/utils/uboSyncFunctions.js');
var uniformParsers = require('./rendering/renderers/shared/shader/utils/uniformParsers.js');
var HelloSystem = require('./rendering/renderers/shared/startup/HelloSystem.js');
var _const$a = require('./rendering/renderers/shared/state/const.js');
var getAdjustedBlendModeBlend = require('./rendering/renderers/shared/state/getAdjustedBlendModeBlend.js');
var State = require('./rendering/renderers/shared/state/State.js');
var AbstractRenderer = require('./rendering/renderers/shared/system/AbstractRenderer.js');
var SharedSystems = require('./rendering/renderers/shared/system/SharedSystems.js');
var SystemRunner = require('./rendering/renderers/shared/system/SystemRunner.js');
var CanvasPool = require('./rendering/renderers/shared/texture/CanvasPool.js');
var _const$b = require('./rendering/renderers/shared/texture/const.js');
var RenderableGCSystem = require('./rendering/renderers/shared/texture/RenderableGCSystem.js');
var RenderTexture = require('./rendering/renderers/shared/texture/RenderTexture.js');
var BufferImageSource = require('./rendering/renderers/shared/texture/sources/BufferImageSource.js');
var CanvasSource = require('./rendering/renderers/shared/texture/sources/CanvasSource.js');
var CompressedSource = require('./rendering/renderers/shared/texture/sources/CompressedSource.js');
var ImageSource = require('./rendering/renderers/shared/texture/sources/ImageSource.js');
var TextureSource = require('./rendering/renderers/shared/texture/sources/TextureSource.js');
var VideoSource = require('./rendering/renderers/shared/texture/sources/VideoSource.js');
var Texture = require('./rendering/renderers/shared/texture/Texture.js');
var TextureGCSystem = require('./rendering/renderers/shared/texture/TextureGCSystem.js');
var TextureMatrix = require('./rendering/renderers/shared/texture/TextureMatrix.js');
var TexturePool = require('./rendering/renderers/shared/texture/TexturePool.js');
var TextureStyle = require('./rendering/renderers/shared/texture/TextureStyle.js');
var TextureUvs = require('./rendering/renderers/shared/texture/TextureUvs.js');
var generateUID = require('./rendering/renderers/shared/texture/utils/generateUID.js');
var getCanvasTexture = require('./rendering/renderers/shared/texture/utils/getCanvasTexture.js');
var getSupportedCompressedTextureFormats = require('./rendering/renderers/shared/texture/utils/getSupportedCompressedTextureFormats.js');
var getSupportedTextureFormats = require('./rendering/renderers/shared/texture/utils/getSupportedTextureFormats.js');
var textureFrom = require('./rendering/renderers/shared/texture/utils/textureFrom.js');
var createIdFromString = require('./rendering/renderers/shared/utils/createIdFromString.js');
var parseFunctionBody = require('./rendering/renderers/shared/utils/parseFunctionBody.js');
var ViewSystem = require('./rendering/renderers/shared/view/ViewSystem.js');
var types$1 = require('./rendering/renderers/types.js');
var particles = require('./scene/particle-container/shared/shader/particles.frag.js');
var particles$1 = require('./scene/particle-container/shared/shader/particles.vert.js');
var particles$2 = require('./scene/particle-container/shared/shader/particles.wgsl.js');
var Bounds = require('./scene/container/bounds/Bounds.js');
var getFastGlobalBounds = require('./scene/container/bounds/getFastGlobalBounds.js');
var getGlobalBounds = require('./scene/container/bounds/getGlobalBounds.js');
var getLocalBounds = require('./scene/container/bounds/getLocalBounds.js');
var getRenderableBounds = require('./scene/container/bounds/getRenderableBounds.js');
var matrixAndBoundsPool = require('./scene/container/bounds/utils/matrixAndBoundsPool.js');
var cacheAsTextureMixin = require('./scene/container/container-mixins/cacheAsTextureMixin.js');
var childrenHelperMixin = require('./scene/container/container-mixins/childrenHelperMixin.js');
var effectsMixin = require('./scene/container/container-mixins/effectsMixin.js');
var findMixin = require('./scene/container/container-mixins/findMixin.js');
var getGlobalMixin = require('./scene/container/container-mixins/getGlobalMixin.js');
var measureMixin = require('./scene/container/container-mixins/measureMixin.js');
var onRenderMixin = require('./scene/container/container-mixins/onRenderMixin.js');
var sortMixin = require('./scene/container/container-mixins/sortMixin.js');
var toLocalGlobalMixin = require('./scene/container/container-mixins/toLocalGlobalMixin.js');
var Container = require('./scene/container/Container.js');
var CustomRenderPipe = require('./scene/container/CustomRenderPipe.js');
var RenderContainer = require('./scene/container/RenderContainer.js');
var RenderGroup = require('./scene/container/RenderGroup.js');
var RenderGroupPipe = require('./scene/container/RenderGroupPipe.js');
var RenderGroupSystem = require('./scene/container/RenderGroupSystem.js');
var assignWithIgnore = require('./scene/container/utils/assignWithIgnore.js');
var buildInstructions = require('./scene/container/utils/buildInstructions.js');
var checkChildrenDidChange = require('./scene/container/utils/checkChildrenDidChange.js');
var clearList = require('./scene/container/utils/clearList.js');
var definedProps = require('./scene/container/utils/definedProps.js');
var executeInstructions = require('./scene/container/utils/executeInstructions.js');
var mixHexColors = require('./scene/container/utils/mixHexColors.js');
var multiplyColors = require('./scene/container/utils/multiplyColors.js');
var multiplyHexColors = require('./scene/container/utils/multiplyHexColors.js');
var updateLocalTransform = require('./scene/container/utils/updateLocalTransform.js');
var updateRenderGroupTransforms = require('./scene/container/utils/updateRenderGroupTransforms.js');
var updateWorldTransform = require('./scene/container/utils/updateWorldTransform.js');
var validateRenderables = require('./scene/container/utils/validateRenderables.js');
var GlGraphicsAdaptor = require('./scene/graphics/gl/GlGraphicsAdaptor.js');
var colorToUniform = require('./scene/graphics/gpu/colorToUniform.js');
var GpuGraphicsAdaptor = require('./scene/graphics/gpu/GpuGraphicsAdaptor.js');
var BatchableGraphics = require('./scene/graphics/shared/BatchableGraphics.js');
var buildAdaptiveBezier = require('./scene/graphics/shared/buildCommands/buildAdaptiveBezier.js');
var buildAdaptiveQuadratic = require('./scene/graphics/shared/buildCommands/buildAdaptiveQuadratic.js');
var buildArc = require('./scene/graphics/shared/buildCommands/buildArc.js');
var buildArcTo = require('./scene/graphics/shared/buildCommands/buildArcTo.js');
var buildArcToSvg = require('./scene/graphics/shared/buildCommands/buildArcToSvg.js');
var buildCircle = require('./scene/graphics/shared/buildCommands/buildCircle.js');
var buildLine = require('./scene/graphics/shared/buildCommands/buildLine.js');
var buildPixelLine = require('./scene/graphics/shared/buildCommands/buildPixelLine.js');
var buildPolygon = require('./scene/graphics/shared/buildCommands/buildPolygon.js');
var buildRectangle = require('./scene/graphics/shared/buildCommands/buildRectangle.js');
var buildTriangle = require('./scene/graphics/shared/buildCommands/buildTriangle.js');
var _const$c = require('./scene/graphics/shared/const.js');
var FillGradient = require('./scene/graphics/shared/fill/FillGradient.js');
var FillPattern = require('./scene/graphics/shared/fill/FillPattern.js');
var Graphics = require('./scene/graphics/shared/Graphics.js');
var GraphicsContext = require('./scene/graphics/shared/GraphicsContext.js');
var GraphicsContextSystem = require('./scene/graphics/shared/GraphicsContextSystem.js');
var GraphicsPipe = require('./scene/graphics/shared/GraphicsPipe.js');
var GraphicsPath = require('./scene/graphics/shared/path/GraphicsPath.js');
var roundShape = require('./scene/graphics/shared/path/roundShape.js');
var ShapePath = require('./scene/graphics/shared/path/ShapePath.js');
var SVGParser = require('./scene/graphics/shared/svg/SVGParser.js');
var SVGToGraphicsPath = require('./scene/graphics/shared/svg/SVGToGraphicsPath.js');
var buildContextBatches = require('./scene/graphics/shared/utils/buildContextBatches.js');
var buildGeometryFromPath = require('./scene/graphics/shared/utils/buildGeometryFromPath.js');
var convertFillInputToFillStyle = require('./scene/graphics/shared/utils/convertFillInputToFillStyle.js');
var getOrientationOfPoints = require('./scene/graphics/shared/utils/getOrientationOfPoints.js');
var triangulateWithHoles = require('./scene/graphics/shared/utils/triangulateWithHoles.js');
var PerspectiveMesh = require('./scene/mesh-perspective/PerspectiveMesh.js');
var PerspectivePlaneGeometry = require('./scene/mesh-perspective/PerspectivePlaneGeometry.js');
var applyProjectiveTransformationToPlane = require('./scene/mesh-perspective/utils/applyProjectiveTransformationToPlane.js');
var compute2DProjections = require('./scene/mesh-perspective/utils/compute2DProjections.js');
var MeshPlane = require('./scene/mesh-plane/MeshPlane.js');
var PlaneGeometry = require('./scene/mesh-plane/PlaneGeometry.js');
var MeshRope = require('./scene/mesh-simple/MeshRope.js');
var MeshSimple = require('./scene/mesh-simple/MeshSimple.js');
var RopeGeometry = require('./scene/mesh-simple/RopeGeometry.js');
var GlMeshAdaptor = require('./scene/mesh/gl/GlMeshAdaptor.js');
var GpuMeshAdapter = require('./scene/mesh/gpu/GpuMeshAdapter.js');
var BatchableMesh = require('./scene/mesh/shared/BatchableMesh.js');
var getTextureDefaultMatrix = require('./scene/mesh/shared/getTextureDefaultMatrix.js');
var Mesh = require('./scene/mesh/shared/Mesh.js');
var MeshGeometry = require('./scene/mesh/shared/MeshGeometry.js');
var MeshPipe = require('./scene/mesh/shared/MeshPipe.js');
var GlParticleContainerAdaptor = require('./scene/particle-container/gl/GlParticleContainerAdaptor.js');
var GpuParticleContainerAdaptor = require('./scene/particle-container/gpu/GpuParticleContainerAdaptor.js');
var GlParticleContainerPipe = require('./scene/particle-container/shared/GlParticleContainerPipe.js');
var GpuParticleContainerPipe = require('./scene/particle-container/shared/GpuParticleContainerPipe.js');
var Particle = require('./scene/particle-container/shared/Particle.js');
var ParticleBuffer = require('./scene/particle-container/shared/ParticleBuffer.js');
var ParticleContainer = require('./scene/particle-container/shared/ParticleContainer.js');
var ParticleContainerPipe = require('./scene/particle-container/shared/ParticleContainerPipe.js');
var particleData = require('./scene/particle-container/shared/particleData.js');
var ParticleShader = require('./scene/particle-container/shared/shader/ParticleShader.js');
var createIndicesForQuads = require('./scene/particle-container/shared/utils/createIndicesForQuads.js');
var generateParticleUpdateFunction = require('./scene/particle-container/shared/utils/generateParticleUpdateFunction.js');
var AnimatedSprite = require('./scene/sprite-animated/AnimatedSprite.js');
var NineSliceGeometry = require('./scene/sprite-nine-slice/NineSliceGeometry.js');
var NineSliceSprite = require('./scene/sprite-nine-slice/NineSliceSprite.js');
var NineSliceSpritePipe = require('./scene/sprite-nine-slice/NineSliceSpritePipe.js');
var tilingBit = require('./scene/sprite-tiling/shader/tilingBit.js');
var TilingSpriteShader = require('./scene/sprite-tiling/shader/TilingSpriteShader.js');
var TilingSprite = require('./scene/sprite-tiling/TilingSprite.js');
var TilingSpritePipe = require('./scene/sprite-tiling/TilingSpritePipe.js');
var applyMatrix = require('./scene/sprite-tiling/utils/applyMatrix.js');
var QuadGeometry = require('./scene/sprite-tiling/utils/QuadGeometry.js');
var setPositions = require('./scene/sprite-tiling/utils/setPositions.js');
var setUvs = require('./scene/sprite-tiling/utils/setUvs.js');
var BatchableSprite = require('./scene/sprite/BatchableSprite.js');
var Sprite = require('./scene/sprite/Sprite.js');
var SpritePipe = require('./scene/sprite/SpritePipe.js');
var AbstractBitmapFont = require('./scene/text-bitmap/AbstractBitmapFont.js');
var bitmapFontTextParser = require('./scene/text-bitmap/asset/bitmapFontTextParser.js');
var bitmapFontXMLParser = require('./scene/text-bitmap/asset/bitmapFontXMLParser.js');
var bitmapFontXMLStringParser = require('./scene/text-bitmap/asset/bitmapFontXMLStringParser.js');
var loadBitmapFont = require('./scene/text-bitmap/asset/loadBitmapFont.js');
var BitmapFont = require('./scene/text-bitmap/BitmapFont.js');
var BitmapFontManager = require('./scene/text-bitmap/BitmapFontManager.js');
var BitmapText = require('./scene/text-bitmap/BitmapText.js');
var BitmapTextPipe = require('./scene/text-bitmap/BitmapTextPipe.js');
var DynamicBitmapFont = require('./scene/text-bitmap/DynamicBitmapFont.js');
var getBitmapTextLayout = require('./scene/text-bitmap/utils/getBitmapTextLayout.js');
var resolveCharacters = require('./scene/text-bitmap/utils/resolveCharacters.js');
var HTMLText = require('./scene/text-html/HTMLText.js');
var HTMLTextPipe = require('./scene/text-html/HTMLTextPipe.js');
var HTMLTextRenderData = require('./scene/text-html/HTMLTextRenderData.js');
var HtmlTextStyle = require('./scene/text-html/HtmlTextStyle.js');
var HTMLTextSystem = require('./scene/text-html/HTMLTextSystem.js');
var extractFontFamilies = require('./scene/text-html/utils/extractFontFamilies.js');
var getFontCss = require('./scene/text-html/utils/getFontCss.js');
var getSVGUrl = require('./scene/text-html/utils/getSVGUrl.js');
var getTemporaryCanvasFromImage = require('./scene/text-html/utils/getTemporaryCanvasFromImage.js');
var loadFontAsBase64 = require('./scene/text-html/utils/loadFontAsBase64.js');
var loadFontCSS = require('./scene/text-html/utils/loadFontCSS.js');
var loadSVGImage = require('./scene/text-html/utils/loadSVGImage.js');
var measureHtmlText = require('./scene/text-html/utils/measureHtmlText.js');
var textStyleToCSS = require('./scene/text-html/utils/textStyleToCSS.js');
var AbstractText = require('./scene/text/AbstractText.js');
var CanvasTextMetrics = require('./scene/text/canvas/CanvasTextMetrics.js');
var CanvasTextPipe = require('./scene/text/canvas/CanvasTextPipe.js');
var CanvasTextSystem = require('./scene/text/canvas/CanvasTextSystem.js');
var fontStringFromTextStyle = require('./scene/text/canvas/utils/fontStringFromTextStyle.js');
var getCanvasFillStyle = require('./scene/text/canvas/utils/getCanvasFillStyle.js');
var SdfShader = require('./scene/text/sdfShader/SdfShader.js');
var localUniformMSDFBit = require('./scene/text/sdfShader/shader-bits/localUniformMSDFBit.js');
var mSDFBit = require('./scene/text/sdfShader/shader-bits/mSDFBit.js');
var Text = require('./scene/text/Text.js');
var TextStyle = require('./scene/text/TextStyle.js');
var ensureTextStyle = require('./scene/text/utils/ensureTextStyle.js');
var generateTextStyleKey = require('./scene/text/utils/generateTextStyleKey.js');
var getPo2TextureFromSource = require('./scene/text/utils/getPo2TextureFromSource.js');
var ViewContainer = require('./scene/view/ViewContainer.js');
var Spritesheet = require('./spritesheet/Spritesheet.js');
var spritesheetAsset = require('./spritesheet/spritesheetAsset.js');
var _const$d = require('./ticker/const.js');
var Ticker = require('./ticker/Ticker.js');
var TickerListener = require('./ticker/TickerListener.js');
var detectVideoAlphaMode = require('./utils/browser/detectVideoAlphaMode.js');
var isMobile = require('./utils/browser/isMobile.js');
var isSafari = require('./utils/browser/isSafari.js');
var isWebGLSupported = require('./utils/browser/isWebGLSupported.js');
var isWebGPUSupported = require('./utils/browser/isWebGPUSupported.js');
var unsafeEvalSupported = require('./utils/browser/unsafeEvalSupported.js');
var getCanvasBoundingBox = require('./utils/canvas/getCanvasBoundingBox.js');
var _const$e = require('./utils/const.js');
var EventEmitter = require('eventemitter3');
var clean = require('./utils/data/clean.js');
var removeItems = require('./utils/data/removeItems.js');
var uid = require('./utils/data/uid.js');
var updateQuadBounds = require('./utils/data/updateQuadBounds.js');
var ViewableBuffer = require('./utils/data/ViewableBuffer.js');
var globalHooks = require('./utils/global/globalHooks.js');
var deprecation = require('./utils/logging/deprecation.js');
var logDebugTexture = require('./utils/logging/logDebugTexture.js');
var logScene = require('./utils/logging/logScene.js');
var warn = require('./utils/logging/warn.js');
var NOOP = require('./utils/misc/NOOP.js');
var Transform = require('./utils/misc/Transform.js');
var getResolutionOfUrl = require('./utils/network/getResolutionOfUrl.js');
var path = require('./utils/path.js');
var Pool = require('./utils/pool/Pool.js');
var PoolGroup = require('./utils/pool/PoolGroup.js');
var sayHello = require('./utils/sayHello.js');
var earcut = require('earcut');

"use strict";
Extensions.extensions.add(browserExt.browserExt, webworkerExt.webworkerExt);

exports.browserExt = browserExt.browserExt;
exports.webworkerExt = webworkerExt.webworkerExt;
exports.ExtensionType = Extensions.ExtensionType;
exports.extensions = Extensions.extensions;
exports.normalizeExtensionPriority = Extensions.normalizeExtensionPriority;
exports.AccessibilitySystem = AccessibilitySystem.AccessibilitySystem;
exports.accessibilityTarget = accessibilityTarget.accessibilityTarget;
exports.ColorBlend = ColorBlend.ColorBlend;
exports.ColorBurnBlend = ColorBurnBlend.ColorBurnBlend;
exports.ColorDodgeBlend = ColorDodgeBlend.ColorDodgeBlend;
exports.DarkenBlend = DarkenBlend.DarkenBlend;
exports.DifferenceBlend = DifferenceBlend.DifferenceBlend;
exports.DivideBlend = DivideBlend.DivideBlend;
exports.ExclusionBlend = ExclusionBlend.ExclusionBlend;
exports.HardLightBlend = HardLightBlend.HardLightBlend;
exports.HardMixBlend = HardMixBlend.HardMixBlend;
exports.LightenBlend = LightenBlend.LightenBlend;
exports.LinearBurnBlend = LinearBurnBlend.LinearBurnBlend;
exports.LinearDodgeBlend = LinearDodgeBlend.LinearDodgeBlend;
exports.LinearLightBlend = LinearLightBlend.LinearLightBlend;
exports.LuminosityBlend = LuminosityBlend.LuminosityBlend;
exports.NegationBlend = NegationBlend.NegationBlend;
exports.OverlayBlend = OverlayBlend.OverlayBlend;
exports.PinLightBlend = PinLightBlend.PinLightBlend;
exports.SaturationBlend = SaturationBlend.SaturationBlend;
exports.SoftLightBlend = SoftLightBlend.SoftLightBlend;
exports.SubtractBlend = SubtractBlend.SubtractBlend;
exports.VividLightBlend = VividLightBlend.VividLightBlend;
exports.Application = Application.Application;
exports.ResizePlugin = ResizePlugin.ResizePlugin;
exports.TickerPlugin = TickerPlugin.TickerPlugin;
exports.Assets = Assets.Assets;
exports.AssetsClass = Assets.AssetsClass;
exports.BackgroundLoader = BackgroundLoader.BackgroundLoader;
exports.Cache = Cache.Cache;
exports.cacheTextureArray = cacheTextureArray.cacheTextureArray;
exports.detectAvif = detectAvif.detectAvif;
exports.detectDefaults = detectDefaults.detectDefaults;
exports.detectMp4 = detectMp4.detectMp4;
exports.detectOgv = detectOgv.detectOgv;
exports.detectWebm = detectWebm.detectWebm;
exports.detectWebp = detectWebp.detectWebp;
exports.testImageFormat = testImageFormat.testImageFormat;
exports.testVideoFormat = testVideoFormat.testVideoFormat;
exports.Loader = Loader.Loader;
exports.LoaderParserPriority = LoaderParser.LoaderParserPriority;
exports.loadJson = loadJson.loadJson;
exports.loadTxt = loadTxt.loadTxt;
exports.getFontFamilyName = loadWebFont.getFontFamilyName;
exports.loadWebFont = loadWebFont.loadWebFont;
exports.loadSvg = loadSVG.loadSvg;
exports.loadImageBitmap = loadTextures.loadImageBitmap;
exports.loadTextures = loadTextures.loadTextures;
exports.crossOrigin = loadVideoTextures.crossOrigin;
exports.determineCrossOrigin = loadVideoTextures.determineCrossOrigin;
exports.loadVideoTextures = loadVideoTextures.loadVideoTextures;
exports.preloadVideo = loadVideoTextures.preloadVideo;
exports.createTexture = createTexture.createTexture;
exports.WorkerManager = WorkerManager.WorkerManager;
exports.resolveJsonUrl = resolveJsonUrl.resolveJsonUrl;
exports.resolveTextureUrl = resolveTextureUrl.resolveTextureUrl;
exports.Resolver = Resolver.Resolver;
exports.getUrlExtension = Resolver.getUrlExtension;
exports.checkDataUrl = checkDataUrl.checkDataUrl;
exports.checkExtension = checkExtension.checkExtension;
exports.convertToList = convertToList.convertToList;
exports.copySearchParams = copySearchParams.copySearchParams;
exports.createStringVariations = createStringVariations.createStringVariations;
exports.isSingleItem = isSingleItem.isSingleItem;
exports.Color = Color.Color;
exports.detectBasis = detectBasis.detectBasis;
exports.loadBasis = loadBasis.loadBasis;
exports.createLevelBuffers = createLevelBuffers.createLevelBuffers;
exports.gpuFormatToBasisTranscoderFormat = gpuFormatToBasisTranscoderFormat.gpuFormatToBasisTranscoderFormat;
exports.basisTranscoderUrls = setBasisTranscoderPath.basisTranscoderUrls;
exports.setBasisTranscoderPath = setBasisTranscoderPath.setBasisTranscoderPath;
exports.loadBasisOnWorker = loadBasisOnWorker.loadBasisOnWorker;
exports.D3D10_RESOURCE_DIMENSION = _const.D3D10_RESOURCE_DIMENSION;
exports.D3DFMT = _const.D3DFMT;
exports.DDS = _const.DDS;
exports.DXGI_FORMAT = _const.DXGI_FORMAT;
exports.DXGI_TO_TEXTURE_FORMAT = _const.DXGI_TO_TEXTURE_FORMAT;
exports.FOURCC_TO_TEXTURE_FORMAT = _const.FOURCC_TO_TEXTURE_FORMAT;
exports.TEXTURE_FORMAT_BLOCK_SIZE = _const.TEXTURE_FORMAT_BLOCK_SIZE;
exports.loadDDS = loadDDS.loadDDS;
exports.parseDDS = parseDDS.parseDDS;
exports.loadKTX = loadKTX.loadKTX;
exports.parseKTX = parseKTX.parseKTX;
exports.GL_INTERNAL_FORMAT = _const$1.GL_INTERNAL_FORMAT;
exports.KTX = _const$1.KTX;
exports.loadKTX2 = loadKTX2.loadKTX2;
exports.convertFormatIfRequired = convertFormatIfRequired.convertFormatIfRequired;
exports.createLevelBuffersFromKTX = createLevelBuffersFromKTX.createLevelBuffersFromKTX;
exports.getTextureFormatFromKTXTexture = getTextureFormatFromKTXTexture.getTextureFormatFromKTXTexture;
exports.glFormatToGPUFormat = glFormatToGPUFormat.glFormatToGPUFormat;
exports.gpuFormatToKTXBasisTranscoderFormat = gpuFormatToKTXBasisTranscoderFormat.gpuFormatToKTXBasisTranscoderFormat;
exports.ktxTranscoderUrls = setKTXTranscoderPath.ktxTranscoderUrls;
exports.setKTXTranscoderPath = setKTXTranscoderPath.setKTXTranscoderPath;
exports.vkFormatToGPUFormat = vkFormatToGPUFormat.vkFormatToGPUFormat;
exports.loadKTX2onWorker = loadKTX2onWorker.loadKTX2onWorker;
exports.detectCompressed = detectCompressed.detectCompressed;
exports.resolveCompressedTextureUrl = resolveCompressedTextureUrl.resolveCompressedTextureUrl;
exports.validFormats = resolveCompressedTextureUrl.validFormats;
exports.Culler = Culler.Culler;
exports.CullerPlugin = CullerPlugin.CullerPlugin;
exports.cullingMixin = cullingMixin.cullingMixin;
exports.DOMAdapter = adapter.DOMAdapter;
exports.autoDetectEnvironment = autoDetectEnvironment.autoDetectEnvironment;
exports.loadEnvironmentExtensions = autoDetectEnvironment.loadEnvironmentExtensions;
exports.BrowserAdapter = BrowserAdapter.BrowserAdapter;
exports.WebWorkerAdapter = WebWorkerAdapter.WebWorkerAdapter;
exports.EventBoundary = EventBoundary.EventBoundary;
exports.EventSystem = EventSystem.EventSystem;
exports.EventsTicker = EventTicker.EventsTicker;
exports.FederatedEvent = FederatedEvent.FederatedEvent;
exports.FederatedContainer = FederatedEventTarget.FederatedContainer;
exports.FederatedMouseEvent = FederatedMouseEvent.FederatedMouseEvent;
exports.FederatedPointerEvent = FederatedPointerEvent.FederatedPointerEvent;
exports.FederatedWheelEvent = FederatedWheelEvent.FederatedWheelEvent;
exports.blendTemplateFrag = blendTemplate.default;
exports.blendTemplateVert = blendTemplate$1.default;
exports.blendTemplateWgsl = blendTemplate$2.default;
exports.hslWgsl = hsl.default;
exports.alphaFrag = alpha.default;
exports.alphaWgsl = alpha$1.default;
exports.blurTemplateWgsl = blurTemplate.default;
exports.colorMatrixFilterFrag = colorMatrixFilter.default;
exports.colorMatrixFilterWgsl = colorMatrixFilter$1.default;
exports.defaultFilterVert = defaultFilter.default;
exports.displacementFrag = displacement.default;
exports.displacementVert = displacement$1.default;
exports.displacementWgsl = displacement$2.default;
exports.noiseFrag = noise.default;
exports.noiseWgsl = noise$1.default;
exports.maskFrag = mask.default;
exports.maskVert = mask$1.default;
exports.maskWgsl = mask$2.default;
exports.BlendModeFilter = BlendModeFilter.BlendModeFilter;
exports.hslgl = GLhls.hslgl;
exports.hslgpu = GPUhls.hslgpu;
exports.AlphaFilter = AlphaFilter.AlphaFilter;
exports.BlurFilter = BlurFilter.BlurFilter;
exports.BlurFilterPass = BlurFilterPass.BlurFilterPass;
exports.GAUSSIAN_VALUES = _const$2.GAUSSIAN_VALUES;
exports.generateBlurFragSource = generateBlurFragSource.generateBlurFragSource;
exports.generateBlurGlProgram = generateBlurGlProgram.generateBlurGlProgram;
exports.generateBlurVertSource = generateBlurVertSource.generateBlurVertSource;
exports.generateBlurProgram = generateBlurProgram.generateBlurProgram;
exports.ColorMatrixFilter = ColorMatrixFilter.ColorMatrixFilter;
exports.DisplacementFilter = DisplacementFilter.DisplacementFilter;
exports.NoiseFilter = NoiseFilter.NoiseFilter;
exports.Filter = Filter.Filter;
exports.FilterEffect = FilterEffect.FilterEffect;
exports.FilterPipe = FilterPipe.FilterPipe;
exports.FilterSystem = FilterSystem.FilterSystem;
exports.MaskFilter = MaskFilter.MaskFilter;
exports.groupD8 = groupD8.groupD8;
exports.Matrix = Matrix.Matrix;
exports.DEG_TO_RAD = _const$3.DEG_TO_RAD;
exports.PI_2 = _const$3.PI_2;
exports.RAD_TO_DEG = _const$3.RAD_TO_DEG;
exports.isPow2 = pow2.isPow2;
exports.log2 = pow2.log2;
exports.nextPow2 = pow2.nextPow2;
exports.squaredDistanceToLineSegment = squaredDistanceToLineSegment.squaredDistanceToLineSegment;
exports.ObservablePoint = ObservablePoint.ObservablePoint;
exports.Point = Point.Point;
exports.pointInTriangle = pointInTriangle.pointInTriangle;
exports.Circle = Circle.Circle;
exports.Ellipse = Ellipse.Ellipse;
exports.Polygon = Polygon.Polygon;
exports.Rectangle = Rectangle.Rectangle;
exports.RoundedRectangle = RoundedRectangle.RoundedRectangle;
exports.Triangle = Triangle.Triangle;
exports.PrepareBase = PrepareBase.PrepareBase;
exports.PrepareQueue = PrepareQueue.PrepareQueue;
exports.PrepareSystem = PrepareSystem.PrepareSystem;
exports.PrepareUpload = PrepareUpload.PrepareUpload;
exports.GlBatchAdaptor = GlBatchAdaptor.GlBatchAdaptor;
exports.checkMaxIfStatementsInShader = checkMaxIfStatementsInShader.checkMaxIfStatementsInShader;
exports.getMaxTexturesPerBatch = maxRecommendedTextures.getMaxTexturesPerBatch;
exports.generateGPULayout = generateGPULayout.generateGPULayout;
exports.generateLayout = generateLayout.generateLayout;
exports.getTextureBatchBindGroup = getTextureBatchBindGroup.getTextureBatchBindGroup;
exports.GpuBatchAdaptor = GpuBatchAdaptor.GpuBatchAdaptor;
exports.Batch = Batcher.Batch;
exports.Batcher = Batcher.Batcher;
exports.BatcherPipe = BatcherPipe.BatcherPipe;
exports.BatchGeometry = BatchGeometry.BatchGeometry;
exports.BatchTextureArray = BatchTextureArray.BatchTextureArray;
exports.DefaultBatcher = DefaultBatcher.DefaultBatcher;
exports.DefaultShader = DefaultShader.DefaultShader;
exports.compileHighShaderGlProgram = compileHighShaderToProgram.compileHighShaderGlProgram;
exports.compileHighShaderGpuProgram = compileHighShaderToProgram.compileHighShaderGpuProgram;
exports.compileHighShader = compileHighShader.compileHighShader;
exports.compileHighShaderGl = compileHighShader.compileHighShaderGl;
exports.addBits = addBits.addBits;
exports.compileHooks = compileHooks.compileHooks;
exports.findHooksRx = compileHooks.findHooksRx;
exports.compileInputs = compileInputs.compileInputs;
exports.compileOutputs = compileOutputs.compileOutputs;
exports.formatShader = formatShader.formatShader;
exports.injectBits = injectBits.injectBits;
exports.fragmentGPUTemplate = defaultProgramTemplate.fragmentGPUTemplate;
exports.fragmentGlTemplate = defaultProgramTemplate.fragmentGlTemplate;
exports.vertexGPUTemplate = defaultProgramTemplate.vertexGPUTemplate;
exports.vertexGlTemplate = defaultProgramTemplate.vertexGlTemplate;
exports.colorBit = colorBit.colorBit;
exports.colorBitGl = colorBit.colorBitGl;
exports.generateTextureBatchBit = generateTextureBatchBit.generateTextureBatchBit;
exports.generateTextureBatchBitGl = generateTextureBatchBit.generateTextureBatchBitGl;
exports.globalUniformsBit = globalUniformsBit.globalUniformsBit;
exports.globalUniformsBitGl = globalUniformsBit.globalUniformsBitGl;
exports.globalUniformsUBOBitGl = globalUniformsBit.globalUniformsUBOBitGl;
exports.localUniformBit = localUniformBit.localUniformBit;
exports.localUniformBitGl = localUniformBit.localUniformBitGl;
exports.localUniformBitGroup2 = localUniformBit.localUniformBitGroup2;
exports.roundPixelsBit = roundPixelsBit.roundPixelsBit;
exports.roundPixelsBitGl = roundPixelsBit.roundPixelsBitGl;
exports.textureBit = textureBit.textureBit;
exports.textureBitGl = textureBit.textureBitGl;
exports.AlphaMask = AlphaMask.AlphaMask;
exports.AlphaMaskPipe = AlphaMaskPipe.AlphaMaskPipe;
exports.ColorMask = ColorMask.ColorMask;
exports.ColorMaskPipe = ColorMaskPipe.ColorMaskPipe;
exports.MaskEffectManager = MaskEffectManager.MaskEffectManager;
exports.MaskEffectManagerClass = MaskEffectManager.MaskEffectManagerClass;
exports.ScissorMask = ScissorMask.ScissorMask;
exports.StencilMask = StencilMask.StencilMask;
exports.StencilMaskPipe = StencilMaskPipe.StencilMaskPipe;
exports.addMaskBounds = addMaskBounds.addMaskBounds;
exports.addMaskLocalBounds = addMaskLocalBounds.addMaskLocalBounds;
exports.getMatrixRelativeToParent = addMaskLocalBounds.getMatrixRelativeToParent;
exports.autoDetectRenderer = autoDetectRenderer.autoDetectRenderer;
exports.BUFFER_TYPE = _const$4.BUFFER_TYPE;
exports.GlBuffer = GlBuffer.GlBuffer;
exports.GlBufferSystem = GlBufferSystem.GlBufferSystem;
exports.CLEAR = _const$5.CLEAR;
exports.GlContextSystem = GlContextSystem.GlContextSystem;
exports.GlGeometrySystem = GlGeometrySystem.GlGeometrySystem;
exports.getGlTypeFromFormat = getGlTypeFromFormat.getGlTypeFromFormat;
exports.GlBackBufferSystem = GlBackBufferSystem.GlBackBufferSystem;
exports.GlColorMaskSystem = GlColorMaskSystem.GlColorMaskSystem;
exports.GlEncoderSystem = GlEncoderSystem.GlEncoderSystem;
exports.GlRenderTarget = GlRenderTarget.GlRenderTarget;
exports.GlStencilSystem = GlStencilSystem.GlStencilSystem;
exports.GlUboSystem = GlUboSystem.GlUboSystem;
exports.GlRenderTargetAdaptor = GlRenderTargetAdaptor.GlRenderTargetAdaptor;
exports.GlRenderTargetSystem = GlRenderTargetSystem.GlRenderTargetSystem;
exports.generateShaderSyncCode = GenerateShaderSyncCode.generateShaderSyncCode;
exports.getBatchSamplersUniformGroup = getBatchSamplersUniformGroup.getBatchSamplersUniformGroup;
exports.GlProgram = GlProgram.GlProgram;
exports.GlProgramData = GlProgramData.GlProgramData;
exports.IGLUniformData = GlProgramData.IGLUniformData;
exports.GlShaderSystem = GlShaderSystem.GlShaderSystem;
exports.GlUniformGroupSystem = GlUniformGroupSystem.GlUniformGroupSystem;
exports.migrateFragmentFromV7toV8 = migrateFragmentFromV7toV8.migrateFragmentFromV7toV8;
exports.compileShader = compileShader.compileShader;
exports.defaultValue = defaultValue.defaultValue;
exports.ensureAttributes = ensureAttributes.ensureAttributes;
exports.extractAttributesFromGlProgram = extractAttributesFromGlProgram.extractAttributesFromGlProgram;
exports.generateProgram = generateProgram.generateProgram;
exports.getMaxFragmentPrecision = getMaxFragmentPrecision.getMaxFragmentPrecision;
exports.getTestContext = getTestContext.getTestContext;
exports.getUboData = getUboData.getUboData;
exports.getUniformData = getUniformData.getUniformData;
exports.logProgramError = logProgramError.logProgramError;
exports.mapSize = mapSize.mapSize;
exports.mapGlToVertexFormat = mapType.mapGlToVertexFormat;
exports.mapType = mapType.mapType;
exports.addProgramDefines = addProgramDefines.addProgramDefines;
exports.ensurePrecision = ensurePrecision.ensurePrecision;
exports.insertVersion = insertVersion.insertVersion;
exports.setProgramName = setProgramName.setProgramName;
exports.stripVersion = stripVersion.stripVersion;
exports.WGSL_TO_STD40_SIZE = createUboElementsSTD40.WGSL_TO_STD40_SIZE;
exports.createUboElementsSTD40 = createUboElementsSTD40.createUboElementsSTD40;
exports.createUboSyncFunctionSTD40 = createUboSyncSTD40.createUboSyncFunctionSTD40;
exports.generateArraySyncSTD40 = generateArraySyncSTD40.generateArraySyncSTD40;
exports.generateUniformsSync = generateUniformsSync.generateUniformsSync;
exports.UNIFORM_TO_ARRAY_SETTERS = generateUniformsSyncTypes.UNIFORM_TO_ARRAY_SETTERS;
exports.UNIFORM_TO_SINGLE_SETTERS = generateUniformsSyncTypes.UNIFORM_TO_SINGLE_SETTERS;
exports.GlStateSystem = GlStateSystem.GlStateSystem;
exports.mapWebGLBlendModesToPixi = mapWebGLBlendModesToPixi.mapWebGLBlendModesToPixi;
exports.GL_FORMATS = _const$6.GL_FORMATS;
exports.GL_TARGETS = _const$6.GL_TARGETS;
exports.GL_TYPES = _const$6.GL_TYPES;
exports.GL_WRAP_MODES = _const$6.GL_WRAP_MODES;
exports.GlTexture = GlTexture.GlTexture;
exports.GlTextureSystem = GlTextureSystem.GlTextureSystem;
exports.glUploadBufferImageResource = glUploadBufferImageResource.glUploadBufferImageResource;
exports.glUploadCompressedTextureResource = glUploadCompressedTextureResource.glUploadCompressedTextureResource;
exports.glUploadImageResource = glUploadImageResource.glUploadImageResource;
exports.glUploadVideoResource = glUploadVideoResource.glUploadVideoResource;
exports.applyStyleParams = applyStyleParams.applyStyleParams;
exports.getSupportedGlCompressedTextureFormats = getSupportedGlCompressedTextureFormats.getSupportedGlCompressedTextureFormats;
exports.mapFormatToGlFormat = mapFormatToGlFormat.mapFormatToGlFormat;
exports.mapFormatToGlInternalFormat = mapFormatToGlInternalFormat.mapFormatToGlInternalFormat;
exports.mapFormatToGlType = mapFormatToGlType.mapFormatToGlType;
exports.compareModeToGlCompare = pixiToGlMaps.compareModeToGlCompare;
exports.mipmapScaleModeToGlFilter = pixiToGlMaps.mipmapScaleModeToGlFilter;
exports.scaleModeToGlFilter = pixiToGlMaps.scaleModeToGlFilter;
exports.wrapModeToGlAddress = pixiToGlMaps.wrapModeToGlAddress;
exports.unpremultiplyAlpha = unpremultiplyAlpha.unpremultiplyAlpha;
exports.WebGLRenderer = WebGLRenderer.WebGLRenderer;
exports.BindGroupSystem = BindGroupSystem.BindGroupSystem;
exports.GpuBufferSystem = GpuBufferSystem.GpuBufferSystem;
exports.GpuReadBuffer = GpuReadBuffer.GpuReadBuffer;
exports.UboBatch = UboBatch.UboBatch;
exports.GpuColorMaskSystem = GpuColorMaskSystem.GpuColorMaskSystem;
exports.GpuDeviceSystem = GpuDeviceSystem.GpuDeviceSystem;
exports.GpuEncoderSystem = GpuEncoderSystem.GpuEncoderSystem;
exports.GpuStencilSystem = GpuStencilSystem.GpuStencilSystem;
exports.GpuUboSystem = GpuUboSystem.GpuUboSystem;
exports.GpuUniformBatchPipe = GpuUniformBatchPipe.GpuUniformBatchPipe;
exports.PipelineSystem = PipelineSystem.PipelineSystem;
exports.calculateProjection = calculateProjection.calculateProjection;
exports.GpuRenderTarget = GpuRenderTarget.GpuRenderTarget;
exports.GpuRenderTargetAdaptor = GpuRenderTargetAdaptor.GpuRenderTargetAdaptor;
exports.GpuRenderTargetSystem = GpuRenderTargetSystem.GpuRenderTargetSystem;
exports.BindGroup = BindGroup.BindGroup;
exports.GpuProgram = GpuProgram.GpuProgram;
exports.GpuShaderSystem = GpuShaderSystem.GpuShaderSystem;
exports.WGSL_ALIGN_SIZE_DATA = createUboElementsWGSL.WGSL_ALIGN_SIZE_DATA;
exports.createUboElementsWGSL = createUboElementsWGSL.createUboElementsWGSL;
exports.createUboSyncFunctionWGSL = createUboSyncFunctionWGSL.createUboSyncFunctionWGSL;
exports.extractAttributesFromGpuProgram = extractAttributesFromGpuProgram.extractAttributesFromGpuProgram;
exports.extractStructAndGroups = extractStructAndGroups.extractStructAndGroups;
exports.generateArraySyncWGSL = generateArraySyncWGSL.generateArraySyncWGSL;
exports.generateGpuLayoutGroups = generateGpuLayoutGroups.generateGpuLayoutGroups;
exports.generateLayoutHash = generateLayoutHash.generateLayoutHash;
exports.removeStructAndGroupDuplicates = removeStructAndGroupDuplicates.removeStructAndGroupDuplicates;
exports.GpuBlendModesToPixi = GpuBlendModesToPixi.GpuBlendModesToPixi;
exports.GpuStateSystem = GpuStateSystem.GpuStateSystem;
exports.GpuStencilModesToPixi = GpuStencilModesToPixi.GpuStencilModesToPixi;
exports.GpuTextureSystem = GpuTextureSystem.GpuTextureSystem;
exports.gpuUploadBufferImageResource = gpuUploadBufferImageResource.gpuUploadBufferImageResource;
exports.blockDataMap = gpuUploadCompressedTextureResource.blockDataMap;
exports.gpuUploadCompressedTextureResource = gpuUploadCompressedTextureResource.gpuUploadCompressedTextureResource;
exports.gpuUploadImageResource = gpuUploadImageSource.gpuUploadImageResource;
exports.gpuUploadVideoResource = gpuUploadVideoSource.gpuUploadVideoResource;
exports.getSupportedGPUCompressedTextureFormats = getSupportedGPUCompressedTextureFormats.getSupportedGPUCompressedTextureFormats;
exports.GpuMipmapGenerator = GpuMipmapGenerator.GpuMipmapGenerator;
exports.WebGPURenderer = WebGPURenderer.WebGPURenderer;
exports.BackgroundSystem = BackgroundSystem.BackgroundSystem;
exports.BlendModePipe = BlendModePipe.BlendModePipe;
exports.Buffer = Buffer.Buffer;
exports.BufferResource = BufferResource.BufferResource;
exports.BufferUsage = _const$7.BufferUsage;
exports.fastCopy = fastCopy.fastCopy;
exports.ExtractSystem = ExtractSystem.ExtractSystem;
exports.GenerateTextureSystem = GenerateTextureSystem.GenerateTextureSystem;
exports.DRAW_MODES = _const$8.DRAW_MODES;
exports.Geometry = Geometry.Geometry;
exports.buildSimpleUvs = buildUvs.buildSimpleUvs;
exports.buildUvs = buildUvs.buildUvs;
exports.ensureIsBuffer = ensureIsBuffer.ensureIsBuffer;
exports.getAttributeInfoFromFormat = getAttributeInfoFromFormat.getAttributeInfoFromFormat;
exports.getGeometryBounds = getGeometryBounds.getGeometryBounds;
exports.transformVertices = transformVertices.transformVertices;
exports.InstructionSet = InstructionSet.InstructionSet;
exports.GlobalUniformSystem = GlobalUniformSystem.GlobalUniformSystem;
exports.isRenderingToScreen = isRenderingToScreen.isRenderingToScreen;
exports.RenderTarget = RenderTarget.RenderTarget;
exports.RenderTargetSystem = RenderTargetSystem.RenderTargetSystem;
exports.viewportFromFrame = viewportFromFrame.viewportFromFrame;
exports.SchedulerSystem = SchedulerSystem.SchedulerSystem;
exports.ShaderStage = _const$9.ShaderStage;
exports.Shader = Shader.Shader;
exports.UNIFORM_TYPES_MAP = types.UNIFORM_TYPES_MAP;
exports.UNIFORM_TYPES_VALUES = types.UNIFORM_TYPES_VALUES;
exports.UboSystem = UboSystem.UboSystem;
exports.UniformGroup = UniformGroup.UniformGroup;
exports.createUboSyncFunction = createUboSyncFunction.createUboSyncFunction;
exports.getDefaultUniformValue = getDefaultUniformValue.getDefaultUniformValue;
exports.uboSyncFunctionsSTD40 = uboSyncFunctions.uboSyncFunctionsSTD40;
exports.uboSyncFunctionsWGSL = uboSyncFunctions.uboSyncFunctionsWGSL;
exports.uniformParsers = uniformParsers.uniformParsers;
exports.HelloSystem = HelloSystem.HelloSystem;
exports.BLEND_TO_NPM = _const$a.BLEND_TO_NPM;
exports.STENCIL_MODES = _const$a.STENCIL_MODES;
exports.getAdjustedBlendModeBlend = getAdjustedBlendModeBlend.getAdjustedBlendModeBlend;
exports.State = State.State;
exports.AbstractRenderer = AbstractRenderer.AbstractRenderer;
exports.SharedRenderPipes = SharedSystems.SharedRenderPipes;
exports.SharedSystems = SharedSystems.SharedSystems;
exports.SystemRunner = SystemRunner.SystemRunner;
exports.CanvasPool = CanvasPool.CanvasPool;
exports.CanvasPoolClass = CanvasPool.CanvasPoolClass;
exports.DEPRECATED_SCALE_MODES = _const$b.DEPRECATED_SCALE_MODES;
exports.DEPRECATED_WRAP_MODES = _const$b.DEPRECATED_WRAP_MODES;
exports.MSAA_QUALITY = _const$b.MSAA_QUALITY;
exports.SCALE_MODES = _const$b.SCALE_MODES;
exports.WRAP_MODES = _const$b.WRAP_MODES;
exports.RenderableGCSystem = RenderableGCSystem.RenderableGCSystem;
exports.RenderTexture = RenderTexture.RenderTexture;
exports.BufferImageSource = BufferImageSource.BufferImageSource;
exports.CanvasSource = CanvasSource.CanvasSource;
exports.CompressedSource = CompressedSource.CompressedSource;
exports.ImageSource = ImageSource.ImageSource;
exports.TextureSource = TextureSource.TextureSource;
exports.VideoSource = VideoSource.VideoSource;
exports.Texture = Texture.Texture;
exports.TextureGCSystem = TextureGCSystem.TextureGCSystem;
exports.TextureMatrix = TextureMatrix.TextureMatrix;
exports.TexturePool = TexturePool.TexturePool;
exports.TexturePoolClass = TexturePool.TexturePoolClass;
exports.TextureStyle = TextureStyle.TextureStyle;
exports.TextureUvs = TextureUvs.TextureUvs;
exports.generateUID = generateUID.generateUID;
exports.getCanvasTexture = getCanvasTexture.getCanvasTexture;
exports.hasCachedCanvasTexture = getCanvasTexture.hasCachedCanvasTexture;
exports.getSupportedCompressedTextureFormats = getSupportedCompressedTextureFormats.getSupportedCompressedTextureFormats;
exports.getSupportedTextureFormats = getSupportedTextureFormats.getSupportedTextureFormats;
exports.nonCompressedFormats = getSupportedTextureFormats.nonCompressedFormats;
exports.autoDetectSource = textureFrom.autoDetectSource;
exports.resourceToTexture = textureFrom.resourceToTexture;
exports.textureFrom = textureFrom.textureFrom;
exports.createIdFromString = createIdFromString.createIdFromString;
exports.parseFunctionBody = parseFunctionBody.parseFunctionBody;
exports.ViewSystem = ViewSystem.ViewSystem;
exports.RendererType = types$1.RendererType;
exports.particlesFrag = particles.default;
exports.particlesVert = particles$1.default;
exports.particlesWgsl = particles$2.default;
exports.Bounds = Bounds.Bounds;
exports._getGlobalBoundsRecursive = getFastGlobalBounds._getGlobalBoundsRecursive;
exports.getFastGlobalBounds = getFastGlobalBounds.getFastGlobalBounds;
exports._getGlobalBounds = getGlobalBounds._getGlobalBounds;
exports.getGlobalBounds = getGlobalBounds.getGlobalBounds;
exports.updateTransformBackwards = getGlobalBounds.updateTransformBackwards;
exports.getLocalBounds = getLocalBounds.getLocalBounds;
exports.getParent = getLocalBounds.getParent;
exports.getGlobalRenderableBounds = getRenderableBounds.getGlobalRenderableBounds;
exports.boundsPool = matrixAndBoundsPool.boundsPool;
exports.matrixPool = matrixAndBoundsPool.matrixPool;
exports.cacheAsTextureMixin = cacheAsTextureMixin.cacheAsTextureMixin;
exports.childrenHelperMixin = childrenHelperMixin.childrenHelperMixin;
exports.effectsMixin = effectsMixin.effectsMixin;
exports.findMixin = findMixin.findMixin;
exports.bgr2rgb = getGlobalMixin.bgr2rgb;
exports.getGlobalMixin = getGlobalMixin.getGlobalMixin;
exports.measureMixin = measureMixin.measureMixin;
exports.onRenderMixin = onRenderMixin.onRenderMixin;
exports.sortMixin = sortMixin.sortMixin;
exports.toLocalGlobalMixin = toLocalGlobalMixin.toLocalGlobalMixin;
exports.Container = Container.Container;
exports.UPDATE_BLEND = Container.UPDATE_BLEND;
exports.UPDATE_COLOR = Container.UPDATE_COLOR;
exports.UPDATE_TRANSFORM = Container.UPDATE_TRANSFORM;
exports.UPDATE_VISIBLE = Container.UPDATE_VISIBLE;
exports.CustomRenderPipe = CustomRenderPipe.CustomRenderPipe;
exports.RenderContainer = RenderContainer.RenderContainer;
exports.RenderGroup = RenderGroup.RenderGroup;
exports.RenderGroupPipe = RenderGroupPipe.RenderGroupPipe;
exports.RenderGroupSystem = RenderGroupSystem.RenderGroupSystem;
exports.assignWithIgnore = assignWithIgnore.assignWithIgnore;
exports.buildInstructions = buildInstructions.buildInstructions;
exports.collectAllRenderables = buildInstructions.collectAllRenderables;
exports.checkChildrenDidChange = checkChildrenDidChange.checkChildrenDidChange;
exports.clearList = clearList.clearList;
exports.definedProps = definedProps.definedProps;
exports.executeInstructions = executeInstructions.executeInstructions;
exports.mixHexColors = mixHexColors.mixHexColors;
exports.multiplyColors = multiplyColors.multiplyColors;
exports.multiplyHexColors = multiplyHexColors.multiplyHexColors;
exports.updateLocalTransform = updateLocalTransform.updateLocalTransform;
exports.updateRenderGroupTransform = updateRenderGroupTransforms.updateRenderGroupTransform;
exports.updateRenderGroupTransforms = updateRenderGroupTransforms.updateRenderGroupTransforms;
exports.updateTransformAndChildren = updateRenderGroupTransforms.updateTransformAndChildren;
exports.updateWorldTransform = updateWorldTransform.updateWorldTransform;
exports.validateRenderables = validateRenderables.validateRenderables;
exports.GlGraphicsAdaptor = GlGraphicsAdaptor.GlGraphicsAdaptor;
exports.color32BitToUniform = colorToUniform.color32BitToUniform;
exports.colorToUniform = colorToUniform.colorToUniform;
exports.GpuGraphicsAdaptor = GpuGraphicsAdaptor.GpuGraphicsAdaptor;
exports.BatchableGraphics = BatchableGraphics.BatchableGraphics;
exports.buildAdaptiveBezier = buildAdaptiveBezier.buildAdaptiveBezier;
exports.buildAdaptiveQuadratic = buildAdaptiveQuadratic.buildAdaptiveQuadratic;
exports.buildArc = buildArc.buildArc;
exports.buildArcTo = buildArcTo.buildArcTo;
exports.buildArcToSvg = buildArcToSvg.buildArcToSvg;
exports.buildCircle = buildCircle.buildCircle;
exports.buildEllipse = buildCircle.buildEllipse;
exports.buildRoundedRectangle = buildCircle.buildRoundedRectangle;
exports.buildLine = buildLine.buildLine;
exports.buildPixelLine = buildPixelLine.buildPixelLine;
exports.buildPolygon = buildPolygon.buildPolygon;
exports.buildRectangle = buildRectangle.buildRectangle;
exports.buildTriangle = buildTriangle.buildTriangle;
exports.closePointEps = _const$c.closePointEps;
exports.curveEps = _const$c.curveEps;
exports.FillGradient = FillGradient.FillGradient;
exports.FillPattern = FillPattern.FillPattern;
exports.Graphics = Graphics.Graphics;
exports.GraphicsContext = GraphicsContext.GraphicsContext;
exports.GpuGraphicsContext = GraphicsContextSystem.GpuGraphicsContext;
exports.GraphicsContextRenderData = GraphicsContextSystem.GraphicsContextRenderData;
exports.GraphicsContextSystem = GraphicsContextSystem.GraphicsContextSystem;
exports.GraphicsPipe = GraphicsPipe.GraphicsPipe;
exports.GraphicsPath = GraphicsPath.GraphicsPath;
exports.roundedShapeArc = roundShape.roundedShapeArc;
exports.roundedShapeQuadraticCurve = roundShape.roundedShapeQuadraticCurve;
exports.ShapePath = ShapePath.ShapePath;
exports.SVGParser = SVGParser.SVGParser;
exports.SVGToGraphicsPath = SVGToGraphicsPath.SVGToGraphicsPath;
exports.buildContextBatches = buildContextBatches.buildContextBatches;
exports.shapeBuilders = buildContextBatches.shapeBuilders;
exports.buildGeometryFromPath = buildGeometryFromPath.buildGeometryFromPath;
exports.toFillStyle = convertFillInputToFillStyle.toFillStyle;
exports.toStrokeStyle = convertFillInputToFillStyle.toStrokeStyle;
exports.getOrientationOfPoints = getOrientationOfPoints.getOrientationOfPoints;
exports.triangulateWithHoles = triangulateWithHoles.triangulateWithHoles;
exports.PerspectiveMesh = PerspectiveMesh.PerspectiveMesh;
exports.PerspectivePlaneGeometry = PerspectivePlaneGeometry.PerspectivePlaneGeometry;
exports.applyProjectiveTransformationToPlane = applyProjectiveTransformationToPlane.applyProjectiveTransformationToPlane;
exports.compute2DProjection = compute2DProjections.compute2DProjection;
exports.MeshPlane = MeshPlane.MeshPlane;
exports.PlaneGeometry = PlaneGeometry.PlaneGeometry;
exports.MeshRope = MeshRope.MeshRope;
exports.MeshSimple = MeshSimple.MeshSimple;
exports.RopeGeometry = RopeGeometry.RopeGeometry;
exports.GlMeshAdaptor = GlMeshAdaptor.GlMeshAdaptor;
exports.GpuMeshAdapter = GpuMeshAdapter.GpuMeshAdapter;
exports.BatchableMesh = BatchableMesh.BatchableMesh;
exports.getTextureDefaultMatrix = getTextureDefaultMatrix.getTextureDefaultMatrix;
exports.Mesh = Mesh.Mesh;
exports.MeshGeometry = MeshGeometry.MeshGeometry;
exports.MeshPipe = MeshPipe.MeshPipe;
exports.GlParticleContainerAdaptor = GlParticleContainerAdaptor.GlParticleContainerAdaptor;
exports.GpuParticleContainerAdaptor = GpuParticleContainerAdaptor.GpuParticleContainerAdaptor;
exports.GlParticleContainerPipe = GlParticleContainerPipe.GlParticleContainerPipe;
exports.GpuParticleContainerPipe = GpuParticleContainerPipe.GpuParticleContainerPipe;
exports.Particle = Particle.Particle;
exports.ParticleBuffer = ParticleBuffer.ParticleBuffer;
exports.ParticleContainer = ParticleContainer.ParticleContainer;
exports.ParticleContainerPipe = ParticleContainerPipe.ParticleContainerPipe;
exports.particleData = particleData.particleData;
exports.ParticleShader = ParticleShader.ParticleShader;
exports.createIndicesForQuads = createIndicesForQuads.createIndicesForQuads;
exports.generateParticleUpdateFunction = generateParticleUpdateFunction.generateParticleUpdateFunction;
exports.AnimatedSprite = AnimatedSprite.AnimatedSprite;
exports.NineSliceGeometry = NineSliceGeometry.NineSliceGeometry;
exports.NineSlicePlane = NineSliceSprite.NineSlicePlane;
exports.NineSliceSprite = NineSliceSprite.NineSliceSprite;
exports.NineSliceSpritePipe = NineSliceSpritePipe.NineSliceSpritePipe;
exports.tilingBit = tilingBit.tilingBit;
exports.tilingBitGl = tilingBit.tilingBitGl;
exports.TilingSpriteShader = TilingSpriteShader.TilingSpriteShader;
exports.TilingSprite = TilingSprite.TilingSprite;
exports.TilingSpritePipe = TilingSpritePipe.TilingSpritePipe;
exports.applyMatrix = applyMatrix.applyMatrix;
exports.QuadGeometry = QuadGeometry.QuadGeometry;
exports.setPositions = setPositions.setPositions;
exports.setUvs = setUvs.setUvs;
exports.BatchableSprite = BatchableSprite.BatchableSprite;
exports.Sprite = Sprite.Sprite;
exports.SpritePipe = SpritePipe.SpritePipe;
exports.AbstractBitmapFont = AbstractBitmapFont.AbstractBitmapFont;
exports.bitmapFontTextParser = bitmapFontTextParser.bitmapFontTextParser;
exports.bitmapFontXMLParser = bitmapFontXMLParser.bitmapFontXMLParser;
exports.bitmapFontXMLStringParser = bitmapFontXMLStringParser.bitmapFontXMLStringParser;
exports.bitmapFontCachePlugin = loadBitmapFont.bitmapFontCachePlugin;
exports.loadBitmapFont = loadBitmapFont.loadBitmapFont;
exports.BitmapFont = BitmapFont.BitmapFont;
exports.BitmapFontManager = BitmapFontManager.BitmapFontManager;
exports.BitmapText = BitmapText.BitmapText;
exports.BitmapTextPipe = BitmapTextPipe.BitmapTextPipe;
exports.DynamicBitmapFont = DynamicBitmapFont.DynamicBitmapFont;
exports.getBitmapTextLayout = getBitmapTextLayout.getBitmapTextLayout;
exports.resolveCharacters = resolveCharacters.resolveCharacters;
exports.HTMLText = HTMLText.HTMLText;
exports.HTMLTextPipe = HTMLTextPipe.HTMLTextPipe;
exports.HTMLTextRenderData = HTMLTextRenderData.HTMLTextRenderData;
exports.nssvg = HTMLTextRenderData.nssvg;
exports.nsxhtml = HTMLTextRenderData.nsxhtml;
exports.HTMLTextStyle = HtmlTextStyle.HTMLTextStyle;
exports.HTMLTextSystem = HTMLTextSystem.HTMLTextSystem;
exports.extractFontFamilies = extractFontFamilies.extractFontFamilies;
exports.FontStylePromiseCache = getFontCss.FontStylePromiseCache;
exports.getFontCss = getFontCss.getFontCss;
exports.getSVGUrl = getSVGUrl.getSVGUrl;
exports.getTemporaryCanvasFromImage = getTemporaryCanvasFromImage.getTemporaryCanvasFromImage;
exports.loadFontAsBase64 = loadFontAsBase64.loadFontAsBase64;
exports.loadFontCSS = loadFontCSS.loadFontCSS;
exports.loadSVGImage = loadSVGImage.loadSVGImage;
exports.measureHtmlText = measureHtmlText.measureHtmlText;
exports.textStyleToCSS = textStyleToCSS.textStyleToCSS;
exports.AbstractText = AbstractText.AbstractText;
exports.ensureOptions = AbstractText.ensureOptions;
exports.CanvasTextMetrics = CanvasTextMetrics.CanvasTextMetrics;
exports.CanvasTextPipe = CanvasTextPipe.CanvasTextPipe;
exports.CanvasTextSystem = CanvasTextSystem.CanvasTextSystem;
exports.fontStringFromTextStyle = fontStringFromTextStyle.fontStringFromTextStyle;
exports.getCanvasFillStyle = getCanvasFillStyle.getCanvasFillStyle;
exports.SdfShader = SdfShader.SdfShader;
exports.localUniformMSDFBit = localUniformMSDFBit.localUniformMSDFBit;
exports.localUniformMSDFBitGl = localUniformMSDFBit.localUniformMSDFBitGl;
exports.mSDFBit = mSDFBit.mSDFBit;
exports.mSDFBitGl = mSDFBit.mSDFBitGl;
exports.Text = Text.Text;
exports.TextStyle = TextStyle.TextStyle;
exports.ensureTextStyle = ensureTextStyle.ensureTextStyle;
exports.generateTextStyleKey = generateTextStyleKey.generateTextStyleKey;
exports.getPo2TextureFromSource = getPo2TextureFromSource.getPo2TextureFromSource;
exports.ViewContainer = ViewContainer.ViewContainer;
exports.Spritesheet = Spritesheet.Spritesheet;
exports.spritesheetAsset = spritesheetAsset.spritesheetAsset;
exports.UPDATE_PRIORITY = _const$d.UPDATE_PRIORITY;
exports.Ticker = Ticker.Ticker;
exports.TickerListener = TickerListener.TickerListener;
exports.detectVideoAlphaMode = detectVideoAlphaMode.detectVideoAlphaMode;
exports.isMobile = isMobile.isMobile;
exports.isSafari = isSafari.isSafari;
exports.isWebGLSupported = isWebGLSupported.isWebGLSupported;
exports.isWebGPUSupported = isWebGPUSupported.isWebGPUSupported;
exports.unsafeEvalSupported = unsafeEvalSupported.unsafeEvalSupported;
exports.getCanvasBoundingBox = getCanvasBoundingBox.getCanvasBoundingBox;
exports.DATA_URI = _const$e.DATA_URI;
exports.VERSION = _const$e.VERSION;
exports.EventEmitter = EventEmitter;
exports.cleanArray = clean.cleanArray;
exports.cleanHash = clean.cleanHash;
exports.removeItems = removeItems.removeItems;
exports.resetUids = uid.resetUids;
exports.uid = uid.uid;
exports.updateQuadBounds = updateQuadBounds.updateQuadBounds;
exports.ViewableBuffer = ViewableBuffer.ViewableBuffer;
exports.ApplicationInitHook = globalHooks.ApplicationInitHook;
exports.RendererInitHook = globalHooks.RendererInitHook;
exports.deprecation = deprecation.deprecation;
exports.v8_0_0 = deprecation.v8_0_0;
exports.v8_3_4 = deprecation.v8_3_4;
exports.logDebugTexture = logDebugTexture.logDebugTexture;
exports.logRenderGroupScene = logScene.logRenderGroupScene;
exports.logScene = logScene.logScene;
exports.warn = warn.warn;
exports.NOOP = NOOP.NOOP;
exports.Transform = Transform.Transform;
exports.getResolutionOfUrl = getResolutionOfUrl.getResolutionOfUrl;
exports.path = path.path;
exports.Pool = Pool.Pool;
exports.BigPool = PoolGroup.BigPool;
exports.PoolGroupClass = PoolGroup.PoolGroupClass;
exports.sayHello = sayHello.sayHello;
exports.earcut = earcut;
//# sourceMappingURL=index.js.map
