'use strict';

var GlBatchAdaptor = require('./batcher/gl/GlBatchAdaptor.js');
var checkMaxIfStatementsInShader = require('./batcher/gl/utils/checkMaxIfStatementsInShader.js');
var maxRecommendedTextures = require('./batcher/gl/utils/maxRecommendedTextures.js');
var generateGPULayout = require('./batcher/gpu/generateGPULayout.js');
var generateLayout = require('./batcher/gpu/generateLayout.js');
var getTextureBatchBindGroup = require('./batcher/gpu/getTextureBatchBindGroup.js');
var GpuBatchAdaptor = require('./batcher/gpu/GpuBatchAdaptor.js');
var Batcher = require('./batcher/shared/Batcher.js');
var BatcherPipe = require('./batcher/shared/BatcherPipe.js');
var BatchGeometry = require('./batcher/shared/BatchGeometry.js');
var BatchTextureArray = require('./batcher/shared/BatchTextureArray.js');
var DefaultBatcher = require('./batcher/shared/DefaultBatcher.js');
var DefaultShader = require('./batcher/shared/DefaultShader.js');
var compileHighShaderToProgram = require('./high-shader/compileHighShaderToProgram.js');
var compileHighShader = require('./high-shader/compiler/compileHighShader.js');
require('./high-shader/compiler/types.js');
var addBits = require('./high-shader/compiler/utils/addBits.js');
var compileHooks = require('./high-shader/compiler/utils/compileHooks.js');
var compileInputs = require('./high-shader/compiler/utils/compileInputs.js');
var compileOutputs = require('./high-shader/compiler/utils/compileOutputs.js');
var formatShader = require('./high-shader/compiler/utils/formatShader.js');
var injectBits = require('./high-shader/compiler/utils/injectBits.js');
var defaultProgramTemplate = require('./high-shader/defaultProgramTemplate.js');
var colorBit = require('./high-shader/shader-bits/colorBit.js');
var generateTextureBatchBit = require('./high-shader/shader-bits/generateTextureBatchBit.js');
var globalUniformsBit = require('./high-shader/shader-bits/globalUniformsBit.js');
var localUniformBit = require('./high-shader/shader-bits/localUniformBit.js');
var roundPixelsBit = require('./high-shader/shader-bits/roundPixelsBit.js');
var textureBit = require('./high-shader/shader-bits/textureBit.js');
var AlphaMask = require('./mask/alpha/AlphaMask.js');
var AlphaMaskPipe = require('./mask/alpha/AlphaMaskPipe.js');
var ColorMask = require('./mask/color/ColorMask.js');
var ColorMaskPipe = require('./mask/color/ColorMaskPipe.js');
var MaskEffectManager = require('./mask/MaskEffectManager.js');
var ScissorMask = require('./mask/scissor/ScissorMask.js');
var StencilMask = require('./mask/stencil/StencilMask.js');
var StencilMaskPipe = require('./mask/stencil/StencilMaskPipe.js');
var addMaskBounds = require('./mask/utils/addMaskBounds.js');
var addMaskLocalBounds = require('./mask/utils/addMaskLocalBounds.js');
var autoDetectRenderer = require('./renderers/autoDetectRenderer.js');
var _const = require('./renderers/gl/buffer/const.js');
var GlBuffer = require('./renderers/gl/buffer/GlBuffer.js');
var GlBufferSystem = require('./renderers/gl/buffer/GlBufferSystem.js');
var _const$1 = require('./renderers/gl/const.js');
var GlContextSystem = require('./renderers/gl/context/GlContextSystem.js');
require('./renderers/gl/context/GlRenderingContext.js');
require('./renderers/gl/context/WebGLExtensions.js');
var GlGeometrySystem = require('./renderers/gl/geometry/GlGeometrySystem.js');
var getGlTypeFromFormat = require('./renderers/gl/geometry/utils/getGlTypeFromFormat.js');
var GlBackBufferSystem = require('./renderers/gl/GlBackBufferSystem.js');
var GlColorMaskSystem = require('./renderers/gl/GlColorMaskSystem.js');
var GlEncoderSystem = require('./renderers/gl/GlEncoderSystem.js');
var GlRenderTarget = require('./renderers/gl/GlRenderTarget.js');
var GlStencilSystem = require('./renderers/gl/GlStencilSystem.js');
var GlUboSystem = require('./renderers/gl/GlUboSystem.js');
var GlRenderTargetAdaptor = require('./renderers/gl/renderTarget/GlRenderTargetAdaptor.js');
var GlRenderTargetSystem = require('./renderers/gl/renderTarget/GlRenderTargetSystem.js');
require('./renderers/gl/shader/const.js');
var GenerateShaderSyncCode = require('./renderers/gl/shader/GenerateShaderSyncCode.js');
var getBatchSamplersUniformGroup = require('./renderers/gl/shader/getBatchSamplersUniformGroup.js');
var GlProgram = require('./renderers/gl/shader/GlProgram.js');
var GlProgramData = require('./renderers/gl/shader/GlProgramData.js');
var GlShaderSystem = require('./renderers/gl/shader/GlShaderSystem.js');
var GlUniformGroupSystem = require('./renderers/gl/shader/GlUniformGroupSystem.js');
var migrateFragmentFromV7toV8 = require('./renderers/gl/shader/migrateFragmentFromV7toV8.js');
var compileShader = require('./renderers/gl/shader/program/compileShader.js');
var defaultValue = require('./renderers/gl/shader/program/defaultValue.js');
var ensureAttributes = require('./renderers/gl/shader/program/ensureAttributes.js');
var extractAttributesFromGlProgram = require('./renderers/gl/shader/program/extractAttributesFromGlProgram.js');
var generateProgram = require('./renderers/gl/shader/program/generateProgram.js');
var getMaxFragmentPrecision = require('./renderers/gl/shader/program/getMaxFragmentPrecision.js');
var getTestContext = require('./renderers/gl/shader/program/getTestContext.js');
var getUboData = require('./renderers/gl/shader/program/getUboData.js');
var getUniformData = require('./renderers/gl/shader/program/getUniformData.js');
var logProgramError = require('./renderers/gl/shader/program/logProgramError.js');
var mapSize = require('./renderers/gl/shader/program/mapSize.js');
var mapType = require('./renderers/gl/shader/program/mapType.js');
var addProgramDefines = require('./renderers/gl/shader/program/preprocessors/addProgramDefines.js');
var ensurePrecision = require('./renderers/gl/shader/program/preprocessors/ensurePrecision.js');
var insertVersion = require('./renderers/gl/shader/program/preprocessors/insertVersion.js');
var setProgramName = require('./renderers/gl/shader/program/preprocessors/setProgramName.js');
var stripVersion = require('./renderers/gl/shader/program/preprocessors/stripVersion.js');
var createUboElementsSTD40 = require('./renderers/gl/shader/utils/createUboElementsSTD40.js');
var createUboSyncSTD40 = require('./renderers/gl/shader/utils/createUboSyncSTD40.js');
var generateArraySyncSTD40 = require('./renderers/gl/shader/utils/generateArraySyncSTD40.js');
var generateUniformsSync = require('./renderers/gl/shader/utils/generateUniformsSync.js');
var generateUniformsSyncTypes = require('./renderers/gl/shader/utils/generateUniformsSyncTypes.js');
var GlStateSystem = require('./renderers/gl/state/GlStateSystem.js');
var mapWebGLBlendModesToPixi = require('./renderers/gl/state/mapWebGLBlendModesToPixi.js');
var _const$2 = require('./renderers/gl/texture/const.js');
var GlTexture = require('./renderers/gl/texture/GlTexture.js');
var GlTextureSystem = require('./renderers/gl/texture/GlTextureSystem.js');
require('./renderers/gl/texture/uploaders/GLTextureUploader.js');
var glUploadBufferImageResource = require('./renderers/gl/texture/uploaders/glUploadBufferImageResource.js');
var glUploadCompressedTextureResource = require('./renderers/gl/texture/uploaders/glUploadCompressedTextureResource.js');
var glUploadImageResource = require('./renderers/gl/texture/uploaders/glUploadImageResource.js');
var glUploadVideoResource = require('./renderers/gl/texture/uploaders/glUploadVideoResource.js');
var applyStyleParams = require('./renderers/gl/texture/utils/applyStyleParams.js');
var getSupportedGlCompressedTextureFormats = require('./renderers/gl/texture/utils/getSupportedGlCompressedTextureFormats.js');
var mapFormatToGlFormat = require('./renderers/gl/texture/utils/mapFormatToGlFormat.js');
var mapFormatToGlInternalFormat = require('./renderers/gl/texture/utils/mapFormatToGlInternalFormat.js');
var mapFormatToGlType = require('./renderers/gl/texture/utils/mapFormatToGlType.js');
var pixiToGlMaps = require('./renderers/gl/texture/utils/pixiToGlMaps.js');
var unpremultiplyAlpha = require('./renderers/gl/texture/utils/unpremultiplyAlpha.js');
var WebGLRenderer = require('./renderers/gl/WebGLRenderer.js');
var BindGroupSystem = require('./renderers/gpu/BindGroupSystem.js');
var GpuBufferSystem = require('./renderers/gpu/buffer/GpuBufferSystem.js');
var GpuReadBuffer = require('./renderers/gpu/buffer/GpuReadBuffer.js');
var UboBatch = require('./renderers/gpu/buffer/UboBatch.js');
var GpuColorMaskSystem = require('./renderers/gpu/GpuColorMaskSystem.js');
var GpuDeviceSystem = require('./renderers/gpu/GpuDeviceSystem.js');
var GpuEncoderSystem = require('./renderers/gpu/GpuEncoderSystem.js');
var GpuStencilSystem = require('./renderers/gpu/GpuStencilSystem.js');
var GpuUboSystem = require('./renderers/gpu/GpuUboSystem.js');
var GpuUniformBatchPipe = require('./renderers/gpu/GpuUniformBatchPipe.js');
var PipelineSystem = require('./renderers/gpu/pipeline/PipelineSystem.js');
var calculateProjection = require('./renderers/gpu/renderTarget/calculateProjection.js');
var GpuRenderTarget = require('./renderers/gpu/renderTarget/GpuRenderTarget.js');
var GpuRenderTargetAdaptor = require('./renderers/gpu/renderTarget/GpuRenderTargetAdaptor.js');
var GpuRenderTargetSystem = require('./renderers/gpu/renderTarget/GpuRenderTargetSystem.js');
var BindGroup = require('./renderers/gpu/shader/BindGroup.js');
require('./renderers/gpu/shader/BindResource.js');
var GpuProgram = require('./renderers/gpu/shader/GpuProgram.js');
var GpuShaderSystem = require('./renderers/gpu/shader/GpuShaderSystem.js');
var createUboElementsWGSL = require('./renderers/gpu/shader/utils/createUboElementsWGSL.js');
var createUboSyncFunctionWGSL = require('./renderers/gpu/shader/utils/createUboSyncFunctionWGSL.js');
var extractAttributesFromGpuProgram = require('./renderers/gpu/shader/utils/extractAttributesFromGpuProgram.js');
var extractStructAndGroups = require('./renderers/gpu/shader/utils/extractStructAndGroups.js');
var generateArraySyncWGSL = require('./renderers/gpu/shader/utils/generateArraySyncWGSL.js');
var generateGpuLayoutGroups = require('./renderers/gpu/shader/utils/generateGpuLayoutGroups.js');
var generateLayoutHash = require('./renderers/gpu/shader/utils/generateLayoutHash.js');
var removeStructAndGroupDuplicates = require('./renderers/gpu/shader/utils/removeStructAndGroupDuplicates.js');
var GpuBlendModesToPixi = require('./renderers/gpu/state/GpuBlendModesToPixi.js');
var GpuStateSystem = require('./renderers/gpu/state/GpuStateSystem.js');
var GpuStencilModesToPixi = require('./renderers/gpu/state/GpuStencilModesToPixi.js');
var GpuTextureSystem = require('./renderers/gpu/texture/GpuTextureSystem.js');
require('./renderers/gpu/texture/uploaders/GpuTextureUploader.js');
var gpuUploadBufferImageResource = require('./renderers/gpu/texture/uploaders/gpuUploadBufferImageResource.js');
var gpuUploadCompressedTextureResource = require('./renderers/gpu/texture/uploaders/gpuUploadCompressedTextureResource.js');
var gpuUploadImageSource = require('./renderers/gpu/texture/uploaders/gpuUploadImageSource.js');
var gpuUploadVideoSource = require('./renderers/gpu/texture/uploaders/gpuUploadVideoSource.js');
var getSupportedGPUCompressedTextureFormats = require('./renderers/gpu/texture/utils/getSupportedGPUCompressedTextureFormats.js');
var GpuMipmapGenerator = require('./renderers/gpu/texture/utils/GpuMipmapGenerator.js');
var WebGPURenderer = require('./renderers/gpu/WebGPURenderer.js');
var BackgroundSystem = require('./renderers/shared/background/BackgroundSystem.js');
var BlendModePipe = require('./renderers/shared/blendModes/BlendModePipe.js');
var Buffer = require('./renderers/shared/buffer/Buffer.js');
var BufferResource = require('./renderers/shared/buffer/BufferResource.js');
var _const$3 = require('./renderers/shared/buffer/const.js');
var fastCopy = require('./renderers/shared/buffer/utils/fastCopy.js');
var ExtractSystem = require('./renderers/shared/extract/ExtractSystem.js');
var GenerateTextureSystem = require('./renderers/shared/extract/GenerateTextureSystem.js');
var _const$4 = require('./renderers/shared/geometry/const.js');
var Geometry = require('./renderers/shared/geometry/Geometry.js');
var buildUvs = require('./renderers/shared/geometry/utils/buildUvs.js');
var ensureIsBuffer = require('./renderers/shared/geometry/utils/ensureIsBuffer.js');
var getAttributeInfoFromFormat = require('./renderers/shared/geometry/utils/getAttributeInfoFromFormat.js');
var getGeometryBounds = require('./renderers/shared/geometry/utils/getGeometryBounds.js');
var transformVertices = require('./renderers/shared/geometry/utils/transformVertices.js');
require('./renderers/shared/instructions/Instruction.js');
var InstructionSet = require('./renderers/shared/instructions/InstructionSet.js');
require('./renderers/shared/instructions/RenderPipe.js');
require('./renderers/shared/Renderable.js');
var GlobalUniformSystem = require('./renderers/shared/renderTarget/GlobalUniformSystem.js');
var isRenderingToScreen = require('./renderers/shared/renderTarget/isRenderingToScreen.js');
var RenderTarget = require('./renderers/shared/renderTarget/RenderTarget.js');
var RenderTargetSystem = require('./renderers/shared/renderTarget/RenderTargetSystem.js');
var viewportFromFrame = require('./renderers/shared/renderTarget/viewportFromFrame.js');
var SchedulerSystem = require('./renderers/shared/SchedulerSystem.js');
var _const$5 = require('./renderers/shared/shader/const.js');
var Shader = require('./renderers/shared/shader/Shader.js');
require('./renderers/shared/shader/ShaderSystem.js');
var types = require('./renderers/shared/shader/types.js');
var UboSystem = require('./renderers/shared/shader/UboSystem.js');
var UniformGroup = require('./renderers/shared/shader/UniformGroup.js');
var createUboSyncFunction = require('./renderers/shared/shader/utils/createUboSyncFunction.js');
var getDefaultUniformValue = require('./renderers/shared/shader/utils/getDefaultUniformValue.js');
var uboSyncFunctions = require('./renderers/shared/shader/utils/uboSyncFunctions.js');
var uniformParsers = require('./renderers/shared/shader/utils/uniformParsers.js');
var HelloSystem = require('./renderers/shared/startup/HelloSystem.js');
var _const$6 = require('./renderers/shared/state/const.js');
var getAdjustedBlendModeBlend = require('./renderers/shared/state/getAdjustedBlendModeBlend.js');
var State = require('./renderers/shared/state/State.js');
var AbstractRenderer = require('./renderers/shared/system/AbstractRenderer.js');
var SharedSystems = require('./renderers/shared/system/SharedSystems.js');
require('./renderers/shared/system/System.js');
var SystemRunner = require('./renderers/shared/system/SystemRunner.js');
require('./renderers/shared/system/utils/typeUtils.js');
var CanvasPool = require('./renderers/shared/texture/CanvasPool.js');
var _const$7 = require('./renderers/shared/texture/const.js');
require('./renderers/shared/texture/GenerateCanvas.js');
var RenderableGCSystem = require('./renderers/shared/texture/RenderableGCSystem.js');
var RenderTexture = require('./renderers/shared/texture/RenderTexture.js');
var BufferImageSource = require('./renderers/shared/texture/sources/BufferImageSource.js');
var CanvasSource = require('./renderers/shared/texture/sources/CanvasSource.js');
var CompressedSource = require('./renderers/shared/texture/sources/CompressedSource.js');
var ImageSource = require('./renderers/shared/texture/sources/ImageSource.js');
var TextureSource = require('./renderers/shared/texture/sources/TextureSource.js');
var VideoSource = require('./renderers/shared/texture/sources/VideoSource.js');
var Texture = require('./renderers/shared/texture/Texture.js');
var TextureGCSystem = require('./renderers/shared/texture/TextureGCSystem.js');
var TextureMatrix = require('./renderers/shared/texture/TextureMatrix.js');
var TexturePool = require('./renderers/shared/texture/TexturePool.js');
var TextureStyle = require('./renderers/shared/texture/TextureStyle.js');
var TextureUvs = require('./renderers/shared/texture/TextureUvs.js');
var generateUID = require('./renderers/shared/texture/utils/generateUID.js');
var getCanvasTexture = require('./renderers/shared/texture/utils/getCanvasTexture.js');
var getSupportedCompressedTextureFormats = require('./renderers/shared/texture/utils/getSupportedCompressedTextureFormats.js');
var getSupportedTextureFormats = require('./renderers/shared/texture/utils/getSupportedTextureFormats.js');
var textureFrom = require('./renderers/shared/texture/utils/textureFrom.js');
var createIdFromString = require('./renderers/shared/utils/createIdFromString.js');
var parseFunctionBody = require('./renderers/shared/utils/parseFunctionBody.js');
require('./renderers/shared/view/View.js');
var ViewSystem = require('./renderers/shared/view/ViewSystem.js');
var types$1 = require('./renderers/types.js');

"use strict";

exports.GlBatchAdaptor = GlBatchAdaptor.GlBatchAdaptor;
exports.checkMaxIfStatementsInShader = checkMaxIfStatementsInShader.checkMaxIfStatementsInShader;
exports.getMaxTexturesPerBatch = maxRecommendedTextures.getMaxTexturesPerBatch;
exports.generateGPULayout = generateGPULayout.generateGPULayout;
exports.generateLayout = generateLayout.generateLayout;
exports.getTextureBatchBindGroup = getTextureBatchBindGroup.getTextureBatchBindGroup;
exports.GpuBatchAdaptor = GpuBatchAdaptor.GpuBatchAdaptor;
exports.Batch = Batcher.Batch;
exports.Batcher = Batcher.Batcher;
exports.BatcherPipe = BatcherPipe.BatcherPipe;
exports.BatchGeometry = BatchGeometry.BatchGeometry;
exports.BatchTextureArray = BatchTextureArray.BatchTextureArray;
exports.DefaultBatcher = DefaultBatcher.DefaultBatcher;
exports.DefaultShader = DefaultShader.DefaultShader;
exports.compileHighShaderGlProgram = compileHighShaderToProgram.compileHighShaderGlProgram;
exports.compileHighShaderGpuProgram = compileHighShaderToProgram.compileHighShaderGpuProgram;
exports.compileHighShader = compileHighShader.compileHighShader;
exports.compileHighShaderGl = compileHighShader.compileHighShaderGl;
exports.addBits = addBits.addBits;
exports.compileHooks = compileHooks.compileHooks;
exports.findHooksRx = compileHooks.findHooksRx;
exports.compileInputs = compileInputs.compileInputs;
exports.compileOutputs = compileOutputs.compileOutputs;
exports.formatShader = formatShader.formatShader;
exports.injectBits = injectBits.injectBits;
exports.fragmentGPUTemplate = defaultProgramTemplate.fragmentGPUTemplate;
exports.fragmentGlTemplate = defaultProgramTemplate.fragmentGlTemplate;
exports.vertexGPUTemplate = defaultProgramTemplate.vertexGPUTemplate;
exports.vertexGlTemplate = defaultProgramTemplate.vertexGlTemplate;
exports.colorBit = colorBit.colorBit;
exports.colorBitGl = colorBit.colorBitGl;
exports.generateTextureBatchBit = generateTextureBatchBit.generateTextureBatchBit;
exports.generateTextureBatchBitGl = generateTextureBatchBit.generateTextureBatchBitGl;
exports.globalUniformsBit = globalUniformsBit.globalUniformsBit;
exports.globalUniformsBitGl = globalUniformsBit.globalUniformsBitGl;
exports.globalUniformsUBOBitGl = globalUniformsBit.globalUniformsUBOBitGl;
exports.localUniformBit = localUniformBit.localUniformBit;
exports.localUniformBitGl = localUniformBit.localUniformBitGl;
exports.localUniformBitGroup2 = localUniformBit.localUniformBitGroup2;
exports.roundPixelsBit = roundPixelsBit.roundPixelsBit;
exports.roundPixelsBitGl = roundPixelsBit.roundPixelsBitGl;
exports.textureBit = textureBit.textureBit;
exports.textureBitGl = textureBit.textureBitGl;
exports.AlphaMask = AlphaMask.AlphaMask;
exports.AlphaMaskPipe = AlphaMaskPipe.AlphaMaskPipe;
exports.ColorMask = ColorMask.ColorMask;
exports.ColorMaskPipe = ColorMaskPipe.ColorMaskPipe;
exports.MaskEffectManager = MaskEffectManager.MaskEffectManager;
exports.MaskEffectManagerClass = MaskEffectManager.MaskEffectManagerClass;
exports.ScissorMask = ScissorMask.ScissorMask;
exports.StencilMask = StencilMask.StencilMask;
exports.StencilMaskPipe = StencilMaskPipe.StencilMaskPipe;
exports.addMaskBounds = addMaskBounds.addMaskBounds;
exports.addMaskLocalBounds = addMaskLocalBounds.addMaskLocalBounds;
exports.getMatrixRelativeToParent = addMaskLocalBounds.getMatrixRelativeToParent;
exports.autoDetectRenderer = autoDetectRenderer.autoDetectRenderer;
exports.BUFFER_TYPE = _const.BUFFER_TYPE;
exports.GlBuffer = GlBuffer.GlBuffer;
exports.GlBufferSystem = GlBufferSystem.GlBufferSystem;
exports.CLEAR = _const$1.CLEAR;
exports.GlContextSystem = GlContextSystem.GlContextSystem;
exports.GlGeometrySystem = GlGeometrySystem.GlGeometrySystem;
exports.getGlTypeFromFormat = getGlTypeFromFormat.getGlTypeFromFormat;
exports.GlBackBufferSystem = GlBackBufferSystem.GlBackBufferSystem;
exports.GlColorMaskSystem = GlColorMaskSystem.GlColorMaskSystem;
exports.GlEncoderSystem = GlEncoderSystem.GlEncoderSystem;
exports.GlRenderTarget = GlRenderTarget.GlRenderTarget;
exports.GlStencilSystem = GlStencilSystem.GlStencilSystem;
exports.GlUboSystem = GlUboSystem.GlUboSystem;
exports.GlRenderTargetAdaptor = GlRenderTargetAdaptor.GlRenderTargetAdaptor;
exports.GlRenderTargetSystem = GlRenderTargetSystem.GlRenderTargetSystem;
exports.generateShaderSyncCode = GenerateShaderSyncCode.generateShaderSyncCode;
exports.getBatchSamplersUniformGroup = getBatchSamplersUniformGroup.getBatchSamplersUniformGroup;
exports.GlProgram = GlProgram.GlProgram;
exports.GlProgramData = GlProgramData.GlProgramData;
exports.IGLUniformData = GlProgramData.IGLUniformData;
exports.GlShaderSystem = GlShaderSystem.GlShaderSystem;
exports.GlUniformGroupSystem = GlUniformGroupSystem.GlUniformGroupSystem;
exports.migrateFragmentFromV7toV8 = migrateFragmentFromV7toV8.migrateFragmentFromV7toV8;
exports.compileShader = compileShader.compileShader;
exports.defaultValue = defaultValue.defaultValue;
exports.ensureAttributes = ensureAttributes.ensureAttributes;
exports.extractAttributesFromGlProgram = extractAttributesFromGlProgram.extractAttributesFromGlProgram;
exports.generateProgram = generateProgram.generateProgram;
exports.getMaxFragmentPrecision = getMaxFragmentPrecision.getMaxFragmentPrecision;
exports.getTestContext = getTestContext.getTestContext;
exports.getUboData = getUboData.getUboData;
exports.getUniformData = getUniformData.getUniformData;
exports.logProgramError = logProgramError.logProgramError;
exports.mapSize = mapSize.mapSize;
exports.mapGlToVertexFormat = mapType.mapGlToVertexFormat;
exports.mapType = mapType.mapType;
exports.addProgramDefines = addProgramDefines.addProgramDefines;
exports.ensurePrecision = ensurePrecision.ensurePrecision;
exports.insertVersion = insertVersion.insertVersion;
exports.setProgramName = setProgramName.setProgramName;
exports.stripVersion = stripVersion.stripVersion;
exports.WGSL_TO_STD40_SIZE = createUboElementsSTD40.WGSL_TO_STD40_SIZE;
exports.createUboElementsSTD40 = createUboElementsSTD40.createUboElementsSTD40;
exports.createUboSyncFunctionSTD40 = createUboSyncSTD40.createUboSyncFunctionSTD40;
exports.generateArraySyncSTD40 = generateArraySyncSTD40.generateArraySyncSTD40;
exports.generateUniformsSync = generateUniformsSync.generateUniformsSync;
exports.UNIFORM_TO_ARRAY_SETTERS = generateUniformsSyncTypes.UNIFORM_TO_ARRAY_SETTERS;
exports.UNIFORM_TO_SINGLE_SETTERS = generateUniformsSyncTypes.UNIFORM_TO_SINGLE_SETTERS;
exports.GlStateSystem = GlStateSystem.GlStateSystem;
exports.mapWebGLBlendModesToPixi = mapWebGLBlendModesToPixi.mapWebGLBlendModesToPixi;
exports.GL_FORMATS = _const$2.GL_FORMATS;
exports.GL_TARGETS = _const$2.GL_TARGETS;
exports.GL_TYPES = _const$2.GL_TYPES;
exports.GL_WRAP_MODES = _const$2.GL_WRAP_MODES;
exports.GlTexture = GlTexture.GlTexture;
exports.GlTextureSystem = GlTextureSystem.GlTextureSystem;
exports.glUploadBufferImageResource = glUploadBufferImageResource.glUploadBufferImageResource;
exports.glUploadCompressedTextureResource = glUploadCompressedTextureResource.glUploadCompressedTextureResource;
exports.glUploadImageResource = glUploadImageResource.glUploadImageResource;
exports.glUploadVideoResource = glUploadVideoResource.glUploadVideoResource;
exports.applyStyleParams = applyStyleParams.applyStyleParams;
exports.getSupportedGlCompressedTextureFormats = getSupportedGlCompressedTextureFormats.getSupportedGlCompressedTextureFormats;
exports.mapFormatToGlFormat = mapFormatToGlFormat.mapFormatToGlFormat;
exports.mapFormatToGlInternalFormat = mapFormatToGlInternalFormat.mapFormatToGlInternalFormat;
exports.mapFormatToGlType = mapFormatToGlType.mapFormatToGlType;
exports.compareModeToGlCompare = pixiToGlMaps.compareModeToGlCompare;
exports.mipmapScaleModeToGlFilter = pixiToGlMaps.mipmapScaleModeToGlFilter;
exports.scaleModeToGlFilter = pixiToGlMaps.scaleModeToGlFilter;
exports.wrapModeToGlAddress = pixiToGlMaps.wrapModeToGlAddress;
exports.unpremultiplyAlpha = unpremultiplyAlpha.unpremultiplyAlpha;
exports.WebGLRenderer = WebGLRenderer.WebGLRenderer;
exports.BindGroupSystem = BindGroupSystem.BindGroupSystem;
exports.GpuBufferSystem = GpuBufferSystem.GpuBufferSystem;
exports.GpuReadBuffer = GpuReadBuffer.GpuReadBuffer;
exports.UboBatch = UboBatch.UboBatch;
exports.GpuColorMaskSystem = GpuColorMaskSystem.GpuColorMaskSystem;
exports.GpuDeviceSystem = GpuDeviceSystem.GpuDeviceSystem;
exports.GpuEncoderSystem = GpuEncoderSystem.GpuEncoderSystem;
exports.GpuStencilSystem = GpuStencilSystem.GpuStencilSystem;
exports.GpuUboSystem = GpuUboSystem.GpuUboSystem;
exports.GpuUniformBatchPipe = GpuUniformBatchPipe.GpuUniformBatchPipe;
exports.PipelineSystem = PipelineSystem.PipelineSystem;
exports.calculateProjection = calculateProjection.calculateProjection;
exports.GpuRenderTarget = GpuRenderTarget.GpuRenderTarget;
exports.GpuRenderTargetAdaptor = GpuRenderTargetAdaptor.GpuRenderTargetAdaptor;
exports.GpuRenderTargetSystem = GpuRenderTargetSystem.GpuRenderTargetSystem;
exports.BindGroup = BindGroup.BindGroup;
exports.GpuProgram = GpuProgram.GpuProgram;
exports.GpuShaderSystem = GpuShaderSystem.GpuShaderSystem;
exports.WGSL_ALIGN_SIZE_DATA = createUboElementsWGSL.WGSL_ALIGN_SIZE_DATA;
exports.createUboElementsWGSL = createUboElementsWGSL.createUboElementsWGSL;
exports.createUboSyncFunctionWGSL = createUboSyncFunctionWGSL.createUboSyncFunctionWGSL;
exports.extractAttributesFromGpuProgram = extractAttributesFromGpuProgram.extractAttributesFromGpuProgram;
exports.extractStructAndGroups = extractStructAndGroups.extractStructAndGroups;
exports.generateArraySyncWGSL = generateArraySyncWGSL.generateArraySyncWGSL;
exports.generateGpuLayoutGroups = generateGpuLayoutGroups.generateGpuLayoutGroups;
exports.generateLayoutHash = generateLayoutHash.generateLayoutHash;
exports.removeStructAndGroupDuplicates = removeStructAndGroupDuplicates.removeStructAndGroupDuplicates;
exports.GpuBlendModesToPixi = GpuBlendModesToPixi.GpuBlendModesToPixi;
exports.GpuStateSystem = GpuStateSystem.GpuStateSystem;
exports.GpuStencilModesToPixi = GpuStencilModesToPixi.GpuStencilModesToPixi;
exports.GpuTextureSystem = GpuTextureSystem.GpuTextureSystem;
exports.gpuUploadBufferImageResource = gpuUploadBufferImageResource.gpuUploadBufferImageResource;
exports.blockDataMap = gpuUploadCompressedTextureResource.blockDataMap;
exports.gpuUploadCompressedTextureResource = gpuUploadCompressedTextureResource.gpuUploadCompressedTextureResource;
exports.gpuUploadImageResource = gpuUploadImageSource.gpuUploadImageResource;
exports.gpuUploadVideoResource = gpuUploadVideoSource.gpuUploadVideoResource;
exports.getSupportedGPUCompressedTextureFormats = getSupportedGPUCompressedTextureFormats.getSupportedGPUCompressedTextureFormats;
exports.GpuMipmapGenerator = GpuMipmapGenerator.GpuMipmapGenerator;
exports.WebGPURenderer = WebGPURenderer.WebGPURenderer;
exports.BackgroundSystem = BackgroundSystem.BackgroundSystem;
exports.BlendModePipe = BlendModePipe.BlendModePipe;
exports.Buffer = Buffer.Buffer;
exports.BufferResource = BufferResource.BufferResource;
exports.BufferUsage = _const$3.BufferUsage;
exports.fastCopy = fastCopy.fastCopy;
exports.ExtractSystem = ExtractSystem.ExtractSystem;
exports.GenerateTextureSystem = GenerateTextureSystem.GenerateTextureSystem;
exports.DRAW_MODES = _const$4.DRAW_MODES;
exports.Geometry = Geometry.Geometry;
exports.buildSimpleUvs = buildUvs.buildSimpleUvs;
exports.buildUvs = buildUvs.buildUvs;
exports.ensureIsBuffer = ensureIsBuffer.ensureIsBuffer;
exports.getAttributeInfoFromFormat = getAttributeInfoFromFormat.getAttributeInfoFromFormat;
exports.getGeometryBounds = getGeometryBounds.getGeometryBounds;
exports.transformVertices = transformVertices.transformVertices;
exports.InstructionSet = InstructionSet.InstructionSet;
exports.GlobalUniformSystem = GlobalUniformSystem.GlobalUniformSystem;
exports.isRenderingToScreen = isRenderingToScreen.isRenderingToScreen;
exports.RenderTarget = RenderTarget.RenderTarget;
exports.RenderTargetSystem = RenderTargetSystem.RenderTargetSystem;
exports.viewportFromFrame = viewportFromFrame.viewportFromFrame;
exports.SchedulerSystem = SchedulerSystem.SchedulerSystem;
exports.ShaderStage = _const$5.ShaderStage;
exports.Shader = Shader.Shader;
exports.UNIFORM_TYPES_MAP = types.UNIFORM_TYPES_MAP;
exports.UNIFORM_TYPES_VALUES = types.UNIFORM_TYPES_VALUES;
exports.UboSystem = UboSystem.UboSystem;
exports.UniformGroup = UniformGroup.UniformGroup;
exports.createUboSyncFunction = createUboSyncFunction.createUboSyncFunction;
exports.getDefaultUniformValue = getDefaultUniformValue.getDefaultUniformValue;
exports.uboSyncFunctionsSTD40 = uboSyncFunctions.uboSyncFunctionsSTD40;
exports.uboSyncFunctionsWGSL = uboSyncFunctions.uboSyncFunctionsWGSL;
exports.uniformParsers = uniformParsers.uniformParsers;
exports.HelloSystem = HelloSystem.HelloSystem;
exports.BLEND_TO_NPM = _const$6.BLEND_TO_NPM;
exports.STENCIL_MODES = _const$6.STENCIL_MODES;
exports.getAdjustedBlendModeBlend = getAdjustedBlendModeBlend.getAdjustedBlendModeBlend;
exports.State = State.State;
exports.AbstractRenderer = AbstractRenderer.AbstractRenderer;
exports.SharedRenderPipes = SharedSystems.SharedRenderPipes;
exports.SharedSystems = SharedSystems.SharedSystems;
exports.SystemRunner = SystemRunner.SystemRunner;
exports.CanvasPool = CanvasPool.CanvasPool;
exports.CanvasPoolClass = CanvasPool.CanvasPoolClass;
exports.DEPRECATED_SCALE_MODES = _const$7.DEPRECATED_SCALE_MODES;
exports.DEPRECATED_WRAP_MODES = _const$7.DEPRECATED_WRAP_MODES;
exports.MSAA_QUALITY = _const$7.MSAA_QUALITY;
exports.SCALE_MODES = _const$7.SCALE_MODES;
exports.WRAP_MODES = _const$7.WRAP_MODES;
exports.RenderableGCSystem = RenderableGCSystem.RenderableGCSystem;
exports.RenderTexture = RenderTexture.RenderTexture;
exports.BufferImageSource = BufferImageSource.BufferImageSource;
exports.CanvasSource = CanvasSource.CanvasSource;
exports.CompressedSource = CompressedSource.CompressedSource;
exports.ImageSource = ImageSource.ImageSource;
exports.TextureSource = TextureSource.TextureSource;
exports.VideoSource = VideoSource.VideoSource;
exports.Texture = Texture.Texture;
exports.TextureGCSystem = TextureGCSystem.TextureGCSystem;
exports.TextureMatrix = TextureMatrix.TextureMatrix;
exports.TexturePool = TexturePool.TexturePool;
exports.TexturePoolClass = TexturePool.TexturePoolClass;
exports.TextureStyle = TextureStyle.TextureStyle;
exports.TextureUvs = TextureUvs.TextureUvs;
exports.generateUID = generateUID.generateUID;
exports.getCanvasTexture = getCanvasTexture.getCanvasTexture;
exports.hasCachedCanvasTexture = getCanvasTexture.hasCachedCanvasTexture;
exports.getSupportedCompressedTextureFormats = getSupportedCompressedTextureFormats.getSupportedCompressedTextureFormats;
exports.getSupportedTextureFormats = getSupportedTextureFormats.getSupportedTextureFormats;
exports.nonCompressedFormats = getSupportedTextureFormats.nonCompressedFormats;
exports.autoDetectSource = textureFrom.autoDetectSource;
exports.resourceToTexture = textureFrom.resourceToTexture;
exports.textureFrom = textureFrom.textureFrom;
exports.createIdFromString = createIdFromString.createIdFromString;
exports.parseFunctionBody = parseFunctionBody.parseFunctionBody;
exports.ViewSystem = ViewSystem.ViewSystem;
exports.RendererType = types$1.RendererType;
//# sourceMappingURL=index.js.map
