'use strict';

"use strict";
function mixHexColors(color1, color2, ratio) {
  const r1 = color1 >> 16 & 255;
  const g1 = color1 >> 8 & 255;
  const b1 = color1 & 255;
  const r2 = color2 >> 16 & 255;
  const g2 = color2 >> 8 & 255;
  const b2 = color2 & 255;
  const r = r1 + (r2 - r1) * ratio;
  const g = g1 + (g2 - g1) * ratio;
  const b = b1 + (b2 - b1) * ratio;
  return (r << 16) + (g << 8) + b;
}

exports.mixHexColors = mixHexColors;
//# sourceMappingURL=mixHexColors.js.map
