'use strict';

var definedProps = require('../container/utils/definedProps.js');
var Mesh = require('../mesh/shared/Mesh.js');
var PlaneGeometry = require('./PlaneGeometry.js');

"use strict";
class MeshPlane extends Mesh.Mesh {
  /**
   * @param options - Options to be applied to MeshPlane
   */
  constructor(options) {
    const { texture, verticesX, verticesY, ...rest } = options;
    const planeGeometry = new PlaneGeometry.PlaneGeometry(definedProps.definedProps({
      width: texture.width,
      height: texture.height,
      verticesX,
      verticesY
    }));
    super(definedProps.definedProps({ ...rest, geometry: planeGeometry, texture }));
    this.texture = texture;
    this.autoResize = true;
  }
  /**
   * Method used for overrides, to do something in case texture frame was changed.
   * Meshes based on plane can override it and change more details based on texture.
   */
  textureUpdated() {
    const geometry = this.geometry;
    const { width, height } = this.texture;
    if (this.autoResize && (geometry.width !== width || geometry.height !== height)) {
      geometry.width = width;
      geometry.height = height;
      geometry.build({});
    }
  }
  set texture(value) {
    this._texture?.off("update", this.textureUpdated, this);
    super.texture = value;
    value.on("update", this.textureUpdated, this);
    this.textureUpdated();
  }
  /** The texture of the MeshPlane */
  get texture() {
    return this._texture;
  }
  /**
   * Destroys this sprite renderable and optionally its texture.
   * @param options - Options parameter. A boolean will act as if all options
   *  have been set to that value
   * @param {boolean} [options.texture=false] - Should it destroy the current texture of the renderable as well
   * @param {boolean} [options.textureSource=false] - Should it destroy the textureSource of the renderable as well
   */
  destroy(options) {
    this.texture.off("update", this.textureUpdated, this);
    super.destroy(options);
  }
}

exports.MeshPlane = MeshPlane;
//# sourceMappingURL=MeshPlane.js.map
