import { Texture } from '../../rendering/renderers/shared/texture/Texture';
import { AbstractBitmapFont } from './AbstractBitmapFont';
import type { BitmapFontData } from './AbstractBitmapFont';
import type { BitmapFontInstallOptions } from './BitmapFontManager';
/**
 * Options for creating a BitmapFont.
 * @memberof text
 */
export interface BitmapFontOptions {
    data: BitmapFontData;
    textures: Texture[];
}
/**
 * A BitmapFont object represents a particular font face, size, and style.
 * @memberof text
 */
export declare class BitmapFont extends AbstractBitmapFont<BitmapFont> {
    /** the url of the font */
    url?: string;
    constructor(options: BitmapFontOptions, url?: string);
    /** Destroys the BitmapFont object. */
    destroy(): void;
    /**
     * Generates a bitmap-font for the given style and character set
     * @param options - Setup options for font generation.
     * @returns Font generated by style options.
     * @example
     * import { BitmapFont, BitmapText } from 'pixi.js';
     *
     * BitmapFont.install('TitleFont', {
     *     fontFamily: 'Arial',
     *     fontSize: 12,
     *     strokeThickness: 2,
     *     fill: 'purple',
     * });
     *
     * const title = new BitmapText({ text: 'This is the title', fontFamily: 'TitleFont' });
     */
    static install(options: BitmapFontInstallOptions): void;
    /**
     * Uninstalls a bitmap font from the cache.
     * @param {string} name - The name of the bitmap font to uninstall.
     */
    static uninstall(name: string): void;
}
