import { ExtensionType } from '../../../extensions/Extensions';
import { BatchableSprite } from '../../sprite/BatchableSprite';
import type { InstructionSet } from '../../../rendering/renderers/shared/instructions/InstructionSet';
import type { RenderPipe } from '../../../rendering/renderers/shared/instructions/RenderPipe';
import type { Texture } from '../../../rendering/renderers/shared/texture/Texture';
import type { Renderer } from '../../../rendering/renderers/types';
import type { Text } from '../Text';
export declare class CanvasTextPipe implements RenderPipe<Text> {
    /** @ignore */
    static extension: {
        readonly type: readonly [ExtensionType.WebGLPipes, ExtensionType.WebGPUPipes, ExtensionType.CanvasPipes];
        readonly name: "text";
    };
    private _renderer;
    private _gpuText;
    private readonly _destroyRenderableBound;
    constructor(renderer: Renderer);
    resolutionChange(): void;
    validateRenderable(text: Text): boolean;
    addRenderable(text: Text, instructionSet: InstructionSet): void;
    updateRenderable(text: Text): void;
    destroyRenderable(text: Text): void;
    private _destroyRenderableById;
    private _updateText;
    private _updateGpuText;
    private _getGpuText;
    initGpuText(text: Text): {
        texture: Texture<import("../../..").TextureSource<any>>;
        currentKey: string;
        batchableSprite: BatchableSprite;
    };
    destroy(): void;
}
