'use strict';

var uniformParsers = require('../../rendering/renderers/shared/shader/utils/uniformParsers.js');
var uniformSyncFunctions = require('./uniformSyncFunctions.js');

"use strict";
function generateUniformsSyncPolyfill(group, uniformData) {
  const functionMap = {};
  for (const i in group.uniformStructures) {
    if (!uniformData[i])
      continue;
    const uniform = group.uniformStructures[i];
    let parsed = false;
    for (let j = 0; j < uniformParsers.uniformParsers.length; j++) {
      const parser = uniformParsers.uniformParsers[j];
      if (uniform.type === parser.type && parser.test(uniform)) {
        functionMap[i] = uniformSyncFunctions.uniformParserFunctions[j];
        parsed = true;
        break;
      }
    }
    if (!parsed) {
      const templateType = uniform.size === 1 ? uniformSyncFunctions.uniformSingleParserFunctions : uniformSyncFunctions.uniformArrayParserFunctions;
      functionMap[i] = templateType[uniform.type];
    }
  }
  return (ud, uv, renderer) => {
    const gl = renderer.gl;
    for (const i in functionMap) {
      const v = uv[i];
      const cu = ud[i];
      const cv = ud[i].value;
      functionMap[i](i, cu, cv, v, ud, uv, gl);
    }
  };
}

exports.generateUniformsSyncPolyfill = generateUniformsSyncPolyfill;
//# sourceMappingURL=generateUniformsSyncPolyfill.js.map
