'use strict';

var detectVideoAlphaMode = require('./browser/detectVideoAlphaMode.js');
var isMobile = require('./browser/isMobile.js');
var isSafari = require('./browser/isSafari.js');
var isWebGLSupported = require('./browser/isWebGLSupported.js');
var isWebGPUSupported = require('./browser/isWebGPUSupported.js');
var unsafeEvalSupported = require('./browser/unsafeEvalSupported.js');
var getCanvasBoundingBox = require('./canvas/getCanvasBoundingBox.js');
var _const = require('./const.js');
var clean = require('./data/clean.js');
var removeItems = require('./data/removeItems.js');
var uid = require('./data/uid.js');
var updateQuadBounds = require('./data/updateQuadBounds.js');
var ViewableBuffer = require('./data/ViewableBuffer.js');
var globalHooks = require('./global/globalHooks.js');
var deprecation = require('./logging/deprecation.js');
var logDebugTexture = require('./logging/logDebugTexture.js');
var logScene = require('./logging/logScene.js');
var warn = require('./logging/warn.js');
var NOOP = require('./misc/NOOP.js');
var Transform = require('./misc/Transform.js');
var getResolutionOfUrl = require('./network/getResolutionOfUrl.js');
var path = require('./path.js');
var Pool = require('./pool/Pool.js');
var PoolGroup = require('./pool/PoolGroup.js');
var sayHello = require('./sayHello.js');
require('./types.js');
require('./utils.js');

"use strict";

exports.detectVideoAlphaMode = detectVideoAlphaMode.detectVideoAlphaMode;
exports.isMobile = isMobile.isMobile;
exports.isSafari = isSafari.isSafari;
exports.isWebGLSupported = isWebGLSupported.isWebGLSupported;
exports.isWebGPUSupported = isWebGPUSupported.isWebGPUSupported;
exports.unsafeEvalSupported = unsafeEvalSupported.unsafeEvalSupported;
exports.getCanvasBoundingBox = getCanvasBoundingBox.getCanvasBoundingBox;
exports.DATA_URI = _const.DATA_URI;
exports.VERSION = _const.VERSION;
exports.cleanArray = clean.cleanArray;
exports.cleanHash = clean.cleanHash;
exports.removeItems = removeItems.removeItems;
exports.resetUids = uid.resetUids;
exports.uid = uid.uid;
exports.updateQuadBounds = updateQuadBounds.updateQuadBounds;
exports.ViewableBuffer = ViewableBuffer.ViewableBuffer;
exports.ApplicationInitHook = globalHooks.ApplicationInitHook;
exports.RendererInitHook = globalHooks.RendererInitHook;
exports.deprecation = deprecation.deprecation;
exports.v8_0_0 = deprecation.v8_0_0;
exports.v8_3_4 = deprecation.v8_3_4;
exports.logDebugTexture = logDebugTexture.logDebugTexture;
exports.logRenderGroupScene = logScene.logRenderGroupScene;
exports.logScene = logScene.logScene;
exports.warn = warn.warn;
exports.NOOP = NOOP.NOOP;
exports.Transform = Transform.Transform;
exports.getResolutionOfUrl = getResolutionOfUrl.getResolutionOfUrl;
exports.path = path.path;
exports.Pool = Pool.Pool;
exports.BigPool = PoolGroup.BigPool;
exports.PoolGroupClass = PoolGroup.PoolGroupClass;
exports.sayHello = sayHello.sayHello;
//# sourceMappingURL=index.js.map
