'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var Assets = require('./Assets.js');
require('./AssetExtension.js');
require('./utils/index.js');
require('./cache/index.js');
require('./loader/index.js');
require('./resolver/index.js');
require('./detections/index.js');
var convertToList = require('./utils/convertToList.js');
var createStringVariations = require('./utils/createStringVariations.js');
var isSingleItem = require('./utils/isSingleItem.js');
var Cache = require('./cache/Cache.js');
var cacheTextureArray = require('./cache/parsers/cacheTextureArray.js');
var LoaderParser = require('./loader/parsers/LoaderParser.js');
var loadJson = require('./loader/parsers/loadJson.js');
var loadTxt = require('./loader/parsers/loadTxt.js');
var loadWebFont = require('./loader/parsers/loadWebFont.js');
var loadSVG = require('./loader/parsers/textures/loadSVG.js');
var loadTextures = require('./loader/parsers/textures/loadTextures.js');
var checkExtension = require('./loader/parsers/textures/utils/checkExtension.js');
var createTexture = require('./loader/parsers/textures/utils/createTexture.js');
var resolveTextureUrl = require('./resolver/parsers/resolveTextureUrl.js');
var detectAvif = require('./detections/parsers/detectAvif.js');
var detectWebp = require('./detections/parsers/detectWebp.js');
var detectDefaults = require('./detections/parsers/detectDefaults.js');



exports.Assets = Assets.Assets;
exports.AssetsClass = Assets.AssetsClass;
exports.convertToList = convertToList.convertToList;
exports.createStringVariations = createStringVariations.createStringVariations;
exports.isSingleItem = isSingleItem.isSingleItem;
exports.Cache = Cache.Cache;
exports.cacheTextureArray = cacheTextureArray.cacheTextureArray;
exports.LoaderParserPriority = LoaderParser.LoaderParserPriority;
exports.loadJson = loadJson.loadJson;
exports.loadTxt = loadTxt.loadTxt;
exports.getFontFamilyName = loadWebFont.getFontFamilyName;
exports.loadWebFont = loadWebFont.loadWebFont;
exports.loadSVG = loadSVG.loadSVG;
exports.loadImageBitmap = loadTextures.loadImageBitmap;
exports.loadTextures = loadTextures.loadTextures;
exports.checkExtension = checkExtension.checkExtension;
exports.createTexture = createTexture.createTexture;
exports.resolveTextureUrl = resolveTextureUrl.resolveTextureUrl;
exports.detectAvif = detectAvif.detectAvif;
exports.detectWebp = detectWebp.detectWebp;
exports.detectDefaults = detectDefaults.detectDefaults;
//# sourceMappingURL=index.js.map
